#pragma once
//ϵͳ
#ifdef WIN32
#include "pch.h"
#endif

#include "vnhts.h"
#include "pybind11/pybind11.h"
#include "DFITCSECTraderApi.h"

using namespace pybind11;
using namespace std;

//

#define ONFRONTCONNECTED 0
#define ONFRONTDISCONNECTED 1
#define ONRTNNOTICE 2
#define ONRSPERROR 3
#define ONRSPSTOCKUSERLOGIN 4
#define ONRSPSTOCKUSERLOGOUT 5
#define ONRSPSTOCKUSERPASSWORDUPDATE 6
#define ONRSPSTOCKENTRUSTORDER 7
#define ONRSPSTOCKWITHDRAWORDER 8
#define ONRSPSTOCKQRYENTRUSTORDER 9
#define ONRSPSTOCKQRYREALTIMETRADE 10
#define ONRSPSTOCKQRYSERIALTRADE 11
#define ONRSPSTOCKQRYPOSITION 12
#define ONRSPSTOCKQRYCAPITALACCOUNTINFO 13
#define ONRSPSTOCKQRYACCOUNTINFO 14
#define ONRSPSTOCKQRYSHAREHOLDERINFO 15
#define ONRSPSTOCKTRANSFERFUNDS 16
#define ONRSPSTOCKENTRUSTBATCHORDER 17
#define ONRSPSTOCKWITHDRAWBATCHORDER 18
#define ONRSPSTOCKCALCABLEENTRUSTQTY 19
#define ONRSPSTOCKCALCABLEPURCHASEETFQTY 20
#define ONRSPSTOCKQRYFREEZEFUNDSDETAIL 21
#define ONRSPSTOCKQRYFREEZESTOCKDETAIL 22
#define ONRSPSTOCKQRYTRANSFERSTOCKDETAIL 23
#define ONRSPSTOCKQRYTRANSFERFUNDSDETAIL 24
#define ONRSPSTOCKQRYSTOCKINFO 25
#define ONRSPSTOCKQRYSTOCKSTATICINFO 26
#define ONRSPSTOCKQRYTRADETIME 27
#define ONSTOCKENTRUSTORDERRTN 28
#define ONSTOCKTRADERTN 29
#define ONSTOCKWITHDRAWORDERRTN 30
#define ONRSPSOPUSERLOGIN 31
#define ONRSPSOPUSERLOGOUT 32
#define ONRSPSOPUSERPASSWORDUPDATE 33
#define ONRSPSOPENTRUSTORDER 34
#define ONRSPSOPQUOTEENTRUSTORDER 35
#define ONRSPSOPGROUPSPLIT 36
#define ONRSPSOPGROUPEXECTUEORDER 37
#define ONRSPSOPQRYGROUPPOSITION 38
#define ONRSPSOPLOCKOUNLOCKSTOCK 39
#define ONRSPSOPWITHDRAWORDER 40
#define ONRSPSOPQRYENTRUSTORDER 41
#define ONRSPSOPQRYSERIALTRADE 42
#define ONRSPSOPQRYPOSITION 43
#define ONRSPSOPQRYCOLLATERALPOSITION 44
#define ONRSPSOPQRYCAPITALACCOUNTINFO 45
#define ONRSPSOPQRYACCOUNTINFO 46
#define ONRSPSOPQRYSHAREHOLDERINFO 47
#define ONRSPSOPCALCABLEENTRUSTQTY 48
#define ONRSPSOPQRYABLELOCKSTOCK 49
#define ONRSPSOPQRYCONTACTINFO 50
#define ONRSPSOPEXECTUEORDER 51
#define ONRSPSOPQRYEXECASSIINFO 52
#define ONRSPSOPQRYTRADETIME 53
#define ONRSPSOPQRYEXCHANGEINFO 54
#define ONRSPSOPQRYCOMMISSION 55
#define ONRSPSOPQRYDEPOSIT 56
#define ONRSPSOPQRYCONTRACTOBJECTINFO 57
#define ONSOPENTRUSTORDERRTN 58
#define ONSOPTRADERTN 59
#define ONSOPWITHDRAWORDERRTN 60
#define ONSOPQUOTEENTRUSTORDERRTN 61
#define ONRSPSOPCAPITALTRANINOUT 62
#define ONRSPSOPCAPITALDISTRIBUTIONRATIO 63
#define ONRSPSOPFUNDTRANSBETWEENNODES 64
#define ONRSPSOPMODCAPITALDISTRIBUTIONRATIO 65
#define ONRSPFASLUSERLOGIN 66
#define ONRSPFASLUSERLOGOUT 67
#define ONRSPFASLQRYABLEFININFO 68
#define ONRSPFASLQRYABLESLOINFO 69
#define ONRSPFASLTRANSFERCOLLATERAL 70
#define ONRSPFASLDIRECTREPAYMENT 71
#define ONRSPFASLREPAYSTOCKTRANSFER 72
#define ONRSPFASLENTRUSTCRDTORDER 73
#define ONRSPFASLENTRUSTORDER 74
#define ONRSPFASLCALCABLEENTRUSTCRDTQTY 75
#define ONRSPFASLQRYCRDTFUNDS 76
#define ONRSPFASLQRYCRDTCONTRACT 77
#define ONRSPFASLQRYCRDTCONCHANGEINFO 78
#define ONRSPFASLTRANSFERFUNDS 79
#define ONRSPFASLTRANSFERSTOCK 80
#define ONRSPFASLQRYACCOUNTINFO 81
#define ONRSPFASLQRYCAPITALACCOUNTINFO 82
#define ONRSPFASLQRYSHAREHOLDERINFO 83
#define ONRSPFASLQRYPOSITION 84
#define ONRSPFASLQRYENTRUSTORDER 85
#define ONRSPFASLQRYSERIALTRADE 86
#define ONRSPFASLQRYREALTIMETRADE 87
#define ONRSPFASLQRYFREEZEFUNDSDETAIL 88
#define ONRSPFASLQRYFREEZESTOCKDETAIL 89
#define ONRSPFASLQRYTRANSFERFUNDSDETAIL 90
#define ONRSPFASLWITHDRAWORDER 91
#define ONRSPFASLQRYSYSTEMTIME 92
#define ONRSPFASLQRYTRANSFERREDCONTRACT 93
#define ONRSPFASLDESIRABLEFUNDSOUT 94
#define ONRSPFASLQRYGUARANTEEDCONTRACT 95
#define ONRSPFASLQRYUNDERLYINGCONTRACT 96
#define ONRSPFASLQRYCENTREFUNDAVLINFO 97
#define ONRSPFASLQRYPLACINGINTERESTSINFO 98
#define ONRSPFASLUSERPASSWORDUPDATE 99
#define ONFASLENTRUSTORDERRTN 100
#define ONFASLTRADERTN 101
#define ONFASLWITHDRAWORDERRTN 102
#define ONFASLLIABILITIESRTN 103
#define ONRSPSTOCKETFENTRUSTORDER 104
#define ONRSPSTOCKETFBASKETORDER 105
#define ONRSPSTOCKBONDREPURCHASEORDER 106
#define ONRSPSTOCKBONDINOUTSTOCKORDER 107
#define ONRSPSTOCKISSUEBUSINESSORDER 108
#define ONRSPSTOCKLOFENTRUSTORDER 109
#define ONRSPSTOCKAFTERHOURSPRICEORDER 110
#define ONRSPSTOCKNONTRADINGBUSINESSORDER 111
#define ONRSPSTOCKSHMUTUALFUNDORDER 112
#define ONRSPSTOCKCALCABLEPURCHASEETFBASKETQTY 113
#define ONRSPSTOCKCALCABLEBONDREPURCHASEQTY 114
#define ONRSPSTOCKCALCABLEISSUEBUSINESSQTY 115
#define ONRSPSTOCKCALCABLEPURCHASELOFQTY 116
#define ONRSPSTOCKCALCABLEAFTERHOURSPRICEQTY 117
#define ONRSPSTOCKCALCABLENONTRADINGBUSINESSQTY 118
#define ONRSPSTOCKCALCABLESHMUTUALFUNDQTY 119


///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ

class TdApi : public DFITCSECTraderSpi
{
private:
	DFITCSECTraderApi* api;            //API
	thread task_thread;                    //ָ߳루pythonݣ
	TaskQueue task_queue;                //
	bool active = false;                //״̬
public:
	TdApi()
	{
	};

	~TdApi()
	{
		if (this->active)
		{
			this->exit();
		}
	};
	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

	/**
	 * SEC-Ӧ
	 */
	virtual void OnFrontConnected();
	/**
	 * SEC-ӲӦ
	 */
	virtual void OnFrontDisconnected(int nReason);
	/**
	 * SEC-Ϣ֪ͨ
	 */
	virtual void OnRtnNotice(DFITCSECRspNoticeField *pNotice);
	/**
	* ERR-Ӧ
	* @param pRspInfo:ָǿգشϢṹַ
	*/
	virtual void OnRspError(DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-¼Ӧ
	* @param pData:ָǿ,û¼ӦϢṹĵַ,¼ɹ
	* @param pRspInfo:ָǿգشϢṹĵַ¼ʧ
	*/
	virtual void OnRspStockUserLogin(DFITCSECRspUserLoginField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-ǳӦ
	* @param pData:ָǿ,ûǳӦϢṹĵַ,ǳɹ
	* @param pRspInfo:ָǿգشϢṹĵַǳʧ
	*/
	virtual void OnRspStockUserLogout(DFITCSECRspUserLogoutField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-Ӧ
	* @param pData:ָǿ,ûӦϢṹĵַ,ɹ
	* @param pRspInfo:ָǿգشϢṹĵַʧ
	*/
	virtual void OnRspStockUserPasswordUpdate(DFITCSECRspPasswordUpdateField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-ίбӦ
	* @param pData:ָǿ,ûίбӦϢṹĵַ,ɹ
	* @param pRspInfo:ָǿգشϢṹĵַίбʧ
	*/
	virtual void OnRspStockEntrustOrder(DFITCStockRspEntrustOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-ίгӦ
	* @param pData:ָǿ,ûίгӦϢṹĵַ,ɹ
	* @param pRspInfo:ָǿգشϢṹĵַίгʧ
	*/
	virtual void OnRspStockWithdrawOrder(DFITCSECRspWithdrawOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-ίвѯӦ
	* @param pData:ָǿ,ûίвѯӦϢṹĵַ,ѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַίвѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQryEntrustOrder(DFITCStockRspQryEntrustOrderField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-ʵʱɽѯӦ
	* @param pData:ָǿ,ûʵʱɽѯӦϢṹĵַ,ʵʱɽѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַʵʱɽѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQryRealTimeTrade(DFITCStockRspQryRealTimeTradeField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-ֱʳɽѯӦ
	* @param pData:ָǿ,ûֱʳɽѯӦϢṹĵַ,ֱʳɽѯɹ
	* @param pRspInfo:ָǿգشϢṹĵֱַʳɽѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQrySerialTrade(DFITCStockRspQrySerialTradeField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-ֲֲѯӦ
	* @param pData:ָǿ,ûֲֲѯӦϢṹĵַ,ֲֲѯɹ
	* @param pRspInfo:ָǿգشϢṹĵֲֲַѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQryPosition(DFITCStockRspQryPositionField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-ʽ˺ŲѯӦ
	* @param pData:ָǿ,ûʽ˺ŲѯӦϢṹĵַ,ʽ˺Ųѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַʽ˺Ųѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQryCapitalAccountInfo(DFITCStockRspQryCapitalAccountField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-˺ŲѯӦ
	* @param pData:ָǿ,û˺ŲѯӦϢṹĵַ,˺Ųѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַ˺Ųѯʧ
	*/
	virtual void OnRspStockQryAccountInfo(DFITCStockRspQryAccountField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-ɶŲѯӦ
	* @param pData:ָǿ,ûɶŲѯӦϢṹĵַ,ɶŲѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַɶŲѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQryShareholderInfo(DFITCStockRspQryShareholderField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-ʽӦ
	* @param pData:ָǿ,ûʽӦϢṹĵַ,ʽɹ
	* @param pRspInfo:ָǿգشϢṹĵַʽʧ
	*/
	virtual void OnRspStockTransferFunds(DFITCStockRspTransferFundsField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-ίӦ
	* @param pData:ָǿ,ûίӦϢṹĵַ,ίɹ
	* @param pRspInfo:ָǿգشϢṹĵַίʧ
	*/
	virtual void OnRspStockEntrustBatchOrder(DFITCStockRspEntrustBatchOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-Ӧ
	* @param pData:ָǿ,ûӦϢṹĵַ,ɹ
	* @param pRspInfo:ָǿգشϢṹĵַʧ
	*/
	virtual void OnRspStockWithdrawBatchOrder(DFITCStockRspWithdrawBatchOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-ίӦ
	* @param pData:ָǿ,ûίӦϢṹĵַ,ίɹ
	* @param pRspInfo:ָǿգشϢṹĵַίʧ
	*/
	virtual void OnRspStockCalcAbleEntrustQty(DFITCStockRspCalcAbleEntrustQtyField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-깺ETFӦ
	* @param pData:ָǿ,û깺ETFӦϢṹĵַ,깺ETFɹ
	* @param pRspInfo:ָǿգشϢṹĵַ깺ETFʧ
	*/
	virtual void OnRspStockCalcAblePurchaseETFQty(DFITCStockRspCalcAblePurchaseETFQtyField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-ʽϸѯӦ
	* @param pData:ָǿ,ûʽϸѯӦϢṹĵַ,ʽϸѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַʽϸѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQryFreezeFundsDetail(DFITCStockRspQryFreezeFundsDetailField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-֤ȯϸѯӦ
	* @param pData:ָǿ,û֤ȯϸѯӦϢṹĵַ,֤ȯϸѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַ֤ȯϸѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQryFreezeStockDetail(DFITCStockRspQryFreezeStockDetailField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-֤ȯϸѯӦ
	* @param pData:ָǿ,û֤ȯϸѯӦϢṹĵַ,֤ȯϸѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַ֤ȯϸѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQryTransferStockDetail(DFITCStockRspQryTransferStockDetailField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-ʽϸѯӦ
	* @param pData:ָǿ,ûʽϸѯӦϢṹĵַ,ʽϸѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַʽϸѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQryTransferFundsDetail(DFITCStockRspQryTransferFundsDetailField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-֤ȯϢѯӦ
	* @param pData:ָǿ,û֤ȯϢѯӦϢṹĵַ,֤ȯϢѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַ֤ȯϢѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQryStockInfo(DFITCStockRspQryStockField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-֤ȯ̬ϢѯӦ
	* @param pData:ָǿ,û֤ȯ̬ϢѯӦϢṹĵַ,֤ȯ̬Ϣѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַ֤ȯ̬Ϣѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockQryStockStaticInfo(DFITCStockRspQryStockStaticField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* STOCK-ʱѯӦ
	* @param pData:ָǿ,ûʱѯӦϢṹĵַ,ʱѯɹ
	* @param pRspInfo:ָǿգشϢṹĵַʱѯʧ
	*/
	virtual void OnRspStockQryTradeTime(DFITCStockRspQryTradeTimeField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* STOCK-ίлرӦ
	* @param pData:ίлرṹĵַ
	*/
	virtual void OnStockEntrustOrderRtn(DFITCStockEntrustOrderRtnField * pData);
	/**
	* STOCK-ɽرӦ
	* @param pData:سɽرṹĵַ
	*/
	virtual void OnStockTradeRtn(DFITCStockTradeRtnField * pData);
	/**
	* STOCK-رӦ
	* @param pData:سرṹĵַ
	*/
	virtual void OnStockWithdrawOrderRtn(DFITCStockWithdrawOrderRtnField * pData);

	/**
	* SOP-¼Ӧ
	* @param pRspUserLogin:ָǿ,û¼ӦϢṹַ,¼ɹ
	* @param pRspInfo:ָǿգشϢַ¼ʧ
	*/
	virtual void OnRspSOPUserLogin(DFITCSECRspUserLoginField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	 * SOP-ǳӦ
	 * @param pData:ָǿ,ûǳӦϢṹַ,ǳɹ
	 * @param pRspInfo:ָǿգشϢַǳʧ
	 */
	virtual void OnRspSOPUserLogout(DFITCSECRspUserLogoutField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* SOP-ûӦ
	* @param pData:ָǿ,ûӦϢṹַ,ûɹ
	* @param pRspInfo:ָǿգشϢַûʧ
	*/
	virtual void OnRspSOPUserPasswordUpdate(DFITCSECRspPasswordUpdateField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* SOP-Ӧ
	* @param pData:ָǿ,ûӦϢṹַ,ɹ
	* @param pRspInfo:ָǿգشϢַʧ
	*/
	virtual void OnRspSOPEntrustOrder(DFITCSOPRspEntrustOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* SOP-̱Ӧ
	* @param pData:ָǿ,ûίӦϢṹַ,̱ɹ
	* @param pRspInfo:ָǿգشϢַ̱ʧ
	*/
	virtual void OnRspSOPQuoteEntrustOrder(DFITCSOPRspQuoteEntrustOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* SOP-ϲίӦ
	* @param pData:ָǿ,ûϲίӦϢṹַ,ϲίɹ
	* @param pRspInfo:ָǿգشϢַϲίʧ
	*/
	virtual void OnRspSOPGroupSplit(DFITCSOPRspEntrustOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	 * SOP-ȨȨίӦ
	 * @param pData:ָǿ,ûȨȨίӦϢṹַ,ȨȨίɹ
	 * @return pRspInfo:ָǿգشϢַȨȨίʧܣerror.xml
	 */
	virtual void OnRspSOPGroupExectueOrder(DFITCSOPRspGroupExectueOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* SOP-ѯͻϳֲϸӦ
	* @param pData:ָǿ,ûѯͻϳֲϸӦṹַ,ѯͻϳֲϸɹ
	* @param pRspInfo:ָǿգشϢַѯͻϳֲϸʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryGroupPosition(DFITCSOPRspQryGroupPositionField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-֤ȯӦ
	* @param pData:ָǿ,û֤ȯӦϢṹַ,֤ȯɹ
	* @param pRspInfo:ָǿգشϢַ֤ȯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPLockOUnLockStock(DFITCSOPRspLockOUnLockStockField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-Ӧ
	* @param pData:ָǿ,ûӦϢṹַ,ɹ
	* @param pRspInfo:ָǿգشϢַʧ
	*/
	virtual void OnRspSOPWithdrawOrder(DFITCSECRspWithdrawOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* SOP-ίвѯӦ
	* @param pData:ָǿ,ûίвѯӦϢṹַ,ίвѯɹ
	* @param pRspInfo:ָǿգشϢַίвѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryEntrustOrder(DFITCSOPRspQryEntrustOrderField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ֱʳɽѯӦ
	* @param pData:ָǿ,ûֱʳɽѯӦϢṹַ,ֱʳɽѯɹ
	* @param pRspInfo:ָǿգشϢֱַʳɽѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQrySerialTrade(DFITCSOPRspQrySerialTradeField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ֲֲѯӦ
	* @param pData:ָǿ,ûֲֲѯӦϢṹַ,ֲֲѯɹ
	* @param pRspInfo:ָǿգشϢֲֲַѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryPosition(DFITCSOPRspQryPositionField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ͻֲֲѯӦ
	* @param pData:ָǿ,ûͻֲֲѯӦϢṹַ,ͻֲֲѯɹ
	* @param pRspInfo:ָǿգشϢַͻֲֲѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryCollateralPosition(DFITCSOPRspQryCollateralPositionField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ͻʽѯӦ
	* @param pData:ָǿ,ûͻʽѯӦϢṹַ,ͻͻʽѯɹ
	* @param pRspInfo:ָǿգشϢַͻͻʽѯʧ
	*/
	virtual void OnRspSOPQryCapitalAccountInfo(DFITCSOPRspQryCapitalAccountField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* SOP-ͻϢѯӦ
	* @param pData:ָǿ,ûͻϢѯӦϢṹַ,ͻͻϢѯɹ
	* @param pRspInfo:ָǿգشϢַͻͻϢѯʧ
	*/
	virtual void OnRspSOPQryAccountInfo(DFITCSOPRspQryAccountField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* SOP-ɶϢѯӦ
	* @param pData:ָǿ,ûɶϢѯӦϢṹַ,ͻɶϢѯɹ
	* @param pRspInfo:ָǿգشϢַͻɶϢѯʧ
	*/
	virtual void OnRspSOPQryShareholderInfo(DFITCSOPRspQryShareholderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* SOP-ίѯӦ
	* @param pData:ָǿ,ûίѯӦϢṹַ,ͻίѯɹ
	* @param pRspInfo:ָǿգشϢַͻίѯʧ
	*/
	virtual void OnRspSOPCalcAbleEntrustQty(DFITCSOPRspCalcAbleEntrustQtyField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* SOP-ͻ֤ȯѯӦ
	* @param pData:ָǿ,ûͻ֤ȯѯӦϢṹַ,ͻͻ֤ȯѯɹ
	* @param pRspInfo:ָǿգشϢַͻͻ֤ȯѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryAbleLockStock(DFITCSOPRspQryAbleLockStockField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ȨԼѯӦ
	* @param pData:ָǿ,ûȨԼѯӦϢṹַ,ͻȨԼѯɹ
	* @param pRspInfo:ָǿգشϢַͻȨԼѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryContactInfo(DFITCSOPRspQryContactField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ִίӦ
	* @param pData:ָǿ,ûִίӦϢṹַ,ͻִίɹ
	* @param pRspInfo:ָǿգشϢַͻִίʧ
	*/
	virtual void OnRspSOPExectueOrder(DFITCSOPRspExectueOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* SOP-ͻȨָϢѯӦ
	* @param pData:ָǿ,ûͻȨָϢѯӦϢṹַ,ͻͻȨָϢѯɹ
	* @param pRspInfo:ָǿգشϢַͻͻȨָϢѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryExecAssiInfo(DFITCSOPRspQryExecAssiInfoField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ѯʱӦ
	* @param pData:ָǿ,ûѯʱӦϢṹַ,ͻѯʱɹ
	* @param pRspInfo:ָǿգشϢַͻѯʱʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryTradeTime(DFITCSOPRspQryTradeTimeField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ȡнӦ
	* @param pData:ָǿ,ûȡнӦϢṹַ,ͻȡнɹ
	* @param pRspInfo:ָǿգشϢַͻȡнʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryExchangeInfo(DFITCSOPRspQryExchangeInfoField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ѯѲӦ
	* @param pData:ָǿ,ûѯѲӦϢṹַ,ͻѯѲɹ
	* @param pRspInfo:ָǿգشϢַͻѯѲʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryCommission(DFITCSOPRspQryCommissionField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ѯ֤ʲӦ
	* @param pData:ָǿ,ûѯ֤ʲӦϢṹַ,ͻѯ֤ʲɹ
	* @param pRspInfo:ָǿգشϢַͻѯ֤ʲʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryDeposit(DFITCSOPRspQryDepositField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ȨϢѯӦ
	* @param pData:ָǿ,ûȨϢѯӦϢṹַ,ͻȨϢѯɹ
	* @param pRspInfo:ָǿգشϢַͻȨϢѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPQryContractObjectInfo(DFITCSOPRspQryContractObjectField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* SOP-ίлرӦ
	* @param pData:ίлرṹĵַ
	*/
	virtual void OnSOPEntrustOrderRtn(DFITCSOPEntrustOrderRtnField * pData);
	/**
	* SOP-ɽرӦ
	* @param pData:سɽرṹĵַ
	*/
	virtual void OnSOPTradeRtn(DFITCSOPTradeRtnField * pData);
	/**
	* SOP-رӦ
	* @param pData:سرṹĵַ
	*/
	virtual void OnSOPWithdrawOrderRtn(DFITCSOPWithdrawOrderRtnField * pData);
	/**
	* SOP-ίлرӦ
	* @param pData:˫߱ίлرṹĵַ
	*/
	virtual void OnSOPQuoteEntrustOrderRtn(DFITCSOPQuoteEntrustOrderRtnField * pData);

	/**
	* SOP-ʽӦ
	* @param pData:ָǿ,ʽӦϢṹַ,ͻʽɹ
	* @param pRspInfo:ָǿգشϢַʽʧ
	*/
	virtual void OnRspSOPCapitalTranInOut(DFITCSOPRspCapitalTranInOutField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* SOP-ʽڵѯӦ
	* @param pData:ָǿ,ʽڵӦϢṹַ,ͻʽڵѯɹ
	* @param pRspInfo:ָǿգشϢַʽڵѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspSOPCapitalDistributionRatio(DFITCSOPRspQryCapitalDistributionRatioField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);

	/**
	* SOP-ڵʽ𻮲Ӧ
	* @param pData:ָǿ,ؽڵʽ𻮲ӦϢṹַ,ͻڵʽ𻮲ɹ
	* @param pRspInfo:ָǿգشϢַڵʽ𻮲ʧ
	*/
	virtual void OnRspSOPFundTransBetweenNodes(DFITCSOPRspFundTransBetweenNodesField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* SOP-޸ʽڵӦ
	* @param pData:ָǿ,ʽڵӦϢṹַ,ÿͻʽڵɹ
	* @param pRspInfo:ָǿգشϢַʽڵʧ
	*/
	virtual void OnRspSOPModCapitalDistributionRatio(DFITCSOPRspModCapitalDistributionRatioField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* FASL-¼Ӧ
	* @param pData:ָǿ,ûȯ¼ӦϢṹַ,ͻȯ¼ɹ
	* @param pRspInfo:ָǿգشϢַͻȯ¼ʧ
	*/
	virtual void OnRspFASLUserLogin(DFITCSECRspUserLoginField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ǳӦ
	* @param pData:ָǿ,ûȯǳӦϢṹַ,ͻȯǳɹ
	* @param pRspInfo:ָǿգشϢַͻȯǳʧ
	*/
	virtual void OnRspFASLUserLogout(DFITCSECRspUserLogoutField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ͻϢӦ
	* @param pData:ָǿ,ûͻϢӦϢṹַ,ͻͻϢɹ
	* @param pRspInfo:ָǿգشϢַͻͻϢʧ
	*/
	virtual void OnRspFASLQryAbleFinInfo(DFITCFASLRspAbleFinInfoField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ͻȯϢӦ
	* @param pData:ָǿ,ûͻȯϢӦϢṹַ,ͻͻȯϢɹ
	* @param pRspInfo:ָǿգشϢַͻͻȯϢʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryAbleSloInfo(DFITCFASLRspAbleSloInfoField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-ﻮתӦ
	* @param pData:ָǿ,ûﻮתӦϢṹַ,ͻﻮתɹ
	* @param pRspInfo:ָǿգشϢַͻﻮתʧ
	*/
	virtual void OnRspFASLTransferCollateral(DFITCFASLRspTransferCollateralField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ֱӻӦ
	* @param pData:ָǿ,ûֱӻӦϢṹַ,ͻֱӻɹ
	* @param pRspInfo:ָǿգشϢַͻֱӻʧ
	*/
	virtual void OnRspFASLDirectRepayment(DFITCFASLRspDirectRepaymentField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ȯתӦ
	* @param pData:ָǿ,ûȯתӦϢṹַ,ͻȯתɹ
	* @param pRspInfo:ָǿգشϢַͻȯתʧ
	*/
	virtual void OnRspFASLRepayStockTransfer(DFITCFASLRspRepayStockTransferField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ýӦ
	* @param pData:ָǿ,ûýӦϢṹַ,ͻýɹ
	* @param pRspInfo:ָǿգشϢַͻýʧ
	*/
	virtual void OnRspFASLEntrustCrdtOrder(DFITCFASLRspEntrustCrdtOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ȯӦ
	* @param pData:ָǿ,ûȯӦϢṹַ,ͻȯɹ
	* @param pRspInfo:ָǿգشϢַͻȯʧ
	*/
	virtual void OnRspFASLEntrustOrder(DFITCFASLRspEntrustOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ÿίѯӦ
	* @param pData:ָǿ,ûÿίѯӦϢṹַ,ͻÿίѯɹ
	* @param pRspInfo:ָǿգشϢַͻÿίѯʧ
	*/
	virtual void OnRspFASLCalcAbleEntrustCrdtQty(DFITCFASLRspCalcAbleEntrustCrdtQtyField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ѯʽӦ
	* @param pData:ָǿ,ûѯʽӦϢṹַ,ͻѯʽɹ
	* @param pRspInfo:ָǿգشϢַͻѯʽʧ
	  * @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryCrdtFunds(DFITCFASLRspQryCrdtFundsField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-úԼϢӦ
	* @param pData:ָǿ,ûúԼϢӦϢṹַ,ͻúԼϢɹ
	* @param pRspInfo:ָǿգشϢַͻúԼϢʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryCrdtContract(DFITCFASLRspQryCrdtContractField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLat);
	/**
	* FASL-úԼ䶯ϢѯӦ
	* @param pData:ָǿ,ûúԼ䶯ϢѯӦϢṹַ,ͻúԼ䶯Ϣѯɹ
	* @param pRspInfo:ָǿգشϢַͻúԼ䶯Ϣѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryCrdtConChangeInfo(DFITCFASLRspQryCrdtConChangeInfoField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-ʽתӦ
	* @param pData:ָǿ,ûʽתӦϢṹַ,ͻʽתɹ
	* @param pRspInfo:ָǿգشϢַͻʽתʧ
	*/
	virtual void OnRspFASLTransferFunds(DFITCFASLRspTransferFundsField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-֤ȯתӦ
	* @param pData:ָǿ,û֤ȯתӦϢṹַ,ͻ֤ȯתɹ
	* @param pRspInfo:ָǿգشϢַͻ֤ȯתʧ
	*/
	virtual void OnRspFASLTransferStock(DFITCFASLRspTransferStockField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ͻϢѯӦ
	* @param pData:ָǿ,ûͻϢѯӦϢṹַ,ͻͻϢѯɹ
	* @param pRspInfo:ָǿգشϢַͻͻϢѯʧ
	*/
	virtual void OnRspFASLQryAccountInfo(DFITCFASLRspQryAccountField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ͻʽѯӦ
	* @param pData:ָǿ,ûͻʽѯӦϢṹַ,ͻͻʽѯɹ
	* @param pRspInfo:ָǿգشϢַͻͻʽѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryCapitalAccountInfo(DFITCFASLRspQryCapitalAccountField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-ɶϢѯӦ
	* @param pData:ָǿ,ûɶϢѯӦϢṹַ,ͻɶϢѯɹ
	* @param pRspInfo:ָǿգشϢַͻɶϢѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryShareholderInfo(DFITCFASLRspQryShareholderField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-ֲֲѯӦ
	* @param pData:ָǿ,ûֲֲѯӦϢṹַ,ͻֲֲѯɹ
	* @param pRspInfo:ָǿգشϢַͻֲֲѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryPosition(DFITCFASLRspQryPositionField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-ίвѯӦ
	* @param pData:ָǿ,ûίвѯӦϢṹַ,ͻίвѯɹ
	* @param pRspInfo:ָǿգشϢַͻίвѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryEntrustOrder(DFITCFASLRspQryEntrustOrderField * pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-ֱʳɽѯӦ
	* @param pData:ָǿ,ûֱʳɽѯӦϢṹַ,ͻֱʳɽѯɹ
	* @param pRspInfo:ָǿգشϢַͻֱʳɽѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQrySerialTrade(DFITCFASLRspQrySerialTradeField * pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-ʵʱɽѯӦ
	* @param pData:ָǿ,ûʵʱɽѯӦϢṹַ,ͻʵʱɽѯɹ
	* @param pRspInfo:ָǿգشϢַͻʵʱɽѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryRealTimeTrade(DFITCFASLRspQryRealTimeTradeField * pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-ʽ𶳽ϸѯӦ
	* @param pData:ָǿ,ûʽ𶳽ϸѯӦϢṹַ,ͻʽ𶳽ϸѯɹ
	* @param pRspInfo:ָǿգشϢַͻʽ𶳽ϸѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryFreezeFundsDetail(DFITCFASLRspQryFreezeFundsDetailField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-֤ȯϸѯӦ
	* @param pData:ָǿ,û֤ȯϸѯӦϢṹַ,ͻ֤ȯϸѯɹ
	* @param pRspInfo:ָǿգشϢַͻ֤ȯϸѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryFreezeStockDetail(DFITCFASLRspQryFreezeStockDetailField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-ʽϸѯӦ
	* @param pData:ָǿ,ûʽϸѯӦϢṹַ,ͻʽϸѯɹ
	* @param pRspInfo:ָǿգشϢַͻʽϸѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryTransferFundsDetail(DFITCFASLRspQryTransferFundsDetailField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-Ӧ
	* @param pData:ָǿ,ûӦϢṹַ,ɹ
	* @param pRspInfo:ָǿգشϢַʧ
	*/
	virtual void OnRspFASLWithdrawOrder(DFITCFASLRspWithdrawOrderField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ǰϵͳʱѯӦ
	* @param pData:ָǿ,ûϵͳʱѯӦϢṹַ,ϵͳʱѯɹ
	* @param pRspInfo:ָǿգشϢַϵͳʱѯʧ
	*/
	virtual void OnRspFASLQrySystemTime(DFITCFASLRspQryTradeTimeField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ת뵣֤ȯѯӦ
	* @param pData:ָǿ,ؿת뵣֤ȯѯӦϢṹַ,ת뵣֤ȯѯɹ
	* @param pRspInfo:ָǿգشϢַת뵣֤ȯѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryTransferredContract(DFITCFASLRspQryTransferredContractField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-ͻȡʽӦ
	* @param pData:ָǿ,ؿͻȡʽӦϢṹַ,ͻȡʽɹ
	* @param pRspInfo:ָǿգشϢַͻȡʽʧ
	*/
	virtual void OnRspFASLDesirableFundsOut(DFITCFASLRspDesirableFundsOutField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-֤ȯѯӦ
	* @param pData:ָǿ,ص֤ȯѯӦϢṹַ,֤ȯѯɹ
	* @param pRspInfo:ָǿգشϢַ֤ȯѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryGuaranteedContract(DFITCFASLRspQryGuaranteedContractField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-֤ȯѯӦ
	* @param pData:ָǿ,ر֤ȯѯӦϢṹַ,֤ȯѯɹ
	* @param pRspInfo:ָǿգشϢַ֤ȯѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryUnderlyingContract(DFITCFASLRspQryUnderlyingContractField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-нʽѯӦ
	* @param pData:ָǿ,ؼнʽѯӦϢṹַ,нʽѯɹ
	* @param pRspInfo:ָǿգشϢַ֤ȯѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryCentreFundAvlInfo(DFITCFASLRspQryCentreFundAvlField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-ͻȨѯӦ
	* @param pData:ָǿ,ؿͻȨѯӦϢṹַ,ͻȨѯɹ
	* @param pRspInfo:ָǿգشϢַ֤ȯѯʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspFASLQryPlacingInterestsInfo(DFITCFASLRspQryPlacingInterestsField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);
	/**
	* FASL-Ӧ
	* @param pData:ָǿ,ûӦϢṹĵַ,ɹ
	* @param pRspInfo:ָǿգشϢṹĵַʧ
	*/
	virtual void OnRspFASLUserPasswordUpdate(DFITCSECRspPasswordUpdateField *pData, DFITCSECRspInfoField *pRspInfo);
	/**
	* FASL-ίлرӦ
	* @param pData:ίлرṹĵַ
	*/
	virtual void OnFASLEntrustOrderRtn(DFITCFaslEntrustOrderRtnField *pData);
	/**
	* FASL-ɽرӦ
	* @param pData:سɽرṹĵַ
	*/
	virtual void OnFASLTradeRtn(DFITCFaslTradeRtnField *pData);
	/**
	* FASL-رӦ
	* @param pData:سرṹĵַ
	*/
	virtual void OnFASLWithdrawOrderRtn(DFITCFaslWithdrawOrderRtnField *pData);
	/**
	* FASL-ծ䶯Ӧ
	* @param pData:ظծ䶯ṹĵַ
	*/
	virtual void OnFASLLiabilitiesRtn(DFITCFaslLiabilitiesRtnField *pData);

	//ΪSTOCKҵӦӿ
	/**
	* STOCK-ETFίӦ
	* @param pData:ָǿ,ETFίӦϢṹĵַ,ETFίɹ
	* @param pRspInfo:ָǿգشϢṹĵַETFίʧ
	*/
	virtual void OnRspStockETFEntrustOrder(DFITCStockRspETFEntrustOrderField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-ETFӹӦ
	* @param pData:ָǿ,ETFӹӦϢṹĵַ,ETFӹɹ,pData->localOrderIDС0˵óɷֹʧܡ
	* @param pRspInfo:ָǿգشϢṹĵַETFӹʧ
	* @param bIsLast:ֵǷһӦϢ(0-,1-)
	*/
	virtual void OnRspStockETFBasketOrder(DFITCStockRspETFBasketOrderField *pData, DFITCSECRspInfoField *pRspInfo, bool bIsLast);

	/**
	* STOCK-ծȯعӦ
	* @param pData:ָǿ,ծȯعӦϢṹĵַ,ծȯعɹ
	* @param pRspInfo:ָǿգشϢṹĵַծȯعʧ
	*/
	virtual void OnRspStockBondRepurchaseOrder(DFITCStockRspBondRepurchaseOrderField *pData, DFITCSECRspInfoField *pRspInfo);


	/**
	* STOCK-ծȯӦ
	* @param pData:ָǿ,ծȯӦϢṹĵַ,ծȯɹ
	* @param pRspInfo:ָǿգشϢṹĵַίбʧ
	*/
	virtual void OnRspStockBondInOutStockOrder(DFITCStockRspBondInOutStockOrderField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-ҵӦ
	* @param pData:ָǿ,طҵӦϢṹĵַ,ҵɹ
	* @param pRspInfo:ָǿգشϢṹĵַҵʧ
	*/
	virtual void OnRspStockIssueBusinessOrder(DFITCStockRspIssueBusinessOrderField *pData, DFITCSECRspInfoField *pRspInfo);


	/**
	* STOCK-LOFӦ
	* @param pData:ָǿ,LOFӦϢṹĵַ,LOFɹ
	* @param pRspInfo:ָǿգشϢṹĵַLOFʧ
	*/
	virtual void OnRspStockLOFEntrustOrder(DFITCStockRspLOFEntrustOrderField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-̺󶨼Ӧ
	* @param pData:ָǿ,̺󶨼ӦϢṹĵַ,̺󶨼ɹ
	* @param pRspInfo:ָǿգشϢṹĵַ̺󶨼ʧ
	*/
	virtual void OnRspStockAfterHoursPriceOrder(DFITCStockRspAfterHoursPriceOrderField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-ǽҵӦ
	* @param pData:ָǿ,طǽҵӦϢṹĵַ,ǽҵɹ
	* @param pRspInfo:ָǿգشϢṹĵַǽҵʧ
	*/
	virtual void OnRspStockNonTradingBusinessOrder(DFITCStockRspNonTradingBusinessOrderField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-ϺͨӦ
	* @param pData:ָǿ,ϺͨӦϢṹĵַ,Ϻͨɹ
	* @param pRspInfo:ָǿգشϢṹĵַϺͨʧ
	*/
	virtual void OnRspStockSHMutualFundOrder(DFITCStockRspSHMutualFundOrderField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-ETFƱӦ
	* @param pData:ָǿ,ûETFƱӦϢṹĵַ,ETFƱɹ
	* @param pRspInfo:ָǿգشϢṹĵַETFƱʧ
	*/
	virtual void OnRspStockCalcAblePurchaseETFBasketQty(DFITCStockRspCalcAblePurchaseETFBasketQtyField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-ծȯعίӦ
	* @param pData:ָǿ,ûծȯعίӦϢṹĵַ,ծȯعίɹ
	* @param pRspInfo:ָǿգشϢṹĵַծȯعίʧ
	*/
	virtual void OnRspStockCalcAbleBondRepurchaseQty(DFITCStockRspCalcAbleBondRepurchaseQtyField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-㷢ҵϹӦ
	* @param pData:ָǿ,û㷢ҵϹӦϢṹĵַ,㷢ҵϹɹ
	* @param pRspInfo:ָǿգشϢṹĵַ㷢ҵϹʧ
	*/
	virtual void OnRspStockCalcAbleIssueBusinessQty(DFITCStockRspCalcAbleIssueBusinessQtyField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-LOFҵίӦ
	* @param pData:ָǿ,ûLOFҵίӦϢṹĵַ,LOFҵίɹ
	* @param pRspInfo:ָǿգشϢṹĵַLOFҵίʧ
	*/
	virtual void OnRspStockCalcAblePurchaseLOFQty(DFITCStockRspCalcAblePurchaseLOFQtyField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-̺󶨼ۿӦ
	* @param pData:ָǿ,û̺󶨼ۿӦϢṹĵַ,̺󶨼ۿɹ
	* @param pRspInfo:ָǿգشϢṹĵַ̺󶨼ۿʧ
	*/
	virtual void OnRspStockCalcAbleAfterHoursPriceQty(DFITCStockRspCalcAbleAfterHoursPriceQtyField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-ǽҵϹӦ
	* @param pData:ָǿ,ûǽҵϹӦϢṹĵַ,ǽҵϹɹ
	* @param pRspInfo:ָǿգشϢṹĵַǽҵϹʧ
	*/
	virtual void OnRspStockCalcAbleNonTradingBusinessQty(DFITCStockRspCalcAbleNonTradingBusinessQtyField *pData, DFITCSECRspInfoField *pRspInfo);

	/**
	* STOCK-ϺҵϹӦ
	* @param pData:ָǿ,ûϺҵϹӦϢṹĵַ,ϺҵϹɹ
	* @param pRspInfo:ָǿգشϢṹĵַϺҵϹʧ
	*/
	virtual void OnRspStockCalcAbleSHMutualFundQty(DFITCStockRspCalcAbleSHMutualFundQtyField *pData, DFITCSECRspInfoField *pRspInfo);

	//-------------------------------------------------------------------------------------
	//task
	//-------------------------------------------------------------------------------------
	void processTask();

	void processFrontConnected(Task *task);

	void processFrontDisconnected(Task *task);

	void processRtnNotice(Task *task);

	void processRspError(Task *task);

	void processRspStockUserLogin(Task *task);

	void processRspStockUserLogout(Task *task);

	void processRspStockUserPasswordUpdate(Task *task);

	void processRspStockEntrustOrder(Task *task);

	void processRspStockWithdrawOrder(Task *task);

	void processRspStockQryEntrustOrder(Task *task);

	void processRspStockQryRealTimeTrade(Task *task);

	void processRspStockQrySerialTrade(Task *task);

	void processRspStockQryPosition(Task *task);

	void processRspStockQryCapitalAccountInfo(Task *task);

	void processRspStockQryAccountInfo(Task *task);

	void processRspStockQryShareholderInfo(Task *task);

	void processRspStockTransferFunds(Task *task);

	void processRspStockEntrustBatchOrder(Task *task);

	void processRspStockWithdrawBatchOrder(Task *task);

	void processRspStockCalcAbleEntrustQty(Task *task);

	void processRspStockCalcAblePurchaseETFQty(Task *task);

	void processRspStockQryFreezeFundsDetail(Task *task);

	void processRspStockQryFreezeStockDetail(Task *task);

	void processRspStockQryTransferStockDetail(Task *task);

	void processRspStockQryTransferFundsDetail(Task *task);

	void processRspStockQryStockInfo(Task *task);

	void processRspStockQryStockStaticInfo(Task *task);

	void processRspStockQryTradeTime(Task *task);

	void processStockEntrustOrderRtn(Task *task);

	void processStockTradeRtn(Task *task);

	void processStockWithdrawOrderRtn(Task *task);

	void processRspSOPUserLogin(Task *task);

	void processRspSOPUserLogout(Task *task);

	void processRspSOPUserPasswordUpdate(Task *task);

	void processRspSOPEntrustOrder(Task *task);

	void processRspSOPQuoteEntrustOrder(Task *task);

	void processRspSOPGroupSplit(Task *task);

	void processRspSOPGroupExectueOrder(Task *task);

	void processRspSOPQryGroupPosition(Task *task);

	void processRspSOPLockOUnLockStock(Task *task);

	void processRspSOPWithdrawOrder(Task *task);

	void processRspSOPQryEntrustOrder(Task *task);

	void processRspSOPQrySerialTrade(Task *task);

	void processRspSOPQryPosition(Task *task);

	void processRspSOPQryCollateralPosition(Task *task);

	void processRspSOPQryCapitalAccountInfo(Task *task);

	void processRspSOPQryAccountInfo(Task *task);

	void processRspSOPQryShareholderInfo(Task *task);

	void processRspSOPCalcAbleEntrustQty(Task *task);

	void processRspSOPQryAbleLockStock(Task *task);

	void processRspSOPQryContactInfo(Task *task);

	void processRspSOPExectueOrder(Task *task);

	void processRspSOPQryExecAssiInfo(Task *task);

	void processRspSOPQryTradeTime(Task *task);

	void processRspSOPQryExchangeInfo(Task *task);

	void processRspSOPQryCommission(Task *task);

	void processRspSOPQryDeposit(Task *task);

	void processRspSOPQryContractObjectInfo(Task *task);

	void processSOPEntrustOrderRtn(Task *task);

	void processSOPTradeRtn(Task *task);

	void processSOPWithdrawOrderRtn(Task *task);

	void processSOPQuoteEntrustOrderRtn(Task *task);

	void processRspSOPCapitalTranInOut(Task *task);

	void processRspSOPCapitalDistributionRatio(Task *task);

	void processRspSOPFundTransBetweenNodes(Task *task);

	void processRspSOPModCapitalDistributionRatio(Task *task);

	void processRspFASLUserLogin(Task *task);

	void processRspFASLUserLogout(Task *task);

	void processRspFASLQryAbleFinInfo(Task *task);

	void processRspFASLQryAbleSloInfo(Task *task);

	void processRspFASLTransferCollateral(Task *task);

	void processRspFASLDirectRepayment(Task *task);

	void processRspFASLRepayStockTransfer(Task *task);

	void processRspFASLEntrustCrdtOrder(Task *task);

	void processRspFASLEntrustOrder(Task *task);

	void processRspFASLCalcAbleEntrustCrdtQty(Task *task);

	void processRspFASLQryCrdtFunds(Task *task);

	void processRspFASLQryCrdtContract(Task *task);

	void processRspFASLQryCrdtConChangeInfo(Task *task);

	void processRspFASLTransferFunds(Task *task);

	void processRspFASLTransferStock(Task *task);

	void processRspFASLQryAccountInfo(Task *task);

	void processRspFASLQryCapitalAccountInfo(Task *task);

	void processRspFASLQryShareholderInfo(Task *task);

	void processRspFASLQryPosition(Task *task);

	void processRspFASLQryEntrustOrder(Task *task);

	void processRspFASLQrySerialTrade(Task *task);

	void processRspFASLQryRealTimeTrade(Task *task);

	void processRspFASLQryFreezeFundsDetail(Task *task);

	void processRspFASLQryFreezeStockDetail(Task *task);

	void processRspFASLQryTransferFundsDetail(Task *task);

	void processRspFASLWithdrawOrder(Task *task);

	void processRspFASLQrySystemTime(Task *task);

	void processRspFASLQryTransferredContract(Task *task);

	void processRspFASLDesirableFundsOut(Task *task);

	void processRspFASLQryGuaranteedContract(Task *task);

	void processRspFASLQryUnderlyingContract(Task *task);

	void processRspFASLQryCentreFundAvlInfo(Task *task);

	void processRspFASLQryPlacingInterestsInfo(Task *task);

	void processRspFASLUserPasswordUpdate(Task *task);

	void processFASLEntrustOrderRtn(Task *task);

	void processFASLTradeRtn(Task *task);

	void processFASLWithdrawOrderRtn(Task *task);

	void processFASLLiabilitiesRtn(Task *task);

	void processRspStockETFEntrustOrder(Task *task);

	void processRspStockETFBasketOrder(Task *task);

	void processRspStockBondRepurchaseOrder(Task *task);

	void processRspStockBondInOutStockOrder(Task *task);

	void processRspStockIssueBusinessOrder(Task *task);

	void processRspStockLOFEntrustOrder(Task *task);

	void processRspStockAfterHoursPriceOrder(Task *task);

	void processRspStockNonTradingBusinessOrder(Task *task);

	void processRspStockSHMutualFundOrder(Task *task);

	void processRspStockCalcAblePurchaseETFBasketQty(Task *task);

	void processRspStockCalcAbleBondRepurchaseQty(Task *task);

	void processRspStockCalcAbleIssueBusinessQty(Task *task);

	void processRspStockCalcAblePurchaseLOFQty(Task *task);

	void processRspStockCalcAbleAfterHoursPriceQty(Task *task);

	void processRspStockCalcAbleNonTradingBusinessQty(Task *task);

	void processRspStockCalcAbleSHMutualFundQty(Task *task);

	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//idid
	//lastǷΪ󷵻
	//i
	//-------------------------------------------------------------------------------------

	virtual void onFrontConnected() {};

	virtual void onFrontDisconnected(int reqid) {};

	virtual void onRtnNotice(const dict &data) {};

	virtual void onRspError(const dict &error) {};

	virtual void onRspStockUserLogin(const dict &data, const dict &error) {};

	virtual void onRspStockUserLogout(const dict &data, const dict &error) {};

	virtual void onRspStockUserPasswordUpdate(const dict &data, const dict &error) {};

	virtual void onRspStockEntrustOrder(const dict &data, const dict &error) {};

	virtual void onRspStockWithdrawOrder(const dict &data, const dict &error) {};

	virtual void onRspStockQryEntrustOrder(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockQryRealTimeTrade(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockQrySerialTrade(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockQryPosition(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockQryCapitalAccountInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockQryAccountInfo(const dict &data, const dict &error) {};

	virtual void onRspStockQryShareholderInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockTransferFunds(const dict &data, const dict &error) {};

	virtual void onRspStockEntrustBatchOrder(const dict &data, const dict &error) {};

	virtual void onRspStockWithdrawBatchOrder(const dict &data, const dict &error) {};

	virtual void onRspStockCalcAbleEntrustQty(const dict &data, const dict &error) {};

	virtual void onRspStockCalcAblePurchaseETFQty(const dict &data, const dict &error) {};

	virtual void onRspStockQryFreezeFundsDetail(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockQryFreezeStockDetail(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockQryTransferStockDetail(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockQryTransferFundsDetail(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockQryStockInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockQryStockStaticInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockQryTradeTime(const dict &data, const dict &error) {};

	virtual void onStockEntrustOrderRtn(const dict &data) {};

	virtual void onStockTradeRtn(const dict &data) {};

	virtual void onStockWithdrawOrderRtn(const dict &data) {};

	virtual void onRspSOPUserLogin(const dict &data, const dict &error) {};

	virtual void onRspSOPUserLogout(const dict &data, const dict &error) {};

	virtual void onRspSOPUserPasswordUpdate(const dict &data, const dict &error) {};

	virtual void onRspSOPEntrustOrder(const dict &data, const dict &error) {};

	virtual void onRspSOPQuoteEntrustOrder(const dict &data, const dict &error) {};

	virtual void onRspSOPGroupSplit(const dict &data, const dict &error) {};

	virtual void onRspSOPGroupExectueOrder(const dict &data, const dict &error) {};

	virtual void onRspSOPQryGroupPosition(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPLockOUnLockStock(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPWithdrawOrder(const dict &data, const dict &error) {};

	virtual void onRspSOPQryEntrustOrder(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPQrySerialTrade(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPQryPosition(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPQryCollateralPosition(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPQryCapitalAccountInfo(const dict &data, const dict &error) {};

	virtual void onRspSOPQryAccountInfo(const dict &data, const dict &error) {};

	virtual void onRspSOPQryShareholderInfo(const dict &data, const dict &error) {};

	virtual void onRspSOPCalcAbleEntrustQty(const dict &data, const dict &error) {};

	virtual void onRspSOPQryAbleLockStock(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPQryContactInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPExectueOrder(const dict &data, const dict &error) {};

	virtual void onRspSOPQryExecAssiInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPQryTradeTime(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPQryExchangeInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPQryCommission(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPQryDeposit(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPQryContractObjectInfo(const dict &data, const dict &error, bool last) {};

	virtual void onSOPEntrustOrderRtn(const dict &data) {};

	virtual void onSOPTradeRtn(const dict &data) {};

	virtual void onSOPWithdrawOrderRtn(const dict &data) {};

	virtual void onSOPQuoteEntrustOrderRtn(const dict &data) {};

	virtual void onRspSOPCapitalTranInOut(const dict &data, const dict &error) {};

	virtual void onRspSOPCapitalDistributionRatio(const dict &data, const dict &error, bool last) {};

	virtual void onRspSOPFundTransBetweenNodes(const dict &data, const dict &error) {};

	virtual void onRspSOPModCapitalDistributionRatio(const dict &data, const dict &error) {};

	virtual void onRspFASLUserLogin(const dict &data, const dict &error) {};

	virtual void onRspFASLUserLogout(const dict &data, const dict &error) {};

	virtual void onRspFASLQryAbleFinInfo(const dict &data, const dict &error) {};

	virtual void onRspFASLQryAbleSloInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLTransferCollateral(const dict &data, const dict &error) {};

	virtual void onRspFASLDirectRepayment(const dict &data, const dict &error) {};

	virtual void onRspFASLRepayStockTransfer(const dict &data, const dict &error) {};

	virtual void onRspFASLEntrustCrdtOrder(const dict &data, const dict &error) {};

	virtual void onRspFASLEntrustOrder(const dict &data, const dict &error) {};

	virtual void onRspFASLCalcAbleEntrustCrdtQty(const dict &data, const dict &error) {};

	virtual void onRspFASLQryCrdtFunds(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryCrdtContract(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryCrdtConChangeInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLTransferFunds(const dict &data, const dict &error) {};

	virtual void onRspFASLTransferStock(const dict &data, const dict &error) {};

	virtual void onRspFASLQryAccountInfo(const dict &data, const dict &error) {};

	virtual void onRspFASLQryCapitalAccountInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryShareholderInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryPosition(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryEntrustOrder(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQrySerialTrade(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryRealTimeTrade(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryFreezeFundsDetail(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryFreezeStockDetail(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryTransferFundsDetail(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLWithdrawOrder(const dict &data, const dict &error) {};

	virtual void onRspFASLQrySystemTime(const dict &data, const dict &error) {};

	virtual void onRspFASLQryTransferredContract(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLDesirableFundsOut(const dict &data, const dict &error) {};

	virtual void onRspFASLQryGuaranteedContract(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryUnderlyingContract(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryCentreFundAvlInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLQryPlacingInterestsInfo(const dict &data, const dict &error, bool last) {};

	virtual void onRspFASLUserPasswordUpdate(const dict &data, const dict &error) {};

	virtual void onFASLEntrustOrderRtn(const dict &data) {};

	virtual void onFASLTradeRtn(const dict &data) {};

	virtual void onFASLWithdrawOrderRtn(const dict &data) {};

	virtual void onFASLLiabilitiesRtn(const dict &data) {};

	virtual void onRspStockETFEntrustOrder(const dict &data, const dict &error) {};

	virtual void onRspStockETFBasketOrder(const dict &data, const dict &error, bool last) {};

	virtual void onRspStockBondRepurchaseOrder(const dict &data, const dict &error) {};

	virtual void onRspStockBondInOutStockOrder(const dict &data, const dict &error) {};

	virtual void onRspStockIssueBusinessOrder(const dict &data, const dict &error) {};

	virtual void onRspStockLOFEntrustOrder(const dict &data, const dict &error) {};

	virtual void onRspStockAfterHoursPriceOrder(const dict &data, const dict &error) {};

	virtual void onRspStockNonTradingBusinessOrder(const dict &data, const dict &error) {};

	virtual void onRspStockSHMutualFundOrder(const dict &data, const dict &error) {};

	virtual void onRspStockCalcAblePurchaseETFBasketQty(const dict &data, const dict &error) {};

	virtual void onRspStockCalcAbleBondRepurchaseQty(const dict &data, const dict &error) {};

	virtual void onRspStockCalcAbleIssueBusinessQty(const dict &data, const dict &error) {};

	virtual void onRspStockCalcAblePurchaseLOFQty(const dict &data, const dict &error) {};

	virtual void onRspStockCalcAbleAfterHoursPriceQty(const dict &data, const dict &error) {};

	virtual void onRspStockCalcAbleNonTradingBusinessQty(const dict &data, const dict &error) {};

	virtual void onRspStockCalcAbleSHMutualFundQty(const dict &data, const dict &error) {};

	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void createDFITCSECTraderApi(string pszLogAddr);

	void release();

	int init(string pszFrontAddress);

	int exit();

	int subscribePrivateTopic(int nResumeType);

	int reqStockUserLogin(const dict &req);

	int reqStockUserLogout(const dict &req);

	int reqStockUserPasswordUpdate(const dict &req);

	int reqStockEntrustOrder(const dict &req);

	int reqStockWithdrawOrder(const dict &req);

	int reqStockQryEntrustOrder(const dict &req);

	int reqStockQryRealTimeTrade(const dict &req);

	int reqStockQrySerialTrade(const dict &req);

	int reqStockQryPosition(const dict &req);

	int reqStockQryCapitalAccountInfo(const dict &req);

	int reqStockQryAccountInfo(const dict &req);

	int reqStockQryShareholderInfo(const dict &req);

	int reqStockTransferFunds(const dict &req);

	int reqStockEntrustBatchOrder(const dict &req);

	int reqStockWithdrawBatchOrder(const dict &req);

	int reqStockCalcAbleEntrustQty(const dict &req);

	int reqStockCalcAblePurchaseETFQty(const dict &req);

	int reqStockQryFreezeFundsDetail(const dict &req);

	int reqStockQryFreezeStockDetail(const dict &req);

	int reqStockQryTransferFundsDetail(const dict &req);

	int reqStockQryTransferStockDetail(const dict &req);

	int reqStockQryStockInfo(const dict &req);

	int reqStockQryStockStaticInfo(const dict &req);

	int reqStockQryTradeTime(const dict &req);

	int reqSOPUserLogin(const dict &req);

	int reqSOPUserLogout(const dict &req);

	int reqSOPUserPasswordUpdate(const dict &req);

	int reqSOPEntrustOrder(const dict &req);

	int reqSOPQuoteEntrustOrder(const dict &req);

	int reqSOPGroupSplit(const dict &req);

	int reqSOPGroupExectueOrder(const dict &req);

	int reqSOPQryGroupPosition(const dict &req);

	int reqSOPLockOUnLockStock(const dict &req);

	int reqSOPWithdrawOrder(const dict &req);

	int reqSOPQryEntrustOrder(const dict &req);

	int reqSOPQrySerialTrade(const dict &req);

	int reqSOPQryPosition(const dict &req);

	int reqSOPQryCollateralPosition(const dict &req);

	int reqSOPQryCapitalAccountInfo(const dict &req);

	int reqSOPQryAccountInfo(const dict &req);

	int reqSOPQryShareholderInfo(const dict &req);

	int reqSOPCalcAbleEntrustQty(const dict &req);

	int reqSOPQryAbleLockStock(const dict &req);

	int reqSOPQryContactInfo(const dict &req);

	int reqSOPExectueOrder(const dict &req);

	int reqSOPQryExecAssiInfo(const dict &req);

	int reqSOPQryTradeTime(const dict &req);

	int reqSOPQryExchangeInfo(const dict &req);

	int reqSOPQryCommission(const dict &req);

	int reqSOPQryDeposit(const dict &req);

	int reqSOPQryContractObjectInfo(const dict &req);

	int reqSOPCapitalTranInOut(const dict &req);

	int reqSOPCapitalDistributionRatio(const dict &req);

	int reqSOPFundTransBetweenNodes(const dict &req);

	int reqSOPModCapitalDistributionRatio(const dict &req);

	int reqFASLUserLogin(const dict &req);

	int reqFASLUserLogout(const dict &req);

	int reqFASLQryAbleFinInfo(const dict &req);

	int reqFASLQryAbleSloInfo(const dict &req);

	int reqFASLTransferCollateral(const dict &req);

	int reqFASLDirectRepayment(const dict &req);

	int reqFASLRepayStockTransfer(const dict &req);

	int reqFASLEntrustCrdtOrder(const dict &req);

	int reqFASLEntrustOrder(const dict &req);

	int reqFASLWithdrawOrder(const dict &req);

	int reqFASLCalcAbleEntrustCrdtQty(const dict &req);

	int reqFASLQryCrdtFunds(const dict &req);

	int reqFASLQryCrdtContract(const dict &req);

	int reqFASLQryCrdtConChangeInfo(const dict &req);

	int reqFASLTransferFunds(const dict &req);

	int reqFASLTransferStock(const dict &req);

	int reqFASLQryAccountInfo(const dict &req);

	int reqFASLQryCapitalAccountInfo(const dict &req);

	int reqFASLQryShareholderInfo(const dict &req);

	int reqFASLQryPosition(const dict &req);

	int reqFASLQryEntrustOrder(const dict &req);

	int reqFASLQrySerialTrade(const dict &req);

	int reqFASLQryRealTimeTrade(const dict &req);

	int reqFASLQryFreezeFundsDetail(const dict &req);

	int reqFASLQryFreezeStockDetail(const dict &req);

	int reqFASLQryTransferFundsDetail(const dict &req);

	int reqFASLQrySystemTime(const dict &req);

	int reqFASLQryTransferredContract(const dict &req);

	int reqFASLDesirableFundsOut(const dict &req);

	int reqFASLQryGuaranteedContract(const dict &req);

	int reqFASLQryUnderlyingContract(const dict &req);

	int reqFASLQryCentreFundAvlInfo(const dict &req);

	int reqFASLQryPlacingInterestsInfo(const dict &req);

	int reqFASLUserPasswordUpdate(const dict &req);

	int reqStockETFEntrustOrder(const dict &req);

	int reqStockETFBasketOrder(const dict &req);

	int reqStockBondRepurchaseOrder(const dict &req);

	int reqStockBondInOutStockOrder(const dict &req);

	int reqStockIssueBusinessOrder(const dict &req);

	int reqStockLOFEntrustOrder(const dict &req);

	int reqStockAfterHoursPriceOrder(const dict &req);

	int reqStockNonTradingBusinessOrder(const dict &req);

	int reqStockSHMutualFundOrder(const dict &req);

	int reqStockCalcAblePurchaseETFBasketQty(const dict &req);

	int reqStockCalcAbleBondRepurchaseQty(const dict &req);

	int reqStockCalcAbleIssueBusinessQty(const dict &req);

	int reqStockCalcAblePurchaseLOFQty(const dict &req);

	int reqStockCalcAbleAfterHoursPriceQty(const dict &req);

	int reqStockCalcAbleNonTradingBusinessQty(const dict &req);

	int reqStockCalcAbleSHMutualFundQty(const dict &req);

};
