class ToolSummarizePast:
    def __init__(self):
        self.name = "summarize_past_on_context_switch"

        self.tool_summary = f"""<tool_summary>
<tool_name>{self.name}</tool_name>
<summary>Summarizes all previous conversations when the user switches context, to avoid keeping in memory a very long conversation that is no longer relevant.</summary>
</tool_summary>"""

        self.tool_description = {
            "name": self.name,
            "description": f"""Summarizes all previous conversations when the user switches context, to avoid keeping in memory a very long conversation that is no longer relevant.

Before calling any other tool, evaluate if {self.name} should be called.
Before every answer, use the <scratchpad></scratchpad> to evaluate if the next answer is unrelated to the previous topics.

CRITICAL: This tool is essential for maintaining conversation efficiency and relevance. Use it proactively to manage memory and context.

WHEN TO USE:
1. After every 3-5 exchanges, evaluate if a summary is needed.
2. When the user introduces a new topic unrelated to the main themes of the last 3-5 exchanges.
3. If the conversation has drifted significantly from the original topic.
4. When the user explicitly indicates a topic change (e.g., "Let's talk about something else", "Changing the subject").
5. If a certain keyword analysis threshold is met (see below).

PROCESS:
1. Maintain a brief list of main topics discussed, updating with each exchange.
2. Before each response, use the <scratchpad></scratchpad> to:
   a. Perform a keyword analysis between the current query and the previous 2-3 exchanges.
   b. Evaluate if the next answer will be unrelated to the previous topics.
   c. Consider what information might be relevant for future exchanges.

3. If a topic change is detected or 5 exchanges have passed, explicitly explain in the scratchpad whether summarize_past_on_context_switch will be used and why.

4. When calling the tool, ensure to:
   a. Provide a concise summary of important topics discussed.
   b. Include crucial information from both user and assistant.
   c. Specify information that may still be relevant moving forward.
   d. State the next question to be answered.

KEYWORD ANALYSIS:
Perform a simple comparison of key terms between the current query and recent exchanges. If the overlap is less than 30%, consider it a potential topic change.

EXAMPLES:
- Topic change: From discussing solar system to cooking recipes.
- Not a topic change: From discussing planets to discussing moons (related astronomical objects).

THRESHOLD:
Consider a topic "unrelated" if it doesn't share any major concepts, field of study, or direct implications with the previous topic.

IMPORTANCE:
Proper use of this tool is as crucial as using tools for information retrieval or computation. It directly impacts the quality and efficiency of the conversation.

Failing to use this tool when appropriate will result in less efficient and less relevant conversations, and may be flagged for improvement.

Raises ValueError: if one of the parameters is invalid.""",
            "input_schema": {
                "type": "object",
                "properties": {
                    "past_conversation_summary": {
                        "type": "string",
                        "description": "A summary of important topics that were discussed. Always include important information from user and assistant (you).",
                    },
                    "information_still_relevant": {
                        "type": "string",
                        "description": "Information that may still be relevant moving forward with the conversation, like user preferences, name, etc.",
                    },
                    "next_question_to_answer": {
                        "type": "string",
                        "description": "What was the last question from the user, which still needs to be answered.",
                    },
                },
                "required": [
                    "past_conversation_summary",
                    "information_still_relevant",
                    "next_question_to_answer",
                ],
            },
        }
        self.tool_summary = self.tool_description

    def __call__(
        self,
        past_conversation_summary,
        information_still_relevant,
        next_question_to_answer,
        **kwargs,
    ):
        if len(kwargs) > 0:
            return f"Error: Unexpected parameter(s): {','.join([x for x in kwargs])}"

        ans = f"""Summary of all past conversation generated by tool {self.name}:

<past_conversation_summary>{past_conversation_summary}</past_conversation_summary>
<information_still_relevant>{information_still_relevant}</information_still_relevant>
<next_question_to_answer>{next_question_to_answer}</next_question_to_answer>

[|[PAST_FORGOTTEN]|]
"""
        # this tool doesn't really need to do anything. The arguments are what is important
        return ans
