"""
Django settings for corgy_erp project.

Generated by 'django-admin startproject' using Django 3.0.6.

For more information on this file, see
https://docs.djangoproject.com/en/3.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.0/ref/settings/
"""

import os
import sentry_sdk
from sentry_sdk.integrations.django import DjangoIntegration
from configurations import Configuration, values
from django.utils.translation import ugettext_lazy as _
from django.core import validators
import logging

from dotenv import load_dotenv
load_dotenv(verbose=True)

class URIValue(values.ValidationMixin, values.Value):
    message = 'Cannot interpret URL value {0!r}'
    validator = validators.URLValidator(schemes=[
        'http', 'https',
        'ftp', 'ftps',
        'ldap', 'ldaps',
        'smtp', 'smtps',
        'redis',
        'postgres',
    ])

ENVIRON_PREFIX = 'CORGY'


class Base(Configuration):

    # Build paths inside the project like this: os.path.join(BASE_DIR, ...)
    BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


    # Quick-start development settings - unsuitable for production
    # See https://docs.djangoproject.com/en/3.0/howto/deployment/checklist/

    # SECURITY WARNING: keep the secret key used in production secret!
    SECRET_KEY = 'u)0-b^so@4ci*ehto*c)))3jjh&=c%($@))52(cjk+g$tdfoyx'

    # SECURITY WARNING: don't run with debug turned on in production!
    DEBUG = True

    ALLOWED_HOSTS = [
        '*'
        #'corgy.cherubits.hu',
        #'corgy-staging.cherubits.hu',
        #'127.0.0.1',
    ]

    GOOGLE_API_KEY = values.Value(default='AIzaSyBkrEScRkVmdQ-KN_rv-E-sV0UmhyMxFjo', environ_prefix=ENVIRON_PREFIX)

    SITE_ID = 1

    # Application definition
    PLATFORM_INSTALLED_APPS = [

        'material.theme.amber',

        'material',
        'material.frontend',
        'material.admin',

        'viewflow',
        'viewflow.frontend',

        'django.contrib.admin',
        'django.contrib.admindocs',
        'django.contrib.auth',
        'django.contrib.contenttypes',
        'django.contrib.sessions',
        'django.contrib.sites',
        'django.contrib.flatpages',
        'django.contrib.humanize',
        'django.contrib.redirects',
        'django.contrib.messages',
        'django.contrib.staticfiles',
        'django.contrib.sitemaps',
        'corsheaders',
        'rest_framework',
        'rest_framework.authtoken',
        #'django_node_assets',
        'address',

        'phonenumber_field',
        'avatar',

    ]

    @property
    def CORGY_MODULES(self):
        return [
            'commons',
            'masterdata',
            'customers',
            'labor',
            'corgy_common',
            #'corgy_accounts',
            #'corgy_mdm',
            #'corgy_labor',
            #'corgy_worksheet',
            #'frontend',

        ]

    @property
    def INSTALLED_APPS(self):
        return self.PLATFORM_INSTALLED_APPS + self.CORGY_MODULES

    MIDDLEWARE = [
        'django.middleware.security.SecurityMiddleware',
        'django.contrib.sessions.middleware.SessionMiddleware',
        'django.middleware.locale.LocaleMiddleware',
        'django.middleware.cache.UpdateCacheMiddleware',
        'corsheaders.middleware.CorsMiddleware',
        'django.middleware.csrf.CsrfViewMiddleware',
        'django.middleware.common.CommonMiddleware',
        'corsheaders.middleware.CorsPostCsrfMiddleware',
        'django.middleware.cache.FetchFromCacheMiddleware',
        'django.contrib.sites.middleware.CurrentSiteMiddleware',
        'django.contrib.auth.middleware.AuthenticationMiddleware',
        'django.contrib.messages.middleware.MessageMiddleware',
        'django.middleware.clickjacking.XFrameOptionsMiddleware',
        'django.contrib.admindocs.middleware.XViewMiddleware',
        'django.contrib.flatpages.middleware.FlatpageFallbackMiddleware',
        'django.contrib.redirects.middleware.RedirectFallbackMiddleware',
    ]

    ROOT_URLCONF = 'corgy_erp.urls'

    #SESSION_ENGINE = 'django.contrib.sessions.backends.cached_db'

    TEMPLATES = [
        {
            'BACKEND': 'django.template.backends.django.DjangoTemplates',
            'DIRS': [
                os.path.join(BASE_DIR, 'corgy_erp', 'templates'),
                os.path.join(BASE_DIR, 'templates'),
            ],
            'APP_DIRS': True,
            'OPTIONS': {
                'libraries': {
                    'corgy.erp.version': 'corgy_erp.templatetags.version',
                    'corgy.verbose': 'corgy_erp.templatetags.verbose',
                },
                'context_processors': [
                    'django.template.context_processors.debug',
                    'django.template.context_processors.request',
                    'django.contrib.auth.context_processors.auth',
                    'django.template.context_processors.i18n',
                    'django.template.context_processors.media',
                    'django.template.context_processors.static',
                    'django.template.context_processors.tz',
                    'django.contrib.messages.context_processors.messages',
                ],
            },
        },
    ]

    WSGI_APPLICATION = 'corgy_erp.wsgi.application'

    # Database
    # https://docs.djangoproject.com/en/3.0/ref/settings/#databases

    DATABASES = {
        'default': {
            'ENGINE': 'django.db.backends.sqlite3',
            'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
        }
    }

    @property
    def FIXTURE_DIRS(self):
        return [os.path.join(self.BASE_DIR, module_name) for module_name in self.CORGY_MODULES]

    # Password validation
    # https://docs.djangoproject.com/en/3.0/ref/settings/#auth-password-validators

    AUTH_PASSWORD_VALIDATORS = [
        {
            'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
        },
        {
            'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
        },
        {
            'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
        },
        {
            'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
        },
    ]

    ADMINS = [('lordoftheflies', 'laszlo.hegedus@cherubits.hu')]
    MANAGERS = [('lordoftheflies', 'laszlo.hegedus@cherubits.hu')]
    CSRF_TRUSTED_ORIGINS = [
        'cherubits.hu',
        '*.cherubits.hu',
    ]
    CORS_ORIGIN_WHITELIST = [
        "https://example.com",
        "https://cherubits.hu",
        "https://corgy.cherubits.hu",
        "https://corgy-staging.cherubits.hu",
        "http://localhost:8001",
        "http://localhost:8000",
    ]
    DEFAULT_FROM_EMAIL = 'webmaster@cherubits.hu'
    EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
    EMAIL_HOST = values.Value('aspmx.l.google.com')
    EMAIL_HOST_USER = values.Value('laszlo.hegedus@cherubits.hu')
    EMAIL_HOST_PASSWORD = values.Value('Apocalypse43254325')
    EMAIL_PORT = values.IntegerValue(587)
    EMAIL_USE_TLS = True
    EMAIL_SUBJECT_PREFIX = '[cherubits-corgy]'
    EMAIL_USE_LOCALTIME = True

    # FILE_UPLOAD_HANDLERS = [
    #   'django.core.files.uploadhandler.MemoryFileUploadHandler',
    #   'django.core.files.uploadhandler.TemporaryFileUploadHandler',
    # ]
    # FILE_UPLOAD_MAX_MEMORY_SIZE = ''
    # FILE_UPLOAD_DIRECTORY_PERMISSIONS = ''
    # FILE_UPLOAD_PERMISSIONS = ''
    # FILE_UPLOAD_TEMP_DIR = ''

    AUTH_USER_MODEL = 'auth.User'
    LOGIN_REDIRECT_URL = '/accounts/profile/'
    LOGIN_URL = '/accounts/login/'
    LOGOUT_REDIRECT_URL = None

    # Internationalization
    # https://docs.djangoproject.com/en/3.0/topics/i18n/

    LANGUAGE_CODE = values.Value('en-us', environ_prefix=ENVIRON_PREFIX)
    TIME_ZONE = values.Value('Europe/Budapest', environ_prefix=ENVIRON_PREFIX)
    USE_I18N = values.BooleanValue(True, environ_prefix=ENVIRON_PREFIX)
    USE_L10N = values.BooleanValue(True, environ_prefix=ENVIRON_PREFIX)
    USE_TZ = values.BooleanValue(True, environ_prefix=ENVIRON_PREFIX)
    PHONENUMBER_DEFAULT_REGION = 'HU'

    LANGUAGES = (
        ('en', _('English')),
        ('hu', _('Hungarian')),
    )

    LOCALE_PATHS = [
        os.path.join(BASE_DIR, 'corgy_erp', 'locale')
    ]

    # configuration for a python-memcached based backend with an object size limit of 2MB
    # CACHES = {
    #     'default': {
    #         'BACKEND': 'django.core.cache.backends.memcached.MemcachedCache',
    #         'LOCATION': '127.0.0.1:11211',
    #     },
    #     'OPTIONS': {
    #         'server_max_value_length': 1024 * 1024 * 2,
    #     },
    # }

    # Static files (CSS, JavaScript, Images)
    # https://docs.djangoproject.com/en/3.0/howto/static-files/

    STATIC_URL = '/static/'
    STATIC_ROOT = values.PathValue(default=os.path.join(BASE_DIR, 'static'), environ_prefix=ENVIRON_PREFIX)
    STATICFILES_FINDERS = [
        'django.contrib.staticfiles.finders.FileSystemFinder',
        'django.contrib.staticfiles.finders.AppDirectoriesFinder',
        #'django_node_assets.finders.NodeModulesFinder',
        #'compressor.finders.CompressorFinder',
    ]
    STATICFILES_DIRS = [
        os.path.join(BASE_DIR, 'frontend', 'static'),
        os.path.join(BASE_DIR, 'corgy_erp', 'static'),
    ]

    COLORS = "light;error=red;warning=yellow;notice=magenta"

    # NODE_MODULES_ROOT = values.PathValue(default=os.path.join(BASE_DIR, 'node_modules'), environ_prefix=ENVIRON_PREFIX)
    # NODE_PACKAGE_JSON = os.path.join(BASE_DIR, 'frontend', 'package.json')

    # Media files

    MEDIA_URL = '/media/'
    MEDIA_ROOT = values.PathValue(default=os.path.join(BASE_DIR, 'media'), environ_prefix=ENVIRON_PREFIX)


    # Error diagnosing

    SENTRY_DSN = values.URLValue("https://63e1e6dd28b64a2d86cd91c70236d69c@o361028.ingest.sentry.io/5241305")

    LOGGING = {
        'version': 1,
        'disable_existing_loggers': False,
        'handlers': {
            'console': {
                'class': 'logging.StreamHandler',
            },
        },
        'root': {
            'handlers': ['console'],
            'level': 'INFO',
        },
    }

    REST_FRAMEWORK = {
        'DEFAULT_PAGINATION_CLASS': 'rest_framework.pagination.PageNumberPagination',
        'PAGE_SIZE': 20,
        'DEFAULT_AUTHENTICATION_CLASSES': [
            'rest_framework.authentication.BasicAuthentication',
            'rest_framework.authentication.SessionAuthentication',
        ]
    }

    CELERY_TASK_ALWAYS_EAGER = True
    CELERY_BROKER_URL = "redis://localhost:6379"
    CELERY_RESULT_BACKEND = "redis://localhost:6379"

    AVATAR_CACHE_ENABLED = False
    AVATAR_DEFAULT_SIZE = 64
    AVATAR_PROVIDERS = (
        'avatar.providers.PrimaryAvatarProvider',
        'avatar.providers.GravatarAvatarProvider',
        'avatar.providers.DefaultAvatarProvider',
    )
    AVATAR_GRAVATAR_DEFAULT = 'retro'
    AVATAR_GRAVATAR_FORCEDEFAULT = False
    AVATAR_GRAVATAR_FIELD = 'email'
    AVATAR_GRAVATAR_BASE_URL = 'https://secure.gravatar.com/avatar/'

class Development(Base):

    DATABASES = values.DatabaseURLValue(
        default='sqlite:///%s/development.sqlite3' % str(Base.BASE_DIR),
        environ_prefix=ENVIRON_PREFIX
    )

    @classmethod
    def post_setup(cls):
        super(Development, cls).post_setup()
        print("Base directory: %s" % cls.BASE_DIR)
        print("Static root: %s" % cls.STATIC_ROOT)
        print("Media root: %s" % cls.MEDIA_ROOT)
        print("Database connection: %s" % cls.DATABASES['default']['NAME'])


class Staging(Base):

    DATABASES = values.DatabaseURLValue(
        default='sqlite:///%s/staging.sqlite3' % str(Base.BASE_DIR),
        environ_prefix=ENVIRON_PREFIX
    )

    @classmethod
    def post_setup(cls):
        super(Production, cls).post_setup()

        sentry_sdk.init(
            dsn=cls.SENTRY_DSN,
            server_name='gitlab.com',
            environment='staging',
            debug=True,
            integrations=[
                DjangoIntegration(),
            ],
            # If you wish to associate users to errors (assuming you are using
            # django.contrib.auth) you may enable sending PII data.
            send_default_pii=True
        )

class Production(Base):
    SECRET_KEY = '0123456789'

    # Build paths inside the project like this: os.path.join(BASE_DIR, ...)
    BASE_DIR = os.path.join('/home', 'corgy')

    CELERY_TASK_ALWAYS_EAGER = False

    DATABASES = values.DatabaseURLValue(
        default='postgres://corgy:qwe123@localhost:5432/corgy_database',
        environ_prefix=ENVIRON_PREFIX
    )

    @classmethod
    def post_setup(cls):
        super(Production, cls).post_setup()

        print("Base directory: %s" % cls.BASE_DIR)
        print("Static root: %s" % cls.STATIC_ROOT)
        print("Media root: %s" % cls.MEDIA_ROOT)
        print("Database connection: %s" % cls.DATABASES['default']['NAME'])

        from .version import __version__ as release_version

        sentry_sdk.init(
            dsn=cls.SENTRY_DSN,
            server_name='corgy.cherubits.hu',
            environment='production',
            release='corgy_erp@%s' % release_version,
            debug=False,
            integrations=[
                DjangoIntegration(),
            ],
            # If you wish to associate users to errors (assuming you are using
            # django.contrib.auth) you may enable sending PII data.
            send_default_pii=True
        )