# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_allauth_webauthn', 'django_allauth_webauthn.migrations']

package_data = \
{'': ['*'], 'django_allauth_webauthn': ['templates/django_allauth_webauthn/*']}

install_requires = \
['Django>=3.2.7,<4.0.0',
 'django-allauth>=0.45.0,<0.46.0',
 'webauthn>=0.4.7,<0.5.0']

setup_kwargs = {
    'name': 'django-allauth-webauthn',
    'version': '0.2.0',
    'description': 'Webauthn-based two-factor authentication for Django allauth',
    'long_description': ".. image:: https://codecov.io/gh/CyberDeck/django-allauth-webauthn/branch/master/graph/badge.svg?token=SANFSR1SYD\n    :target: https://codecov.io/gh/CyberDeck/django-allauth-webauthn\n\nWelcome to django-allauth-webauthn!\n===================================\n\n``django-allauth-webauthn`` adds `two-factor authentication`_ by using the `webauthn`_ standard to `django-allauth`_.\ndjango-allauth is a set of `Django`_ applications which help with authentication, registration, and other account management tasks.\n\nUsing the `webauthn`_ standard for the second authentication factor allows for a variety of authentication schemes on the client side.\nThe user may authenticate by using a roaming hardware token (e.g. a USB key or Bluetooth Low Energy device) or the operating system may provide the authentication functionality (e.g. Windows Hello).\n\n``django-allauth-webauthn`` does not implement the `webauthn`_ standard to allow for *password-less* logins.\nIt allows to authenticate a user *after* the usual login scheme against a pre-registered security token.\nThe user may pre-register an arbitrary amount of tokens.\n\nSource code\n    http://github.com/cyberdeck/django-allauth-webauthn\nDocumentation\n    https://django-allauth-webauthn.readthedocs.io/\n\nMain Feature\n------------\n\nAdds `webauthn`_-based `two-factor authentication`_ views and workflow to `django-allauth`_.\n\nCompatibility\n-------------\n\n``django-allauth-webauthn`` was actively developed against `django-allauth`_ 0.45 using `Django`_ 3.2 and Python 3.8.\n\nHowever, it includes exceptional testing aiming for 100% coverage and thus, you may test it easily against your version requirements.\nIf you need to patch it due to compatibility reasons I would love to see you contributing a *pull request*.\n\nWhere does it come from?\n------------------------\n\n``django-allauth-webauthn`` was created from scratch but it borrows a lot of ingredients from `django-allauth-2fa`_ and `django-webauthin`_.\nBoth packages are exceptionally useful but does not included the feature to allow for a `webauthn`_-based `two-factor authentication`_ out of the box.\n\nContributing\n------------\n\n``django-allauth-webauthn`` was initially developed by H. Gregor Molter due to the lack of other suitable `webauthn`_-based `two-factor authentication`_ packages.\nPlease feel free to contribute if you find ``django-allauth-webauthn`` useful!\n\n1. Check for open issues or open a new issue to start a discussion around a bug or your special feature request.\n2. For the `repository`_ on GitHub and start to develop on the **master** branch or a custom branch derived from the master branch.\n3. Write one or multiple test(s) to allow for validation that the bug was fixed or that your special feature works as expected without any negative impact on the behavior of the other functionality.\n4. Before submitting your patch please thoroughly check your contribution by executing the pre-commit script.\n5. Send a pull request to get your changes merged and published.\n\n.. _repository: http://github.com/cyberdeck/django-allauth-webauthn/\n\nDeveloping\n**********\n\n``django-allauth-webauthn`` make heavy use of the `poetry`_ Python packaging and dependency manager and the `pre-commit`_ framework.\n\nAfter you forked (and branched) ``django-allauth-webauthn`` please install all development dependencies with `poetry`_:\n\n.. code-block:: bash\n\n    $ poetry install\n\n`poetry`_ will install all needed development dependencies in a virtual environment for you.\nAfterwards install the `pre-commit`_ hooks by running:\n\n.. code-block:: bash\n\n    $ poetry run pre-commit install\n\nThe pre-commit hooks will be executed automatically prior committing to the Git repository.\nThere are hooks for source code styling (e.g. import reordering) and it is ensured that all tests may be executed successfully and that no obvious type checking issues are included.\n\nTo execute these hooks manually (i.e. without performing a commit) execute the following:\n\n.. code-block:: bash\n\n    $ poetry run pre-commit run --all-files\n\n.. _poetry: https://python-poetry.org/\n.. _pre-commit: https://pre-commit.com/\n\nTesting\n*******\n\nTests can be run using the standard Django testing facility by executing:\n\n.. code-block:: bash\n\n    $ poetry run python manage.py test\n\nCoverage\n********\n\nDuring test execution a coverage report can be created with:\n\n.. code-block:: bash\n\n    $ poetry run coverage run manage.py test\n\nTo view the coverage report on the command line you have to execute:\n\n.. code-block:: bash\n\n    $ poetry run coverage report -m\n\nor you can generate an HTML report for more eye candy:\n\n.. code-block:: bash\n\n    $ poetry run coverage html\n\nThe resulting HTML report will be stored in the ``coverage_html`` folder.\n\nDemo Project\n************\n\nA simple demo Django project is included within the *demo* folder and may be run by:\n\n.. code-block:: bash\n\n    $ cd demo\n    # Migrate the demo database first (only needed once)\n    $ poetry run python manage.py migrate\n    # Run the SSL demo server (a self-signed certificate and private key is created during first run)\n    $ poetry run python manage.py runserver_plus --cert test.crt\n\n.. note::\n\n    The `webauthn`_ technology requires you to run your test server over *https*.\n    Otherwise the registration of security tokens or authentication cannot be executed successfully.\n    Some browser are a little bit piggy about self-signed certificates on **127.0.0.1**.\n    Please use at least https://localhost:8000/ to access the demo server and consult the web about your browser's behavior before submitting an issue!\n\nThe demo app allows you to register security tokens to a logged in user.\nIf a user has at least a single security token registered, she will be asked to authenticate with this token during sign in.\nSecurity tokens may be renamed or deleted. All in one, it demonstrates the basic workflow for `webauthn`_-based `two-factor authentication`_.\n\n.. note::\n\n    If you do not have a security token at hand or if you hesitate to use your super-secret token during development, you may `emulate authenticators`_ with the Chrome browser.\n\n.. _emulate authenticators: https://developer.chrome.com/docs/devtools/webauthn/\n\n.. _two-factor authentication: https://en.wikipedia.org/wiki/Multi-factor_authentication\n.. _webauthn: https://en.wikipedia.org/wiki/WebAuthn\n.. _django-allauth: https://github.com/pennersr/django-allauth/\n.. _django-allauth-2fa: https://github.com/valohai/django-allauth-2fa/\n.. _django-webauthin: https://gitlab.com/stavros/django-webauthin/\n.. _Django: https://www.djangoproject.com/\n",
    'author': 'H. Gregor Molter',
    'author_email': 'gregor.molter@secretlab.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cyberdeck/django-allauth-webauthn',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
