





# Model Card for train and eval model

## Model Details

### Version

name: 0.3  

date: 2020-01-01  

diff: Updated dataset.  

### Owners

* bar, bar@xyz.com


### Licenses

* Apache 2.0

### References

* [https://my_model.xyz.com](https://my_model.xyz.com)
* [https://example.com](https://example.com)


## Model Parameters

### Model Architecture

knn

### Input Format

32-char-len-text

### Output Format

64-char-len-text


## Considerations

### Users

* Testers


### Use Cases

* Testing


### Limitations

* This model has no limitations


### Tradeoffs

* no tradeoffs


### Ethical Considerations

* Risk: Bugs
  * Mitigation Strategy: Unit tests

* Risk: Broken edge cases
  * Mitigation Strategy: Test coverage

## Graphics
  
### train graphic
<img src="data:image/jpeg;base64,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">
  
### eval graphic
<img src="data:image/jpeg;base64,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">


  
### analysis graphic
<img src="data:image/jpeg;base64,iVBORw0KGgoAAAANSUhEUgAAAsIAAAGKCAYAAAAG8SdFAAAMYmlDQ1BJQ0MgUHJvZmlsZQAASImVVwdYU8kWnltSSWiBCEgJvYkiNYCUEFoEAamCqIQkkFBiTAgqdnRRwbWLCKgruiriomsBxIaIa10Uu2tZLKisrIur2FB5ExLQ1Ve+d75v7vw5c+Y/JTP3zgCg08GXyXJRXQDypPnyuPBg1oSUVBbpEaAAMqACa4DyBQoZJzY2CkAZ7P8pr68DRNVfcVFxfTv+X0VfKFIIAEDSIM4QKgR5EDcDgBcJZPJ8AIghUG89PV+mwmKIDeQwQIhnq3CWGq9U4Qw13jZgkxDHhbgRADKNz5dnAaDdCvWsAkEW5NF+BLGrVCiRAqBjAHGAQMwXQpwA8Yi8vKkqPB9iB2gvg3gnxOyMLziz/sGfMcTP52cNYXVeA0IOkShkufyZ/2dp/rfk5SoHfdjBRhPLI+JU+cMa3syZGqnCNIi7pRnRMapaQ/xWIlTXHQCUKlZGJKrtUVOBggvrB5gQuwr5IZEQm0IcJs2NjtLoMzIlYTyI4WpBZ0jyeQmauUtEitB4DWeVfGpczCDOlHM5mrl1fPmAX5V9qzInkaPhvykW8Qb5XxWKE5IhpgKAUQskSdEQa0NsoMiJj1TbYFaFYm70oI1cGaeK3wZitkgaHqzmx9Iy5WFxGntZnmIwX6xYLOFFa3B5vjghQl0fbJeAPxC/EcT1IikncZBHpJgQNZiLUBQSqs4daxNJEzX5Yvdk+cFxmrk9stxYjT1OFuWGq/RWEJsoCuI1c/Ex+XBxqvnxKFl+bII6Tjw9mz82Vh0PXgCiABeEABZQwpYBpoJsIGnrbuiGv9QjYYAP5CALiICLRjM4I3lgRAqf8aAQ/AmRCCiG5gUPjIpAAdR/HNKqny4gc2C0YGBGDngMcR6IBLnwt3JglnTIWxJ4BDWSb7wLYKy5sKnGvtVxoCZKo1EO8rJ0Bi2JocQQYgQxjOiIm+ABuB8eBZ9BsLnhbNxnMNrP9oTHhHbCA8I1Qgfh1hRJkfyrWMaBDsgfpsk448uMcTvI6YkH4/6QHTLjTNwEuOAe0A8HD4SePaGWq4lblTvr3+Q5lMEXNdfYUVwpKGUYJYji8PVMbSdtzyEWVUW/rI861oyhqnKHRr72z/2izkLYR35tiS3B9mOnsRPYWewI1gBY2HGsEbuAHVXhoTX0aGANDXqLG4gnB/JIvvHH1/hUVVLhWuva5fpBMwbyRTPyVRuMO1U2Uy7JEuezOPArIGLxpIKRI1hurm6uAKi+KerX1EvmwLcCYZ77rFu4CQD/A/39/Yc/6yKbANhfCrf5jc86+znwdXACgDOVAqW8QK3DVQ8CfBvowB1lDMzhF8sBZuQGvIAfCAKhYCyIAQkgBUyGdRbD9SwH08FssAAUg1KwEqwDFWAz2Ap2gp/APtAAjoAT4BdwHlwC18BtuH46wTPQA16DPgRBSAgdYSDGiAViizgjbggbCUBCkSgkDklB0pEsRIookdnIQqQUWY1UIFuQGuRn5BByAjmLtCO3kPtIF/I38h7FUBpqgJqhdugolI1y0Eg0AZ2EZqHT0EJ0EbocLUer0d1oPXoCPY9eQzvQZ2gvBjAtjIlZYi4YG+NiMVgqlonJsblYCVaGVWN1WBP8p69gHVg39g4n4gychbvANRyBJ+ICfBo+F1+GV+A78Xq8Fb+C38d78E8EOsGU4EzwJfAIEwhZhOmEYkIZYTvhIOEU3E2dhNdEIpFJtCd6w92YQswmziIuI24k7iE2E9uJD4m9JBLJmORM8ifFkPikfFIxaQNpN+k46TKpk/SWrEW2ILuRw8ipZCm5iFxG3kU+Rr5MfkLuo+hSbCm+lBiKkDKTsoKyjdJEuUjppPRR9aj2VH9qAjWbuoBaTq2jnqLeob7U0tKy0vLRGq8l0ZqvVa61V+uM1n2tdzR9mhONS0ujKWnLaTtozbRbtJd0Ot2OHkRPpefTl9Nr6Cfp9+hvtRnaI7V52kLtedqV2vXal7Wf61B0bHU4OpN1CnXKdPbrXNTp1qXo2ulydfm6c3UrdQ/p3tDt1WPojdaL0cvTW6a3S++s3lN9kr6dfqi+UH+R/lb9k/oPGRjDmsFlCBgLGdsYpxidBkQDewOeQbZBqcFPBm0GPYb6hh6GSYYzDCsNjxp2MDGmHZPHzGWuYO5jXme+H2Y2jDNMNGzpsLphl4e9MRpuFGQkMiox2mN0zei9Mcs41DjHeJVxg/FdE9zEyWS8yXSTTSanTLqHGwz3Gy4YXjJ83/DfTFFTJ9M401mmW00vmPaamZuFm8nMNpidNOs2Z5oHmWebrzU/Zt5lwbAIsJBYrLU4bvEHy5DFYeWyylmtrB5LU8sIS6XlFss2yz4re6tEqyKrPVZ3ranWbOtM67XWLdY9NhY242xm29Ta/GZLsWXbim3X2562fWNnb5dst9iuwe6pvZE9z77Qvtb+jgPdIdBhmkO1w1VHoiPbMcdxo+MlJ9TJ00nsVOl00Rl19nKWOG90bh9BGOEzQjqiesQNF5oLx6XApdbl/kjmyKiRRSMbRj4fZTMqddSqUadHfXL1dM113eZ6e7T+6LGji0Y3jf7bzclN4FbpdtWd7h7mPs+90f2Fh7OHyGOTx01Phuc4z8WeLZ4fvby95F51Xl3eNt7p3lXeN9gG7Fj2MvYZH4JPsM88nyM+73y9fPN99/n+5efil+O3y+/pGPsxojHbxjz0t/Ln+2/x7whgBaQH/BDQEWgZyA+sDnwQZB0kDNoe9ITjyMnm7OY8D3YNlgcfDH7D9eXO4TaHYCHhISUhbaH6oYmhFaH3wqzCssJqw3rCPcNnhTdHECIiI1ZF3OCZ8QS8Gl7PWO+xc8a2RtIi4yMrIh9EOUXJo5rGoePGjlsz7k60bbQ0uiEGxPBi1sTcjbWPnRZ7eDxxfOz4yvGP40bHzY47Hc+InxK/K/51QnDCioTbiQ6JysSWJJ2ktKSapDfJIcmrkzsmjJowZ8L5FJMUSUpjKik1KXV7au/E0InrJnameaYVp12fZD9pxqSzk00m504+OkVnCn/K/nRCenL6rvQP/Bh+Nb83g5dRldEj4ArWC54Jg4RrhV0if9Fq0ZNM/8zVmU+z/LPWZHWJA8Vl4m4JV1IheZEdkb05+01OTM6OnP7c5Nw9eeS89LxDUn1pjrR1qvnUGVPbZc6yYlnHNN9p66b1yCPl2xWIYpKiMd8AHt4vKB2U3ynvFwQUVBa8nZ40ff8MvRnSGRdmOs1cOvNJYVjhj7PwWYJZLbMtZy+YfX8OZ86WucjcjLkt86znLZrXOT98/s4F1AU5C34tci1aXfRqYfLCpkVmi+Yvevhd+He1xdrF8uIbi/0Wb16CL5EsaVvqvnTD0k8lwpJzpa6lZaUflgmWnft+9Pfl3/cvz1zetsJrxaaVxJXSlddXBa7auVpvdeHqh2vGralfy1pbsvbVuinrzpZ5lG1eT12vXN9RHlXeuMFmw8oNHyrEFdcqgyv3VJlWLa16s1G48fKmoE11m802l25+/4Pkh5tbwrfUV9tVl20lbi3Y+nhb0rbTP7J/rNlusr10+8cd0h0dO+N2ttZ419TsMt21ohatVdZ27U7bfemnkJ8a61zqtuxh7indC/Yq9/7xc/rP1/dF7mvZz95fd8D2QNVBxsGSeqR+Zn1Pg7ihozGlsf3Q2EMtTX5NBw+PPLzjiOWRyqOGR1ccox5bdKz/eOHx3mZZc/eJrBMPW6a03D454eTV1vGtbaciT535JeyXk6c5p4+f8T9z5Kzv2UPn2Ocaznudr7/geeHgr56/Hmzzaqu/6H2x8ZLPpab2Me3HLgdePnEl5MovV3lXz1+LvtZ+PfH6zRtpNzpuCm8+vZV768VvBb/13Z5/h3Cn5K7u3bJ7pveqf3f8fU+HV8fR+yH3LzyIf3D7oeDhs0eKRx86Fz2mPy57YvGk5qnb0yNdYV2X/pj4R+cz2bO+7uI/9f6seu7w/MBfQX9d6JnQ0/lC/qL/72UvjV/ueOXxqqU3tvfe67zXfW9K3hq/3fmO/e70++T3T/qmfyB9KP/o+LHpU+SnO/15/f0yvpw/cBTAYEMzMwH4ewcA9BQAGJfg+WGi+s43IIj6njqAwH/C6nvhgHgBUAc71XGd2wzAXtjsgiA37FVH9YQggLq7DzWNKDLd3dRcNHjjIbzt739pBgAJnmc+yvv7+zb293+Ed1TsFgDN09R3TZUQ4d3gB1cVumyxH3wt6nvoFzl+3QNVBB7g6/5f57aJssclDwAAAACKZVhJZk1NACoAAAAIAAQBGgAFAAAAAQAAAD4BGwAFAAAAAQAAAEYBKAADAAAAAQACAACHaQAEAAAAAQAAAE4AAAAAAAAAkAAAAAEAAACQAAAAAQADkoYABwAAABIAAAB4oAIABAAAAAEAAALCoAMABAAAAAEAAAGKAAAAAEFTQ0lJAAAAU2NyZWVuc2hvdPn0pnYAAAAJcEhZcwAAFiUAABYlAUlSJPAAAAHWaVRYdFhNTDpjb20uYWRvYmUueG1wAAAAAAA8eDp4bXBtZXRhIHhtbG5zOng9ImFkb2JlOm5zOm1ldGEvIiB4OnhtcHRrPSJYTVAgQ29yZSA1LjQuMCI+CiAgIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOmV4aWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vZXhpZi8xLjAvIj4KICAgICAgICAgPGV4aWY6UGl4ZWxYRGltZW5zaW9uPjcwNjwvZXhpZjpQaXhlbFhEaW1lbnNpb24+CiAgICAgICAgIDxleGlmOlVzZXJDb21tZW50PlNjcmVlbnNob3Q8L2V4aWY6VXNlckNvbW1lbnQ+CiAgICAgICAgIDxleGlmOlBpeGVsWURpbWVuc2lvbj4zOTQ8L2V4aWY6UGl4ZWxZRGltZW5zaW9uPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4Kgnnq7AAAABxpRE9UAAAAAgAAAAAAAADFAAAAKAAAAMUAAADFAABwiUCXllsAAEAASURBVHgB7N1pfx3Hde/7wjwQAAmCFEVSlDhosgZrsHPsHCfHTm5uHuS+gLzSPDn2sWM7nzjHQ6x5JCmOEimO4ARwAm59C1jUJgSQ4AAQIFZJze5dXbVq1b96o3+9dnV312xNJVMqkAqkAgsUmJmZKbdv3y7xJ6Krq6v09PQUa0umVCAVeLoU8F33vbf4jnd3d7fl6epl9iYVuFuBrgThuwXJT6lAKpAKpAKpQCqQCqQCG0OBBOGNMc7Zy1QgFUgFUoFUIBVIBVKBBQokCC8QJD+mAqlAKpAKpAKpQCqQCmwMBRKEN8Y4Zy9TgVQgFUgFUoFUIBVIBRYokCC8QJD8mAqkAqnAvRSIm4ncWBQ3FC12A2HnjUdhL282DCU27tpxETehxnHjpjTbmVKBVGD1FUgQXn3Ns8VUIBVYpwqAmFu3bpXp6el2Z31vb2/p6+sr1mCmM4Gd69evt/Lg2f7BwcFWNgCos3xubwwFOo8fx0QcQy6SMqUCqcDqK5AgvPqaZ4upQCqwDhWICO/Vq1fLmTNnGuCOjIyUTZs2tQUQd6YbN26Ua9euNWgGP4BnbGysDAwMNCjOCGCnWhtn2zFx9uzZ4vhwYTQ8PFwcR/39/XeJ4OLp5s2bdxafIwVAqxMXYXk8hTq5TgUeTIEE4QfTK0unAqnABlUAiIjyfvvtt+XTTz8tU1NT5dlnny3PPPNM2b59ewOakAY0iwZfvHixAGfQA1q2bdvWoDmmSET5XG8MBRwX586dK1988UW7SNqyZUuZmJhox5ALqs7k+Ll8+XKZnJxsi8/qg2DHEnjeunVrW7sIy4hyp3q5nQosX4EE4eVrlSVTgVRgAysAhEV2jx8/Xv74xz+WK1eulOeff77s3r277Ny5s4yOjt41Zxj8ghgRQBADXkDP0NDQXfNBwY0U0yWATkT37NOupbOcMgvL2d+5xFCFXeuFddjtbDvajbqd67B9P3/ChvKdZX0OHzr9WKpM2OFDZ934LC9SlJXXudhv32L7I38pLTv9irKx7vSn07Y6kaJs7Jev3jfffFP++te/Nsh1AeXYee6559qvBVHXGgQre+rUqXL69Ol2DPk1QQSYHcebumxs3ry5/dIgfzG/Q+/wif2FZeXF/iivTJSzjjKxP8q3HflPKrBOFUgQXqcDl26nAqnA6ioAMIDw0aNHy3/+5382yAUwnSAsKgdUQC9wMJcYEKtnn5/BQYSfvEWXpYAN+SJ7MefYvvhpnI2ALHainLXEljYstpVlF6iwy6dYInKoHPvKyYtFncVS9F8d/oT/7Otv+OQzm/Yrpzy/oh3llNeePPtCI22EDvaHL/J9VleeOvIsPgccdvbfPok9dSU+WaJe+Mwf5diyj53OfsrvbJ/fnX6yrZ46M7O1D131QqWn6t5z99xx9U6ePFn+9Kc/lUuXLrVfFBw/e/bsaTDLjqSc6ROff/55+eqrr9rFF/t+gdBXF1h8jrr79u1rIK398Dv6yG9lY/z5zf7C8dGussrF9J3QwoWc8lEmgFx59jKlAutZgQTh9Tx66XsqkAqsmgIBBcDk97//fQMVEV4ROYufqoEB2B0fH2/wASACBgGDfT6bXmFqRYAdyAAgfh4X6bMoL5psaoXo4PXp6w2ylBNV1p5IoDYBtwi1qRja7AQ35dlSxxxl81Lt1/758+cb4GiPbwE4C0UFTgCLP9pp/szDEfvq8od90KU/yrLPf5+1yb4+mhKgHr+VC3s0Vp8tZSV56stXT3/5oJ98Cs2VAZf6ZVsK6GZLH+yL8eAPm+FPROrZZUcbfNM+X9nQT/WUYZv+UY9dgAqi+wf6y9DgUCuvnKR9CxD2i4KyIrpg9oUXXrgDwlFOFPjDDz8shw4dapFhdg4cONB8YUPfHX/qvvnmm00bPltozke21NNHmhpnn+mjTIyPPjpGYs6ycaSr/luU1b/ag9LfNzc+7MU40SRTKrBeFUgQXq8jl36nAqnAqioAFkAOEP7d735Xjh071mChEzDBAzgBLKADQMQCQMwRBkB/+ctfGoQADvk3b90sgwODra6oH7gBaUDFjXl+HlcPjIAyALZjx44iEgheLly4UL7++uty8ODBBpWAzQKA2JfUMZUDpAMXc1VFHAGV9sx15k8AaIgbYAaI+ALiQRpYBFud/rADjuQrw/658+dahJRd+1w08EM9Uc+wSSd+KUMDvtOcf+zxTX/1h219BrZ0oittjhw50vplnJTT14B88KdOQLR+8UFdds23NX50ZkcbyipHS+2zJ7FDd/1VT1v08GvB9PXpsmXzlrJ1YmvZvu27ueOhY4Cw8vrpVwV6GB8pytEZCJ84caIdQ/rxyiuvNGAFx3xQdteuXeVv/uZvmn+OE/Xo6uKCJnR3TDpetKUvLkD0z1xlxxjd4zimB5vylGHLBRatjcfg0GDZNrHtjj0XJyBa+UypwHpUIEF4PY5a+pwKpAKrrkCA8OHDh8tvf/vbBj0BEBHhBAuA6aWXXmoROgAHIMEVWBL9A36/+tWvGrD5SVx5tru6a4SyRtvA0RtvvNHy1QOsAOfihYvl2tS1BuPAA9iIBAIkZcAbcNKeSCP4AZVsgy7lXn755QZ+6rNprqr92gsYA3idKcAMFIKsWAKOQCd7APe1115rfoMwYA60rly9UjaPbW7t84dfQAvg0pI9umkH1NIDlNsGx/oD3ADn66+/3vIBp3p84i97ynz00UcN7GgNLGlpDQa1x+cA4YhGG7sf/OAHrU39AH6ffPJJs8MH9kE5/fgGLsEsaHbBw1cQCUzdRGnMjTOfjJE+S6GjuqZGGNuICIf2neX0T3+AMJ/ZcVw55lzw6AuQ19aPfvSj5h/N1XM8sE877fKPL+qzY5/5x4CaxvL0zQL2jSV97KeHi4hYaEQX2hpva5/pkSkVWI8KJAivx1FLn1OBVGDVFegE4d/85jcNJIADaBBps1+0GHAFgAEE4ASSbANfUbZ/+7d/awDy4x//uNUFEWBVlBmU/I//8T8aSIEYYAWELKAFSLthD5y9++67DSyBp7wPPvigQal8PmkTMH355ZdNLyAMRCPa9/777zeY0p6oKJvqLEz8AEYBkgGo4Q+/AeMPf/jDBmTgSaRRv0HYiy++2AAcoFq0QYf//u//bv0CjXSkJx+AKzgGa2zYFqlk3z6ABuT1W7t0BX3A3tpn/QeJ9DQ2xsE+a/AOFgElLQBi6EJfACrfhQbf+Aw6jZN+AXx27FOP37Shv7aAtWixfSKw0sOCsL6CZwCqX5ILAWnv3r1NW+3RjW+OE2NlzSf66SsdgKvxaBdWdR89+AfEXWgYlwBaZRwftA8dwTCIPvn1yTI2OtaOUz6wvdhx05zMf1KBNa5AgvAaH6B0LxVIBdaGAp0g/O///u8tUibKBk5AJDASkQUewEAEUTRSPSACFABHgDBg/od/+Ieyf//+BlkBhoDrf/7P/9nsgh/Q1gmeon6fffZZA8Cf/OQnDboBDWiUD3R+9rOftbZAjQghQFMG0PAL0IAkQMVXdoAbyNT+wgTiAFGAsG32LPwRCVXv7bffbvZBFJ/5L2Iq4mwNLrUN1LT9X//1X+3CAeACKtFIYKs9UCdiDEy1B5TZpyOA1V8XD8rTVRkgzD7gMyYirvbzJRZtGxN6f/zxx01fIAwEtWusgC6djA87+iGpR0/9pQX4jHEGnqaCgGZ+6k9Eo9V9WBDmC620DbzZESU2ViLkpks4how73/nhWAwQ1k/l6WAc1HPhQi++08iFSlwIqOsCA4D/4Q9/aGP16quvtv1xAWGf4+bv/u7v2kWECwF2M6UC61GBBOH1OGrpcyqQCqy6AkAECMTNcoAXBANI0CNyC4SBB+ADSaKYEkABSIDN9i9/+csGNP/4j//YIAZoifr93//7f1v5AFywDGjUAScgTrQVyIAPwAuOwIsyAbbmjIJefigP3PgLVtzwND013eYl1807UyxEscFsQF9zpP4TAKd9gAtMQWr4o13+ALG33nqrARJIBaTgUmS2MxIdoHWkTuUwV1ry0z4NOyOL/AaB9ARttHznnXfugDAA50OAMP07I7nsgTuJv+yxpQ5d5fFBn4EeX/kc0wbU/cUvftFAuBmZ/0d/OyPS9AK8jg3agEsg7NigiXGXQscHnRoREWFjSUt2RP/ZBcGmZ+irix6a8AGku0gIGJZHWxcc6rmQYAfkq2sxRUSiNW1MD/HLBz20YT99XFCwR58E4SZZ/rPOFUgQXucDmO6nAqnA6ijQCcJulgOWwBYIAwogJvIaIOwnZ1FMCTwFCIOMX//61w1S/+mf/qmBsDLgxmPZwIYpE8BMG8ANnABI+9QH40AYiABeYAd+ACgQMzUCIIMnNsBURFCBzfkL5xukHdh/oLXPf+0pb+lM+q1dIBkAKBLMHzAV/oBsoKp9wKwem4AQsAWU3guE9UnEl12amdIRfosW6xcdAbI2+OGCwxjQALwBQkAujz0XDyKiAfE+s0EH/QGyphYAbT4DSLDqc0Ts6RG6GA/ACf6BNNjUdzYtfiUQeXVh4XNMNdAny4OAsAsrFze014Zxiosm/aWpiK58yXGhrGORzvrquOAvnYwPOyLtfNlbAVhd67gRkKaLgbC2tK1dGhhb4+E7wHZOjWhDkP+sQwUShNfhoKXLqUAqsPoKBAiDJ5EyUTEQAgREzACCOZUgAhgAwsWmRtgPhEFFJwgDKyAssiiiKJp4pIIWoAEpbIpe+mleO8DDFIoAYQAXIAx4gLDyoAVksyUSaA0MAdu//Mu/NGgEOcA9YK9TXRDMBzbc5AVQ9UuEkY90+POf/9yqiESLHCoD3tkDhMBUe5L+2ccPEXC62Q/IwBWbtAZwNAGO0S/gpU+AV7tgTnvqstMJwgFogFdEHAjrB/vGjS76Iw+om7oBWvmuPIj+53/+5zZtwFjpi0V5NgHqe++917TUH5qIfJtmYKoCTdkLTR8UhF1QAWH9D/uAnf8B9Xz1Wbvsm5qhrAsw40lHdkwBAeXxdAnjD5aNoeNE/+PXC/mOJce5qSs+a5dmbEpgWbuOPccmuA7gbwXyn1RgHSmQILyOBitdTQVSgSenQICwqJuIcMAZ4AEEgBHcAT3QB4zAB0ADv8BVdBTgqQ+uflF/et9bo3EgBpx4vqzybtJSF4yAjgBh0wBEeIEa+HCTG0BRB9iBZMDsJ3CAwwYwkg+CzaH94ssvmu8ipv/6r/9a3nn7nQY1yi6WAoRBKTACoCAfRFnrj0g4EAKqgMrP52CKr4DJhYJ8bdDBwif+iKjqAx3BJ//V0S7gpLMIJqAEmXSjs3rKsasvdAeC9tPPmLDFB4AsKhoAZ4oBXfitHXOEATt7ysvXXqeOtNdnfTBeANV4iVrTBMSbqmJ+sv7Qho3FQFg9+ijHT9DueJECmOkDYEGvvtHHnODQ3IWJ48A+FwLaoQtQp4m+08KxRxf+A2F+6qPjxTiBW8elfOPiQoOtAHGa8dMxqKz9fKSF45w/NNFWplRgPSqQILweRy19TgVSgVVXAAiDpgBWYAhCpAABgAAoROiAjZ+mARvoARmAIiKRwOGnP/1pAyH1AI9IrzbMWVU+5nwCQu2DGfvBp0ioyK/oHz+0I0IIgNQHKfwCyRHhE4E9cvRImyMMnv7l//uX8srLrzSIXQpkot/8MwdXv7XPD+Bov88g1pQA7QaAmcIAusATiKIJ4ASuEnADXPpHKzoos7deHAA/sA/ktMuO/isDYvUN8GkvLkRiqoMIJ61pQRcgLYJr7LQjn990sQ2wXTiAPXAIMMEtXfWF73SmWcAfv4A8yGRbXXO+RU9t8zUgWF/5bQmAvh8IG0u2+WEMHVf6Zdz1gR3Azg4daKyvFvCqf44h4yRPfZF3kW/72HdxRNfoI83tp6e+u+gD5OoDbP0xJsaIvnSji7HIiLBRzrQeFUgQXo+jlj6nAqnAqisAYkCFOZieziBSCThACVABIqAK6Ikw2o6om3JgAYyAOIAIKmJuKtuABLBpQ4QQxMgDQtpSD1wBDiADtoAIMAIt9oMicKq+/crap322RXQBLbDz8/3f/u3f3rkBi6D8WJjkWcDq8WPHG4C1vk9du/OTuL7wY28HwCofc3nBJV+UAZz85ieYBFqim7ZpCaj5BrSUB2HsKEdnfQdu9AWAsdCNX3wR4QR19PLTPtgGjiCeX+pb+KQ94AcAjY/y/FGeVnyil/3hFxBkB4iCSWXV/fnPf35n7I13Zwodlb1XRFidO3pXP+KiQ+TVuFrTII5DY84/x598Wjtm9AO0yqcJ/yIyL8+xBbTjOOYvzYyPcXT8sUM7ZfSXxmyypRx76qhLz0ypwHpUIEF4PY5a+pwKpAKrrkCADOAUTQNowCwWIADugApQAAcgSiRNGfsBi23QJ4E4eWwrC3psgzOwIg/YgBD1gJsF2GgL7AITAAR4taUeUIuIpDy+HqnRVwBmG1CJbgZIAxw2oo8LxdWe9vly5fKVMnnpu7fcBVDyh9/6o+9ATD+Bmn5IfFKGPkArfNNvtvVBvn4px6Y8etuvPB9poJz92rOWr298jbq00DcXAvzQjvGTwm8++ZkfWLNFB2UtoTs79vPbWttAFAgDWzZFRj39AoQbEz52ptBWeXOT2XfRtHBqRNShmTLW6mpTv9iW9CkuHvinPxKNXIDRTX4cMzRyYaGP8tnVB20YK7rZF8evMvpFUzrYpg17ysU42ta2+plSgfWoQILwehy19DkVSAWeiAKABFiBDaABDHy2AAEACFjAis/K2Kecz+DCtvpSJzApBzYldpRXVh5QsT+Aw5otbdkOyIp25KsvH8iI7Pn53k/+8s013VujfvGTOsgEOuCIz51JO2CRr81uqTeM3bxxp0/aD9jid2xrm9/6qg98s48N9mwroz3tKqOPUUY59pQJG8r6rExnu3wMW/oXfoQGoS1/woZ97Kgba/UkZbTJL3WVDb21QytRUnOPQSKQFiHtvOmOfwuTuuqZUgFWwbPItznLwLIzhc/WEnvRL5/l8zH281GK4yuOhU6t1I/+qtc5PuoqG+OjPTaMSxwX/O/UwjHBXrTNRqZUYL0pkCC83kYs/U0FUoEnqgAYAAgWyWeLBB5i8Tn2WYMFi+2oCzwCIjrz2eisD1rChvywpVxn/Vap/iM/IMaUAjd0+bkfEIsKejybqDAgDahTTuTVZ0l7koifn79BmwimiGG0b39sL1zbFzpZh/986+z3UmWUs4QusV6qzWhvoR/qxRI6Kit1ltWWz1K0FeUj3z4RVG9Wc2Fx+ODhaqS0yPreemEBaEXjw67yC5MxcEHi4kPkm67mHYPpzhQ+WEtsLuZj7I+6US8+hy+xDhvK6V+MTWcbnWWinLWl045ylkypwHpWIEF4PY9e+p4KpAKpwBIKgBwRQ+BlHivQ9dnP+yLCcVObiLGb8swF9VN5gDCzwAcIixwrL3oJ9EQBNxoABRBenLzYLiqaZqdOl4H+gfLSyy+1KQ60NQXhXglIu2mPzuBXJNjFyf3q3ctm7ksFUoGHVyBB+OG1y5pPoQJOdplSgadBgQA3c0ndGOXnbXmAC7ABXAkc+5keEIMzP4V3Jj+nq2NurGiwn8MjYthZbiNs04+OYFZE17aLAiALamOqwL3+jtBXXdMvaGtRT5Q8UyrwNCrgV4S1nBKE1/LopG+rooCfBkXPnKA659ytSuPZSCqwggoEDDu2HecAFnB1RnTl2w/M4qfyTpc660S9tX5i6/T/cW/TKLRimz50iekeoc29YDimI8Q0g6jzuH1Ne6nAk1DA8RzHv+2Ym27++Vq8iE4QfhJHSba5phQAAXFXubuwRcV8WTOlAk+LAsBLCuCyjm0nrM5lsT5H+VjHSW6xshshL/TS19Aktq03uj40yLQxFej8u+LvDgj2a1JMAXJfQud3Zi2olCC8FkYhfXiiCgBfPx2bHxnPDfVlFeXJlAqsZwXipBRrfQlIs478WN+vr51171f2ad0fWsVaPx9Ul866nfWfVs2yXxtHgTi2/XLiqSR+KTFtyHQs9xgA4rUWFU4Q3jjHZ/Z0CQXMjQTAFo82chXr4fkxh3KJapmdCqQCqUAqkAqkAgsUAMMg2Fx6v7gKKnnyzL767HJrcLyWfnVNEF4wgPlx4ynQHodUH3IPhN1h76ccD8V3d7wU0Z6Np0z2OBVIBVKBVCAVWL4CINjil9Z4EY459W4o9cbNeHZ5gvDyNc2SqcCKKxAg7Evr7nnzmVy5esanlCC84kOQDaQCqUAqkAo8BQrE1Aj33TinmnYY59V4JXfcdLtWupsR4bUyEunHE1MgQDgeMeURUb6w5jRlSgVSgVQgFUgFUoEHUwAIu+8mYNh9NzE1IkH4wbTM0qnAiivQCcJ+zjGZP0F4xWXPBlKBVCAVSAWeUgUShJ/Sgc1uPZ0KJAg/neOavUoFUoFUIBV4MgokCD8Z3bPVVOChFEgQfijZslIqkAqkAqlAKrCoAgnCi8qSmanA2lQgQXhtjkt6lQqkAqlAKrA+FUgQXp/jll5vUAXuAuHpOkd4NOcIb9BDIbudCqQCqUAq8BgUSBB+DCKmiVRgtRToBOHpCsKjbpbbn0+NWC39s51UIBVIBVKBp0uBBOGnazyzN0+5AneB8PXpGhGee3za+Hg+Pu0pH/rsXiqQCqQCqcAKKJAgvAKipslUYKUUCBA+d+Z8uTI5VYYHR8u+vQfKls1AeLb+lykVSAVSgVQgFXj6FOju7io9/aX09HWV3rp099Q+dj16PxOEH13DtJAKrJoCAcKnjp8rZ45dLb2zI+W5nQfK5pHx9la5BOFVG4psKBVIBVKBVGC1FKgnt77BrjK0pbsMb+4um+q6b8grkqsDjwjDCcKrNYjZTirwGBRoIHziZDl+8Fw59uHlcvvScNk5fqCMDG5JEH4M+qaJVCAVSAVSgTWmgAhPXQbHusqWPb1lfE9PGd/VU4bGuktXd92XILzGBizdSQVWUIEA4cMfni2f/f5Smfp6qGzr31+GeyoI+0vR5S9GplQgFUgFUoFU4ClQYB6Cy0wpm7Z1lx1v9ZYdr9XlQF8Znagg3FOjwmD4EVJGhB9BvKyaCqy2Ag2Ej58sB987Uz76P5fK5SNDZWv3vjLUBYTrX4pHvDJe7f5ke6lAKpAKpAKpwJIKzFYSBsO3u8ros91l19/0ll1v9ZVdr/aVsWd66jzhBOEltcsdqcDTqEBEhA++d7Z8/OvJcvnoUJnoqSDcXUG4RoMtmVKBVCAVSAVSgadCgYgI3y5ldEcF4XcrBP+wt+x8JUH4qRjf7EQq8KAK3AXCv5ksV45VEO7dVwbnQXju0vlBrWb5VCAVSAVSgVRgDSoQsR0g/Ex32flOBeE3E4TX4EilS6nA6iiQILw6OmcrqUAqkAqkAmtAgQThuwaha7amu3LyQyqwwRRIEN5gA57dTQVSgVRgIysQ1JcR4XYUJAhv5C9D9r0pkCCcB0IqkAqkAqnAhlEgQfiuoU4QvkuO/LARFUgQ3oijnn1OBVKBVGCDKpAgfNfAJwjfJUd+2IgKJAhvxFHPPqcCqUAqsEoKBHhGc/d7JOdyy0e5+9mLdmMd9XJqRFMkQTgOjFxvWAUShDfs0GfHU4FUIBVYWQUCOhe2ci94XVhnqbKd5ZYqs7Bdn6NegnBTJ0F4sYMk8">



