





# Model Card for Fine-tuned MobileNetV2 Model for Cat vs. Dogs

## Model Details

### Overview
This model distinguishes cat and dog images. It uses the MobileNetV2 architecture (https://arxiv.org/abs/1801.04381) and is trained on the Cats vs Dogs dataset (https://www.tensorflow.org/datasets/catalog/cats_vs_dogs). This model performed with high accuracy on both Cat and Dog images. 

### Version

name: v1.0  

date: 08/28/2020  

### Owners

* Model Cards Team, model-cards@google.com


### Licenses

* Apache-2.0

### References

* [https://www.kaggle.com/c/dogs-vs-cats](https://www.kaggle.com/c/dogs-vs-cats)
* [https://arxiv.org/abs/1801.04381](https://arxiv.org/abs/1801.04381)


### Citations

* https://github.com/tensorflow/model-card-toolkit/blob/master/model_card_toolkit/documentation/examples/Standalone_Model_Card_Toolkit_Demo.ipynb



## Considerations

### Users

* Fans of dogs and cats.


### Use Cases

* This model classifies images of cats and dogs.


### Limitations

* This model is not able to classify images of other classes.


### Tradeoffs

* Recall vs Precision.


### Ethical Considerations

* Risk: While distinguishing between cats and dogs is generally agreed to be a benign application of machine learning, harmful results can occur when the model attempts to classify images that don’t contain cats or dogs. For instance, predicting the “dog” label for an image of a human, could be considered offensive.
  * Mitigation Strategy: Avoid application on non-dog and non-cat images.

## Graphics
  
### Validation Set Size

This is the number of examples in the validation set.
<img src="data:image/jpeg;base64,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">


  
### Accuracy
<img src="data:image/jpeg;base64,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


## Metrics

|Name|Value|
-----|------
|accuracy@0.5|0.9781249761581421|
|accuracy@0.5, cat|0.9932885766029358 (0.9832885766, 1.0032885766)|
|accuracy@0.5, Dog|0.9649122953414917 (0.95491229534, 0.97491229534)|

