"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StripeWebhook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const cdk_secret_key_1 = require("@cloudcomponents/cdk-secret-key");
class StripeWebhook extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const secretKey = typeof props.secretKey === 'string' ? cdk_secret_key_1.SecretKey.fromPlainText(props.secretKey) : props.secretKey;
        const handler = new aws_lambda_1.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: 'e9db3870-d793-4cd2-96a9-efe2e318ebbc',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'stripe-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::StripeWebhook',
            timeout: core_1.Duration.minutes(15),
        });
        if (secretKey.grantRead) {
            secretKey.grantRead(handler);
        }
        const cr = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::StripeWebhook',
            pascalCaseProperties: true,
            properties: {
                url: props.url,
                description: props.description,
                events: props.events,
                logLevel: props.logLevel,
                secretKeyString: secretKey.serialize(),
            },
        });
        this.id = cr.ref;
    }
}
exports.StripeWebhook = StripeWebhook;
_a = JSII_RTTI_SYMBOL_1;
StripeWebhook[_a] = { fqn: "@cloudcomponents/cdk-stripe-webhook.StripeWebhook", version: "1.29.0" };
//# sourceMappingURL=data:application/json;base64,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