# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/52_data.ipynb.

# %% auto 0
__all__ = ['NPArray', 'ndarray', 'NPMatrix', 'ndmatrix', 'Idx', 'Index', 'Series', 'DFrame', 'DataFrame', 'DataFrames',
           'IndexLike', 'SeriesLike', 'IterLike', 'GroupKey', 'SPArray', 'SPMatrix']

# %% ../nbs/52_data.ipynb 6
import inspect
from numbers import Number

# %% ../nbs/52_data.ipynb 8
import types
from typing import (
    Type, TypeAlias, Tuple,
    ClassVar, Any, Optional, Callable, Iterable, ForwardRef
)
from typing import TypeAlias, List, Union, Iterable, List

# %% ../nbs/52_data.ipynb 11
try:
    import numpy as np
    arr = np.ndarray
    mtx = np.matrix
except ImportError:
    # Define a placeholder type if numpy is not installed
    arr = 'np.ndarray'
    mtx = 'np.matrix'

# %% ../nbs/52_data.ipynb 13
try:
    import pandas as pd
    index = pd.Index
    dframe = pd.DataFrame
    series = pd.Series
except ImportError:
    # Define a placeholder type if pandas is not installed
    index = 'pd.Index'    
    dframe = 'pd.DataFrame'
    series = 'pd.Series'

# %% ../nbs/52_data.ipynb 15
try:
    import scipy as sp
    sparr = sp.sparse.sparray
    spmtx = sp.sparse.spmatrix
except ImportError:
    # Define a placeholder type if scipy is not installed
    # sparr = 'sp.sparse.sparray'
    # spmtx = 'sp.sparse.spmatrix'
    sparr = 'scipy.sparse._base.sparray'
    spmtx = 'scipy.sparse._matrix.spmatrix'

# %% ../nbs/52_data.ipynb 17
#| export


# %% ../nbs/52_data.ipynb 19
from .nums import Numbers

# %% ../nbs/52_data.ipynb 22
NPArray: TypeAlias = arr
ndarray: TypeAlias = arr
NPMatrix: TypeAlias = mtx
ndmatrix: TypeAlias = mtx

# %% ../nbs/52_data.ipynb 24
Idx: TypeAlias = index
Index: TypeAlias = index
Series: TypeAlias = series
DFrame: TypeAlias = dframe
DataFrame: TypeAlias = dframe
DataFrames: TypeAlias = List[DataFrame]

# %% ../nbs/52_data.ipynb 26
IndexLike: TypeAlias = Union[Numbers, List['Boolish'], 'Index']
SeriesLike: TypeAlias = Union[list, 'Series', 'ndarray', 'Tensor', 'IndexLike']
IterLike: TypeAlias = Union[Iterable, 'SeriesLike', 'IndexLike']

# %% ../nbs/52_data.ipynb 27
GroupKey: TypeAlias = Union[str, int, float, tuple] # key for pandas groupby

# %% ../nbs/52_data.ipynb 29
SPArray: TypeAlias = sparr
SPMatrix: TypeAlias = spmtx
