# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_atyp.ipynb.

# %% auto 0
__all__ = ['Boolic', 'Boolish', 'Bools', 'Numeric', 'Numbers', 'StrLike', 'Strs', 'StrSet', 'StrTmpl', 'PathType', 'PathLike',
           'DirPath', 'DirNames', 'FileNames', 'WalkTuple', 'WalkParts', 'Intum', 'Strum', 'Inhum', 'ByteLike',
           'Literals', 'TypingLike', 'GuardLike', 'Module', 'Loader', 'ModuleSpec', 'Sig', 'Param']

# %% ../nbs/00_atyp.ipynb 4
from typing import (
    TypeAlias, Literal, Union, List, Set,
    Iterable, Tuple, ForwardRef
)

# %% ../nbs/00_atyp.ipynb 7
try: from numpy import bool_ as npbool
except ImportError: npbool = bool

# %% ../nbs/00_atyp.ipynb 8
Boolic:  TypeAlias = Union[bool, npbool]
Boolish: TypeAlias = Union[bool, Boolic, Literal[0], Literal[1]]
Bools:   TypeAlias = List[Boolish]

# %% ../nbs/00_atyp.ipynb 10
from numbers import Number

# %% ../nbs/00_atyp.ipynb 11
Numeric: TypeAlias = Union[int, float, complex, Number]
Numbers: TypeAlias = List[Numeric]

# %% ../nbs/00_atyp.ipynb 13
from string import Template

# %% ../nbs/00_atyp.ipynb 14
StrLike: TypeAlias = Union[str, 'strfix', 'fuzstr', 'nymstr', 'synset']
Strs:    TypeAlias = List[StrLike]
StrSet:  TypeAlias = Set[StrLike]
StrTmpl: TypeAlias = Union[str, Template]

# %% ../nbs/00_atyp.ipynb 16
import os, pathlib

# %% ../nbs/00_atyp.ipynb 17
PathType: TypeAlias = Union[pathlib.Path, pathlib.PosixPath]
PathLike: TypeAlias = Union[str, os.PathLike, pathlib.Path, PathType]

# %% ../nbs/00_atyp.ipynb 19
DirPath:   TypeAlias = PathLike
DirNames:  TypeAlias = List[PathLike]
FileNames: TypeAlias = List[PathLike]
WalkTuple: TypeAlias = Tuple[DirPath, DirNames, FileNames]
WalkParts: TypeAlias = Iterable[WalkTuple]

# %% ../nbs/00_atyp.ipynb 21
# DirLike: TypeAlias = Union['Dir', 'rdir', 'sdir', 'bdir', 'ndir', 'dsrc', 'dtry']
# BaseLike: TypeAlias = Union['Base', 'base',  'bdir', 'btry', 'bpth', 'bsrc', ]
# Entry: TypeAlias = Union[PathLike, 'Entry', 'BaseEntry', 'StructuredEntry', 'ntry']
# BaseType: TypeAlias   = Union[PathLike, Entry, BaseLike, Entry]
# DirType:  TypeAlias   = Union[PathLike, 'StructuredPath', 'DirEntry',  'StructuredDir', DirLike, 'dpath']
# FileType: TypeAlias   = Union[PathLike, 'StructuredPath', 'FileEntry', 'StructuredFile',  'fpath']
# PathType: TypeAlias   = Union[PathLike, 'StructuredPath', 'PathEntry',  Entry,  BaseType, 'ppath']

# %% ../nbs/00_atyp.ipynb 23
from enum import IntEnum, StrEnum

# %% ../nbs/00_atyp.ipynb 24
Intum: TypeAlias = Union[IntEnum, 'LitIntEnum', 'Intum']
Strum: TypeAlias = Union[StrEnum, 'LitStrEnum', 'Strum', 'LiteralEnum']

Inhum = ForwardRef('Inhum', module='inhum', is_class=True)

# %% ../nbs/00_atyp.ipynb 26
ByteLike: TypeAlias = Union[bytes, 'BytesUnit', 'Bytes']

# %% ../nbs/00_atyp.ipynb 28
from typing import TypeVar, TypeGuard

# %% ../nbs/00_atyp.ipynb 29
Literals = TypeVar('Literals')
TypingLike: TypeAlias = Union['TTyp', 'TType', 'TypingUnit', 'Typing']
GuardLike: TypeAlias = Union['TTypGuard', 'TTypeGuard']

# %% ../nbs/00_atyp.ipynb 31
import types

# %% ../nbs/00_atyp.ipynb 32
Module: TypeAlias = types.ModuleType

# %% ../nbs/00_atyp.ipynb 34
import importlib
from importlib.abc import Loader

# %% ../nbs/00_atyp.ipynb 35
Loader: TypeAlias = Loader
ModuleSpec: TypeAlias = importlib.machinery.ModuleSpec

# %% ../nbs/00_atyp.ipynb 37
import inspect

# %% ../nbs/00_atyp.ipynb 38
Sig:   TypeAlias = inspect.Signature
Param: TypeAlias = inspect.Parameter
