/* Generated with cbindgen:0.20.0 */

/* Warning, this file is autogenerated by cbindgen. Don't modify this manually. */

#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

/**
 * A C-compatible `struct` originating **inside** Rust
 * used for passing arrays across the FFI boundary
 */
typedef struct InternalArray {
    void *data;
    size_t len;
} InternalArray;

/**
 * A C-compatible `struct` originating **outside** Rust
 * used for passing arrays across the FFI boundary
 */
typedef struct ExternalArray {
    const void *data;
    size_t len;
} ExternalArray;

/**
 * Convert a Polyline into an array of coordinates
 *
 * Callers must pass two arguments:
 *
 * - a pointer to `NUL`-terminated characters (`char*`)
 * - an unsigned 32-bit `int` for precision (5 for Google Polylines, 6 for
 * OSRM and Valhalla Polylines)
 *
 * A decoding failure will return an [Array](struct.Array.html) whose `data` field is `[[NaN, NaN]]`, and whose `len` field is `1`.
 *
 * Implementations calling this function **must** call [`drop_float_array`](fn.drop_float_array.html)
 * with the returned [Array](struct.Array.html), in order to free the memory it allocates.
 *
 * # Safety
 *
 * This function is unsafe because it accesses a raw pointer which could contain arbitrary data
 */
struct InternalArray decode_polyline_ffi(const char *pl,
                                         uint32_t precision);

/**
 * Convert an array of coordinates into a Polyline
 *
 * Callers must pass two arguments:
 *
 * - a [Struct](struct.Array.html) with two fields:
 *     - `data`, a void pointer to an array of floating-point lat, lon coordinates: `[[1.0, 2.0]]`
 *     - `len`, the length of the array being passed. Its type must be `size_t`: `1`
 * - an unsigned 32-bit `int` for precision (5 for Google Polylines, 6 for
 * OSRM and Valhalla Polylines)
 *
 * A decoding failure will return one of the following:
 *
 * - a `char*` beginning with "Longitude error:" if invalid longitudes are passed
 * - a `char*` beginning with "Latitude error:" if invalid latitudes are passed
 *
 * Implementations calling this function **must** call [`drop_cstring`](fn.drop_cstring.html)
 * with the returned `c_char` pointer, in order to free the memory it allocates.
 *
 * # Safety
 *
 * This function is unsafe because it accesses a raw pointer which could contain arbitrary data
 */
char *encode_coordinates_ffi(struct ExternalArray coords,
                             uint32_t precision);

/**
 * Free Array memory which Rust has allocated across the FFI boundary
 *
 * # Safety
 *
 * This function is unsafe because it accesses a raw pointer which could contain arbitrary data
 */
void drop_float_array(struct InternalArray);

/**
 * Free `CString` memory which Rust has allocated across the FFI boundary
 *
 * # Safety
 *
 * This function is unsafe because it accesses a raw pointer which could contain arbitrary data
 */
void drop_cstring(char *p);
