/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BlockValue;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2265;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_4115;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_9;
import net.minecraft.server.MinecraftServer;

public class ValueConversions {
    public static Value of(class_2338 pos) {
        return ListValue.of(new NumericValue(pos.method_10263()), new NumericValue(pos.method_10264()), new NumericValue(pos.method_10260()));
    }

    public static Value ofOptional(class_2338 pos) {
        if (pos == null) {
            return Value.NULL;
        }
        return ListValue.of(new NumericValue(pos.method_10263()), new NumericValue(pos.method_10264()), new NumericValue(pos.method_10260()));
    }

    public static Value of(class_243 vec) {
        return ListValue.of(new NumericValue(vec.field_1352), new NumericValue(vec.field_1351), new NumericValue(vec.field_1350));
    }

    public static Value of(class_2265 cpos) {
        return ListValue.of(new NumericValue(cpos.field_10708), new NumericValue(cpos.field_10707));
    }

    public static Value of(class_3218 world) {
        return ValueConversions.of(world.method_27983().method_29177());
    }

    public static class_1937 dimFromValue(Value dimensionValue, MinecraftServer server) {
        String dimString;
        if (dimensionValue instanceof EntityValue) {
            return ((EntityValue)dimensionValue).getEntity().method_5770();
        }
        if (dimensionValue instanceof BlockValue) {
            BlockValue bv = (BlockValue)dimensionValue;
            if (bv.getWorld() != null) {
                return bv.getWorld();
            }
            throw new InternalExpressionException("dimension argument accepts only world-localized block arguments");
        }
        switch (dimString = dimensionValue.getString().toLowerCase(Locale.ROOT)) {
            case "nether": 
            case "the_nether": {
                return server.method_3847(class_1937.field_25180);
            }
            case "end": 
            case "the_end": {
                return server.method_3847(class_1937.field_25181);
            }
            case "overworld": 
            case "over_world": {
                return server.method_3847(class_1937.field_25179);
            }
        }
        class_5321 dim = null;
        class_2960 id = new class_2960(dimString);
        for (class_5321 world : server.method_29435()) {
            if (!id.equals((Object)world.method_29177())) continue;
            dim = world;
            break;
        }
        if (dim == null) {
            throw new InternalExpressionException("Incorrect dimension string: " + dimString);
        }
        return server.method_3847(dim);
    }

    public static Value of(class_5321<class_1937> dim) {
        return ValueConversions.of(dim.method_29177());
    }

    public static Value of(class_2960 id) {
        if (id == null) {
            return Value.NULL;
        }
        if (id.method_12836().equals("minecraft")) {
            return new StringValue(id.method_12832());
        }
        return new StringValue(id.toString());
    }

    public static String simplify(class_2960 id) {
        if (id == null) {
            return "";
        }
        if (id.method_12836().equals("minecraft")) {
            return id.method_12832();
        }
        return id.toString();
    }

    public static Value of(class_4208 pos) {
        return ListValue.of(ValueConversions.of((class_5321<class_1937>)pos.method_19442()), ValueConversions.of(pos.method_19446()));
    }

    public static Value fromPath(class_3218 world, class_11 path) {
        ArrayList<Value> nodes = new ArrayList<Value>();
        int len = path.method_38();
        for (int i = 0; i < len; ++i) {
            class_9 node = path.method_40(i);
            nodes.add(ListValue.of(new BlockValue(null, world, node.method_22879()), new StringValue(node.field_41.name().toLowerCase(Locale.ROOT)), new NumericValue(node.field_43), new NumericValue(node.field_42)));
        }
        return ListValue.wrap(nodes);
    }

    public static Value fromTimedMemory(class_1297 e, long expiry, Object v) {
        Value ret = ValueConversions.fromEntityMemory(e, v);
        if (ret.isNull() || expiry == Long.MAX_VALUE) {
            return ret;
        }
        return ListValue.of(ret, new NumericValue(expiry));
    }

    private static Value fromEntityMemory(class_1297 e, Object v) {
        if (v instanceof class_4208) {
            class_4208 pos = (class_4208)v;
            return ValueConversions.of(pos);
        }
        if (v instanceof class_1297) {
            return new EntityValue((class_1297)v);
        }
        if (v instanceof class_2338) {
            return new BlockValue(null, (class_3218)e.method_5770(), (class_2338)v);
        }
        if (v instanceof Number) {
            return new NumericValue(((Number)((Object)v)).doubleValue());
        }
        if (v instanceof Boolean) {
            return new NumericValue((Boolean)((Object)v));
        }
        if (v instanceof UUID) {
            return ValueConversions.ofUUID((class_3218)e.method_5770(), (UUID)((Object)v));
        }
        if (v instanceof class_1282) {
            class_1282 source = (class_1282)v;
            return ListValue.of(new StringValue(source.method_5525()), source.method_5529() == null ? Value.NULL : new EntityValue(source.method_5529()));
        }
        if (v instanceof class_11) {
            return ValueConversions.fromPath((class_3218)e.method_5770(), (class_11)v);
        }
        if (v instanceof class_4115) {
            return new BlockValue(null, (class_3218)e.method_5770(), ((class_4115)v).method_18989());
        }
        if (v instanceof class_4142) {
            return ListValue.of(new BlockValue(null, (class_3218)e.method_5770(), ((class_4142)v).method_19094().method_18989()), new NumericValue(((class_4142)v).method_19095()), new NumericValue(((class_4142)v).method_19096()));
        }
        if (v instanceof Set) {
            v = new ArrayList((Set)((Object)v));
        }
        if (v instanceof List) {
            List l = v;
            if (l.isEmpty()) {
                return ListValue.of(new Value[0]);
            }
            Object el = l.get(0);
            if (el instanceof class_1297) {
                return ListValue.wrap(l.stream().map(o -> new EntityValue((class_1297)o)).collect(Collectors.toList()));
            }
            if (el instanceof class_4208) {
                return ListValue.wrap(l.stream().map(o -> ValueConversions.of((class_4208)o)).collect(Collectors.toList()));
            }
        }
        return Value.NULL;
    }

    private static Value ofUUID(class_3218 entityWorld, UUID uuid) {
        class_1297 current = entityWorld.method_14190(uuid);
        return ListValue.of(current == null ? Value.NULL : new EntityValue(current), new StringValue(uuid.toString()));
    }

    public static Value of(class_3449<?> structure) {
        if (structure == null || structure == class_3449.field_16713) {
            return Value.NULL;
        }
        ArrayList<Value> pieces = new ArrayList<Value>();
        for (class_3443 piece : structure.method_14963()) {
            class_3341 box = piece.method_14935();
            pieces.add(ListValue.of(new StringValue(NBTSerializableValue.nameFromRegistryId(class_2378.field_16645.method_10221((Object)piece.method_16653()))), piece.method_14934() == null ? Value.NULL : new StringValue(piece.method_14934().method_10151()), ListValue.fromTriple(box.field_14381, box.field_14380, box.field_14379), ListValue.fromTriple(box.field_14378, box.field_14377, box.field_14376)));
        }
        class_3341 boundingBox = structure.method_14968();
        HashMap<Value, Value> ret = new HashMap<Value, Value>();
        ret.put(new StringValue("box"), ListValue.of(ListValue.fromTriple(boundingBox.field_14381, boundingBox.field_14380, boundingBox.field_14379), ListValue.fromTriple(boundingBox.field_14378, boundingBox.field_14377, boundingBox.field_14376)));
        ret.put(new StringValue("pieces"), ListValue.wrap(pieces));
        return MapValue.wrap(ret);
    }
}

