/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_2995;

public class Scoreboards {
    private static String getScoreboardKeyFromValue(Value keyValue) {
        if (keyValue instanceof EntityValue) {
            class_1297 e = ((EntityValue)keyValue).getEntity();
            if (e instanceof class_1657) {
                return e.method_5477().getString();
            }
            return e.method_5845();
        }
        return keyValue.getString();
    }

    public static void apply(Expression expression) {
        expression.addLazyFunction("scoreboard", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            if (lv.size() == 0) {
                ListValue ret = ListValue.wrap(scoreboard.method_1163().stream().map(StringValue::new).collect(Collectors.toList()));
                return (_c, _t) -> ret;
            }
            String objectiveName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            class_266 objective = scoreboard.method_1165(objectiveName);
            if (objective == null) {
                throw new InternalExpressionException("Unknown objective: " + objectiveName);
            }
            if (lv.size() == 1) {
                ListValue ret = ListValue.wrap(scoreboard.method_1184(objective).stream().map(s -> new StringValue(s.method_1129())).collect(Collectors.toList()));
                return (_c, _t) -> ret;
            }
            String key = Scoreboards.getScoreboardKeyFromValue(((LazyValue)lv.get(1)).evalValue((Context)c));
            if (!scoreboard.method_1183(key, objective) && lv.size() == 2) {
                return LazyValue.NULL;
            }
            class_267 scoreboardPlayerScore = scoreboard.method_1180(key, objective);
            NumericValue retval = new NumericValue(scoreboardPlayerScore.method_1126());
            if (lv.size() > 2) {
                scoreboardPlayerScore.method_1128(NumericValue.asNumber(((LazyValue)lv.get(2)).evalValue((Context)c)).getInt());
            }
            return (_c, _t) -> retval;
        });
        expression.addLazyFunction("scoreboard_remove", -1, (c, t, lv) -> {
            String objectiveName;
            if (lv.size() == 0) {
                throw new InternalExpressionException("'scoreboard_remove' requires at least one parameter");
            }
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            class_266 objective = scoreboard.method_1165(objectiveName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString());
            if (objective == null) {
                return LazyValue.FALSE;
            }
            if (lv.size() == 1) {
                scoreboard.method_1194(objective);
                return LazyValue.TRUE;
            }
            String key = Scoreboards.getScoreboardKeyFromValue(((LazyValue)lv.get(1)).evalValue((Context)c));
            if (!scoreboard.method_1183(key, objective)) {
                return LazyValue.NULL;
            }
            class_267 scoreboardPlayerScore = scoreboard.method_1180(key, objective);
            NumericValue previous = new NumericValue(scoreboardPlayerScore.method_1126());
            scoreboard.method_1155(key, objective);
            return (c_, t_) -> previous;
        });
        expression.addLazyFunction("scoreboard_add", -1, (c, t, lv) -> {
            class_274 criterion;
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            if (lv.size() == 0 || lv.size() > 2) {
                throw new InternalExpressionException("'scoreboard_add' should have one or two parameters");
            }
            String objectiveName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            if (lv.size() == 1) {
                criterion = class_274.field_1468;
            } else {
                String critetionName = ((LazyValue)lv.get(1)).evalValue((Context)c).getString();
                criterion = class_274.method_1224((String)critetionName).orElse(null);
                if (criterion == null) {
                    throw new InternalExpressionException("Unknown scoreboard criterion: " + critetionName);
                }
            }
            class_266 objective = scoreboard.method_1165(objectiveName);
            if (objective != null) {
                return LazyValue.FALSE;
            }
            scoreboard.method_1168(objectiveName, criterion, (class_2561)new class_2585(objectiveName), criterion.method_1227());
            return LazyValue.TRUE;
        });
        expression.addLazyFunction("scoreboard_display", 2, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            String location = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            int slot = class_269.method_1192((String)location);
            if (slot < 0) {
                throw new InternalExpressionException("Invalid objective slot: " + location);
            }
            Value target = ((LazyValue)lv.get(1)).evalValue((Context)c);
            if (target instanceof NullValue) {
                scoreboard.method_1158(slot, null);
                return (_c, _t) -> new NumericValue(slot);
            }
            String objectiveString = target.getString();
            class_266 objective = scoreboard.method_1165(objectiveString);
            if (objective == null) {
                throw new InternalExpressionException("Objective doesn't exist: " + objectiveString);
            }
            scoreboard.method_1158(slot, objective);
            return (_c, _t) -> new NumericValue(slot);
        });
    }
}

