Capt’n python client
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Docs

For full documentation, Please follow the below link:

- <a href="https://docs.captn.ai" target="_blank">https://docs.captn.ai/</a>

## How to install

If you don’t have the captn library already installed, please install it
using pip.

``` console
pip install captn-client
```

## How to use

To access the captn service, you must first create a developer account.
Please fill out the signup form below to get one:

- <https://bit.ly/3I4cNuv>

After successful verification, you will receive an email with the
username and password for the developer account.

Once you have the credentials, use them to get an access token by
calling `Client.get_token` method. It is necessary to get an access
token; otherwise, you won’t be able to access all of the captn service’s
APIs. You can either pass the username, password, and server address as
parameters to the `Client.get_token` method or store them in the
environment variables **CAPTN_SERVICE_USERNAME**,
**CAPTN_SERVICE_PASSWORD**, and **CAPTN_SERVER_URL**.

In addition to the regular authentication with credentials, you can also
enable multi-factor authentication (MFA) and single sign-on (SSO) for
generating tokens.

To help protect your account, we recommend that you enable multi-factor
authentication (MFA). MFA provides additional security by requiring you
to provide unique verification code (OTP) in addition to your regular
sign-in credentials when performing critical operations.

Your account can be configured for MFA in just two easy steps:

1.  To begin, you need to enable MFA for your account by calling the
    `User.enable_mfa` method, which will generate a QR code. You can
    then scan the QR code with an authenticator app, such as Google
    Authenticator and follow the on-device instructions to finish the
    setup in your smartphone.

2.  Finally, activate MFA for your account by calling
    `User.activate_mfa` and passing the dynamically generated six-digit
    verification code from your smartphone’s authenticator app.

You can also disable MFA for your account at any time by calling the
method `User.disable_mfa` method.

Single sign-on (SSO) can be enabled for your account in three simple
steps:

1.  Enable the SSO for a provider by calling the `User.enable_sso`
    method with the SSO provider name and an email address. At the
    moment, we only support “google” and “github” as SSO providers. We
    intend to support additional SSO providers in future releases.

2.  Before you can start generating new tokens with SSO, you must first
    authenticate with the SSO provider. Call the `Client.get_token` with
    the same SSO provider you have enabled in the step above to generate
    an SSO authorization URL. Please copy and paste it into your
    preferred browser and complete the authentication process with the
    SSO provider.

3.  After successfully authenticating with the SSO provider, call the
    `Client.set_sso_token` method to generate a new token and use it
    automatically in all future interactions with the captn server.

For more information, please check:

- [Tutorial](https://docs.captn.ai/Tutorial/) with more elaborate
  example, and

- [API](https://docs.captn.ai/API/client/Client/) with reference
  documentation.

Here’s a minimal example showing how to use captn services to train a
model and make predictions.

In the below example, the username, password, and server address are
stored in **CAPTN_SERVICE_USERNAME**, **CAPTN_SERVICE_PASSWORD**, and
**CAPTN_SERVER_URL** environment variables.

### 0. Get token

``` python
# Importing necessary libraries
from captn.client import Client, DataBlob, DataSource

# Authenticate
Client.get_token()
```

### 1. Connect and preprocess data

In our example, we will be using the captn APIs to load and preprocess a
sample CSV file stored in an AWS S3 bucket.

``` python
# Before you can use the data to train a model, it must be uploaded to the
# captn server. Run the following command to upload the data to the
# captn server for further processing.
data_blob = DataBlob.from_s3(uri="s3://test-airt-service/sample_gaming_130k")

# Display the upload progress
data_blob.progress_bar()
```

    100%|██████████| 1/1 [00:35<00:00, 35.44s/it]

The sample data we used in this example doesn’t have the header rows and
their data types defined.

The following code creates the necessary headers along with their data
types and reads only a subset of columns that are required for modeling:

``` python
# Add header rows
prefix = ["revenue", "ad_revenue", "conversion", "retention"]
days = list(range(30)) + list(range(30, 361, 30))
dtype = {
    "date": "str",
    "game_name": "str",
    "platform": "str",
    "user_type": "str",
    "network": "str",
    "campaign": "str",
    "adgroup": "str",
    "installs": "int32",
    "spend": "float32",
}
dtype.update({f"{p}_{d}": "float32" for p in prefix for d in days})
names = list(dtype.keys())

kwargs = {
    "delimiter": "|",
    "names": names,
    "parse_dates": ["date"],
    "usecols": names[:42],
    "dtype": dtype,
}
```

Finally, the above variables are passed to the `DataBlob.to_datasource`
method which preprocesses the data and stores it in captn server.

``` python
# Preprocess and prepare the data for training
data_source = data_blob.to_datasource(
    file_type="csv", index_column="game_name", sort_by="date", **kwargs
)

# Display the data preprocessing progress
data_source.progress_bar()
```

    100%|██████████| 1/1 [00:55<00:00, 55.66s/it]

``` python
# When the preprocessing is finished, you can run the following command to
# display the head of the data to ensure everything is fine.
print(data_source.head())
```

                      date platform          user_type            network  \
    game_name                                                               
    game_name_0 2021-03-15      ios      jetfuelit_int      jetfuelit_int   
    game_name_0 2021-03-15      ios      jetfuelit_int      jetfuelit_int   
    game_name_0 2021-03-15      ios      jetfuelit_int      jetfuelit_int   
    game_name_0 2021-03-15      ios      jetfuelit_int      jetfuelit_int   
    game_name_0 2021-03-15      ios      jetfuelit_int      jetfuelit_int   
    game_name_0 2021-03-15  android  googleadwords_int  googleadwords_int   
    game_name_0 2021-03-15  android  googleadwords_int  googleadwords_int   
    game_name_0 2021-03-15  android         moloco_int         moloco_int   
    game_name_0 2021-03-15  android      jetfuelit_int      jetfuelit_int   
    game_name_0 2021-03-15  android      jetfuelit_int      jetfuelit_int   

                     campaign       adgroup  installs       spend  revenue_0  \
    game_name                                                                  
    game_name_0    campaign_0   adgroup_541         1    0.600000   0.000000   
    game_name_0    campaign_0  adgroup_2351         2    4.900000   0.000000   
    game_name_0    campaign_0   adgroup_636         3    7.350000   0.000000   
    game_name_0    campaign_0   adgroup_569         1    0.750000   0.000000   
    game_name_0    campaign_0   adgroup_243         2    3.440000   0.000000   
    game_name_0  campaign_283  adgroup_1685        11    0.000000   0.000000   
    game_name_0    campaign_2    adgroup_56        32   30.090000   0.000000   
    game_name_0  campaign_191          None       291  503.480011  34.701553   
    game_name_0    campaign_0   adgroup_190         4    2.740000   0.000000   
    game_name_0    campaign_0   adgroup_755         8   11.300000  13.976003   

                 revenue_1  ...  revenue_23  revenue_24  revenue_25  revenue_26  \
    game_name               ...                                                   
    game_name_0   0.018173  ...    0.018173    0.018173    0.018173    0.018173   
    game_name_0   0.034000  ...    0.034000    6.034000    6.034000    6.034000   
    game_name_0   0.000000  ...   12.112897   12.112897   12.112897   12.112897   
    game_name_0   0.029673  ...    0.029673    0.029673    0.029673    0.029673   
    game_name_0   0.027981  ...    0.042155    0.042155    0.042155    0.042155   
    game_name_0   0.097342  ...    0.139581    0.139581    0.139581    0.139581   
    game_name_0   0.802349  ...    2.548253    2.548253    2.771138    2.805776   
    game_name_0  63.618111  ...  116.508331  117.334709  117.387489  117.509506   
    game_name_0   0.000000  ...    0.000000    0.000000    0.000000    0.000000   
    game_name_0  14.358793  ...   14.338905   14.338905   14.338905   14.338905   

                 revenue_27  revenue_28  revenue_29  revenue_30  revenue_60  \
    game_name                                                                 
    game_name_0    0.018173    0.018173    0.018173    0.018173    0.018173   
    game_name_0    6.034000    6.034000    6.034000    6.034000    6.034000   
    game_name_0   12.112897   12.112897   12.112897   12.112897   12.112897   
    game_name_0    0.029673    0.029673    0.029673    0.029673    0.029673   
    game_name_0    0.042155    0.042155    0.042155    0.042155    0.042155   
    game_name_0    0.139581    0.139581    0.139581    0.139581    0.139581   
    game_name_0    2.805776    2.805776    2.805776    2.805776    2.805776   
    game_name_0  118.811417  118.760765  119.151291  119.350220  139.069443   
    game_name_0    0.000000    0.000000    0.000000    0.000000    0.000000   
    game_name_0   14.338905   14.338905   14.338905   14.338905   14.338905   

                 revenue_90  
    game_name                
    game_name_0    0.018173  
    game_name_0   13.030497  
    game_name_0   12.112897  
    game_name_0    0.029673  
    game_name_0    0.042155  
    game_name_0    0.139581  
    game_name_0    2.805776  
    game_name_0  147.528793  
    game_name_0    0.000000  
    game_name_0   14.338905  

    [10 rows x 41 columns]

### 2. Training

``` python
# Todo
```
