# Parser for the GeoSuite[tm] PRV export format

This library provides functionality to parse geotechnical
investigation data in `.prv` files generated by [Trimble](https://www.trimble.com/)s GeoSuite.

Note: This parser is based on reverse-engineering, not a published standard.
Some details in the format might have been missed, or might have changed in newer versions.

The datamodel is (mostly) compatible with
[libsgfdata](https://github.com/emerald-geomodelling/libsgfdata),
meaning that it is possible to (with fields not being properly
renamed/transformed) save the loaded data as an SGF file.

# Usage

```
>>> data = libgeosuiteprv.parse("SOMEFILE.PRV" )
>>> data
[{'main': [{'method_code': 23,
            'method_name': 'rps',
            'day': 23,
            'month': 5,
            'year': 2011,
            'date': '2011-5-23',
            'stop_code': 91,
            'stop_desc': 'abandoned_hit_hard_surface',
            'depth_increment': 0.021,
            'depth_bedrock': None,
            'x_coordinate': 288557.381,
            'y_coordinate': 6667259.708,
            'z_coordinate': 139.01}],
  'data':        depth  feed_force  flushing  extra_spin  hammering  pumping comments
  0      0.021       102.0         0           0          0        0         
  1      0.042      1318.0         0           0          0        0         
  2      0.052      1038.0         0           0          0        0         
  3      0.072      1101.0         0           0          0        0         
  4      0.100      1728.0         0           0          0        0         
  ...      ...         ...       ...         ...        ...      ...      ...
  1326  28.550      5301.0         0           1          0        0         
  1327  28.570      9423.0         0           1          0        0         
  1328  28.605     12217.0         0           1          0        0         
  1329  28.631     11564.0         0           1          0        0         
  1330  28.650     11942.0         0           1          0        0         
  
  [1331 rows x 7 columns]}]
  
>>> libsgfdata.dump(data, "somefile.sgf")
```
