# Generated by Django 5.0.4 on 2024-04-04 19:52

from django.db import migrations


def move_data_from_quotes_django_markov(apps, schema_editor):  # no cov
    Source = apps.get_model("django_quotes", "Source")
    SourceGroup = apps.get_model("django_quotes", "SourceGroup")
    SourceMarkovModel = apps.get_model("django_quotes", "SourceMarkovModel")
    GroupMarkovModel = apps.get_model("django_quotes", "GroupMarkovModel")
    MarkovTextModel = apps.get_model("django_markov", "MarkovTextModel")
    for group in SourceGroup.objects.all():
        g_m = MarkovTextModel.objects.create()
        group.text_model = g_m
        group.save()
        group_model = GroupMarkovModel.objects.get(group=group)
        g_m.data = group_model.data
        g_m.save()

    for source in Source.objects.all():
        s_m = MarkovTextModel.objects.create()
        source.text_model = s_m
        source.save()
        source_model = SourceMarkovModel.objects.get(source=source)
        s_m.data = source_model.data
        s_m.save()


def reverse_data_migration(apps, schema_editor):  # no cov
    Source = apps.get_model("django_quotes", "Source")
    SourceGroup = apps.get_model("django_quotes", "SourceGroup")
    MarkovTextModel = apps.get_model("django_markov", "MarkovTextModel")
    for source in Source.objects.all():
        if source.text_model:
            text_model = MarkovTextModel.objects.get(pk=source.text_model.id)
            source.text_model = None
            source.save()
            text_model.delete()
    for group in SourceGroup.objects.all():
        if group.text_model:
            text_model = MarkovTextModel.objects.get(pk=group.text_model.id)
            group.text_model = None
            group.save()
            text_model.delete()


class Migration(migrations.Migration):

    dependencies = [
        ("django_quotes", "0007_source_text_model_sourcegroup_text_model"),
        ("django_markov", "0005_alter_markovtextmodel_data"),
    ]

    operations = [migrations.RunPython(move_data_from_quotes_django_markov, reverse_code=reverse_data_migration)]
