# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['springer']

package_data = \
{'': ['*']}

install_requires = \
['loguru>=0.4.1,<0.5.0',
 'pandas>=1.0.3,<2.0.0',
 'requests>=2.23.0,<3.0.0',
 'toml>=0.10.0,<0.11.0',
 'typer>=0.1.1,<0.2.0',
 'xlrd>=1.2.0,<2.0.0']

entry_points = \
{'console_scripts': ['springer = springer.__main__:cli']}

setup_kwargs = {
    'name': 'springer',
    'version': '0.12.0',
    'description': 'Bulk Springer Textbook Downloader',
    'long_description': '# `springer`\n\n![Downloading](https://github.com/JnyJny/springer_downloader/raw/master/demo/download-catalog.gif)\n__Springer Textbook Bulk Download Tool__\n\n## NOTICE\n\nThe author of this software is not affiliated with Springer and this\ntool is not authorized or supported by Springer. Thank you to\nSpringer for making these high quality textbooks available at no\ncost.\n\n\n>"With the Coronavirus outbreak having an unprecedented impact on\n>education, Springer Nature is launching a global program to support\n>learning and teaching at higher education institutions\n>worldwide. Remote access to educational resources has become\n>essential. We want to support lecturers, teachers and students\n>during this challenging period and hope that this initiative will go\n>some way to help.\n>\n>Institutions will be able to access more than 500 key textbooks\n>across Springer Nature’s eBook subject collections for free. In\n>addition, we are making a number of German-language Springer medical\n>training books on emergency nursing freely accessible.  These books\n>will be available via SpringerLink until at least the end of July."\n\n[Source](https://www.springernature.com/gp/librarians/news-events/all-news-articles/industry-news-initiatives/free-access-to-textbooks-for-institutions-affected-by-coronaviru/17855960)\n\n## Overview\n\nThis tool automates the process of downloading the Springer-provided\nExcel catalogs, locating URLs and downloading the files in PDF or epub\nformat.\n\nCatalogs are lists of books in a specific _language_, spanning a\n_topic_. Catalogs are further subdivided into _packages_ which are\nbooks grouped by sub-topics.\n\nTextbooks can be downloaded by; title, package name or the entire\ncatalog. Title and package names can be incompletely specified and\nare case-insensitive. \n\nThe available languages are: English & German.\n\nThe available topics are: _All Disciplines_ and _Emergency Nursing_.\n\n**Note: The _Emergency Nursing_ topic is not available in English.**\n\n## Source and License\n\nFull source is available on\n[GitHub](https://github.com/JnyJny/springer_downloader) and it is\nlicensed under the\n[Apache-2.0](https://www.apache.org/licenses/LICENSE-2.0)\nlicense.\n\n## Installation\n\nThis utility can be installed using `pip`:\n\n`$ python3 -m pip install springer`\n\nOr from the latest source on GitHub:\n\n`$ python3 -m pip install git+https://github.com/JnyJny/springer_downloader`\n\n**Usage**:\n\n```console\n$ springer [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `-L, --language [en|de]`: Choose catalog language\n* `-T, --topic [all|med]`: Choose a catalog topic.\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `clean-catalog`: Remove cached catalogs.\n* `download`: Download textbooks from Springer This command...\n* `get-default-catalog`: Print the default catalog identifier.\n* `list`: List books, package, packages, catalog or...\n* `refresh-catalog`: Refresh the cached catalog of springer...\n* `set-default-catalog`: Set default catalog language and topic.\n\n## `springer clean-catalog`\n\nRemove cached catalogs.\n\n__Examples__\n\nRemove the cached default catalog:\n\n`$ springer clean-catalog --force`\n\nRemove the cached German language _Emergency Nursing_ catalog:\n\n`$ springer --language de --topic med clean-catalog --force`\n\nRemove all catalogs:\n\n`$ springer clean-catalog --force --all`\n\n**Usage**:\n\n```console\n$ springer clean-catalog [OPTIONS]\n```\n\n**Options**:\n\n* `-F, --force`\n* `--all`\n* `--help`: Show this message and exit.\n\n## `springer download`\n\nDownload textbooks from Springer\n\nThis command downloads textbooks from Springer to the local host. Files\nare saved by default in PDF format to the current working directory.\n\nIf a download is interrupted by the user, it can be later restarted where\nthe interruption occurred without downloading previous files. \n\nProblems encountered while downloading files are logged to:\n\n`dest-path/DOWNLOAD_REPORT.txt`\n\n__Examples__\n\nDownload all books in the default catalog in PDF format to the\ncurrent directory:\n\n`$ springer download books`\n\nDownload all books in EPUB format whose title includes \'python\':\n\n`$ springer download books --name python --file-format epub`\n\nDownload all books into directories grouped by package:\n\n`$ springer download packages --dest-path by_pkgs\n\nDownload all books in a specific package in EPUB format:\n\n`$ springer download package --name \'Computer Science\' --file-format epub`\n\nDownload all books in packages whose name includes `Science`:\n\n`$ springer download package --name science --dest sciences`\n\nDownload all books in all catalogs [en-all, de-all, de-med] in EPUB format:\n\n`$ springer download catalogs --file-format epub`\n\nThe `catalogs` download subcommand will create a set of directories by language\nand topic for each catalog and save downloaded files into the appropriate\ndirectory, eg:\n\n\ndest-path/English/All_Disciplines/package_name/title.fmt\ndest-path/German/All_Disciplines/package_name/title.fmt\ndest-path/German/Emergency_Nursing/package_name/title.fmt\n\nThe `package` and `packages` subcommands will also save downloaded\nfiles into directories with package names rooted in the destination\npath:\n\n\ndest-path/package_name/title.fmt\n...\n\n\n\nSee Also: `set-default-catalog`, `get-default-catalog`, `list`\n\n**Usage**:\n\n```console\n$ springer download [OPTIONS] [catalogs|catalog|packages|package|books]\n```\n\n**Options**:\n\n* `-n, --name TEXT`: Name to match against title or package.\n* `-d, --dest-path PATH`: Destination directory for downloaded files.  [default: /Users/ejo/local/springer]\n* `-f, --format [pdf|epub]`: [default: pdf]\n* `-W, --over-write`: Over write downloaded files.  [default: False]\n* `--help`: Show this message and exit.\n\n## `springer get-default-catalog`\n\nPrint the default catalog identifier.\n\nThis is the default catalog that will be used when listing books and packages\nand the user has not specified a --language or --topic on the command line.\n\n**Usage**:\n\n```console\n$ springer get-default-catalog [OPTIONS]\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n\n## `springer list`\n\nList books, package, packages, catalog or catalogs.\n\nDisplay information about books, packages, and catalogs. Packages\nare sets of books grouped by subject.\n\n__Examples__\n\nList titles available in the default catalog:\n\n`$ springer list books`\n\nList packages available in the default catalog:\n\n`$ springer list packages`\n\nList titles available in the German language, all disciplines catalog:\n\n`$ springer --language de --topic all list books`\n\nList all eBook packages in the default catalog:\n\n`$ springer list packages`\n\nList all eBook packages in the default catalog whose name match:\n\n`$ springer list package -m science`\n\nList information about the current catalog:\n\n`$ springer list catalog`\n\nList information about the Germal language, Emergency Nursing catalog:\n\n`$ springer --language de --topic med list catalog`\n\n**Usage**:\n\n```console\n$ springer list [OPTIONS] [catalogs|catalog|packages|package|books]\n```\n\n**Options**:\n\n* `-n, --name TEXT`: Name to match against title or pacakge.\n* `-l, --long-format`: Display selected information in a longer format.  [default: False]\n* `--help`: Show this message and exit.\n\n## `springer refresh-catalog`\n\nRefresh the cached catalog of springer textbooks.\n\nIf `--all` is specified, the `--url` option is ignored.\n\n__Examples__\n\nUpdate English language catalog:\n\n`$ springer --language en refresh`\n\nUpdate German language catalog whose topic is \'all\':\n\n`$ springer --language de --topic all refresh`\n\nUpdate German language catalog whose topic is \'med\' with a new url:\n\n`$ springer -l de -d med refresh --url https://example.com/api/endpoint/something/v11`\n\n__NOTE: THIS URL DOES NOT REPLACE THE DEFAULT URL FOR THE TARGET CATALOG__\n\nUpdate all catalogs:\n\n`$ springer refresh-catalog --all`\n\n**Usage**:\n\n```console\n$ springer refresh-catalog [OPTIONS]\n```\n\n**Options**:\n\n* `-u, --url TEXT`: URL for Excel-formatted catalog.\n* `--all`\n* `--help`: Show this message and exit.\n\n## `springer set-default-catalog`\n\nSet default catalog language and topic.\n\n__Examples__\n\nSet the default catalog to German language:\n\n`$ springer --language de set-default-catalog`\n\nSet the default catalog to German and emergency nursing:\n\n`$ springer --language de --topic med set-default-catalog`\n\nSet the default catalog to English and all disciplines topic:\n\n`$ springer --language en --topic all set-default-catalog`\n\nNote: The only English language catalog is `en-all`.\n\n**Usage**:\n\n```console\n$ springer set-default-catalog [OPTIONS]\n```\n\n**Options**:\n\n* `--help`: Show this message and exit.\n',
    'author': 'JnyJny',
    'author_email': 'erik.oshaughnessy@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'http://github.com/JnyJny/springer_downloader',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
