"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnWorkloads = exports.toJson_CfnWorkloadsProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnWorkloadsProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnWorkloadsProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'SourceGuid': obj.sourceGuid,
        'DuplicateName': obj.duplicateName,
        'Workload': obj.workload,
        'ListQueryFilter': obj.listQueryFilter,
        'Variables': obj.variables,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnWorkloadsProps = toJson_CfnWorkloadsProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `NewRelic::Observability::Workloads`
 *
 * @cloudformationResource NewRelic::Observability::Workloads
 * @stability external
 * @link https://github.com/newrelic-experimental/newrelic-cloudformation-resource-providers-workloads
 */
class CfnWorkloads extends cdk.CfnResource {
    /**
     * Create a new `NewRelic::Observability::Workloads`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnWorkloads.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnWorkloadsProps(props) });
        this.props = props;
        this.attrGuid = cdk.Token.asString(this.getAtt('Guid'));
    }
}
exports.CfnWorkloads = CfnWorkloads;
_a = JSII_RTTI_SYMBOL_1;
CfnWorkloads[_a] = { fqn: "@cdk-cloudformation/newrelic-observability-workloads.CfnWorkloads", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnWorkloads.CFN_RESOURCE_TYPE_NAME = "NewRelic::Observability::Workloads";
//# sourceMappingURL=data:application/json;base64,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