import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * CRUD operations for New Relic Workloads via the NerdGraph API
 *
 * @schema CfnWorkloadsProps
 */
export interface CfnWorkloadsProps {
    /**
     * @schema CfnWorkloadsProps#SourceGuid
     */
    readonly sourceGuid?: string;
    /**
     * @schema CfnWorkloadsProps#DuplicateName
     */
    readonly duplicateName?: string;
    /**
     * @schema CfnWorkloadsProps#Workload
     */
    readonly workload?: string;
    /**
     * @schema CfnWorkloadsProps#ListQueryFilter
     */
    readonly listQueryFilter?: string;
    /**
     * @schema CfnWorkloadsProps#Variables
     */
    readonly variables?: any;
}
/**
 * Converts an object of type 'CfnWorkloadsProps' to JSON representation.
 */
export declare function toJson_CfnWorkloadsProps(obj: CfnWorkloadsProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `NewRelic::Observability::Workloads`
 *
 * @cloudformationResource NewRelic::Observability::Workloads
 * @stability external
 * @link https://github.com/newrelic-experimental/newrelic-cloudformation-resource-providers-workloads
 */
export declare class CfnWorkloads extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "NewRelic::Observability::Workloads";
    /**
     * Resource props.
     */
    readonly props: CfnWorkloadsProps;
    /**
     * Attribute `NewRelic::Observability::Workloads.Guid`
     * @link https://github.com/newrelic-experimental/newrelic-cloudformation-resource-providers-workloads
     */
    readonly attrGuid: string;
    /**
     * Create a new `NewRelic::Observability::Workloads`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnWorkloadsProps);
}
