from typing import Dict, Any


__mastery = """
## Autogenerated runner by neugs_utils
import unittest
from neugs_utils import TierMasteryJSONTestRunner

if __name__ == '__main__':
    suite = unittest.defaultTestLoader.discover('tests')
    with open('/autograder/results/results.json', 'w') as f:
        TierMasteryJSONTestRunner(visibility='visible', stream=f).run(suite)

"""


__standard = """
## Autogenerated runner by neugs_utils
import unittest
from gradescope_utils.autograder_utils.json_test_runner import JSONTestRunner

if __name__ == '__main__':
    suite = unittest.defaultTestLoader.discover('tests')
    with open('/autograder/results/results.json', 'w') as f:
        JSONTestRunner(visibility='visible', stream=f).run(suite)

"""

def build_runner(config: Dict[str, Any]) -> str:
    """build a runner based on the type of grading system to use

    Args:
        config (Dict[str, Any]): a config file

    Returns:
        str: the file to write out
    """
    return __mastery if config["gtype"] == "mastery" else __standard