
from huobi.constant import *

class OrderListItem:
    """
    The order update received by request of order list.

    :member
        symbol: The symbol you subscribed.
        timestamp: The UNIX formatted timestamp generated by server in UTC.
        topic: request topic
        client_req_id: client request ID
        order_list : order list

    """

    def __init__(self):
        self.id = 0
        self.symbol = ""
        self.account_id = 0
        self.amount = 0.0
        self.price = 0.0
        self.created_at = 0
        self.type = OrderType.INVALID
        self.finished_at = 0
        self.source = OrderSource.INVALID
        self.state = OrderState.INVALID
        self.canceled_at = 0
        self.filled_amount = 0.0
        self.filled_cash_amount = 0.0
        self.filled_fees = 0.0
        self.stop_price = 0.0
        self.operator = ""


    def print_object(self, format_data=""):
        from huobi.utils.print_mix_object import PrintBasic
        PrintBasic.print_basic(self.id, format_data + "ID")
        PrintBasic.print_basic(self.symbol, format_data + "Symbol")
        PrintBasic.print_basic(self.account_id, format_data + "Account Id")
        PrintBasic.print_basic(self.amount, format_data + "Amount")
        PrintBasic.print_basic(self.price, format_data + "Price")
        PrintBasic.print_basic(self.created_at, format_data + "Create Time")
        PrintBasic.print_basic(self.type, format_data + "Order Type")
        PrintBasic.print_basic(self.finished_at, format_data + "Finish Time")
        PrintBasic.print_basic(self.source, format_data + "Order Source")
        PrintBasic.print_basic(self.state, format_data + "Order State")
        PrintBasic.print_basic(self.canceled_at, format_data + "Cancel Time")
        PrintBasic.print_basic(self.filled_amount, format_data + "Filled Amount")
        PrintBasic.print_basic(self.filled_cash_amount, format_data + "Filled Cash Amount")
        PrintBasic.print_basic(self.filled_fees, format_data + "Filled Fees")
        PrintBasic.print_basic(self.stop_price, format_data + "Stop Price")
        PrintBasic.print_basic(self.operator, format_data + "Operator")


