
class AccountBalanceReq:
    """
    The account change information received by subscription of account.

    :member
        ts: The UNIX formatted timestamp generated by server in UTC.
        cid: client request ID
        topic: request Channel or Topic
        data: The list of account and balance

    """

    def __init__(self):
        self.ts = 0
        self.cid = ""
        self.topic = ""
        self.data = list()


    def print_object(self, format_data=""):
        from huobi.utils.print_mix_object import PrintBasic
        PrintBasic.print_basic(self.ts, format_data + "Timestamp")
        PrintBasic.print_basic(self.cid, format_data + "Client Order ID")
        PrintBasic.print_basic(self.topic, format_data + "Topic")
        print()
        if len(self.data):
            for account_balance in self.data:
                account_balance.print_object()
                print()