# Changelog

<!-- markdownlint-disable MD024 -->

All notable changes to this project will be documented in this file.

The format is based on Semantic Versioning. Keep entries concise and tied to actual changes.

## [Unreleased]

## [0.3.2] - 2025-08-16

### Breaking Changes

- Change `Buff.remaining_turns` type from int to float; permanent durations now map to `float('inf')` (parsers and tests updated). If you relied on ints, adjust code to handle `math.inf` for permanence and floats for arithmetic.

### New Features

- Represent permanent buff durations as infinity to enable consistent duration math and comparisons across the API.

### Documentation

- Align API spec to reflect `Buff.remaining_turns: float` with `inf` for permanent
- Update SRS to v0.7 documenting the change
- Clarify git workflow docs for CHANGELOG update flow

## [0.3.1] - 2025-08-16

### Documentation

- Clarify PyPI distribution name vs import name in README
- Update SRS document version to v0.6 and specify package names

## [0.3.0] - 2025-08-16

### Added

- Initial public release of the `hv_bie` Python package
- Parsing engine for HentaiVerse battle snapshots (`hv_bie.parsers.core`)
- Data models and types (`hv_bie.types.models`, `hv_bie.types.system_monsters`, `py.typed` for PEP 561)
- Snapshot orchestration API (`hv_bie.snapshot`)
- Test suite and fixtures (`tests/unit`, `tests/perf`, `tests/fixtures/hv/*`)
- Project documentation (`README.md`, `API_SPEC.md`, `SRS.md`)
- Packaging and metadata (`pyproject.toml`, `hv_bie.egg-info/`, `LICENSE`)
- Contributor guidance for agents (`AGENTS.md`)

### Changed

- N/A

### Fixed

- N/A

### Documentation

- Project overview and agent workflows updated

[Unreleased]: https://github.com/Kuan-Lun/hv-bie/compare/v0.3.2...HEAD
[0.3.2]: https://github.com/Kuan-Lun/hv-bie/compare/v0.3.1...v0.3.2
[0.3.1]: https://github.com/Kuan-Lun/hv-bie/compare/v0.3.0...v0.3.1
