"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShardingInstance = exports.ShardingInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const mongodb_generated_1 = require("./mongodb.generated");
Object.defineProperty(exports, "ShardingInstanceProperty", { enumerable: true, get: function () { return mongodb_generated_1.RosShardingInstance; } });
/**
 * A ROS resource type:  `ALIYUN::MONGODB::ShardingInstance`
 */
class ShardingInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::MONGODB::ShardingInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosShardingInstance = new mongodb_generated_1.RosShardingInstance(this, id, {
            tdeStatus: props.tdeStatus,
            engineVersion: props.engineVersion === undefined || props.engineVersion === null ? '3.4' : props.engineVersion,
            zoneId: props.zoneId,
            resourceGroupId: props.resourceGroupId,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            securityIpArray: props.securityIpArray,
            mongos: props.mongos,
            storageEngine: props.storageEngine === undefined || props.storageEngine === null ? 'WiredTiger' : props.storageEngine,
            restoreTime: props.restoreTime,
            accountPassword: props.accountPassword,
            vpcId: props.vpcId,
            protocolType: props.protocolType,
            chargeType: props.chargeType === undefined || props.chargeType === null ? 'PostPaid' : props.chargeType,
            networkType: props.networkType,
            configServer: props.configServer,
            srcDbInstanceId: props.srcDbInstanceId,
            replicaSet: props.replicaSet,
            dbInstanceDescription: props.dbInstanceDescription,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosShardingInstance;
        this.attrDbInstanceId = rosShardingInstance.attrDbInstanceId;
        this.attrDbInstanceStatus = rosShardingInstance.attrDbInstanceStatus;
        this.attrOrderId = rosShardingInstance.attrOrderId;
    }
}
exports.ShardingInstance = ShardingInstance;
//# sourceMappingURL=data:application/json;base64,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