# Auto generated from mixs.yaml by pythongen.py version: 0.9.0
# Generation date: 2022-03-22T15:58:29
# Schema: MIxS
#
# id: http://w3id.org/mixs
# description: Minimal Information about any Sequence Standard
# license: https://creativecommons.org/publicdomain/zero/1.0/

import dataclasses
import sys
import re
from jsonasobj2 import JsonObj, as_dict
from typing import Optional, List, Union, Dict, ClassVar, Any
from dataclasses import dataclass
from linkml_runtime.linkml_model.meta import EnumDefinition, PermissibleValue, PvFormulaOptions

from linkml_runtime.utils.slot import Slot
from linkml_runtime.utils.metamodelcore import empty_list, empty_dict, bnode
from linkml_runtime.utils.yamlutils import YAMLRoot, extended_str, extended_float, extended_int
from linkml_runtime.utils.dataclass_extensions_376 import dataclasses_init_fn_with_kwargs
from linkml_runtime.utils.formatutils import camelcase, underscore, sfx
from linkml_runtime.utils.enumerations import EnumDefinitionImpl
from rdflib import Namespace, URIRef
from linkml_runtime.utils.curienamespace import CurieNamespace
from linkml_runtime.linkml_model.types import Date, Double, Integer, String
from linkml_runtime.utils.metamodelcore import XSDDate

metamodel_version = "1.7.0"
version = None

# Overwrite dataclasses _init_fn to add **kwargs in __init__
dataclasses._init_fn = dataclasses_init_fn_with_kwargs

# Namespaces
MIGS = CurieNamespace('MIGS', 'https://w3id.org/mixs/migs/')
MIXS = CurieNamespace('MIXS', 'https://w3id.org/mixs/terms/')
LINKML = CurieNamespace('linkml', 'https://w3id.org/linkml/')
MIXS_VOCAB = CurieNamespace('mixs_vocab', 'https://w3id.org/mixs/vocab/')
DEFAULT_ = MIXS.VOCAB


# Types

# Class references



@dataclass
class MIGSEukaryote(YAMLRoot):
    """
    Minimal Information about a Genome Sequence: eukaryote
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.MIGSEukaryote
    class_class_curie: ClassVar[str] = "mixs.vocab:MIGSEukaryote"
    class_name: ClassVar[str] = "MIGS eukaryote"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.MIGSEukaryote

    samp_name: str = None
    samp_taxon_id: str = None
    project_name: str = None
    lat_lon: str = None
    geo_loc_name: str = None
    collection_date: Union[str, XSDDate] = None
    env_broad_scale: str = None
    env_local_scale: str = None
    env_medium: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    ploidy: Optional[str] = None
    num_replicons: Optional[int] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    propagation: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self._is_empty(self.lat_lon):
            self.MissingRequiredField("lat_lon")
        if not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self._is_empty(self.geo_loc_name):
            self.MissingRequiredField("geo_loc_name")
        if not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self._is_empty(self.collection_date):
            self.MissingRequiredField("collection_date")
        if not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self._is_empty(self.env_broad_scale):
            self.MissingRequiredField("env_broad_scale")
        if not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self._is_empty(self.env_local_scale):
            self.MissingRequiredField("env_local_scale")
        if not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self._is_empty(self.env_medium):
            self.MissingRequiredField("env_medium")
        if not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.ploidy is not None and not isinstance(self.ploidy, str):
            self.ploidy = str(self.ploidy)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.propagation is not None and not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class MIGSBacteria(YAMLRoot):
    """
    Minimal Information about a Genome Sequence: cultured bacteria/archaea
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.MIGSBacteria
    class_class_curie: ClassVar[str] = "mixs.vocab:MIGSBacteria"
    class_name: ClassVar[str] = "MIGS bacteria"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.MIGSBacteria

    samp_name: str = None
    samp_taxon_id: str = None
    project_name: str = None
    lat_lon: str = None
    geo_loc_name: str = None
    collection_date: Union[str, XSDDate] = None
    env_broad_scale: str = None
    env_local_scale: str = None
    env_medium: str = None
    num_replicons: int = None
    ref_biomaterial: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    encoded_traits: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self._is_empty(self.lat_lon):
            self.MissingRequiredField("lat_lon")
        if not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self._is_empty(self.geo_loc_name):
            self.MissingRequiredField("geo_loc_name")
        if not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self._is_empty(self.collection_date):
            self.MissingRequiredField("collection_date")
        if not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self._is_empty(self.env_broad_scale):
            self.MissingRequiredField("env_broad_scale")
        if not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self._is_empty(self.env_local_scale):
            self.MissingRequiredField("env_local_scale")
        if not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self._is_empty(self.env_medium):
            self.MissingRequiredField("env_medium")
        if not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self._is_empty(self.num_replicons):
            self.MissingRequiredField("num_replicons")
        if not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self._is_empty(self.ref_biomaterial):
            self.MissingRequiredField("ref_biomaterial")
        if not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class MIGSPlant(YAMLRoot):
    """
    Minimal Information about a Genome Sequence: plant
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.MIGSPlant
    class_class_curie: ClassVar[str] = "mixs.vocab:MIGSPlant"
    class_name: ClassVar[str] = "MIGS plant"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.MIGSPlant

    samp_name: str = None
    samp_taxon_id: str = None
    project_name: str = None
    lat_lon: str = None
    geo_loc_name: str = None
    collection_date: Union[str, XSDDate] = None
    env_broad_scale: str = None
    env_local_scale: str = None
    env_medium: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self._is_empty(self.lat_lon):
            self.MissingRequiredField("lat_lon")
        if not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self._is_empty(self.geo_loc_name):
            self.MissingRequiredField("geo_loc_name")
        if not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self._is_empty(self.collection_date):
            self.MissingRequiredField("collection_date")
        if not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self._is_empty(self.env_broad_scale):
            self.MissingRequiredField("env_broad_scale")
        if not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self._is_empty(self.env_local_scale):
            self.MissingRequiredField("env_local_scale")
        if not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self._is_empty(self.env_medium):
            self.MissingRequiredField("env_medium")
        if not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class MIGSVirus(YAMLRoot):
    """
    Minimal Information about a Genome Sequence: cultured bacteria/archaea
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.MIGSVirus
    class_class_curie: ClassVar[str] = "mixs.vocab:MIGSVirus"
    class_name: ClassVar[str] = "MIGS virus"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.MIGSVirus

    samp_name: str = None
    samp_taxon_id: str = None
    project_name: str = None
    lat_lon: str = None
    geo_loc_name: str = None
    collection_date: Union[str, XSDDate] = None
    env_broad_scale: str = None
    env_local_scale: str = None
    env_medium: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    num_replicons: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    virus_enrich_appr: Optional[Union[str, "VirusEnrichApprEnum"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self._is_empty(self.lat_lon):
            self.MissingRequiredField("lat_lon")
        if not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self._is_empty(self.geo_loc_name):
            self.MissingRequiredField("geo_loc_name")
        if not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self._is_empty(self.collection_date):
            self.MissingRequiredField("collection_date")
        if not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self._is_empty(self.env_broad_scale):
            self.MissingRequiredField("env_broad_scale")
        if not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self._is_empty(self.env_local_scale):
            self.MissingRequiredField("env_local_scale")
        if not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self._is_empty(self.env_medium):
            self.MissingRequiredField("env_medium")
        if not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.virus_enrich_appr is not None and not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class MIGSOrg(YAMLRoot):
    """
    Minimal Information about a Genome Sequence: org
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.MIGSOrg
    class_class_curie: ClassVar[str] = "mixs.vocab:MIGSOrg"
    class_name: ClassVar[str] = "MIGS org"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.MIGSOrg

    samp_name: str = None
    samp_taxon_id: str = None
    project_name: str = None
    lat_lon: str = None
    geo_loc_name: str = None
    collection_date: Union[str, XSDDate] = None
    env_broad_scale: str = None
    env_local_scale: str = None
    env_medium: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self._is_empty(self.lat_lon):
            self.MissingRequiredField("lat_lon")
        if not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self._is_empty(self.geo_loc_name):
            self.MissingRequiredField("geo_loc_name")
        if not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self._is_empty(self.collection_date):
            self.MissingRequiredField("collection_date")
        if not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self._is_empty(self.env_broad_scale):
            self.MissingRequiredField("env_broad_scale")
        if not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self._is_empty(self.env_local_scale):
            self.MissingRequiredField("env_local_scale")
        if not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self._is_empty(self.env_medium):
            self.MissingRequiredField("env_medium")
        if not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class MIMS(YAMLRoot):
    """
    Metagenome or Environmental
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.MIMS
    class_class_curie: ClassVar[str] = "mixs.vocab:MIMS"
    class_name: ClassVar[str] = "MIMS"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.MIMS

    samp_name: str = None
    samp_taxon_id: str = None
    project_name: str = None
    lat_lon: str = None
    geo_loc_name: str = None
    collection_date: Union[str, XSDDate] = None
    env_broad_scale: str = None
    env_local_scale: str = None
    env_medium: str = None
    seq_meth: str = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    assembly_software: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self._is_empty(self.lat_lon):
            self.MissingRequiredField("lat_lon")
        if not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self._is_empty(self.geo_loc_name):
            self.MissingRequiredField("geo_loc_name")
        if not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self._is_empty(self.collection_date):
            self.MissingRequiredField("collection_date")
        if not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self._is_empty(self.env_broad_scale):
            self.MissingRequiredField("env_broad_scale")
        if not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self._is_empty(self.env_local_scale):
            self.MissingRequiredField("env_local_scale")
        if not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self._is_empty(self.env_medium):
            self.MissingRequiredField("env_medium")
        if not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class MIMARKSSpecimen(YAMLRoot):
    """
    Minimal Information about a Marker Specimen: specimen
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.MIMARKSSpecimen
    class_class_curie: ClassVar[str] = "mixs.vocab:MIMARKSSpecimen"
    class_name: ClassVar[str] = "MIMARKS specimen"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.MIMARKSSpecimen

    samp_name: str = None
    samp_taxon_id: str = None
    project_name: str = None
    lat_lon: str = None
    geo_loc_name: str = None
    collection_date: Union[str, XSDDate] = None
    env_broad_scale: str = None
    env_local_scale: str = None
    env_medium: str = None
    target_gene: str = None
    seq_meth: str = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    assembly_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self._is_empty(self.lat_lon):
            self.MissingRequiredField("lat_lon")
        if not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self._is_empty(self.geo_loc_name):
            self.MissingRequiredField("geo_loc_name")
        if not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self._is_empty(self.collection_date):
            self.MissingRequiredField("collection_date")
        if not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self._is_empty(self.env_broad_scale):
            self.MissingRequiredField("env_broad_scale")
        if not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self._is_empty(self.env_local_scale):
            self.MissingRequiredField("env_local_scale")
        if not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self._is_empty(self.env_medium):
            self.MissingRequiredField("env_medium")
        if not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class MIMARKSSurvey(YAMLRoot):
    """
    Minimal Information about a Marker Specimen: survey
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.MIMARKSSurvey
    class_class_curie: ClassVar[str] = "mixs.vocab:MIMARKSSurvey"
    class_name: ClassVar[str] = "MIMARKS survey"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.MIMARKSSurvey

    samp_name: str = None
    samp_taxon_id: str = None
    project_name: str = None
    lat_lon: str = None
    geo_loc_name: str = None
    collection_date: Union[str, XSDDate] = None
    env_broad_scale: str = None
    env_local_scale: str = None
    env_medium: str = None
    isol_growth_condt: str = None
    target_gene: str = None
    seq_meth: str = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    source_mat_id: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self._is_empty(self.lat_lon):
            self.MissingRequiredField("lat_lon")
        if not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self._is_empty(self.geo_loc_name):
            self.MissingRequiredField("geo_loc_name")
        if not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self._is_empty(self.collection_date):
            self.MissingRequiredField("collection_date")
        if not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self._is_empty(self.env_broad_scale):
            self.MissingRequiredField("env_broad_scale")
        if not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self._is_empty(self.env_local_scale):
            self.MissingRequiredField("env_local_scale")
        if not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self._is_empty(self.env_medium):
            self.MissingRequiredField("env_medium")
        if not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class MISAG(YAMLRoot):
    """
    Minimum Information About a Single Amplified Genome
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.MISAG
    class_class_curie: ClassVar[str] = "mixs.vocab:MISAG"
    class_name: ClassVar[str] = "MISAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.MISAG

    samp_name: str = None
    samp_taxon_id: str = None
    project_name: str = None
    lat_lon: str = None
    geo_loc_name: str = None
    collection_date: Union[str, XSDDate] = None
    env_broad_scale: str = None
    env_local_scale: str = None
    env_medium: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    sort_tech: Union[str, "SortTechEnum"] = None
    single_cell_lysis_appr: Union[str, "SingleCellLysisApprEnum"] = None
    wga_amp_appr: str = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self._is_empty(self.lat_lon):
            self.MissingRequiredField("lat_lon")
        if not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self._is_empty(self.geo_loc_name):
            self.MissingRequiredField("geo_loc_name")
        if not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self._is_empty(self.collection_date):
            self.MissingRequiredField("collection_date")
        if not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self._is_empty(self.env_broad_scale):
            self.MissingRequiredField("env_broad_scale")
        if not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self._is_empty(self.env_local_scale):
            self.MissingRequiredField("env_local_scale")
        if not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self._is_empty(self.env_medium):
            self.MissingRequiredField("env_medium")
        if not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.sort_tech):
            self.MissingRequiredField("sort_tech")
        if not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self._is_empty(self.single_cell_lysis_appr):
            self.MissingRequiredField("single_cell_lysis_appr")
        if not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self._is_empty(self.wga_amp_appr):
            self.MissingRequiredField("wga_amp_appr")
        if not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class MIMAG(YAMLRoot):
    """
    Minimum Information About a Metagenome-Assembled Genome
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.MIMAG
    class_class_curie: ClassVar[str] = "mixs.vocab:MIMAG"
    class_name: ClassVar[str] = "MIMAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.MIMAG

    samp_name: str = None
    samp_taxon_id: str = None
    project_name: str = None
    lat_lon: str = None
    geo_loc_name: str = None
    collection_date: Union[str, XSDDate] = None
    env_broad_scale: str = None
    env_local_scale: str = None
    env_medium: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    bin_param: Union[str, "BinParamEnum"] = None
    bin_software: str = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self._is_empty(self.lat_lon):
            self.MissingRequiredField("lat_lon")
        if not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self._is_empty(self.geo_loc_name):
            self.MissingRequiredField("geo_loc_name")
        if not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self._is_empty(self.collection_date):
            self.MissingRequiredField("collection_date")
        if not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self._is_empty(self.env_broad_scale):
            self.MissingRequiredField("env_broad_scale")
        if not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self._is_empty(self.env_local_scale):
            self.MissingRequiredField("env_local_scale")
        if not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self._is_empty(self.env_medium):
            self.MissingRequiredField("env_medium")
        if not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.bin_param):
            self.MissingRequiredField("bin_param")
        if not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self._is_empty(self.bin_software):
            self.MissingRequiredField("bin_software")
        if not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class MIUVIG(YAMLRoot):
    """
    Minimum Information About an Uncultivated Virus Genome
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.MIUVIG
    class_class_curie: ClassVar[str] = "mixs.vocab:MIUVIG"
    class_name: ClassVar[str] = "MIUVIG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.MIUVIG

    samp_name: str = None
    samp_taxon_id: str = None
    project_name: str = None
    lat_lon: str = None
    geo_loc_name: str = None
    collection_date: Union[str, XSDDate] = None
    env_broad_scale: str = None
    env_local_scale: str = None
    env_medium: str = None
    source_uvig: Union[str, "SourceUvigEnum"] = None
    virus_enrich_appr: Union[str, "VirusEnrichApprEnum"] = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    vir_ident_software: str = None
    pred_genome_type: Union[str, "PredGenomeTypeEnum"] = None
    pred_genome_struc: Union[str, "PredGenomeStrucEnum"] = None
    detec_type: str = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    sort_tech: Optional[Union[str, "SortTechEnum"]] = None
    single_cell_lysis_appr: Optional[Union[str, "SingleCellLysisApprEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_appr: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    bin_param: Optional[Union[str, "BinParamEnum"]] = None
    bin_software: Optional[str] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    otu_class_appr: Optional[str] = None
    otu_seq_comp_appr: Optional[str] = None
    otu_db: Optional[str] = None
    host_pred_appr: Optional[Union[str, "HostPredApprEnum"]] = None
    host_pred_est_acc: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self._is_empty(self.lat_lon):
            self.MissingRequiredField("lat_lon")
        if not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self._is_empty(self.geo_loc_name):
            self.MissingRequiredField("geo_loc_name")
        if not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self._is_empty(self.collection_date):
            self.MissingRequiredField("collection_date")
        if not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self._is_empty(self.env_broad_scale):
            self.MissingRequiredField("env_broad_scale")
        if not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self._is_empty(self.env_local_scale):
            self.MissingRequiredField("env_local_scale")
        if not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self._is_empty(self.env_medium):
            self.MissingRequiredField("env_medium")
        if not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self._is_empty(self.source_uvig):
            self.MissingRequiredField("source_uvig")
        if not isinstance(self.source_uvig, SourceUvigEnum):
            self.source_uvig = SourceUvigEnum(self.source_uvig)

        if self._is_empty(self.virus_enrich_appr):
            self.MissingRequiredField("virus_enrich_appr")
        if not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self._is_empty(self.vir_ident_software):
            self.MissingRequiredField("vir_ident_software")
        if not isinstance(self.vir_ident_software, str):
            self.vir_ident_software = str(self.vir_ident_software)

        if self._is_empty(self.pred_genome_type):
            self.MissingRequiredField("pred_genome_type")
        if not isinstance(self.pred_genome_type, PredGenomeTypeEnum):
            self.pred_genome_type = PredGenomeTypeEnum(self.pred_genome_type)

        if self._is_empty(self.pred_genome_struc):
            self.MissingRequiredField("pred_genome_struc")
        if not isinstance(self.pred_genome_struc, PredGenomeStrucEnum):
            self.pred_genome_struc = PredGenomeStrucEnum(self.pred_genome_struc)

        if self._is_empty(self.detec_type):
            self.MissingRequiredField("detec_type")
        if not isinstance(self.detec_type, str):
            self.detec_type = str(self.detec_type)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.sort_tech is not None and not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self.single_cell_lysis_appr is not None and not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_appr is not None and not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.bin_param is not None and not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self.bin_software is not None and not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.otu_class_appr is not None and not isinstance(self.otu_class_appr, str):
            self.otu_class_appr = str(self.otu_class_appr)

        if self.otu_seq_comp_appr is not None and not isinstance(self.otu_seq_comp_appr, str):
            self.otu_seq_comp_appr = str(self.otu_seq_comp_appr)

        if self.otu_db is not None and not isinstance(self.otu_db, str):
            self.otu_db = str(self.otu_db)

        if self.host_pred_appr is not None and not isinstance(self.host_pred_appr, HostPredApprEnum):
            self.host_pred_appr = HostPredApprEnum(self.host_pred_appr)

        if self.host_pred_est_acc is not None and not isinstance(self.host_pred_est_acc, str):
            self.host_pred_est_acc = str(self.host_pred_est_acc)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Core(YAMLRoot):
    """
    Core package. Do not use this directly, this is used to build other packages
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.Core
    class_class_curie: ClassVar[str] = "mixs.vocab:Core"
    class_name: ClassVar[str] = "core"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Core

    samp_name: Optional[str] = None
    samp_taxon_id: Optional[str] = None
    project_name: Optional[str] = None
    experimental_factor: Optional[str] = None
    lat_lon: Optional[str] = None
    depth: Optional[Union[dict, "QuantityValue"]] = None
    alt: Optional[Union[dict, "QuantityValue"]] = None
    elev: Optional[Union[dict, "QuantityValue"]] = None
    temp: Optional[Union[dict, "QuantityValue"]] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    ploidy: Optional[str] = None
    num_replicons: Optional[int] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    propagation: Optional[str] = None
    encoded_traits: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    isol_growth_condt: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    source_uvig: Optional[Union[str, "SourceUvigEnum"]] = None
    virus_enrich_appr: Optional[Union[str, "VirusEnrichApprEnum"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    target_gene: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_meth: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    assembly_software: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_score: Optional[str] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    sort_tech: Optional[Union[str, "SortTechEnum"]] = None
    single_cell_lysis_appr: Optional[Union[str, "SingleCellLysisApprEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_appr: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    bin_param: Optional[Union[str, "BinParamEnum"]] = None
    bin_software: Optional[str] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    vir_ident_software: Optional[str] = None
    pred_genome_type: Optional[Union[str, "PredGenomeTypeEnum"]] = None
    pred_genome_struc: Optional[Union[str, "PredGenomeStrucEnum"]] = None
    detec_type: Optional[str] = None
    otu_class_appr: Optional[str] = None
    otu_seq_comp_appr: Optional[str] = None
    otu_db: Optional[str] = None
    host_pred_appr: Optional[Union[str, "HostPredApprEnum"]] = None
    host_pred_est_acc: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self.samp_name is not None and not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self.samp_taxon_id is not None and not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self.project_name is not None and not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.depth is not None and not isinstance(self.depth, QuantityValue):
            self.depth = QuantityValue(**as_dict(self.depth))

        if self.alt is not None and not isinstance(self.alt, QuantityValue):
            self.alt = QuantityValue(**as_dict(self.alt))

        if self.elev is not None and not isinstance(self.elev, QuantityValue):
            self.elev = QuantityValue(**as_dict(self.elev))

        if self.temp is not None and not isinstance(self.temp, QuantityValue):
            self.temp = QuantityValue(**as_dict(self.temp))

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.ploidy is not None and not isinstance(self.ploidy, str):
            self.ploidy = str(self.ploidy)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.propagation is not None and not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.isol_growth_condt is not None and not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.source_uvig is not None and not isinstance(self.source_uvig, SourceUvigEnum):
            self.source_uvig = SourceUvigEnum(self.source_uvig)

        if self.virus_enrich_appr is not None and not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.target_gene is not None and not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_meth is not None and not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_score is not None and not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.sort_tech is not None and not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self.single_cell_lysis_appr is not None and not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_appr is not None and not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.bin_param is not None and not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self.bin_software is not None and not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.vir_ident_software is not None and not isinstance(self.vir_ident_software, str):
            self.vir_ident_software = str(self.vir_ident_software)

        if self.pred_genome_type is not None and not isinstance(self.pred_genome_type, PredGenomeTypeEnum):
            self.pred_genome_type = PredGenomeTypeEnum(self.pred_genome_type)

        if self.pred_genome_struc is not None and not isinstance(self.pred_genome_struc, PredGenomeStrucEnum):
            self.pred_genome_struc = PredGenomeStrucEnum(self.pred_genome_struc)

        if self.detec_type is not None and not isinstance(self.detec_type, str):
            self.detec_type = str(self.detec_type)

        if self.otu_class_appr is not None and not isinstance(self.otu_class_appr, str):
            self.otu_class_appr = str(self.otu_class_appr)

        if self.otu_seq_comp_appr is not None and not isinstance(self.otu_seq_comp_appr, str):
            self.otu_seq_comp_appr = str(self.otu_seq_comp_appr)

        if self.otu_db is not None and not isinstance(self.otu_db, str):
            self.otu_db = str(self.otu_db)

        if self.host_pred_appr is not None and not isinstance(self.host_pred_appr, HostPredApprEnum):
            self.host_pred_appr = HostPredApprEnum(self.host_pred_appr)

        if self.host_pred_est_acc is not None and not isinstance(self.host_pred_est_acc, str):
            self.host_pred_est_acc = str(self.host_pred_est_acc)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Air(YAMLRoot):
    """
    air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.Air
    class_class_curie: ClassVar[str] = "mixs.vocab:Air"
    class_name: ClassVar[str] = "air"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Air

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    lat_lon: Optional[str] = None
    depth: Optional[Union[dict, "QuantityValue"]] = None
    elev: Optional[Union[dict, "QuantityValue"]] = None
    temp: Optional[Union[dict, "QuantityValue"]] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    barometric_press: Optional[Union[dict, "QuantityValue"]] = None
    carb_dioxide: Optional[Union[dict, "QuantityValue"]] = None
    carb_monoxide: Optional[Union[dict, "QuantityValue"]] = None
    chem_administration: Optional[Union[str, List[str]]] = empty_list()
    humidity: Optional[Union[dict, "QuantityValue"]] = None
    methane: Optional[Union[dict, "QuantityValue"]] = None
    organism_count: Optional[Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]]] = empty_list()
    oxygen: Optional[Union[dict, "QuantityValue"]] = None
    oxy_stat_samp: Optional[Union[str, "OxyStatSampEnum"]] = None
    perturbation: Optional[Union[str, List[str]]] = empty_list()
    pollutants: Optional[Union[str, List[str]]] = empty_list()
    air_particulate_matter_concentration: Optional[Union[str, List[str]]] = empty_list()
    salinity: Optional[Union[dict, "QuantityValue"]] = None
    samp_store_dur: Optional[str] = None
    samp_store_loc: Optional[str] = None
    samp_store_temp: Optional[Union[dict, "QuantityValue"]] = None
    solar_irradiance: Optional[Union[dict, "QuantityValue"]] = None
    ventilation_rate: Optional[Union[dict, "QuantityValue"]] = None
    ventilation_type: Optional[str] = None
    volatile_org_comp: Optional[Union[str, List[str]]] = empty_list()
    wind_direction: Optional[str] = None
    wind_speed: Optional[Union[dict, "QuantityValue"]] = None
    misc_param: Optional[Union[str, List[str]]] = empty_list()
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.alt):
            self.MissingRequiredField("alt")
        if not isinstance(self.alt, QuantityValue):
            self.alt = QuantityValue(**as_dict(self.alt))

        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.depth is not None and not isinstance(self.depth, QuantityValue):
            self.depth = QuantityValue(**as_dict(self.depth))

        if self.elev is not None and not isinstance(self.elev, QuantityValue):
            self.elev = QuantityValue(**as_dict(self.elev))

        if self.temp is not None and not isinstance(self.temp, QuantityValue):
            self.temp = QuantityValue(**as_dict(self.temp))

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.barometric_press is not None and not isinstance(self.barometric_press, QuantityValue):
            self.barometric_press = QuantityValue(**as_dict(self.barometric_press))

        if self.carb_dioxide is not None and not isinstance(self.carb_dioxide, QuantityValue):
            self.carb_dioxide = QuantityValue(**as_dict(self.carb_dioxide))

        if self.carb_monoxide is not None and not isinstance(self.carb_monoxide, QuantityValue):
            self.carb_monoxide = QuantityValue(**as_dict(self.carb_monoxide))

        if not isinstance(self.chem_administration, list):
            self.chem_administration = [self.chem_administration] if self.chem_administration is not None else []
        self.chem_administration = [v if isinstance(v, str) else str(v) for v in self.chem_administration]

        if self.humidity is not None and not isinstance(self.humidity, QuantityValue):
            self.humidity = QuantityValue(**as_dict(self.humidity))

        if self.methane is not None and not isinstance(self.methane, QuantityValue):
            self.methane = QuantityValue(**as_dict(self.methane))

        if not isinstance(self.organism_count, list):
            self.organism_count = [self.organism_count] if self.organism_count is not None else []
        self.organism_count = [v if isinstance(v, OrganismCountEnum) else OrganismCountEnum(v) for v in self.organism_count]

        if self.oxygen is not None and not isinstance(self.oxygen, QuantityValue):
            self.oxygen = QuantityValue(**as_dict(self.oxygen))

        if self.oxy_stat_samp is not None and not isinstance(self.oxy_stat_samp, OxyStatSampEnum):
            self.oxy_stat_samp = OxyStatSampEnum(self.oxy_stat_samp)

        if not isinstance(self.perturbation, list):
            self.perturbation = [self.perturbation] if self.perturbation is not None else []
        self.perturbation = [v if isinstance(v, str) else str(v) for v in self.perturbation]

        if not isinstance(self.pollutants, list):
            self.pollutants = [self.pollutants] if self.pollutants is not None else []
        self.pollutants = [v if isinstance(v, str) else str(v) for v in self.pollutants]

        if not isinstance(self.air_particulate_matter_concentration, list):
            self.air_particulate_matter_concentration = [self.air_particulate_matter_concentration] if self.air_particulate_matter_concentration is not None else []
        self.air_particulate_matter_concentration = [v if isinstance(v, str) else str(v) for v in self.air_particulate_matter_concentration]

        if self.salinity is not None and not isinstance(self.salinity, QuantityValue):
            self.salinity = QuantityValue(**as_dict(self.salinity))

        if self.samp_store_dur is not None and not isinstance(self.samp_store_dur, str):
            self.samp_store_dur = str(self.samp_store_dur)

        if self.samp_store_loc is not None and not isinstance(self.samp_store_loc, str):
            self.samp_store_loc = str(self.samp_store_loc)

        if self.samp_store_temp is not None and not isinstance(self.samp_store_temp, QuantityValue):
            self.samp_store_temp = QuantityValue(**as_dict(self.samp_store_temp))

        if self.solar_irradiance is not None and not isinstance(self.solar_irradiance, QuantityValue):
            self.solar_irradiance = QuantityValue(**as_dict(self.solar_irradiance))

        if self.ventilation_rate is not None and not isinstance(self.ventilation_rate, QuantityValue):
            self.ventilation_rate = QuantityValue(**as_dict(self.ventilation_rate))

        if self.ventilation_type is not None and not isinstance(self.ventilation_type, str):
            self.ventilation_type = str(self.ventilation_type)

        if not isinstance(self.volatile_org_comp, list):
            self.volatile_org_comp = [self.volatile_org_comp] if self.volatile_org_comp is not None else []
        self.volatile_org_comp = [v if isinstance(v, str) else str(v) for v in self.volatile_org_comp]

        if self.wind_direction is not None and not isinstance(self.wind_direction, str):
            self.wind_direction = str(self.wind_direction)

        if self.wind_speed is not None and not isinstance(self.wind_speed, QuantityValue):
            self.wind_speed = QuantityValue(**as_dict(self.wind_speed))

        if not isinstance(self.misc_param, list):
            self.misc_param = [self.misc_param] if self.misc_param is not None else []
        self.misc_param = [v if isinstance(v, str) else str(v) for v in self.misc_param]

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        super().__post_init__(**kwargs)


@dataclass
class AirMIGSEukaryote(Air):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: eukaryote with environmental package air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIGSEukaryote
    class_class_curie: ClassVar[str] = "mixs.vocab:AirMIGSEukaryote"
    class_name: ClassVar[str] = "air MIGS eukaryote"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIGSEukaryote

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    ploidy: Optional[str] = None
    num_replicons: Optional[int] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    propagation: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.ploidy is not None and not isinstance(self.ploidy, str):
            self.ploidy = str(self.ploidy)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.propagation is not None and not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class AirMIGSBacteria(Air):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIGSBacteria
    class_class_curie: ClassVar[str] = "mixs.vocab:AirMIGSBacteria"
    class_name: ClassVar[str] = "air MIGS bacteria"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIGSBacteria

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    num_replicons: int = None
    ref_biomaterial: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    encoded_traits: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.num_replicons):
            self.MissingRequiredField("num_replicons")
        if not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self._is_empty(self.ref_biomaterial):
            self.MissingRequiredField("ref_biomaterial")
        if not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class AirMIGSPlant(Air):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: plant with environmental package air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIGSPlant
    class_class_curie: ClassVar[str] = "mixs.vocab:AirMIGSPlant"
    class_name: ClassVar[str] = "air MIGS plant"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIGSPlant

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class AirMIGSVirus(Air):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIGSVirus
    class_class_curie: ClassVar[str] = "mixs.vocab:AirMIGSVirus"
    class_name: ClassVar[str] = "air MIGS virus"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIGSVirus

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    num_replicons: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    virus_enrich_appr: Optional[Union[str, "VirusEnrichApprEnum"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.virus_enrich_appr is not None and not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class AirMIGSOrg(Air):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: org with environmental package air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIGSOrg
    class_class_curie: ClassVar[str] = "mixs.vocab:AirMIGSOrg"
    class_name: ClassVar[str] = "air MIGS org"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIGSOrg

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class AirMIMS(Air):
    """
    Combinatorial checklist Metagenome or Environmental with environmental package air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIMS
    class_class_curie: ClassVar[str] = "mixs.vocab:AirMIMS"
    class_name: ClassVar[str] = "air MIMS"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIMS

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    assembly_software: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class AirMIMARKSSpecimen(Air):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: specimen with environmental package air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIMARKSSpecimen
    class_class_curie: ClassVar[str] = "mixs.vocab:AirMIMARKSSpecimen"
    class_name: ClassVar[str] = "air MIMARKS specimen"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIMARKSSpecimen

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    assembly_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class AirMIMARKSSurvey(Air):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: survey with environmental package air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIMARKSSurvey
    class_class_curie: ClassVar[str] = "mixs.vocab:AirMIMARKSSurvey"
    class_name: ClassVar[str] = "air MIMARKS survey"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIMARKSSurvey

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    source_mat_id: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class AirMISAG(Air):
    """
    Combinatorial checklist Minimum Information About a Single Amplified Genome with environmental package air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMISAG
    class_class_curie: ClassVar[str] = "mixs.vocab:AirMISAG"
    class_name: ClassVar[str] = "air MISAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMISAG

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    sort_tech: Union[str, "SortTechEnum"] = None
    single_cell_lysis_appr: Union[str, "SingleCellLysisApprEnum"] = None
    wga_amp_appr: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.sort_tech):
            self.MissingRequiredField("sort_tech")
        if not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self._is_empty(self.single_cell_lysis_appr):
            self.MissingRequiredField("single_cell_lysis_appr")
        if not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self._is_empty(self.wga_amp_appr):
            self.MissingRequiredField("wga_amp_appr")
        if not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class AirMIMAG(Air):
    """
    Combinatorial checklist Minimum Information About a Metagenome-Assembled Genome with environmental package air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIMAG
    class_class_curie: ClassVar[str] = "mixs.vocab:AirMIMAG"
    class_name: ClassVar[str] = "air MIMAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIMAG

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    bin_param: Union[str, "BinParamEnum"] = None
    bin_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.bin_param):
            self.MissingRequiredField("bin_param")
        if not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self._is_empty(self.bin_software):
            self.MissingRequiredField("bin_software")
        if not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class AirMIUVIG(Air):
    """
    Combinatorial checklist Minimum Information About an Uncultivated Virus Genome with environmental package air
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIUVIG
    class_class_curie: ClassVar[str] = "mixs.vocab:AirMIUVIG"
    class_name: ClassVar[str] = "air MIUVIG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.AirMIUVIG

    alt: Union[dict, "QuantityValue"] = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    source_uvig: Union[str, "SourceUvigEnum"] = None
    virus_enrich_appr: Union[str, "VirusEnrichApprEnum"] = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    vir_ident_software: str = None
    pred_genome_type: Union[str, "PredGenomeTypeEnum"] = None
    pred_genome_struc: Union[str, "PredGenomeStrucEnum"] = None
    detec_type: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    sort_tech: Optional[Union[str, "SortTechEnum"]] = None
    single_cell_lysis_appr: Optional[Union[str, "SingleCellLysisApprEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_appr: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    bin_param: Optional[Union[str, "BinParamEnum"]] = None
    bin_software: Optional[str] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    otu_class_appr: Optional[str] = None
    otu_seq_comp_appr: Optional[str] = None
    otu_db: Optional[str] = None
    host_pred_appr: Optional[Union[str, "HostPredApprEnum"]] = None
    host_pred_est_acc: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.source_uvig):
            self.MissingRequiredField("source_uvig")
        if not isinstance(self.source_uvig, SourceUvigEnum):
            self.source_uvig = SourceUvigEnum(self.source_uvig)

        if self._is_empty(self.virus_enrich_appr):
            self.MissingRequiredField("virus_enrich_appr")
        if not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self._is_empty(self.vir_ident_software):
            self.MissingRequiredField("vir_ident_software")
        if not isinstance(self.vir_ident_software, str):
            self.vir_ident_software = str(self.vir_ident_software)

        if self._is_empty(self.pred_genome_type):
            self.MissingRequiredField("pred_genome_type")
        if not isinstance(self.pred_genome_type, PredGenomeTypeEnum):
            self.pred_genome_type = PredGenomeTypeEnum(self.pred_genome_type)

        if self._is_empty(self.pred_genome_struc):
            self.MissingRequiredField("pred_genome_struc")
        if not isinstance(self.pred_genome_struc, PredGenomeStrucEnum):
            self.pred_genome_struc = PredGenomeStrucEnum(self.pred_genome_struc)

        if self._is_empty(self.detec_type):
            self.MissingRequiredField("detec_type")
        if not isinstance(self.detec_type, str):
            self.detec_type = str(self.detec_type)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.sort_tech is not None and not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self.single_cell_lysis_appr is not None and not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_appr is not None and not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.bin_param is not None and not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self.bin_software is not None and not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.otu_class_appr is not None and not isinstance(self.otu_class_appr, str):
            self.otu_class_appr = str(self.otu_class_appr)

        if self.otu_seq_comp_appr is not None and not isinstance(self.otu_seq_comp_appr, str):
            self.otu_seq_comp_appr = str(self.otu_seq_comp_appr)

        if self.otu_db is not None and not isinstance(self.otu_db, str):
            self.otu_db = str(self.otu_db)

        if self.host_pred_appr is not None and not isinstance(self.host_pred_appr, HostPredApprEnum):
            self.host_pred_appr = HostPredApprEnum(self.host_pred_appr)

        if self.host_pred_est_acc is not None and not isinstance(self.host_pred_est_acc, str):
            self.host_pred_est_acc = str(self.host_pred_est_acc)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironment(YAMLRoot):
    """
    built environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironment
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironment"
    class_name: ClassVar[str] = "built environment"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironment

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    lat_lon: Optional[str] = None
    depth: Optional[Union[dict, "QuantityValue"]] = None
    alt: Optional[Union[dict, "QuantityValue"]] = None
    elev: Optional[Union[dict, "QuantityValue"]] = None
    temp: Optional[Union[dict, "QuantityValue"]] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    surf_material: Optional[Union[str, "SurfMaterialEnum"]] = None
    surf_air_cont: Optional[Union[Union[str, "SurfAirContEnum"], List[Union[str, "SurfAirContEnum"]]]] = empty_list()
    surf_humidity: Optional[Union[dict, "QuantityValue"]] = None
    surf_temp: Optional[Union[dict, "QuantityValue"]] = None
    surf_moisture_ph: Optional[float] = None
    surf_moisture: Optional[Union[dict, "QuantityValue"]] = None
    dew_point: Optional[Union[dict, "QuantityValue"]] = None
    indoor_surf: Optional[Union[str, "IndoorSurfEnum"]] = None
    substructure_type: Optional[Union[Union[str, "SubstructureTypeEnum"], List[Union[str, "SubstructureTypeEnum"]]]] = empty_list()
    samp_sort_meth: Optional[Union[str, List[str]]] = empty_list()
    address: Optional[str] = None
    adj_room: Optional[str] = None
    aero_struc: Optional[str] = None
    amount_light: Optional[Union[dict, "QuantityValue"]] = None
    arch_struc: Optional[Union[str, "ArchStrucEnum"]] = None
    avg_occup: Optional[float] = None
    avg_dew_point: Optional[Union[dict, "QuantityValue"]] = None
    avg_temp: Optional[Union[dict, "QuantityValue"]] = None
    bathroom_count: Optional[int] = None
    bedroom_count: Optional[int] = None
    built_struc_age: Optional[Union[dict, "QuantityValue"]] = None
    built_struc_set: Optional[str] = None
    built_struc_type: Optional[str] = None
    ceil_area: Optional[Union[dict, "QuantityValue"]] = None
    ceil_cond: Optional[Union[str, "CeilCondEnum"]] = None
    ceil_finish_mat: Optional[Union[str, "CeilFinishMatEnum"]] = None
    ceil_water_mold: Optional[str] = None
    ceil_struc: Optional[str] = None
    ceil_texture: Optional[Union[str, "CeilTextureEnum"]] = None
    ceil_thermal_mass: Optional[Union[dict, "QuantityValue"]] = None
    ceil_type: Optional[Union[str, "CeilTypeEnum"]] = None
    cool_syst_id: Optional[int] = None
    date_last_rain: Optional[Union[str, XSDDate]] = None
    build_docs: Optional[Union[str, "BuildDocsEnum"]] = None
    door_size: Optional[Union[dict, "QuantityValue"]] = None
    door_cond: Optional[Union[str, "DoorCondEnum"]] = None
    door_direct: Optional[Union[str, "DoorDirectEnum"]] = None
    door_loc: Optional[Union[str, "DoorLocEnum"]] = None
    door_mat: Optional[Union[str, "DoorMatEnum"]] = None
    door_move: Optional[Union[str, "DoorMoveEnum"]] = None
    door_water_mold: Optional[str] = None
    door_type: Optional[Union[str, "DoorTypeEnum"]] = None
    door_comp_type: Optional[Union[str, "DoorCompTypeEnum"]] = None
    door_type_metal: Optional[Union[str, "DoorTypeMetalEnum"]] = None
    door_type_wood: Optional[Union[str, "DoorTypeWoodEnum"]] = None
    drawings: Optional[Union[str, "DrawingsEnum"]] = None
    elevator: Optional[int] = None
    escalator: Optional[int] = None
    exp_duct: Optional[Union[dict, "QuantityValue"]] = None
    exp_pipe: Optional[int] = None
    ext_door: Optional[int] = None
    fireplace_type: Optional[str] = None
    floor_age: Optional[Union[dict, "QuantityValue"]] = None
    floor_area: Optional[Union[dict, "QuantityValue"]] = None
    floor_cond: Optional[Union[str, "FloorCondEnum"]] = None
    floor_count: Optional[int] = None
    floor_finish_mat: Optional[Union[str, "FloorFinishMatEnum"]] = None
    floor_water_mold: Optional[Union[str, "FloorWaterMoldEnum"]] = None
    floor_struc: Optional[Union[str, "FloorStrucEnum"]] = None
    floor_thermal_mass: Optional[Union[dict, "QuantityValue"]] = None
    freq_clean: Optional[Union[str, "FreqCleanEnum"]] = None
    freq_cook: Optional[int] = None
    furniture: Optional[Union[str, "FurnitureEnum"]] = None
    gender_restroom: Optional[Union[str, "GenderRestroomEnum"]] = None
    hall_count: Optional[int] = None
    handidness: Optional[Union[str, "HandidnessEnum"]] = None
    heat_deliv_loc: Optional[Union[str, "HeatDelivLocEnum"]] = None
    heat_sys_deliv_meth: Optional[str] = None
    heat_system_id: Optional[int] = None
    height_carper_fiber: Optional[Union[dict, "QuantityValue"]] = None
    inside_lux: Optional[Union[dict, "QuantityValue"]] = None
    int_wall_cond: Optional[Union[str, "IntWallCondEnum"]] = None
    last_clean: Optional[Union[str, XSDDate]] = None
    max_occup: Optional[int] = None
    mech_struc: Optional[Union[str, "MechStrucEnum"]] = None
    number_plants: Optional[int] = None
    number_pets: Optional[int] = None
    number_resident: Optional[int] = None
    occup_document: Optional[Union[str, "OccupDocumentEnum"]] = None
    ext_wall_orient: Optional[Union[str, "ExtWallOrientEnum"]] = None
    ext_window_orient: Optional[Union[str, "ExtWindowOrientEnum"]] = None
    rel_humidity_out: Optional[Union[dict, "QuantityValue"]] = None
    pres_animal_insect: Optional[str] = None
    quad_pos: Optional[Union[str, "QuadPosEnum"]] = None
    rel_samp_loc: Optional[Union[str, "RelSampLocEnum"]] = None
    room_air_exch_rate: Optional[Union[dict, "QuantityValue"]] = None
    room_architec_elem: Optional[str] = None
    room_condt: Optional[Union[str, "RoomCondtEnum"]] = None
    room_count: Optional[int] = None
    room_dim: Optional[str] = None
    room_door_dist: Optional[str] = None
    room_loc: Optional[Union[str, "RoomLocEnum"]] = None
    room_moist_dam_hist: Optional[int] = None
    room_net_area: Optional[str] = None
    room_occup: Optional[int] = None
    room_samp_pos: Optional[Union[str, "RoomSampPosEnum"]] = None
    room_type: Optional[Union[str, "RoomTypeEnum"]] = None
    room_vol: Optional[str] = None
    room_window_count: Optional[int] = None
    room_connected: Optional[Union[str, "RoomConnectedEnum"]] = None
    room_hallway: Optional[str] = None
    room_door_share: Optional[str] = None
    room_wall_share: Optional[str] = None
    samp_weather: Optional[Union[str, "SampWeatherEnum"]] = None
    samp_floor: Optional[Union[str, "SampFloorEnum"]] = None
    samp_room_id: Optional[int] = None
    samp_time_out: Optional[float] = None
    season: Optional[str] = None
    season_use: Optional[Union[str, "SeasonUseEnum"]] = None
    shading_device_cond: Optional[Union[str, "ShadingDeviceCondEnum"]] = None
    shading_device_loc: Optional[str] = None
    shading_device_mat: Optional[str] = None
    shad_dev_water_mold: Optional[str] = None
    shading_device_type: Optional[Union[str, "ShadingDeviceTypeEnum"]] = None
    specific_humidity: Optional[Union[dict, "QuantityValue"]] = None
    specific: Optional[Union[str, "SpecificEnum"]] = None
    temp_out: Optional[Union[dict, "QuantityValue"]] = None
    train_line: Optional[Union[str, "TrainLineEnum"]] = None
    train_stat_loc: Optional[Union[str, "TrainStatLocEnum"]] = None
    train_stop_loc: Optional[Union[str, "TrainStopLocEnum"]] = None
    vis_media: Optional[Union[str, "VisMediaEnum"]] = None
    wall_area: Optional[Union[dict, "QuantityValue"]] = None
    wall_const_type: Optional[Union[str, "WallConstTypeEnum"]] = None
    wall_finish_mat: Optional[Union[str, "WallFinishMatEnum"]] = None
    wall_height: Optional[Union[dict, "QuantityValue"]] = None
    wall_loc: Optional[Union[str, "WallLocEnum"]] = None
    wall_water_mold: Optional[str] = None
    wall_surf_treatment: Optional[Union[str, "WallSurfTreatmentEnum"]] = None
    wall_texture: Optional[Union[str, "WallTextureEnum"]] = None
    wall_thermal_mass: Optional[Union[dict, "QuantityValue"]] = None
    water_feat_size: Optional[Union[dict, "QuantityValue"]] = None
    water_feat_type: Optional[Union[str, "WaterFeatTypeEnum"]] = None
    weekday: Optional[Union[str, "WeekdayEnum"]] = None
    window_size: Optional[str] = None
    window_cond: Optional[Union[str, "WindowCondEnum"]] = None
    window_cover: Optional[Union[str, "WindowCoverEnum"]] = None
    window_horiz_pos: Optional[Union[str, "WindowHorizPosEnum"]] = None
    window_loc: Optional[Union[str, "WindowLocEnum"]] = None
    window_mat: Optional[Union[str, "WindowMatEnum"]] = None
    window_open_freq: Optional[int] = None
    window_water_mold: Optional[str] = None
    window_status: Optional[str] = None
    window_type: Optional[Union[str, "WindowTypeEnum"]] = None
    window_vert_pos: Optional[Union[str, "WindowVertPosEnum"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.rel_air_humidity):
            self.MissingRequiredField("rel_air_humidity")
        if not isinstance(self.rel_air_humidity, QuantityValue):
            self.rel_air_humidity = QuantityValue(**as_dict(self.rel_air_humidity))

        if self._is_empty(self.abs_air_humidity):
            self.MissingRequiredField("abs_air_humidity")
        if not isinstance(self.abs_air_humidity, QuantityValue):
            self.abs_air_humidity = QuantityValue(**as_dict(self.abs_air_humidity))

        if self._is_empty(self.temp):
            self.MissingRequiredField("temp")
        if not isinstance(self.temp, QuantityValue):
            self.temp = QuantityValue(**as_dict(self.temp))

        if self._is_empty(self.build_occup_type):
            self.MissingRequiredField("build_occup_type")
        if not isinstance(self.build_occup_type, list):
            self.build_occup_type = [self.build_occup_type] if self.build_occup_type is not None else []
        self.build_occup_type = [v if isinstance(v, BuildOccupTypeEnum) else BuildOccupTypeEnum(v) for v in self.build_occup_type]

        if self._is_empty(self.carb_dioxide):
            self.MissingRequiredField("carb_dioxide")
        if not isinstance(self.carb_dioxide, QuantityValue):
            self.carb_dioxide = QuantityValue(**as_dict(self.carb_dioxide))

        if self._is_empty(self.ventilation_type):
            self.MissingRequiredField("ventilation_type")
        if not isinstance(self.ventilation_type, str):
            self.ventilation_type = str(self.ventilation_type)

        if self._is_empty(self.organism_count):
            self.MissingRequiredField("organism_count")
        if not isinstance(self.organism_count, list):
            self.organism_count = [self.organism_count] if self.organism_count is not None else []
        self.organism_count = [v if isinstance(v, OrganismCountEnum) else OrganismCountEnum(v) for v in self.organism_count]

        if self._is_empty(self.indoor_space):
            self.MissingRequiredField("indoor_space")
        if not isinstance(self.indoor_space, IndoorSpaceEnum):
            self.indoor_space = IndoorSpaceEnum(self.indoor_space)

        if self._is_empty(self.filter_type):
            self.MissingRequiredField("filter_type")
        if not isinstance(self.filter_type, list):
            self.filter_type = [self.filter_type] if self.filter_type is not None else []
        self.filter_type = [v if isinstance(v, FilterTypeEnum) else FilterTypeEnum(v) for v in self.filter_type]

        if self._is_empty(self.heat_cool_type):
            self.MissingRequiredField("heat_cool_type")
        if not isinstance(self.heat_cool_type, list):
            self.heat_cool_type = [self.heat_cool_type] if self.heat_cool_type is not None else []
        self.heat_cool_type = [v if isinstance(v, HeatCoolTypeEnum) else HeatCoolTypeEnum(v) for v in self.heat_cool_type]

        if self._is_empty(self.building_setting):
            self.MissingRequiredField("building_setting")
        if not isinstance(self.building_setting, BuildingSettingEnum):
            self.building_setting = BuildingSettingEnum(self.building_setting)

        if self._is_empty(self.light_type):
            self.MissingRequiredField("light_type")
        if not isinstance(self.light_type, list):
            self.light_type = [self.light_type] if self.light_type is not None else []
        self.light_type = [v if isinstance(v, LightTypeEnum) else LightTypeEnum(v) for v in self.light_type]

        if self._is_empty(self.space_typ_state):
            self.MissingRequiredField("space_typ_state")
        if not isinstance(self.space_typ_state, str):
            self.space_typ_state = str(self.space_typ_state)

        if self._is_empty(self.typ_occup_density):
            self.MissingRequiredField("typ_occup_density")
        if not isinstance(self.typ_occup_density, float):
            self.typ_occup_density = float(self.typ_occup_density)

        if self._is_empty(self.occup_samp):
            self.MissingRequiredField("occup_samp")
        if not isinstance(self.occup_samp, int):
            self.occup_samp = int(self.occup_samp)

        if self._is_empty(self.occup_density_samp):
            self.MissingRequiredField("occup_density_samp")
        if not isinstance(self.occup_density_samp, float):
            self.occup_density_samp = float(self.occup_density_samp)

        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.depth is not None and not isinstance(self.depth, QuantityValue):
            self.depth = QuantityValue(**as_dict(self.depth))

        if self.alt is not None and not isinstance(self.alt, QuantityValue):
            self.alt = QuantityValue(**as_dict(self.alt))

        if self.elev is not None and not isinstance(self.elev, QuantityValue):
            self.elev = QuantityValue(**as_dict(self.elev))

        if self.temp is not None and not isinstance(self.temp, QuantityValue):
            self.temp = QuantityValue(**as_dict(self.temp))

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.surf_material is not None and not isinstance(self.surf_material, SurfMaterialEnum):
            self.surf_material = SurfMaterialEnum(self.surf_material)

        if not isinstance(self.surf_air_cont, list):
            self.surf_air_cont = [self.surf_air_cont] if self.surf_air_cont is not None else []
        self.surf_air_cont = [v if isinstance(v, SurfAirContEnum) else SurfAirContEnum(v) for v in self.surf_air_cont]

        if self.surf_humidity is not None and not isinstance(self.surf_humidity, QuantityValue):
            self.surf_humidity = QuantityValue(**as_dict(self.surf_humidity))

        if self.surf_temp is not None and not isinstance(self.surf_temp, QuantityValue):
            self.surf_temp = QuantityValue(**as_dict(self.surf_temp))

        if self.surf_moisture_ph is not None and not isinstance(self.surf_moisture_ph, float):
            self.surf_moisture_ph = float(self.surf_moisture_ph)

        if self.surf_moisture is not None and not isinstance(self.surf_moisture, QuantityValue):
            self.surf_moisture = QuantityValue(**as_dict(self.surf_moisture))

        if self.dew_point is not None and not isinstance(self.dew_point, QuantityValue):
            self.dew_point = QuantityValue(**as_dict(self.dew_point))

        if self.indoor_surf is not None and not isinstance(self.indoor_surf, IndoorSurfEnum):
            self.indoor_surf = IndoorSurfEnum(self.indoor_surf)

        if not isinstance(self.substructure_type, list):
            self.substructure_type = [self.substructure_type] if self.substructure_type is not None else []
        self.substructure_type = [v if isinstance(v, SubstructureTypeEnum) else SubstructureTypeEnum(v) for v in self.substructure_type]

        if not isinstance(self.samp_sort_meth, list):
            self.samp_sort_meth = [self.samp_sort_meth] if self.samp_sort_meth is not None else []
        self.samp_sort_meth = [v if isinstance(v, str) else str(v) for v in self.samp_sort_meth]

        if self.address is not None and not isinstance(self.address, str):
            self.address = str(self.address)

        if self.adj_room is not None and not isinstance(self.adj_room, str):
            self.adj_room = str(self.adj_room)

        if self.aero_struc is not None and not isinstance(self.aero_struc, str):
            self.aero_struc = str(self.aero_struc)

        if self.amount_light is not None and not isinstance(self.amount_light, QuantityValue):
            self.amount_light = QuantityValue(**as_dict(self.amount_light))

        if self.arch_struc is not None and not isinstance(self.arch_struc, ArchStrucEnum):
            self.arch_struc = ArchStrucEnum(self.arch_struc)

        if self.avg_occup is not None and not isinstance(self.avg_occup, float):
            self.avg_occup = float(self.avg_occup)

        if self.avg_dew_point is not None and not isinstance(self.avg_dew_point, QuantityValue):
            self.avg_dew_point = QuantityValue(**as_dict(self.avg_dew_point))

        if self.avg_temp is not None and not isinstance(self.avg_temp, QuantityValue):
            self.avg_temp = QuantityValue(**as_dict(self.avg_temp))

        if self.bathroom_count is not None and not isinstance(self.bathroom_count, int):
            self.bathroom_count = int(self.bathroom_count)

        if self.bedroom_count is not None and not isinstance(self.bedroom_count, int):
            self.bedroom_count = int(self.bedroom_count)

        if self.built_struc_age is not None and not isinstance(self.built_struc_age, QuantityValue):
            self.built_struc_age = QuantityValue(**as_dict(self.built_struc_age))

        if self.built_struc_set is not None and not isinstance(self.built_struc_set, str):
            self.built_struc_set = str(self.built_struc_set)

        if self.built_struc_type is not None and not isinstance(self.built_struc_type, str):
            self.built_struc_type = str(self.built_struc_type)

        if self.ceil_area is not None and not isinstance(self.ceil_area, QuantityValue):
            self.ceil_area = QuantityValue(**as_dict(self.ceil_area))

        if self.ceil_cond is not None and not isinstance(self.ceil_cond, CeilCondEnum):
            self.ceil_cond = CeilCondEnum(self.ceil_cond)

        if self.ceil_finish_mat is not None and not isinstance(self.ceil_finish_mat, CeilFinishMatEnum):
            self.ceil_finish_mat = CeilFinishMatEnum(self.ceil_finish_mat)

        if self.ceil_water_mold is not None and not isinstance(self.ceil_water_mold, str):
            self.ceil_water_mold = str(self.ceil_water_mold)

        if self.ceil_struc is not None and not isinstance(self.ceil_struc, str):
            self.ceil_struc = str(self.ceil_struc)

        if self.ceil_texture is not None and not isinstance(self.ceil_texture, CeilTextureEnum):
            self.ceil_texture = CeilTextureEnum(self.ceil_texture)

        if self.ceil_thermal_mass is not None and not isinstance(self.ceil_thermal_mass, QuantityValue):
            self.ceil_thermal_mass = QuantityValue(**as_dict(self.ceil_thermal_mass))

        if self.ceil_type is not None and not isinstance(self.ceil_type, CeilTypeEnum):
            self.ceil_type = CeilTypeEnum(self.ceil_type)

        if self.cool_syst_id is not None and not isinstance(self.cool_syst_id, int):
            self.cool_syst_id = int(self.cool_syst_id)

        if self.date_last_rain is not None and not isinstance(self.date_last_rain, XSDDate):
            self.date_last_rain = XSDDate(self.date_last_rain)

        if self.build_docs is not None and not isinstance(self.build_docs, BuildDocsEnum):
            self.build_docs = BuildDocsEnum(self.build_docs)

        if self.door_size is not None and not isinstance(self.door_size, QuantityValue):
            self.door_size = QuantityValue(**as_dict(self.door_size))

        if self.door_cond is not None and not isinstance(self.door_cond, DoorCondEnum):
            self.door_cond = DoorCondEnum(self.door_cond)

        if self.door_direct is not None and not isinstance(self.door_direct, DoorDirectEnum):
            self.door_direct = DoorDirectEnum(self.door_direct)

        if self.door_loc is not None and not isinstance(self.door_loc, DoorLocEnum):
            self.door_loc = DoorLocEnum(self.door_loc)

        if self.door_mat is not None and not isinstance(self.door_mat, DoorMatEnum):
            self.door_mat = DoorMatEnum(self.door_mat)

        if self.door_move is not None and not isinstance(self.door_move, DoorMoveEnum):
            self.door_move = DoorMoveEnum(self.door_move)

        if self.door_water_mold is not None and not isinstance(self.door_water_mold, str):
            self.door_water_mold = str(self.door_water_mold)

        if self.door_type is not None and not isinstance(self.door_type, DoorTypeEnum):
            self.door_type = DoorTypeEnum(self.door_type)

        if self.door_comp_type is not None and not isinstance(self.door_comp_type, DoorCompTypeEnum):
            self.door_comp_type = DoorCompTypeEnum(self.door_comp_type)

        if self.door_type_metal is not None and not isinstance(self.door_type_metal, DoorTypeMetalEnum):
            self.door_type_metal = DoorTypeMetalEnum(self.door_type_metal)

        if self.door_type_wood is not None and not isinstance(self.door_type_wood, DoorTypeWoodEnum):
            self.door_type_wood = DoorTypeWoodEnum(self.door_type_wood)

        if self.drawings is not None and not isinstance(self.drawings, DrawingsEnum):
            self.drawings = DrawingsEnum(self.drawings)

        if self.elevator is not None and not isinstance(self.elevator, int):
            self.elevator = int(self.elevator)

        if self.escalator is not None and not isinstance(self.escalator, int):
            self.escalator = int(self.escalator)

        if self.exp_duct is not None and not isinstance(self.exp_duct, QuantityValue):
            self.exp_duct = QuantityValue(**as_dict(self.exp_duct))

        if self.exp_pipe is not None and not isinstance(self.exp_pipe, int):
            self.exp_pipe = int(self.exp_pipe)

        if self.ext_door is not None and not isinstance(self.ext_door, int):
            self.ext_door = int(self.ext_door)

        if self.fireplace_type is not None and not isinstance(self.fireplace_type, str):
            self.fireplace_type = str(self.fireplace_type)

        if self.floor_age is not None and not isinstance(self.floor_age, QuantityValue):
            self.floor_age = QuantityValue(**as_dict(self.floor_age))

        if self.floor_area is not None and not isinstance(self.floor_area, QuantityValue):
            self.floor_area = QuantityValue(**as_dict(self.floor_area))

        if self.floor_cond is not None and not isinstance(self.floor_cond, FloorCondEnum):
            self.floor_cond = FloorCondEnum(self.floor_cond)

        if self.floor_count is not None and not isinstance(self.floor_count, int):
            self.floor_count = int(self.floor_count)

        if self.floor_finish_mat is not None and not isinstance(self.floor_finish_mat, FloorFinishMatEnum):
            self.floor_finish_mat = FloorFinishMatEnum(self.floor_finish_mat)

        if self.floor_water_mold is not None and not isinstance(self.floor_water_mold, FloorWaterMoldEnum):
            self.floor_water_mold = FloorWaterMoldEnum(self.floor_water_mold)

        if self.floor_struc is not None and not isinstance(self.floor_struc, FloorStrucEnum):
            self.floor_struc = FloorStrucEnum(self.floor_struc)

        if self.floor_thermal_mass is not None and not isinstance(self.floor_thermal_mass, QuantityValue):
            self.floor_thermal_mass = QuantityValue(**as_dict(self.floor_thermal_mass))

        if self.freq_clean is not None and not isinstance(self.freq_clean, FreqCleanEnum):
            self.freq_clean = FreqCleanEnum(self.freq_clean)

        if self.freq_cook is not None and not isinstance(self.freq_cook, int):
            self.freq_cook = int(self.freq_cook)

        if self.furniture is not None and not isinstance(self.furniture, FurnitureEnum):
            self.furniture = FurnitureEnum(self.furniture)

        if self.gender_restroom is not None and not isinstance(self.gender_restroom, GenderRestroomEnum):
            self.gender_restroom = GenderRestroomEnum(self.gender_restroom)

        if self.hall_count is not None and not isinstance(self.hall_count, int):
            self.hall_count = int(self.hall_count)

        if self.handidness is not None and not isinstance(self.handidness, HandidnessEnum):
            self.handidness = HandidnessEnum(self.handidness)

        if self.heat_deliv_loc is not None and not isinstance(self.heat_deliv_loc, HeatDelivLocEnum):
            self.heat_deliv_loc = HeatDelivLocEnum(self.heat_deliv_loc)

        if self.heat_sys_deliv_meth is not None and not isinstance(self.heat_sys_deliv_meth, str):
            self.heat_sys_deliv_meth = str(self.heat_sys_deliv_meth)

        if self.heat_system_id is not None and not isinstance(self.heat_system_id, int):
            self.heat_system_id = int(self.heat_system_id)

        if self.height_carper_fiber is not None and not isinstance(self.height_carper_fiber, QuantityValue):
            self.height_carper_fiber = QuantityValue(**as_dict(self.height_carper_fiber))

        if self.inside_lux is not None and not isinstance(self.inside_lux, QuantityValue):
            self.inside_lux = QuantityValue(**as_dict(self.inside_lux))

        if self.int_wall_cond is not None and not isinstance(self.int_wall_cond, IntWallCondEnum):
            self.int_wall_cond = IntWallCondEnum(self.int_wall_cond)

        if self.last_clean is not None and not isinstance(self.last_clean, XSDDate):
            self.last_clean = XSDDate(self.last_clean)

        if self.max_occup is not None and not isinstance(self.max_occup, int):
            self.max_occup = int(self.max_occup)

        if self.mech_struc is not None and not isinstance(self.mech_struc, MechStrucEnum):
            self.mech_struc = MechStrucEnum(self.mech_struc)

        if self.number_plants is not None and not isinstance(self.number_plants, int):
            self.number_plants = int(self.number_plants)

        if self.number_pets is not None and not isinstance(self.number_pets, int):
            self.number_pets = int(self.number_pets)

        if self.number_resident is not None and not isinstance(self.number_resident, int):
            self.number_resident = int(self.number_resident)

        if self.occup_document is not None and not isinstance(self.occup_document, OccupDocumentEnum):
            self.occup_document = OccupDocumentEnum(self.occup_document)

        if self.ext_wall_orient is not None and not isinstance(self.ext_wall_orient, ExtWallOrientEnum):
            self.ext_wall_orient = ExtWallOrientEnum(self.ext_wall_orient)

        if self.ext_window_orient is not None and not isinstance(self.ext_window_orient, ExtWindowOrientEnum):
            self.ext_window_orient = ExtWindowOrientEnum(self.ext_window_orient)

        if self.rel_humidity_out is not None and not isinstance(self.rel_humidity_out, QuantityValue):
            self.rel_humidity_out = QuantityValue(**as_dict(self.rel_humidity_out))

        if self.pres_animal_insect is not None and not isinstance(self.pres_animal_insect, str):
            self.pres_animal_insect = str(self.pres_animal_insect)

        if self.quad_pos is not None and not isinstance(self.quad_pos, QuadPosEnum):
            self.quad_pos = QuadPosEnum(self.quad_pos)

        if self.rel_samp_loc is not None and not isinstance(self.rel_samp_loc, RelSampLocEnum):
            self.rel_samp_loc = RelSampLocEnum(self.rel_samp_loc)

        if self.room_air_exch_rate is not None and not isinstance(self.room_air_exch_rate, QuantityValue):
            self.room_air_exch_rate = QuantityValue(**as_dict(self.room_air_exch_rate))

        if self.room_architec_elem is not None and not isinstance(self.room_architec_elem, str):
            self.room_architec_elem = str(self.room_architec_elem)

        if self.room_condt is not None and not isinstance(self.room_condt, RoomCondtEnum):
            self.room_condt = RoomCondtEnum(self.room_condt)

        if self.room_count is not None and not isinstance(self.room_count, int):
            self.room_count = int(self.room_count)

        if self.room_dim is not None and not isinstance(self.room_dim, str):
            self.room_dim = str(self.room_dim)

        if self.room_door_dist is not None and not isinstance(self.room_door_dist, str):
            self.room_door_dist = str(self.room_door_dist)

        if self.room_loc is not None and not isinstance(self.room_loc, RoomLocEnum):
            self.room_loc = RoomLocEnum(self.room_loc)

        if self.room_moist_dam_hist is not None and not isinstance(self.room_moist_dam_hist, int):
            self.room_moist_dam_hist = int(self.room_moist_dam_hist)

        if self.room_net_area is not None and not isinstance(self.room_net_area, str):
            self.room_net_area = str(self.room_net_area)

        if self.room_occup is not None and not isinstance(self.room_occup, int):
            self.room_occup = int(self.room_occup)

        if self.room_samp_pos is not None and not isinstance(self.room_samp_pos, RoomSampPosEnum):
            self.room_samp_pos = RoomSampPosEnum(self.room_samp_pos)

        if self.room_type is not None and not isinstance(self.room_type, RoomTypeEnum):
            self.room_type = RoomTypeEnum(self.room_type)

        if self.room_vol is not None and not isinstance(self.room_vol, str):
            self.room_vol = str(self.room_vol)

        if self.room_window_count is not None and not isinstance(self.room_window_count, int):
            self.room_window_count = int(self.room_window_count)

        if self.room_connected is not None and not isinstance(self.room_connected, RoomConnectedEnum):
            self.room_connected = RoomConnectedEnum(self.room_connected)

        if self.room_hallway is not None and not isinstance(self.room_hallway, str):
            self.room_hallway = str(self.room_hallway)

        if self.room_door_share is not None and not isinstance(self.room_door_share, str):
            self.room_door_share = str(self.room_door_share)

        if self.room_wall_share is not None and not isinstance(self.room_wall_share, str):
            self.room_wall_share = str(self.room_wall_share)

        if self.samp_weather is not None and not isinstance(self.samp_weather, SampWeatherEnum):
            self.samp_weather = SampWeatherEnum(self.samp_weather)

        if self.samp_floor is not None and not isinstance(self.samp_floor, SampFloorEnum):
            self.samp_floor = SampFloorEnum(self.samp_floor)

        if self.samp_room_id is not None and not isinstance(self.samp_room_id, int):
            self.samp_room_id = int(self.samp_room_id)

        if self.samp_time_out is not None and not isinstance(self.samp_time_out, float):
            self.samp_time_out = float(self.samp_time_out)

        if self.season is not None and not isinstance(self.season, str):
            self.season = str(self.season)

        if self.season_use is not None and not isinstance(self.season_use, SeasonUseEnum):
            self.season_use = SeasonUseEnum(self.season_use)

        if self.shading_device_cond is not None and not isinstance(self.shading_device_cond, ShadingDeviceCondEnum):
            self.shading_device_cond = ShadingDeviceCondEnum(self.shading_device_cond)

        if self.shading_device_loc is not None and not isinstance(self.shading_device_loc, str):
            self.shading_device_loc = str(self.shading_device_loc)

        if self.shading_device_mat is not None and not isinstance(self.shading_device_mat, str):
            self.shading_device_mat = str(self.shading_device_mat)

        if self.shad_dev_water_mold is not None and not isinstance(self.shad_dev_water_mold, str):
            self.shad_dev_water_mold = str(self.shad_dev_water_mold)

        if self.shading_device_type is not None and not isinstance(self.shading_device_type, ShadingDeviceTypeEnum):
            self.shading_device_type = ShadingDeviceTypeEnum(self.shading_device_type)

        if self.specific_humidity is not None and not isinstance(self.specific_humidity, QuantityValue):
            self.specific_humidity = QuantityValue(**as_dict(self.specific_humidity))

        if self.specific is not None and not isinstance(self.specific, SpecificEnum):
            self.specific = SpecificEnum(self.specific)

        if self.temp_out is not None and not isinstance(self.temp_out, QuantityValue):
            self.temp_out = QuantityValue(**as_dict(self.temp_out))

        if self.train_line is not None and not isinstance(self.train_line, TrainLineEnum):
            self.train_line = TrainLineEnum(self.train_line)

        if self.train_stat_loc is not None and not isinstance(self.train_stat_loc, TrainStatLocEnum):
            self.train_stat_loc = TrainStatLocEnum(self.train_stat_loc)

        if self.train_stop_loc is not None and not isinstance(self.train_stop_loc, TrainStopLocEnum):
            self.train_stop_loc = TrainStopLocEnum(self.train_stop_loc)

        if self.vis_media is not None and not isinstance(self.vis_media, VisMediaEnum):
            self.vis_media = VisMediaEnum(self.vis_media)

        if self.wall_area is not None and not isinstance(self.wall_area, QuantityValue):
            self.wall_area = QuantityValue(**as_dict(self.wall_area))

        if self.wall_const_type is not None and not isinstance(self.wall_const_type, WallConstTypeEnum):
            self.wall_const_type = WallConstTypeEnum(self.wall_const_type)

        if self.wall_finish_mat is not None and not isinstance(self.wall_finish_mat, WallFinishMatEnum):
            self.wall_finish_mat = WallFinishMatEnum(self.wall_finish_mat)

        if self.wall_height is not None and not isinstance(self.wall_height, QuantityValue):
            self.wall_height = QuantityValue(**as_dict(self.wall_height))

        if self.wall_loc is not None and not isinstance(self.wall_loc, WallLocEnum):
            self.wall_loc = WallLocEnum(self.wall_loc)

        if self.wall_water_mold is not None and not isinstance(self.wall_water_mold, str):
            self.wall_water_mold = str(self.wall_water_mold)

        if self.wall_surf_treatment is not None and not isinstance(self.wall_surf_treatment, WallSurfTreatmentEnum):
            self.wall_surf_treatment = WallSurfTreatmentEnum(self.wall_surf_treatment)

        if self.wall_texture is not None and not isinstance(self.wall_texture, WallTextureEnum):
            self.wall_texture = WallTextureEnum(self.wall_texture)

        if self.wall_thermal_mass is not None and not isinstance(self.wall_thermal_mass, QuantityValue):
            self.wall_thermal_mass = QuantityValue(**as_dict(self.wall_thermal_mass))

        if self.water_feat_size is not None and not isinstance(self.water_feat_size, QuantityValue):
            self.water_feat_size = QuantityValue(**as_dict(self.water_feat_size))

        if self.water_feat_type is not None and not isinstance(self.water_feat_type, WaterFeatTypeEnum):
            self.water_feat_type = WaterFeatTypeEnum(self.water_feat_type)

        if self.weekday is not None and not isinstance(self.weekday, WeekdayEnum):
            self.weekday = WeekdayEnum(self.weekday)

        if self.window_size is not None and not isinstance(self.window_size, str):
            self.window_size = str(self.window_size)

        if self.window_cond is not None and not isinstance(self.window_cond, WindowCondEnum):
            self.window_cond = WindowCondEnum(self.window_cond)

        if self.window_cover is not None and not isinstance(self.window_cover, WindowCoverEnum):
            self.window_cover = WindowCoverEnum(self.window_cover)

        if self.window_horiz_pos is not None and not isinstance(self.window_horiz_pos, WindowHorizPosEnum):
            self.window_horiz_pos = WindowHorizPosEnum(self.window_horiz_pos)

        if self.window_loc is not None and not isinstance(self.window_loc, WindowLocEnum):
            self.window_loc = WindowLocEnum(self.window_loc)

        if self.window_mat is not None and not isinstance(self.window_mat, WindowMatEnum):
            self.window_mat = WindowMatEnum(self.window_mat)

        if self.window_open_freq is not None and not isinstance(self.window_open_freq, int):
            self.window_open_freq = int(self.window_open_freq)

        if self.window_water_mold is not None and not isinstance(self.window_water_mold, str):
            self.window_water_mold = str(self.window_water_mold)

        if self.window_status is not None and not isinstance(self.window_status, str):
            self.window_status = str(self.window_status)

        if self.window_type is not None and not isinstance(self.window_type, WindowTypeEnum):
            self.window_type = WindowTypeEnum(self.window_type)

        if self.window_vert_pos is not None and not isinstance(self.window_vert_pos, WindowVertPosEnum):
            self.window_vert_pos = WindowVertPosEnum(self.window_vert_pos)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironmentMIGSEukaryote(BuiltEnvironment):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: eukaryote with environmental package built
    environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIGSEukaryote
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironmentMIGSEukaryote"
    class_name: ClassVar[str] = "built environment MIGS eukaryote"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIGSEukaryote

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    temp: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    ploidy: Optional[str] = None
    num_replicons: Optional[int] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    propagation: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.ploidy is not None and not isinstance(self.ploidy, str):
            self.ploidy = str(self.ploidy)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.propagation is not None and not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironmentMIGSBacteria(BuiltEnvironment):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package built environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIGSBacteria
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironmentMIGSBacteria"
    class_name: ClassVar[str] = "built environment MIGS bacteria"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIGSBacteria

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    temp: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    num_replicons: int = None
    ref_biomaterial: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    encoded_traits: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.num_replicons):
            self.MissingRequiredField("num_replicons")
        if not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self._is_empty(self.ref_biomaterial):
            self.MissingRequiredField("ref_biomaterial")
        if not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironmentMIGSPlant(BuiltEnvironment):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: plant with environmental package built
    environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIGSPlant
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironmentMIGSPlant"
    class_name: ClassVar[str] = "built environment MIGS plant"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIGSPlant

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    temp: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironmentMIGSVirus(BuiltEnvironment):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package built environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIGSVirus
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironmentMIGSVirus"
    class_name: ClassVar[str] = "built environment MIGS virus"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIGSVirus

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    temp: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    num_replicons: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    virus_enrich_appr: Optional[Union[str, "VirusEnrichApprEnum"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.virus_enrich_appr is not None and not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironmentMIGSOrg(BuiltEnvironment):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: org with environmental package built
    environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIGSOrg
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironmentMIGSOrg"
    class_name: ClassVar[str] = "built environment MIGS org"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIGSOrg

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    temp: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironmentMIMS(BuiltEnvironment):
    """
    Combinatorial checklist Metagenome or Environmental with environmental package built environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIMS
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironmentMIMS"
    class_name: ClassVar[str] = "built environment MIMS"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIMS

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    temp: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    assembly_software: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironmentMIMARKSSpecimen(BuiltEnvironment):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: specimen with environmental package built
    environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIMARKSSpecimen
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironmentMIMARKSSpecimen"
    class_name: ClassVar[str] = "built environment MIMARKS specimen"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIMARKSSpecimen

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    temp: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    assembly_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironmentMIMARKSSurvey(BuiltEnvironment):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: survey with environmental package built
    environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIMARKSSurvey
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironmentMIMARKSSurvey"
    class_name: ClassVar[str] = "built environment MIMARKS survey"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIMARKSSurvey

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    temp: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    source_mat_id: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironmentMISAG(BuiltEnvironment):
    """
    Combinatorial checklist Minimum Information About a Single Amplified Genome with environmental package built
    environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMISAG
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironmentMISAG"
    class_name: ClassVar[str] = "built environment MISAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMISAG

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    temp: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    sort_tech: Union[str, "SortTechEnum"] = None
    single_cell_lysis_appr: Union[str, "SingleCellLysisApprEnum"] = None
    wga_amp_appr: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.sort_tech):
            self.MissingRequiredField("sort_tech")
        if not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self._is_empty(self.single_cell_lysis_appr):
            self.MissingRequiredField("single_cell_lysis_appr")
        if not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self._is_empty(self.wga_amp_appr):
            self.MissingRequiredField("wga_amp_appr")
        if not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironmentMIMAG(BuiltEnvironment):
    """
    Combinatorial checklist Minimum Information About a Metagenome-Assembled Genome with environmental package built
    environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIMAG
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironmentMIMAG"
    class_name: ClassVar[str] = "built environment MIMAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIMAG

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    temp: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    bin_param: Union[str, "BinParamEnum"] = None
    bin_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.bin_param):
            self.MissingRequiredField("bin_param")
        if not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self._is_empty(self.bin_software):
            self.MissingRequiredField("bin_software")
        if not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class BuiltEnvironmentMIUVIG(BuiltEnvironment):
    """
    Combinatorial checklist Minimum Information About an Uncultivated Virus Genome with environmental package built
    environment
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIUVIG
    class_class_curie: ClassVar[str] = "mixs.vocab:BuiltEnvironmentMIUVIG"
    class_name: ClassVar[str] = "built environment MIUVIG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.BuiltEnvironmentMIUVIG

    rel_air_humidity: Union[dict, "QuantityValue"] = None
    abs_air_humidity: Union[dict, "QuantityValue"] = None
    temp: Union[dict, "QuantityValue"] = None
    build_occup_type: Union[Union[str, "BuildOccupTypeEnum"], List[Union[str, "BuildOccupTypeEnum"]]] = None
    carb_dioxide: Union[dict, "QuantityValue"] = None
    ventilation_type: str = None
    organism_count: Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]] = None
    indoor_space: Union[str, "IndoorSpaceEnum"] = None
    filter_type: Union[Union[str, "FilterTypeEnum"], List[Union[str, "FilterTypeEnum"]]] = None
    heat_cool_type: Union[Union[str, "HeatCoolTypeEnum"], List[Union[str, "HeatCoolTypeEnum"]]] = None
    building_setting: Union[str, "BuildingSettingEnum"] = None
    light_type: Union[Union[str, "LightTypeEnum"], List[Union[str, "LightTypeEnum"]]] = None
    space_typ_state: str = None
    typ_occup_density: float = None
    occup_samp: int = None
    occup_density_samp: float = None
    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    source_uvig: Union[str, "SourceUvigEnum"] = None
    virus_enrich_appr: Union[str, "VirusEnrichApprEnum"] = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    vir_ident_software: str = None
    pred_genome_type: Union[str, "PredGenomeTypeEnum"] = None
    pred_genome_struc: Union[str, "PredGenomeStrucEnum"] = None
    detec_type: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    host_disease_stat: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    sort_tech: Optional[Union[str, "SortTechEnum"]] = None
    single_cell_lysis_appr: Optional[Union[str, "SingleCellLysisApprEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_appr: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    bin_param: Optional[Union[str, "BinParamEnum"]] = None
    bin_software: Optional[str] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    otu_class_appr: Optional[str] = None
    otu_seq_comp_appr: Optional[str] = None
    otu_db: Optional[str] = None
    host_pred_appr: Optional[Union[str, "HostPredApprEnum"]] = None
    host_pred_est_acc: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.source_uvig):
            self.MissingRequiredField("source_uvig")
        if not isinstance(self.source_uvig, SourceUvigEnum):
            self.source_uvig = SourceUvigEnum(self.source_uvig)

        if self._is_empty(self.virus_enrich_appr):
            self.MissingRequiredField("virus_enrich_appr")
        if not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self._is_empty(self.vir_ident_software):
            self.MissingRequiredField("vir_ident_software")
        if not isinstance(self.vir_ident_software, str):
            self.vir_ident_software = str(self.vir_ident_software)

        if self._is_empty(self.pred_genome_type):
            self.MissingRequiredField("pred_genome_type")
        if not isinstance(self.pred_genome_type, PredGenomeTypeEnum):
            self.pred_genome_type = PredGenomeTypeEnum(self.pred_genome_type)

        if self._is_empty(self.pred_genome_struc):
            self.MissingRequiredField("pred_genome_struc")
        if not isinstance(self.pred_genome_struc, PredGenomeStrucEnum):
            self.pred_genome_struc = PredGenomeStrucEnum(self.pred_genome_struc)

        if self._is_empty(self.detec_type):
            self.MissingRequiredField("detec_type")
        if not isinstance(self.detec_type, str):
            self.detec_type = str(self.detec_type)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.sort_tech is not None and not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self.single_cell_lysis_appr is not None and not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_appr is not None and not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.bin_param is not None and not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self.bin_software is not None and not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.otu_class_appr is not None and not isinstance(self.otu_class_appr, str):
            self.otu_class_appr = str(self.otu_class_appr)

        if self.otu_seq_comp_appr is not None and not isinstance(self.otu_seq_comp_appr, str):
            self.otu_seq_comp_appr = str(self.otu_seq_comp_appr)

        if self.otu_db is not None and not isinstance(self.otu_db, str):
            self.otu_db = str(self.otu_db)

        if self.host_pred_appr is not None and not isinstance(self.host_pred_appr, HostPredApprEnum):
            self.host_pred_appr = HostPredApprEnum(self.host_pred_appr)

        if self.host_pred_est_acc is not None and not isinstance(self.host_pred_est_acc, str):
            self.host_pred_est_acc = str(self.host_pred_est_acc)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Host-associated(YAMLRoot):
    """
    host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associated"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associated"
    class_name: ClassVar[str] = "host-associated"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associated

    samp_name: str = None
    project_name: str = None
    lat_lon: Optional[str] = None
    depth: Optional[Union[dict, "QuantityValue"]] = None
    alt: Optional[Union[dict, "QuantityValue"]] = None
    elev: Optional[Union[dict, "QuantityValue"]] = None
    temp: Optional[Union[dict, "QuantityValue"]] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    ances_data: Optional[str] = None
    biol_stat: Optional[Union[str, "BiolStatEnum"]] = None
    genetic_mod: Optional[str] = None
    host_common_name: Optional[str] = None
    samp_capt_status: Optional[Union[str, "SampCaptStatusEnum"]] = None
    samp_dis_stage: Optional[Union[str, "SampDisStageEnum"]] = None
    host_taxid: Optional[str] = None
    host_subject_id: Optional[str] = None
    host_age: Optional[Union[dict, "QuantityValue"]] = None
    host_life_stage: Optional[str] = None
    host_sex: Optional[Union[str, "HostSexEnum"]] = None
    chem_administration: Optional[Union[str, List[str]]] = empty_list()
    host_body_habitat: Optional[str] = None
    host_body_site: Optional[str] = None
    host_body_product: Optional[str] = None
    host_tot_mass: Optional[Union[dict, "QuantityValue"]] = None
    host_height: Optional[Union[dict, "QuantityValue"]] = None
    host_length: Optional[Union[dict, "QuantityValue"]] = None
    host_diet: Optional[Union[str, List[str]]] = empty_list()
    host_last_meal: Optional[Union[str, List[str]]] = empty_list()
    host_growth_cond: Optional[str] = None
    host_substrate: Optional[str] = None
    host_family_relation: Optional[Union[str, List[str]]] = empty_list()
    host_subspecf_genlin: Optional[Union[str, List[str]]] = empty_list()
    host_genotype: Optional[str] = None
    host_phenotype: Optional[str] = None
    host_body_temp: Optional[Union[dict, "QuantityValue"]] = None
    host_dry_mass: Optional[Union[dict, "QuantityValue"]] = None
    blood_press_diast: Optional[Union[dict, "QuantityValue"]] = None
    blood_press_syst: Optional[Union[dict, "QuantityValue"]] = None
    host_color: Optional[str] = None
    host_shape: Optional[str] = None
    gravidity: Optional[str] = None
    perturbation: Optional[Union[str, List[str]]] = empty_list()
    salinity: Optional[Union[dict, "QuantityValue"]] = None
    oxy_stat_samp: Optional[Union[str, "OxyStatSampEnum"]] = None
    organism_count: Optional[Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]]] = empty_list()
    samp_store_temp: Optional[Union[dict, "QuantityValue"]] = None
    samp_store_dur: Optional[str] = None
    samp_store_loc: Optional[str] = None
    host_symbiont: Optional[Union[str, List[str]]] = empty_list()
    misc_param: Optional[Union[str, List[str]]] = empty_list()
    host_disease_stat: Optional[str] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.depth is not None and not isinstance(self.depth, QuantityValue):
            self.depth = QuantityValue(**as_dict(self.depth))

        if self.alt is not None and not isinstance(self.alt, QuantityValue):
            self.alt = QuantityValue(**as_dict(self.alt))

        if self.elev is not None and not isinstance(self.elev, QuantityValue):
            self.elev = QuantityValue(**as_dict(self.elev))

        if self.temp is not None and not isinstance(self.temp, QuantityValue):
            self.temp = QuantityValue(**as_dict(self.temp))

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.ances_data is not None and not isinstance(self.ances_data, str):
            self.ances_data = str(self.ances_data)

        if self.biol_stat is not None and not isinstance(self.biol_stat, BiolStatEnum):
            self.biol_stat = BiolStatEnum(self.biol_stat)

        if self.genetic_mod is not None and not isinstance(self.genetic_mod, str):
            self.genetic_mod = str(self.genetic_mod)

        if self.host_common_name is not None and not isinstance(self.host_common_name, str):
            self.host_common_name = str(self.host_common_name)

        if self.samp_capt_status is not None and not isinstance(self.samp_capt_status, SampCaptStatusEnum):
            self.samp_capt_status = SampCaptStatusEnum(self.samp_capt_status)

        if self.samp_dis_stage is not None and not isinstance(self.samp_dis_stage, SampDisStageEnum):
            self.samp_dis_stage = SampDisStageEnum(self.samp_dis_stage)

        if self.host_taxid is not None and not isinstance(self.host_taxid, str):
            self.host_taxid = str(self.host_taxid)

        if self.host_subject_id is not None and not isinstance(self.host_subject_id, str):
            self.host_subject_id = str(self.host_subject_id)

        if self.host_age is not None and not isinstance(self.host_age, QuantityValue):
            self.host_age = QuantityValue(**as_dict(self.host_age))

        if self.host_life_stage is not None and not isinstance(self.host_life_stage, str):
            self.host_life_stage = str(self.host_life_stage)

        if self.host_sex is not None and not isinstance(self.host_sex, HostSexEnum):
            self.host_sex = HostSexEnum(self.host_sex)

        if not isinstance(self.chem_administration, list):
            self.chem_administration = [self.chem_administration] if self.chem_administration is not None else []
        self.chem_administration = [v if isinstance(v, str) else str(v) for v in self.chem_administration]

        if self.host_body_habitat is not None and not isinstance(self.host_body_habitat, str):
            self.host_body_habitat = str(self.host_body_habitat)

        if self.host_body_site is not None and not isinstance(self.host_body_site, str):
            self.host_body_site = str(self.host_body_site)

        if self.host_body_product is not None and not isinstance(self.host_body_product, str):
            self.host_body_product = str(self.host_body_product)

        if self.host_tot_mass is not None and not isinstance(self.host_tot_mass, QuantityValue):
            self.host_tot_mass = QuantityValue(**as_dict(self.host_tot_mass))

        if self.host_height is not None and not isinstance(self.host_height, QuantityValue):
            self.host_height = QuantityValue(**as_dict(self.host_height))

        if self.host_length is not None and not isinstance(self.host_length, QuantityValue):
            self.host_length = QuantityValue(**as_dict(self.host_length))

        if not isinstance(self.host_diet, list):
            self.host_diet = [self.host_diet] if self.host_diet is not None else []
        self.host_diet = [v if isinstance(v, str) else str(v) for v in self.host_diet]

        if not isinstance(self.host_last_meal, list):
            self.host_last_meal = [self.host_last_meal] if self.host_last_meal is not None else []
        self.host_last_meal = [v if isinstance(v, str) else str(v) for v in self.host_last_meal]

        if self.host_growth_cond is not None and not isinstance(self.host_growth_cond, str):
            self.host_growth_cond = str(self.host_growth_cond)

        if self.host_substrate is not None and not isinstance(self.host_substrate, str):
            self.host_substrate = str(self.host_substrate)

        if not isinstance(self.host_family_relation, list):
            self.host_family_relation = [self.host_family_relation] if self.host_family_relation is not None else []
        self.host_family_relation = [v if isinstance(v, str) else str(v) for v in self.host_family_relation]

        if not isinstance(self.host_subspecf_genlin, list):
            self.host_subspecf_genlin = [self.host_subspecf_genlin] if self.host_subspecf_genlin is not None else []
        self.host_subspecf_genlin = [v if isinstance(v, str) else str(v) for v in self.host_subspecf_genlin]

        if self.host_genotype is not None and not isinstance(self.host_genotype, str):
            self.host_genotype = str(self.host_genotype)

        if self.host_phenotype is not None and not isinstance(self.host_phenotype, str):
            self.host_phenotype = str(self.host_phenotype)

        if self.host_body_temp is not None and not isinstance(self.host_body_temp, QuantityValue):
            self.host_body_temp = QuantityValue(**as_dict(self.host_body_temp))

        if self.host_dry_mass is not None and not isinstance(self.host_dry_mass, QuantityValue):
            self.host_dry_mass = QuantityValue(**as_dict(self.host_dry_mass))

        if self.blood_press_diast is not None and not isinstance(self.blood_press_diast, QuantityValue):
            self.blood_press_diast = QuantityValue(**as_dict(self.blood_press_diast))

        if self.blood_press_syst is not None and not isinstance(self.blood_press_syst, QuantityValue):
            self.blood_press_syst = QuantityValue(**as_dict(self.blood_press_syst))

        if self.host_color is not None and not isinstance(self.host_color, str):
            self.host_color = str(self.host_color)

        if self.host_shape is not None and not isinstance(self.host_shape, str):
            self.host_shape = str(self.host_shape)

        if self.gravidity is not None and not isinstance(self.gravidity, str):
            self.gravidity = str(self.gravidity)

        if not isinstance(self.perturbation, list):
            self.perturbation = [self.perturbation] if self.perturbation is not None else []
        self.perturbation = [v if isinstance(v, str) else str(v) for v in self.perturbation]

        if self.salinity is not None and not isinstance(self.salinity, QuantityValue):
            self.salinity = QuantityValue(**as_dict(self.salinity))

        if self.oxy_stat_samp is not None and not isinstance(self.oxy_stat_samp, OxyStatSampEnum):
            self.oxy_stat_samp = OxyStatSampEnum(self.oxy_stat_samp)

        if not isinstance(self.organism_count, list):
            self.organism_count = [self.organism_count] if self.organism_count is not None else []
        self.organism_count = [v if isinstance(v, OrganismCountEnum) else OrganismCountEnum(v) for v in self.organism_count]

        if self.samp_store_temp is not None and not isinstance(self.samp_store_temp, QuantityValue):
            self.samp_store_temp = QuantityValue(**as_dict(self.samp_store_temp))

        if self.samp_store_dur is not None and not isinstance(self.samp_store_dur, str):
            self.samp_store_dur = str(self.samp_store_dur)

        if self.samp_store_loc is not None and not isinstance(self.samp_store_loc, str):
            self.samp_store_loc = str(self.samp_store_loc)

        if not isinstance(self.host_symbiont, list):
            self.host_symbiont = [self.host_symbiont] if self.host_symbiont is not None else []
        self.host_symbiont = [v if isinstance(v, str) else str(v) for v in self.host_symbiont]

        if not isinstance(self.misc_param, list):
            self.misc_param = [self.misc_param] if self.misc_param is not None else []
        self.misc_param = [v if isinstance(v, str) else str(v) for v in self.misc_param]

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        super().__post_init__(**kwargs)


@dataclass
class Host-associatedMIGSEukaryote(Host-associated):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: eukaryote with environmental package
    host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associatedMIGSEukaryote"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associatedMIGSEukaryote"
    class_name: ClassVar[str] = "host-associated MIGS eukaryote"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associatedMIGSEukaryote

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    ploidy: Optional[str] = None
    num_replicons: Optional[int] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    propagation: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.ploidy is not None and not isinstance(self.ploidy, str):
            self.ploidy = str(self.ploidy)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.propagation is not None and not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Host-associatedMIGSBacteria(Host-associated):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associatedMIGSBacteria"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associatedMIGSBacteria"
    class_name: ClassVar[str] = "host-associated MIGS bacteria"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associatedMIGSBacteria

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    num_replicons: int = None
    ref_biomaterial: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    encoded_traits: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.num_replicons):
            self.MissingRequiredField("num_replicons")
        if not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self._is_empty(self.ref_biomaterial):
            self.MissingRequiredField("ref_biomaterial")
        if not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Host-associatedMIGSPlant(Host-associated):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: plant with environmental package
    host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associatedMIGSPlant"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associatedMIGSPlant"
    class_name: ClassVar[str] = "host-associated MIGS plant"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associatedMIGSPlant

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Host-associatedMIGSVirus(Host-associated):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associatedMIGSVirus"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associatedMIGSVirus"
    class_name: ClassVar[str] = "host-associated MIGS virus"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associatedMIGSVirus

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    num_replicons: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    virus_enrich_appr: Optional[Union[str, "VirusEnrichApprEnum"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.virus_enrich_appr is not None and not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Host-associatedMIGSOrg(Host-associated):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: org with environmental package host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associatedMIGSOrg"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associatedMIGSOrg"
    class_name: ClassVar[str] = "host-associated MIGS org"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associatedMIGSOrg

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Host-associatedMIMS(Host-associated):
    """
    Combinatorial checklist Metagenome or Environmental with environmental package host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associatedMIMS"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associatedMIMS"
    class_name: ClassVar[str] = "host-associated MIMS"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associatedMIMS

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    assembly_software: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Host-associatedMIMARKSSpecimen(Host-associated):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: specimen with environmental package
    host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associatedMIMARKSSpecimen"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associatedMIMARKSSpecimen"
    class_name: ClassVar[str] = "host-associated MIMARKS specimen"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associatedMIMARKSSpecimen

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    assembly_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Host-associatedMIMARKSSurvey(Host-associated):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: survey with environmental package
    host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associatedMIMARKSSurvey"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associatedMIMARKSSurvey"
    class_name: ClassVar[str] = "host-associated MIMARKS survey"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associatedMIMARKSSurvey

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    source_mat_id: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Host-associatedMISAG(Host-associated):
    """
    Combinatorial checklist Minimum Information About a Single Amplified Genome with environmental package
    host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associatedMISAG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associatedMISAG"
    class_name: ClassVar[str] = "host-associated MISAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associatedMISAG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    sort_tech: Union[str, "SortTechEnum"] = None
    single_cell_lysis_appr: Union[str, "SingleCellLysisApprEnum"] = None
    wga_amp_appr: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.sort_tech):
            self.MissingRequiredField("sort_tech")
        if not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self._is_empty(self.single_cell_lysis_appr):
            self.MissingRequiredField("single_cell_lysis_appr")
        if not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self._is_empty(self.wga_amp_appr):
            self.MissingRequiredField("wga_amp_appr")
        if not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Host-associatedMIMAG(Host-associated):
    """
    Combinatorial checklist Minimum Information About a Metagenome-Assembled Genome with environmental package
    host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associatedMIMAG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associatedMIMAG"
    class_name: ClassVar[str] = "host-associated MIMAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associatedMIMAG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    bin_param: Union[str, "BinParamEnum"] = None
    bin_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.bin_param):
            self.MissingRequiredField("bin_param")
        if not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self._is_empty(self.bin_software):
            self.MissingRequiredField("bin_software")
        if not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Host-associatedMIUVIG(Host-associated):
    """
    Combinatorial checklist Minimum Information About an Uncultivated Virus Genome with environmental package
    host-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Host-associatedMIUVIG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Host-associatedMIUVIG"
    class_name: ClassVar[str] = "host-associated MIUVIG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Host-associatedMIUVIG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    source_uvig: Union[str, "SourceUvigEnum"] = None
    virus_enrich_appr: Union[str, "VirusEnrichApprEnum"] = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    vir_ident_software: str = None
    pred_genome_type: Union[str, "PredGenomeTypeEnum"] = None
    pred_genome_struc: Union[str, "PredGenomeStrucEnum"] = None
    detec_type: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    sort_tech: Optional[Union[str, "SortTechEnum"]] = None
    single_cell_lysis_appr: Optional[Union[str, "SingleCellLysisApprEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_appr: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    bin_param: Optional[Union[str, "BinParamEnum"]] = None
    bin_software: Optional[str] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    otu_class_appr: Optional[str] = None
    otu_seq_comp_appr: Optional[str] = None
    otu_db: Optional[str] = None
    host_pred_appr: Optional[Union[str, "HostPredApprEnum"]] = None
    host_pred_est_acc: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.source_uvig):
            self.MissingRequiredField("source_uvig")
        if not isinstance(self.source_uvig, SourceUvigEnum):
            self.source_uvig = SourceUvigEnum(self.source_uvig)

        if self._is_empty(self.virus_enrich_appr):
            self.MissingRequiredField("virus_enrich_appr")
        if not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self._is_empty(self.vir_ident_software):
            self.MissingRequiredField("vir_ident_software")
        if not isinstance(self.vir_ident_software, str):
            self.vir_ident_software = str(self.vir_ident_software)

        if self._is_empty(self.pred_genome_type):
            self.MissingRequiredField("pred_genome_type")
        if not isinstance(self.pred_genome_type, PredGenomeTypeEnum):
            self.pred_genome_type = PredGenomeTypeEnum(self.pred_genome_type)

        if self._is_empty(self.pred_genome_struc):
            self.MissingRequiredField("pred_genome_struc")
        if not isinstance(self.pred_genome_struc, PredGenomeStrucEnum):
            self.pred_genome_struc = PredGenomeStrucEnum(self.pred_genome_struc)

        if self._is_empty(self.detec_type):
            self.MissingRequiredField("detec_type")
        if not isinstance(self.detec_type, str):
            self.detec_type = str(self.detec_type)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.sort_tech is not None and not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self.single_cell_lysis_appr is not None and not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_appr is not None and not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.bin_param is not None and not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self.bin_software is not None and not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.otu_class_appr is not None and not isinstance(self.otu_class_appr, str):
            self.otu_class_appr = str(self.otu_class_appr)

        if self.otu_seq_comp_appr is not None and not isinstance(self.otu_seq_comp_appr, str):
            self.otu_seq_comp_appr = str(self.otu_seq_comp_appr)

        if self.otu_db is not None and not isinstance(self.otu_db, str):
            self.otu_db = str(self.otu_db)

        if self.host_pred_appr is not None and not isinstance(self.host_pred_appr, HostPredApprEnum):
            self.host_pred_appr = HostPredApprEnum(self.host_pred_appr)

        if self.host_pred_est_acc is not None and not isinstance(self.host_pred_est_acc, str):
            self.host_pred_est_acc = str(self.host_pred_est_acc)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-associated(YAMLRoot):
    """
    human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associated"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associated"
    class_name: ClassVar[str] = "human-associated"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associated

    samp_name: str = None
    project_name: str = None
    lat_lon: Optional[str] = None
    depth: Optional[Union[dict, "QuantityValue"]] = None
    alt: Optional[Union[dict, "QuantityValue"]] = None
    elev: Optional[Union[dict, "QuantityValue"]] = None
    temp: Optional[Union[dict, "QuantityValue"]] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    host_subject_id: Optional[str] = None
    host_age: Optional[Union[dict, "QuantityValue"]] = None
    host_sex: Optional[Union[str, "HostSexEnum"]] = None
    ihmc_medication_code: Optional[Union[int, List[int]]] = empty_list()
    chem_administration: Optional[Union[str, List[str]]] = empty_list()
    host_body_site: Optional[str] = None
    host_body_product: Optional[str] = None
    host_tot_mass: Optional[Union[dict, "QuantityValue"]] = None
    host_height: Optional[Union[dict, "QuantityValue"]] = None
    host_diet: Optional[Union[str, List[str]]] = empty_list()
    host_last_meal: Optional[Union[str, List[str]]] = empty_list()
    host_family_relation: Optional[Union[str, List[str]]] = empty_list()
    host_genotype: Optional[str] = None
    host_phenotype: Optional[str] = None
    host_body_temp: Optional[Union[dict, "QuantityValue"]] = None
    smoker: Optional[str] = None
    host_hiv_stat: Optional[str] = None
    drug_usage: Optional[Union[Union[str, "DrugUsageEnum"], List[Union[str, "DrugUsageEnum"]]]] = empty_list()
    host_body_mass_index: Optional[Union[dict, "QuantityValue"]] = None
    diet_last_six_month: Optional[str] = None
    weight_loss_3_month: Optional[str] = None
    ethnicity: Optional[Union[str, List[str]]] = empty_list()
    host_occupation: Optional[int] = None
    pet_farm_animal: Optional[Union[str, List[str]]] = empty_list()
    travel_out_six_month: Optional[Union[str, List[str]]] = empty_list()
    twin_sibling: Optional[str] = None
    medic_hist_perform: Optional[str] = None
    study_complt_stat: Optional[Union[str, "StudyCompltStatEnum"]] = None
    pulmonary_disord: Optional[Union[str, List[str]]] = empty_list()
    nose_throat_disord: Optional[Union[str, List[str]]] = empty_list()
    blood_blood_disord: Optional[Union[str, List[str]]] = empty_list()
    host_pulse: Optional[Union[dict, "QuantityValue"]] = None
    gestation_state: Optional[str] = None
    maternal_health_stat: Optional[str] = None
    foetal_health_stat: Optional[str] = None
    amniotic_fluid_color: Optional[str] = None
    kidney_disord: Optional[Union[str, List[str]]] = empty_list()
    urogenit_tract_disor: Optional[Union[str, List[str]]] = empty_list()
    urine_collect_meth: Optional[str] = None
    perturbation: Optional[Union[str, List[str]]] = empty_list()
    salinity: Optional[Union[dict, "QuantityValue"]] = None
    oxy_stat_samp: Optional[Union[str, "OxyStatSampEnum"]] = None
    organism_count: Optional[Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]]] = empty_list()
    samp_store_temp: Optional[Union[dict, "QuantityValue"]] = None
    samp_store_dur: Optional[str] = None
    host_symbiont: Optional[Union[str, List[str]]] = empty_list()
    samp_store_loc: Optional[str] = None
    misc_param: Optional[Union[str, List[str]]] = empty_list()
    host_disease_stat: Optional[str] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.depth is not None and not isinstance(self.depth, QuantityValue):
            self.depth = QuantityValue(**as_dict(self.depth))

        if self.alt is not None and not isinstance(self.alt, QuantityValue):
            self.alt = QuantityValue(**as_dict(self.alt))

        if self.elev is not None and not isinstance(self.elev, QuantityValue):
            self.elev = QuantityValue(**as_dict(self.elev))

        if self.temp is not None and not isinstance(self.temp, QuantityValue):
            self.temp = QuantityValue(**as_dict(self.temp))

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.host_subject_id is not None and not isinstance(self.host_subject_id, str):
            self.host_subject_id = str(self.host_subject_id)

        if self.host_age is not None and not isinstance(self.host_age, QuantityValue):
            self.host_age = QuantityValue(**as_dict(self.host_age))

        if self.host_sex is not None and not isinstance(self.host_sex, HostSexEnum):
            self.host_sex = HostSexEnum(self.host_sex)

        if not isinstance(self.ihmc_medication_code, list):
            self.ihmc_medication_code = [self.ihmc_medication_code] if self.ihmc_medication_code is not None else []
        self.ihmc_medication_code = [v if isinstance(v, int) else int(v) for v in self.ihmc_medication_code]

        if not isinstance(self.chem_administration, list):
            self.chem_administration = [self.chem_administration] if self.chem_administration is not None else []
        self.chem_administration = [v if isinstance(v, str) else str(v) for v in self.chem_administration]

        if self.host_body_site is not None and not isinstance(self.host_body_site, str):
            self.host_body_site = str(self.host_body_site)

        if self.host_body_product is not None and not isinstance(self.host_body_product, str):
            self.host_body_product = str(self.host_body_product)

        if self.host_tot_mass is not None and not isinstance(self.host_tot_mass, QuantityValue):
            self.host_tot_mass = QuantityValue(**as_dict(self.host_tot_mass))

        if self.host_height is not None and not isinstance(self.host_height, QuantityValue):
            self.host_height = QuantityValue(**as_dict(self.host_height))

        if not isinstance(self.host_diet, list):
            self.host_diet = [self.host_diet] if self.host_diet is not None else []
        self.host_diet = [v if isinstance(v, str) else str(v) for v in self.host_diet]

        if not isinstance(self.host_last_meal, list):
            self.host_last_meal = [self.host_last_meal] if self.host_last_meal is not None else []
        self.host_last_meal = [v if isinstance(v, str) else str(v) for v in self.host_last_meal]

        if not isinstance(self.host_family_relation, list):
            self.host_family_relation = [self.host_family_relation] if self.host_family_relation is not None else []
        self.host_family_relation = [v if isinstance(v, str) else str(v) for v in self.host_family_relation]

        if self.host_genotype is not None and not isinstance(self.host_genotype, str):
            self.host_genotype = str(self.host_genotype)

        if self.host_phenotype is not None and not isinstance(self.host_phenotype, str):
            self.host_phenotype = str(self.host_phenotype)

        if self.host_body_temp is not None and not isinstance(self.host_body_temp, QuantityValue):
            self.host_body_temp = QuantityValue(**as_dict(self.host_body_temp))

        if self.smoker is not None and not isinstance(self.smoker, str):
            self.smoker = str(self.smoker)

        if self.host_hiv_stat is not None and not isinstance(self.host_hiv_stat, str):
            self.host_hiv_stat = str(self.host_hiv_stat)

        if not isinstance(self.drug_usage, list):
            self.drug_usage = [self.drug_usage] if self.drug_usage is not None else []
        self.drug_usage = [v if isinstance(v, DrugUsageEnum) else DrugUsageEnum(v) for v in self.drug_usage]

        if self.host_body_mass_index is not None and not isinstance(self.host_body_mass_index, QuantityValue):
            self.host_body_mass_index = QuantityValue(**as_dict(self.host_body_mass_index))

        if self.diet_last_six_month is not None and not isinstance(self.diet_last_six_month, str):
            self.diet_last_six_month = str(self.diet_last_six_month)

        if self.weight_loss_3_month is not None and not isinstance(self.weight_loss_3_month, str):
            self.weight_loss_3_month = str(self.weight_loss_3_month)

        if not isinstance(self.ethnicity, list):
            self.ethnicity = [self.ethnicity] if self.ethnicity is not None else []
        self.ethnicity = [v if isinstance(v, str) else str(v) for v in self.ethnicity]

        if self.host_occupation is not None and not isinstance(self.host_occupation, int):
            self.host_occupation = int(self.host_occupation)

        if not isinstance(self.pet_farm_animal, list):
            self.pet_farm_animal = [self.pet_farm_animal] if self.pet_farm_animal is not None else []
        self.pet_farm_animal = [v if isinstance(v, str) else str(v) for v in self.pet_farm_animal]

        if not isinstance(self.travel_out_six_month, list):
            self.travel_out_six_month = [self.travel_out_six_month] if self.travel_out_six_month is not None else []
        self.travel_out_six_month = [v if isinstance(v, str) else str(v) for v in self.travel_out_six_month]

        if self.twin_sibling is not None and not isinstance(self.twin_sibling, str):
            self.twin_sibling = str(self.twin_sibling)

        if self.medic_hist_perform is not None and not isinstance(self.medic_hist_perform, str):
            self.medic_hist_perform = str(self.medic_hist_perform)

        if self.study_complt_stat is not None and not isinstance(self.study_complt_stat, StudyCompltStatEnum):
            self.study_complt_stat = StudyCompltStatEnum(self.study_complt_stat)

        if not isinstance(self.pulmonary_disord, list):
            self.pulmonary_disord = [self.pulmonary_disord] if self.pulmonary_disord is not None else []
        self.pulmonary_disord = [v if isinstance(v, str) else str(v) for v in self.pulmonary_disord]

        if not isinstance(self.nose_throat_disord, list):
            self.nose_throat_disord = [self.nose_throat_disord] if self.nose_throat_disord is not None else []
        self.nose_throat_disord = [v if isinstance(v, str) else str(v) for v in self.nose_throat_disord]

        if not isinstance(self.blood_blood_disord, list):
            self.blood_blood_disord = [self.blood_blood_disord] if self.blood_blood_disord is not None else []
        self.blood_blood_disord = [v if isinstance(v, str) else str(v) for v in self.blood_blood_disord]

        if self.host_pulse is not None and not isinstance(self.host_pulse, QuantityValue):
            self.host_pulse = QuantityValue(**as_dict(self.host_pulse))

        if self.gestation_state is not None and not isinstance(self.gestation_state, str):
            self.gestation_state = str(self.gestation_state)

        if self.maternal_health_stat is not None and not isinstance(self.maternal_health_stat, str):
            self.maternal_health_stat = str(self.maternal_health_stat)

        if self.foetal_health_stat is not None and not isinstance(self.foetal_health_stat, str):
            self.foetal_health_stat = str(self.foetal_health_stat)

        if self.amniotic_fluid_color is not None and not isinstance(self.amniotic_fluid_color, str):
            self.amniotic_fluid_color = str(self.amniotic_fluid_color)

        if not isinstance(self.kidney_disord, list):
            self.kidney_disord = [self.kidney_disord] if self.kidney_disord is not None else []
        self.kidney_disord = [v if isinstance(v, str) else str(v) for v in self.kidney_disord]

        if not isinstance(self.urogenit_tract_disor, list):
            self.urogenit_tract_disor = [self.urogenit_tract_disor] if self.urogenit_tract_disor is not None else []
        self.urogenit_tract_disor = [v if isinstance(v, str) else str(v) for v in self.urogenit_tract_disor]

        if self.urine_collect_meth is not None and not isinstance(self.urine_collect_meth, str):
            self.urine_collect_meth = str(self.urine_collect_meth)

        if not isinstance(self.perturbation, list):
            self.perturbation = [self.perturbation] if self.perturbation is not None else []
        self.perturbation = [v if isinstance(v, str) else str(v) for v in self.perturbation]

        if self.salinity is not None and not isinstance(self.salinity, QuantityValue):
            self.salinity = QuantityValue(**as_dict(self.salinity))

        if self.oxy_stat_samp is not None and not isinstance(self.oxy_stat_samp, OxyStatSampEnum):
            self.oxy_stat_samp = OxyStatSampEnum(self.oxy_stat_samp)

        if not isinstance(self.organism_count, list):
            self.organism_count = [self.organism_count] if self.organism_count is not None else []
        self.organism_count = [v if isinstance(v, OrganismCountEnum) else OrganismCountEnum(v) for v in self.organism_count]

        if self.samp_store_temp is not None and not isinstance(self.samp_store_temp, QuantityValue):
            self.samp_store_temp = QuantityValue(**as_dict(self.samp_store_temp))

        if self.samp_store_dur is not None and not isinstance(self.samp_store_dur, str):
            self.samp_store_dur = str(self.samp_store_dur)

        if not isinstance(self.host_symbiont, list):
            self.host_symbiont = [self.host_symbiont] if self.host_symbiont is not None else []
        self.host_symbiont = [v if isinstance(v, str) else str(v) for v in self.host_symbiont]

        if self.samp_store_loc is not None and not isinstance(self.samp_store_loc, str):
            self.samp_store_loc = str(self.samp_store_loc)

        if not isinstance(self.misc_param, list):
            self.misc_param = [self.misc_param] if self.misc_param is not None else []
        self.misc_param = [v if isinstance(v, str) else str(v) for v in self.misc_param]

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        super().__post_init__(**kwargs)


@dataclass
class Human-associatedMIGSEukaryote(Human-associated):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: eukaryote with environmental package
    human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associatedMIGSEukaryote"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associatedMIGSEukaryote"
    class_name: ClassVar[str] = "human-associated MIGS eukaryote"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associatedMIGSEukaryote

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    ploidy: Optional[str] = None
    num_replicons: Optional[int] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    propagation: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.ploidy is not None and not isinstance(self.ploidy, str):
            self.ploidy = str(self.ploidy)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.propagation is not None and not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-associatedMIGSBacteria(Human-associated):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associatedMIGSBacteria"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associatedMIGSBacteria"
    class_name: ClassVar[str] = "human-associated MIGS bacteria"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associatedMIGSBacteria

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    num_replicons: int = None
    ref_biomaterial: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    encoded_traits: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.num_replicons):
            self.MissingRequiredField("num_replicons")
        if not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self._is_empty(self.ref_biomaterial):
            self.MissingRequiredField("ref_biomaterial")
        if not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-associatedMIGSPlant(Human-associated):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: plant with environmental package
    human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associatedMIGSPlant"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associatedMIGSPlant"
    class_name: ClassVar[str] = "human-associated MIGS plant"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associatedMIGSPlant

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-associatedMIGSVirus(Human-associated):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associatedMIGSVirus"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associatedMIGSVirus"
    class_name: ClassVar[str] = "human-associated MIGS virus"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associatedMIGSVirus

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    num_replicons: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    virus_enrich_appr: Optional[Union[str, "VirusEnrichApprEnum"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.virus_enrich_appr is not None and not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-associatedMIGSOrg(Human-associated):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: org with environmental package
    human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associatedMIGSOrg"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associatedMIGSOrg"
    class_name: ClassVar[str] = "human-associated MIGS org"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associatedMIGSOrg

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-associatedMIMS(Human-associated):
    """
    Combinatorial checklist Metagenome or Environmental with environmental package human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associatedMIMS"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associatedMIMS"
    class_name: ClassVar[str] = "human-associated MIMS"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associatedMIMS

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    assembly_software: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-associatedMIMARKSSpecimen(Human-associated):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: specimen with environmental package
    human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associatedMIMARKSSpecimen"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associatedMIMARKSSpecimen"
    class_name: ClassVar[str] = "human-associated MIMARKS specimen"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associatedMIMARKSSpecimen

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    assembly_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-associatedMIMARKSSurvey(Human-associated):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: survey with environmental package
    human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associatedMIMARKSSurvey"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associatedMIMARKSSurvey"
    class_name: ClassVar[str] = "human-associated MIMARKS survey"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associatedMIMARKSSurvey

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    source_mat_id: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-associatedMISAG(Human-associated):
    """
    Combinatorial checklist Minimum Information About a Single Amplified Genome with environmental package
    human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associatedMISAG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associatedMISAG"
    class_name: ClassVar[str] = "human-associated MISAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associatedMISAG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    sort_tech: Union[str, "SortTechEnum"] = None
    single_cell_lysis_appr: Union[str, "SingleCellLysisApprEnum"] = None
    wga_amp_appr: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.sort_tech):
            self.MissingRequiredField("sort_tech")
        if not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self._is_empty(self.single_cell_lysis_appr):
            self.MissingRequiredField("single_cell_lysis_appr")
        if not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self._is_empty(self.wga_amp_appr):
            self.MissingRequiredField("wga_amp_appr")
        if not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-associatedMIMAG(Human-associated):
    """
    Combinatorial checklist Minimum Information About a Metagenome-Assembled Genome with environmental package
    human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associatedMIMAG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associatedMIMAG"
    class_name: ClassVar[str] = "human-associated MIMAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associatedMIMAG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    bin_param: Union[str, "BinParamEnum"] = None
    bin_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.bin_param):
            self.MissingRequiredField("bin_param")
        if not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self._is_empty(self.bin_software):
            self.MissingRequiredField("bin_software")
        if not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-associatedMIUVIG(Human-associated):
    """
    Combinatorial checklist Minimum Information About an Uncultivated Virus Genome with environmental package
    human-associated
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-associatedMIUVIG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-associatedMIUVIG"
    class_name: ClassVar[str] = "human-associated MIUVIG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-associatedMIUVIG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    source_uvig: Union[str, "SourceUvigEnum"] = None
    virus_enrich_appr: Union[str, "VirusEnrichApprEnum"] = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    vir_ident_software: str = None
    pred_genome_type: Union[str, "PredGenomeTypeEnum"] = None
    pred_genome_struc: Union[str, "PredGenomeStrucEnum"] = None
    detec_type: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    sort_tech: Optional[Union[str, "SortTechEnum"]] = None
    single_cell_lysis_appr: Optional[Union[str, "SingleCellLysisApprEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_appr: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    bin_param: Optional[Union[str, "BinParamEnum"]] = None
    bin_software: Optional[str] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    otu_class_appr: Optional[str] = None
    otu_seq_comp_appr: Optional[str] = None
    otu_db: Optional[str] = None
    host_pred_appr: Optional[Union[str, "HostPredApprEnum"]] = None
    host_pred_est_acc: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.source_uvig):
            self.MissingRequiredField("source_uvig")
        if not isinstance(self.source_uvig, SourceUvigEnum):
            self.source_uvig = SourceUvigEnum(self.source_uvig)

        if self._is_empty(self.virus_enrich_appr):
            self.MissingRequiredField("virus_enrich_appr")
        if not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self._is_empty(self.vir_ident_software):
            self.MissingRequiredField("vir_ident_software")
        if not isinstance(self.vir_ident_software, str):
            self.vir_ident_software = str(self.vir_ident_software)

        if self._is_empty(self.pred_genome_type):
            self.MissingRequiredField("pred_genome_type")
        if not isinstance(self.pred_genome_type, PredGenomeTypeEnum):
            self.pred_genome_type = PredGenomeTypeEnum(self.pred_genome_type)

        if self._is_empty(self.pred_genome_struc):
            self.MissingRequiredField("pred_genome_struc")
        if not isinstance(self.pred_genome_struc, PredGenomeStrucEnum):
            self.pred_genome_struc = PredGenomeStrucEnum(self.pred_genome_struc)

        if self._is_empty(self.detec_type):
            self.MissingRequiredField("detec_type")
        if not isinstance(self.detec_type, str):
            self.detec_type = str(self.detec_type)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.sort_tech is not None and not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self.single_cell_lysis_appr is not None and not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_appr is not None and not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.bin_param is not None and not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self.bin_software is not None and not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.otu_class_appr is not None and not isinstance(self.otu_class_appr, str):
            self.otu_class_appr = str(self.otu_class_appr)

        if self.otu_seq_comp_appr is not None and not isinstance(self.otu_seq_comp_appr, str):
            self.otu_seq_comp_appr = str(self.otu_seq_comp_appr)

        if self.otu_db is not None and not isinstance(self.otu_db, str):
            self.otu_db = str(self.otu_db)

        if self.host_pred_appr is not None and not isinstance(self.host_pred_appr, HostPredApprEnum):
            self.host_pred_appr = HostPredApprEnum(self.host_pred_appr)

        if self.host_pred_est_acc is not None and not isinstance(self.host_pred_est_acc, str):
            self.host_pred_est_acc = str(self.host_pred_est_acc)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-gut(YAMLRoot):
    """
    human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gut"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gut"
    class_name: ClassVar[str] = "human-gut"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gut

    samp_name: str = None
    project_name: str = None
    lat_lon: Optional[str] = None
    depth: Optional[Union[dict, "QuantityValue"]] = None
    alt: Optional[Union[dict, "QuantityValue"]] = None
    elev: Optional[Union[dict, "QuantityValue"]] = None
    temp: Optional[Union[dict, "QuantityValue"]] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    gastrointest_disord: Optional[Union[str, List[str]]] = empty_list()
    liver_disord: Optional[Union[str, List[str]]] = empty_list()
    special_diet: Optional[Union[Union[str, "SpecialDietEnum"], List[Union[str, "SpecialDietEnum"]]]] = empty_list()
    host_subject_id: Optional[str] = None
    host_age: Optional[Union[dict, "QuantityValue"]] = None
    host_sex: Optional[Union[str, "HostSexEnum"]] = None
    ihmc_medication_code: Optional[Union[int, List[int]]] = empty_list()
    chem_administration: Optional[Union[str, List[str]]] = empty_list()
    host_body_site: Optional[str] = None
    host_body_product: Optional[str] = None
    host_tot_mass: Optional[Union[dict, "QuantityValue"]] = None
    host_height: Optional[Union[dict, "QuantityValue"]] = None
    host_diet: Optional[Union[str, List[str]]] = empty_list()
    host_last_meal: Optional[Union[str, List[str]]] = empty_list()
    host_family_relation: Optional[Union[str, List[str]]] = empty_list()
    host_genotype: Optional[str] = None
    host_phenotype: Optional[str] = None
    host_body_temp: Optional[Union[dict, "QuantityValue"]] = None
    host_body_mass_index: Optional[Union[dict, "QuantityValue"]] = None
    ethnicity: Optional[Union[str, List[str]]] = empty_list()
    host_occupation: Optional[int] = None
    medic_hist_perform: Optional[str] = None
    host_pulse: Optional[Union[dict, "QuantityValue"]] = None
    perturbation: Optional[Union[str, List[str]]] = empty_list()
    salinity: Optional[Union[dict, "QuantityValue"]] = None
    oxy_stat_samp: Optional[Union[str, "OxyStatSampEnum"]] = None
    organism_count: Optional[Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]]] = empty_list()
    samp_store_temp: Optional[Union[dict, "QuantityValue"]] = None
    samp_store_dur: Optional[str] = None
    host_symbiont: Optional[Union[str, List[str]]] = empty_list()
    samp_store_loc: Optional[str] = None
    misc_param: Optional[Union[str, List[str]]] = empty_list()
    host_disease_stat: Optional[str] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.depth is not None and not isinstance(self.depth, QuantityValue):
            self.depth = QuantityValue(**as_dict(self.depth))

        if self.alt is not None and not isinstance(self.alt, QuantityValue):
            self.alt = QuantityValue(**as_dict(self.alt))

        if self.elev is not None and not isinstance(self.elev, QuantityValue):
            self.elev = QuantityValue(**as_dict(self.elev))

        if self.temp is not None and not isinstance(self.temp, QuantityValue):
            self.temp = QuantityValue(**as_dict(self.temp))

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if not isinstance(self.gastrointest_disord, list):
            self.gastrointest_disord = [self.gastrointest_disord] if self.gastrointest_disord is not None else []
        self.gastrointest_disord = [v if isinstance(v, str) else str(v) for v in self.gastrointest_disord]

        if not isinstance(self.liver_disord, list):
            self.liver_disord = [self.liver_disord] if self.liver_disord is not None else []
        self.liver_disord = [v if isinstance(v, str) else str(v) for v in self.liver_disord]

        if not isinstance(self.special_diet, list):
            self.special_diet = [self.special_diet] if self.special_diet is not None else []
        self.special_diet = [v if isinstance(v, SpecialDietEnum) else SpecialDietEnum(v) for v in self.special_diet]

        if self.host_subject_id is not None and not isinstance(self.host_subject_id, str):
            self.host_subject_id = str(self.host_subject_id)

        if self.host_age is not None and not isinstance(self.host_age, QuantityValue):
            self.host_age = QuantityValue(**as_dict(self.host_age))

        if self.host_sex is not None and not isinstance(self.host_sex, HostSexEnum):
            self.host_sex = HostSexEnum(self.host_sex)

        if not isinstance(self.ihmc_medication_code, list):
            self.ihmc_medication_code = [self.ihmc_medication_code] if self.ihmc_medication_code is not None else []
        self.ihmc_medication_code = [v if isinstance(v, int) else int(v) for v in self.ihmc_medication_code]

        if not isinstance(self.chem_administration, list):
            self.chem_administration = [self.chem_administration] if self.chem_administration is not None else []
        self.chem_administration = [v if isinstance(v, str) else str(v) for v in self.chem_administration]

        if self.host_body_site is not None and not isinstance(self.host_body_site, str):
            self.host_body_site = str(self.host_body_site)

        if self.host_body_product is not None and not isinstance(self.host_body_product, str):
            self.host_body_product = str(self.host_body_product)

        if self.host_tot_mass is not None and not isinstance(self.host_tot_mass, QuantityValue):
            self.host_tot_mass = QuantityValue(**as_dict(self.host_tot_mass))

        if self.host_height is not None and not isinstance(self.host_height, QuantityValue):
            self.host_height = QuantityValue(**as_dict(self.host_height))

        if not isinstance(self.host_diet, list):
            self.host_diet = [self.host_diet] if self.host_diet is not None else []
        self.host_diet = [v if isinstance(v, str) else str(v) for v in self.host_diet]

        if not isinstance(self.host_last_meal, list):
            self.host_last_meal = [self.host_last_meal] if self.host_last_meal is not None else []
        self.host_last_meal = [v if isinstance(v, str) else str(v) for v in self.host_last_meal]

        if not isinstance(self.host_family_relation, list):
            self.host_family_relation = [self.host_family_relation] if self.host_family_relation is not None else []
        self.host_family_relation = [v if isinstance(v, str) else str(v) for v in self.host_family_relation]

        if self.host_genotype is not None and not isinstance(self.host_genotype, str):
            self.host_genotype = str(self.host_genotype)

        if self.host_phenotype is not None and not isinstance(self.host_phenotype, str):
            self.host_phenotype = str(self.host_phenotype)

        if self.host_body_temp is not None and not isinstance(self.host_body_temp, QuantityValue):
            self.host_body_temp = QuantityValue(**as_dict(self.host_body_temp))

        if self.host_body_mass_index is not None and not isinstance(self.host_body_mass_index, QuantityValue):
            self.host_body_mass_index = QuantityValue(**as_dict(self.host_body_mass_index))

        if not isinstance(self.ethnicity, list):
            self.ethnicity = [self.ethnicity] if self.ethnicity is not None else []
        self.ethnicity = [v if isinstance(v, str) else str(v) for v in self.ethnicity]

        if self.host_occupation is not None and not isinstance(self.host_occupation, int):
            self.host_occupation = int(self.host_occupation)

        if self.medic_hist_perform is not None and not isinstance(self.medic_hist_perform, str):
            self.medic_hist_perform = str(self.medic_hist_perform)

        if self.host_pulse is not None and not isinstance(self.host_pulse, QuantityValue):
            self.host_pulse = QuantityValue(**as_dict(self.host_pulse))

        if not isinstance(self.perturbation, list):
            self.perturbation = [self.perturbation] if self.perturbation is not None else []
        self.perturbation = [v if isinstance(v, str) else str(v) for v in self.perturbation]

        if self.salinity is not None and not isinstance(self.salinity, QuantityValue):
            self.salinity = QuantityValue(**as_dict(self.salinity))

        if self.oxy_stat_samp is not None and not isinstance(self.oxy_stat_samp, OxyStatSampEnum):
            self.oxy_stat_samp = OxyStatSampEnum(self.oxy_stat_samp)

        if not isinstance(self.organism_count, list):
            self.organism_count = [self.organism_count] if self.organism_count is not None else []
        self.organism_count = [v if isinstance(v, OrganismCountEnum) else OrganismCountEnum(v) for v in self.organism_count]

        if self.samp_store_temp is not None and not isinstance(self.samp_store_temp, QuantityValue):
            self.samp_store_temp = QuantityValue(**as_dict(self.samp_store_temp))

        if self.samp_store_dur is not None and not isinstance(self.samp_store_dur, str):
            self.samp_store_dur = str(self.samp_store_dur)

        if not isinstance(self.host_symbiont, list):
            self.host_symbiont = [self.host_symbiont] if self.host_symbiont is not None else []
        self.host_symbiont = [v if isinstance(v, str) else str(v) for v in self.host_symbiont]

        if self.samp_store_loc is not None and not isinstance(self.samp_store_loc, str):
            self.samp_store_loc = str(self.samp_store_loc)

        if not isinstance(self.misc_param, list):
            self.misc_param = [self.misc_param] if self.misc_param is not None else []
        self.misc_param = [v if isinstance(v, str) else str(v) for v in self.misc_param]

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        super().__post_init__(**kwargs)


@dataclass
class Human-gutMIGSEukaryote(Human-gut):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: eukaryote with environmental package human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gutMIGSEukaryote"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gutMIGSEukaryote"
    class_name: ClassVar[str] = "human-gut MIGS eukaryote"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gutMIGSEukaryote

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    ploidy: Optional[str] = None
    num_replicons: Optional[int] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    propagation: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.ploidy is not None and not isinstance(self.ploidy, str):
            self.ploidy = str(self.ploidy)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.propagation is not None and not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-gutMIGSBacteria(Human-gut):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gutMIGSBacteria"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gutMIGSBacteria"
    class_name: ClassVar[str] = "human-gut MIGS bacteria"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gutMIGSBacteria

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    num_replicons: int = None
    ref_biomaterial: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    encoded_traits: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.num_replicons):
            self.MissingRequiredField("num_replicons")
        if not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self._is_empty(self.ref_biomaterial):
            self.MissingRequiredField("ref_biomaterial")
        if not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-gutMIGSPlant(Human-gut):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: plant with environmental package human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gutMIGSPlant"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gutMIGSPlant"
    class_name: ClassVar[str] = "human-gut MIGS plant"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gutMIGSPlant

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-gutMIGSVirus(Human-gut):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gutMIGSVirus"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gutMIGSVirus"
    class_name: ClassVar[str] = "human-gut MIGS virus"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gutMIGSVirus

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    num_replicons: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    virus_enrich_appr: Optional[Union[str, "VirusEnrichApprEnum"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.virus_enrich_appr is not None and not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-gutMIGSOrg(Human-gut):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: org with environmental package human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gutMIGSOrg"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gutMIGSOrg"
    class_name: ClassVar[str] = "human-gut MIGS org"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gutMIGSOrg

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-gutMIMS(Human-gut):
    """
    Combinatorial checklist Metagenome or Environmental with environmental package human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gutMIMS"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gutMIMS"
    class_name: ClassVar[str] = "human-gut MIMS"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gutMIMS

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    assembly_software: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-gutMIMARKSSpecimen(Human-gut):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: specimen with environmental package human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gutMIMARKSSpecimen"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gutMIMARKSSpecimen"
    class_name: ClassVar[str] = "human-gut MIMARKS specimen"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gutMIMARKSSpecimen

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    assembly_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-gutMIMARKSSurvey(Human-gut):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: survey with environmental package human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gutMIMARKSSurvey"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gutMIMARKSSurvey"
    class_name: ClassVar[str] = "human-gut MIMARKS survey"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gutMIMARKSSurvey

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    source_mat_id: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-gutMISAG(Human-gut):
    """
    Combinatorial checklist Minimum Information About a Single Amplified Genome with environmental package human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gutMISAG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gutMISAG"
    class_name: ClassVar[str] = "human-gut MISAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gutMISAG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    sort_tech: Union[str, "SortTechEnum"] = None
    single_cell_lysis_appr: Union[str, "SingleCellLysisApprEnum"] = None
    wga_amp_appr: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.sort_tech):
            self.MissingRequiredField("sort_tech")
        if not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self._is_empty(self.single_cell_lysis_appr):
            self.MissingRequiredField("single_cell_lysis_appr")
        if not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self._is_empty(self.wga_amp_appr):
            self.MissingRequiredField("wga_amp_appr")
        if not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-gutMIMAG(Human-gut):
    """
    Combinatorial checklist Minimum Information About a Metagenome-Assembled Genome with environmental package
    human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gutMIMAG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gutMIMAG"
    class_name: ClassVar[str] = "human-gut MIMAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gutMIMAG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    bin_param: Union[str, "BinParamEnum"] = None
    bin_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.bin_param):
            self.MissingRequiredField("bin_param")
        if not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self._is_empty(self.bin_software):
            self.MissingRequiredField("bin_software")
        if not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-gutMIUVIG(Human-gut):
    """
    Combinatorial checklist Minimum Information About an Uncultivated Virus Genome with environmental package human-gut
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-gutMIUVIG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-gutMIUVIG"
    class_name: ClassVar[str] = "human-gut MIUVIG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-gutMIUVIG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    source_uvig: Union[str, "SourceUvigEnum"] = None
    virus_enrich_appr: Union[str, "VirusEnrichApprEnum"] = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    vir_ident_software: str = None
    pred_genome_type: Union[str, "PredGenomeTypeEnum"] = None
    pred_genome_struc: Union[str, "PredGenomeStrucEnum"] = None
    detec_type: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    sort_tech: Optional[Union[str, "SortTechEnum"]] = None
    single_cell_lysis_appr: Optional[Union[str, "SingleCellLysisApprEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_appr: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    bin_param: Optional[Union[str, "BinParamEnum"]] = None
    bin_software: Optional[str] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    otu_class_appr: Optional[str] = None
    otu_seq_comp_appr: Optional[str] = None
    otu_db: Optional[str] = None
    host_pred_appr: Optional[Union[str, "HostPredApprEnum"]] = None
    host_pred_est_acc: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.source_uvig):
            self.MissingRequiredField("source_uvig")
        if not isinstance(self.source_uvig, SourceUvigEnum):
            self.source_uvig = SourceUvigEnum(self.source_uvig)

        if self._is_empty(self.virus_enrich_appr):
            self.MissingRequiredField("virus_enrich_appr")
        if not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self._is_empty(self.vir_ident_software):
            self.MissingRequiredField("vir_ident_software")
        if not isinstance(self.vir_ident_software, str):
            self.vir_ident_software = str(self.vir_ident_software)

        if self._is_empty(self.pred_genome_type):
            self.MissingRequiredField("pred_genome_type")
        if not isinstance(self.pred_genome_type, PredGenomeTypeEnum):
            self.pred_genome_type = PredGenomeTypeEnum(self.pred_genome_type)

        if self._is_empty(self.pred_genome_struc):
            self.MissingRequiredField("pred_genome_struc")
        if not isinstance(self.pred_genome_struc, PredGenomeStrucEnum):
            self.pred_genome_struc = PredGenomeStrucEnum(self.pred_genome_struc)

        if self._is_empty(self.detec_type):
            self.MissingRequiredField("detec_type")
        if not isinstance(self.detec_type, str):
            self.detec_type = str(self.detec_type)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.sort_tech is not None and not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self.single_cell_lysis_appr is not None and not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_appr is not None and not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.bin_param is not None and not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self.bin_software is not None and not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.otu_class_appr is not None and not isinstance(self.otu_class_appr, str):
            self.otu_class_appr = str(self.otu_class_appr)

        if self.otu_seq_comp_appr is not None and not isinstance(self.otu_seq_comp_appr, str):
            self.otu_seq_comp_appr = str(self.otu_seq_comp_appr)

        if self.otu_db is not None and not isinstance(self.otu_db, str):
            self.otu_db = str(self.otu_db)

        if self.host_pred_appr is not None and not isinstance(self.host_pred_appr, HostPredApprEnum):
            self.host_pred_appr = HostPredApprEnum(self.host_pred_appr)

        if self.host_pred_est_acc is not None and not isinstance(self.host_pred_est_acc, str):
            self.host_pred_est_acc = str(self.host_pred_est_acc)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-oral(YAMLRoot):
    """
    human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oral"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oral"
    class_name: ClassVar[str] = "human-oral"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oral

    samp_name: str = None
    project_name: str = None
    lat_lon: Optional[str] = None
    depth: Optional[Union[dict, "QuantityValue"]] = None
    alt: Optional[Union[dict, "QuantityValue"]] = None
    elev: Optional[Union[dict, "QuantityValue"]] = None
    temp: Optional[Union[dict, "QuantityValue"]] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    nose_throat_disord: Optional[Union[str, List[str]]] = empty_list()
    time_last_toothbrush: Optional[str] = None
    host_subject_id: Optional[str] = None
    host_age: Optional[Union[dict, "QuantityValue"]] = None
    host_sex: Optional[Union[str, "HostSexEnum"]] = None
    ihmc_medication_code: Optional[Union[int, List[int]]] = empty_list()
    chem_administration: Optional[Union[str, List[str]]] = empty_list()
    host_body_site: Optional[str] = None
    host_body_product: Optional[str] = None
    host_tot_mass: Optional[Union[dict, "QuantityValue"]] = None
    host_height: Optional[Union[dict, "QuantityValue"]] = None
    host_diet: Optional[Union[str, List[str]]] = empty_list()
    host_last_meal: Optional[Union[str, List[str]]] = empty_list()
    host_family_relation: Optional[Union[str, List[str]]] = empty_list()
    host_genotype: Optional[str] = None
    host_phenotype: Optional[str] = None
    host_body_temp: Optional[Union[dict, "QuantityValue"]] = None
    host_body_mass_index: Optional[Union[dict, "QuantityValue"]] = None
    ethnicity: Optional[Union[str, List[str]]] = empty_list()
    host_occupation: Optional[int] = None
    medic_hist_perform: Optional[str] = None
    host_pulse: Optional[Union[dict, "QuantityValue"]] = None
    perturbation: Optional[Union[str, List[str]]] = empty_list()
    salinity: Optional[Union[dict, "QuantityValue"]] = None
    oxy_stat_samp: Optional[Union[str, "OxyStatSampEnum"]] = None
    organism_count: Optional[Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]]] = empty_list()
    samp_store_temp: Optional[Union[dict, "QuantityValue"]] = None
    samp_store_dur: Optional[str] = None
    host_symbiont: Optional[Union[str, List[str]]] = empty_list()
    samp_store_loc: Optional[str] = None
    misc_param: Optional[Union[str, List[str]]] = empty_list()
    host_disease_stat: Optional[str] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.depth is not None and not isinstance(self.depth, QuantityValue):
            self.depth = QuantityValue(**as_dict(self.depth))

        if self.alt is not None and not isinstance(self.alt, QuantityValue):
            self.alt = QuantityValue(**as_dict(self.alt))

        if self.elev is not None and not isinstance(self.elev, QuantityValue):
            self.elev = QuantityValue(**as_dict(self.elev))

        if self.temp is not None and not isinstance(self.temp, QuantityValue):
            self.temp = QuantityValue(**as_dict(self.temp))

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if not isinstance(self.nose_throat_disord, list):
            self.nose_throat_disord = [self.nose_throat_disord] if self.nose_throat_disord is not None else []
        self.nose_throat_disord = [v if isinstance(v, str) else str(v) for v in self.nose_throat_disord]

        if self.time_last_toothbrush is not None and not isinstance(self.time_last_toothbrush, str):
            self.time_last_toothbrush = str(self.time_last_toothbrush)

        if self.host_subject_id is not None and not isinstance(self.host_subject_id, str):
            self.host_subject_id = str(self.host_subject_id)

        if self.host_age is not None and not isinstance(self.host_age, QuantityValue):
            self.host_age = QuantityValue(**as_dict(self.host_age))

        if self.host_sex is not None and not isinstance(self.host_sex, HostSexEnum):
            self.host_sex = HostSexEnum(self.host_sex)

        if not isinstance(self.ihmc_medication_code, list):
            self.ihmc_medication_code = [self.ihmc_medication_code] if self.ihmc_medication_code is not None else []
        self.ihmc_medication_code = [v if isinstance(v, int) else int(v) for v in self.ihmc_medication_code]

        if not isinstance(self.chem_administration, list):
            self.chem_administration = [self.chem_administration] if self.chem_administration is not None else []
        self.chem_administration = [v if isinstance(v, str) else str(v) for v in self.chem_administration]

        if self.host_body_site is not None and not isinstance(self.host_body_site, str):
            self.host_body_site = str(self.host_body_site)

        if self.host_body_product is not None and not isinstance(self.host_body_product, str):
            self.host_body_product = str(self.host_body_product)

        if self.host_tot_mass is not None and not isinstance(self.host_tot_mass, QuantityValue):
            self.host_tot_mass = QuantityValue(**as_dict(self.host_tot_mass))

        if self.host_height is not None and not isinstance(self.host_height, QuantityValue):
            self.host_height = QuantityValue(**as_dict(self.host_height))

        if not isinstance(self.host_diet, list):
            self.host_diet = [self.host_diet] if self.host_diet is not None else []
        self.host_diet = [v if isinstance(v, str) else str(v) for v in self.host_diet]

        if not isinstance(self.host_last_meal, list):
            self.host_last_meal = [self.host_last_meal] if self.host_last_meal is not None else []
        self.host_last_meal = [v if isinstance(v, str) else str(v) for v in self.host_last_meal]

        if not isinstance(self.host_family_relation, list):
            self.host_family_relation = [self.host_family_relation] if self.host_family_relation is not None else []
        self.host_family_relation = [v if isinstance(v, str) else str(v) for v in self.host_family_relation]

        if self.host_genotype is not None and not isinstance(self.host_genotype, str):
            self.host_genotype = str(self.host_genotype)

        if self.host_phenotype is not None and not isinstance(self.host_phenotype, str):
            self.host_phenotype = str(self.host_phenotype)

        if self.host_body_temp is not None and not isinstance(self.host_body_temp, QuantityValue):
            self.host_body_temp = QuantityValue(**as_dict(self.host_body_temp))

        if self.host_body_mass_index is not None and not isinstance(self.host_body_mass_index, QuantityValue):
            self.host_body_mass_index = QuantityValue(**as_dict(self.host_body_mass_index))

        if not isinstance(self.ethnicity, list):
            self.ethnicity = [self.ethnicity] if self.ethnicity is not None else []
        self.ethnicity = [v if isinstance(v, str) else str(v) for v in self.ethnicity]

        if self.host_occupation is not None and not isinstance(self.host_occupation, int):
            self.host_occupation = int(self.host_occupation)

        if self.medic_hist_perform is not None and not isinstance(self.medic_hist_perform, str):
            self.medic_hist_perform = str(self.medic_hist_perform)

        if self.host_pulse is not None and not isinstance(self.host_pulse, QuantityValue):
            self.host_pulse = QuantityValue(**as_dict(self.host_pulse))

        if not isinstance(self.perturbation, list):
            self.perturbation = [self.perturbation] if self.perturbation is not None else []
        self.perturbation = [v if isinstance(v, str) else str(v) for v in self.perturbation]

        if self.salinity is not None and not isinstance(self.salinity, QuantityValue):
            self.salinity = QuantityValue(**as_dict(self.salinity))

        if self.oxy_stat_samp is not None and not isinstance(self.oxy_stat_samp, OxyStatSampEnum):
            self.oxy_stat_samp = OxyStatSampEnum(self.oxy_stat_samp)

        if not isinstance(self.organism_count, list):
            self.organism_count = [self.organism_count] if self.organism_count is not None else []
        self.organism_count = [v if isinstance(v, OrganismCountEnum) else OrganismCountEnum(v) for v in self.organism_count]

        if self.samp_store_temp is not None and not isinstance(self.samp_store_temp, QuantityValue):
            self.samp_store_temp = QuantityValue(**as_dict(self.samp_store_temp))

        if self.samp_store_dur is not None and not isinstance(self.samp_store_dur, str):
            self.samp_store_dur = str(self.samp_store_dur)

        if not isinstance(self.host_symbiont, list):
            self.host_symbiont = [self.host_symbiont] if self.host_symbiont is not None else []
        self.host_symbiont = [v if isinstance(v, str) else str(v) for v in self.host_symbiont]

        if self.samp_store_loc is not None and not isinstance(self.samp_store_loc, str):
            self.samp_store_loc = str(self.samp_store_loc)

        if not isinstance(self.misc_param, list):
            self.misc_param = [self.misc_param] if self.misc_param is not None else []
        self.misc_param = [v if isinstance(v, str) else str(v) for v in self.misc_param]

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        super().__post_init__(**kwargs)


@dataclass
class Human-oralMIGSEukaryote(Human-oral):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: eukaryote with environmental package
    human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oralMIGSEukaryote"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oralMIGSEukaryote"
    class_name: ClassVar[str] = "human-oral MIGS eukaryote"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oralMIGSEukaryote

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    ploidy: Optional[str] = None
    num_replicons: Optional[int] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    propagation: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.ploidy is not None and not isinstance(self.ploidy, str):
            self.ploidy = str(self.ploidy)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.propagation is not None and not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-oralMIGSBacteria(Human-oral):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oralMIGSBacteria"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oralMIGSBacteria"
    class_name: ClassVar[str] = "human-oral MIGS bacteria"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oralMIGSBacteria

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    num_replicons: int = None
    ref_biomaterial: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    encoded_traits: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.num_replicons):
            self.MissingRequiredField("num_replicons")
        if not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self._is_empty(self.ref_biomaterial):
            self.MissingRequiredField("ref_biomaterial")
        if not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-oralMIGSPlant(Human-oral):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: plant with environmental package human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oralMIGSPlant"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oralMIGSPlant"
    class_name: ClassVar[str] = "human-oral MIGS plant"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oralMIGSPlant

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-oralMIGSVirus(Human-oral):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oralMIGSVirus"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oralMIGSVirus"
    class_name: ClassVar[str] = "human-oral MIGS virus"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oralMIGSVirus

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    num_replicons: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    virus_enrich_appr: Optional[Union[str, "VirusEnrichApprEnum"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.virus_enrich_appr is not None and not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-oralMIGSOrg(Human-oral):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: org with environmental package human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oralMIGSOrg"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oralMIGSOrg"
    class_name: ClassVar[str] = "human-oral MIGS org"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oralMIGSOrg

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-oralMIMS(Human-oral):
    """
    Combinatorial checklist Metagenome or Environmental with environmental package human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oralMIMS"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oralMIMS"
    class_name: ClassVar[str] = "human-oral MIMS"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oralMIMS

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    assembly_software: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-oralMIMARKSSpecimen(Human-oral):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: specimen with environmental package human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oralMIMARKSSpecimen"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oralMIMARKSSpecimen"
    class_name: ClassVar[str] = "human-oral MIMARKS specimen"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oralMIMARKSSpecimen

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    assembly_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.assembly_software is not None and not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-oralMIMARKSSurvey(Human-oral):
    """
    Combinatorial checklist Minimal Information about a Marker Specimen: survey with environmental package human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oralMIMARKSSurvey"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oralMIMARKSSurvey"
    class_name: ClassVar[str] = "human-oral MIMARKS survey"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oralMIMARKSSurvey

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    target_gene: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    source_mat_id: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    target_subfragment: Optional[str] = None
    pcr_primers: Optional[str] = None
    pcr_cond: Optional[str] = None
    seq_quality_check: Optional[str] = None
    chimera_check: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.target_gene):
            self.MissingRequiredField("target_gene")
        if not isinstance(self.target_gene, str):
            self.target_gene = str(self.target_gene)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.target_subfragment is not None and not isinstance(self.target_subfragment, str):
            self.target_subfragment = str(self.target_subfragment)

        if self.pcr_primers is not None and not isinstance(self.pcr_primers, str):
            self.pcr_primers = str(self.pcr_primers)

        if self.pcr_cond is not None and not isinstance(self.pcr_cond, str):
            self.pcr_cond = str(self.pcr_cond)

        if self.seq_quality_check is not None and not isinstance(self.seq_quality_check, str):
            self.seq_quality_check = str(self.seq_quality_check)

        if self.chimera_check is not None and not isinstance(self.chimera_check, str):
            self.chimera_check = str(self.chimera_check)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-oralMISAG(Human-oral):
    """
    Combinatorial checklist Minimum Information About a Single Amplified Genome with environmental package human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oralMISAG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oralMISAG"
    class_name: ClassVar[str] = "human-oral MISAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oralMISAG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    sort_tech: Union[str, "SortTechEnum"] = None
    single_cell_lysis_appr: Union[str, "SingleCellLysisApprEnum"] = None
    wga_amp_appr: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.sort_tech):
            self.MissingRequiredField("sort_tech")
        if not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self._is_empty(self.single_cell_lysis_appr):
            self.MissingRequiredField("single_cell_lysis_appr")
        if not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self._is_empty(self.wga_amp_appr):
            self.MissingRequiredField("wga_amp_appr")
        if not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-oralMIMAG(Human-oral):
    """
    Combinatorial checklist Minimum Information About a Metagenome-Assembled Genome with environmental package
    human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oralMIMAG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oralMIMAG"
    class_name: ClassVar[str] = "human-oral MIMAG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oralMIMAG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    tax_ident: Union[str, "TaxIdentEnum"] = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    compl_score: str = None
    compl_software: str = None
    contam_score: str = None
    bin_param: Union[str, "BinParamEnum"] = None
    bin_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    x_16s_recover: Optional[str] = None
    x_16s_recover_software: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    contam_screen_input: Optional[str] = None
    contam_screen_param: Optional[str] = None
    decontam_software: Optional[Union[str, "DecontamSoftwareEnum"]] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.tax_ident):
            self.MissingRequiredField("tax_ident")
        if not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.compl_score):
            self.MissingRequiredField("compl_score")
        if not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self._is_empty(self.compl_software):
            self.MissingRequiredField("compl_software")
        if not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self._is_empty(self.contam_score):
            self.MissingRequiredField("contam_score")
        if not isinstance(self.contam_score, str):
            self.contam_score = str(self.contam_score)

        if self._is_empty(self.bin_param):
            self.MissingRequiredField("bin_param")
        if not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self._is_empty(self.bin_software):
            self.MissingRequiredField("bin_software")
        if not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.x_16s_recover is not None and not isinstance(self.x_16s_recover, str):
            self.x_16s_recover = str(self.x_16s_recover)

        if self.x_16s_recover_software is not None and not isinstance(self.x_16s_recover_software, str):
            self.x_16s_recover_software = str(self.x_16s_recover_software)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.contam_screen_input is not None and not isinstance(self.contam_screen_input, str):
            self.contam_screen_input = str(self.contam_screen_input)

        if self.contam_screen_param is not None and not isinstance(self.contam_screen_param, str):
            self.contam_screen_param = str(self.contam_screen_param)

        if self.decontam_software is not None and not isinstance(self.decontam_software, DecontamSoftwareEnum):
            self.decontam_software = DecontamSoftwareEnum(self.decontam_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-oralMIUVIG(Human-oral):
    """
    Combinatorial checklist Minimum Information About an Uncultivated Virus Genome with environmental package
    human-oral
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-oralMIUVIG"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-oralMIUVIG"
    class_name: ClassVar[str] = "human-oral MIUVIG"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-oralMIUVIG

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    source_uvig: Union[str, "SourceUvigEnum"] = None
    virus_enrich_appr: Union[str, "VirusEnrichApprEnum"] = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    vir_ident_software: str = None
    pred_genome_type: Union[str, "PredGenomeTypeEnum"] = None
    pred_genome_struc: Union[str, "PredGenomeStrucEnum"] = None
    detec_type: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    mid: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    trnas: Optional[int] = None
    trna_ext_software: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    compl_appr: Optional[Union[str, "ComplApprEnum"]] = None
    sort_tech: Optional[Union[str, "SortTechEnum"]] = None
    single_cell_lysis_appr: Optional[Union[str, "SingleCellLysisApprEnum"]] = None
    single_cell_lysis_prot: Optional[str] = None
    wga_amp_appr: Optional[str] = None
    wga_amp_kit: Optional[str] = None
    bin_param: Optional[Union[str, "BinParamEnum"]] = None
    bin_software: Optional[str] = None
    reassembly_bin: Optional[str] = None
    mag_cov_software: Optional[Union[str, "MagCovSoftwareEnum"]] = None
    otu_class_appr: Optional[str] = None
    otu_seq_comp_appr: Optional[str] = None
    otu_db: Optional[str] = None
    host_pred_appr: Optional[Union[str, "HostPredApprEnum"]] = None
    host_pred_est_acc: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.source_uvig):
            self.MissingRequiredField("source_uvig")
        if not isinstance(self.source_uvig, SourceUvigEnum):
            self.source_uvig = SourceUvigEnum(self.source_uvig)

        if self._is_empty(self.virus_enrich_appr):
            self.MissingRequiredField("virus_enrich_appr")
        if not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self._is_empty(self.vir_ident_software):
            self.MissingRequiredField("vir_ident_software")
        if not isinstance(self.vir_ident_software, str):
            self.vir_ident_software = str(self.vir_ident_software)

        if self._is_empty(self.pred_genome_type):
            self.MissingRequiredField("pred_genome_type")
        if not isinstance(self.pred_genome_type, PredGenomeTypeEnum):
            self.pred_genome_type = PredGenomeTypeEnum(self.pred_genome_type)

        if self._is_empty(self.pred_genome_struc):
            self.MissingRequiredField("pred_genome_struc")
        if not isinstance(self.pred_genome_struc, PredGenomeStrucEnum):
            self.pred_genome_struc = PredGenomeStrucEnum(self.pred_genome_struc)

        if self._is_empty(self.detec_type):
            self.MissingRequiredField("detec_type")
        if not isinstance(self.detec_type, str):
            self.detec_type = str(self.detec_type)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.size_frac is not None and not isinstance(self.size_frac, str):
            self.size_frac = str(self.size_frac)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.mid is not None and not isinstance(self.mid, str):
            self.mid = str(self.mid)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.trnas is not None and not isinstance(self.trnas, int):
            self.trnas = int(self.trnas)

        if self.trna_ext_software is not None and not isinstance(self.trna_ext_software, str):
            self.trna_ext_software = str(self.trna_ext_software)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.compl_appr is not None and not isinstance(self.compl_appr, ComplApprEnum):
            self.compl_appr = ComplApprEnum(self.compl_appr)

        if self.sort_tech is not None and not isinstance(self.sort_tech, SortTechEnum):
            self.sort_tech = SortTechEnum(self.sort_tech)

        if self.single_cell_lysis_appr is not None and not isinstance(self.single_cell_lysis_appr, SingleCellLysisApprEnum):
            self.single_cell_lysis_appr = SingleCellLysisApprEnum(self.single_cell_lysis_appr)

        if self.single_cell_lysis_prot is not None and not isinstance(self.single_cell_lysis_prot, str):
            self.single_cell_lysis_prot = str(self.single_cell_lysis_prot)

        if self.wga_amp_appr is not None and not isinstance(self.wga_amp_appr, str):
            self.wga_amp_appr = str(self.wga_amp_appr)

        if self.wga_amp_kit is not None and not isinstance(self.wga_amp_kit, str):
            self.wga_amp_kit = str(self.wga_amp_kit)

        if self.bin_param is not None and not isinstance(self.bin_param, BinParamEnum):
            self.bin_param = BinParamEnum(self.bin_param)

        if self.bin_software is not None and not isinstance(self.bin_software, str):
            self.bin_software = str(self.bin_software)

        if self.reassembly_bin is not None and not isinstance(self.reassembly_bin, str):
            self.reassembly_bin = str(self.reassembly_bin)

        if self.mag_cov_software is not None and not isinstance(self.mag_cov_software, MagCovSoftwareEnum):
            self.mag_cov_software = MagCovSoftwareEnum(self.mag_cov_software)

        if self.otu_class_appr is not None and not isinstance(self.otu_class_appr, str):
            self.otu_class_appr = str(self.otu_class_appr)

        if self.otu_seq_comp_appr is not None and not isinstance(self.otu_seq_comp_appr, str):
            self.otu_seq_comp_appr = str(self.otu_seq_comp_appr)

        if self.otu_db is not None and not isinstance(self.otu_db, str):
            self.otu_db = str(self.otu_db)

        if self.host_pred_appr is not None and not isinstance(self.host_pred_appr, HostPredApprEnum):
            self.host_pred_appr = HostPredApprEnum(self.host_pred_appr)

        if self.host_pred_est_acc is not None and not isinstance(self.host_pred_est_acc, str):
            self.host_pred_est_acc = str(self.host_pred_est_acc)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-skin(YAMLRoot):
    """
    human-skin
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-skin"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-skin"
    class_name: ClassVar[str] = "human-skin"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-skin

    samp_name: str = None
    project_name: str = None
    lat_lon: Optional[str] = None
    depth: Optional[Union[dict, "QuantityValue"]] = None
    alt: Optional[Union[dict, "QuantityValue"]] = None
    elev: Optional[Union[dict, "QuantityValue"]] = None
    temp: Optional[Union[dict, "QuantityValue"]] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    dermatology_disord: Optional[Union[str, List[str]]] = empty_list()
    time_since_last_wash: Optional[str] = None
    dominant_hand: Optional[Union[str, "DominantHandEnum"]] = None
    host_subject_id: Optional[str] = None
    host_age: Optional[Union[dict, "QuantityValue"]] = None
    host_sex: Optional[Union[str, "HostSexEnum"]] = None
    ihmc_medication_code: Optional[Union[int, List[int]]] = empty_list()
    chem_administration: Optional[Union[str, List[str]]] = empty_list()
    host_body_site: Optional[str] = None
    host_body_product: Optional[str] = None
    host_tot_mass: Optional[Union[dict, "QuantityValue"]] = None
    host_height: Optional[Union[dict, "QuantityValue"]] = None
    host_diet: Optional[Union[str, List[str]]] = empty_list()
    host_last_meal: Optional[Union[str, List[str]]] = empty_list()
    host_family_relation: Optional[Union[str, List[str]]] = empty_list()
    host_genotype: Optional[str] = None
    host_phenotype: Optional[str] = None
    host_body_temp: Optional[Union[dict, "QuantityValue"]] = None
    host_body_mass_index: Optional[Union[dict, "QuantityValue"]] = None
    ethnicity: Optional[Union[str, List[str]]] = empty_list()
    host_occupation: Optional[int] = None
    medic_hist_perform: Optional[str] = None
    host_pulse: Optional[Union[dict, "QuantityValue"]] = None
    perturbation: Optional[Union[str, List[str]]] = empty_list()
    salinity: Optional[Union[dict, "QuantityValue"]] = None
    oxy_stat_samp: Optional[Union[str, "OxyStatSampEnum"]] = None
    organism_count: Optional[Union[Union[str, "OrganismCountEnum"], List[Union[str, "OrganismCountEnum"]]]] = empty_list()
    samp_store_temp: Optional[Union[dict, "QuantityValue"]] = None
    samp_store_dur: Optional[str] = None
    samp_store_loc: Optional[str] = None
    host_symbiont: Optional[Union[str, List[str]]] = empty_list()
    misc_param: Optional[Union[str, List[str]]] = empty_list()
    host_disease_stat: Optional[str] = None
    samp_vol_we_dna_ext: Optional[Union[dict, "QuantityValue"]] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_name):
            self.MissingRequiredField("samp_name")
        if not isinstance(self.samp_name, str):
            self.samp_name = str(self.samp_name)

        if self._is_empty(self.project_name):
            self.MissingRequiredField("project_name")
        if not isinstance(self.project_name, str):
            self.project_name = str(self.project_name)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.depth is not None and not isinstance(self.depth, QuantityValue):
            self.depth = QuantityValue(**as_dict(self.depth))

        if self.alt is not None and not isinstance(self.alt, QuantityValue):
            self.alt = QuantityValue(**as_dict(self.alt))

        if self.elev is not None and not isinstance(self.elev, QuantityValue):
            self.elev = QuantityValue(**as_dict(self.elev))

        if self.temp is not None and not isinstance(self.temp, QuantityValue):
            self.temp = QuantityValue(**as_dict(self.temp))

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if not isinstance(self.dermatology_disord, list):
            self.dermatology_disord = [self.dermatology_disord] if self.dermatology_disord is not None else []
        self.dermatology_disord = [v if isinstance(v, str) else str(v) for v in self.dermatology_disord]

        if self.time_since_last_wash is not None and not isinstance(self.time_since_last_wash, str):
            self.time_since_last_wash = str(self.time_since_last_wash)

        if self.dominant_hand is not None and not isinstance(self.dominant_hand, DominantHandEnum):
            self.dominant_hand = DominantHandEnum(self.dominant_hand)

        if self.host_subject_id is not None and not isinstance(self.host_subject_id, str):
            self.host_subject_id = str(self.host_subject_id)

        if self.host_age is not None and not isinstance(self.host_age, QuantityValue):
            self.host_age = QuantityValue(**as_dict(self.host_age))

        if self.host_sex is not None and not isinstance(self.host_sex, HostSexEnum):
            self.host_sex = HostSexEnum(self.host_sex)

        if not isinstance(self.ihmc_medication_code, list):
            self.ihmc_medication_code = [self.ihmc_medication_code] if self.ihmc_medication_code is not None else []
        self.ihmc_medication_code = [v if isinstance(v, int) else int(v) for v in self.ihmc_medication_code]

        if not isinstance(self.chem_administration, list):
            self.chem_administration = [self.chem_administration] if self.chem_administration is not None else []
        self.chem_administration = [v if isinstance(v, str) else str(v) for v in self.chem_administration]

        if self.host_body_site is not None and not isinstance(self.host_body_site, str):
            self.host_body_site = str(self.host_body_site)

        if self.host_body_product is not None and not isinstance(self.host_body_product, str):
            self.host_body_product = str(self.host_body_product)

        if self.host_tot_mass is not None and not isinstance(self.host_tot_mass, QuantityValue):
            self.host_tot_mass = QuantityValue(**as_dict(self.host_tot_mass))

        if self.host_height is not None and not isinstance(self.host_height, QuantityValue):
            self.host_height = QuantityValue(**as_dict(self.host_height))

        if not isinstance(self.host_diet, list):
            self.host_diet = [self.host_diet] if self.host_diet is not None else []
        self.host_diet = [v if isinstance(v, str) else str(v) for v in self.host_diet]

        if not isinstance(self.host_last_meal, list):
            self.host_last_meal = [self.host_last_meal] if self.host_last_meal is not None else []
        self.host_last_meal = [v if isinstance(v, str) else str(v) for v in self.host_last_meal]

        if not isinstance(self.host_family_relation, list):
            self.host_family_relation = [self.host_family_relation] if self.host_family_relation is not None else []
        self.host_family_relation = [v if isinstance(v, str) else str(v) for v in self.host_family_relation]

        if self.host_genotype is not None and not isinstance(self.host_genotype, str):
            self.host_genotype = str(self.host_genotype)

        if self.host_phenotype is not None and not isinstance(self.host_phenotype, str):
            self.host_phenotype = str(self.host_phenotype)

        if self.host_body_temp is not None and not isinstance(self.host_body_temp, QuantityValue):
            self.host_body_temp = QuantityValue(**as_dict(self.host_body_temp))

        if self.host_body_mass_index is not None and not isinstance(self.host_body_mass_index, QuantityValue):
            self.host_body_mass_index = QuantityValue(**as_dict(self.host_body_mass_index))

        if not isinstance(self.ethnicity, list):
            self.ethnicity = [self.ethnicity] if self.ethnicity is not None else []
        self.ethnicity = [v if isinstance(v, str) else str(v) for v in self.ethnicity]

        if self.host_occupation is not None and not isinstance(self.host_occupation, int):
            self.host_occupation = int(self.host_occupation)

        if self.medic_hist_perform is not None and not isinstance(self.medic_hist_perform, str):
            self.medic_hist_perform = str(self.medic_hist_perform)

        if self.host_pulse is not None and not isinstance(self.host_pulse, QuantityValue):
            self.host_pulse = QuantityValue(**as_dict(self.host_pulse))

        if not isinstance(self.perturbation, list):
            self.perturbation = [self.perturbation] if self.perturbation is not None else []
        self.perturbation = [v if isinstance(v, str) else str(v) for v in self.perturbation]

        if self.salinity is not None and not isinstance(self.salinity, QuantityValue):
            self.salinity = QuantityValue(**as_dict(self.salinity))

        if self.oxy_stat_samp is not None and not isinstance(self.oxy_stat_samp, OxyStatSampEnum):
            self.oxy_stat_samp = OxyStatSampEnum(self.oxy_stat_samp)

        if not isinstance(self.organism_count, list):
            self.organism_count = [self.organism_count] if self.organism_count is not None else []
        self.organism_count = [v if isinstance(v, OrganismCountEnum) else OrganismCountEnum(v) for v in self.organism_count]

        if self.samp_store_temp is not None and not isinstance(self.samp_store_temp, QuantityValue):
            self.samp_store_temp = QuantityValue(**as_dict(self.samp_store_temp))

        if self.samp_store_dur is not None and not isinstance(self.samp_store_dur, str):
            self.samp_store_dur = str(self.samp_store_dur)

        if self.samp_store_loc is not None and not isinstance(self.samp_store_loc, str):
            self.samp_store_loc = str(self.samp_store_loc)

        if not isinstance(self.host_symbiont, list):
            self.host_symbiont = [self.host_symbiont] if self.host_symbiont is not None else []
        self.host_symbiont = [v if isinstance(v, str) else str(v) for v in self.host_symbiont]

        if not isinstance(self.misc_param, list):
            self.misc_param = [self.misc_param] if self.misc_param is not None else []
        self.misc_param = [v if isinstance(v, str) else str(v) for v in self.misc_param]

        if self.host_disease_stat is not None and not isinstance(self.host_disease_stat, str):
            self.host_disease_stat = str(self.host_disease_stat)

        if self.samp_vol_we_dna_ext is not None and not isinstance(self.samp_vol_we_dna_ext, QuantityValue):
            self.samp_vol_we_dna_ext = QuantityValue(**as_dict(self.samp_vol_we_dna_ext))

        super().__post_init__(**kwargs)


@dataclass
class Human-skinMIGSEukaryote(Human-skin):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: eukaryote with environmental package
    human-skin
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-skinMIGSEukaryote"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-skinMIGSEukaryote"
    class_name: ClassVar[str] = "human-skin MIGS eukaryote"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-skinMIGSEukaryote

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    ploidy: Optional[str] = None
    num_replicons: Optional[int] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    propagation: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.ploidy is not None and not isinstance(self.ploidy, str):
            self.ploidy = str(self.ploidy)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.propagation is not None and not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-skinMIGSBacteria(Human-skin):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package human-skin
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-skinMIGSBacteria"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-skinMIGSBacteria"
    class_name: ClassVar[str] = "human-skin MIGS bacteria"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-skinMIGSBacteria

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    num_replicons: int = None
    ref_biomaterial: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_qual: Union[str, "AssemblyQualEnum"] = None
    assembly_software: str = None
    number_contig: int = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    trophic_level: Optional[Union[str, "TrophicLevelEnum"]] = None
    encoded_traits: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.num_replicons):
            self.MissingRequiredField("num_replicons")
        if not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self._is_empty(self.ref_biomaterial):
            self.MissingRequiredField("ref_biomaterial")
        if not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_qual):
            self.MissingRequiredField("assembly_qual")
        if not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self._is_empty(self.number_contig):
            self.MissingRequiredField("number_contig")
        if not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.trophic_level is not None and not isinstance(self.trophic_level, TrophicLevelEnum):
            self.trophic_level = TrophicLevelEnum(self.trophic_level)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.rel_to_oxygen is not None and not isinstance(self.rel_to_oxygen, RelToOxygenEnum):
            self.rel_to_oxygen = RelToOxygenEnum(self.rel_to_oxygen)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-skinMIGSPlant(Human-skin):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: plant with environmental package human-skin
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-skinMIGSPlant"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-skinMIGSPlant"
    class_name: ClassVar[str] = "human-skin MIGS plant"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-skinMIGSPlant

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-skinMIGSVirus(Human-skin):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: cultured bacteria/archaea with environmental
    package human-skin
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-skinMIGSVirus"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-skinMIGSVirus"
    class_name: ClassVar[str] = "human-skin MIGS virus"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-skinMIGSVirus

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    propagation: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    num_replicons: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    pathogenicity: Optional[str] = None
    biotic_relationship: Optional[Union[str, "BioticRelationshipEnum"]] = None
    specific_host: Optional[str] = None
    host_spec_range: Optional[int] = None
    encoded_traits: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    virus_enrich_appr: Optional[Union[str, "VirusEnrichApprEnum"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.propagation):
            self.MissingRequiredField("propagation")
        if not isinstance(self.propagation, str):
            self.propagation = str(self.propagation)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.num_replicons is not None and not isinstance(self.num_replicons, int):
            self.num_replicons = int(self.num_replicons)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.pathogenicity is not None and not isinstance(self.pathogenicity, str):
            self.pathogenicity = str(self.pathogenicity)

        if self.biotic_relationship is not None and not isinstance(self.biotic_relationship, BioticRelationshipEnum):
            self.biotic_relationship = BioticRelationshipEnum(self.biotic_relationship)

        if self.specific_host is not None and not isinstance(self.specific_host, str):
            self.specific_host = str(self.specific_host)

        if self.host_spec_range is not None and not isinstance(self.host_spec_range, int):
            self.host_spec_range = int(self.host_spec_range)

        if self.encoded_traits is not None and not isinstance(self.encoded_traits, str):
            self.encoded_traits = str(self.encoded_traits)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.virus_enrich_appr is not None and not isinstance(self.virus_enrich_appr, VirusEnrichApprEnum):
            self.virus_enrich_appr = VirusEnrichApprEnum(self.virus_enrich_appr)

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-skinMIGSOrg(Human-skin):
    """
    Combinatorial checklist Minimal Information about a Genome Sequence: org with environmental package human-skin
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-skinMIGSOrg"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-skinMIGSOrg"
    class_name: ClassVar[str] = "human-skin MIGS org"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-skinMIGSOrg

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    isol_growth_condt: str = None
    seq_meth: str = None
    assembly_software: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    subspecf_gen_lin: Optional[str] = None
    extrachrom_elements: Optional[int] = None
    estimated_size: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    samp_size: Optional[Union[dict, "QuantityValue"]] = None
    nucl_acid_ext: Optional[str] = None
    nucl_acid_amp: Optional[str] = None
    lib_size: Optional[int] = None
    lib_reads_seqd: Optional[int] = None
    lib_layout: Optional[Union[str, "LibLayoutEnum"]] = None
    lib_vector: Optional[str] = None
    lib_screen: Optional[str] = None
    adapters: Optional[str] = None
    tax_ident: Optional[Union[str, "TaxIdentEnum"]] = None
    assembly_qual: Optional[Union[str, "AssemblyQualEnum"]] = None
    assembly_name: Optional[str] = None
    annot: Optional[str] = None
    number_contig: Optional[int] = None
    feat_pred: Optional[str] = None
    ref_db: Optional[str] = None
    sim_search_meth: Optional[str] = None
    tax_class: Optional[str] = None
    compl_score: Optional[str] = None
    compl_software: Optional[str] = None
    associated_resource: Optional[str] = None
    sop: Optional[str] = None

    def __post_init__(self, *_: List[str], **kwargs: Dict[str, Any]):
        if self._is_empty(self.samp_taxon_id):
            self.MissingRequiredField("samp_taxon_id")
        if not isinstance(self.samp_taxon_id, str):
            self.samp_taxon_id = str(self.samp_taxon_id)

        if self._is_empty(self.isol_growth_condt):
            self.MissingRequiredField("isol_growth_condt")
        if not isinstance(self.isol_growth_condt, str):
            self.isol_growth_condt = str(self.isol_growth_condt)

        if self._is_empty(self.seq_meth):
            self.MissingRequiredField("seq_meth")
        if not isinstance(self.seq_meth, str):
            self.seq_meth = str(self.seq_meth)

        if self._is_empty(self.assembly_software):
            self.MissingRequiredField("assembly_software")
        if not isinstance(self.assembly_software, str):
            self.assembly_software = str(self.assembly_software)

        if self.lat_lon is not None and not isinstance(self.lat_lon, str):
            self.lat_lon = str(self.lat_lon)

        if self.geo_loc_name is not None and not isinstance(self.geo_loc_name, str):
            self.geo_loc_name = str(self.geo_loc_name)

        if self.collection_date is not None and not isinstance(self.collection_date, XSDDate):
            self.collection_date = XSDDate(self.collection_date)

        if self.env_broad_scale is not None and not isinstance(self.env_broad_scale, str):
            self.env_broad_scale = str(self.env_broad_scale)

        if self.env_local_scale is not None and not isinstance(self.env_local_scale, str):
            self.env_local_scale = str(self.env_local_scale)

        if self.env_medium is not None and not isinstance(self.env_medium, str):
            self.env_medium = str(self.env_medium)

        if self.experimental_factor is not None and not isinstance(self.experimental_factor, str):
            self.experimental_factor = str(self.experimental_factor)

        if self.neg_cont_type is not None and not isinstance(self.neg_cont_type, NegContTypeEnum):
            self.neg_cont_type = NegContTypeEnum(self.neg_cont_type)

        if self.pos_cont_type is not None and not isinstance(self.pos_cont_type, str):
            self.pos_cont_type = str(self.pos_cont_type)

        if self.subspecf_gen_lin is not None and not isinstance(self.subspecf_gen_lin, str):
            self.subspecf_gen_lin = str(self.subspecf_gen_lin)

        if self.extrachrom_elements is not None and not isinstance(self.extrachrom_elements, int):
            self.extrachrom_elements = int(self.extrachrom_elements)

        if self.estimated_size is not None and not isinstance(self.estimated_size, str):
            self.estimated_size = str(self.estimated_size)

        if self.ref_biomaterial is not None and not isinstance(self.ref_biomaterial, str):
            self.ref_biomaterial = str(self.ref_biomaterial)

        if self.source_mat_id is not None and not isinstance(self.source_mat_id, str):
            self.source_mat_id = str(self.source_mat_id)

        if self.samp_collec_device is not None and not isinstance(self.samp_collec_device, str):
            self.samp_collec_device = str(self.samp_collec_device)

        if self.samp_collec_method is not None and not isinstance(self.samp_collec_method, str):
            self.samp_collec_method = str(self.samp_collec_method)

        if self.samp_mat_process is not None and not isinstance(self.samp_mat_process, str):
            self.samp_mat_process = str(self.samp_mat_process)

        if self.samp_size is not None and not isinstance(self.samp_size, QuantityValue):
            self.samp_size = QuantityValue(**as_dict(self.samp_size))

        if self.nucl_acid_ext is not None and not isinstance(self.nucl_acid_ext, str):
            self.nucl_acid_ext = str(self.nucl_acid_ext)

        if self.nucl_acid_amp is not None and not isinstance(self.nucl_acid_amp, str):
            self.nucl_acid_amp = str(self.nucl_acid_amp)

        if self.lib_size is not None and not isinstance(self.lib_size, int):
            self.lib_size = int(self.lib_size)

        if self.lib_reads_seqd is not None and not isinstance(self.lib_reads_seqd, int):
            self.lib_reads_seqd = int(self.lib_reads_seqd)

        if self.lib_layout is not None and not isinstance(self.lib_layout, LibLayoutEnum):
            self.lib_layout = LibLayoutEnum(self.lib_layout)

        if self.lib_vector is not None and not isinstance(self.lib_vector, str):
            self.lib_vector = str(self.lib_vector)

        if self.lib_screen is not None and not isinstance(self.lib_screen, str):
            self.lib_screen = str(self.lib_screen)

        if self.adapters is not None and not isinstance(self.adapters, str):
            self.adapters = str(self.adapters)

        if self.tax_ident is not None and not isinstance(self.tax_ident, TaxIdentEnum):
            self.tax_ident = TaxIdentEnum(self.tax_ident)

        if self.assembly_qual is not None and not isinstance(self.assembly_qual, AssemblyQualEnum):
            self.assembly_qual = AssemblyQualEnum(self.assembly_qual)

        if self.assembly_name is not None and not isinstance(self.assembly_name, str):
            self.assembly_name = str(self.assembly_name)

        if self.annot is not None and not isinstance(self.annot, str):
            self.annot = str(self.annot)

        if self.number_contig is not None and not isinstance(self.number_contig, int):
            self.number_contig = int(self.number_contig)

        if self.feat_pred is not None and not isinstance(self.feat_pred, str):
            self.feat_pred = str(self.feat_pred)

        if self.ref_db is not None and not isinstance(self.ref_db, str):
            self.ref_db = str(self.ref_db)

        if self.sim_search_meth is not None and not isinstance(self.sim_search_meth, str):
            self.sim_search_meth = str(self.sim_search_meth)

        if self.tax_class is not None and not isinstance(self.tax_class, str):
            self.tax_class = str(self.tax_class)

        if self.compl_score is not None and not isinstance(self.compl_score, str):
            self.compl_score = str(self.compl_score)

        if self.compl_software is not None and not isinstance(self.compl_software, str):
            self.compl_software = str(self.compl_software)

        if self.associated_resource is not None and not isinstance(self.associated_resource, str):
            self.associated_resource = str(self.associated_resource)

        if self.sop is not None and not isinstance(self.sop, str):
            self.sop = str(self.sop)

        super().__post_init__(**kwargs)


@dataclass
class Human-skinMIMS(Human-skin):
    """
    Combinatorial checklist Metagenome or Environmental with environmental package human-skin
    """
    _inherited_slots: ClassVar[List[str]] = []

    class_class_uri: ClassVar[URIRef] = MIXS.VOCAB["Human-skinMIMS"]
    class_class_curie: ClassVar[str] = "mixs.vocab:Human-skinMIMS"
    class_name: ClassVar[str] = "human-skin MIMS"
    class_model_uri: ClassVar[URIRef] = MIXS.VOCAB.Human-skinMIMS

    samp_name: str = None
    project_name: str = None
    samp_taxon_id: str = None
    seq_meth: str = None
    lat_lon: Optional[str] = None
    geo_loc_name: Optional[str] = None
    collection_date: Optional[Union[str, XSDDate]] = None
    env_broad_scale: Optional[str] = None
    env_local_scale: Optional[str] = None
    env_medium: Optional[str] = None
    experimental_factor: Optional[str] = None
    neg_cont_type: Optional[Union[str, "NegContTypeEnum"]] = None
    pos_cont_type: Optional[str] = None
    ref_biomaterial: Optional[str] = None
    source_mat_id: Optional[str] = None
    rel_to_oxygen: Optional[Union[str, "RelToOxygenEnum"]] = None
    samp_collec_device: Optional[str] = None
    samp_collec_method: Optional[str] = None
    samp_mat_process: Optional[str] = None
    size_frac: Optional[str] = None
    samp_size: Optional[Union[dic