PEP: 8101 Title: 2020 Term steering council election Version:
\$Revision\$ Last-Modified: \$Date\$ Author: Ewa Jodlowska
\<<ewa@python.org>\>, Ernest W. Durbin III \<<ewdurbin@gmail.com>\>
Sponsor: Brett Cannon \<<brett@python.org>\> Status: Active Type:
Informational Content-Type: text/x-rst Created: 16-Nov-2019

Abstract
========

This document describes the schedule and other details of the December
2019 election for the Python steering council, as specified in PEP 13.
This is steering council election for the 2020 term.

Election Administration
=======================

The steering council appointed the [Python Software
Foundation](https://www.python.org/psf-landing/) Director of
Infrastructure, Ernest W. Durbin III, to implement the election, and
[Python Software Foundation](https://www.python.org/psf-landing/)
Executive Director, Ewa Jodlowska, to communicate announcements
regarding the election.

Schedule
========

There will be a two-week nomination period, followed by a two-week vote.

The nomination period was: November 1, 2019 through November 16, 2019
12:00 UTC (The end of November 15, 2019 [Anywhere on
Earth](http://www.ieee802.org/16/aoe.html)). As announced on
[python-committers](https://mail.python.org/archives/list/python-committers@python.org/thread/4N6WEWVSE6JQ64KDFGQRWFG33MSHRMCK/),
and took place on
[discuss.python.org](https://discuss.python.org/t/about-the-steering-council-nominations-category/2459).

The voting period is: December 1, 2019 12:00 UTC through December 16,
2019 12:00 UTC (The end of December 15, 2019 [Anywhere on
Earth](http://www.ieee802.org/16/aoe.html)).

Candidates
==========

Candidates must be nominated by a core team member. If the candidate is
a core team member, they may nominate themselves.

Nominees (in alphabetical order):

-   [Brett
    Cannon](https://discuss.python.org/t/steering-council-nomination-brett-cannon-2020-term/2566)
-   [Kushal
    Das](https://discuss.python.org/t/steering-council-nomination-kushal-das-2020-term/2662)
-   [Christian
    Heimes](https://discuss.python.org/t/steering-council-nomination-christian-heimes-2020-term/2661)
-   [Pablo Galindo
    Salgado](https://discuss.python.org/t/steering-council-nomination-pablo-galindo-salgado-2020-term/2667)
-   [Gregory P.
    Smith](https://discuss.python.org/t/steering-council-nomination-gregory-p-smith-2020-term/2668)
-   [Victor
    Stinner](https://discuss.python.org/t/steering-council-nomination-victor-stinner-2020-term/2658)
-   [Barry
    Warsaw](https://discuss.python.org/t/steering-council-nomination-barry-warsaw-2020-term/2601)
-   [Carol
    Willing](https://discuss.python.org/t/steering-council-nomination-carol-willing-2020-term/2593)
-   [Thomas
    Wouters](https://discuss.python.org/t/steering-council-nomination-thomas-wouters-2020-term/2615)

Withdrawn nominations:

-   [Guido van
    Rossum](https://discuss.python.org/t/steering-council-nomination-guido-van-rossum-2020-term/2657).
    ([Withdrawal](https://discuss.python.org/t/steering-council-nomination-guido-van-rossum-2020-term/2657/11))

Voter Roll
==========

All active Python core team members are eligible to vote.

Ballots will be distributed based on the [The Python Voter Roll for this
election](https://github.com/python/voters/blob/master/voter-files/2019-12-01-2020-python-steering-council-election.csv)
[^1].

While this file is not public as it contains private email addresses,
the [Complete Voter Roll](#complete-voter-roll) by name is available.

Election Implementation
=======================

The election will be conducted using the [Helios Voting
Service](https://heliosvoting.org).

Configuration
-------------

Short name: `2020-python-steering-council`

Name: `2020 Python Steering Council Election`

Description:
`Election for the Python steering council, as specified in PEP 13. This is steering council election for the 2020 term.`

type: `Election`

Use voter aliases: `[X]`

Randomize answer order: `[X]`

Private: `[X]`

Help Email Address: `ernest@python.org`

Voting starts at: `December 1, 2019 12:00 UTC`

Voting ends at: `December 16, 2019 12:00 UTC`

This will create an election in which:

-   Voting is not open to the public, only those on the [Voter
    Roll](#voter-roll) may participate. Ballots will be emailed when
    voting starts.
-   Candidates are presented in random order, to help avoid bias.
-   Voter identities and ballots are protected against cryptographic
    advances.

Questions
---------

### Question 1

Select between `0` and `- (approval)` answers. Result Type: `absolute`

Question: `Select candidates for the Python Steering Council`

Answer \#1 - \#N: `Candidates from Candidates_ Section`

Results
=======

Of 82 eligible voters, 63 cast ballots.

The top five vote-getters are:

-   Barry Warsaw
-   Brett Cannon
-   Carol Willing
-   Thomas Wouters
-   Victor Stinner

No conflict of interest as defined in PEP 13 were observed.

The full vote counts are as follows:

  ----------------------------------------
  Candidate               Votes Received
  ----------------------- ----------------
  Brett Cannon            54

  Carol Willing           54

  Barry Warsaw            50

  Thomas Wouters          40

  Victor Stinner          38

  Christian Heimes        37

  Pablo Galindo Salgado   37

  Gregory P. Smith        32

  Kushal Das              30
  ----------------------------------------

Copyright
=========

This document has been placed in the public domain.

Complete Voter Roll
===================

Active Python core developers
-----------------------------

    Abhilash Raj
    Alex Gaynor
    Alex Martelli
    Alexander Belopolsky
    Andrew Kuchling
    Andrew Svetlov
    Antoine Pitrou
    Barry Warsaw
    Benjamin Peterson
    Berker Peksağ
    Brett Cannon
    Brian Curtin
    Brian Quinlan
    Carol Willing
    Cheryl Sabella
    Chris Withers
    Christian Heimes
    Christian Tismer
    Davin Potts
    Dino Viehland
    Donald Stufft
    Emily Morehouse
    Éric Araujo
    Eric Snow
    Eric V. Smith
    Ethan Furman
    Ezio Melotti
    Facundo Batista
    Fred Drake
    Giampaolo Rodolà
    Gregory P. Smith
    Guido van Rossum
    Inada Naoki
    Ivan Levkivskyi
    Jason R. Coombs
    Jeremy Kloth
    Jesús Cea
    Joannah Nanjekye
    Julien Palard
    Kurt B. Kaiser
    Kushal Das
    Larry Hastings
    Lisa Roach
    Łukasz Langa
    Marc-André Lemburg
    Mariatta
    Mark Dickinson
    Mark Shannon
    Matthias Klose
    Michael Foord
    Nathaniel J. Smith
    Ned Deily
    Neil Schemenauer
    Nick Coghlan
    Pablo Galindo
    Paul Ganssle
    Paul Moore
    Petr Viktorin
    R. David Murray
    Raymond Hettinger
    Robert Collins
    Ronald Oussoren
    Senthil Kumaran
    Serhiy Storchaka
    Skip Montanaro
    Stefan Behnel
    Stefan Krah
    Steve Dower
    Steven D'Aprano
    Stéphane Wirtel
    Tal Einat
    Terry Jan Reedy
    Thomas Wouters
    Tim Golden
    Tim Peters
    Victor Stinner
    Vinay Sajip
    Walter Dörwald
    Xavier de Gaye
    Xiang Zhang
    Yury Selivanov
    Zachary Ware

#### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:

[^1]: This repository is private and accessible only to Python Core
    Developers, administrators, and Python Software Foundation Staff as
    it contains personal email addresses.
