PEP: 3105 Title: Make print a function Version: $Revision$
Last-Modified: $Date$ Author: Georg Brandl <georg@python.org> Status:
Final Type: Standards Track Content-Type: text/x-rst Created:
19-Nov-2006 Python-Version: 3.0 Post-History:

Abstract
========

The title says it all -- this PEP proposes a new `print()` builtin that
replaces the `print` statement and suggests a specific signature for the
new function.

Rationale
=========

The `print` statement has long appeared on lists of dubious language
features that are to be removed in Python 3000, such as Guido's "Python
Regrets" presentation \[1\]\_. As such, the objective of this PEP is not
new, though it might become much disputed among Python developers.

The following arguments for a `print()` function are distilled from a
python-3000 message by Guido himself \[2\]\_:

-   `print` is the only application-level functionality that has a
    statement dedicated to it. Within Python's world, syntax is
    generally used as a last resort, when something *can't* be done
    without help from the compiler. Print doesn't qualify for such an
    exception.

-   At some point in application development one quite often feels the
    need to replace `print` output by something more sophisticated, like
    logging calls or calls into some other I/O library. With a `print()`
    function, this is a straightforward string replacement, today it is
    a mess adding all those parentheses and possibly converting
    `>>stream` style syntax.

-   Having special syntax for `print` puts up a much larger barrier for
    evolution, e.g. a hypothetical new `printf()` function is not too
    far fetched when it will coexist with a `print()` function.

-   There's no easy way to convert `print` statements into another call
    if one needs a different separator, not spaces, or none at all.
    Also, there's no easy way *at all* to conveniently print objects
    with some other separator than a space.

-   If `print()` is a function, it would be much easier to replace it
    within one module (just `def print(*args):...`) or even throughout a
    program (e.g. by putting a different function in
    `__builtin__.print`). As it is, one can do this by writing a class
    with a `write()` method and assigning that to `sys.stdout` -- that's
    not bad, but definitely a much larger conceptual leap, and it works
    at a different level than print.

Specification
=============

The signature for `print()`, taken from various mailings and recently
posted on the python-3000 list \[3\]\_ is::

    def print(*args, sep=' ', end='\n', file=None)

A call like::

    print(a, b, c, file=sys.stderr)

will be equivalent to today's::

    print >>sys.stderr, a, b, c

while the optional `sep` and `end` arguments specify what is printed
between and after the arguments, respectively.

The `softspace` feature (a semi-secret attribute on files currently used
to tell print whether to insert a space before the first item) will be
removed. Therefore, there will not be a direct translation for today's::

    print "a",
    print

which will not print a space between the `"a"` and the newline.

Backwards Compatibility
=======================

The changes proposed in this PEP will render most of today's `print`
statements invalid. Only those which incidentally feature parentheses
around all of their arguments will continue to be valid Python syntax in
version 3.0, and of those, only the ones printing a single parenthesized
value will continue to do the same thing. For example, in 2.x::

    >>> print ("Hello")
    Hello
    >>> print ("Hello", "world")
    ('Hello', 'world')

whereas in 3.0::

    >>> print ("Hello")
    Hello
    >>> print ("Hello", "world")
    Hello world

Luckily, as it is a statement in Python 2, `print` can be detected and
replaced reliably and non-ambiguously by an automated tool, so there
should be no major porting problems (provided someone writes the
mentioned tool).

Implementation
==============

The proposed changes were implemented in the Python 3000 branch in the
Subversion revisions 53685 to 53704. Most of the legacy code in the
library has been converted too, but it is an ongoing effort to catch
every print statement that may be left in the distribution.

References
==========

.. \[1\]
http://legacy.python.org/doc/essays/ppt/regrets/PythonRegrets.pdf

.. \[2\] Replacement for print in Python 3.0 (Guido van Rossum)
https://mail.python.org/pipermail/python-dev/2005-September/056154.html

.. \[3\] print() parameters in py3k (Guido van Rossum)
https://mail.python.org/pipermail/python-3000/2006-November/004485.html

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
