PEP: 3002 Title: Procedure for Backwards-Incompatible Changes Version:
$Revision$ Last-Modified: $Date$ Author: Steven Bethard
<steven.bethard@gmail.com> Status: Final Type: Process Content-Type:
text/x-rst Created: 27-Mar-2006 Post-History: 27-Mar-2006, 13-Apr-2006

Abstract
========

This PEP describes the procedure for changes to Python that are
backwards-incompatible between the Python 2.X series and Python 3000.
All such changes must be documented by an appropriate Python 3000 PEP
and must be accompanied by code that can identify when pieces of Python
2.X code may be problematic in Python 3000.

Rationale
=========

Python 3000 will introduce a number of backwards-incompatible changes to
Python, mainly to streamline the language and to remove some previous
design mistakes. But Python 3000 is not intended to be a new and
completely different language from the Python 2.X series, and it is
expected that much of the Python user community will make the transition
to Python 3000 when it becomes available.

To encourage this transition, it is crucial to provide a clear and
complete guide on how to upgrade Python 2.X code to Python 3000 code.
Thus, for any backwards-incompatible change, two things are required:

-   An official Python Enhancement Proposal (PEP)
-   Code that can identify pieces of Python 2.X code that may be
    problematic in Python 3000

Python Enhancement Proposals
============================

Every backwards-incompatible change must be accompanied by a PEP. This
PEP should follow the usual PEP guidelines and explain the purpose and
reasoning behind the backwards incompatible change. In addition to the
usual PEP sections, all PEPs proposing backwards-incompatible changes
must include an additional section: Compatibility Issues. This section
should describe what is backwards incompatible about the proposed change
to Python, and the major sorts of breakage to be expected.

While PEPs must still be evaluated on a case-by-case basis, a PEP may be
inappropriate for Python 3000 if its Compatibility Issues section
implies any of the following:

-   Most or all instances of a Python 2.X construct are incorrect in
    Python 3000, and most or all instances of the Python 3000 construct
    are incorrect in Python 2.X.

    So for example, changing the meaning of the for-loop else-clause
    from "executed when the loop was not broken out of" to "executed
    when the loop had zero iterations" would mean that all Python 2.X
    for-loop else-clauses would be broken, and there would be no way to
    use a for-loop else-clause in a Python-3000-appropriate manner. Thus
    a PEP for such an idea would likely be rejected.

-   Many instances of a Python 2.X construct are incorrect in Python
    3000 and the PEP fails to demonstrate real-world use-cases for the
    changes.

    Backwards incompatible changes are allowed in Python 3000, but not
    to excess. A PEP that proposes backwards-incompatible changes should
    provide good examples of code that visibly benefits from the
    changes.

PEP-writing is time-consuming, so when a number of
backwards-incompatible changes are closely related, they should be
proposed in the same PEP. Such PEPs will likely have longer
Compatibility Issues sections, however, since they must now describe the
sorts of breakage expected from *all* the proposed changes.

Identifying Problematic Code
============================

In addition to the PEP requirement, backwards incompatible changes to
Python must also be accompanied by code to issue warnings for pieces of
Python 2.X code that will behave differently in Python 3000. Such
warnings will be enabled in Python 2.X using a new command-line switch:
-3. All backwards incompatible changes should be accompanied by a patch
for Python 2.X that, when -3 is specified, issues warnings for each
construct that is being changed.

For example, if `dict.keys()` returns an iterator in Python 3000, the
patch to the Python 2.X branch should do something like:

    If -3 was specified, change ``dict.keys()`` to return a
    subclass of ``list`` that issues warnings whenever you use any
    methods other than ``__iter__()``.

Such a patch would mean that warnings are only issued when features that
will not be present in Python 3000 are used, and almost all existing
code should continue to work. (Code that relies on `dict.keys()` always
returning a `list` and not a subclass should be pretty much
non-existent.)

References
==========

TBD

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
