PEP: 3000 Title: Python 3000 Version: $Revision$ Last-Modified: $Date$
Author: Guido van Rossum <guido@python.org> Status: Final Type: Process
Content-Type: text/x-rst Created: 05-Apr-2006 Post-History:

Abstract
========

This PEP sets guidelines for Python 3000 development. Ideally, we first
agree on the process, and start discussing features only after the
process has been decided and specified. In practice, we'll be discussing
features and process simultaneously; often the debate about a particular
feature will prompt a process discussion.

Naming
======

Python 3000, Python 3.0 and Py3K are all names for the same thing. The
project is called Python 3000, or abbreviated to Py3k. The actual Python
release will be referred to as Python 3.0, and that's what "python3.0
-V" will print; the actual file names will use the same naming
convention we use for Python 2.x. I don't want to pick a new name for
the executable or change the suffix for Python source files.

PEP Numbering
=============

Python 3000 PEPs are numbered starting at PEP 3000. PEPs 3000-3099 are
meta-PEPs -- these can be either process or informational PEPs. PEPs
3100-3999 are feature PEPs. PEP 3000 itself (this PEP) is special; it is
the meta-PEP for Python 3000 meta-PEPs (IOW it describe the process to
define processes). PEP 3100 is also special; it's a laundry list of
features that were selected for (hopeful) inclusion in Python 3000
before we started the Python 3000 process for real. PEP 3099, finally,
is a list of features that will *not* change.

Timeline
========

See PEP 361 \[\#pep361\]\_, which contains the release schedule for
Python 2.6 and 3.0. These versions will be released in lockstep.

Note: standard library development is expected to ramp up after 3.0a1 is
released.

I expect that there will be parallel Python 2.x and 3.x releases for
some time; the Python 2.x releases will continue for a longer time than
the traditional 2.x.y bugfix releases. Typically, we stop releasing
bugfix versions for 2.x once version 2.(x+1) has been released. But I
expect there to be at least one or two new 2.x releases even after 3.0
(final) has been released, probably well into 3.1 or 3.2. This will to
some extent depend on community demand for continued 2.x support,
acceptance and stability of 3.0, and volunteer stamina.

I expect that Python 3.1 and 3.2 will be released much sooner after 3.0
than has been customary for the 2.x series. The 3.x release pattern will
stabilize once the community is happy with 3.x.

Compatibility and Transition
============================

Python 3.0 will break backwards compatibility with Python 2.x.

**There is no requirement that Python 2.6 code will run unmodified on
Python 3.0.** Not even a subset. (Of course there will be a *tiny*
subset, but it will be missing major functionality.)

Python 2.6 will support forward compatibility in the following two ways:

-   It will support a "Py3k warnings mode" which will warn dynamically
    (i.e. at runtime) about features that will stop working in Python
    3.0, e.g. assuming that range() returns a list.
-   It will contain backported versions of many Py3k features, either
    enabled through **future** statements or simply by allowing old and
    new syntax to be used side-by-side (if the new syntax would be a
    syntax error in 2.x).

Instead, and complementary to the forward compatibility features in 2.6,
there will be a separate source code conversion tool \[1\]\_. This tool
can do a context-free source-to-source translation. For example, it can
translate `apply(f, args)` into `f(*args)`. However, the tool cannot do
data flow analysis or type inferencing, so it simply assumes that
`apply` in this example refers to the old built-in function.

The recommended development model for a project that needs to support
Python 2.6 and 3.0 simultaneously is as follows:

0.  You should have excellent unit tests with close to full coverage.
1.  Port your project to Python 2.6.
2.  Turn on the Py3k warnings mode.
3.  Test and edit until no warnings remain.
4.  Use the 2to3 tool to convert this source code to 3.0 syntax. **Do
    not manually edit the output!**
5.  Test the converted source code under 3.0.
6.  If problems are found, make corrections to the **2.6** version of
    the source code and go back to step 3.
7.  When it's time to release, release separate 2.6 and 3.0 tarballs (or
    whatever archive form you use for releases).

It is recommended not to edit the 3.0 source code until you are ready to
reduce 2.6 support to pure maintenance (i.e. the moment when you would
normally move the 2.6 code to a maintenance branch anyway).

PS. We need a meta-PEP to describe the transitional issues in detail.

Implementation Language
=======================

Python 3000 will be implemented in C, and the implementation will be
derived as an evolution of the Python 2 code base. This reflects my
views (which I share with Joel Spolsky \[2\]\_) on the dangers of
complete rewrites. Since Python 3000 as a language is a relatively mild
improvement on Python 2, we can gain a lot by not attempting to
reimplement the language from scratch. I am not against parallel
from-scratch implementation efforts, but my own efforts will be directed
at the language and implementation that I know best.

Meta-Contributions
==================

Suggestions for additional text for this PEP are gracefully accepted by
the author. Draft meta-PEPs for the topics above and additional topics
are even more welcome!

References
==========

.. \[1\] The 2to3 tool, in the subversion sandbox
http://svn.python.org/view/sandbox/trunk/2to3/

.. \[2\] Joel on Software: Things You Should Never Do, Part I
http://www.joelonsoftware.com/articles/fog0000000069.html

.. \[\#pep361\] PEP 361 (Python 2.6 and 3.0 Release Schedule)
http://www.python.org/dev/peps/pep-0361

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
