PEP: 666 Title: Reject Foolish Indentation Version: $Revision$
Last-Modified: $Date$ Author: lac\@strakt.com (Laura Creighton) Status:
Rejected Type: Standards Track Content-Type: text/x-rst Created:
3-Dec-2001 Python-Version: 2.2 Post-History: 5-Dec-2001

Abstract
========

Everybody agrees that mixing tabs and spaces is a bad idea. Some people
want more than this. I propose that we let people define whatever Python
behaviour they want, so it will only run the way they like it, and will
not run the way they don't like it. We will do this with a command line
switch. Programs that aren't formatted the way the programmer wants
things will raise `IndentationError`.

-   `python -TNone` will refuse to run when there are any tabs.
-   `python -Tn` will refuse to run when tabs are not exactly `n` spaces
-   `python -TOnly` will refuse to run when blocks are indented by
    anything other than tabs

People who mix tabs and spaces, naturally, will find that their programs
do not run. Alas, we haven't found a way to give them an electric shock
as from a cattle prod remotely. (Though if somebody finds out a way to
do this, I will be pleased to add this option to the PEP.)

Rationale
=========

Python-list\@python.org (a.k.a. comp.lang.python) is periodically awash
with discussions about tabs and spaces. This is inevitable, given that
indentation is syntactically significant in Python. This has never
solved anything, and just makes various people frustrated and angry.
Eventually they start saying rude things to each other which is sad for
all of us. And it is also sad that they are wasting their valuable time
which they could spend creating something with Python. Moreover, for the
Python community as a whole, from a public relations point of view, this
is quite unfortunate. The people who aren't posting about tabs and
spaces, are, (unsurprisingly) invisible, while the people who are
posting make the rest of us look somewhat foolish.

The problem is that there is no polite way to say 'Stop wasting your
valuable time and mine.' People who are already in the middle of a flame
war are not well disposed to believe that you are acting out of
compassion for them, and quite rightly insist that their own time is
their own to do with as they please. They are stuck like flies in
treacle in this wretched argument, and it is self-evident that they
cannot disengage or they would have already done so.

But today I had to spend time cleaning my keyboard because the 'n' key
is sticking. So, in addition to feeling compassion for these people, I
am pretty annoyed. I figure if I make this PEP, we can then ask Guido to
quickly reject it, and then when this argument next starts up again, we
can say 'Guido isn't changing things to suit the tab-haters or the
only-tabbers, so this conversation is a waste of time.' Then everybody
can quietly believe that a) they are correct and b) other people are
fools and c) they are undeniably fortunate to not have to share a lab
with idiots, (which is something the arguers could do *now*, but
apparently have forgotten).

And python-list can go back to worrying if it is too smug, rather than
whether it is too hostile for newcomers. Possibly somebody could get
around to explaining to me what is the difference between `__getattr__`
and `__getattribute__` in non-Classic classes in 2.2, a question I have
foolishly posted in the middle of the current tab thread. I would like
to know the answer to that question \[2\]\_.

This proposal, if accepted, will probably mean a heck of a lot of work
for somebody. But since I don't want it accepted, I don't care.

References
==========

.. \[1\] PEP 1, PEP Purpose and Guidelines
http://www.python.org/dev/peps/pep-0001/

.. \[2\] Tim Peters already has (private correspondence). My early 2.2
didn't have a `__getattribute__`, and `__getattr__` was implemented like
`__getattribute__` now is. This has been fixed. The important conclusion
is that my Decorator Pattern is safe and all is right with the world.

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
fill-column: 70 End:
