PEP: 494 Title: Python 3.6 Release Schedule Version: $Revision$
Last-Modified: $Date$ Author: Ned Deily <nad@python.org> Status: Active
Type: Informational Content-Type: text/x-rst Created: 30-May-2015
Python-Version: 3.6

Abstract
========

This document describes the development and release schedule for Python
3.6. The schedule primarily concerns itself with PEP-sized items.

.. Small features may be added up to the first beta release. Bugs may be
fixed until the final release, which is planned for December 2016.

Release Manager and Crew
========================

-   3.6 Release Manager: Ned Deily
-   Windows installers: Steve Dower
-   Mac installers: Ned Deily
-   Documentation: Julien Palard, Georg Brandl

3.6 Lifespan
============

3.6 will receive
`bugfix updates <https://devguide.python.org/devcycle/#maintenance-branches>`*
approximately every 3 months for about 24 months. Sometime after the
release of 3.7.0 final, a final 3.6 bugfix update will be released.
After that, it is expected that
`security updates <https://devguide.python.org/devcycle/#security-branches>`*
(source only) will be released as needed until 5 years after the release
of 3.6 final, so until approximately 2021-12.

Release Schedule
================

3.6.0 schedule
--------------

-   3.6 development begins: 2015-05-24
-   3.6.0 alpha 1: 2016-05-17
-   3.6.0 alpha 2: 2016-06-13
-   3.6.0 alpha 3: 2016-07-11
-   3.6.0 alpha 4: 2016-08-15
-   3.6.0 beta 1: 2016-09-12 (No new features beyond this point.)
-   3.6.0 beta 2: 2016-10-10
-   3.6.0 beta 3: 2016-10-31
-   3.6.0 beta 4: 2016-11-21
-   3.6.0 candidate 1: 2016-12-06
-   3.6.0 candidate 2: 2016-12-16
-   3.6.0 final: 2016-12-23

3.6.1 schedule (first bugfix release)
-------------------------------------

-   3.6.1 candidate: 2017-03-05
-   3.6.1 final: 2017-03-21

3.6.2 schedule
--------------

-   3.6.2 candidate 1: 2017-06-17
-   3.6.2 candidate 2: 2017-07-07
-   3.6.2 final: 2017-07-17

3.6.3 schedule
--------------

-   3.6.3 candidate: 2017-09-19
-   3.6.3 final: 2017-10-03

3.6.4 schedule
--------------

-   3.6.4 candidate: 2017-12-05
-   3.6.4 final: 2017-12-19

3.6.5 schedule
--------------

-   3.6.5 candidate: 2018-03-13
-   3.6.5 final: 2018-03-28

3.6.6 schedule
--------------

-   3.6.6 candidate: 2018-06-12
-   3.6.6 final: 2018-06-27

3.6.7 schedule
--------------

-   3.6.7 candidate: 2018-09-26
-   3.6.7 candidate 2: 2018-10-13
-   3.6.7 final: 2018-10-20

3.6.8 schedule (last bugfix release)
------------------------------------

Last binary releases

-   3.6.8 candidate: 2018-12-11
-   3.6.8 final: 2018-12-24

3.6.9 schedule (first security-only release)
--------------------------------------------

Source only

-   3.6.9 candidate 1: 2019-06-18
-   3.6.9 final: 2019-07-02

3.6.10 schedule
---------------

-   3.6.10 candidate 1: 2019-12-11
-   3.6.10 final: 2019-12-18

3.6.11 schedule
---------------

-   3.6.11 candidate 1: 2020-06-15
-   3.6.11 final: 2020-06-27

3.6.12 schedule
---------------

-   3.6.12 final: 2020-08-17

3.6.13 and beyond schedule
--------------------------

Security fixes only, as needed, until 2021-12

-   TBD

Features for 3.6
================

Implemented changes for 3.6 (as of 3.6.0 beta 1):

-   :pep:`468`, Preserving Keyword Argument Order
-   :pep:`487`, Simpler customization of class creation
-   :pep:`495`, Local Time Disambiguation
-   :pep:`498`, Literal String Formatting
-   :pep:`506`, Adding A Secrets Module To The Standard Library
-   :pep:`509`, Add a private version to dict
-   :pep:`515`, Underscores in Numeric Literals
-   :pep:`519`, Adding a file system path protocol
-   :pep:`520`, Preserving Class Attribute Definition Order
-   :pep:`523`, Adding a frame evaluation API to CPython
-   :pep:`524`, Make os.urandom() blocking on Linux (during system
    startup)
-   :pep:`525`, Asynchronous Generators (provisional)
-   :pep:`526`, Syntax for Variable Annotations (provisional)
-   :pep:`528`, Change Windows console encoding to UTF-8 (provisional)
-   :pep:`529`, Change Windows filesystem encoding to UTF-8
    (provisional)
-   :pep:`530`, Asynchronous Comprehensions

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
