PEP: 430 Title: Migrating to Python 3 as the default online
documentation Version: $Revision$ Last-Modified: $Date$ Author: Nick
Coghlan <ncoghlan@gmail.com> BDFL-Delegate: Georg Brandl Status: Final
Type: Informational Content-Type: text/x-rst Created: 27-Oct-2012

Abstract
========

This PEP proposes a strategy for migrating the default version of the
Python documentation presented to users of Python when accessing
docs.python.org from 2.7 to Python 3.3.

It proposes a backwards compatible scheme that preserves the meaning of
existing deep links in to the Python 2 documentation, while still
presenting the Python 3 documentation by default, and presenting the
Python 2 and 3 documentation in a way that avoids making the Python 3
documentation look like a second-class citizen.

Background
==========

With the transition of the overall Python ecosystem from Python 2 to
Python 3 still in progress, one question which arises periodically
\[1\_, 2\_\] is when and how to handle the change from providing the
Python 2 documentation as the default version displayed at the
docs.python.org root URL to providing the Python 3 documentation.

Key Concerns
============

There are a couple of key concerns that any migration proposal needs to
address.

Don't Confuse Beginners
-----------------------

Many beginners learn Python through third party resources. These
resources, not all of which are online resources, may reference in to
the python.org online documentation for additional background and
details.

Importantly, even when the online documentation is updated, the "version
added" and "version changed" tags usually provide enough information for
users to adjust appropriately for the specific version they are using.

While deep links in to the python.org documentation may occasionally
break within the Python 2 series, this is very rare.

Migrating to Python 3 is a very different matter. Many links would break
due to renames and removals, and the "version added" and "version
changed" information for the Python 2 series is completely absent.

Don't Break Useful Resources
----------------------------

There are many useful Python resources out there, such as the mailing
list archives on python.org and question-and-answer sites like Stack
Overflow, where links are highly unlikely to be updated, no matter how
much notice is provided.

Old posts and answers to questions all currently link to docs.python.org
expecting to get the Python 2 documentation at unqualified URLs. Links
from answers that relate to Python 3 are explicitly qualified with
`/py3k/` in the path component.

Proposal
========

This PEP (based on an idea originally put forward back in May \[3\_\])
is to *not migrate* the Python 2 specific deep links at all, and instead
adopt a scheme where all URLs presented to users on docs.python.org are
qualified appropriately with the relevant release series.

Visitors to the root URL at `http://docs.python.org` will be
automatically redirected to `http://docs.python.org/3/`, but links
deeper in the version-specific hierarchy, such as to
`http://docs.python.org/library/os`, will instead be redirected to a
Python 2 specific link such as `http://docs.python.org/2/library/os`.

The specific subpaths which will be redirected to explicitly qualified
paths for the Python 2 docs are:

-   `/c-api/`
-   `/distutils/`
-   `/extending/`
-   `/faq/`
-   `/howto/`
-   `/library/`
-   `/reference/`
-   `/tutorial/`
-   `/using/`
-   `/whatsnew/`
-   `/about.html`
-   `/bugs.html`
-   `/contents.html`
-   `/copyright.html`
-   `/license.html`
-   `/genindex.html`
-   `/glossary.html`
-   `/py-modindex.html`
-   `/search.html`

The existing `/py3k/` subpath will be redirected to the new `/3/`
subpath.

Presented URLs
--------------

With this scheme, the following URLs would be presented to users after
resolution of any aliasing and rewriting rules:

-   `http://docs.python.org/x/*`
-   `http://docs.python.org/x.y/*`
-   `http://docs.python.org/dev/*`
-   `http://docs.python.org/release/x.y.z/*`
-   `http://docs.python.org/devguide`

The `/x/` URLs mean "give me the latest documentation for a released
version in this release series". It will draw the documentation from the
relevant maintenance branch in source control (this will always be the
2.7 branch for Python 2 and is currently 3.3 for Python 3). Differences
relative to previous versions in the release series will be available
through "version added" and "version changed" markers.

The `/x.y/` URLs mean "give me the latest documentation for this
release". It will draw the documentation from the relevant maintenance
branch in source control (or the default branch for the currently in
development version). It differs from the status quo in that the URLs
will actually remain available in the user's browser for easy copy and
pasting. (Currently, references to specific versions that are not the
latest in their release series will resolve to a stable URL for a
specific maintenance version in the "release" hierarchy, while the
current latest version in the release series resolves to the release
series URL. This makes it hard to get a "latest version specific URL",
since it is always necessary to construct them manually).

The `/dev/` URL means the documentation for the default branch in source
control.

The `/release/x.y.x/` URLs will refer to the documentation of those
releases, exactly as it was at the time of the release.

The developer's guide is not version specific, and thus retains its own
stable `/devguide/` URL.

Rationale
=========

There is some desire to switch the unqualified references to mean Python
3 as a sign of confidence in Python 3. Such a move would either break a
lot of things, or else involve an awful lot of work to *avoid* breaking
things.

I believe we can get much the same effect without breaking the world by:

1.  Deprecating the use of unqualified references to the online
    documentation (while promising to preserve the meaning of such
    references indefinitely)
2.  Updating all python.org and python-dev controlled links to use
    qualified references (excluding archived email)
3.  Redirecting visitors to the root of `http://docs.python.org` to
    `http://docs.python.org/3.x`

Most importantly, because this scheme doesn't alter the behaviour of any
existing deep links, it could be implemented with a significantly
shorter warning period than would be required for a scheme that risked
breaking deep links, or started to redirect unqualified links to Python
3. The only part of the scheme which would require any warning at all is
the step of redirecting the "http://docs.python.org/" landing page to
the Python 3.3 documentation.

Namespaces are one honking great idea - let's do more of those.

Note that the approach described in this PEP gives two ways to access
the content of the default branch: as `/dev/` or using the appropriate
`/x.y/` reference. This is deliberate, as the default branch is
referenced for two different purposes:

-   to provide additional information when discussing an upcoming
    feature of the next release (a `/x.y/` URL is appropriate)
-   to provide a stable destination for developers to access the
    documentation of the next feature release, regardless of the version
    (a `/dev/` URL is appropriate)

Implementation
==============

The URLs on docs.python.org are controlled by the python.org
infrastructure team rather than through the CPython source repo, so
acceptance and implementation of the ideas in this PEP will be up to the
team.

References
==========

.. \[1\] May 2012 discussion
(https://mail.python.org/pipermail/python-dev/2012-May/119524.html)

.. \[2\] October 2012 discussion
(https://mail.python.org/pipermail/python-ideas/2012-October/017406.html)

.. \[3\] Using a "/latest/" path prefix
(https://mail.python.org/pipermail/python-dev/2012-May/119567.html)

Copyright
=========

This document has been placed in the public domain.
