PEP: 345 Title: Metadata for Python Software Packages 1.2 Version:
$Revision$ Last-Modified: $Date$ Author: Richard Jones
<richard@python.org> Discussions-To: Distutils SIG Status: Final Type:
Standards Track Content-Type: text/x-rst Created: 28-Apr-2005
Python-Version: 2.5 Post-History:

Abstract
========

This PEP describes a mechanism for adding metadata to Python
distributions. It includes specifics of the field names, and their
semantics and usage.

This document specifies version 1.2 of the metadata format. Version 1.0
is specified in PEP 241. Version 1.1 is specified in PEP 314.

Version 1.2 of the metadata format adds a number of optional fields
designed to make third-party packaging of Python Software easier. These
fields are "Requires-Python", "Requires-External", "Requires-Dist",
"Provides-Dist", and "Obsoletes-Dist". This version also changes the
"Platform" field. Three new fields were also added: "Maintainer",
"Maintainer-email" and "Project-URL".

Last, this new version also adds `environment markers`.

Fields
======

This section specifies the names and semantics of each of the supported
metadata fields.

Fields marked with "(Multiple use)" may be specified multiple times in a
single PKG-INFO file. Other fields may only occur once in a PKG-INFO
file. Fields marked with "(optional)" are not required to appear in a
valid PKG-INFO file; all other fields must be present.

Metadata-Version ::::::::::::::::

Version of the file format; "1.2" is the only legal value.

Example::

    Metadata-Version: 1.2

Name ::::

The name of the distributions.

Example::

    Name: BeagleVote

Version :::::::

A string containing the distribution's version number. This field must
be in the format specified in PEP 440.

Example::

    Version: 1.0a2

Platform (multiple use) :::::::::::::::::::::::

A Platform specification describing an operating system supported by the
distribution which is not listed in the "Operating System" Trove
classifiers. See "Classifier" below.

Examples::

    Platform: ObscureUnix
    Platform: RareDOS

Supported-Platform (multiple use) :::::::::::::::::::::::::::::::::

Binary distributions containing a PKG-INFO file will use the
Supported-Platform field in their metadata to specify the OS and CPU for
which the binary distribution was compiled. The semantics of the
Supported-Platform field are not specified in this PEP.

Example::

    Supported-Platform: RedHat 7.2
    Supported-Platform: i386-win32-2791

Summary :::::::

A one-line summary of what the distribution does.

Example::

    Summary: A module for collecting votes from beagles.

Description (optional) ::::::::::::::::::::::

A longer description of the distribution that can run to several
paragraphs. Software that deals with metadata should not assume any
maximum size for this field, though people shouldn't include their
instruction manual as the description.

The contents of this field can be written using reStructuredText markup
\[1\]\_. For programs that work with the metadata, supporting markup is
optional; programs can also display the contents of the field as-is.
This means that authors should be conservative in the markup they use.

To support empty lines and lines with indentation with respect to the
RFC 822 format, any CRLF character has to be suffixed by 7 spaces
followed by a pipe ("\|") char. As a result, the Description field is
encoded into a folded field that can be interpreted by RFC822 parser
\[2\]\_.

Example::

    Description: This project provides powerful math functions
            |For example, you can use `sum()` to sum numbers:
            |
            |Example::
            |
            |    >>> sum(1, 2)
            |    3
            |

This encoding implies that any occurrences of a CRLF followed by 7
spaces and a pipe char have to be replaced by a single CRLF when the
field is unfolded using a RFC822 reader.

Keywords (optional) :::::::::::::::::::

A list of additional keywords to be used to assist searching for the
distribution in a larger catalog.

Example::

    Keywords: dog puppy voting election

Home-page (optional) ::::::::::::::::::::

A string containing the URL for the distribution's home page.

Example::

    Home-page: http://www.example.com/~cschultz/bvote/

Download-URL ::::::::::::

A string containing the URL from which this version of the distribution
can be downloaded. (This means that the URL can't be something like
".../BeagleVote-latest.tgz", but instead must be
".../BeagleVote-0.45.tgz".)

Author (optional) :::::::::::::::::

A string containing the author's name at a minimum; additional contact
information may be provided.

Example::

    Author: C. Schultz, Universal Features Syndicate,
            Los Angeles, CA <cschultz@peanuts.example.com>

Author-email (optional) :::::::::::::::::::::::

A string containing the author's e-mail address. It can contain a name
and e-mail address in the legal forms for a RFC-822 `From:` header.

Example::

    Author-email: "C. Schultz" <cschultz@example.com>

Maintainer (optional) :::::::::::::::::::::

A string containing the maintainer's name at a minimum; additional
contact information may be provided.

Note that this field is intended for use when a project is being
maintained by someone other than the original author: it should be
omitted if it is identical to `Author`.

Example::

    Maintainer: C. Schultz, Universal Features Syndicate,
            Los Angeles, CA <cschultz@peanuts.example.com>

Maintainer-email (optional) :::::::::::::::::::::::::::

A string containing the maintainer's e-mail address. It can contain a
name and e-mail address in the legal forms for a RFC-822 `From:` header.

Note that this field is intended for use when a project is being
maintained by someone other than the original author: it should be
omitted if it is identical to `Author-email`.

Example::

    Maintainer-email: "C. Schultz" <cschultz@example.com>

License (optional) ::::::::::::::::::

Text indicating the license covering the distribution where the license
is not a selection from the "License" Trove classifiers. See
"Classifier" below. This field may also be used to specify a particular
version of a license which is named via the `Classifier` field, or to
indicate a variation or exception to such a license.

Examples::

    License: This software may only be obtained by sending the
            author a postcard, and then the user promises not
            to redistribute it.

    License: GPL version 3, excluding DRM provisions

Classifier (multiple use) :::::::::::::::::::::::::

Each entry is a string giving a single classification value for the
distribution. Classifiers are described in PEP 301 \[3\]\_.

Examples::

    Classifier: Development Status :: 4 - Beta
    Classifier: Environment :: Console (Text Based)

Requires-Dist (multiple use) ::::::::::::::::::::::::::::

Each entry contains a string naming some other distutils project
required by this distribution.

The format of a requirement string is identical to that of a distutils
project name (e.g., as found in the `Name:` field. optionally followed
by a version declaration within parentheses.

The distutils project names should correspond to names as found on the
`Python Package Index`\_.

Version declarations must follow the rules described in
`Version Specifiers`\_

Examples::

    Requires-Dist: pkginfo
    Requires-Dist: PasteDeploy
    Requires-Dist: zope.interface (>3.5.0)

Provides-Dist (multiple use) ::::::::::::::::::::::::::::

Each entry contains a string naming a Distutils project which is
contained within this distribution. This field *must* include the
project identified in the `Name` field, followed by the version : Name
(Version).

A distribution may provide additional names, e.g. to indicate that
multiple projects have been bundled together. For instance, source
distributions of the `ZODB` project have historically included the
`transaction` project, which is now available as a separate
distribution. Installing such a source distribution satisfies
requirements for both `ZODB` and `transaction`.

A distribution may also provide a "virtual" project name, which does not
correspond to any separately-distributed project: such a name might be
used to indicate an abstract capability which could be supplied by one
of multiple projects. E.g., multiple projects might supply RDBMS
bindings for use by a given ORM: each project might declare that it
provides `ORM-bindings`, allowing other projects to depend only on
having at most one of them installed.

A version declaration may be supplied and must follow the rules
described in `Version Specifiers`\_. The distribution's version number
will be implied if none is specified.

Examples::

    Provides-Dist: OtherProject
    Provides-Dist: AnotherProject (3.4)
    Provides-Dist: virtual_package

Obsoletes-Dist (multiple use) :::::::::::::::::::::::::::::

Each entry contains a string describing a distutils project's
distribution which this distribution renders obsolete, meaning that the
two projects should not be installed at the same time.

Version declarations can be supplied. Version numbers must be in the
format specified in `Version Specifiers`\_.

The most common use of this field will be in case a project name
changes, e.g. Gorgon 2.3 gets subsumed into Torqued Python 1.0. When you
install Torqued Python, the Gorgon distribution should be removed.

Examples::

    Obsoletes-Dist: Gorgon
    Obsoletes-Dist: OtherProject (<3.0)

Requires-Python :::::::::::::::

This field specifies the Python version(s) that the distribution is
guaranteed to be compatible with.

Version numbers must be in the format specified in
`Version Specifiers`\_.

Examples::

    Requires-Python: 2.5
    Requires-Python: >2.1
    Requires-Python: >=2.3.4
    Requires-Python: >=2.5,<2.7

Requires-External (multiple use) ::::::::::::::::::::::::::::::::

Each entry contains a string describing some dependency in the system
that the distribution is to be used. This field is intended to serve as
a hint to downstream project maintainers, and has no semantics which are
meaningful to the `distutils` distribution.

The format of a requirement string is a name of an external dependency,
optionally followed by a version declaration within parentheses.

Because they refer to non-Python software releases, version numbers for
this field are **not** required to conform to the format specified in
PEP 440: they should correspond to the version scheme used by the
external dependency.

Notice that there's is no particular rule on the strings to be used.

Examples::

    Requires-External: C
    Requires-External: libpng (>=1.5)

Project-URL (multiple-use) ::::::::::::::::::::::::::

A string containing an extra URL for the project and a label for it,
separated by a comma. This should be used when there are other URLs to
list in the metadata in addition to the "Home-page" field.

Examples::

    Project-URL: Bug Tracker, https://github.com/pypa/setuptools/issues
    Project-URL: Documentation, https://setuptools.readthedocs.io/
    Project-URL: Funding, https://donate.pypi.org

The label is free text, with a maximum length of 32 characters. Notice
that distributions uploaded to PyPI will have these extra entries
displayed under the "Project links" section of their landing page.

Version Specifiers
==================

Version specifiers are a series of conditional operators and version
numbers, separated by commas. Conditional operators must be one of "\<",
"\>", "\<=", "\>=", "==" and "!=".

Any number of conditional operators can be specified, e.g. the string
"\>1.0, !=1.3.4, \<2.0" is a legal version declaration. The comma (",")
is equivalent to the **and** operator.

Each version number must be in the format specified in PEP 440.

When a version is provided, it always includes all versions that starts
with the same value. For example, the "2.5" version of Python will
include versions like "2.5.2" or "2.5.3". Pre and post releases in that
case are excluded. So in our example, versions like "2.5a1" are not
included when "2.5" is used. If the first version of the range is
required, it has to be explicitly given. In our example, it will be
"2.5.0".

Notice that some projects might omit the ".0" suffix for the first
release of the "2.5.x" series:

-   2.5
-   2.5.1
-   2.5.2
-   etc.

In that case, "2.5.0" will have to be explicitly used to avoid any
confusion between the "2.5" notation that represents the full range. It
is a recommended practice to use schemes of the same length for a series
to completely avoid this problem.

Some Examples:

-   `Requires-Dist: zope.interface (3.1)`: any version that starts with
    3.1, excluding post or pre-releases.
-   `Requires-Dist: zope.interface (3.1.0)`: any version that starts
    with 3.1.0, excluding post or pre-releases. Since that particular
    project doesn't use more than 3 digits, it also means "only the
    3.1.0 release".
-   `Requires-Python: 3`: Any Python 3 version, no matter which one,
    excluding post or pre-releases.
-   `Requires-Python: >=2.6,<3`: Any version of Python 2.6 or 2.7,
    including post releases of 2.6, pre and post releases of 2.7. It
    excludes pre releases of Python 3.
-   `Requires-Python: 2.6.2`: Equivalent to "\>=2.6.2,\<2.6.3". So this
    includes only Python 2.6.2. Of course, if Python was numbered with 4
    digits, it would have include all versions of the 2.6.2 series.
-   `Requires-Python: 2.5.0`: Equivalent to "\>=2.5.0,\<2.5.1".
-   `Requires-Dist: zope.interface (3.1,!=3.1.3)`: any version that
    starts with 3.1, excluding post or pre-releases of 3.1 *and*
    excluding any version that starts with "3.1.3". For this particular
    project, this means: "any version of the 3.1 series but not 3.1.3".
    This is equivalent to: "\>=3.1,!=3.1.3,\<3.2".

Environment markers
===================

An **environment marker** is a marker that can be added at the end of a
field after a semi-colon (";"), to add a condition about the execution
environment.

Here are some example of fields using such markers::

Requires-Dist: pywin32 (\>1.0); sys.platform == 'win32' Obsoletes-Dist:
pywin31; sys.platform == 'win32' Requires-Dist: foo (1,!=1.3);
platform.machine == 'i386' Requires-Dist: bar; python\_version == '2.4'
or python\_version == '2.5' Requires-External: libxslt; 'linux' in
sys.platform

The micro-language behind this is the simplest possible: it compares
only strings, with the `==` and `in` operators (and their opposites),
and with the ability to combine expressions. It makes it also easy to
understand to non-pythoneers.

The pseudo-grammar is ::

    EXPR [in|==|!=|not in] EXPR [or|and] ...

where `EXPR` belongs to any of those:

-   python\_version = '%s.%s' % (sys.version\_info\[0\],
    sys.version\_info\[1\])
-   python\_full\_version = sys.version.split()\[0\]
-   os.name = os.name
-   sys.platform = sys.platform
-   platform.version = platform.version()
-   platform.machine = platform.machine()
-   platform.python\_implementation = platform.python\_implementation()
-   a free string, like `'2.4'`, or `'win32'`

Notice that `in` is restricted to strings, meaning that it is not
possible to use other sequences like tuples or lists on the right side.

The fields that benefit from this marker are:

-   Requires-External
-   Requires-Dist
-   Provides-Dist
-   Obsoletes-Dist
-   Classifier

Summary of Differences From PEP 314
===================================

-   Metadata-Version is now 1.2.

-   Added the environment markers.

-   Changed fields:

    -   Platform (syntax change)
    -   Author-email (change to optional field)

-   Added fields:

    -   Maintainer
    -   Maintainer-email
    -   Requires-Python
    -   Requires-External
    -   Requires-Dist
    -   Provides-Dist
    -   Obsoletes-Dist
    -   Project-URL

-   Deprecated fields:

    -   Requires (in favor of Requires-Dist)
    -   Provides (in favor of Provides-Dist)
    -   Obsoletes (in favor of Obsoletes-Dist)

References
==========

This document specifies version 1.2 of the metadata format. Version 1.0
is specified in PEP 241. Version 1.1 is specified in PEP 314.

.. \[1\] reStructuredText markup: http://docutils.sourceforge.net/

.. \_`Python Package Index`: http://pypi.python.org/pypi/

.. \[2\] RFC 822 Long Header Fields:
http://www.freesoft.org/CIE/RFC/822/7.htm

.. \[3\] PEP 301, Package Index and Metadata for Distutils:
http://www.python.org/dev/peps/pep-0301/

Copyright
=========

This document has been placed in the public domain.

Acknowledgements
================

Fred Drake, Anthony Baxter and Matthias Klose have all contributed to
the ideas presented in this PEP.

Tres Seaver, Jim Fulton, Marc-André Lemburg, Martin von Löwis, Tarek
Ziadé, David Lyon and other people at the Distutils-SIG have contributed
to the new updated version.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 End:
