PEP: 320 Title: Python 2.4 Release Schedule Version: $Revision$
Last-Modified: $Date$ Author: Barry Warsaw, Raymond Hettinger, Anthony
Baxter Status: Final Type: Informational Content-Type: text/x-rst
Created: 29-Jul-2003 Python-Version: 2.4 Post-History: 1-Dec-2004

Abstract
========

This document describes the development and release schedule for Python
2.4. The schedule primarily concerns itself with PEP-sized items. Small
features may be added up to and including the first beta release. Bugs
may be fixed until the final release.

There will be at least two alpha releases, two beta releases, and one
release candidate. The release date was 30th November, 2004.

Release Manager
===============

Anthony Baxter

Martin von Lowis is building the Windows installers, Fred the doc
packages, Sean the RPMs.

Release Schedule
================

-   July 9: alpha 1 \[completed\]

-   August 5/6: alpha 2 \[completed\]

-   Sept 3: alpha 3 \[completed\]

-   October 15: beta 1 \[completed\]

-   November 3: beta 2 \[completed\]

-   November 18: release candidate 1 \[completed\]

-   November 30: final \[completed\]

Completed features for 2.4
==========================

-   PEP 218 Builtin Set Objects.

-   PEP 289 Generator expressions.

-   PEP 292 Simpler String Substitutions to be implemented as a module.

-   PEP 318: Function/method decorator syntax, using @syntax

-   PEP 322 Reverse Iteration.

-   PEP 327: A Decimal package for fixed precision arithmetic.

-   PEP 328: Multi-line Imports

-   Encapsulate the decorate-sort-undecorate pattern in a keyword for
    `list.sort()`.

-   Added a builtin called `sorted()` which may be used in expressions.

-   The `itertools` module has two new functions, `tee()` and
    `groupby()`.

-   Add a `collections` module with a `deque()` object.

-   Add two statistical/reduction functions, `nlargest()` and
    `nsmallest()` to the `heapq` module.

-   Python's windows installer now uses MSI

Deferred until 2.5
==================

-   Deprecate and/or remove the modules listed in PEP 4 (`posixfile`,
    `gopherlib`, `pre`, `others`)

-   Remove support for platforms as described in PEP 11.

-   Finish implementing the Distutils `bdist_dpkg` command. (AMK)

-   Add support for reading shadow passwords \[1\]\_

-   It would be nice if the built-in SSL socket type could be used for
    non-blocking SSL I/O. Currently packages such as Twisted which
    implement async servers using SSL have to require third-party
    packages such as pyopenssl.

-   AST-based compiler: this branch was not completed in time for 2.4,
    but will land on the trunk some time after 2.4 final is out, for
    inclusion in 2.5.

-   reST is going to be used a lot in Zope3. Maybe it could become a
    standard library module? (Since reST's author thinks it's too
    instable, I'm inclined not to do this.)

Ongoing tasks
=============

The following are ongoing TO-DO items which we should attempt to work on
without hoping for completion by any particular date.

-   Documentation: complete the distribution and installation manuals.

-   Documentation: complete the documentation for new-style classes.

-   Look over the `Demos/` directory and update where required (Andrew
    Kuchling has done a lot of this)

-   New tests.

-   Fix doc bugs on SF.

-   Remove use of deprecated features in the core.

-   Document deprecated features appropriately.

-   Mark deprecated C APIs with `Py_DEPRECATED`.

-   Deprecate modules which are unmaintained, or perhaps make a new
    category for modules 'Unmaintained'

-   In general, lots of cleanup so it is easier to move forward.

Open issues
===========

None at this time.

Carryover features from Python 2.3
==================================

-   The import lock could use some redesign. \[2\]\_

-   A nicer API to open text files, replacing the ugly (in some people's
    eyes) "U" mode flag. There's a proposal out there to have a new
    built-in type `textfile(filename, mode, encoding)`. (Shouldn't it
    have a *bufsize* argument too?)

-   New widgets for Tkinter???

    Has anyone gotten the time for this? *Are* there any new widgets in
    Tk 8.4? Note that we've got better Tix support already (though not
    on Windows yet).

-   PEP 304 (Controlling Generation of Bytecode Files by Montanaro)
    seems to have lost steam.

-   For a class defined inside another class, the `__name__` should be
    "outer.inner", and pickling should work. (\[3\]\_. I'm no longer
    certain this is easy or even right.)

-   Decide on a clearer deprecation policy (especially for modules) and
    act on it. For a start, see this message from Neal Norwitz \[4\]\_.
    There seems insufficient interest in moving this further in an
    organized fashion, and it's not particularly important.

-   Provide alternatives for common uses of the `types` module; Skip
    Montanaro has posted a proto-PEP for this idea \[5\]\_. There hasn't
    been any progress on this, AFAICT.

-   Use pending deprecation for the `types` and `string` modules. This
    requires providing alternatives for the parts that aren't covered
    yet (e.g. `string.whitespace` and `types.TracebackType`). It seems
    we can't get consensus on this.

-   PEP 262 Database of Installed Python Packages (Kuchling)

    This turns out to be useful for Jack Jansen's Python installer, so
    the database is worth implementing. Code will go in sandbox/pep262.

-   PEP 269 Pgen Module for Python (Riehl)

    (Some necessary changes are in; the `pgen` module itself needs to
    mature more.)

-   PEP 266 Optimizing Global Variable/Attribute Access (Montanaro)

    PEP 267 Optimized Access to Module Namespaces (Hylton)

    PEP 280 Optimizing access to globals (van Rossum)

    These are basically three friendly competing proposals. Jeremy has
    made a little progress with a new compiler, but it's going slowly
    and the compiler is only the first step. Maybe we'll be able to
    refactor the compiler in this release. I'm tempted to say we won't
    hold our breath.

-   Lazily tracking tuples? \[6\]\_ \[7\]\_ Not much enthusiasm I
    believe.

-   PEP 286 Enhanced Argument Tuples (von Loewis)

    I haven't had the time to review this thoroughly. It seems a deep
    optimization hack (also makes better correctness guarantees though).

-   Make '`as`' a keyword. It has been a pseudo-keyword long enough. Too
    much effort to bother.

References
==========

.. \[1\] Shadow Password Support Module
https://bugs.python.org/issue579435

.. \[2\] PyErr\_Warn may cause import deadlock
https://bugs.python.org/issue683658

.. \[3\] Nested class **name** https://bugs.python.org/issue633930

.. \[4\] Neal Norwitz, random vs whrandom
https://mail.python.org/pipermail/python-dev/2002-April/023165.html

.. \[5\] Skip Montanaro, python/dist/src/Lib types.py,1.26,1.27
https://mail.python.org/pipermail/python-dev/2002-May/024346.html

.. \[6\] Daniel Dunbar, Lazily GC tracking tuples
https://mail.python.org/pipermail/python-dev/2002-May/023926.html

.. \[7\] GC: untrack simple objects https://bugs.python.org/issue558745

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
