PEP: 228 Title: Reworking Python's Numeric Model Version: $Revision$
Last-Modified: $Date$ Author: moshez\@zadka.site.co.il (Moshe Zadka),
guido\@python.org (Guido van Rossum) Status: Withdrawn Type: Standards
Track Content-Type: text/x-rst Created: 4-Nov-2000 Post-History:

Withdrawal
==========

This PEP has been withdrawn in favor of PEP 3141.

Abstract
========

Today, Python's numerical model is similar to the C numeric model: there
are several unrelated numerical types, and when operations between
numerical types are requested, coercions happen. While the C rationale
for the numerical model is that it is very similar to what happens at
the hardware level, that rationale does not apply to Python. So, while
it is acceptable to C programmers that `2/3 == 0`, it is surprising to
many Python programmers.

NOTE: in the light of recent discussions in the newsgroup, the
motivation in this PEP (and details) need to be extended.

Rationale
=========

In usability studies, one of the least usable aspect of Python was the
fact that integer division returns the floor of the division. This makes
it hard to program correctly, requiring casts to `float()` in various
parts through the code. Python's numerical model stems from C, while a
model that might be easier to work with can be based on the mathematical
understanding of numbers.

Other Numerical Models
======================

Perl's numerical model is that there is one type of numbers -- floating
point numbers. While it is consistent and superficially non-surprising,
it tends to have subtle gotchas. One of these is that printing numbers
is very tricky, and requires correct rounding. In Perl, there is also a
mode where all numbers are integers. This mode also has its share of
problems, which arise from the fact that there is not even an
approximate way of dividing numbers and getting meaningful answers.

Suggested Interface For Python's Numerical Model
================================================

While coercion rules will remain for add-on types and classes, the built
in type system will have exactly one Python type -- a number. There are
several things which can be considered "number methods":

1.  `isnatural()`
2.  `isintegral()`
3.  `isrational()`
4.  `isreal()`
5.  `iscomplex()`
6.  `isexact()`

Obviously, a number which answers true to a question from 1 to 5, will
also answer true to any following question. If `isexact()` is not true,
then any answer might be wrong. (But not horribly wrong: it's close to
the truth.)

Now, there is two thing the models promises for the field operations
(`+`, `-`, `/`, `*`):

-   If both operands satisfy `isexact()`, the result satisfies
    `isexact()`.

-   All field rules are true, except that for not-`isexact()` numbers,
    they might be only approximately true.

One consequence of these two rules is that all exact calculations are
done as (complex) rationals: since the field laws must hold, then ::

    (a/b)*b == a

must hold.

There is built-in function, `inexact()` which takes a number and returns
an inexact number which is a good approximation. Inexact numbers must be
as least as accurate as if they were using IEEE-754.

Several of the classical Python functions will return exact numbers even
when given inexact numbers: e.g, `int()`.

Coercion
========

The number type does not define `nb_coerce` Any numeric operation slot,
when receiving something other then `PyNumber`, refuses to implement it.

Inexact Operations
==================

The functions in the `math` module will be allowed to return inexact
results for exact values. However, they will never return a non-real
number. The functions in the `cmath` module are also allowed to return
an inexact result for an exact argument, and are furthermore allowed to
return a complex result for a real argument.

Numerical Python Issues
=======================

People who use Numerical Python do so for high-performance vector
operations. Therefore, NumPy should keep its hardware based numeric
model.

Unresolved Issues
=================

Which number literals will be exact, and which inexact?

How do we deal with IEEE 754 operations? (probably, isnan/isinf should
be methods)

On 64-bit machines, comparisons between ints and floats may be broken
when the comparison involves conversion to float. Ditto for comparisons
between longs and floats. This can be dealt with by avoiding the
conversion to float. (Due to Andrew Koenig.)

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
