PEP: 217 Title: Display Hook for Interactive Use Version: $Revision$
Last-Modified: $Date$ Author: moshez\@zadka.site.co.il (Moshe Zadka)
Status: Final Type: Standards Track Content-Type: text/x-rst Created:
31-Jul-2000 Python-Version: 2.1 Post-History:

Abstract
========

Python's interactive mode is one of the implementation's great strengths
-- being able to write expressions on the command line and get back a
meaningful output. However, the output function cannot be all things to
all people, and the current output function too often falls short of
this goal. This PEP describes a way to provides alternatives to the
built-in display function in Python, so users will have control over the
output from the interactive interpreter.

Interface
=========

The current Python solution has worked for many users, and this should
not break it. Therefore, in the default configuration, nothing will
change in the REPL loop. To change the way the interpreter prints
interactively entered expressions, users will have to rebind
`sys.displayhook` to a callable object. The result of calling this
object with the result of the interactively entered expression should be
print-able, and this is what will be printed on `sys.stdout`.

Solution
========

The bytecode `PRINT_EXPR` will call `sys.displayhook(POP())`. A
`displayhook()` will be added to the sys builtin module, which is
equivalent to::

    import __builtin__
    def displayhook(o):
        if o is None:
            return
        __builtin__._ = None
        print `o`
        __builtin__._ = o

Jython Issues
=============

The method `Py.printResult` will be similarly changed.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
