PEP: 216 Title: Docstring Format Version: $Revision$ Last-Modified:
$Date$ Author: moshez\@zadka.site.co.il (Moshe Zadka) Status: Rejected
Type: Informational Content-Type: text/x-rst Created: 31-Jul-2000
Post-History: Superseded-By: 287

Notice
======

This PEP is rejected by the author. It has been superseded by PEP 287.

Abstract
========

Named Python objects, such as modules, classes and functions, have a
string attribute called `__doc__`. If the first expression inside the
definition is a literal string, that string is assigned to the `__doc__`
attribute.

The `__doc__` attribute is called a documentation string, or docstring.
It is often used to summarize the interface of the module, class or
function. However, since there is no common format for documentation
string, tools for extracting docstrings and transforming those into
documentation in a standard format (e.g., DocBook) have not sprang up in
abundance, and those that do exist are for the most part unmaintained
and unused.

Perl Documentation
==================

In Perl, most modules are documented in a format called POD -- Plain Old
Documentation. This is an easy-to-type, very low level format which
integrates well with the Perl parser. Many tools exist to turn POD
documentation into other formats: info, HTML and man pages, among
others. However, in Perl, the information is not available at run-time.

Java Documentation
==================

In Java, special comments before classes and functions function to
document the code. A program to extract these, and turn them into HTML
documentation is called javadoc, and is part of the standard Java
distribution. However, the only output format that is supported is HTML,
and JavaDoc has a very intimate relationship with HTML.

Python Docstring Goals
======================

Python documentation string are easy to spot during parsing, and are
also available to the runtime interpreter. This double purpose is a bit
problematic, sometimes: for example, some are reluctant to have too long
docstrings, because they do not want to take much space in the runtime.
In addition, because of the current lack of tools, people read objects'
docstrings by "print"ing them, so a tendency to make them brief and free
of markups has sprung up. This tendency hinders writing better
documentation-extraction tools, since it causes docstrings to contain
little information, which is hard to parse.

High Level Solutions
====================

To counter the objection that the strings take up place in the running
program, it is suggested that documentation extraction tools will
concatenate a maximum prefix of string literals which appear in the
beginning of a definition. The first of these will also be available in
the interactive interpreter, so it should contain a few summary lines.

Docstring Format Goals
======================

These are the goals for the docstring format, as discussed ad nauseam in
the doc-sig.

1.  It must be easy to type with any standard text editor.
2.  It must be readable to the casual observer.
3.  It must not contain information which can be deduced from parsing
    the module.
4.  It must contain sufficient information so it can be converted to any
    reasonable markup format.
5.  It must be possible to write a module's entire documentation in
    docstrings, without feeling hampered by the markup language.

Docstring Contents
==================

For requirement 5. above, it is needed to specify what must be in
docstrings.

At least the following must be available:

a.  A tag that means "this is a Python *something*, guess what"

    Example: In the sentence "The POP3 class", we need to markup "POP3"
    so. The parser will be able to guess it is a class from the contents
    of the `poplib` module, but we need to make it guess.

b.  Tags that mean "this is a Python class/module/class var/instance
    var..."

    Example: The usual Python idiom for singleton class `A` is to have
    `_A` as the class, and `A` a function which returns `_A` objects.
    It's usual to document the class, nonetheless, as being `A`. This
    requires the strength to say "The class `A`" and have `A`
    hyperlinked and marked-up as a class.

c.  An easy way to include Python source code/Python interactive
    sessions

d.  Emphasis/bold

e.  List/tables

Docstring Basic Structure
=========================

The documentation strings will be in StructuredTextNG
(http://www.zope.org/Members/jim/StructuredTextWiki/StructuredTextNG)
Since StructuredText is not yet strong enough to handle (a) and (b)
above, we will need to extend it. I suggest using
`[<optional description>:python identifier]`. E.g.: `[class:POP3]`,
`[:POP3.list]`, etc. If the description is missing, a guess will be made
from the text.

Unresolved Issues
=================

Is there a way to escape characters in ST? If so, how? (example: \* at
the beginning of a line without being bullet symbol)

Is my suggestion above for Python symbols compatible with ST-NG? How
hard would it be to extend ST-NG to support it?

How do we describe input and output types of functions?

What additional constraint do we enforce on each docstring?
(module/class/function)?

What are the guesser rules?

Rejected Suggestions
====================

XML -- it's very hard to type, and too cluttered to read it comfortably.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
