PEP: 9 Title: Sample Plaintext PEP Template Version: $Revision$
Last-Modified: $Date$ Author: Barry Warsaw <barry@python.org> Status:
Withdrawn Type: Process Content-Type: text/x-rst Created: 14-Aug-2001
Post-History: Resolution:
https://mail.python.org/mailman/private/peps/2016-January/001165.html

:: Update

      As of 05-Jan-2016, this PEP is officially deprecated and replaced
      by PEP 12.  All PEPs should now use the reStructuredText format
      described by PEP 12, and plaintext PEPs will no longer be
      accepted.

Abstract

      This PEP provides a boilerplate or sample template for creating
      your own plaintext PEPs.  In conjunction with the content
      guidelines in PEP 1 [1], this should make it easy for you to
      conform your own PEPs to the format outlined below.

      Note: if you are reading this PEP via the web, you should first
      grab the plaintext source of this PEP in order to complete the
      steps below.  DO NOT USE THE HTML FILE AS YOUR TEMPLATE!

      To get the source this (or any) PEP, look at the top of the HTML
      page and click on the date & time on the "Last-Modified" line.  It
      is a link to the source text in the Python repository.

      If you would prefer to use lightweight markup in your PEP, please
      see PEP 12, "Sample reStructuredText PEP Template" [2].

Rationale

      PEP submissions come in a wide variety of forms, not all adhering
      to the format guidelines set forth below.  Use this template, in
      conjunction with the content guidelines in PEP 1, to ensure that
      your PEP submission won't get automatically rejected because of
      form.

How to Use This Template

      To use this template you must first decide whether your PEP is
      going to be an Informational or Standards Track PEP.  Most PEPs
      are Standards Track because they propose a new feature for the
      Python language or standard library.  When in doubt, read PEP 1
      for details or contact the PEP editors <peps@python.org>.

      Once you've decided which type of PEP yours is going to be, follow
      the directions below.

      - Make a copy of this file (.txt file, not HTML!) and perform the
        following edits.

      - Replace the "PEP: 9" header with "PEP: XXX" since you don't yet
        have a PEP number assignment.

      - Change the Title header to the title of your PEP.

      - Leave the Version and Last-Modified headers alone; we'll take
        care of those when we check your PEP into Python's Subversion
        repository.  These headers consist of keywords ("Revision" and
        "Date" enclosed in "$"-signs) which are automatically expanded
        by the repository.  Please do not edit the expanded date or
        revision text.

      - Change the Author header to include your name, and optionally
        your email address.  Be sure to follow the format carefully:
        your name must appear first, and it must not be contained in
        parentheses.  Your email address may appear second (or it can be
        omitted) and if it appears, it must appear in angle brackets.
        It is okay to obfuscate your email address.

      - If there is a mailing list for discussion of your new feature,
        add a Discussions-To header right after the Author header.  You
        should not add a Discussions-To header if the mailing list to be
        used is either python-list@python.org or python-dev@python.org,
        or if discussions should be sent to you directly.  Most
        Informational PEPs don't have a Discussions-To header.

      - Change the Status header to "Draft".

      - For Standards Track PEPs, change the Type header to "Standards
        Track".

      - For Informational PEPs, change the Type header to
        "Informational".

      - For Standards Track PEPs, if your feature depends on the
        acceptance of some other currently in-development PEP, add a
        Requires header right after the Type header.  The value should
        be the PEP number of the PEP yours depends on.  Don't add this
        header if your dependent feature is described in a Final PEP.

      - Change the Created header to today's date.  Be sure to follow
        the format carefully: it must be in dd-mmm-yyyy format, where
        the mmm is the 3 English letter month abbreviation, e.g. one of
        Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec.

      - For Standards Track PEPs, after the Created header, add a
        Python-Version header and set the value to the next planned
        version of Python, i.e. the one your new feature will hopefully
        make its first appearance in.  Do not use an alpha or beta
        release designation here.  Thus, if the last version of Python
        was 2.2 alpha 1 and you're hoping to get your new feature into
        Python 2.2, set the header to:

        Python-Version: 2.2

      - Leave Post-History alone for now; you'll add dates to this
        header each time you post your PEP to python-list@python.org or
        python-dev@python.org.  E.g. if you posted your PEP to the lists
        on August 14, 2001 and September 3, 2001, the Post-History
        header would look like:

        Post-History: 14-Aug-2001, 03-Sept-2001

        You must manually add new dates and check them in.  If you don't
        have check-in privileges, send your changes to the PEP editor.

      - Add a Replaces header if your PEP obsoletes an earlier PEP.  The
        value of this header is the number of the PEP that your new PEP
        is replacing.  Only add this header if the older PEP is in
        "final" form, i.e. is either Accepted, Final, or Rejected.  You
        aren't replacing an older open PEP if you're submitting a
        competing idea.

      - Now write your Abstract, Rationale, and other content for your
        PEP, replacing all this gobbledygook with your own text. Be sure
        to adhere to the format guidelines below, specifically on the
        prohibition of tab characters and the indentation requirements.

      - Update your References and Copyright section.  Usually you'll
        place your PEP into the public domain, in which case just leave
        the "Copyright" section alone.  Alternatively, you can use the
        Open Publication License[3], but public domain is still strongly
        preferred.

      - Leave the little Emacs turd at the end of this file alone,
        including the formfeed character ("^L", or \f).

      - Send your PEP submission to the PEP editors (peps@python.org),
        along with $100k in unmarked pennies.  (Just kidding, I wanted
        to see if you were still awake. :)

Plaintext PEP Formatting Requirements

      PEP headings must begin in column zero and the initial letter of
      each word must be capitalized as in book titles.  Acronyms should
      be in all capitals.  The body of each section must be indented 4
      spaces.  Code samples inside body sections should be indented a
      further 4 spaces, and other indentation can be used as required to
      make the text readable.  You must use two blank lines between the
      last line of a section's body and the next section heading.

      You must adhere to the Emacs convention of adding two spaces at
      the end of every sentence.  You should fill your paragraphs to
      column 70, but under no circumstances should your lines extend
      past column 79.  If your code samples spill over column 79, you
      should rewrite them.

      Tab characters must never appear in the document at all.  A PEP
      should include the standard Emacs stanza included by example at
      the bottom of this PEP.

      When referencing an external web page in the body of a PEP, you
      should include the title of the page in the text, with a
      footnote reference to the URL.  Do not include the URL in the body
      text of the PEP.  E.g.

          Refer to the Python Language web site [1] for more details.
          ...
          [1] http://www.python.org

      When referring to another PEP, include the PEP number in the body
      text, such as "PEP 1".  The title may optionally appear.  Add a
      footnote reference, a number in square brackets.  The footnote
      body should include the PEP's title and author.  It may optionally
      include the explicit URL on a separate line, but only in the
      References section.  Note that the pep2html.py script will
      calculate URLs automatically.  For example:

              ...
              Refer to PEP 1 [7] for more information about PEP style
              ...

          References

              [7] PEP 1, PEP Purpose and Guidelines, Warsaw, Hylton
                  http://www.python.org/dev/peps/pep-0001/

      If you decide to provide an explicit URL for a PEP, please use
      this as the URL template:

          http://www.python.org/dev/peps/pep-xxxx/

      PEP numbers in URLs must be padded with zeros from the left, so as
      to be exactly 4 characters wide, however PEP numbers in the text
      are never padded.

References

      [1] PEP 1, PEP Purpose and Guidelines, Warsaw, Hylton
          http://www.python.org/dev/peps/pep-0001/

      [2] PEP 12, Sample reStructuredText PEP Template, Goodger, Warsaw
          http://www.python.org/dev/peps/pep-0012/

      [3] http://www.opencontent.org/openpub/

Copyright

      This document has been placed in the public domain.

 Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
