from typing import Any as _py_Any
from typing import List as _py_List
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.beans
import java.io
import java.lang
import java.security
import java.util
import java.util.function
import sun.util.logging


class ErrorManager:
    GENERIC_FAILURE: _py_ClassVar[int] = ...
    WRITE_FAILURE: _py_ClassVar[int] = ...
    FLUSH_FAILURE: _py_ClassVar[int] = ...
    CLOSE_FAILURE: _py_ClassVar[int] = ...
    OPEN_FAILURE: _py_ClassVar[int] = ...
    FORMAT_FAILURE: _py_ClassVar[int] = ...
    def __init__(self): ...
    def error(self, string: str, exception: java.lang.Exception, int: int) -> None: ...

class Filter:
    def isLoggable(self, logRecord: 'LogRecord') -> bool: ...

class Formatter:
    def format(self, logRecord: 'LogRecord') -> str: ...
    def formatMessage(self, logRecord: 'LogRecord') -> str: ...
    def getHead(self, handler: 'Handler') -> str: ...
    def getTail(self, handler: 'Handler') -> str: ...

class Handler:
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def getEncoding(self) -> str: ...
    def getErrorManager(self) -> ErrorManager: ...
    def getFilter(self) -> Filter: ...
    def getFormatter(self) -> Formatter: ...
    def getLevel(self) -> 'Level': ...
    def isLoggable(self, logRecord: 'LogRecord') -> bool: ...
    def publish(self, logRecord: 'LogRecord') -> None: ...
    def setEncoding(self, string: str) -> None: ...
    def setErrorManager(self, errorManager: ErrorManager) -> None: ...
    def setFilter(self, filter: Filter) -> None: ...
    def setFormatter(self, formatter: Formatter) -> None: ...
    def setLevel(self, level: 'Level') -> None: ...

class Level(java.io.Serializable):
    OFF: _py_ClassVar['Level'] = ...
    SEVERE: _py_ClassVar['Level'] = ...
    WARNING: _py_ClassVar['Level'] = ...
    INFO: _py_ClassVar['Level'] = ...
    CONFIG: _py_ClassVar['Level'] = ...
    FINE: _py_ClassVar['Level'] = ...
    FINER: _py_ClassVar['Level'] = ...
    FINEST: _py_ClassVar['Level'] = ...
    ALL: _py_ClassVar['Level'] = ...
    def equals(self, object: _py_Any) -> bool: ...
    def getLocalizedName(self) -> str: ...
    def getName(self) -> str: ...
    def getResourceBundleName(self) -> str: ...
    def hashCode(self) -> int: ...
    def intValue(self) -> int: ...
    @classmethod
    def parse(cls, string: str) -> 'Level': ...
    def toString(self) -> str: ...

class LogManager:
    LOGGING_MXBEAN_NAME: _py_ClassVar[str] = ...
    def addLogger(self, logger: 'Logger') -> bool: ...
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def checkAccess(self) -> None: ...
    @classmethod
    def getLogManager(cls) -> 'LogManager': ...
    def getLogger(self, string: str) -> 'Logger': ...
    def getLoggerNames(self) -> java.util.Enumeration[str]: ...
    @classmethod
    def getLoggingMXBean(cls) -> 'LoggingMXBean': ...
    def getProperty(self, string: str) -> str: ...
    @overload
    def readConfiguration(self) -> None: ...
    @overload
    def readConfiguration(self, inputStream: java.io.InputStream) -> None: ...
    def removePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def reset(self) -> None: ...

class LogRecord(java.io.Serializable):
    def __init__(self, level: Level, string: str): ...
    def getLevel(self) -> Level: ...
    def getLoggerName(self) -> str: ...
    def getMessage(self) -> str: ...
    def getMillis(self) -> int: ...
    def getParameters(self) -> _py_List[_py_Any]: ...
    def getResourceBundle(self) -> java.util.ResourceBundle: ...
    def getResourceBundleName(self) -> str: ...
    def getSequenceNumber(self) -> int: ...
    def getSourceClassName(self) -> str: ...
    def getSourceMethodName(self) -> str: ...
    def getThreadID(self) -> int: ...
    def getThrown(self) -> java.lang.Throwable: ...
    def setLevel(self, level: Level) -> None: ...
    def setLoggerName(self, string: str) -> None: ...
    def setMessage(self, string: str) -> None: ...
    def setMillis(self, long: int) -> None: ...
    def setParameters(self, objectArray: _py_List[_py_Any]) -> None: ...
    def setResourceBundle(self, resourceBundle: java.util.ResourceBundle) -> None: ...
    def setResourceBundleName(self, string: str) -> None: ...
    def setSequenceNumber(self, long: int) -> None: ...
    def setSourceClassName(self, string: str) -> None: ...
    def setSourceMethodName(self, string: str) -> None: ...
    def setThreadID(self, int: int) -> None: ...
    def setThrown(self, throwable: java.lang.Throwable) -> None: ...

class Logger:
    GLOBAL_LOGGER_NAME: _py_ClassVar[str] = ...
    global_: _py_ClassVar['Logger'] = ...
    def addHandler(self, handler: Handler) -> None: ...
    @overload
    def config(self, string: str) -> None: ...
    @overload
    def config(self, supplier: java.util.function.Supplier[str]) -> None: ...
    @overload
    def entering(self, string: str, string2: str) -> None: ...
    @overload
    def entering(self, string: str, string2: str, object: _py_Any) -> None: ...
    @overload
    def entering(self, string: str, string2: str, objectArray: _py_List[_py_Any]) -> None: ...
    @overload
    def exiting(self, string: str, string2: str) -> None: ...
    @overload
    def exiting(self, string: str, string2: str, object: _py_Any) -> None: ...
    @overload
    def fine(self, string: str) -> None: ...
    @overload
    def fine(self, supplier: java.util.function.Supplier[str]) -> None: ...
    @overload
    def finer(self, string: str) -> None: ...
    @overload
    def finer(self, supplier: java.util.function.Supplier[str]) -> None: ...
    @overload
    def finest(self, string: str) -> None: ...
    @overload
    def finest(self, supplier: java.util.function.Supplier[str]) -> None: ...
    @classmethod
    @overload
    def getAnonymousLogger(cls) -> 'Logger': ...
    @classmethod
    @overload
    def getAnonymousLogger(cls, string: str) -> 'Logger': ...
    def getFilter(self) -> Filter: ...
    @classmethod
    def getGlobal(cls) -> 'Logger': ...
    def getHandlers(self) -> _py_List[Handler]: ...
    def getLevel(self) -> Level: ...
    @classmethod
    @overload
    def getLogger(cls, string: str) -> 'Logger': ...
    @classmethod
    @overload
    def getLogger(cls, string: str, string2: str) -> 'Logger': ...
    def getName(self) -> str: ...
    def getParent(self) -> 'Logger': ...
    def getResourceBundle(self) -> java.util.ResourceBundle: ...
    def getResourceBundleName(self) -> str: ...
    def getUseParentHandlers(self) -> bool: ...
    @overload
    def info(self, string: str) -> None: ...
    @overload
    def info(self, supplier: java.util.function.Supplier[str]) -> None: ...
    def isLoggable(self, level: Level) -> bool: ...
    @overload
    def log(self, level: Level, string: str) -> None: ...
    @overload
    def log(self, level: Level, string: str, object: _py_Any) -> None: ...
    @overload
    def log(self, level: Level, string: str, objectArray: _py_List[_py_Any]) -> None: ...
    @overload
    def log(self, level: Level, string: str, throwable: java.lang.Throwable) -> None: ...
    @overload
    def log(self, level: Level, throwable: java.lang.Throwable, supplier: java.util.function.Supplier[str]) -> None: ...
    @overload
    def log(self, level: Level, supplier: java.util.function.Supplier[str]) -> None: ...
    @overload
    def log(self, logRecord: LogRecord) -> None: ...
    @overload
    def logp(self, level: Level, string: str, string2: str, string3: str) -> None: ...
    @overload
    def logp(self, level: Level, string: str, string2: str, string3: str, object: _py_Any) -> None: ...
    @overload
    def logp(self, level: Level, string: str, string2: str, string3: str, objectArray: _py_List[_py_Any]) -> None: ...
    @overload
    def logp(self, level: Level, string: str, string2: str, string3: str, throwable: java.lang.Throwable) -> None: ...
    @overload
    def logp(self, level: Level, string: str, string2: str, throwable: java.lang.Throwable, supplier: java.util.function.Supplier[str]) -> None: ...
    @overload
    def logp(self, level: Level, string: str, string2: str, supplier: java.util.function.Supplier[str]) -> None: ...
    @overload
    def logrb(self, level: Level, string: str, string2: str, string3: str, string4: str) -> None: ...
    @overload
    def logrb(self, level: Level, string: str, string2: str, string3: str, string4: str, object: _py_Any) -> None: ...
    @overload
    def logrb(self, level: Level, string: str, string2: str, string3: str, string4: str, objectArray: _py_List[_py_Any]) -> None: ...
    @overload
    def logrb(self, level: Level, string: str, string2: str, string3: str, string4: str, throwable: java.lang.Throwable) -> None: ...
    @overload
    def logrb(self, level: Level, string: str, string2: str, resourceBundle: java.util.ResourceBundle, string3: str, objectArray: _py_List[_py_Any]) -> None: ...
    @overload
    def logrb(self, level: Level, string: str, string2: str, resourceBundle: java.util.ResourceBundle, string3: str, throwable: java.lang.Throwable) -> None: ...
    def removeHandler(self, handler: Handler) -> None: ...
    def setFilter(self, filter: Filter) -> None: ...
    def setLevel(self, level: Level) -> None: ...
    def setParent(self, logger: 'Logger') -> None: ...
    def setResourceBundle(self, resourceBundle: java.util.ResourceBundle) -> None: ...
    def setUseParentHandlers(self, boolean: bool) -> None: ...
    @overload
    def severe(self, string: str) -> None: ...
    @overload
    def severe(self, supplier: java.util.function.Supplier[str]) -> None: ...
    def throwing(self, string: str, string2: str, throwable: java.lang.Throwable) -> None: ...
    @overload
    def warning(self, string: str) -> None: ...
    @overload
    def warning(self, supplier: java.util.function.Supplier[str]) -> None: ...

class LoggingMXBean:
    def getLoggerLevel(self, string: str) -> str: ...
    def getLoggerNames(self) -> java.util.List[str]: ...
    def getParentLoggerName(self, string: str) -> str: ...
    def setLoggerLevel(self, string: str, string2: str) -> None: ...

class LoggingPermission(java.security.BasicPermission):
    def __init__(self, string: str, string2: str): ...

class LoggingProxyImpl(sun.util.logging.LoggingProxy):
    def getLevel(self, object: _py_Any) -> _py_Any: ...
    def getLevelName(self, object: _py_Any) -> str: ...
    def getLevelValue(self, object: _py_Any) -> int: ...
    def getLogger(self, string: str) -> _py_Any: ...
    def getLoggerLevel(self, string: str) -> str: ...
    def getLoggerNames(self) -> java.util.List[str]: ...
    def getParentLoggerName(self, string: str) -> str: ...
    def getProperty(self, string: str) -> str: ...
    def isLoggable(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def log(self, object: _py_Any, object2: _py_Any, string: str) -> None: ...
    @overload
    def log(self, object: _py_Any, object2: _py_Any, string: str, objectArray: _py_List[_py_Any]) -> None: ...
    @overload
    def log(self, object: _py_Any, object2: _py_Any, string: str, throwable: java.lang.Throwable) -> None: ...
    def parseLevel(self, string: str) -> _py_Any: ...
    def setLevel(self, object: _py_Any, object2: _py_Any) -> None: ...
    def setLoggerLevel(self, string: str, string2: str) -> None: ...

class Logging(LoggingMXBean):
    def getLoggerLevel(self, string: str) -> str: ...
    def getLoggerNames(self) -> java.util.List[str]: ...
    def getParentLoggerName(self, string: str) -> str: ...
    def setLoggerLevel(self, string: str, string2: str) -> None: ...

class MemoryHandler(Handler):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, handler: Handler, int: int, level: Level): ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def getPushLevel(self) -> Level: ...
    def isLoggable(self, logRecord: LogRecord) -> bool: ...
    def publish(self, logRecord: LogRecord) -> None: ...
    def push(self) -> None: ...
    def setPushLevel(self, level: Level) -> None: ...

class SimpleFormatter(Formatter):
    def __init__(self): ...
    def format(self, logRecord: LogRecord) -> str: ...

class StreamHandler(Handler):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, outputStream: java.io.OutputStream, formatter: Formatter): ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def isLoggable(self, logRecord: LogRecord) -> bool: ...
    def publish(self, logRecord: LogRecord) -> None: ...
    def setEncoding(self, string: str) -> None: ...

class XMLFormatter(Formatter):
    def __init__(self): ...
    def format(self, logRecord: LogRecord) -> str: ...
    def getHead(self, handler: Handler) -> str: ...
    def getTail(self, handler: Handler) -> str: ...

class ConsoleHandler(StreamHandler):
    def __init__(self): ...
    def close(self) -> None: ...
    def publish(self, logRecord: LogRecord) -> None: ...

class FileHandler(StreamHandler):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, boolean: bool): ...
    @overload
    def __init__(self, string: str, int: int, int2: int): ...
    @overload
    def __init__(self, string: str, int: int, int2: int, boolean: bool): ...
    def close(self) -> None: ...
    def publish(self, logRecord: LogRecord) -> None: ...

class SocketHandler(StreamHandler):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str, int: int): ...
    def close(self) -> None: ...
    def publish(self, logRecord: LogRecord) -> None: ...
