from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import java.io
import java.lang
import java.time
import java.time.format
import java.time.temporal
import java.util


class ChronoLocalDate(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['ChronoLocalDate']):
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atTime(self, localTime: java.time.LocalTime) -> 'ChronoLocalDateTime'[_py_Any]: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, chronoLocalDate: 'ChronoLocalDate') -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def getChronology(self) -> 'Chronology': ...
    def getEra(self) -> 'Era': ...
    def hashCode(self) -> int: ...
    def isAfter(self, chronoLocalDate: 'ChronoLocalDate') -> bool: ...
    def isBefore(self, chronoLocalDate: 'ChronoLocalDate') -> bool: ...
    def isEqual(self, chronoLocalDate: 'ChronoLocalDate') -> bool: ...
    def isLeapYear(self) -> bool: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    def lengthOfMonth(self) -> int: ...
    def lengthOfYear(self) -> int: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ChronoLocalDate': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ChronoLocalDate': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ChronoLocalDate': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ChronoLocalDate': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    @classmethod
    def timeLineOrder(cls) -> java.util.Comparator['ChronoLocalDate']: ...
    def toEpochDay(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def until(self, chronoLocalDate: 'ChronoLocalDate') -> 'ChronoPeriod': ...
    @overload
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...

_ChronoLocalDateTime__D = _py_TypeVar('_ChronoLocalDateTime__D', bound=ChronoLocalDate)  # <D>
class ChronoLocalDateTime(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['ChronoLocalDateTime'[_py_Any]], _py_Generic[_ChronoLocalDateTime__D]):
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atZone(self, zoneId: java.time.ZoneId) -> 'ChronoZonedDateTime'[_ChronoLocalDateTime__D]: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, chronoLocalDateTime: 'ChronoLocalDateTime'[_py_Any]) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def getChronology(self) -> 'Chronology': ...
    def hashCode(self) -> int: ...
    def isAfter(self, chronoLocalDateTime: 'ChronoLocalDateTime'[_py_Any]) -> bool: ...
    def isBefore(self, chronoLocalDateTime: 'ChronoLocalDateTime'[_py_Any]) -> bool: ...
    def isEqual(self, chronoLocalDateTime: 'ChronoLocalDateTime'[_py_Any]) -> bool: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ChronoLocalDateTime'[_ChronoLocalDateTime__D]: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ChronoLocalDateTime'[_ChronoLocalDateTime__D]: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ChronoLocalDateTime'[_ChronoLocalDateTime__D]: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ChronoLocalDateTime'[_ChronoLocalDateTime__D]: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    @classmethod
    def timeLineOrder(cls) -> java.util.Comparator['ChronoLocalDateTime'[_py_Any]]: ...
    def toEpochSecond(self, zoneOffset: java.time.ZoneOffset) -> int: ...
    def toInstant(self, zoneOffset: java.time.ZoneOffset) -> java.time.Instant: ...
    def toLocalDate(self) -> _ChronoLocalDateTime__D: ...
    def toLocalTime(self) -> java.time.LocalTime: ...
    def toString(self) -> str: ...

class ChronoPeriod(java.time.temporal.TemporalAmount):
    def addTo(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    @classmethod
    def between(cls, chronoLocalDate: ChronoLocalDate, chronoLocalDate2: ChronoLocalDate) -> 'ChronoPeriod': ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def getChronology(self) -> 'Chronology': ...
    def getUnits(self) -> java.util.List[java.time.temporal.TemporalUnit]: ...
    def hashCode(self) -> int: ...
    def isNegative(self) -> bool: ...
    def isZero(self) -> bool: ...
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ChronoPeriod': ...
    def multipliedBy(self, int: int) -> 'ChronoPeriod': ...
    def negated(self) -> 'ChronoPeriod': ...
    def normalized(self) -> 'ChronoPeriod': ...
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ChronoPeriod': ...
    def subtractFrom(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def toString(self) -> str: ...

_ChronoZonedDateTime__D = _py_TypeVar('_ChronoZonedDateTime__D', bound=ChronoLocalDate)  # <D>
class ChronoZonedDateTime(java.time.temporal.Temporal, java.lang.Comparable['ChronoZonedDateTime'[_py_Any]], _py_Generic[_ChronoZonedDateTime__D]):
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, chronoZonedDateTime: 'ChronoZonedDateTime'[_py_Any]) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getChronology(self) -> 'Chronology': ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getOffset(self) -> java.time.ZoneOffset: ...
    def getZone(self) -> java.time.ZoneId: ...
    def hashCode(self) -> int: ...
    def isAfter(self, chronoZonedDateTime: 'ChronoZonedDateTime'[_py_Any]) -> bool: ...
    def isBefore(self, chronoZonedDateTime: 'ChronoZonedDateTime'[_py_Any]) -> bool: ...
    def isEqual(self, chronoZonedDateTime: 'ChronoZonedDateTime'[_py_Any]) -> bool: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ChronoZonedDateTime'[_ChronoZonedDateTime__D]: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ChronoZonedDateTime'[_ChronoZonedDateTime__D]: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ChronoZonedDateTime'[_ChronoZonedDateTime__D]: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ChronoZonedDateTime'[_ChronoZonedDateTime__D]: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    @classmethod
    def timeLineOrder(cls) -> java.util.Comparator['ChronoZonedDateTime'[_py_Any]]: ...
    def toEpochSecond(self) -> int: ...
    def toInstant(self) -> java.time.Instant: ...
    def toLocalDate(self) -> _ChronoZonedDateTime__D: ...
    def toLocalDateTime(self) -> ChronoLocalDateTime[_ChronoZonedDateTime__D]: ...
    def toLocalTime(self) -> java.time.LocalTime: ...
    def toString(self) -> str: ...
    def withEarlierOffsetAtOverlap(self) -> 'ChronoZonedDateTime'[_ChronoZonedDateTime__D]: ...
    def withLaterOffsetAtOverlap(self) -> 'ChronoZonedDateTime'[_ChronoZonedDateTime__D]: ...
    def withZoneSameInstant(self, zoneId: java.time.ZoneId) -> 'ChronoZonedDateTime'[_ChronoZonedDateTime__D]: ...
    def withZoneSameLocal(self, zoneId: java.time.ZoneId) -> 'ChronoZonedDateTime'[_ChronoZonedDateTime__D]: ...

class Chronology(java.lang.Comparable['Chronology']):
    @overload
    def compareTo(self, chronology: 'Chronology') -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def date(self, int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    @overload
    def date(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDate: ...
    @overload
    def date(self, era: 'Era', int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    def dateEpochDay(self, long: int) -> ChronoLocalDate: ...
    @overload
    def dateNow(self) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, clock: java.time.Clock) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, zoneId: java.time.ZoneId) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, int: int, int2: int) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, era: 'Era', int: int, int2: int) -> ChronoLocalDate: ...
    def equals(self, object: _py_Any) -> bool: ...
    def eraOf(self, int: int) -> 'Era': ...
    def eras(self) -> java.util.List['Era']: ...
    @classmethod
    def getAvailableChronologies(cls) -> java.util.Set['Chronology']: ...
    def getCalendarType(self) -> str: ...
    def getDisplayName(self, textStyle: java.time.format.TextStyle, locale: java.util.Locale) -> str: ...
    def getId(self) -> str: ...
    def hashCode(self) -> int: ...
    def isLeapYear(self, long: int) -> bool: ...
    def localDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDateTime[ChronoLocalDate]: ...
    @classmethod
    def of(cls, string: str) -> 'Chronology': ...
    @classmethod
    def ofLocale(cls, locale: java.util.Locale) -> 'Chronology': ...
    def period(self, int: int, int2: int, int3: int) -> ChronoPeriod: ...
    def prolepticYear(self, era: 'Era', int: int) -> int: ...
    def range(self, chronoField: java.time.temporal.ChronoField) -> java.time.temporal.ValueRange: ...
    def resolveDate(self, map: java.util.Map[java.time.temporal.TemporalField, int], resolverStyle: java.time.format.ResolverStyle) -> ChronoLocalDate: ...
    def toString(self) -> str: ...
    @overload
    def zonedDateTime(self, instant: java.time.Instant, zoneId: java.time.ZoneId) -> ChronoZonedDateTime[ChronoLocalDate]: ...
    @overload
    def zonedDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoZonedDateTime[ChronoLocalDate]: ...

class Era(java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster):
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDisplayName(self, textStyle: java.time.format.TextStyle, locale: java.util.Locale) -> str: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getValue(self) -> int: ...
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...

class Ser(java.io.Externalizable):
    def __init__(self): ...
    def readExternal(self, objectInput: java.io.ObjectInput) -> None: ...
    def writeExternal(self, objectOutput: java.io.ObjectOutput) -> None: ...

class AbstractChronology(Chronology):
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, chronology: Chronology) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def resolveDate(self, map: java.util.Map[java.time.temporal.TemporalField, int], resolverStyle: java.time.format.ResolverStyle) -> ChronoLocalDate: ...
    def toString(self) -> str: ...

_ChronoLocalDateImpl__D = _py_TypeVar('_ChronoLocalDateImpl__D', bound=ChronoLocalDate)  # <D>
class ChronoLocalDateImpl(ChronoLocalDate, java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.io.Serializable, _py_Generic[_ChronoLocalDateImpl__D]):
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> _ChronoLocalDateImpl__D: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> _ChronoLocalDateImpl__D: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> _ChronoLocalDateImpl__D: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> _ChronoLocalDateImpl__D: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def toString(self) -> str: ...
    @overload
    def until(self, chronoLocalDate: ChronoLocalDate) -> ChronoPeriod: ...
    @overload
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...

_ChronoLocalDateTimeImpl__D = _py_TypeVar('_ChronoLocalDateTimeImpl__D', bound=ChronoLocalDate)  # <D>
class ChronoLocalDateTimeImpl(ChronoLocalDateTime[_ChronoLocalDateTimeImpl__D], java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.io.Serializable, _py_Generic[_ChronoLocalDateTimeImpl__D]):
    def atZone(self, zoneId: java.time.ZoneId) -> ChronoZonedDateTime[_ChronoLocalDateTimeImpl__D]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def hashCode(self) -> int: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoLocalDateTime[_ChronoLocalDateTimeImpl__D]: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> ChronoLocalDateTime: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ChronoLocalDateTimeImpl'[_ChronoLocalDateTimeImpl__D]: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toLocalDate(self) -> _ChronoLocalDateTimeImpl__D: ...
    def toLocalTime(self) -> java.time.LocalTime: ...
    def toString(self) -> str: ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...

class ChronoPeriodImpl(ChronoPeriod, java.io.Serializable):
    def addTo(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def getChronology(self) -> Chronology: ...
    def getUnits(self) -> java.util.List[java.time.temporal.TemporalUnit]: ...
    def hashCode(self) -> int: ...
    def isNegative(self) -> bool: ...
    def isZero(self) -> bool: ...
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoPeriod: ...
    def multipliedBy(self, int: int) -> ChronoPeriod: ...
    def normalized(self) -> ChronoPeriod: ...
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoPeriod: ...
    def subtractFrom(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def toString(self) -> str: ...

_ChronoZonedDateTimeImpl__D = _py_TypeVar('_ChronoZonedDateTimeImpl__D', bound=ChronoLocalDate)  # <D>
class ChronoZonedDateTimeImpl(ChronoZonedDateTime[_ChronoZonedDateTimeImpl__D], java.io.Serializable, _py_Generic[_ChronoZonedDateTimeImpl__D]):
    def equals(self, object: _py_Any) -> bool: ...
    def getOffset(self) -> java.time.ZoneOffset: ...
    def getZone(self) -> java.time.ZoneId: ...
    def hashCode(self) -> int: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoZonedDateTime[_ChronoZonedDateTimeImpl__D]: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> ChronoZonedDateTime[_ChronoZonedDateTimeImpl__D]: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def toLocalDateTime(self) -> ChronoLocalDateTime[_ChronoZonedDateTimeImpl__D]: ...
    def toString(self) -> str: ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withEarlierOffsetAtOverlap(self) -> ChronoZonedDateTime[_ChronoZonedDateTimeImpl__D]: ...
    def withLaterOffsetAtOverlap(self) -> ChronoZonedDateTime[_ChronoZonedDateTimeImpl__D]: ...
    def withZoneSameInstant(self, zoneId: java.time.ZoneId) -> ChronoZonedDateTime[_ChronoZonedDateTimeImpl__D]: ...
    def withZoneSameLocal(self, zoneId: java.time.ZoneId) -> ChronoZonedDateTime[_ChronoZonedDateTimeImpl__D]: ...

class HijrahEra(java.lang.Enum['HijrahEra'], Era):
    AH: _py_ClassVar['HijrahEra'] = ...
    def getValue(self) -> int: ...
    @classmethod
    def of(cls, int: int) -> 'HijrahEra': ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'HijrahEra': ...
    @classmethod
    def values(cls) -> _py_List['HijrahEra']: ...

class IsoEra(java.lang.Enum['IsoEra'], Era):
    BCE: _py_ClassVar['IsoEra'] = ...
    CE: _py_ClassVar['IsoEra'] = ...
    def getValue(self) -> int: ...
    @classmethod
    def of(cls, int: int) -> 'IsoEra': ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'IsoEra': ...
    @classmethod
    def values(cls) -> _py_List['IsoEra']: ...

class JapaneseEra(Era, java.io.Serializable):
    MEIJI: _py_ClassVar['JapaneseEra'] = ...
    TAISHO: _py_ClassVar['JapaneseEra'] = ...
    SHOWA: _py_ClassVar['JapaneseEra'] = ...
    HEISEI: _py_ClassVar['JapaneseEra'] = ...
    def getDisplayName(self, textStyle: java.time.format.TextStyle, locale: java.util.Locale) -> str: ...
    def getValue(self) -> int: ...
    @classmethod
    def of(cls, int: int) -> 'JapaneseEra': ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toString(self) -> str: ...
    @classmethod
    def valueOf(cls, string: str) -> 'JapaneseEra': ...
    @classmethod
    def values(cls) -> _py_List['JapaneseEra']: ...

class MinguoEra(java.lang.Enum['MinguoEra'], Era):
    BEFORE_ROC: _py_ClassVar['MinguoEra'] = ...
    ROC: _py_ClassVar['MinguoEra'] = ...
    def getValue(self) -> int: ...
    @classmethod
    def of(cls, int: int) -> 'MinguoEra': ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'MinguoEra': ...
    @classmethod
    def values(cls) -> _py_List['MinguoEra']: ...

class ThaiBuddhistEra(java.lang.Enum['ThaiBuddhistEra'], Era):
    BEFORE_BE: _py_ClassVar['ThaiBuddhistEra'] = ...
    BE: _py_ClassVar['ThaiBuddhistEra'] = ...
    def getValue(self) -> int: ...
    @classmethod
    def of(cls, int: int) -> 'ThaiBuddhistEra': ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'ThaiBuddhistEra': ...
    @classmethod
    def values(cls) -> _py_List['ThaiBuddhistEra']: ...

class HijrahChronology(AbstractChronology, java.io.Serializable):
    INSTANCE: _py_ClassVar['HijrahChronology'] = ...
    @overload
    def date(self, int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    @overload
    def date(self, era: Era, int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    @overload
    def date(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDate: ...
    @overload
    def date(self, int: int, int2: int, int3: int) -> 'HijrahDate': ...
    @overload
    def date(self, era: Era, int: int, int2: int, int3: int) -> 'HijrahDate': ...
    @overload
    def date(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> 'HijrahDate': ...
    @overload
    def dateEpochDay(self, long: int) -> ChronoLocalDate: ...
    @overload
    def dateEpochDay(self, long: int) -> 'HijrahDate': ...
    @overload
    def dateNow(self) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, clock: java.time.Clock) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, zoneId: java.time.ZoneId) -> ChronoLocalDate: ...
    @overload
    def dateNow(self) -> 'HijrahDate': ...
    @overload
    def dateNow(self, clock: java.time.Clock) -> 'HijrahDate': ...
    @overload
    def dateNow(self, zoneId: java.time.ZoneId) -> 'HijrahDate': ...
    @overload
    def dateYearDay(self, int: int, int2: int) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, era: Era, int: int, int2: int) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, int: int, int2: int) -> 'HijrahDate': ...
    @overload
    def dateYearDay(self, era: Era, int: int, int2: int) -> 'HijrahDate': ...
    @overload
    def eraOf(self, int: int) -> Era: ...
    @overload
    def eraOf(self, int: int) -> HijrahEra: ...
    def eras(self) -> java.util.List[Era]: ...
    def getCalendarType(self) -> str: ...
    def getId(self) -> str: ...
    def isLeapYear(self, long: int) -> bool: ...
    def localDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDateTime['HijrahDate']: ...
    def prolepticYear(self, era: Era, int: int) -> int: ...
    def range(self, chronoField: java.time.temporal.ChronoField) -> java.time.temporal.ValueRange: ...
    @overload
    def resolveDate(self, map: java.util.Map, resolverStyle: java.time.format.ResolverStyle) -> ChronoLocalDate: ...
    @overload
    def resolveDate(self, map: java.util.Map[java.time.temporal.TemporalField, int], resolverStyle: java.time.format.ResolverStyle) -> 'HijrahDate': ...
    @overload
    def zonedDateTime(self, instant: java.time.Instant, zoneId: java.time.ZoneId) -> ChronoZonedDateTime['HijrahDate']: ...
    @overload
    def zonedDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoZonedDateTime['HijrahDate']: ...

class HijrahDate(ChronoLocalDateImpl['HijrahDate'], ChronoLocalDate, java.io.Serializable):
    def atTime(self, localTime: java.time.LocalTime) -> ChronoLocalDateTime['HijrahDate']: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getChronology(self) -> Chronology: ...
    @overload
    def getChronology(self) -> HijrahChronology: ...
    @overload
    def getEra(self) -> Era: ...
    @overload
    def getEra(self) -> HijrahEra: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def hashCode(self) -> int: ...
    def isLeapYear(self) -> bool: ...
    def lengthOfMonth(self) -> int: ...
    def lengthOfYear(self) -> int: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoLocalDate: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> ChronoLocalDate: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'HijrahDate': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'HijrahDate': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    @classmethod
    @overload
    def now(cls) -> 'HijrahDate': ...
    @classmethod
    @overload
    def now(cls, clock: java.time.Clock) -> 'HijrahDate': ...
    @classmethod
    @overload
    def now(cls, zoneId: java.time.ZoneId) -> 'HijrahDate': ...
    @classmethod
    def of(cls, int: int, int2: int, int3: int) -> 'HijrahDate': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoLocalDate: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> ChronoLocalDate: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'HijrahDate': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'HijrahDate': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toEpochDay(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def until(self, chronoLocalDate: ChronoLocalDate) -> ChronoPeriod: ...
    @overload
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withVariant(self, hijrahChronology: HijrahChronology) -> 'HijrahDate': ...

class IsoChronology(AbstractChronology, java.io.Serializable):
    INSTANCE: _py_ClassVar['IsoChronology'] = ...
    @overload
    def date(self, int: int, int2: int, int3: int) -> java.time.LocalDate: ...
    @overload
    def date(self, era: Era, int: int, int2: int, int3: int) -> java.time.LocalDate: ...
    @overload
    def date(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> java.time.LocalDate: ...
    @overload
    def date(self, int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    @overload
    def date(self, era: Era, int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    @overload
    def date(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDate: ...
    @overload
    def dateEpochDay(self, long: int) -> java.time.LocalDate: ...
    @overload
    def dateEpochDay(self, long: int) -> ChronoLocalDate: ...
    @overload
    def dateNow(self) -> java.time.LocalDate: ...
    @overload
    def dateNow(self, clock: java.time.Clock) -> java.time.LocalDate: ...
    @overload
    def dateNow(self, zoneId: java.time.ZoneId) -> java.time.LocalDate: ...
    @overload
    def dateNow(self) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, clock: java.time.Clock) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, zoneId: java.time.ZoneId) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, int: int, int2: int) -> java.time.LocalDate: ...
    @overload
    def dateYearDay(self, era: Era, int: int, int2: int) -> java.time.LocalDate: ...
    @overload
    def dateYearDay(self, int: int, int2: int) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, era: Era, int: int, int2: int) -> ChronoLocalDate: ...
    @overload
    def eraOf(self, int: int) -> Era: ...
    @overload
    def eraOf(self, int: int) -> IsoEra: ...
    def eras(self) -> java.util.List[Era]: ...
    def getCalendarType(self) -> str: ...
    def getId(self) -> str: ...
    def isLeapYear(self, long: int) -> bool: ...
    @overload
    def localDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> java.time.LocalDateTime: ...
    @overload
    def localDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDateTime: ...
    @overload
    def period(self, int: int, int2: int, int3: int) -> java.time.Period: ...
    @overload
    def period(self, int: int, int2: int, int3: int) -> ChronoPeriod: ...
    def prolepticYear(self, era: Era, int: int) -> int: ...
    def range(self, chronoField: java.time.temporal.ChronoField) -> java.time.temporal.ValueRange: ...
    @overload
    def resolveDate(self, map: java.util.Map[java.time.temporal.TemporalField, int], resolverStyle: java.time.format.ResolverStyle) -> java.time.LocalDate: ...
    @overload
    def resolveDate(self, map: java.util.Map, resolverStyle: java.time.format.ResolverStyle) -> ChronoLocalDate: ...
    @overload
    def zonedDateTime(self, instant: java.time.Instant, zoneId: java.time.ZoneId) -> java.time.ZonedDateTime: ...
    @overload
    def zonedDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> java.time.ZonedDateTime: ...
    @overload
    def zonedDateTime(self, instant: java.time.Instant, zoneId: java.time.ZoneId) -> ChronoZonedDateTime: ...
    @overload
    def zonedDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoZonedDateTime: ...

class JapaneseChronology(AbstractChronology, java.io.Serializable):
    INSTANCE: _py_ClassVar['JapaneseChronology'] = ...
    @overload
    def date(self, int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    @overload
    def date(self, era: Era, int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    @overload
    def date(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDate: ...
    @overload
    def date(self, int: int, int2: int, int3: int) -> 'JapaneseDate': ...
    @overload
    def date(self, era: Era, int: int, int2: int, int3: int) -> 'JapaneseDate': ...
    @overload
    def date(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> 'JapaneseDate': ...
    @overload
    def dateEpochDay(self, long: int) -> ChronoLocalDate: ...
    @overload
    def dateEpochDay(self, long: int) -> 'JapaneseDate': ...
    @overload
    def dateNow(self) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, clock: java.time.Clock) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, zoneId: java.time.ZoneId) -> ChronoLocalDate: ...
    @overload
    def dateNow(self) -> 'JapaneseDate': ...
    @overload
    def dateNow(self, clock: java.time.Clock) -> 'JapaneseDate': ...
    @overload
    def dateNow(self, zoneId: java.time.ZoneId) -> 'JapaneseDate': ...
    @overload
    def dateYearDay(self, int: int, int2: int) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, era: Era, int: int, int2: int) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, int: int, int2: int) -> 'JapaneseDate': ...
    @overload
    def dateYearDay(self, era: Era, int: int, int2: int) -> 'JapaneseDate': ...
    @overload
    def eraOf(self, int: int) -> Era: ...
    @overload
    def eraOf(self, int: int) -> JapaneseEra: ...
    def eras(self) -> java.util.List[Era]: ...
    def getCalendarType(self) -> str: ...
    def getId(self) -> str: ...
    def isLeapYear(self, long: int) -> bool: ...
    def localDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDateTime['JapaneseDate']: ...
    def prolepticYear(self, era: Era, int: int) -> int: ...
    def range(self, chronoField: java.time.temporal.ChronoField) -> java.time.temporal.ValueRange: ...
    @overload
    def resolveDate(self, map: java.util.Map, resolverStyle: java.time.format.ResolverStyle) -> ChronoLocalDate: ...
    @overload
    def resolveDate(self, map: java.util.Map[java.time.temporal.TemporalField, int], resolverStyle: java.time.format.ResolverStyle) -> 'JapaneseDate': ...
    @overload
    def zonedDateTime(self, instant: java.time.Instant, zoneId: java.time.ZoneId) -> ChronoZonedDateTime['JapaneseDate']: ...
    @overload
    def zonedDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoZonedDateTime['JapaneseDate']: ...

class JapaneseDate(ChronoLocalDateImpl['JapaneseDate'], ChronoLocalDate, java.io.Serializable):
    def atTime(self, localTime: java.time.LocalTime) -> ChronoLocalDateTime['JapaneseDate']: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getChronology(self) -> Chronology: ...
    @overload
    def getChronology(self) -> JapaneseChronology: ...
    @overload
    def getEra(self) -> Era: ...
    @overload
    def getEra(self) -> JapaneseEra: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def hashCode(self) -> int: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    def lengthOfMonth(self) -> int: ...
    def lengthOfYear(self) -> int: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoLocalDate: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> ChronoLocalDate: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'JapaneseDate': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'JapaneseDate': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    @classmethod
    @overload
    def now(cls) -> 'JapaneseDate': ...
    @classmethod
    @overload
    def now(cls, clock: java.time.Clock) -> 'JapaneseDate': ...
    @classmethod
    @overload
    def now(cls, zoneId: java.time.ZoneId) -> 'JapaneseDate': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int, int3: int) -> 'JapaneseDate': ...
    @classmethod
    @overload
    def of(cls, japaneseEra: JapaneseEra, int: int, int2: int, int3: int) -> 'JapaneseDate': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoLocalDate: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> ChronoLocalDate: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'JapaneseDate': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'JapaneseDate': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toEpochDay(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def until(self, chronoLocalDate: ChronoLocalDate) -> ChronoPeriod: ...
    @overload
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...

class MinguoChronology(AbstractChronology, java.io.Serializable):
    INSTANCE: _py_ClassVar['MinguoChronology'] = ...
    @overload
    def date(self, int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    @overload
    def date(self, era: Era, int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    @overload
    def date(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDate: ...
    @overload
    def date(self, int: int, int2: int, int3: int) -> 'MinguoDate': ...
    @overload
    def date(self, era: Era, int: int, int2: int, int3: int) -> 'MinguoDate': ...
    @overload
    def date(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> 'MinguoDate': ...
    @overload
    def dateEpochDay(self, long: int) -> ChronoLocalDate: ...
    @overload
    def dateEpochDay(self, long: int) -> 'MinguoDate': ...
    @overload
    def dateNow(self) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, clock: java.time.Clock) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, zoneId: java.time.ZoneId) -> ChronoLocalDate: ...
    @overload
    def dateNow(self) -> 'MinguoDate': ...
    @overload
    def dateNow(self, clock: java.time.Clock) -> 'MinguoDate': ...
    @overload
    def dateNow(self, zoneId: java.time.ZoneId) -> 'MinguoDate': ...
    @overload
    def dateYearDay(self, int: int, int2: int) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, era: Era, int: int, int2: int) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, int: int, int2: int) -> 'MinguoDate': ...
    @overload
    def dateYearDay(self, era: Era, int: int, int2: int) -> 'MinguoDate': ...
    @overload
    def eraOf(self, int: int) -> Era: ...
    @overload
    def eraOf(self, int: int) -> MinguoEra: ...
    def eras(self) -> java.util.List[Era]: ...
    def getCalendarType(self) -> str: ...
    def getId(self) -> str: ...
    def isLeapYear(self, long: int) -> bool: ...
    def localDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDateTime['MinguoDate']: ...
    def prolepticYear(self, era: Era, int: int) -> int: ...
    def range(self, chronoField: java.time.temporal.ChronoField) -> java.time.temporal.ValueRange: ...
    @overload
    def resolveDate(self, map: java.util.Map, resolverStyle: java.time.format.ResolverStyle) -> ChronoLocalDate: ...
    @overload
    def resolveDate(self, map: java.util.Map[java.time.temporal.TemporalField, int], resolverStyle: java.time.format.ResolverStyle) -> 'MinguoDate': ...
    @overload
    def zonedDateTime(self, instant: java.time.Instant, zoneId: java.time.ZoneId) -> ChronoZonedDateTime['MinguoDate']: ...
    @overload
    def zonedDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoZonedDateTime['MinguoDate']: ...

class MinguoDate(ChronoLocalDateImpl['MinguoDate'], ChronoLocalDate, java.io.Serializable):
    def atTime(self, localTime: java.time.LocalTime) -> ChronoLocalDateTime['MinguoDate']: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getChronology(self) -> Chronology: ...
    @overload
    def getChronology(self) -> MinguoChronology: ...
    @overload
    def getEra(self) -> Era: ...
    @overload
    def getEra(self) -> MinguoEra: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def hashCode(self) -> int: ...
    def lengthOfMonth(self) -> int: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoLocalDate: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> ChronoLocalDate: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'MinguoDate': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'MinguoDate': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    @classmethod
    @overload
    def now(cls) -> 'MinguoDate': ...
    @classmethod
    @overload
    def now(cls, clock: java.time.Clock) -> 'MinguoDate': ...
    @classmethod
    @overload
    def now(cls, zoneId: java.time.ZoneId) -> 'MinguoDate': ...
    @classmethod
    def of(cls, int: int, int2: int, int3: int) -> 'MinguoDate': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoLocalDate: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> ChronoLocalDate: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'MinguoDate': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'MinguoDate': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toEpochDay(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def until(self, chronoLocalDate: ChronoLocalDate) -> ChronoPeriod: ...
    @overload
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...

class ThaiBuddhistChronology(AbstractChronology, java.io.Serializable):
    INSTANCE: _py_ClassVar['ThaiBuddhistChronology'] = ...
    @overload
    def date(self, int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    @overload
    def date(self, era: Era, int: int, int2: int, int3: int) -> ChronoLocalDate: ...
    @overload
    def date(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDate: ...
    @overload
    def date(self, int: int, int2: int, int3: int) -> 'ThaiBuddhistDate': ...
    @overload
    def date(self, era: Era, int: int, int2: int, int3: int) -> 'ThaiBuddhistDate': ...
    @overload
    def date(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> 'ThaiBuddhistDate': ...
    @overload
    def dateEpochDay(self, long: int) -> ChronoLocalDate: ...
    @overload
    def dateEpochDay(self, long: int) -> 'ThaiBuddhistDate': ...
    @overload
    def dateNow(self) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, clock: java.time.Clock) -> ChronoLocalDate: ...
    @overload
    def dateNow(self, zoneId: java.time.ZoneId) -> ChronoLocalDate: ...
    @overload
    def dateNow(self) -> 'ThaiBuddhistDate': ...
    @overload
    def dateNow(self, clock: java.time.Clock) -> 'ThaiBuddhistDate': ...
    @overload
    def dateNow(self, zoneId: java.time.ZoneId) -> 'ThaiBuddhistDate': ...
    @overload
    def dateYearDay(self, int: int, int2: int) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, era: Era, int: int, int2: int) -> ChronoLocalDate: ...
    @overload
    def dateYearDay(self, int: int, int2: int) -> 'ThaiBuddhistDate': ...
    @overload
    def dateYearDay(self, era: Era, int: int, int2: int) -> 'ThaiBuddhistDate': ...
    @overload
    def eraOf(self, int: int) -> Era: ...
    @overload
    def eraOf(self, int: int) -> ThaiBuddhistEra: ...
    def eras(self) -> java.util.List[Era]: ...
    def getCalendarType(self) -> str: ...
    def getId(self) -> str: ...
    def isLeapYear(self, long: int) -> bool: ...
    def localDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoLocalDateTime['ThaiBuddhistDate']: ...
    def prolepticYear(self, era: Era, int: int) -> int: ...
    def range(self, chronoField: java.time.temporal.ChronoField) -> java.time.temporal.ValueRange: ...
    @overload
    def resolveDate(self, map: java.util.Map, resolverStyle: java.time.format.ResolverStyle) -> ChronoLocalDate: ...
    @overload
    def resolveDate(self, map: java.util.Map[java.time.temporal.TemporalField, int], resolverStyle: java.time.format.ResolverStyle) -> 'ThaiBuddhistDate': ...
    @overload
    def zonedDateTime(self, instant: java.time.Instant, zoneId: java.time.ZoneId) -> ChronoZonedDateTime['ThaiBuddhistDate']: ...
    @overload
    def zonedDateTime(self, temporalAccessor: java.time.temporal.TemporalAccessor) -> ChronoZonedDateTime['ThaiBuddhistDate']: ...

class ThaiBuddhistDate(ChronoLocalDateImpl['ThaiBuddhistDate'], ChronoLocalDate, java.io.Serializable):
    def atTime(self, localTime: java.time.LocalTime) -> ChronoLocalDateTime['ThaiBuddhistDate']: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getChronology(self) -> Chronology: ...
    @overload
    def getChronology(self) -> ThaiBuddhistChronology: ...
    @overload
    def getEra(self) -> Era: ...
    @overload
    def getEra(self) -> ThaiBuddhistEra: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def hashCode(self) -> int: ...
    def lengthOfMonth(self) -> int: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoLocalDate: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> ChronoLocalDate: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ThaiBuddhistDate': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ThaiBuddhistDate': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    @classmethod
    @overload
    def now(cls) -> 'ThaiBuddhistDate': ...
    @classmethod
    @overload
    def now(cls, clock: java.time.Clock) -> 'ThaiBuddhistDate': ...
    @classmethod
    @overload
    def now(cls, zoneId: java.time.ZoneId) -> 'ThaiBuddhistDate': ...
    @classmethod
    def of(cls, int: int, int2: int, int3: int) -> 'ThaiBuddhistDate': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> ChronoLocalDate: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> ChronoLocalDate: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ThaiBuddhistDate': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ThaiBuddhistDate': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toEpochDay(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def until(self, chronoLocalDate: ChronoLocalDate) -> ChronoPeriod: ...
    @overload
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
