from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.io
import java.lang
import java.math
import java.net
import java.security
import java.time
import java.util
import java.util.concurrent
import java.util.logging
import javax.xml.transform


class Array:
    def free(self) -> None: ...
    @overload
    def getArray(self) -> _py_Any: ...
    @overload
    def getArray(self, map: java.util.Map[str, _py_Type[_py_Any]]) -> _py_Any: ...
    @overload
    def getArray(self, long: int, int: int) -> _py_Any: ...
    @overload
    def getArray(self, long: int, int: int, map: java.util.Map[str, _py_Type[_py_Any]]) -> _py_Any: ...
    def getBaseType(self) -> int: ...
    def getBaseTypeName(self) -> str: ...
    @overload
    def getResultSet(self) -> 'ResultSet': ...
    @overload
    def getResultSet(self, map: java.util.Map[str, _py_Type[_py_Any]]) -> 'ResultSet': ...
    @overload
    def getResultSet(self, long: int, int: int) -> 'ResultSet': ...
    @overload
    def getResultSet(self, long: int, int: int, map: java.util.Map[str, _py_Type[_py_Any]]) -> 'ResultSet': ...

class Blob:
    def free(self) -> None: ...
    @overload
    def getBinaryStream(self) -> java.io.InputStream: ...
    @overload
    def getBinaryStream(self, long: int, long2: int) -> java.io.InputStream: ...
    def getBytes(self, long: int, int: int) -> _py_List[int]: ...
    def length(self) -> int: ...
    @overload
    def position(self, byteArray: _py_List[int], long: int) -> int: ...
    @overload
    def position(self, blob: 'Blob', long: int) -> int: ...
    def setBinaryStream(self, long: int) -> java.io.OutputStream: ...
    @overload
    def setBytes(self, long: int, byteArray: _py_List[int]) -> int: ...
    @overload
    def setBytes(self, long: int, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def truncate(self, long: int) -> None: ...

class ClientInfoStatus(java.lang.Enum['ClientInfoStatus']):
    REASON_UNKNOWN: _py_ClassVar['ClientInfoStatus'] = ...
    REASON_UNKNOWN_PROPERTY: _py_ClassVar['ClientInfoStatus'] = ...
    REASON_VALUE_INVALID: _py_ClassVar['ClientInfoStatus'] = ...
    REASON_VALUE_TRUNCATED: _py_ClassVar['ClientInfoStatus'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'ClientInfoStatus': ...
    @classmethod
    def values(cls) -> _py_List['ClientInfoStatus']: ...

class Clob:
    def free(self) -> None: ...
    def getAsciiStream(self) -> java.io.InputStream: ...
    @overload
    def getCharacterStream(self) -> java.io.Reader: ...
    @overload
    def getCharacterStream(self, long: int, long2: int) -> java.io.Reader: ...
    def getSubString(self, long: int, int: int) -> str: ...
    def length(self) -> int: ...
    @overload
    def position(self, string: str, long: int) -> int: ...
    @overload
    def position(self, clob: 'Clob', long: int) -> int: ...
    def setAsciiStream(self, long: int) -> java.io.OutputStream: ...
    def setCharacterStream(self, long: int) -> java.io.Writer: ...
    @overload
    def setString(self, long: int, string: str) -> int: ...
    @overload
    def setString(self, long: int, string: str, int: int, int2: int) -> int: ...
    def truncate(self, long: int) -> None: ...

class Date(java.util.Date):
    @overload
    def __init__(self, int: int, int2: int, int3: int): ...
    @overload
    def __init__(self, long: int): ...
    def getHours(self) -> int: ...
    def getMinutes(self) -> int: ...
    def getSeconds(self) -> int: ...
    def setHours(self, int: int) -> None: ...
    def setMinutes(self, int: int) -> None: ...
    def setSeconds(self, int: int) -> None: ...
    def setTime(self, long: int) -> None: ...
    def toInstant(self) -> java.time.Instant: ...
    def toLocalDate(self) -> java.time.LocalDate: ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'Date': ...
    @classmethod
    @overload
    def valueOf(cls, localDate: java.time.LocalDate) -> 'Date': ...

class Driver:
    def acceptsURL(self, string: str) -> bool: ...
    def connect(self, string: str, properties: java.util.Properties) -> 'Connection': ...
    def getMajorVersion(self) -> int: ...
    def getMinorVersion(self) -> int: ...
    def getParentLogger(self) -> java.util.logging.Logger: ...
    def getPropertyInfo(self, string: str, properties: java.util.Properties) -> _py_List['DriverPropertyInfo']: ...
    def jdbcCompliant(self) -> bool: ...

class DriverAction:
    def deregister(self) -> None: ...

class DriverInfo:
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class DriverManager:
    @classmethod
    def deregisterDriver(cls, driver: Driver) -> None: ...
    @classmethod
    @overload
    def getConnection(cls, string: str) -> 'Connection': ...
    @classmethod
    @overload
    def getConnection(cls, string: str, string2: str, string3: str) -> 'Connection': ...
    @classmethod
    @overload
    def getConnection(cls, string: str, properties: java.util.Properties) -> 'Connection': ...
    @classmethod
    def getDriver(cls, string: str) -> Driver: ...
    @classmethod
    def getDrivers(cls) -> java.util.Enumeration[Driver]: ...
    @classmethod
    def getLogStream(cls) -> java.io.PrintStream: ...
    @classmethod
    def getLogWriter(cls) -> java.io.PrintWriter: ...
    @classmethod
    def getLoginTimeout(cls) -> int: ...
    @classmethod
    def println(cls, string: str) -> None: ...
    @classmethod
    @overload
    def registerDriver(cls, driver: Driver) -> None: ...
    @classmethod
    @overload
    def registerDriver(cls, driver: Driver, driverAction: DriverAction) -> None: ...
    @classmethod
    def setLogStream(cls, printStream: java.io.PrintStream) -> None: ...
    @classmethod
    def setLogWriter(cls, printWriter: java.io.PrintWriter) -> None: ...
    @classmethod
    def setLoginTimeout(cls, int: int) -> None: ...

class DriverPropertyInfo:
    name: str = ...
    description: str = ...
    required: bool = ...
    value: str = ...
    choices: _py_List[str] = ...
    def __init__(self, string: str, string2: str): ...

class PseudoColumnUsage(java.lang.Enum['PseudoColumnUsage']):
    SELECT_LIST_ONLY: _py_ClassVar['PseudoColumnUsage'] = ...
    WHERE_CLAUSE_ONLY: _py_ClassVar['PseudoColumnUsage'] = ...
    NO_USAGE_RESTRICTIONS: _py_ClassVar['PseudoColumnUsage'] = ...
    USAGE_UNKNOWN: _py_ClassVar['PseudoColumnUsage'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'PseudoColumnUsage': ...
    @classmethod
    def values(cls) -> _py_List['PseudoColumnUsage']: ...

class Ref:
    def getBaseTypeName(self) -> str: ...
    @overload
    def getObject(self) -> _py_Any: ...
    @overload
    def getObject(self, map: java.util.Map[str, _py_Type[_py_Any]]) -> _py_Any: ...
    def setObject(self, object: _py_Any) -> None: ...

class RowId:
    def equals(self, object: _py_Any) -> bool: ...
    def getBytes(self) -> _py_List[int]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class RowIdLifetime(java.lang.Enum['RowIdLifetime']):
    ROWID_UNSUPPORTED: _py_ClassVar['RowIdLifetime'] = ...
    ROWID_VALID_OTHER: _py_ClassVar['RowIdLifetime'] = ...
    ROWID_VALID_SESSION: _py_ClassVar['RowIdLifetime'] = ...
    ROWID_VALID_TRANSACTION: _py_ClassVar['RowIdLifetime'] = ...
    ROWID_VALID_FOREVER: _py_ClassVar['RowIdLifetime'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'RowIdLifetime': ...
    @classmethod
    def values(cls) -> _py_List['RowIdLifetime']: ...

class SQLData:
    def getSQLTypeName(self) -> str: ...
    def readSQL(self, sQLInput: 'SQLInput', string: str) -> None: ...
    def writeSQL(self, sQLOutput: 'SQLOutput') -> None: ...

class SQLException(java.lang.Exception, java.lang.Iterable[java.lang.Throwable]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...
    def getErrorCode(self) -> int: ...
    def getNextException(self) -> 'SQLException': ...
    def getSQLState(self) -> str: ...
    def iterator(self) -> java.util.Iterator[java.lang.Throwable]: ...
    def setNextException(self, sQLException: 'SQLException') -> None: ...

class SQLInput:
    def readArray(self) -> Array: ...
    def readAsciiStream(self) -> java.io.InputStream: ...
    def readBigDecimal(self) -> java.math.BigDecimal: ...
    def readBinaryStream(self) -> java.io.InputStream: ...
    def readBlob(self) -> Blob: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readBytes(self) -> _py_List[int]: ...
    def readCharacterStream(self) -> java.io.Reader: ...
    def readClob(self) -> Clob: ...
    def readDate(self) -> Date: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    def readInt(self) -> int: ...
    def readLong(self) -> int: ...
    def readNClob(self) -> 'NClob': ...
    def readNString(self) -> str: ...
    @overload
    def readObject(self) -> _py_Any: ...
    _readObject_1__T = _py_TypeVar('_readObject_1__T')  # <T>
    @overload
    def readObject(self, class_: _py_Type[_readObject_1__T]) -> _readObject_1__T: ...
    def readRef(self) -> Ref: ...
    def readRowId(self) -> RowId: ...
    def readSQLXML(self) -> 'SQLXML': ...
    def readShort(self) -> int: ...
    def readString(self) -> str: ...
    def readTime(self) -> 'Time': ...
    def readTimestamp(self) -> 'Timestamp': ...
    def readURL(self) -> java.net.URL: ...
    def wasNull(self) -> bool: ...

class SQLOutput:
    def writeArray(self, array: Array) -> None: ...
    def writeAsciiStream(self, inputStream: java.io.InputStream) -> None: ...
    def writeBigDecimal(self, bigDecimal: java.math.BigDecimal) -> None: ...
    def writeBinaryStream(self, inputStream: java.io.InputStream) -> None: ...
    def writeBlob(self, blob: Blob) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, byte: int) -> None: ...
    def writeBytes(self, byteArray: _py_List[int]) -> None: ...
    def writeCharacterStream(self, reader: java.io.Reader) -> None: ...
    def writeClob(self, clob: Clob) -> None: ...
    def writeDate(self, date: Date) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeNClob(self, nClob: 'NClob') -> None: ...
    def writeNString(self, string: str) -> None: ...
    @overload
    def writeObject(self, sQLData: SQLData) -> None: ...
    @overload
    def writeObject(self, object: _py_Any, sQLType: 'SQLType') -> None: ...
    def writeRef(self, ref: Ref) -> None: ...
    def writeRowId(self, rowId: RowId) -> None: ...
    def writeSQLXML(self, sQLXML: 'SQLXML') -> None: ...
    def writeShort(self, short: int) -> None: ...
    def writeString(self, string: str) -> None: ...
    def writeStruct(self, struct: 'Struct') -> None: ...
    def writeTime(self, time: 'Time') -> None: ...
    def writeTimestamp(self, timestamp: 'Timestamp') -> None: ...
    def writeURL(self, uRL: java.net.URL) -> None: ...

class SQLPermission(java.security.BasicPermission):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...

class SQLType:
    def getName(self) -> str: ...
    def getVendor(self) -> str: ...
    def getVendorTypeNumber(self) -> int: ...

class SQLXML:
    def free(self) -> None: ...
    def getBinaryStream(self) -> java.io.InputStream: ...
    def getCharacterStream(self) -> java.io.Reader: ...
    _getSource__T = _py_TypeVar('_getSource__T', bound=javax.xml.transform.Source)  # <T>
    def getSource(self, class_: _py_Type[_getSource__T]) -> _getSource__T: ...
    def getString(self) -> str: ...
    def setBinaryStream(self) -> java.io.OutputStream: ...
    def setCharacterStream(self) -> java.io.Writer: ...
    _setResult__T = _py_TypeVar('_setResult__T', bound=javax.xml.transform.Result)  # <T>
    def setResult(self, class_: _py_Type[_setResult__T]) -> _setResult__T: ...
    def setString(self, string: str) -> None: ...

class Savepoint:
    def getSavepointId(self) -> int: ...
    def getSavepointName(self) -> str: ...

class Struct:
    @overload
    def getAttributes(self) -> _py_List[_py_Any]: ...
    @overload
    def getAttributes(self, map: java.util.Map[str, _py_Type[_py_Any]]) -> _py_List[_py_Any]: ...
    def getSQLTypeName(self) -> str: ...

class Time(java.util.Date):
    @overload
    def __init__(self, int: int, int2: int, int3: int): ...
    @overload
    def __init__(self, long: int): ...
    def getDate(self) -> int: ...
    def getDay(self) -> int: ...
    def getMonth(self) -> int: ...
    def getYear(self) -> int: ...
    def setDate(self, int: int) -> None: ...
    def setMonth(self, int: int) -> None: ...
    def setTime(self, long: int) -> None: ...
    def setYear(self, int: int) -> None: ...
    def toInstant(self) -> java.time.Instant: ...
    def toLocalTime(self) -> java.time.LocalTime: ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'Time': ...
    @classmethod
    @overload
    def valueOf(cls, localTime: java.time.LocalTime) -> 'Time': ...

class Timestamp(java.util.Date):
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int): ...
    @overload
    def __init__(self, long: int): ...
    @overload
    def after(self, timestamp: 'Timestamp') -> bool: ...
    @overload
    def after(self, date: java.util.Date) -> bool: ...
    @overload
    def before(self, timestamp: 'Timestamp') -> bool: ...
    @overload
    def before(self, date: java.util.Date) -> bool: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, timestamp: 'Timestamp') -> int: ...
    @overload
    def compareTo(self, date: java.util.Date) -> int: ...
    @overload
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def equals(self, timestamp: 'Timestamp') -> bool: ...
    def getNanos(self) -> int: ...
    def getTime(self) -> int: ...
    def hashCode(self) -> int: ...
    def setNanos(self, int: int) -> None: ...
    def setTime(self, long: int) -> None: ...
    def toInstant(self) -> java.time.Instant: ...
    def toLocalDateTime(self) -> java.time.LocalDateTime: ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'Timestamp': ...
    @classmethod
    @overload
    def valueOf(cls, localDateTime: java.time.LocalDateTime) -> 'Timestamp': ...

class Types:
    BIT: _py_ClassVar[int] = ...
    TINYINT: _py_ClassVar[int] = ...
    SMALLINT: _py_ClassVar[int] = ...
    INTEGER: _py_ClassVar[int] = ...
    BIGINT: _py_ClassVar[int] = ...
    FLOAT: _py_ClassVar[int] = ...
    REAL: _py_ClassVar[int] = ...
    DOUBLE: _py_ClassVar[int] = ...
    NUMERIC: _py_ClassVar[int] = ...
    DECIMAL: _py_ClassVar[int] = ...
    CHAR: _py_ClassVar[int] = ...
    VARCHAR: _py_ClassVar[int] = ...
    LONGVARCHAR: _py_ClassVar[int] = ...
    DATE: _py_ClassVar[int] = ...
    TIME: _py_ClassVar[int] = ...
    TIMESTAMP: _py_ClassVar[int] = ...
    BINARY: _py_ClassVar[int] = ...
    VARBINARY: _py_ClassVar[int] = ...
    LONGVARBINARY: _py_ClassVar[int] = ...
    NULL: _py_ClassVar[int] = ...
    OTHER: _py_ClassVar[int] = ...
    JAVA_OBJECT: _py_ClassVar[int] = ...
    DISTINCT: _py_ClassVar[int] = ...
    STRUCT: _py_ClassVar[int] = ...
    ARRAY: _py_ClassVar[int] = ...
    BLOB: _py_ClassVar[int] = ...
    CLOB: _py_ClassVar[int] = ...
    REF: _py_ClassVar[int] = ...
    DATALINK: _py_ClassVar[int] = ...
    BOOLEAN: _py_ClassVar[int] = ...
    ROWID: _py_ClassVar[int] = ...
    NCHAR: _py_ClassVar[int] = ...
    NVARCHAR: _py_ClassVar[int] = ...
    LONGNVARCHAR: _py_ClassVar[int] = ...
    NCLOB: _py_ClassVar[int] = ...
    SQLXML: _py_ClassVar[int] = ...
    REF_CURSOR: _py_ClassVar[int] = ...
    TIME_WITH_TIMEZONE: _py_ClassVar[int] = ...
    TIMESTAMP_WITH_TIMEZONE: _py_ClassVar[int] = ...

class Wrapper:
    def isWrapperFor(self, class_: _py_Type[_py_Any]) -> bool: ...
    _unwrap__T = _py_TypeVar('_unwrap__T')  # <T>
    def unwrap(self, class_: _py_Type[_unwrap__T]) -> _unwrap__T: ...

class BatchUpdateException(SQLException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, intArray: _py_List[int]): ...
    @overload
    def __init__(self, intArray: _py_List[int], throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, intArray: _py_List[int]): ...
    @overload
    def __init__(self, string: str, intArray: _py_List[int], throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, intArray: _py_List[int]): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, intArray: _py_List[int], throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, longArray: _py_List[int], throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, intArray: _py_List[int]): ...
    @overload
    def __init__(self, string: str, string2: str, intArray: _py_List[int], throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...
    def getLargeUpdateCounts(self) -> _py_List[int]: ...
    def getUpdateCounts(self) -> _py_List[int]: ...

class Connection(Wrapper, java.lang.AutoCloseable):
    TRANSACTION_NONE: _py_ClassVar[int] = ...
    TRANSACTION_READ_UNCOMMITTED: _py_ClassVar[int] = ...
    TRANSACTION_READ_COMMITTED: _py_ClassVar[int] = ...
    TRANSACTION_REPEATABLE_READ: _py_ClassVar[int] = ...
    TRANSACTION_SERIALIZABLE: _py_ClassVar[int] = ...
    def abort(self, executor: java.util.concurrent.Executor) -> None: ...
    def clearWarnings(self) -> None: ...
    def close(self) -> None: ...
    def commit(self) -> None: ...
    def createArrayOf(self, string: str, objectArray: _py_List[_py_Any]) -> Array: ...
    def createBlob(self) -> Blob: ...
    def createClob(self) -> Clob: ...
    def createNClob(self) -> 'NClob': ...
    def createSQLXML(self) -> SQLXML: ...
    @overload
    def createStatement(self) -> 'Statement': ...
    @overload
    def createStatement(self, int: int, int2: int) -> 'Statement': ...
    @overload
    def createStatement(self, int: int, int2: int, int3: int) -> 'Statement': ...
    def createStruct(self, string: str, objectArray: _py_List[_py_Any]) -> Struct: ...
    def getAutoCommit(self) -> bool: ...
    def getCatalog(self) -> str: ...
    @overload
    def getClientInfo(self, string: str) -> str: ...
    @overload
    def getClientInfo(self) -> java.util.Properties: ...
    def getHoldability(self) -> int: ...
    def getMetaData(self) -> 'DatabaseMetaData': ...
    def getNetworkTimeout(self) -> int: ...
    def getSchema(self) -> str: ...
    def getTransactionIsolation(self) -> int: ...
    def getTypeMap(self) -> java.util.Map[str, _py_Type[_py_Any]]: ...
    def getWarnings(self) -> 'SQLWarning': ...
    def isClosed(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def isValid(self, int: int) -> bool: ...
    def nativeSQL(self, string: str) -> str: ...
    @overload
    def prepareCall(self, string: str) -> 'CallableStatement': ...
    @overload
    def prepareCall(self, string: str, int: int, int2: int) -> 'CallableStatement': ...
    @overload
    def prepareCall(self, string: str, int: int, int2: int, int3: int) -> 'CallableStatement': ...
    @overload
    def prepareStatement(self, string: str) -> 'PreparedStatement': ...
    @overload
    def prepareStatement(self, string: str, int: int) -> 'PreparedStatement': ...
    @overload
    def prepareStatement(self, string: str, int: int, int2: int) -> 'PreparedStatement': ...
    @overload
    def prepareStatement(self, string: str, int: int, int2: int, int3: int) -> 'PreparedStatement': ...
    @overload
    def prepareStatement(self, string: str, intArray: _py_List[int]) -> 'PreparedStatement': ...
    @overload
    def prepareStatement(self, string: str, stringArray: _py_List[str]) -> 'PreparedStatement': ...
    def releaseSavepoint(self, savepoint: Savepoint) -> None: ...
    @overload
    def rollback(self) -> None: ...
    @overload
    def rollback(self, savepoint: Savepoint) -> None: ...
    def setAutoCommit(self, boolean: bool) -> None: ...
    def setCatalog(self, string: str) -> None: ...
    @overload
    def setClientInfo(self, string: str, string2: str) -> None: ...
    @overload
    def setClientInfo(self, properties: java.util.Properties) -> None: ...
    def setHoldability(self, int: int) -> None: ...
    def setNetworkTimeout(self, executor: java.util.concurrent.Executor, int: int) -> None: ...
    def setReadOnly(self, boolean: bool) -> None: ...
    @overload
    def setSavepoint(self) -> Savepoint: ...
    @overload
    def setSavepoint(self, string: str) -> Savepoint: ...
    def setSchema(self, string: str) -> None: ...
    def setTransactionIsolation(self, int: int) -> None: ...
    def setTypeMap(self, map: java.util.Map[str, _py_Type[_py_Any]]) -> None: ...

class DatabaseMetaData(Wrapper):
    procedureResultUnknown: _py_ClassVar[int] = ...
    procedureNoResult: _py_ClassVar[int] = ...
    procedureReturnsResult: _py_ClassVar[int] = ...
    procedureColumnUnknown: _py_ClassVar[int] = ...
    procedureColumnIn: _py_ClassVar[int] = ...
    procedureColumnInOut: _py_ClassVar[int] = ...
    procedureColumnOut: _py_ClassVar[int] = ...
    procedureColumnReturn: _py_ClassVar[int] = ...
    procedureColumnResult: _py_ClassVar[int] = ...
    procedureNoNulls: _py_ClassVar[int] = ...
    procedureNullable: _py_ClassVar[int] = ...
    procedureNullableUnknown: _py_ClassVar[int] = ...
    columnNoNulls: _py_ClassVar[int] = ...
    columnNullable: _py_ClassVar[int] = ...
    columnNullableUnknown: _py_ClassVar[int] = ...
    bestRowTemporary: _py_ClassVar[int] = ...
    bestRowTransaction: _py_ClassVar[int] = ...
    bestRowSession: _py_ClassVar[int] = ...
    bestRowUnknown: _py_ClassVar[int] = ...
    bestRowNotPseudo: _py_ClassVar[int] = ...
    bestRowPseudo: _py_ClassVar[int] = ...
    versionColumnUnknown: _py_ClassVar[int] = ...
    versionColumnNotPseudo: _py_ClassVar[int] = ...
    versionColumnPseudo: _py_ClassVar[int] = ...
    importedKeyCascade: _py_ClassVar[int] = ...
    importedKeyRestrict: _py_ClassVar[int] = ...
    importedKeySetNull: _py_ClassVar[int] = ...
    importedKeyNoAction: _py_ClassVar[int] = ...
    importedKeySetDefault: _py_ClassVar[int] = ...
    importedKeyInitiallyDeferred: _py_ClassVar[int] = ...
    importedKeyInitiallyImmediate: _py_ClassVar[int] = ...
    importedKeyNotDeferrable: _py_ClassVar[int] = ...
    typeNoNulls: _py_ClassVar[int] = ...
    typeNullable: _py_ClassVar[int] = ...
    typeNullableUnknown: _py_ClassVar[int] = ...
    typePredNone: _py_ClassVar[int] = ...
    typePredChar: _py_ClassVar[int] = ...
    typePredBasic: _py_ClassVar[int] = ...
    typeSearchable: _py_ClassVar[int] = ...
    tableIndexStatistic: _py_ClassVar[int] = ...
    tableIndexClustered: _py_ClassVar[int] = ...
    tableIndexHashed: _py_ClassVar[int] = ...
    tableIndexOther: _py_ClassVar[int] = ...
    attributeNoNulls: _py_ClassVar[int] = ...
    attributeNullable: _py_ClassVar[int] = ...
    attributeNullableUnknown: _py_ClassVar[int] = ...
    sqlStateXOpen: _py_ClassVar[int] = ...
    sqlStateSQL: _py_ClassVar[int] = ...
    sqlStateSQL99: _py_ClassVar[int] = ...
    functionColumnUnknown: _py_ClassVar[int] = ...
    functionColumnIn: _py_ClassVar[int] = ...
    functionColumnInOut: _py_ClassVar[int] = ...
    functionColumnOut: _py_ClassVar[int] = ...
    functionReturn: _py_ClassVar[int] = ...
    functionColumnResult: _py_ClassVar[int] = ...
    functionNoNulls: _py_ClassVar[int] = ...
    functionNullable: _py_ClassVar[int] = ...
    functionNullableUnknown: _py_ClassVar[int] = ...
    functionResultUnknown: _py_ClassVar[int] = ...
    functionNoTable: _py_ClassVar[int] = ...
    functionReturnsTable: _py_ClassVar[int] = ...
    def allProceduresAreCallable(self) -> bool: ...
    def allTablesAreSelectable(self) -> bool: ...
    def autoCommitFailureClosesAllResultSets(self) -> bool: ...
    def dataDefinitionCausesTransactionCommit(self) -> bool: ...
    def dataDefinitionIgnoredInTransactions(self) -> bool: ...
    def deletesAreDetected(self, int: int) -> bool: ...
    def doesMaxRowSizeIncludeBlobs(self) -> bool: ...
    def generatedKeyAlwaysReturned(self) -> bool: ...
    def getAttributes(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getBestRowIdentifier(self, string: str, string2: str, string3: str, int: int, boolean: bool) -> 'ResultSet': ...
    def getCatalogSeparator(self) -> str: ...
    def getCatalogTerm(self) -> str: ...
    def getCatalogs(self) -> 'ResultSet': ...
    def getClientInfoProperties(self) -> 'ResultSet': ...
    def getColumnPrivileges(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getColumns(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getConnection(self) -> Connection: ...
    def getCrossReference(self, string: str, string2: str, string3: str, string4: str, string5: str, string6: str) -> 'ResultSet': ...
    def getDatabaseMajorVersion(self) -> int: ...
    def getDatabaseMinorVersion(self) -> int: ...
    def getDatabaseProductName(self) -> str: ...
    def getDatabaseProductVersion(self) -> str: ...
    def getDefaultTransactionIsolation(self) -> int: ...
    def getDriverMajorVersion(self) -> int: ...
    def getDriverMinorVersion(self) -> int: ...
    def getDriverName(self) -> str: ...
    def getDriverVersion(self) -> str: ...
    def getExportedKeys(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getExtraNameCharacters(self) -> str: ...
    def getFunctionColumns(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getFunctions(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getIdentifierQuoteString(self) -> str: ...
    def getImportedKeys(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getIndexInfo(self, string: str, string2: str, string3: str, boolean: bool, boolean2: bool) -> 'ResultSet': ...
    def getJDBCMajorVersion(self) -> int: ...
    def getJDBCMinorVersion(self) -> int: ...
    def getMaxBinaryLiteralLength(self) -> int: ...
    def getMaxCatalogNameLength(self) -> int: ...
    def getMaxCharLiteralLength(self) -> int: ...
    def getMaxColumnNameLength(self) -> int: ...
    def getMaxColumnsInGroupBy(self) -> int: ...
    def getMaxColumnsInIndex(self) -> int: ...
    def getMaxColumnsInOrderBy(self) -> int: ...
    def getMaxColumnsInSelect(self) -> int: ...
    def getMaxColumnsInTable(self) -> int: ...
    def getMaxConnections(self) -> int: ...
    def getMaxCursorNameLength(self) -> int: ...
    def getMaxIndexLength(self) -> int: ...
    def getMaxLogicalLobSize(self) -> int: ...
    def getMaxProcedureNameLength(self) -> int: ...
    def getMaxRowSize(self) -> int: ...
    def getMaxSchemaNameLength(self) -> int: ...
    def getMaxStatementLength(self) -> int: ...
    def getMaxStatements(self) -> int: ...
    def getMaxTableNameLength(self) -> int: ...
    def getMaxTablesInSelect(self) -> int: ...
    def getMaxUserNameLength(self) -> int: ...
    def getNumericFunctions(self) -> str: ...
    def getPrimaryKeys(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getProcedureColumns(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getProcedureTerm(self) -> str: ...
    def getProcedures(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getPseudoColumns(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getResultSetHoldability(self) -> int: ...
    def getRowIdLifetime(self) -> RowIdLifetime: ...
    def getSQLKeywords(self) -> str: ...
    def getSQLStateType(self) -> int: ...
    def getSchemaTerm(self) -> str: ...
    @overload
    def getSchemas(self) -> 'ResultSet': ...
    @overload
    def getSchemas(self, string: str, string2: str) -> 'ResultSet': ...
    def getSearchStringEscape(self) -> str: ...
    def getStringFunctions(self) -> str: ...
    def getSuperTables(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getSuperTypes(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getSystemFunctions(self) -> str: ...
    def getTablePrivileges(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getTableTypes(self) -> 'ResultSet': ...
    def getTables(self, string: str, string2: str, string3: str, stringArray: _py_List[str]) -> 'ResultSet': ...
    def getTimeDateFunctions(self) -> str: ...
    def getTypeInfo(self) -> 'ResultSet': ...
    def getUDTs(self, string: str, string2: str, string3: str, intArray: _py_List[int]) -> 'ResultSet': ...
    def getURL(self) -> str: ...
    def getUserName(self) -> str: ...
    def getVersionColumns(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def insertsAreDetected(self, int: int) -> bool: ...
    def isCatalogAtStart(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def locatorsUpdateCopy(self) -> bool: ...
    def nullPlusNonNullIsNull(self) -> bool: ...
    def nullsAreSortedAtEnd(self) -> bool: ...
    def nullsAreSortedAtStart(self) -> bool: ...
    def nullsAreSortedHigh(self) -> bool: ...
    def nullsAreSortedLow(self) -> bool: ...
    def othersDeletesAreVisible(self, int: int) -> bool: ...
    def othersInsertsAreVisible(self, int: int) -> bool: ...
    def othersUpdatesAreVisible(self, int: int) -> bool: ...
    def ownDeletesAreVisible(self, int: int) -> bool: ...
    def ownInsertsAreVisible(self, int: int) -> bool: ...
    def ownUpdatesAreVisible(self, int: int) -> bool: ...
    def storesLowerCaseIdentifiers(self) -> bool: ...
    def storesLowerCaseQuotedIdentifiers(self) -> bool: ...
    def storesMixedCaseIdentifiers(self) -> bool: ...
    def storesMixedCaseQuotedIdentifiers(self) -> bool: ...
    def storesUpperCaseIdentifiers(self) -> bool: ...
    def storesUpperCaseQuotedIdentifiers(self) -> bool: ...
    def supportsANSI92EntryLevelSQL(self) -> bool: ...
    def supportsANSI92FullSQL(self) -> bool: ...
    def supportsANSI92IntermediateSQL(self) -> bool: ...
    def supportsAlterTableWithAddColumn(self) -> bool: ...
    def supportsAlterTableWithDropColumn(self) -> bool: ...
    def supportsBatchUpdates(self) -> bool: ...
    def supportsCatalogsInDataManipulation(self) -> bool: ...
    def supportsCatalogsInIndexDefinitions(self) -> bool: ...
    def supportsCatalogsInPrivilegeDefinitions(self) -> bool: ...
    def supportsCatalogsInProcedureCalls(self) -> bool: ...
    def supportsCatalogsInTableDefinitions(self) -> bool: ...
    def supportsColumnAliasing(self) -> bool: ...
    @overload
    def supportsConvert(self) -> bool: ...
    @overload
    def supportsConvert(self, int: int, int2: int) -> bool: ...
    def supportsCoreSQLGrammar(self) -> bool: ...
    def supportsCorrelatedSubqueries(self) -> bool: ...
    def supportsDataDefinitionAndDataManipulationTransactions(self) -> bool: ...
    def supportsDataManipulationTransactionsOnly(self) -> bool: ...
    def supportsDifferentTableCorrelationNames(self) -> bool: ...
    def supportsExpressionsInOrderBy(self) -> bool: ...
    def supportsExtendedSQLGrammar(self) -> bool: ...
    def supportsFullOuterJoins(self) -> bool: ...
    def supportsGetGeneratedKeys(self) -> bool: ...
    def supportsGroupBy(self) -> bool: ...
    def supportsGroupByBeyondSelect(self) -> bool: ...
    def supportsGroupByUnrelated(self) -> bool: ...
    def supportsIntegrityEnhancementFacility(self) -> bool: ...
    def supportsLikeEscapeClause(self) -> bool: ...
    def supportsLimitedOuterJoins(self) -> bool: ...
    def supportsMinimumSQLGrammar(self) -> bool: ...
    def supportsMixedCaseIdentifiers(self) -> bool: ...
    def supportsMixedCaseQuotedIdentifiers(self) -> bool: ...
    def supportsMultipleOpenResults(self) -> bool: ...
    def supportsMultipleResultSets(self) -> bool: ...
    def supportsMultipleTransactions(self) -> bool: ...
    def supportsNamedParameters(self) -> bool: ...
    def supportsNonNullableColumns(self) -> bool: ...
    def supportsOpenCursorsAcrossCommit(self) -> bool: ...
    def supportsOpenCursorsAcrossRollback(self) -> bool: ...
    def supportsOpenStatementsAcrossCommit(self) -> bool: ...
    def supportsOpenStatementsAcrossRollback(self) -> bool: ...
    def supportsOrderByUnrelated(self) -> bool: ...
    def supportsOuterJoins(self) -> bool: ...
    def supportsPositionedDelete(self) -> bool: ...
    def supportsPositionedUpdate(self) -> bool: ...
    def supportsRefCursors(self) -> bool: ...
    def supportsResultSetConcurrency(self, int: int, int2: int) -> bool: ...
    def supportsResultSetHoldability(self, int: int) -> bool: ...
    def supportsResultSetType(self, int: int) -> bool: ...
    def supportsSavepoints(self) -> bool: ...
    def supportsSchemasInDataManipulation(self) -> bool: ...
    def supportsSchemasInIndexDefinitions(self) -> bool: ...
    def supportsSchemasInPrivilegeDefinitions(self) -> bool: ...
    def supportsSchemasInProcedureCalls(self) -> bool: ...
    def supportsSchemasInTableDefinitions(self) -> bool: ...
    def supportsSelectForUpdate(self) -> bool: ...
    def supportsStatementPooling(self) -> bool: ...
    def supportsStoredFunctionsUsingCallSyntax(self) -> bool: ...
    def supportsStoredProcedures(self) -> bool: ...
    def supportsSubqueriesInComparisons(self) -> bool: ...
    def supportsSubqueriesInExists(self) -> bool: ...
    def supportsSubqueriesInIns(self) -> bool: ...
    def supportsSubqueriesInQuantifieds(self) -> bool: ...
    def supportsTableCorrelationNames(self) -> bool: ...
    def supportsTransactionIsolationLevel(self, int: int) -> bool: ...
    def supportsTransactions(self) -> bool: ...
    def supportsUnion(self) -> bool: ...
    def supportsUnionAll(self) -> bool: ...
    def updatesAreDetected(self, int: int) -> bool: ...
    def usesLocalFilePerTable(self) -> bool: ...
    def usesLocalFiles(self) -> bool: ...

class JDBCType(java.lang.Enum['JDBCType'], SQLType):
    BIT: _py_ClassVar['JDBCType'] = ...
    TINYINT: _py_ClassVar['JDBCType'] = ...
    SMALLINT: _py_ClassVar['JDBCType'] = ...
    INTEGER: _py_ClassVar['JDBCType'] = ...
    BIGINT: _py_ClassVar['JDBCType'] = ...
    FLOAT: _py_ClassVar['JDBCType'] = ...
    REAL: _py_ClassVar['JDBCType'] = ...
    DOUBLE: _py_ClassVar['JDBCType'] = ...
    NUMERIC: _py_ClassVar['JDBCType'] = ...
    DECIMAL: _py_ClassVar['JDBCType'] = ...
    CHAR: _py_ClassVar['JDBCType'] = ...
    VARCHAR: _py_ClassVar['JDBCType'] = ...
    LONGVARCHAR: _py_ClassVar['JDBCType'] = ...
    DATE: _py_ClassVar['JDBCType'] = ...
    TIME: _py_ClassVar['JDBCType'] = ...
    TIMESTAMP: _py_ClassVar['JDBCType'] = ...
    BINARY: _py_ClassVar['JDBCType'] = ...
    VARBINARY: _py_ClassVar['JDBCType'] = ...
    LONGVARBINARY: _py_ClassVar['JDBCType'] = ...
    NULL: _py_ClassVar['JDBCType'] = ...
    OTHER: _py_ClassVar['JDBCType'] = ...
    JAVA_OBJECT: _py_ClassVar['JDBCType'] = ...
    DISTINCT: _py_ClassVar['JDBCType'] = ...
    STRUCT: _py_ClassVar['JDBCType'] = ...
    ARRAY: _py_ClassVar['JDBCType'] = ...
    BLOB: _py_ClassVar['JDBCType'] = ...
    CLOB: _py_ClassVar['JDBCType'] = ...
    REF: _py_ClassVar['JDBCType'] = ...
    DATALINK: _py_ClassVar['JDBCType'] = ...
    BOOLEAN: _py_ClassVar['JDBCType'] = ...
    ROWID: _py_ClassVar['JDBCType'] = ...
    NCHAR: _py_ClassVar['JDBCType'] = ...
    NVARCHAR: _py_ClassVar['JDBCType'] = ...
    LONGNVARCHAR: _py_ClassVar['JDBCType'] = ...
    NCLOB: _py_ClassVar['JDBCType'] = ...
    SQLXML: _py_ClassVar['JDBCType'] = ...
    REF_CURSOR: _py_ClassVar['JDBCType'] = ...
    TIME_WITH_TIMEZONE: _py_ClassVar['JDBCType'] = ...
    TIMESTAMP_WITH_TIMEZONE: _py_ClassVar['JDBCType'] = ...
    def getName(self) -> str: ...
    def getVendor(self) -> str: ...
    def getVendorTypeNumber(self) -> int: ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, int: int) -> 'JDBCType': ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'JDBCType': ...
    @classmethod
    def values(cls) -> _py_List['JDBCType']: ...

class NClob(Clob): ...

class ParameterMetaData(Wrapper):
    parameterNoNulls: _py_ClassVar[int] = ...
    parameterNullable: _py_ClassVar[int] = ...
    parameterNullableUnknown: _py_ClassVar[int] = ...
    parameterModeUnknown: _py_ClassVar[int] = ...
    parameterModeIn: _py_ClassVar[int] = ...
    parameterModeInOut: _py_ClassVar[int] = ...
    parameterModeOut: _py_ClassVar[int] = ...
    def getParameterClassName(self, int: int) -> str: ...
    def getParameterCount(self) -> int: ...
    def getParameterMode(self, int: int) -> int: ...
    def getParameterType(self, int: int) -> int: ...
    def getParameterTypeName(self, int: int) -> str: ...
    def getPrecision(self, int: int) -> int: ...
    def getScale(self, int: int) -> int: ...
    def isNullable(self, int: int) -> int: ...
    def isSigned(self, int: int) -> bool: ...

class ResultSet(Wrapper, java.lang.AutoCloseable):
    FETCH_FORWARD: _py_ClassVar[int] = ...
    FETCH_REVERSE: _py_ClassVar[int] = ...
    FETCH_UNKNOWN: _py_ClassVar[int] = ...
    TYPE_FORWARD_ONLY: _py_ClassVar[int] = ...
    TYPE_SCROLL_INSENSITIVE: _py_ClassVar[int] = ...
    TYPE_SCROLL_SENSITIVE: _py_ClassVar[int] = ...
    CONCUR_READ_ONLY: _py_ClassVar[int] = ...
    CONCUR_UPDATABLE: _py_ClassVar[int] = ...
    HOLD_CURSORS_OVER_COMMIT: _py_ClassVar[int] = ...
    CLOSE_CURSORS_AT_COMMIT: _py_ClassVar[int] = ...
    def absolute(self, int: int) -> bool: ...
    def afterLast(self) -> None: ...
    def beforeFirst(self) -> None: ...
    def cancelRowUpdates(self) -> None: ...
    def clearWarnings(self) -> None: ...
    def close(self) -> None: ...
    def deleteRow(self) -> None: ...
    def findColumn(self, string: str) -> int: ...
    def first(self) -> bool: ...
    @overload
    def getArray(self, int: int) -> Array: ...
    @overload
    def getArray(self, string: str) -> Array: ...
    @overload
    def getAsciiStream(self, int: int) -> java.io.InputStream: ...
    @overload
    def getAsciiStream(self, string: str) -> java.io.InputStream: ...
    @overload
    def getBigDecimal(self, int: int) -> java.math.BigDecimal: ...
    @overload
    def getBigDecimal(self, int: int, int2: int) -> java.math.BigDecimal: ...
    @overload
    def getBigDecimal(self, string: str) -> java.math.BigDecimal: ...
    @overload
    def getBigDecimal(self, string: str, int: int) -> java.math.BigDecimal: ...
    @overload
    def getBinaryStream(self, int: int) -> java.io.InputStream: ...
    @overload
    def getBinaryStream(self, string: str) -> java.io.InputStream: ...
    @overload
    def getBlob(self, int: int) -> Blob: ...
    @overload
    def getBlob(self, string: str) -> Blob: ...
    @overload
    def getBoolean(self, int: int) -> bool: ...
    @overload
    def getBoolean(self, string: str) -> bool: ...
    @overload
    def getByte(self, int: int) -> int: ...
    @overload
    def getByte(self, string: str) -> int: ...
    @overload
    def getBytes(self, int: int) -> _py_List[int]: ...
    @overload
    def getBytes(self, string: str) -> _py_List[int]: ...
    @overload
    def getCharacterStream(self, int: int) -> java.io.Reader: ...
    @overload
    def getCharacterStream(self, string: str) -> java.io.Reader: ...
    @overload
    def getClob(self, int: int) -> Clob: ...
    @overload
    def getClob(self, string: str) -> Clob: ...
    def getConcurrency(self) -> int: ...
    def getCursorName(self) -> str: ...
    @overload
    def getDate(self, int: int) -> Date: ...
    @overload
    def getDate(self, int: int, calendar: java.util.Calendar) -> Date: ...
    @overload
    def getDate(self, string: str) -> Date: ...
    @overload
    def getDate(self, string: str, calendar: java.util.Calendar) -> Date: ...
    @overload
    def getDouble(self, int: int) -> float: ...
    @overload
    def getDouble(self, string: str) -> float: ...
    def getFetchDirection(self) -> int: ...
    def getFetchSize(self) -> int: ...
    @overload
    def getFloat(self, int: int) -> float: ...
    @overload
    def getFloat(self, string: str) -> float: ...
    def getHoldability(self) -> int: ...
    @overload
    def getInt(self, int: int) -> int: ...
    @overload
    def getInt(self, string: str) -> int: ...
    @overload
    def getLong(self, int: int) -> int: ...
    @overload
    def getLong(self, string: str) -> int: ...
    def getMetaData(self) -> 'ResultSetMetaData': ...
    @overload
    def getNCharacterStream(self, int: int) -> java.io.Reader: ...
    @overload
    def getNCharacterStream(self, string: str) -> java.io.Reader: ...
    @overload
    def getNClob(self, int: int) -> NClob: ...
    @overload
    def getNClob(self, string: str) -> NClob: ...
    @overload
    def getNString(self, int: int) -> str: ...
    @overload
    def getNString(self, string: str) -> str: ...
    @overload
    def getObject(self, int: int) -> _py_Any: ...
    _getObject_1__T = _py_TypeVar('_getObject_1__T')  # <T>
    @overload
    def getObject(self, int: int, class_: _py_Type[_getObject_1__T]) -> _getObject_1__T: ...
    @overload
    def getObject(self, int: int, map: java.util.Map[str, _py_Type[_py_Any]]) -> _py_Any: ...
    @overload
    def getObject(self, string: str) -> _py_Any: ...
    _getObject_4__T = _py_TypeVar('_getObject_4__T')  # <T>
    @overload
    def getObject(self, string: str, class_: _py_Type[_getObject_4__T]) -> _getObject_4__T: ...
    @overload
    def getObject(self, string: str, map: java.util.Map[str, _py_Type[_py_Any]]) -> _py_Any: ...
    @overload
    def getRef(self, int: int) -> Ref: ...
    @overload
    def getRef(self, string: str) -> Ref: ...
    def getRow(self) -> int: ...
    @overload
    def getRowId(self, int: int) -> RowId: ...
    @overload
    def getRowId(self, string: str) -> RowId: ...
    @overload
    def getSQLXML(self, int: int) -> SQLXML: ...
    @overload
    def getSQLXML(self, string: str) -> SQLXML: ...
    @overload
    def getShort(self, int: int) -> int: ...
    @overload
    def getShort(self, string: str) -> int: ...
    def getStatement(self) -> 'Statement': ...
    @overload
    def getString(self, int: int) -> str: ...
    @overload
    def getString(self, string: str) -> str: ...
    @overload
    def getTime(self, int: int) -> Time: ...
    @overload
    def getTime(self, int: int, calendar: java.util.Calendar) -> Time: ...
    @overload
    def getTime(self, string: str) -> Time: ...
    @overload
    def getTime(self, string: str, calendar: java.util.Calendar) -> Time: ...
    @overload
    def getTimestamp(self, int: int) -> Timestamp: ...
    @overload
    def getTimestamp(self, int: int, calendar: java.util.Calendar) -> Timestamp: ...
    @overload
    def getTimestamp(self, string: str) -> Timestamp: ...
    @overload
    def getTimestamp(self, string: str, calendar: java.util.Calendar) -> Timestamp: ...
    def getType(self) -> int: ...
    @overload
    def getURL(self, int: int) -> java.net.URL: ...
    @overload
    def getURL(self, string: str) -> java.net.URL: ...
    @overload
    def getUnicodeStream(self, int: int) -> java.io.InputStream: ...
    @overload
    def getUnicodeStream(self, string: str) -> java.io.InputStream: ...
    def getWarnings(self) -> 'SQLWarning': ...
    def insertRow(self) -> None: ...
    def isAfterLast(self) -> bool: ...
    def isBeforeFirst(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def isFirst(self) -> bool: ...
    def isLast(self) -> bool: ...
    def last(self) -> bool: ...
    def moveToCurrentRow(self) -> None: ...
    def moveToInsertRow(self) -> None: ...
    def next(self) -> bool: ...
    def previous(self) -> bool: ...
    def refreshRow(self) -> None: ...
    def relative(self, int: int) -> bool: ...
    def rowDeleted(self) -> bool: ...
    def rowInserted(self) -> bool: ...
    def rowUpdated(self) -> bool: ...
    def setFetchDirection(self, int: int) -> None: ...
    def setFetchSize(self, int: int) -> None: ...
    @overload
    def updateArray(self, int: int, array: Array) -> None: ...
    @overload
    def updateArray(self, string: str, array: Array) -> None: ...
    @overload
    def updateAsciiStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @overload
    def updateAsciiStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @overload
    def updateAsciiStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def updateAsciiStream(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @overload
    def updateAsciiStream(self, string: str, inputStream: java.io.InputStream, int: int) -> None: ...
    @overload
    def updateAsciiStream(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def updateBigDecimal(self, int: int, bigDecimal: java.math.BigDecimal) -> None: ...
    @overload
    def updateBigDecimal(self, string: str, bigDecimal: java.math.BigDecimal) -> None: ...
    @overload
    def updateBinaryStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @overload
    def updateBinaryStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @overload
    def updateBinaryStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def updateBinaryStream(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @overload
    def updateBinaryStream(self, string: str, inputStream: java.io.InputStream, int: int) -> None: ...
    @overload
    def updateBinaryStream(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def updateBlob(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @overload
    def updateBlob(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def updateBlob(self, int: int, blob: Blob) -> None: ...
    @overload
    def updateBlob(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @overload
    def updateBlob(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def updateBlob(self, string: str, blob: Blob) -> None: ...
    @overload
    def updateBoolean(self, int: int, boolean: bool) -> None: ...
    @overload
    def updateBoolean(self, string: str, boolean: bool) -> None: ...
    @overload
    def updateByte(self, int: int, byte: int) -> None: ...
    @overload
    def updateByte(self, string: str, byte: int) -> None: ...
    @overload
    def updateBytes(self, int: int, byteArray: _py_List[int]) -> None: ...
    @overload
    def updateBytes(self, string: str, byteArray: _py_List[int]) -> None: ...
    @overload
    def updateCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def updateCharacterStream(self, int: int, reader: java.io.Reader, int2: int) -> None: ...
    @overload
    def updateCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def updateCharacterStream(self, string: str, reader: java.io.Reader) -> None: ...
    @overload
    def updateCharacterStream(self, string: str, reader: java.io.Reader, int: int) -> None: ...
    @overload
    def updateCharacterStream(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def updateClob(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def updateClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def updateClob(self, int: int, clob: Clob) -> None: ...
    @overload
    def updateClob(self, string: str, reader: java.io.Reader) -> None: ...
    @overload
    def updateClob(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def updateClob(self, string: str, clob: Clob) -> None: ...
    @overload
    def updateDate(self, int: int, date: Date) -> None: ...
    @overload
    def updateDate(self, string: str, date: Date) -> None: ...
    @overload
    def updateDouble(self, int: int, double: float) -> None: ...
    @overload
    def updateDouble(self, string: str, double: float) -> None: ...
    @overload
    def updateFloat(self, int: int, float: float) -> None: ...
    @overload
    def updateFloat(self, string: str, float: float) -> None: ...
    @overload
    def updateInt(self, int: int, int2: int) -> None: ...
    @overload
    def updateInt(self, string: str, int: int) -> None: ...
    @overload
    def updateLong(self, int: int, long: int) -> None: ...
    @overload
    def updateLong(self, string: str, long: int) -> None: ...
    @overload
    def updateNCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def updateNCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def updateNCharacterStream(self, string: str, reader: java.io.Reader) -> None: ...
    @overload
    def updateNCharacterStream(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def updateNClob(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def updateNClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def updateNClob(self, int: int, nClob: NClob) -> None: ...
    @overload
    def updateNClob(self, string: str, reader: java.io.Reader) -> None: ...
    @overload
    def updateNClob(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def updateNClob(self, string: str, nClob: NClob) -> None: ...
    @overload
    def updateNString(self, int: int, string: str) -> None: ...
    @overload
    def updateNString(self, string: str, string2: str) -> None: ...
    @overload
    def updateNull(self, int: int) -> None: ...
    @overload
    def updateNull(self, string: str) -> None: ...
    @overload
    def updateObject(self, int: int, object: _py_Any) -> None: ...
    @overload
    def updateObject(self, int: int, object: _py_Any, int2: int) -> None: ...
    @overload
    def updateObject(self, string: str, object: _py_Any) -> None: ...
    @overload
    def updateObject(self, string: str, object: _py_Any, int: int) -> None: ...
    @overload
    def updateObject(self, int: int, object: _py_Any, sQLType: SQLType) -> None: ...
    @overload
    def updateObject(self, int: int, object: _py_Any, sQLType: SQLType, int2: int) -> None: ...
    @overload
    def updateObject(self, string: str, object: _py_Any, sQLType: SQLType) -> None: ...
    @overload
    def updateObject(self, string: str, object: _py_Any, sQLType: SQLType, int: int) -> None: ...
    @overload
    def updateRef(self, int: int, ref: Ref) -> None: ...
    @overload
    def updateRef(self, string: str, ref: Ref) -> None: ...
    def updateRow(self) -> None: ...
    @overload
    def updateRowId(self, int: int, rowId: RowId) -> None: ...
    @overload
    def updateRowId(self, string: str, rowId: RowId) -> None: ...
    @overload
    def updateSQLXML(self, int: int, sQLXML: SQLXML) -> None: ...
    @overload
    def updateSQLXML(self, string: str, sQLXML: SQLXML) -> None: ...
    @overload
    def updateShort(self, int: int, short: int) -> None: ...
    @overload
    def updateShort(self, string: str, short: int) -> None: ...
    @overload
    def updateString(self, int: int, string: str) -> None: ...
    @overload
    def updateString(self, string: str, string2: str) -> None: ...
    @overload
    def updateTime(self, int: int, time: Time) -> None: ...
    @overload
    def updateTime(self, string: str, time: Time) -> None: ...
    @overload
    def updateTimestamp(self, int: int, timestamp: Timestamp) -> None: ...
    @overload
    def updateTimestamp(self, string: str, timestamp: Timestamp) -> None: ...
    def wasNull(self) -> bool: ...

class ResultSetMetaData(Wrapper):
    columnNoNulls: _py_ClassVar[int] = ...
    columnNullable: _py_ClassVar[int] = ...
    columnNullableUnknown: _py_ClassVar[int] = ...
    def getCatalogName(self, int: int) -> str: ...
    def getColumnClassName(self, int: int) -> str: ...
    def getColumnCount(self) -> int: ...
    def getColumnDisplaySize(self, int: int) -> int: ...
    def getColumnLabel(self, int: int) -> str: ...
    def getColumnName(self, int: int) -> str: ...
    def getColumnType(self, int: int) -> int: ...
    def getColumnTypeName(self, int: int) -> str: ...
    def getPrecision(self, int: int) -> int: ...
    def getScale(self, int: int) -> int: ...
    def getSchemaName(self, int: int) -> str: ...
    def getTableName(self, int: int) -> str: ...
    def isAutoIncrement(self, int: int) -> bool: ...
    def isCaseSensitive(self, int: int) -> bool: ...
    def isCurrency(self, int: int) -> bool: ...
    def isDefinitelyWritable(self, int: int) -> bool: ...
    def isNullable(self, int: int) -> int: ...
    def isReadOnly(self, int: int) -> bool: ...
    def isSearchable(self, int: int) -> bool: ...
    def isSigned(self, int: int) -> bool: ...
    def isWritable(self, int: int) -> bool: ...

class SQLClientInfoException(SQLException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, map: java.util.Map[str, ClientInfoStatus]): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, map: java.util.Map[str, ClientInfoStatus], throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, map: java.util.Map[str, ClientInfoStatus]): ...
    @overload
    def __init__(self, string: str, string2: str, map: java.util.Map[str, ClientInfoStatus], throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, map: java.util.Map[str, ClientInfoStatus]): ...
    @overload
    def __init__(self, string: str, map: java.util.Map[str, ClientInfoStatus], throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, map: java.util.Map[str, ClientInfoStatus]): ...
    @overload
    def __init__(self, map: java.util.Map[str, ClientInfoStatus], throwable: java.lang.Throwable): ...
    def getFailedProperties(self) -> java.util.Map[str, ClientInfoStatus]: ...

class SQLNonTransientException(SQLException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLRecoverableException(SQLException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLTransientException(SQLException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLWarning(SQLException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...
    def getNextWarning(self) -> 'SQLWarning': ...
    def setNextWarning(self, sQLWarning: 'SQLWarning') -> None: ...

class Statement(Wrapper, java.lang.AutoCloseable):
    CLOSE_CURRENT_RESULT: _py_ClassVar[int] = ...
    KEEP_CURRENT_RESULT: _py_ClassVar[int] = ...
    CLOSE_ALL_RESULTS: _py_ClassVar[int] = ...
    SUCCESS_NO_INFO: _py_ClassVar[int] = ...
    EXECUTE_FAILED: _py_ClassVar[int] = ...
    RETURN_GENERATED_KEYS: _py_ClassVar[int] = ...
    NO_GENERATED_KEYS: _py_ClassVar[int] = ...
    def addBatch(self, string: str) -> None: ...
    def cancel(self) -> None: ...
    def clearBatch(self) -> None: ...
    def clearWarnings(self) -> None: ...
    def close(self) -> None: ...
    def closeOnCompletion(self) -> None: ...
    @overload
    def execute(self, string: str) -> bool: ...
    @overload
    def execute(self, string: str, int: int) -> bool: ...
    @overload
    def execute(self, string: str, intArray: _py_List[int]) -> bool: ...
    @overload
    def execute(self, string: str, stringArray: _py_List[str]) -> bool: ...
    def executeBatch(self) -> _py_List[int]: ...
    def executeLargeBatch(self) -> _py_List[int]: ...
    @overload
    def executeLargeUpdate(self, string: str) -> int: ...
    @overload
    def executeLargeUpdate(self, string: str, int: int) -> int: ...
    @overload
    def executeLargeUpdate(self, string: str, intArray: _py_List[int]) -> int: ...
    @overload
    def executeLargeUpdate(self, string: str, stringArray: _py_List[str]) -> int: ...
    def executeQuery(self, string: str) -> ResultSet: ...
    @overload
    def executeUpdate(self, string: str) -> int: ...
    @overload
    def executeUpdate(self, string: str, int: int) -> int: ...
    @overload
    def executeUpdate(self, string: str, intArray: _py_List[int]) -> int: ...
    @overload
    def executeUpdate(self, string: str, stringArray: _py_List[str]) -> int: ...
    def getConnection(self) -> Connection: ...
    def getFetchDirection(self) -> int: ...
    def getFetchSize(self) -> int: ...
    def getGeneratedKeys(self) -> ResultSet: ...
    def getLargeMaxRows(self) -> int: ...
    def getLargeUpdateCount(self) -> int: ...
    def getMaxFieldSize(self) -> int: ...
    def getMaxRows(self) -> int: ...
    @overload
    def getMoreResults(self) -> bool: ...
    @overload
    def getMoreResults(self, int: int) -> bool: ...
    def getQueryTimeout(self) -> int: ...
    def getResultSet(self) -> ResultSet: ...
    def getResultSetConcurrency(self) -> int: ...
    def getResultSetHoldability(self) -> int: ...
    def getResultSetType(self) -> int: ...
    def getUpdateCount(self) -> int: ...
    def getWarnings(self) -> SQLWarning: ...
    def isCloseOnCompletion(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def isPoolable(self) -> bool: ...
    def setCursorName(self, string: str) -> None: ...
    def setEscapeProcessing(self, boolean: bool) -> None: ...
    def setFetchDirection(self, int: int) -> None: ...
    def setFetchSize(self, int: int) -> None: ...
    def setLargeMaxRows(self, long: int) -> None: ...
    def setMaxFieldSize(self, int: int) -> None: ...
    def setMaxRows(self, int: int) -> None: ...
    def setPoolable(self, boolean: bool) -> None: ...
    def setQueryTimeout(self, int: int) -> None: ...

class DataTruncation(SQLWarning):
    @overload
    def __init__(self, int: int, boolean: bool, boolean2: bool, int2: int, int3: int): ...
    @overload
    def __init__(self, int: int, boolean: bool, boolean2: bool, int2: int, int3: int, throwable: java.lang.Throwable): ...
    def getDataSize(self) -> int: ...
    def getIndex(self) -> int: ...
    def getParameter(self) -> bool: ...
    def getRead(self) -> bool: ...
    def getTransferSize(self) -> int: ...

class PreparedStatement(Statement):
    @overload
    def addBatch(self) -> None: ...
    @overload
    def addBatch(self, string: str) -> None: ...
    def clearParameters(self) -> None: ...
    @overload
    def execute(self) -> bool: ...
    @overload
    def execute(self, string: str) -> bool: ...
    @overload
    def execute(self, string: str, int: int) -> bool: ...
    @overload
    def execute(self, string: str, intArray: _py_List[int]) -> bool: ...
    @overload
    def execute(self, string: str, stringArray: _py_List[str]) -> bool: ...
    @overload
    def executeLargeUpdate(self) -> int: ...
    @overload
    def executeLargeUpdate(self, string: str) -> int: ...
    @overload
    def executeLargeUpdate(self, string: str, int: int) -> int: ...
    @overload
    def executeLargeUpdate(self, string: str, intArray: _py_List[int]) -> int: ...
    @overload
    def executeLargeUpdate(self, string: str, stringArray: _py_List[str]) -> int: ...
    @overload
    def executeQuery(self) -> ResultSet: ...
    @overload
    def executeQuery(self, string: str) -> ResultSet: ...
    @overload
    def executeUpdate(self) -> int: ...
    @overload
    def executeUpdate(self, string: str) -> int: ...
    @overload
    def executeUpdate(self, string: str, int: int) -> int: ...
    @overload
    def executeUpdate(self, string: str, intArray: _py_List[int]) -> int: ...
    @overload
    def executeUpdate(self, string: str, stringArray: _py_List[str]) -> int: ...
    def getMetaData(self) -> ResultSetMetaData: ...
    def getParameterMetaData(self) -> ParameterMetaData: ...
    def setArray(self, int: int, array: Array) -> None: ...
    @overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    def setBigDecimal(self, int: int, bigDecimal: java.math.BigDecimal) -> None: ...
    @overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def setBlob(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @overload
    def setBlob(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def setBlob(self, int: int, blob: Blob) -> None: ...
    def setBoolean(self, int: int, boolean: bool) -> None: ...
    def setByte(self, int: int, byte: int) -> None: ...
    def setBytes(self, int: int, byteArray: _py_List[int]) -> None: ...
    @overload
    def setCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def setCharacterStream(self, int: int, reader: java.io.Reader, int2: int) -> None: ...
    @overload
    def setCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setClob(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def setClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setClob(self, int: int, clob: Clob) -> None: ...
    @overload
    def setDate(self, int: int, date: Date) -> None: ...
    @overload
    def setDate(self, int: int, date: Date, calendar: java.util.Calendar) -> None: ...
    def setDouble(self, int: int, double: float) -> None: ...
    def setFloat(self, int: int, float: float) -> None: ...
    def setInt(self, int: int, int2: int) -> None: ...
    def setLong(self, int: int, long: int) -> None: ...
    @overload
    def setNCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def setNCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setNClob(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def setNClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setNClob(self, int: int, nClob: NClob) -> None: ...
    def setNString(self, int: int, string: str) -> None: ...
    @overload
    def setNull(self, int: int, int2: int) -> None: ...
    @overload
    def setNull(self, int: int, int2: int, string: str) -> None: ...
    @overload
    def setObject(self, int: int, object: _py_Any) -> None: ...
    @overload
    def setObject(self, int: int, object: _py_Any, int2: int) -> None: ...
    @overload
    def setObject(self, int: int, object: _py_Any, int2: int, int3: int) -> None: ...
    @overload
    def setObject(self, int: int, object: _py_Any, sQLType: SQLType) -> None: ...
    @overload
    def setObject(self, int: int, object: _py_Any, sQLType: SQLType, int2: int) -> None: ...
    def setRef(self, int: int, ref: Ref) -> None: ...
    def setRowId(self, int: int, rowId: RowId) -> None: ...
    def setSQLXML(self, int: int, sQLXML: SQLXML) -> None: ...
    def setShort(self, int: int, short: int) -> None: ...
    def setString(self, int: int, string: str) -> None: ...
    @overload
    def setTime(self, int: int, time: Time) -> None: ...
    @overload
    def setTime(self, int: int, time: Time, calendar: java.util.Calendar) -> None: ...
    @overload
    def setTimestamp(self, int: int, timestamp: Timestamp) -> None: ...
    @overload
    def setTimestamp(self, int: int, timestamp: Timestamp, calendar: java.util.Calendar) -> None: ...
    def setURL(self, int: int, uRL: java.net.URL) -> None: ...
    def setUnicodeStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...

class SQLDataException(SQLNonTransientException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLFeatureNotSupportedException(SQLNonTransientException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLIntegrityConstraintViolationException(SQLNonTransientException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLInvalidAuthorizationSpecException(SQLNonTransientException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLNonTransientConnectionException(SQLNonTransientException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLSyntaxErrorException(SQLNonTransientException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLTimeoutException(SQLTransientException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLTransactionRollbackException(SQLTransientException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLTransientConnectionException(SQLTransientException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class CallableStatement(PreparedStatement):
    @overload
    def getArray(self, int: int) -> Array: ...
    @overload
    def getArray(self, string: str) -> Array: ...
    @overload
    def getBigDecimal(self, int: int) -> java.math.BigDecimal: ...
    @overload
    def getBigDecimal(self, int: int, int2: int) -> java.math.BigDecimal: ...
    @overload
    def getBigDecimal(self, string: str) -> java.math.BigDecimal: ...
    @overload
    def getBlob(self, int: int) -> Blob: ...
    @overload
    def getBlob(self, string: str) -> Blob: ...
    @overload
    def getBoolean(self, int: int) -> bool: ...
    @overload
    def getBoolean(self, string: str) -> bool: ...
    @overload
    def getByte(self, int: int) -> int: ...
    @overload
    def getByte(self, string: str) -> int: ...
    @overload
    def getBytes(self, int: int) -> _py_List[int]: ...
    @overload
    def getBytes(self, string: str) -> _py_List[int]: ...
    @overload
    def getCharacterStream(self, int: int) -> java.io.Reader: ...
    @overload
    def getCharacterStream(self, string: str) -> java.io.Reader: ...
    @overload
    def getClob(self, int: int) -> Clob: ...
    @overload
    def getClob(self, string: str) -> Clob: ...
    @overload
    def getDate(self, int: int) -> Date: ...
    @overload
    def getDate(self, int: int, calendar: java.util.Calendar) -> Date: ...
    @overload
    def getDate(self, string: str) -> Date: ...
    @overload
    def getDate(self, string: str, calendar: java.util.Calendar) -> Date: ...
    @overload
    def getDouble(self, int: int) -> float: ...
    @overload
    def getDouble(self, string: str) -> float: ...
    @overload
    def getFloat(self, int: int) -> float: ...
    @overload
    def getFloat(self, string: str) -> float: ...
    @overload
    def getInt(self, int: int) -> int: ...
    @overload
    def getInt(self, string: str) -> int: ...
    @overload
    def getLong(self, int: int) -> int: ...
    @overload
    def getLong(self, string: str) -> int: ...
    @overload
    def getNCharacterStream(self, int: int) -> java.io.Reader: ...
    @overload
    def getNCharacterStream(self, string: str) -> java.io.Reader: ...
    @overload
    def getNClob(self, int: int) -> NClob: ...
    @overload
    def getNClob(self, string: str) -> NClob: ...
    @overload
    def getNString(self, int: int) -> str: ...
    @overload
    def getNString(self, string: str) -> str: ...
    @overload
    def getObject(self, int: int) -> _py_Any: ...
    _getObject_1__T = _py_TypeVar('_getObject_1__T')  # <T>
    @overload
    def getObject(self, int: int, class_: _py_Type[_getObject_1__T]) -> _getObject_1__T: ...
    @overload
    def getObject(self, int: int, map: java.util.Map[str, _py_Type[_py_Any]]) -> _py_Any: ...
    @overload
    def getObject(self, string: str) -> _py_Any: ...
    _getObject_4__T = _py_TypeVar('_getObject_4__T')  # <T>
    @overload
    def getObject(self, string: str, class_: _py_Type[_getObject_4__T]) -> _getObject_4__T: ...
    @overload
    def getObject(self, string: str, map: java.util.Map[str, _py_Type[_py_Any]]) -> _py_Any: ...
    @overload
    def getRef(self, int: int) -> Ref: ...
    @overload
    def getRef(self, string: str) -> Ref: ...
    @overload
    def getRowId(self, int: int) -> RowId: ...
    @overload
    def getRowId(self, string: str) -> RowId: ...
    @overload
    def getSQLXML(self, int: int) -> SQLXML: ...
    @overload
    def getSQLXML(self, string: str) -> SQLXML: ...
    @overload
    def getShort(self, int: int) -> int: ...
    @overload
    def getShort(self, string: str) -> int: ...
    @overload
    def getString(self, int: int) -> str: ...
    @overload
    def getString(self, string: str) -> str: ...
    @overload
    def getTime(self, int: int) -> Time: ...
    @overload
    def getTime(self, int: int, calendar: java.util.Calendar) -> Time: ...
    @overload
    def getTime(self, string: str) -> Time: ...
    @overload
    def getTime(self, string: str, calendar: java.util.Calendar) -> Time: ...
    @overload
    def getTimestamp(self, int: int) -> Timestamp: ...
    @overload
    def getTimestamp(self, int: int, calendar: java.util.Calendar) -> Timestamp: ...
    @overload
    def getTimestamp(self, string: str) -> Timestamp: ...
    @overload
    def getTimestamp(self, string: str, calendar: java.util.Calendar) -> Timestamp: ...
    @overload
    def getURL(self, int: int) -> java.net.URL: ...
    @overload
    def getURL(self, string: str) -> java.net.URL: ...
    @overload
    def registerOutParameter(self, int: int, int2: int) -> None: ...
    @overload
    def registerOutParameter(self, int: int, int2: int, int3: int) -> None: ...
    @overload
    def registerOutParameter(self, int: int, int2: int, string: str) -> None: ...
    @overload
    def registerOutParameter(self, string: str, int: int) -> None: ...
    @overload
    def registerOutParameter(self, string: str, int: int, int2: int) -> None: ...
    @overload
    def registerOutParameter(self, string: str, int: int, string2: str) -> None: ...
    @overload
    def registerOutParameter(self, int: int, sQLType: SQLType) -> None: ...
    @overload
    def registerOutParameter(self, int: int, sQLType: SQLType, int2: int) -> None: ...
    @overload
    def registerOutParameter(self, int: int, sQLType: SQLType, string: str) -> None: ...
    @overload
    def registerOutParameter(self, string: str, sQLType: SQLType) -> None: ...
    @overload
    def registerOutParameter(self, string: str, sQLType: SQLType, int: int) -> None: ...
    @overload
    def registerOutParameter(self, string: str, sQLType: SQLType, string2: str) -> None: ...
    @overload
    def setAsciiStream(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @overload
    def setAsciiStream(self, string: str, inputStream: java.io.InputStream, int: int) -> None: ...
    @overload
    def setAsciiStream(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def setBigDecimal(self, string: str, bigDecimal: java.math.BigDecimal) -> None: ...
    @overload
    def setBigDecimal(self, int: int, bigDecimal: java.math.BigDecimal) -> None: ...
    @overload
    def setBinaryStream(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @overload
    def setBinaryStream(self, string: str, inputStream: java.io.InputStream, int: int) -> None: ...
    @overload
    def setBinaryStream(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def setBlob(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @overload
    def setBlob(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def setBlob(self, string: str, blob: Blob) -> None: ...
    @overload
    def setBlob(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @overload
    def setBlob(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @overload
    def setBlob(self, int: int, blob: Blob) -> None: ...
    @overload
    def setBoolean(self, string: str, boolean: bool) -> None: ...
    @overload
    def setBoolean(self, int: int, boolean: bool) -> None: ...
    @overload
    def setByte(self, string: str, byte: int) -> None: ...
    @overload
    def setByte(self, int: int, byte: int) -> None: ...
    @overload
    def setBytes(self, string: str, byteArray: _py_List[int]) -> None: ...
    @overload
    def setBytes(self, int: int, byteArray: _py_List[int]) -> None: ...
    @overload
    def setCharacterStream(self, string: str, reader: java.io.Reader) -> None: ...
    @overload
    def setCharacterStream(self, string: str, reader: java.io.Reader, int: int) -> None: ...
    @overload
    def setCharacterStream(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def setCharacterStream(self, int: int, reader: java.io.Reader, int2: int) -> None: ...
    @overload
    def setCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setClob(self, string: str, reader: java.io.Reader) -> None: ...
    @overload
    def setClob(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setClob(self, string: str, clob: Clob) -> None: ...
    @overload
    def setClob(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def setClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setClob(self, int: int, clob: Clob) -> None: ...
    @overload
    def setDate(self, string: str, date: Date) -> None: ...
    @overload
    def setDate(self, string: str, date: Date, calendar: java.util.Calendar) -> None: ...
    @overload
    def setDate(self, int: int, date: Date) -> None: ...
    @overload
    def setDate(self, int: int, date: Date, calendar: java.util.Calendar) -> None: ...
    @overload
    def setDouble(self, string: str, double: float) -> None: ...
    @overload
    def setDouble(self, int: int, double: float) -> None: ...
    @overload
    def setFloat(self, string: str, float: float) -> None: ...
    @overload
    def setFloat(self, int: int, float: float) -> None: ...
    @overload
    def setInt(self, string: str, int: int) -> None: ...
    @overload
    def setInt(self, int: int, int2: int) -> None: ...
    @overload
    def setLong(self, string: str, long: int) -> None: ...
    @overload
    def setLong(self, int: int, long: int) -> None: ...
    @overload
    def setNCharacterStream(self, string: str, reader: java.io.Reader) -> None: ...
    @overload
    def setNCharacterStream(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setNCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def setNCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setNClob(self, string: str, reader: java.io.Reader) -> None: ...
    @overload
    def setNClob(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setNClob(self, string: str, nClob: NClob) -> None: ...
    @overload
    def setNClob(self, int: int, reader: java.io.Reader) -> None: ...
    @overload
    def setNClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @overload
    def setNClob(self, int: int, nClob: NClob) -> None: ...
    @overload
    def setNString(self, string: str, string2: str) -> None: ...
    @overload
    def setNString(self, int: int, string: str) -> None: ...
    @overload
    def setNull(self, string: str, int: int) -> None: ...
    @overload
    def setNull(self, string: str, int: int, string2: str) -> None: ...
    @overload
    def setNull(self, int: int, int2: int) -> None: ...
    @overload
    def setNull(self, int: int, int2: int, string: str) -> None: ...
    @overload
    def setObject(self, string: str, object: _py_Any) -> None: ...
    @overload
    def setObject(self, string: str, object: _py_Any, int: int) -> None: ...
    @overload
    def setObject(self, string: str, object: _py_Any, int: int, int2: int) -> None: ...
    @overload
    def setObject(self, int: int, object: _py_Any) -> None: ...
    @overload
    def setObject(self, int: int, object: _py_Any, int2: int) -> None: ...
    @overload
    def setObject(self, int: int, object: _py_Any, int2: int, int3: int) -> None: ...
    @overload
    def setObject(self, string: str, object: _py_Any, sQLType: SQLType) -> None: ...
    @overload
    def setObject(self, string: str, object: _py_Any, sQLType: SQLType, int: int) -> None: ...
    @overload
    def setObject(self, int: int, object: _py_Any, sQLType: SQLType) -> None: ...
    @overload
    def setObject(self, int: int, object: _py_Any, sQLType: SQLType, int2: int) -> None: ...
    @overload
    def setRowId(self, string: str, rowId: RowId) -> None: ...
    @overload
    def setRowId(self, int: int, rowId: RowId) -> None: ...
    @overload
    def setSQLXML(self, string: str, sQLXML: SQLXML) -> None: ...
    @overload
    def setSQLXML(self, int: int, sQLXML: SQLXML) -> None: ...
    @overload
    def setShort(self, string: str, short: int) -> None: ...
    @overload
    def setShort(self, int: int, short: int) -> None: ...
    @overload
    def setString(self, string: str, string2: str) -> None: ...
    @overload
    def setString(self, int: int, string: str) -> None: ...
    @overload
    def setTime(self, string: str, time: Time) -> None: ...
    @overload
    def setTime(self, string: str, time: Time, calendar: java.util.Calendar) -> None: ...
    @overload
    def setTime(self, int: int, time: Time) -> None: ...
    @overload
    def setTime(self, int: int, time: Time, calendar: java.util.Calendar) -> None: ...
    @overload
    def setTimestamp(self, string: str, timestamp: Timestamp) -> None: ...
    @overload
    def setTimestamp(self, string: str, timestamp: Timestamp, calendar: java.util.Calendar) -> None: ...
    @overload
    def setTimestamp(self, int: int, timestamp: Timestamp) -> None: ...
    @overload
    def setTimestamp(self, int: int, timestamp: Timestamp, calendar: java.util.Calendar) -> None: ...
    @overload
    def setURL(self, string: str, uRL: java.net.URL) -> None: ...
    @overload
    def setURL(self, int: int, uRL: java.net.URL) -> None: ...
    def wasNull(self) -> bool: ...
