from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import java
import java.io
import java.lang
import java.net
import java.nio
import java.security.cert
import java.security.spec
import java.util
import java.util.function
import javax.crypto
import javax.security.auth
import javax.security.auth.callback
import javax.security.auth.login


class AccessControlContext:
    @overload
    def __init__(self, accessControlContext: 'AccessControlContext', domainCombiner: 'DomainCombiner'): ...
    @overload
    def __init__(self, protectionDomainArray: _py_List['ProtectionDomain']): ...
    def checkPermission(self, permission: 'Permission') -> None: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDomainCombiner(self) -> 'DomainCombiner': ...
    def hashCode(self) -> int: ...

class AccessControlException(java.lang.SecurityException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, permission: 'Permission'): ...
    def getPermission(self) -> 'Permission': ...

class AccessController:
    @classmethod
    def checkPermission(cls, permission: 'Permission') -> None: ...
    _doPrivileged_0__T = _py_TypeVar('_doPrivileged_0__T')  # <T>
    @classmethod
    @overload
    def doPrivileged(cls, privilegedAction: 'PrivilegedAction'[_doPrivileged_0__T], accessControlContext: AccessControlContext, permissionArray: _py_List['Permission']) -> _doPrivileged_0__T: ...
    _doPrivileged_1__T = _py_TypeVar('_doPrivileged_1__T')  # <T>
    @classmethod
    @overload
    def doPrivileged(cls, privilegedExceptionAction: 'PrivilegedExceptionAction'[_doPrivileged_1__T], accessControlContext: AccessControlContext, permissionArray: _py_List['Permission']) -> _doPrivileged_1__T: ...
    _doPrivileged_2__T = _py_TypeVar('_doPrivileged_2__T')  # <T>
    @classmethod
    @overload
    def doPrivileged(cls, privilegedAction: 'PrivilegedAction'[_doPrivileged_2__T]) -> _doPrivileged_2__T: ...
    _doPrivileged_3__T = _py_TypeVar('_doPrivileged_3__T')  # <T>
    @classmethod
    @overload
    def doPrivileged(cls, privilegedAction: 'PrivilegedAction'[_doPrivileged_3__T], accessControlContext: AccessControlContext) -> _doPrivileged_3__T: ...
    _doPrivileged_4__T = _py_TypeVar('_doPrivileged_4__T')  # <T>
    @classmethod
    @overload
    def doPrivileged(cls, privilegedExceptionAction: 'PrivilegedExceptionAction'[_doPrivileged_4__T]) -> _doPrivileged_4__T: ...
    _doPrivileged_5__T = _py_TypeVar('_doPrivileged_5__T')  # <T>
    @classmethod
    @overload
    def doPrivileged(cls, privilegedExceptionAction: 'PrivilegedExceptionAction'[_doPrivileged_5__T], accessControlContext: AccessControlContext) -> _doPrivileged_5__T: ...
    _doPrivilegedWithCombiner_0__T = _py_TypeVar('_doPrivilegedWithCombiner_0__T')  # <T>
    @classmethod
    @overload
    def doPrivilegedWithCombiner(cls, privilegedAction: 'PrivilegedAction'[_doPrivilegedWithCombiner_0__T]) -> _doPrivilegedWithCombiner_0__T: ...
    _doPrivilegedWithCombiner_1__T = _py_TypeVar('_doPrivilegedWithCombiner_1__T')  # <T>
    @classmethod
    @overload
    def doPrivilegedWithCombiner(cls, privilegedAction: 'PrivilegedAction'[_doPrivilegedWithCombiner_1__T], accessControlContext: AccessControlContext, permissionArray: _py_List['Permission']) -> _doPrivilegedWithCombiner_1__T: ...
    _doPrivilegedWithCombiner_2__T = _py_TypeVar('_doPrivilegedWithCombiner_2__T')  # <T>
    @classmethod
    @overload
    def doPrivilegedWithCombiner(cls, privilegedExceptionAction: 'PrivilegedExceptionAction'[_doPrivilegedWithCombiner_2__T]) -> _doPrivilegedWithCombiner_2__T: ...
    _doPrivilegedWithCombiner_3__T = _py_TypeVar('_doPrivilegedWithCombiner_3__T')  # <T>
    @classmethod
    @overload
    def doPrivilegedWithCombiner(cls, privilegedExceptionAction: 'PrivilegedExceptionAction'[_doPrivilegedWithCombiner_3__T], accessControlContext: AccessControlContext, permissionArray: _py_List['Permission']) -> _doPrivilegedWithCombiner_3__T: ...
    @classmethod
    def getContext(cls) -> AccessControlContext: ...

class AlgorithmConstraints:
    @overload
    def permits(self, set: java.util.Set['CryptoPrimitive'], string: str, algorithmParameters: 'AlgorithmParameters') -> bool: ...
    @overload
    def permits(self, set: java.util.Set['CryptoPrimitive'], string: str, key: 'Key', algorithmParameters: 'AlgorithmParameters') -> bool: ...
    @overload
    def permits(self, set: java.util.Set['CryptoPrimitive'], key: 'Key') -> bool: ...

class AlgorithmParameterGenerator:
    def generateParameters(self) -> 'AlgorithmParameters': ...
    def getAlgorithm(self) -> str: ...
    @classmethod
    @overload
    def getInstance(cls, string: str) -> 'AlgorithmParameterGenerator': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, string2: str) -> 'AlgorithmParameterGenerator': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, provider: 'Provider') -> 'AlgorithmParameterGenerator': ...
    def getProvider(self) -> 'Provider': ...
    @overload
    def init(self, int: int) -> None: ...
    @overload
    def init(self, int: int, secureRandom: 'SecureRandom') -> None: ...
    @overload
    def init(self, algorithmParameterSpec: java.security.spec.AlgorithmParameterSpec) -> None: ...
    @overload
    def init(self, algorithmParameterSpec: java.security.spec.AlgorithmParameterSpec, secureRandom: 'SecureRandom') -> None: ...

class AlgorithmParameterGeneratorSpi:
    def __init__(self): ...

class AlgorithmParameters:
    def getAlgorithm(self) -> str: ...
    @overload
    def getEncoded(self) -> _py_List[int]: ...
    @overload
    def getEncoded(self, string: str) -> _py_List[int]: ...
    @classmethod
    @overload
    def getInstance(cls, string: str) -> 'AlgorithmParameters': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, string2: str) -> 'AlgorithmParameters': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, provider: 'Provider') -> 'AlgorithmParameters': ...
    _getParameterSpec__T = _py_TypeVar('_getParameterSpec__T', bound=java.security.spec.AlgorithmParameterSpec)  # <T>
    def getParameterSpec(self, class_: _py_Type[_getParameterSpec__T]) -> _getParameterSpec__T: ...
    def getProvider(self) -> 'Provider': ...
    @overload
    def init(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def init(self, byteArray: _py_List[int], string: str) -> None: ...
    @overload
    def init(self, algorithmParameterSpec: java.security.spec.AlgorithmParameterSpec) -> None: ...
    def toString(self) -> str: ...

class AlgorithmParametersSpi:
    def __init__(self): ...

class Certificate:
    def decode(self, inputStream: java.io.InputStream) -> None: ...
    def encode(self, outputStream: java.io.OutputStream) -> None: ...
    def getFormat(self) -> str: ...
    def getGuarantor(self) -> 'Principal': ...
    def getPrincipal(self) -> 'Principal': ...
    def getPublicKey(self) -> 'PublicKey': ...
    def toString(self, boolean: bool) -> str: ...

class CodeSigner(java.io.Serializable):
    def __init__(self, certPath: java.security.cert.CertPath, timestamp: 'Timestamp'): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getSignerCertPath(self) -> java.security.cert.CertPath: ...
    def getTimestamp(self) -> 'Timestamp': ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class CodeSource(java.io.Serializable):
    @overload
    def __init__(self, uRL: java.net.URL, codeSignerArray: _py_List[CodeSigner]): ...
    @overload
    def __init__(self, uRL: java.net.URL, certificateArray: _py_List[java.security.cert.Certificate]): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getCertificates(self) -> _py_List[java.security.cert.Certificate]: ...
    def getCodeSigners(self) -> _py_List[CodeSigner]: ...
    def getLocation(self) -> java.net.URL: ...
    def hashCode(self) -> int: ...
    def implies(self, codeSource: 'CodeSource') -> bool: ...
    def toString(self) -> str: ...

class CryptoPrimitive(java.lang.Enum['CryptoPrimitive']):
    MESSAGE_DIGEST: _py_ClassVar['CryptoPrimitive'] = ...
    SECURE_RANDOM: _py_ClassVar['CryptoPrimitive'] = ...
    BLOCK_CIPHER: _py_ClassVar['CryptoPrimitive'] = ...
    STREAM_CIPHER: _py_ClassVar['CryptoPrimitive'] = ...
    MAC: _py_ClassVar['CryptoPrimitive'] = ...
    KEY_WRAP: _py_ClassVar['CryptoPrimitive'] = ...
    PUBLIC_KEY_ENCRYPTION: _py_ClassVar['CryptoPrimitive'] = ...
    SIGNATURE: _py_ClassVar['CryptoPrimitive'] = ...
    KEY_ENCAPSULATION: _py_ClassVar['CryptoPrimitive'] = ...
    KEY_AGREEMENT: _py_ClassVar['CryptoPrimitive'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'CryptoPrimitive': ...
    @classmethod
    def values(cls) -> _py_List['CryptoPrimitive']: ...

class DigestInputStream(java.io.FilterInputStream):
    def __init__(self, inputStream: java.io.InputStream, messageDigest: 'MessageDigest'): ...
    def getMessageDigest(self) -> 'MessageDigest': ...
    def on(self, boolean: bool) -> None: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def setMessageDigest(self, messageDigest: 'MessageDigest') -> None: ...
    def toString(self) -> str: ...

class DigestOutputStream(java.io.FilterOutputStream):
    def __init__(self, outputStream: java.io.OutputStream, messageDigest: 'MessageDigest'): ...
    def getMessageDigest(self) -> 'MessageDigest': ...
    def on(self, boolean: bool) -> None: ...
    def setMessageDigest(self, messageDigest: 'MessageDigest') -> None: ...
    def toString(self) -> str: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...

class DomainCombiner:
    def combine(self, protectionDomainArray: _py_List['ProtectionDomain'], protectionDomainArray2: _py_List['ProtectionDomain']) -> _py_List['ProtectionDomain']: ...

class GeneralSecurityException(java.lang.Exception):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class Guard:
    def checkGuard(self, object: _py_Any) -> None: ...

class GuardedObject(java.io.Serializable):
    def __init__(self, object: _py_Any, guard: Guard): ...
    def getObject(self) -> _py_Any: ...

class InvalidParameterException(java.lang.IllegalArgumentException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class Key(java.io.Serializable):
    serialVersionUID: _py_ClassVar[int] = ...
    def getAlgorithm(self) -> str: ...
    def getEncoded(self) -> _py_List[int]: ...
    def getFormat(self) -> str: ...

class KeyFactory:
    def generatePrivate(self, keySpec: java.security.spec.KeySpec) -> 'PrivateKey': ...
    def generatePublic(self, keySpec: java.security.spec.KeySpec) -> 'PublicKey': ...
    def getAlgorithm(self) -> str: ...
    @classmethod
    @overload
    def getInstance(cls, string: str) -> 'KeyFactory': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, string2: str) -> 'KeyFactory': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, provider: 'Provider') -> 'KeyFactory': ...
    _getKeySpec__T = _py_TypeVar('_getKeySpec__T', bound=java.security.spec.KeySpec)  # <T>
    def getKeySpec(self, key: Key, class_: _py_Type[_getKeySpec__T]) -> _getKeySpec__T: ...
    def getProvider(self) -> 'Provider': ...
    def translateKey(self, key: Key) -> Key: ...

class KeyFactorySpi:
    def __init__(self): ...

class KeyPair(java.io.Serializable):
    def __init__(self, publicKey: 'PublicKey', privateKey: 'PrivateKey'): ...
    def getPrivate(self) -> 'PrivateKey': ...
    def getPublic(self) -> 'PublicKey': ...

class KeyPairGeneratorSpi:
    def __init__(self): ...
    def generateKeyPair(self) -> KeyPair: ...
    @overload
    def initialize(self, int: int, secureRandom: 'SecureRandom') -> None: ...
    @overload
    def initialize(self, algorithmParameterSpec: java.security.spec.AlgorithmParameterSpec, secureRandom: 'SecureRandom') -> None: ...

class KeyRep(java.io.Serializable):
    def __init__(self, type: 'KeyRep.Type', string: str, string2: str, byteArray: _py_List[int]): ...
    class Type(java.lang.Enum['KeyRep.Type']):
        SECRET: _py_ClassVar['KeyRep.Type'] = ...
        PUBLIC: _py_ClassVar['KeyRep.Type'] = ...
        PRIVATE: _py_ClassVar['KeyRep.Type'] = ...
        _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'KeyRep.Type': ...
        @classmethod
        def values(cls) -> _py_List['KeyRep.Type']: ...

class KeyStoreSpi:
    def __init__(self): ...
    def engineAliases(self) -> java.util.Enumeration[str]: ...
    def engineContainsAlias(self, string: str) -> bool: ...
    def engineDeleteEntry(self, string: str) -> None: ...
    def engineEntryInstanceOf(self, string: str, class_: _py_Type['KeyStore.Entry']) -> bool: ...
    def engineGetCertificate(self, string: str) -> java.security.cert.Certificate: ...
    def engineGetCertificateAlias(self, certificate: java.security.cert.Certificate) -> str: ...
    def engineGetCertificateChain(self, string: str) -> _py_List[java.security.cert.Certificate]: ...
    def engineGetCreationDate(self, string: str) -> java.util.Date: ...
    def engineGetEntry(self, string: str, protectionParameter: 'KeyStore.ProtectionParameter') -> 'KeyStore.Entry': ...
    def engineGetKey(self, string: str, charArray: _py_List[str]) -> Key: ...
    def engineIsCertificateEntry(self, string: str) -> bool: ...
    def engineIsKeyEntry(self, string: str) -> bool: ...
    @overload
    def engineLoad(self, inputStream: java.io.InputStream, charArray: _py_List[str]) -> None: ...
    @overload
    def engineLoad(self, loadStoreParameter: 'KeyStore.LoadStoreParameter') -> None: ...
    def engineSetCertificateEntry(self, string: str, certificate: java.security.cert.Certificate) -> None: ...
    def engineSetEntry(self, string: str, entry: 'KeyStore.Entry', protectionParameter: 'KeyStore.ProtectionParameter') -> None: ...
    @overload
    def engineSetKeyEntry(self, string: str, byteArray: _py_List[int], certificateArray: _py_List[java.security.cert.Certificate]) -> None: ...
    @overload
    def engineSetKeyEntry(self, string: str, key: Key, charArray: _py_List[str], certificateArray: _py_List[java.security.cert.Certificate]) -> None: ...
    def engineSize(self) -> int: ...
    @overload
    def engineStore(self, outputStream: java.io.OutputStream, charArray: _py_List[str]) -> None: ...
    @overload
    def engineStore(self, loadStoreParameter: 'KeyStore.LoadStoreParameter') -> None: ...

class MessageDigestSpi:
    def __init__(self): ...
    def clone(self) -> _py_Any: ...

class PermissionCollection(java.io.Serializable):
    def __init__(self): ...
    def add(self, permission: 'Permission') -> None: ...
    def elements(self) -> java.util.Enumeration['Permission']: ...
    def implies(self, permission: 'Permission') -> bool: ...
    def isReadOnly(self) -> bool: ...
    def setReadOnly(self) -> None: ...
    def toString(self) -> str: ...

class PermissionsEnumerator(java.util.Enumeration['Permission']):
    def hasMoreElements(self) -> bool: ...
    @overload
    def nextElement(self) -> _py_Any: ...
    @overload
    def nextElement(self) -> 'Permission': ...

class Policy:
    UNSUPPORTED_EMPTY_COLLECTION: _py_ClassVar[PermissionCollection] = ...
    def __init__(self): ...
    @classmethod
    @overload
    def getInstance(cls, string: str, parameters: 'Policy.Parameters') -> 'Policy': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, parameters: 'Policy.Parameters', string2: str) -> 'Policy': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, parameters: 'Policy.Parameters', provider: 'Provider') -> 'Policy': ...
    def getParameters(self) -> 'Policy.Parameters': ...
    @overload
    def getPermissions(self, codeSource: CodeSource) -> PermissionCollection: ...
    @overload
    def getPermissions(self, protectionDomain: 'ProtectionDomain') -> PermissionCollection: ...
    @classmethod
    def getPolicy(cls) -> 'Policy': ...
    def getProvider(self) -> 'Provider': ...
    def getType(self) -> str: ...
    def implies(self, protectionDomain: 'ProtectionDomain', permission: 'Permission') -> bool: ...
    def refresh(self) -> None: ...
    @classmethod
    def setPolicy(cls, policy: 'Policy') -> None: ...
    class Parameters: ...

class PolicySpi:
    def __init__(self): ...

class Principal:
    def equals(self, object: _py_Any) -> bool: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def implies(self, subject: javax.security.auth.Subject) -> bool: ...
    def toString(self) -> str: ...

_PrivilegedAction__T = _py_TypeVar('_PrivilegedAction__T')  # <T>
class PrivilegedAction(_py_Generic[_PrivilegedAction__T]):
    def run(self) -> _PrivilegedAction__T: ...

class PrivilegedActionException(java.lang.Exception):
    def __init__(self, exception: java.lang.Exception): ...
    def getCause(self) -> java.lang.Throwable: ...
    def getException(self) -> java.lang.Exception: ...
    def toString(self) -> str: ...

_PrivilegedExceptionAction__T = _py_TypeVar('_PrivilegedExceptionAction__T')  # <T>
class PrivilegedExceptionAction(_py_Generic[_PrivilegedExceptionAction__T]):
    def run(self) -> _PrivilegedExceptionAction__T: ...

class ProtectionDomain:
    @overload
    def __init__(self, codeSource: CodeSource, permissionCollection: PermissionCollection): ...
    @overload
    def __init__(self, codeSource: CodeSource, permissionCollection: PermissionCollection, classLoader: java.lang.ClassLoader, principalArray: _py_List[Principal]): ...
    def getClassLoader(self) -> java.lang.ClassLoader: ...
    def getCodeSource(self) -> CodeSource: ...
    def getPermissions(self) -> PermissionCollection: ...
    def getPrincipals(self) -> _py_List[Principal]: ...
    def implies(self, permission: 'Permission') -> bool: ...
    def toString(self) -> str: ...

class Provider(java.util.Properties):
    def clear(self) -> None: ...
    def compute(self, object: _py_Any, biFunction: java.util.function.BiFunction[_py_Any, _py_Any, _py_Any]) -> _py_Any: ...
    def computeIfAbsent(self, object: _py_Any, function: java.util.function.Function[_py_Any, _py_Any]) -> _py_Any: ...
    def computeIfPresent(self, object: _py_Any, biFunction: java.util.function.BiFunction[_py_Any, _py_Any, _py_Any]) -> _py_Any: ...
    def elements(self) -> java.util.Enumeration[_py_Any]: ...
    def entrySet(self) -> java.util.Set[java.util.Map.Entry[_py_Any, _py_Any]]: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer[_py_Any, _py_Any]) -> None: ...
    def get(self, object: _py_Any) -> _py_Any: ...
    def getInfo(self) -> str: ...
    def getName(self) -> str: ...
    def getOrDefault(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    @overload
    def getProperty(self, string: str) -> str: ...
    @overload
    def getProperty(self, string: str, string2: str) -> str: ...
    def getService(self, string: str, string2: str) -> 'Provider.Service': ...
    def getServices(self) -> java.util.Set['Provider.Service']: ...
    def getVersion(self) -> float: ...
    def keySet(self) -> java.util.Set[_py_Any]: ...
    def keys(self) -> java.util.Enumeration[_py_Any]: ...
    @overload
    def load(self, inputStream: java.io.InputStream) -> None: ...
    @overload
    def load(self, reader: java.io.Reader) -> None: ...
    def merge(self, object: _py_Any, object2: _py_Any, biFunction: java.util.function.BiFunction[_py_Any, _py_Any, _py_Any]) -> _py_Any: ...
    def put(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    def putAll(self, map: java.util.Map[_py_Any, _py_Any]) -> None: ...
    def putIfAbsent(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _py_Any: ...
    @overload
    def replace(self, object: _py_Any, object2: _py_Any, object3: _py_Any) -> bool: ...
    @overload
    def replace(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    def replaceAll(self, biFunction: java.util.function.BiFunction[_py_Any, _py_Any, _py_Any]) -> None: ...
    def toString(self) -> str: ...
    def values(self) -> java.util.Collection[_py_Any]: ...
    class Service:
        def __init__(self, provider: 'Provider', string: str, string2: str, string3: str, list: java.util.List[str], map: java.util.Map[str, str]): ...
        def getAlgorithm(self) -> str: ...
        def getAttribute(self, string: str) -> str: ...
        def getClassName(self) -> str: ...
        def getProvider(self) -> 'Provider': ...
        def getType(self) -> str: ...
        def newInstance(self, object: _py_Any) -> _py_Any: ...
        def supportsParameter(self, object: _py_Any) -> bool: ...
        def toString(self) -> str: ...

class ProviderException(java.lang.RuntimeException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SecureClassLoader(java.lang.ClassLoader): ...

class SecureRandom(java.util.Random):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, byteArray: _py_List[int]): ...
    def generateSeed(self, int: int) -> _py_List[int]: ...
    def getAlgorithm(self) -> str: ...
    @classmethod
    @overload
    def getInstance(cls, string: str) -> 'SecureRandom': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, string2: str) -> 'SecureRandom': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, provider: Provider) -> 'SecureRandom': ...
    @classmethod
    def getInstanceStrong(cls) -> 'SecureRandom': ...
    def getProvider(self) -> Provider: ...
    @classmethod
    def getSeed(cls, int: int) -> _py_List[int]: ...
    def nextBytes(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def setSeed(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def setSeed(self, long: int) -> None: ...

class SecureRandomSpi(java.io.Serializable):
    def __init__(self): ...

class Security:
    @classmethod
    def addProvider(cls, provider: Provider) -> int: ...
    @classmethod
    def getAlgorithmProperty(cls, string: str, string2: str) -> str: ...
    @classmethod
    def getAlgorithms(cls, string: str) -> java.util.Set[str]: ...
    @classmethod
    def getProperty(cls, string: str) -> str: ...
    @classmethod
    def getProvider(cls, string: str) -> Provider: ...
    @classmethod
    @overload
    def getProviders(cls) -> _py_List[Provider]: ...
    @classmethod
    @overload
    def getProviders(cls, string: str) -> _py_List[Provider]: ...
    @classmethod
    @overload
    def getProviders(cls, map: java.util.Map[str, str]) -> _py_List[Provider]: ...
    @classmethod
    def insertProviderAt(cls, provider: Provider, int: int) -> int: ...
    @classmethod
    def removeProvider(cls, string: str) -> None: ...
    @classmethod
    def setProperty(cls, string: str, string2: str) -> None: ...

class SignatureSpi:
    def __init__(self): ...
    def clone(self) -> _py_Any: ...

class SignedObject(java.io.Serializable):
    def __init__(self, serializable: java.io.Serializable, privateKey: 'PrivateKey', signature: 'Signature'): ...
    def getAlgorithm(self) -> str: ...
    def getObject(self) -> _py_Any: ...
    def getSignature(self) -> _py_List[int]: ...
    def verify(self, publicKey: 'PublicKey', signature: 'Signature') -> bool: ...

class Timestamp(java.io.Serializable):
    def __init__(self, date: java.util.Date, certPath: java.security.cert.CertPath): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getSignerCertPath(self) -> java.security.cert.CertPath: ...
    def getTimestamp(self) -> java.util.Date: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class AllPermissionCollection(PermissionCollection, java.io.Serializable):
    def __init__(self): ...
    def add(self, permission: 'Permission') -> None: ...
    def elements(self) -> java.util.Enumeration['Permission']: ...
    def implies(self, permission: 'Permission') -> bool: ...

class AuthProvider(Provider):
    def login(self, subject: javax.security.auth.Subject, callbackHandler: javax.security.auth.callback.CallbackHandler) -> None: ...
    def logout(self) -> None: ...
    def setCallbackHandler(self, callbackHandler: javax.security.auth.callback.CallbackHandler) -> None: ...

class BasicPermissionCollection(PermissionCollection, java.io.Serializable):
    def __init__(self, class_: _py_Type[_py_Any]): ...
    def add(self, permission: 'Permission') -> None: ...
    def elements(self) -> java.util.Enumeration['Permission']: ...
    def implies(self, permission: 'Permission') -> bool: ...

class DigestException(GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class Identity(Principal, java.io.Serializable):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, identityScope: 'IdentityScope'): ...
    def addCertificate(self, certificate: Certificate) -> None: ...
    def certificates(self) -> _py_List[Certificate]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getInfo(self) -> str: ...
    def getName(self) -> str: ...
    def getPublicKey(self) -> 'PublicKey': ...
    def getScope(self) -> 'IdentityScope': ...
    def hashCode(self) -> int: ...
    def removeCertificate(self, certificate: Certificate) -> None: ...
    def setInfo(self, string: str) -> None: ...
    def setPublicKey(self, publicKey: 'PublicKey') -> None: ...
    @overload
    def toString(self) -> str: ...
    @overload
    def toString(self, boolean: bool) -> str: ...

class InvalidAlgorithmParameterException(GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class KeyException(GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class KeyPairGenerator(KeyPairGeneratorSpi):
    def genKeyPair(self) -> KeyPair: ...
    def generateKeyPair(self) -> KeyPair: ...
    def getAlgorithm(self) -> str: ...
    @classmethod
    @overload
    def getInstance(cls, string: str) -> 'KeyPairGenerator': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, string2: str) -> 'KeyPairGenerator': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, provider: Provider) -> 'KeyPairGenerator': ...
    def getProvider(self) -> Provider: ...
    @overload
    def initialize(self, int: int) -> None: ...
    @overload
    def initialize(self, int: int, secureRandom: SecureRandom) -> None: ...
    @overload
    def initialize(self, algorithmParameterSpec: java.security.spec.AlgorithmParameterSpec) -> None: ...
    @overload
    def initialize(self, algorithmParameterSpec: java.security.spec.AlgorithmParameterSpec, secureRandom: SecureRandom) -> None: ...

class KeyStoreException(GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class MessageDigest(MessageDigestSpi):
    def clone(self) -> _py_Any: ...
    @overload
    def digest(self) -> _py_List[int]: ...
    @overload
    def digest(self, byteArray: _py_List[int]) -> _py_List[int]: ...
    @overload
    def digest(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def getAlgorithm(self) -> str: ...
    def getDigestLength(self) -> int: ...
    @classmethod
    @overload
    def getInstance(cls, string: str) -> 'MessageDigest': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, string2: str) -> 'MessageDigest': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, provider: Provider) -> 'MessageDigest': ...
    def getProvider(self) -> Provider: ...
    @classmethod
    def isEqual(cls, byteArray: _py_List[int], byteArray2: _py_List[int]) -> bool: ...
    def reset(self) -> None: ...
    def toString(self) -> str: ...
    @overload
    def update(self, byteBuffer: java.nio.ByteBuffer) -> None: ...
    @overload
    def update(self, byte: int) -> None: ...
    @overload
    def update(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def update(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...

class NoSuchAlgorithmException(GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class NoSuchProviderException(GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class Permission(Guard, java.io.Serializable):
    def __init__(self, string: str): ...
    def checkGuard(self, object: _py_Any) -> None: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getActions(self) -> str: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def implies(self, permission: 'Permission') -> bool: ...
    def newPermissionCollection(self) -> PermissionCollection: ...
    def toString(self) -> str: ...

class Permissions(PermissionCollection, java.io.Serializable):
    def __init__(self): ...
    def add(self, permission: Permission) -> None: ...
    def elements(self) -> java.util.Enumeration[Permission]: ...
    def implies(self, permission: Permission) -> bool: ...

class PermissionsHash(PermissionCollection, java.io.Serializable):
    def add(self, permission: Permission) -> None: ...
    def elements(self) -> java.util.Enumeration[Permission]: ...
    def implies(self, permission: Permission) -> bool: ...

class PrivateKey(Key, javax.security.auth.Destroyable):
    serialVersionUID: _py_ClassVar[int] = ...

class PublicKey(Key):
    serialVersionUID: _py_ClassVar[int] = ...

class Signature(SignatureSpi):
    def clone(self) -> _py_Any: ...
    def getAlgorithm(self) -> str: ...
    @classmethod
    @overload
    def getInstance(cls, string: str) -> 'Signature': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, string2: str) -> 'Signature': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, provider: Provider) -> 'Signature': ...
    def getParameter(self, string: str) -> _py_Any: ...
    def getParameters(self) -> AlgorithmParameters: ...
    def getProvider(self) -> Provider: ...
    @overload
    def initSign(self, privateKey: PrivateKey) -> None: ...
    @overload
    def initSign(self, privateKey: PrivateKey, secureRandom: SecureRandom) -> None: ...
    @overload
    def initVerify(self, publicKey: PublicKey) -> None: ...
    @overload
    def initVerify(self, certificate: java.security.cert.Certificate) -> None: ...
    @overload
    def setParameter(self, string: str, object: _py_Any) -> None: ...
    @overload
    def setParameter(self, algorithmParameterSpec: java.security.spec.AlgorithmParameterSpec) -> None: ...
    @overload
    def sign(self) -> _py_List[int]: ...
    @overload
    def sign(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def toString(self) -> str: ...
    @overload
    def update(self, byte: int) -> None: ...
    @overload
    def update(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def update(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def update(self, byteBuffer: java.nio.ByteBuffer) -> None: ...
    @overload
    def verify(self, byteArray: _py_List[int]) -> bool: ...
    @overload
    def verify(self, byteArray: _py_List[int], int: int, int2: int) -> bool: ...

class SignatureException(GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class UnrecoverableEntryException(GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class UnresolvedPermissionCollection(PermissionCollection, java.io.Serializable):
    def __init__(self): ...
    def add(self, permission: Permission) -> None: ...
    def elements(self) -> java.util.Enumeration[Permission]: ...
    def implies(self, permission: Permission) -> bool: ...

class AllPermission(Permission):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getActions(self) -> str: ...
    def hashCode(self) -> int: ...
    def implies(self, permission: Permission) -> bool: ...
    def newPermissionCollection(self) -> PermissionCollection: ...

class BasicPermission(Permission, java.io.Serializable):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getActions(self) -> str: ...
    def hashCode(self) -> int: ...
    def implies(self, permission: Permission) -> bool: ...
    def newPermissionCollection(self) -> PermissionCollection: ...

class IdentityScope(Identity):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, identityScope: 'IdentityScope'): ...
    def addIdentity(self, identity: Identity) -> None: ...
    @overload
    def getIdentity(self, string: str) -> Identity: ...
    @overload
    def getIdentity(self, publicKey: PublicKey) -> Identity: ...
    @overload
    def getIdentity(self, principal: Principal) -> Identity: ...
    @classmethod
    def getSystemScope(cls) -> 'IdentityScope': ...
    def identities(self) -> java.util.Enumeration[Identity]: ...
    def removeIdentity(self, identity: Identity) -> None: ...
    def size(self) -> int: ...
    @overload
    def toString(self, boolean: bool) -> str: ...
    @overload
    def toString(self) -> str: ...

class InvalidKeyException(KeyException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class KeyManagementException(KeyException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class Signer(Identity):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, identityScope: IdentityScope): ...
    def getPrivateKey(self) -> PrivateKey: ...
    def setKeyPair(self, keyPair: KeyPair) -> None: ...
    @overload
    def toString(self, boolean: bool) -> str: ...
    @overload
    def toString(self) -> str: ...

class UnrecoverableKeyException(UnrecoverableEntryException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class UnresolvedPermission(Permission, java.io.Serializable):
    def __init__(self, string: str, string2: str, string3: str, certificateArray: _py_List[java.security.cert.Certificate]): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getActions(self) -> str: ...
    def getUnresolvedActions(self) -> str: ...
    def getUnresolvedCerts(self) -> _py_List[java.security.cert.Certificate]: ...
    def getUnresolvedName(self) -> str: ...
    def getUnresolvedType(self) -> str: ...
    def hashCode(self) -> int: ...
    def implies(self, permission: Permission) -> bool: ...
    def newPermissionCollection(self) -> PermissionCollection: ...
    def toString(self) -> str: ...

class SecurityPermission(BasicPermission):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...

class DomainLoadStoreParameter(java.security.KeyStore.LoadStoreParameter):
    def __init__(self, uRI: java.net.URI, map: java.util.Map[str, 'KeyStore.ProtectionParameter']): ...
    def getConfiguration(self) -> java.net.URI: ...
    def getProtectionParameter(self) -> 'KeyStore.ProtectionParameter': ...
    def getProtectionParams(self) -> java.util.Map[str, 'KeyStore.ProtectionParameter']: ...

class KeyStore:
    def aliases(self) -> java.util.Enumeration[str]: ...
    def containsAlias(self, string: str) -> bool: ...
    def deleteEntry(self, string: str) -> None: ...
    def entryInstanceOf(self, string: str, class_: _py_Type['KeyStore.Entry']) -> bool: ...
    def getCertificate(self, string: str) -> java.security.cert.Certificate: ...
    def getCertificateAlias(self, certificate: java.security.cert.Certificate) -> str: ...
    def getCertificateChain(self, string: str) -> _py_List[java.security.cert.Certificate]: ...
    def getCreationDate(self, string: str) -> java.util.Date: ...
    @classmethod
    def getDefaultType(cls) -> str: ...
    def getEntry(self, string: str, protectionParameter: 'KeyStore.ProtectionParameter') -> 'KeyStore.Entry': ...
    @classmethod
    @overload
    def getInstance(cls, string: str) -> 'KeyStore': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, string2: str) -> 'KeyStore': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, provider: Provider) -> 'KeyStore': ...
    def getKey(self, string: str, charArray: _py_List[str]) -> Key: ...
    def getProvider(self) -> Provider: ...
    def getType(self) -> str: ...
    def isCertificateEntry(self, string: str) -> bool: ...
    def isKeyEntry(self, string: str) -> bool: ...
    @overload
    def load(self, inputStream: java.io.InputStream, charArray: _py_List[str]) -> None: ...
    @overload
    def load(self, loadStoreParameter: 'KeyStore.LoadStoreParameter') -> None: ...
    def setCertificateEntry(self, string: str, certificate: java.security.cert.Certificate) -> None: ...
    def setEntry(self, string: str, entry: 'KeyStore.Entry', protectionParameter: 'KeyStore.ProtectionParameter') -> None: ...
    @overload
    def setKeyEntry(self, string: str, byteArray: _py_List[int], certificateArray: _py_List[java.security.cert.Certificate]) -> None: ...
    @overload
    def setKeyEntry(self, string: str, key: Key, charArray: _py_List[str], certificateArray: _py_List[java.security.cert.Certificate]) -> None: ...
    def size(self) -> int: ...
    @overload
    def store(self, outputStream: java.io.OutputStream, charArray: _py_List[str]) -> None: ...
    @overload
    def store(self, loadStoreParameter: 'KeyStore.LoadStoreParameter') -> None: ...
    class Builder:
        def getKeyStore(self) -> 'KeyStore': ...
        def getProtectionParameter(self, string: str) -> 'KeyStore.ProtectionParameter': ...
        @classmethod
        @overload
        def newInstance(cls, string: str, provider: Provider, file: java.io.File, protectionParameter: 'KeyStore.ProtectionParameter') -> 'KeyStore.Builder': ...
        @classmethod
        @overload
        def newInstance(cls, string: str, provider: Provider, protectionParameter: 'KeyStore.ProtectionParameter') -> 'KeyStore.Builder': ...
        @classmethod
        @overload
        def newInstance(cls, keyStore: 'KeyStore', protectionParameter: 'KeyStore.ProtectionParameter') -> 'KeyStore.Builder': ...
    class CallbackHandlerProtection(java.security.KeyStore.ProtectionParameter):
        def __init__(self, callbackHandler: javax.security.auth.callback.CallbackHandler): ...
        def getCallbackHandler(self) -> javax.security.auth.callback.CallbackHandler: ...
    class Entry:
        def getAttributes(self) -> java.util.Set['KeyStore.Entry.Attribute']: ...
        class Attribute:
            def getName(self) -> str: ...
            def getValue(self) -> str: ...
    class LoadStoreParameter:
        def getProtectionParameter(self) -> 'KeyStore.ProtectionParameter': ...
    class PasswordProtection(java.security.KeyStore.ProtectionParameter, javax.security.auth.Destroyable):
        @overload
        def __init__(self, charArray: _py_List[str]): ...
        @overload
        def __init__(self, charArray: _py_List[str], string: str, algorithmParameterSpec: java.security.spec.AlgorithmParameterSpec): ...
        def destroy(self) -> None: ...
        def getPassword(self) -> _py_List[str]: ...
        def getProtectionAlgorithm(self) -> str: ...
        def getProtectionParameters(self) -> java.security.spec.AlgorithmParameterSpec: ...
        def isDestroyed(self) -> bool: ...
    class PrivateKeyEntry(java.security.KeyStore.Entry):
        @overload
        def __init__(self, privateKey: PrivateKey, certificateArray: _py_List[java.security.cert.Certificate]): ...
        @overload
        def __init__(self, privateKey: PrivateKey, certificateArray: _py_List[java.security.cert.Certificate], set: java.util.Set['KeyStore.Entry.Attribute']): ...
        def getAttributes(self) -> java.util.Set['KeyStore.Entry.Attribute']: ...
        def getCertificate(self) -> java.security.cert.Certificate: ...
        def getCertificateChain(self) -> _py_List[java.security.cert.Certificate]: ...
        def getPrivateKey(self) -> PrivateKey: ...
        def toString(self) -> str: ...
    class ProtectionParameter: ...
    class SecretKeyEntry(java.security.KeyStore.Entry):
        @overload
        def __init__(self, secretKey: javax.crypto.SecretKey): ...
        @overload
        def __init__(self, secretKey: javax.crypto.SecretKey, set: java.util.Set['KeyStore.Entry.Attribute']): ...
        def getAttributes(self) -> java.util.Set['KeyStore.Entry.Attribute']: ...
        def getSecretKey(self) -> javax.crypto.SecretKey: ...
        def toString(self) -> str: ...
    class TrustedCertificateEntry(java.security.KeyStore.Entry):
        @overload
        def __init__(self, certificate: java.security.cert.Certificate): ...
        @overload
        def __init__(self, certificate: java.security.cert.Certificate, set: java.util.Set['KeyStore.Entry.Attribute']): ...
        def getAttributes(self) -> java.util.Set['KeyStore.Entry.Attribute']: ...
        def getTrustedCertificate(self) -> java.security.cert.Certificate: ...
        def toString(self) -> str: ...

class PKCS12Attribute(KeyStore.Entry.Attribute):
    @overload
    def __init__(self, byteArray: _py_List[int]): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getEncoded(self) -> _py_List[int]: ...
    def getName(self) -> str: ...
    def getValue(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class URIParameter(Policy.Parameters, javax.security.auth.login.Configuration.Parameters):
    def __init__(self, uRI: java.net.URI): ...
    def getURI(self) -> java.net.URI: ...
