from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import java.io
import java.lang
import java.nio
import java.security
import java.time
import java.util
import java.util.concurrent


class AclEntry:
    def equals(self, object: _py_Any) -> bool: ...
    def flags(self) -> java.util.Set['AclEntryFlag']: ...
    def hashCode(self) -> int: ...
    @classmethod
    @overload
    def newBuilder(cls) -> 'AclEntry.Builder': ...
    @classmethod
    @overload
    def newBuilder(cls, aclEntry: 'AclEntry') -> 'AclEntry.Builder': ...
    def permissions(self) -> java.util.Set['AclEntryPermission']: ...
    def principal(self) -> 'UserPrincipal': ...
    def toString(self) -> str: ...
    def type(self) -> 'AclEntryType': ...
    class Builder:
        def build(self) -> 'AclEntry': ...
        @overload
        def setFlags(self, aclEntryFlagArray: _py_List['AclEntryFlag']) -> 'AclEntry.Builder': ...
        @overload
        def setFlags(self, set: java.util.Set['AclEntryFlag']) -> 'AclEntry.Builder': ...
        @overload
        def setPermissions(self, aclEntryPermissionArray: _py_List['AclEntryPermission']) -> 'AclEntry.Builder': ...
        @overload
        def setPermissions(self, set: java.util.Set['AclEntryPermission']) -> 'AclEntry.Builder': ...
        def setPrincipal(self, userPrincipal: 'UserPrincipal') -> 'AclEntry.Builder': ...
        def setType(self, aclEntryType: 'AclEntryType') -> 'AclEntry.Builder': ...

class AclEntryFlag(java.lang.Enum['AclEntryFlag']):
    FILE_INHERIT: _py_ClassVar['AclEntryFlag'] = ...
    DIRECTORY_INHERIT: _py_ClassVar['AclEntryFlag'] = ...
    NO_PROPAGATE_INHERIT: _py_ClassVar['AclEntryFlag'] = ...
    INHERIT_ONLY: _py_ClassVar['AclEntryFlag'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'AclEntryFlag': ...
    @classmethod
    def values(cls) -> _py_List['AclEntryFlag']: ...

class AclEntryPermission(java.lang.Enum['AclEntryPermission']):
    READ_DATA: _py_ClassVar['AclEntryPermission'] = ...
    WRITE_DATA: _py_ClassVar['AclEntryPermission'] = ...
    APPEND_DATA: _py_ClassVar['AclEntryPermission'] = ...
    READ_NAMED_ATTRS: _py_ClassVar['AclEntryPermission'] = ...
    WRITE_NAMED_ATTRS: _py_ClassVar['AclEntryPermission'] = ...
    EXECUTE: _py_ClassVar['AclEntryPermission'] = ...
    DELETE_CHILD: _py_ClassVar['AclEntryPermission'] = ...
    READ_ATTRIBUTES: _py_ClassVar['AclEntryPermission'] = ...
    WRITE_ATTRIBUTES: _py_ClassVar['AclEntryPermission'] = ...
    DELETE: _py_ClassVar['AclEntryPermission'] = ...
    READ_ACL: _py_ClassVar['AclEntryPermission'] = ...
    WRITE_ACL: _py_ClassVar['AclEntryPermission'] = ...
    WRITE_OWNER: _py_ClassVar['AclEntryPermission'] = ...
    SYNCHRONIZE: _py_ClassVar['AclEntryPermission'] = ...
    LIST_DIRECTORY: _py_ClassVar['AclEntryPermission'] = ...
    ADD_FILE: _py_ClassVar['AclEntryPermission'] = ...
    ADD_SUBDIRECTORY: _py_ClassVar['AclEntryPermission'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'AclEntryPermission': ...
    @classmethod
    def values(cls) -> _py_List['AclEntryPermission']: ...

class AclEntryType(java.lang.Enum['AclEntryType']):
    ALLOW: _py_ClassVar['AclEntryType'] = ...
    DENY: _py_ClassVar['AclEntryType'] = ...
    AUDIT: _py_ClassVar['AclEntryType'] = ...
    ALARM: _py_ClassVar['AclEntryType'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'AclEntryType': ...
    @classmethod
    def values(cls) -> _py_List['AclEntryType']: ...

class AttributeView:
    def name(self) -> str: ...

class BasicFileAttributes:
    def creationTime(self) -> 'FileTime': ...
    def fileKey(self) -> _py_Any: ...
    def isDirectory(self) -> bool: ...
    def isOther(self) -> bool: ...
    def isRegularFile(self) -> bool: ...
    def isSymbolicLink(self) -> bool: ...
    def lastAccessTime(self) -> 'FileTime': ...
    def lastModifiedTime(self) -> 'FileTime': ...
    def size(self) -> int: ...

_FileAttribute__T = _py_TypeVar('_FileAttribute__T')  # <T>
class FileAttribute(_py_Generic[_FileAttribute__T]):
    def name(self) -> str: ...
    def value(self) -> _FileAttribute__T: ...

class FileTime(java.lang.Comparable['FileTime']):
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, fileTime: 'FileTime') -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    @classmethod
    def fromMillis(cls, long: int) -> 'FileTime': ...
    def hashCode(self) -> int: ...
    def to(self, timeUnit: java.util.concurrent.TimeUnit) -> int: ...
    def toInstant(self) -> java.time.Instant: ...
    def toMillis(self) -> int: ...
    def toString(self) -> str: ...

class PosixFilePermission(java.lang.Enum['PosixFilePermission']):
    OWNER_READ: _py_ClassVar['PosixFilePermission'] = ...
    OWNER_WRITE: _py_ClassVar['PosixFilePermission'] = ...
    OWNER_EXECUTE: _py_ClassVar['PosixFilePermission'] = ...
    GROUP_READ: _py_ClassVar['PosixFilePermission'] = ...
    GROUP_WRITE: _py_ClassVar['PosixFilePermission'] = ...
    GROUP_EXECUTE: _py_ClassVar['PosixFilePermission'] = ...
    OTHERS_READ: _py_ClassVar['PosixFilePermission'] = ...
    OTHERS_WRITE: _py_ClassVar['PosixFilePermission'] = ...
    OTHERS_EXECUTE: _py_ClassVar['PosixFilePermission'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'PosixFilePermission': ...
    @classmethod
    def values(cls) -> _py_List['PosixFilePermission']: ...

class PosixFilePermissions:
    @classmethod
    def asFileAttribute(cls, set: java.util.Set[PosixFilePermission]) -> FileAttribute[java.util.Set[PosixFilePermission]]: ...
    @classmethod
    def fromString(cls, string: str) -> java.util.Set[PosixFilePermission]: ...
    @overload
    def toString(self) -> str: ...
    @classmethod
    @overload
    def toString(cls, set: java.util.Set[PosixFilePermission]) -> str: ...

class UserPrincipal(java.security.Principal):
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class UserPrincipalLookupService:
    def lookupPrincipalByGroupName(self, string: str) -> 'GroupPrincipal': ...
    def lookupPrincipalByName(self, string: str) -> UserPrincipal: ...

class UserPrincipalNotFoundException(java.io.IOException):
    def __init__(self, string: str): ...
    def getName(self) -> str: ...

class DosFileAttributes(BasicFileAttributes):
    def isArchive(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def isSystem(self) -> bool: ...

class FileAttributeView(AttributeView): ...

class FileStoreAttributeView(AttributeView): ...

class GroupPrincipal(UserPrincipal):
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class PosixFileAttributes(BasicFileAttributes):
    def group(self) -> GroupPrincipal: ...
    def owner(self) -> UserPrincipal: ...
    def permissions(self) -> java.util.Set[PosixFilePermission]: ...

class BasicFileAttributeView(FileAttributeView):
    def name(self) -> str: ...
    def readAttributes(self) -> BasicFileAttributes: ...
    def setTimes(self, fileTime: FileTime, fileTime2: FileTime, fileTime3: FileTime) -> None: ...

class FileOwnerAttributeView(FileAttributeView):
    def getOwner(self) -> UserPrincipal: ...
    def name(self) -> str: ...
    def setOwner(self, userPrincipal: UserPrincipal) -> None: ...

class UserDefinedFileAttributeView(FileAttributeView):
    def delete(self, string: str) -> None: ...
    def list(self) -> java.util.List[str]: ...
    def name(self) -> str: ...
    def read(self, string: str, byteBuffer: java.nio.ByteBuffer) -> int: ...
    def size(self, string: str) -> int: ...
    def write(self, string: str, byteBuffer: java.nio.ByteBuffer) -> int: ...

class AclFileAttributeView(FileOwnerAttributeView):
    def getAcl(self) -> java.util.List[AclEntry]: ...
    def name(self) -> str: ...
    def setAcl(self, list: java.util.List[AclEntry]) -> None: ...

class DosFileAttributeView(BasicFileAttributeView):
    def name(self) -> str: ...
    @overload
    def readAttributes(self) -> DosFileAttributes: ...
    @overload
    def readAttributes(self) -> BasicFileAttributes: ...
    def setArchive(self, boolean: bool) -> None: ...
    def setHidden(self, boolean: bool) -> None: ...
    def setReadOnly(self, boolean: bool) -> None: ...
    def setSystem(self, boolean: bool) -> None: ...

class PosixFileAttributeView(BasicFileAttributeView, FileOwnerAttributeView):
    def name(self) -> str: ...
    @overload
    def readAttributes(self) -> PosixFileAttributes: ...
    @overload
    def readAttributes(self) -> BasicFileAttributes: ...
    def setGroup(self, groupPrincipal: GroupPrincipal) -> None: ...
    def setPermissions(self, set: java.util.Set[PosixFilePermission]) -> None: ...
