from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import java.io
import java.lang
import java.nio.channels
import java.security
import java.security.cert
import java.util
import java.util.jar


class Authenticator:
    def __init__(self): ...
    @classmethod
    @overload
    def requestPasswordAuthentication(cls, string: str, inetAddress: 'InetAddress', int: int, string2: str, string3: str, string4: str) -> 'PasswordAuthentication': ...
    @classmethod
    @overload
    def requestPasswordAuthentication(cls, string: str, inetAddress: 'InetAddress', int: int, string2: str, string3: str, string4: str, uRL: 'URL', requestorType: 'Authenticator.RequestorType') -> 'PasswordAuthentication': ...
    @classmethod
    @overload
    def requestPasswordAuthentication(cls, inetAddress: 'InetAddress', int: int, string: str, string2: str, string3: str) -> 'PasswordAuthentication': ...
    @classmethod
    def setDefault(cls, authenticator: 'Authenticator') -> None: ...
    class RequestorType(java.lang.Enum['Authenticator.RequestorType']):
        PROXY: _py_ClassVar['Authenticator.RequestorType'] = ...
        SERVER: _py_ClassVar['Authenticator.RequestorType'] = ...
        _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'Authenticator.RequestorType': ...
        @classmethod
        def values(cls) -> _py_List['Authenticator.RequestorType']: ...

class CacheRequest:
    def __init__(self): ...
    def abort(self) -> None: ...
    def getBody(self) -> java.io.OutputStream: ...

class CacheResponse:
    def __init__(self): ...
    def getBody(self) -> java.io.InputStream: ...
    def getHeaders(self) -> java.util.Map[str, java.util.List[str]]: ...

class ContentHandler:
    def __init__(self): ...
    @overload
    def getContent(self, uRLConnection: 'URLConnection') -> _py_Any: ...
    @overload
    def getContent(self, uRLConnection: 'URLConnection', classArray: _py_List[_py_Type]) -> _py_Any: ...

class ContentHandlerFactory:
    def createContentHandler(self, string: str) -> ContentHandler: ...

class CookieHandler:
    def __init__(self): ...
    def get(self, uRI: 'URI', map: java.util.Map[str, java.util.List[str]]) -> java.util.Map[str, java.util.List[str]]: ...
    @classmethod
    def getDefault(cls) -> 'CookieHandler': ...
    def put(self, uRI: 'URI', map: java.util.Map[str, java.util.List[str]]) -> None: ...
    @classmethod
    def setDefault(cls, cookieHandler: 'CookieHandler') -> None: ...

class CookiePolicy:
    ACCEPT_ALL: _py_ClassVar['CookiePolicy'] = ...
    ACCEPT_NONE: _py_ClassVar['CookiePolicy'] = ...
    ACCEPT_ORIGINAL_SERVER: _py_ClassVar['CookiePolicy'] = ...
    def shouldAccept(self, uRI: 'URI', httpCookie: 'HttpCookie') -> bool: ...

class CookieStore:
    def add(self, uRI: 'URI', httpCookie: 'HttpCookie') -> None: ...
    def get(self, uRI: 'URI') -> java.util.List['HttpCookie']: ...
    def getCookies(self) -> java.util.List['HttpCookie']: ...
    def getURIs(self) -> java.util.List['URI']: ...
    def remove(self, uRI: 'URI', httpCookie: 'HttpCookie') -> bool: ...
    def removeAll(self) -> bool: ...

class DatagramPacket:
    @overload
    def __init__(self, byteArray: _py_List[int], int: int): ...
    @overload
    def __init__(self, byteArray: _py_List[int], int: int, int2: int): ...
    @overload
    def __init__(self, byteArray: _py_List[int], int: int, int2: int, inetAddress: 'InetAddress', int3: int): ...
    @overload
    def __init__(self, byteArray: _py_List[int], int: int, int2: int, socketAddress: 'SocketAddress'): ...
    @overload
    def __init__(self, byteArray: _py_List[int], int: int, inetAddress: 'InetAddress', int2: int): ...
    @overload
    def __init__(self, byteArray: _py_List[int], int: int, socketAddress: 'SocketAddress'): ...
    def getAddress(self) -> 'InetAddress': ...
    def getData(self) -> _py_List[int]: ...
    def getLength(self) -> int: ...
    def getOffset(self) -> int: ...
    def getPort(self) -> int: ...
    def getSocketAddress(self) -> 'SocketAddress': ...
    def setAddress(self, inetAddress: 'InetAddress') -> None: ...
    @overload
    def setData(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def setData(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    def setLength(self, int: int) -> None: ...
    def setPort(self, int: int) -> None: ...
    def setSocketAddress(self, socketAddress: 'SocketAddress') -> None: ...

class DatagramSocket(java.io.Closeable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, inetAddress: 'InetAddress'): ...
    @overload
    def __init__(self, socketAddress: 'SocketAddress'): ...
    def bind(self, socketAddress: 'SocketAddress') -> None: ...
    def close(self) -> None: ...
    @overload
    def connect(self, inetAddress: 'InetAddress', int: int) -> None: ...
    @overload
    def connect(self, socketAddress: 'SocketAddress') -> None: ...
    def disconnect(self) -> None: ...
    def getBroadcast(self) -> bool: ...
    def getChannel(self) -> java.nio.channels.DatagramChannel: ...
    def getInetAddress(self) -> 'InetAddress': ...
    def getLocalAddress(self) -> 'InetAddress': ...
    def getLocalPort(self) -> int: ...
    def getLocalSocketAddress(self) -> 'SocketAddress': ...
    def getPort(self) -> int: ...
    def getReceiveBufferSize(self) -> int: ...
    def getRemoteSocketAddress(self) -> 'SocketAddress': ...
    def getReuseAddress(self) -> bool: ...
    def getSendBufferSize(self) -> int: ...
    def getSoTimeout(self) -> int: ...
    def getTrafficClass(self) -> int: ...
    def isBound(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def isConnected(self) -> bool: ...
    def receive(self, datagramPacket: DatagramPacket) -> None: ...
    def send(self, datagramPacket: DatagramPacket) -> None: ...
    def setBroadcast(self, boolean: bool) -> None: ...
    @classmethod
    def setDatagramSocketImplFactory(cls, datagramSocketImplFactory: 'DatagramSocketImplFactory') -> None: ...
    def setReceiveBufferSize(self, int: int) -> None: ...
    def setReuseAddress(self, boolean: bool) -> None: ...
    def setSendBufferSize(self, int: int) -> None: ...
    def setSoTimeout(self, int: int) -> None: ...
    def setTrafficClass(self, int: int) -> None: ...

class DatagramSocketImplFactory:
    def createDatagramSocketImpl(self) -> 'DatagramSocketImpl': ...

class DefaultDatagramSocketImplFactory: ...

class DefaultInterface: ...

class FileNameMap:
    def getContentTypeFor(self, string: str) -> str: ...

class HostPortrange:
    def hashCode(self) -> int: ...
    def hostname(self) -> str: ...
    def ipv4Literal(self) -> bool: ...
    def ipv6Literal(self) -> bool: ...
    def literal(self) -> bool: ...
    def portrange(self) -> _py_List[int]: ...
    def wildcard(self) -> bool: ...

class HttpCookie(java.lang.Cloneable):
    def __init__(self, string: str, string2: str): ...
    def clone(self) -> _py_Any: ...
    @classmethod
    def domainMatches(cls, string: str, string2: str) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getComment(self) -> str: ...
    def getCommentURL(self) -> str: ...
    def getDiscard(self) -> bool: ...
    def getDomain(self) -> str: ...
    def getMaxAge(self) -> int: ...
    def getName(self) -> str: ...
    def getPath(self) -> str: ...
    def getPortlist(self) -> str: ...
    def getSecure(self) -> bool: ...
    def getValue(self) -> str: ...
    def getVersion(self) -> int: ...
    def hasExpired(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isHttpOnly(self) -> bool: ...
    @classmethod
    def parse(cls, string: str) -> java.util.List['HttpCookie']: ...
    def setComment(self, string: str) -> None: ...
    def setCommentURL(self, string: str) -> None: ...
    def setDiscard(self, boolean: bool) -> None: ...
    def setDomain(self, string: str) -> None: ...
    def setHttpOnly(self, boolean: bool) -> None: ...
    def setMaxAge(self, long: int) -> None: ...
    def setPath(self, string: str) -> None: ...
    def setPortlist(self, string: str) -> None: ...
    def setSecure(self, boolean: bool) -> None: ...
    def setValue(self, string: str) -> None: ...
    def setVersion(self, int: int) -> None: ...
    def toString(self) -> str: ...

class HttpRetryException(java.io.IOException):
    @overload
    def __init__(self, string: str, int: int): ...
    @overload
    def __init__(self, string: str, int: int, string2: str): ...
    def getLocation(self) -> str: ...
    def getReason(self) -> str: ...
    def responseCode(self) -> int: ...

class IDN:
    ALLOW_UNASSIGNED: _py_ClassVar[int] = ...
    USE_STD3_ASCII_RULES: _py_ClassVar[int] = ...
    @classmethod
    @overload
    def toASCII(cls, string: str) -> str: ...
    @classmethod
    @overload
    def toASCII(cls, string: str, int: int) -> str: ...
    @classmethod
    @overload
    def toUnicode(cls, string: str) -> str: ...
    @classmethod
    @overload
    def toUnicode(cls, string: str, int: int) -> str: ...

class InetAddress(java.io.Serializable):
    def equals(self, object: _py_Any) -> bool: ...
    def getAddress(self) -> _py_List[int]: ...
    @classmethod
    def getAllByName(cls, string: str) -> _py_List['InetAddress']: ...
    @classmethod
    @overload
    def getByAddress(cls, byteArray: _py_List[int]) -> 'InetAddress': ...
    @classmethod
    @overload
    def getByAddress(cls, string: str, byteArray: _py_List[int]) -> 'InetAddress': ...
    @classmethod
    def getByName(cls, string: str) -> 'InetAddress': ...
    def getCanonicalHostName(self) -> str: ...
    def getHostAddress(self) -> str: ...
    def getHostName(self) -> str: ...
    @classmethod
    def getLocalHost(cls) -> 'InetAddress': ...
    @classmethod
    def getLoopbackAddress(cls) -> 'InetAddress': ...
    def hashCode(self) -> int: ...
    def isAnyLocalAddress(self) -> bool: ...
    def isLinkLocalAddress(self) -> bool: ...
    def isLoopbackAddress(self) -> bool: ...
    def isMCGlobal(self) -> bool: ...
    def isMCLinkLocal(self) -> bool: ...
    def isMCNodeLocal(self) -> bool: ...
    def isMCOrgLocal(self) -> bool: ...
    def isMCSiteLocal(self) -> bool: ...
    def isMulticastAddress(self) -> bool: ...
    @overload
    def isReachable(self, int: int) -> bool: ...
    @overload
    def isReachable(self, networkInterface: 'NetworkInterface', int: int, int2: int) -> bool: ...
    def isSiteLocalAddress(self) -> bool: ...
    def toString(self) -> str: ...

class InetAddressContainer: ...

class InetAddressImpl:
    def anyLocalAddress(self) -> InetAddress: ...
    def getHostByAddr(self, byteArray: _py_List[int]) -> str: ...
    def getLocalHostName(self) -> str: ...
    def isReachable(self, inetAddress: InetAddress, int: int, networkInterface: 'NetworkInterface', int2: int) -> bool: ...
    def lookupAllHostAddr(self, string: str) -> _py_List[InetAddress]: ...
    def loopbackAddress(self) -> InetAddress: ...

class InetAddressImplFactory: ...

class InterfaceAddress:
    def equals(self, object: _py_Any) -> bool: ...
    def getAddress(self) -> InetAddress: ...
    def getBroadcast(self) -> InetAddress: ...
    def getNetworkPrefixLength(self) -> int: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class MalformedURLException(java.io.IOException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class NetPermission(java.security.BasicPermission):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...

class NetworkInterface:
    def equals(self, object: _py_Any) -> bool: ...
    @classmethod
    def getByIndex(cls, int: int) -> 'NetworkInterface': ...
    @classmethod
    def getByInetAddress(cls, inetAddress: InetAddress) -> 'NetworkInterface': ...
    @classmethod
    def getByName(cls, string: str) -> 'NetworkInterface': ...
    def getDisplayName(self) -> str: ...
    def getHardwareAddress(self) -> _py_List[int]: ...
    def getIndex(self) -> int: ...
    def getInetAddresses(self) -> java.util.Enumeration[InetAddress]: ...
    def getInterfaceAddresses(self) -> java.util.List[InterfaceAddress]: ...
    def getMTU(self) -> int: ...
    def getName(self) -> str: ...
    @classmethod
    def getNetworkInterfaces(cls) -> java.util.Enumeration['NetworkInterface']: ...
    def getParent(self) -> 'NetworkInterface': ...
    def getSubInterfaces(self) -> java.util.Enumeration['NetworkInterface']: ...
    def hashCode(self) -> int: ...
    def isLoopback(self) -> bool: ...
    def isPointToPoint(self) -> bool: ...
    def isUp(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def supportsMulticast(self) -> bool: ...
    def toString(self) -> str: ...

class Parts: ...

class PasswordAuthentication:
    def __init__(self, string: str, charArray: _py_List[str]): ...
    def getPassword(self) -> _py_List[str]: ...
    def getUserName(self) -> str: ...

class ProtocolException(java.io.IOException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class ProtocolFamily:
    def name(self) -> str: ...

class Proxy:
    NO_PROXY: _py_ClassVar['Proxy'] = ...
    def __init__(self, type: 'Proxy.Type', socketAddress: 'SocketAddress'): ...
    def address(self) -> 'SocketAddress': ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def type(self) -> 'Proxy.Type': ...
    class Type(java.lang.Enum['Proxy.Type']):
        DIRECT: _py_ClassVar['Proxy.Type'] = ...
        HTTP: _py_ClassVar['Proxy.Type'] = ...
        SOCKS: _py_ClassVar['Proxy.Type'] = ...
        _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'Proxy.Type': ...
        @classmethod
        def values(cls) -> _py_List['Proxy.Type']: ...

class ProxySelector:
    def __init__(self): ...
    def connectFailed(self, uRI: 'URI', socketAddress: 'SocketAddress', iOException: java.io.IOException) -> None: ...
    @classmethod
    def getDefault(cls) -> 'ProxySelector': ...
    def select(self, uRI: 'URI') -> java.util.List[Proxy]: ...
    @classmethod
    def setDefault(cls, proxySelector: 'ProxySelector') -> None: ...

class ResponseCache:
    def __init__(self): ...
    def get(self, uRI: 'URI', string: str, map: java.util.Map[str, java.util.List[str]]) -> CacheResponse: ...
    @classmethod
    def getDefault(cls) -> 'ResponseCache': ...
    def put(self, uRI: 'URI', uRLConnection: 'URLConnection') -> CacheRequest: ...
    @classmethod
    def setDefault(cls, responseCache: 'ResponseCache') -> None: ...

class ServerSocket(java.io.Closeable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    @overload
    def __init__(self, int: int, int2: int, inetAddress: InetAddress): ...
    def accept(self) -> 'Socket': ...
    @overload
    def bind(self, socketAddress: 'SocketAddress') -> None: ...
    @overload
    def bind(self, socketAddress: 'SocketAddress', int: int) -> None: ...
    def close(self) -> None: ...
    def getChannel(self) -> java.nio.channels.ServerSocketChannel: ...
    def getInetAddress(self) -> InetAddress: ...
    def getLocalPort(self) -> int: ...
    def getLocalSocketAddress(self) -> 'SocketAddress': ...
    def getReceiveBufferSize(self) -> int: ...
    def getReuseAddress(self) -> bool: ...
    def getSoTimeout(self) -> int: ...
    def isBound(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def setPerformancePreferences(self, int: int, int2: int, int3: int) -> None: ...
    def setReceiveBufferSize(self, int: int) -> None: ...
    def setReuseAddress(self, boolean: bool) -> None: ...
    def setSoTimeout(self, int: int) -> None: ...
    @classmethod
    def setSocketFactory(cls, socketImplFactory: 'SocketImplFactory') -> None: ...
    def toString(self) -> str: ...

class Socket(java.io.Closeable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str, int: int): ...
    @overload
    def __init__(self, string: str, int: int, boolean: bool): ...
    @overload
    def __init__(self, string: str, int: int, inetAddress: InetAddress, int2: int): ...
    @overload
    def __init__(self, inetAddress: InetAddress, int: int): ...
    @overload
    def __init__(self, inetAddress: InetAddress, int: int, boolean: bool): ...
    @overload
    def __init__(self, inetAddress: InetAddress, int: int, inetAddress2: InetAddress, int2: int): ...
    @overload
    def __init__(self, proxy: Proxy): ...
    def bind(self, socketAddress: 'SocketAddress') -> None: ...
    def close(self) -> None: ...
    @overload
    def connect(self, socketAddress: 'SocketAddress') -> None: ...
    @overload
    def connect(self, socketAddress: 'SocketAddress', int: int) -> None: ...
    def getChannel(self) -> java.nio.channels.SocketChannel: ...
    def getInetAddress(self) -> InetAddress: ...
    def getInputStream(self) -> java.io.InputStream: ...
    def getKeepAlive(self) -> bool: ...
    def getLocalAddress(self) -> InetAddress: ...
    def getLocalPort(self) -> int: ...
    def getLocalSocketAddress(self) -> 'SocketAddress': ...
    def getOOBInline(self) -> bool: ...
    def getOutputStream(self) -> java.io.OutputStream: ...
    def getPort(self) -> int: ...
    def getReceiveBufferSize(self) -> int: ...
    def getRemoteSocketAddress(self) -> 'SocketAddress': ...
    def getReuseAddress(self) -> bool: ...
    def getSendBufferSize(self) -> int: ...
    def getSoLinger(self) -> int: ...
    def getSoTimeout(self) -> int: ...
    def getTcpNoDelay(self) -> bool: ...
    def getTrafficClass(self) -> int: ...
    def isBound(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def isConnected(self) -> bool: ...
    def isInputShutdown(self) -> bool: ...
    def isOutputShutdown(self) -> bool: ...
    def sendUrgentData(self, int: int) -> None: ...
    def setKeepAlive(self, boolean: bool) -> None: ...
    def setOOBInline(self, boolean: bool) -> None: ...
    def setPerformancePreferences(self, int: int, int2: int, int3: int) -> None: ...
    def setReceiveBufferSize(self, int: int) -> None: ...
    def setReuseAddress(self, boolean: bool) -> None: ...
    def setSendBufferSize(self, int: int) -> None: ...
    def setSoLinger(self, boolean: bool, int: int) -> None: ...
    def setSoTimeout(self, int: int) -> None: ...
    @classmethod
    def setSocketImplFactory(cls, socketImplFactory: 'SocketImplFactory') -> None: ...
    def setTcpNoDelay(self, boolean: bool) -> None: ...
    def setTrafficClass(self, int: int) -> None: ...
    def shutdownInput(self) -> None: ...
    def shutdownOutput(self) -> None: ...
    def toString(self) -> str: ...

class SocketAddress(java.io.Serializable):
    def __init__(self): ...

class SocketException(java.io.IOException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class SocketImplFactory:
    def createSocketImpl(self) -> 'SocketImpl': ...

class SocketInputStream(java.io.FileInputStream):
    def available(self) -> int: ...
    def close(self) -> None: ...
    def getChannel(self) -> java.nio.channels.FileChannel: ...
    @overload
    def read(self) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int]) -> int: ...
    @overload
    def read(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    def skip(self, long: int) -> int: ...

_SocketOption__T = _py_TypeVar('_SocketOption__T')  # <T>
class SocketOption(_py_Generic[_SocketOption__T]):
    def name(self) -> str: ...
    def type(self) -> _py_Type[_SocketOption__T]: ...

class SocketOptions:
    TCP_NODELAY: _py_ClassVar[int] = ...
    SO_BINDADDR: _py_ClassVar[int] = ...
    SO_REUSEADDR: _py_ClassVar[int] = ...
    SO_BROADCAST: _py_ClassVar[int] = ...
    IP_MULTICAST_IF: _py_ClassVar[int] = ...
    IP_MULTICAST_IF2: _py_ClassVar[int] = ...
    IP_MULTICAST_LOOP: _py_ClassVar[int] = ...
    IP_TOS: _py_ClassVar[int] = ...
    SO_LINGER: _py_ClassVar[int] = ...
    SO_TIMEOUT: _py_ClassVar[int] = ...
    SO_SNDBUF: _py_ClassVar[int] = ...
    SO_RCVBUF: _py_ClassVar[int] = ...
    SO_KEEPALIVE: _py_ClassVar[int] = ...
    SO_OOBINLINE: _py_ClassVar[int] = ...
    def getOption(self, int: int) -> _py_Any: ...
    def setOption(self, int: int, object: _py_Any) -> None: ...

class SocketOutputStream(java.io.FileOutputStream):
    def close(self) -> None: ...
    def getChannel(self) -> java.nio.channels.FileChannel: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...

class SocketPermission(java.security.Permission, java.io.Serializable):
    def __init__(self, string: str, string2: str): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getActions(self) -> str: ...
    def hashCode(self) -> int: ...
    def implies(self, permission: java.security.Permission) -> bool: ...
    def newPermissionCollection(self) -> java.security.PermissionCollection: ...

class SocketPermissionCollection(java.security.PermissionCollection, java.io.Serializable):
    def __init__(self): ...
    def add(self, permission: java.security.Permission) -> None: ...
    def elements(self) -> java.util.Enumeration[java.security.Permission]: ...
    def implies(self, permission: java.security.Permission) -> bool: ...

class SocketSecrets: ...

class SocketTimeoutException(java.io.InterruptedIOException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class SocksConsts:
    PROTO_VERS4: _py_ClassVar[int] = ...
    PROTO_VERS: _py_ClassVar[int] = ...
    DEFAULT_PORT: _py_ClassVar[int] = ...
    NO_AUTH: _py_ClassVar[int] = ...
    GSSAPI: _py_ClassVar[int] = ...
    USER_PASSW: _py_ClassVar[int] = ...
    NO_METHODS: _py_ClassVar[int] = ...
    CONNECT: _py_ClassVar[int] = ...
    BIND: _py_ClassVar[int] = ...
    UDP_ASSOC: _py_ClassVar[int] = ...
    IPV4: _py_ClassVar[int] = ...
    DOMAIN_NAME: _py_ClassVar[int] = ...
    IPV6: _py_ClassVar[int] = ...
    REQUEST_OK: _py_ClassVar[int] = ...
    GENERAL_FAILURE: _py_ClassVar[int] = ...
    NOT_ALLOWED: _py_ClassVar[int] = ...
    NET_UNREACHABLE: _py_ClassVar[int] = ...
    HOST_UNREACHABLE: _py_ClassVar[int] = ...
    CONN_REFUSED: _py_ClassVar[int] = ...
    TTL_EXPIRED: _py_ClassVar[int] = ...
    CMD_NOT_SUPPORTED: _py_ClassVar[int] = ...
    ADDR_TYPE_NOT_SUP: _py_ClassVar[int] = ...

class StandardSocketOptions:
    SO_BROADCAST: _py_ClassVar[SocketOption] = ...
    SO_KEEPALIVE: _py_ClassVar[SocketOption] = ...
    SO_SNDBUF: _py_ClassVar[SocketOption] = ...
    SO_RCVBUF: _py_ClassVar[SocketOption] = ...
    SO_REUSEADDR: _py_ClassVar[SocketOption] = ...
    SO_LINGER: _py_ClassVar[SocketOption] = ...
    IP_TOS: _py_ClassVar[SocketOption] = ...
    IP_MULTICAST_IF: _py_ClassVar[SocketOption] = ...
    IP_MULTICAST_TTL: _py_ClassVar[SocketOption] = ...
    IP_MULTICAST_LOOP: _py_ClassVar[SocketOption] = ...
    TCP_NODELAY: _py_ClassVar[SocketOption] = ...

class URI(java.lang.Comparable['URI'], java.io.Serializable):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str, int: int, string4: str, string5: str, string6: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str, string4: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str, string4: str, string5: str): ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, uRI: 'URI') -> int: ...
    @classmethod
    def create(cls, string: str) -> 'URI': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAuthority(self) -> str: ...
    def getFragment(self) -> str: ...
    def getHost(self) -> str: ...
    def getPath(self) -> str: ...
    def getPort(self) -> int: ...
    def getQuery(self) -> str: ...
    def getRawAuthority(self) -> str: ...
    def getRawFragment(self) -> str: ...
    def getRawPath(self) -> str: ...
    def getRawQuery(self) -> str: ...
    def getRawSchemeSpecificPart(self) -> str: ...
    def getRawUserInfo(self) -> str: ...
    def getScheme(self) -> str: ...
    def getSchemeSpecificPart(self) -> str: ...
    def getUserInfo(self) -> str: ...
    def hashCode(self) -> int: ...
    def isAbsolute(self) -> bool: ...
    def isOpaque(self) -> bool: ...
    def normalize(self) -> 'URI': ...
    def parseServerAuthority(self) -> 'URI': ...
    def relativize(self, uRI: 'URI') -> 'URI': ...
    @overload
    def resolve(self, string: str) -> 'URI': ...
    @overload
    def resolve(self, uRI: 'URI') -> 'URI': ...
    def toASCIIString(self) -> str: ...
    def toString(self) -> str: ...
    def toURL(self) -> 'URL': ...

class URISyntaxException(java.lang.Exception):
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    def getIndex(self) -> int: ...
    def getInput(self) -> str: ...
    def getMessage(self) -> str: ...
    def getReason(self) -> str: ...

class URL(java.io.Serializable):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, string3: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int, string3: str, uRLStreamHandler: 'URLStreamHandler'): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @overload
    def __init__(self, uRL: 'URL', string: str): ...
    @overload
    def __init__(self, uRL: 'URL', string: str, uRLStreamHandler: 'URLStreamHandler'): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAuthority(self) -> str: ...
    @overload
    def getContent(self) -> _py_Any: ...
    @overload
    def getContent(self, classArray: _py_List[_py_Type]) -> _py_Any: ...
    def getDefaultPort(self) -> int: ...
    def getFile(self) -> str: ...
    def getHost(self) -> str: ...
    def getPath(self) -> str: ...
    def getPort(self) -> int: ...
    def getProtocol(self) -> str: ...
    def getQuery(self) -> str: ...
    def getRef(self) -> str: ...
    def getUserInfo(self) -> str: ...
    def hashCode(self) -> int: ...
    @overload
    def openConnection(self) -> 'URLConnection': ...
    @overload
    def openConnection(self, proxy: Proxy) -> 'URLConnection': ...
    def openStream(self) -> java.io.InputStream: ...
    def sameFile(self, uRL: 'URL') -> bool: ...
    @classmethod
    def setURLStreamHandlerFactory(cls, uRLStreamHandlerFactory: 'URLStreamHandlerFactory') -> None: ...
    def toExternalForm(self) -> str: ...
    def toString(self) -> str: ...
    def toURI(self) -> URI: ...

class URLClassLoader(java.security.SecureClassLoader, java.io.Closeable):
    @overload
    def __init__(self, uRLArray: _py_List[URL]): ...
    @overload
    def __init__(self, uRLArray: _py_List[URL], classLoader: java.lang.ClassLoader): ...
    @overload
    def __init__(self, uRLArray: _py_List[URL], classLoader: java.lang.ClassLoader, uRLStreamHandlerFactory: 'URLStreamHandlerFactory'): ...
    def close(self) -> None: ...
    def findResource(self, string: str) -> URL: ...
    def findResources(self, string: str) -> java.util.Enumeration[URL]: ...
    def getResourceAsStream(self, string: str) -> java.io.InputStream: ...
    def getURLs(self) -> _py_List[URL]: ...
    @classmethod
    @overload
    def newInstance(cls, uRLArray: _py_List[URL]) -> 'URLClassLoader': ...
    @classmethod
    @overload
    def newInstance(cls, uRLArray: _py_List[URL], classLoader: java.lang.ClassLoader) -> 'URLClassLoader': ...

class URLConnection:
    def addRequestProperty(self, string: str, string2: str) -> None: ...
    def connect(self) -> None: ...
    def getAllowUserInteraction(self) -> bool: ...
    def getConnectTimeout(self) -> int: ...
    @overload
    def getContent(self) -> _py_Any: ...
    @overload
    def getContent(self, classArray: _py_List[_py_Type]) -> _py_Any: ...
    def getContentEncoding(self) -> str: ...
    def getContentLength(self) -> int: ...
    def getContentLengthLong(self) -> int: ...
    def getContentType(self) -> str: ...
    def getDate(self) -> int: ...
    @classmethod
    def getDefaultAllowUserInteraction(cls) -> bool: ...
    @classmethod
    def getDefaultRequestProperty(cls, string: str) -> str: ...
    def getDefaultUseCaches(self) -> bool: ...
    def getDoInput(self) -> bool: ...
    def getDoOutput(self) -> bool: ...
    def getExpiration(self) -> int: ...
    @classmethod
    def getFileNameMap(cls) -> FileNameMap: ...
    @overload
    def getHeaderField(self, int: int) -> str: ...
    @overload
    def getHeaderField(self, string: str) -> str: ...
    def getHeaderFieldDate(self, string: str, long: int) -> int: ...
    def getHeaderFieldInt(self, string: str, int: int) -> int: ...
    def getHeaderFieldKey(self, int: int) -> str: ...
    def getHeaderFieldLong(self, string: str, long: int) -> int: ...
    def getHeaderFields(self) -> java.util.Map[str, java.util.List[str]]: ...
    def getIfModifiedSince(self) -> int: ...
    def getInputStream(self) -> java.io.InputStream: ...
    def getLastModified(self) -> int: ...
    def getOutputStream(self) -> java.io.OutputStream: ...
    def getPermission(self) -> java.security.Permission: ...
    def getReadTimeout(self) -> int: ...
    def getRequestProperties(self) -> java.util.Map[str, java.util.List[str]]: ...
    def getRequestProperty(self, string: str) -> str: ...
    def getURL(self) -> URL: ...
    def getUseCaches(self) -> bool: ...
    @classmethod
    def guessContentTypeFromName(cls, string: str) -> str: ...
    @classmethod
    def guessContentTypeFromStream(cls, inputStream: java.io.InputStream) -> str: ...
    def setAllowUserInteraction(self, boolean: bool) -> None: ...
    def setConnectTimeout(self, int: int) -> None: ...
    @classmethod
    def setContentHandlerFactory(cls, contentHandlerFactory: ContentHandlerFactory) -> None: ...
    @classmethod
    def setDefaultAllowUserInteraction(cls, boolean: bool) -> None: ...
    @classmethod
    def setDefaultRequestProperty(cls, string: str, string2: str) -> None: ...
    def setDefaultUseCaches(self, boolean: bool) -> None: ...
    def setDoInput(self, boolean: bool) -> None: ...
    def setDoOutput(self, boolean: bool) -> None: ...
    @classmethod
    def setFileNameMap(cls, fileNameMap: FileNameMap) -> None: ...
    def setIfModifiedSince(self, long: int) -> None: ...
    def setReadTimeout(self, int: int) -> None: ...
    def setRequestProperty(self, string: str, string2: str) -> None: ...
    def setUseCaches(self, boolean: bool) -> None: ...
    def toString(self) -> str: ...

class URLDecoder:
    def __init__(self): ...
    @classmethod
    @overload
    def decode(cls, string: str) -> str: ...
    @classmethod
    @overload
    def decode(cls, string: str, string2: str) -> str: ...

class URLEncoder:
    @classmethod
    @overload
    def encode(cls, string: str) -> str: ...
    @classmethod
    @overload
    def encode(cls, string: str, string2: str) -> str: ...

class URLPermission(java.security.Permission):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getActions(self) -> str: ...
    def hashCode(self) -> int: ...
    def implies(self, permission: java.security.Permission) -> bool: ...

class URLStreamHandler:
    def __init__(self): ...

class URLStreamHandlerFactory:
    def createURLStreamHandler(self, string: str) -> URLStreamHandler: ...

class UnknownHostException(java.io.IOException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class UnknownServiceException(java.io.IOException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class UrlDeserializedState:
    def __init__(self, string: str, string2: str, int: int, string3: str, string4: str, string5: str, int2: int): ...

class BindException(SocketException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class ConnectException(SocketException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class CookieManager(CookieHandler):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, cookieStore: CookieStore, cookiePolicy: CookiePolicy): ...
    def get(self, uRI: URI, map: java.util.Map[str, java.util.List[str]]) -> java.util.Map[str, java.util.List[str]]: ...
    def getCookieStore(self) -> CookieStore: ...
    def put(self, uRI: URI, map: java.util.Map[str, java.util.List[str]]) -> None: ...
    def setCookiePolicy(self, cookiePolicy: CookiePolicy) -> None: ...

class DatagramSocketImpl(SocketOptions):
    def __init__(self): ...

class FactoryURLClassLoader(URLClassLoader):
    @overload
    def loadClass(self, string: str, boolean: bool) -> _py_Type[_py_Any]: ...
    @overload
    def loadClass(self, string: str) -> _py_Type[_py_Any]: ...

class HttpURLConnection(URLConnection):
    HTTP_OK: _py_ClassVar[int] = ...
    HTTP_CREATED: _py_ClassVar[int] = ...
    HTTP_ACCEPTED: _py_ClassVar[int] = ...
    HTTP_NOT_AUTHORITATIVE: _py_ClassVar[int] = ...
    HTTP_NO_CONTENT: _py_ClassVar[int] = ...
    HTTP_RESET: _py_ClassVar[int] = ...
    HTTP_PARTIAL: _py_ClassVar[int] = ...
    HTTP_MULT_CHOICE: _py_ClassVar[int] = ...
    HTTP_MOVED_PERM: _py_ClassVar[int] = ...
    HTTP_MOVED_TEMP: _py_ClassVar[int] = ...
    HTTP_SEE_OTHER: _py_ClassVar[int] = ...
    HTTP_NOT_MODIFIED: _py_ClassVar[int] = ...
    HTTP_USE_PROXY: _py_ClassVar[int] = ...
    HTTP_BAD_REQUEST: _py_ClassVar[int] = ...
    HTTP_UNAUTHORIZED: _py_ClassVar[int] = ...
    HTTP_PAYMENT_REQUIRED: _py_ClassVar[int] = ...
    HTTP_FORBIDDEN: _py_ClassVar[int] = ...
    HTTP_NOT_FOUND: _py_ClassVar[int] = ...
    HTTP_BAD_METHOD: _py_ClassVar[int] = ...
    HTTP_NOT_ACCEPTABLE: _py_ClassVar[int] = ...
    HTTP_PROXY_AUTH: _py_ClassVar[int] = ...
    HTTP_CLIENT_TIMEOUT: _py_ClassVar[int] = ...
    HTTP_CONFLICT: _py_ClassVar[int] = ...
    HTTP_GONE: _py_ClassVar[int] = ...
    HTTP_LENGTH_REQUIRED: _py_ClassVar[int] = ...
    HTTP_PRECON_FAILED: _py_ClassVar[int] = ...
    HTTP_ENTITY_TOO_LARGE: _py_ClassVar[int] = ...
    HTTP_REQ_TOO_LONG: _py_ClassVar[int] = ...
    HTTP_UNSUPPORTED_TYPE: _py_ClassVar[int] = ...
    HTTP_SERVER_ERROR: _py_ClassVar[int] = ...
    HTTP_INTERNAL_ERROR: _py_ClassVar[int] = ...
    HTTP_NOT_IMPLEMENTED: _py_ClassVar[int] = ...
    HTTP_BAD_GATEWAY: _py_ClassVar[int] = ...
    HTTP_UNAVAILABLE: _py_ClassVar[int] = ...
    HTTP_GATEWAY_TIMEOUT: _py_ClassVar[int] = ...
    HTTP_VERSION: _py_ClassVar[int] = ...
    def disconnect(self) -> None: ...
    def getErrorStream(self) -> java.io.InputStream: ...
    @classmethod
    def getFollowRedirects(cls) -> bool: ...
    @overload
    def getHeaderField(self, int: int) -> str: ...
    @overload
    def getHeaderField(self, string: str) -> str: ...
    def getHeaderFieldDate(self, string: str, long: int) -> int: ...
    def getHeaderFieldKey(self, int: int) -> str: ...
    def getInstanceFollowRedirects(self) -> bool: ...
    def getPermission(self) -> java.security.Permission: ...
    def getRequestMethod(self) -> str: ...
    def getResponseCode(self) -> int: ...
    def getResponseMessage(self) -> str: ...
    def setChunkedStreamingMode(self, int: int) -> None: ...
    @overload
    def setFixedLengthStreamingMode(self, int: int) -> None: ...
    @overload
    def setFixedLengthStreamingMode(self, long: int) -> None: ...
    @classmethod
    def setFollowRedirects(cls, boolean: bool) -> None: ...
    def setInstanceFollowRedirects(self, boolean: bool) -> None: ...
    def setRequestMethod(self, string: str) -> None: ...
    def usingProxy(self) -> bool: ...

class InMemoryCookieStore(CookieStore):
    def __init__(self): ...
    def add(self, uRI: URI, httpCookie: HttpCookie) -> None: ...
    def get(self, uRI: URI) -> java.util.List[HttpCookie]: ...
    def getCookies(self) -> java.util.List[HttpCookie]: ...
    def getURIs(self) -> java.util.List[URI]: ...
    def remove(self, uRI: URI, httpCookie: HttpCookie) -> bool: ...
    def removeAll(self) -> bool: ...

class Inet4Address(InetAddress):
    def equals(self, object: _py_Any) -> bool: ...
    def getAddress(self) -> _py_List[int]: ...
    def getHostAddress(self) -> str: ...
    def hashCode(self) -> int: ...
    def isAnyLocalAddress(self) -> bool: ...
    def isLinkLocalAddress(self) -> bool: ...
    def isLoopbackAddress(self) -> bool: ...
    def isMCGlobal(self) -> bool: ...
    def isMCLinkLocal(self) -> bool: ...
    def isMCNodeLocal(self) -> bool: ...
    def isMCOrgLocal(self) -> bool: ...
    def isMCSiteLocal(self) -> bool: ...
    def isMulticastAddress(self) -> bool: ...
    def isSiteLocalAddress(self) -> bool: ...

class Inet4AddressImpl(InetAddressImpl):
    def anyLocalAddress(self) -> InetAddress: ...
    def getHostByAddr(self, byteArray: _py_List[int]) -> str: ...
    def getLocalHostName(self) -> str: ...
    def isReachable(self, inetAddress: InetAddress, int: int, networkInterface: NetworkInterface, int2: int) -> bool: ...
    def lookupAllHostAddr(self, string: str) -> _py_List[InetAddress]: ...
    def loopbackAddress(self) -> InetAddress: ...

class Inet6Address(InetAddress):
    def equals(self, object: _py_Any) -> bool: ...
    def getAddress(self) -> _py_List[int]: ...
    @classmethod
    @overload
    def getByAddress(cls, string: str, byteArray: _py_List[int], int: int) -> 'Inet6Address': ...
    @classmethod
    @overload
    def getByAddress(cls, string: str, byteArray: _py_List[int], networkInterface: NetworkInterface) -> 'Inet6Address': ...
    @classmethod
    @overload
    def getByAddress(cls, byteArray: _py_List[int]) -> InetAddress: ...
    @classmethod
    @overload
    def getByAddress(cls, string: str, byteArray: _py_List[int]) -> InetAddress: ...
    def getHostAddress(self) -> str: ...
    def getScopeId(self) -> int: ...
    def getScopedInterface(self) -> NetworkInterface: ...
    def hashCode(self) -> int: ...
    def isAnyLocalAddress(self) -> bool: ...
    def isIPv4CompatibleAddress(self) -> bool: ...
    def isLinkLocalAddress(self) -> bool: ...
    def isLoopbackAddress(self) -> bool: ...
    def isMCGlobal(self) -> bool: ...
    def isMCLinkLocal(self) -> bool: ...
    def isMCNodeLocal(self) -> bool: ...
    def isMCOrgLocal(self) -> bool: ...
    def isMCSiteLocal(self) -> bool: ...
    def isMulticastAddress(self) -> bool: ...
    def isSiteLocalAddress(self) -> bool: ...

class Inet6AddressImpl(InetAddressImpl):
    def anyLocalAddress(self) -> InetAddress: ...
    def getHostByAddr(self, byteArray: _py_List[int]) -> str: ...
    def getLocalHostName(self) -> str: ...
    def isReachable(self, inetAddress: InetAddress, int: int, networkInterface: NetworkInterface, int2: int) -> bool: ...
    def lookupAllHostAddr(self, string: str) -> _py_List[InetAddress]: ...
    def loopbackAddress(self) -> InetAddress: ...

class InetSocketAddress(SocketAddress):
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, string: str, int: int): ...
    @overload
    def __init__(self, inetAddress: InetAddress, int: int): ...
    @classmethod
    def createUnresolved(cls, string: str, int: int) -> 'InetSocketAddress': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAddress(self) -> InetAddress: ...
    def getHostName(self) -> str: ...
    def getHostString(self) -> str: ...
    def getPort(self) -> int: ...
    def hashCode(self) -> int: ...
    def isUnresolved(self) -> bool: ...
    def toString(self) -> str: ...

class JarURLConnection(URLConnection):
    def getAttributes(self) -> java.util.jar.Attributes: ...
    def getCertificates(self) -> _py_List[java.security.cert.Certificate]: ...
    def getEntryName(self) -> str: ...
    def getJarEntry(self) -> java.util.jar.JarEntry: ...
    def getJarFile(self) -> java.util.jar.JarFile: ...
    def getJarFileURL(self) -> URL: ...
    def getMainAttributes(self) -> java.util.jar.Attributes: ...
    def getManifest(self) -> java.util.jar.Manifest: ...

class MulticastSocket(DatagramSocket):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, socketAddress: SocketAddress): ...
    def getInterface(self) -> InetAddress: ...
    def getLoopbackMode(self) -> bool: ...
    def getNetworkInterface(self) -> NetworkInterface: ...
    def getTTL(self) -> int: ...
    def getTimeToLive(self) -> int: ...
    @overload
    def joinGroup(self, inetAddress: InetAddress) -> None: ...
    @overload
    def joinGroup(self, socketAddress: SocketAddress, networkInterface: NetworkInterface) -> None: ...
    @overload
    def leaveGroup(self, inetAddress: InetAddress) -> None: ...
    @overload
    def leaveGroup(self, socketAddress: SocketAddress, networkInterface: NetworkInterface) -> None: ...
    @overload
    def send(self, datagramPacket: DatagramPacket) -> None: ...
    @overload
    def send(self, datagramPacket: DatagramPacket, byte: int) -> None: ...
    def setInterface(self, inetAddress: InetAddress) -> None: ...
    def setLoopbackMode(self, boolean: bool) -> None: ...
    def setNetworkInterface(self, networkInterface: NetworkInterface) -> None: ...
    def setTTL(self, byte: int) -> None: ...
    def setTimeToLive(self, int: int) -> None: ...

class NoRouteToHostException(SocketException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class PortUnreachableException(SocketException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class SecureCacheResponse(CacheResponse):
    def __init__(self): ...
    def getCipherSuite(self) -> str: ...
    def getLocalCertificateChain(self) -> java.util.List[java.security.cert.Certificate]: ...
    def getLocalPrincipal(self) -> java.security.Principal: ...
    def getPeerPrincipal(self) -> java.security.Principal: ...
    def getServerCertificateChain(self) -> java.util.List[java.security.cert.Certificate]: ...

class SocketImpl(SocketOptions):
    def __init__(self): ...
    def toString(self) -> str: ...

class StandardProtocolFamily(java.lang.Enum['StandardProtocolFamily'], ProtocolFamily):
    INET: _py_ClassVar['StandardProtocolFamily'] = ...
    INET6: _py_ClassVar['StandardProtocolFamily'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'StandardProtocolFamily': ...
    @classmethod
    def values(cls) -> _py_List['StandardProtocolFamily']: ...

class UnknownContentHandler(ContentHandler):
    @overload
    def getContent(self, uRLConnection: URLConnection, classArray: _py_List[_py_Type]) -> _py_Any: ...
    @overload
    def getContent(self, uRLConnection: URLConnection) -> _py_Any: ...

class AbstractPlainDatagramSocketImpl(DatagramSocketImpl):
    def getOption(self, int: int) -> _py_Any: ...
    def setOption(self, int: int, object: _py_Any) -> None: ...

class AbstractPlainSocketImpl(SocketImpl):
    SHUT_RD: _py_ClassVar[int] = ...
    SHUT_WR: _py_ClassVar[int] = ...
    def getOption(self, int: int) -> _py_Any: ...
    def getTimeout(self) -> int: ...
    def isClosedOrPending(self) -> bool: ...
    def isConnectionReset(self) -> bool: ...
    def isConnectionResetPending(self) -> bool: ...
    def setConnectionReset(self) -> None: ...
    def setConnectionResetPending(self) -> None: ...
    def setOption(self, int: int, object: _py_Any) -> None: ...

class DualStackPlainDatagramSocketImpl(AbstractPlainDatagramSocketImpl): ...

class DualStackPlainSocketImpl(AbstractPlainSocketImpl):
    @overload
    def __init__(self, boolean: bool): ...
    @overload
    def __init__(self, fileDescriptor: java.io.FileDescriptor, boolean: bool): ...

class PlainSocketImpl(AbstractPlainSocketImpl):
    def getOption(self, int: int) -> _py_Any: ...
    def getTimeout(self) -> int: ...
    def isClosedOrPending(self) -> bool: ...
    def isConnectionReset(self) -> bool: ...
    def isConnectionResetPending(self) -> bool: ...
    def setConnectionReset(self) -> None: ...
    def setConnectionResetPending(self) -> None: ...
    def setOption(self, int: int, object: _py_Any) -> None: ...
    def toString(self) -> str: ...

class TwoStacksPlainDatagramSocketImpl(AbstractPlainDatagramSocketImpl):
    def getOption(self, int: int) -> _py_Any: ...

class TwoStacksPlainSocketImpl(AbstractPlainSocketImpl):
    @overload
    def __init__(self, boolean: bool): ...
    @overload
    def __init__(self, fileDescriptor: java.io.FileDescriptor, boolean: bool): ...
    def getOption(self, int: int) -> _py_Any: ...
    def isClosedOrPending(self) -> bool: ...

class HttpConnectSocketImpl(PlainSocketImpl):
    def setOption(self, int: int, object: _py_Any) -> None: ...

class SdpSocketImpl(PlainSocketImpl): ...

class SocksSocketImpl(PlainSocketImpl, SocksConsts): ...
