from typing import Any as _py_Any
from typing import List as _py_List
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.awt
import java.awt.color
import java.awt.geom
import java.lang
import java.math
import java.util


class BufferStrategy:
    def __init__(self): ...
    def contentsLost(self) -> bool: ...
    def contentsRestored(self) -> bool: ...
    def dispose(self) -> None: ...
    def getCapabilities(self) -> java.awt.BufferCapabilities: ...
    def getDrawGraphics(self) -> java.awt.Graphics: ...
    def show(self) -> None: ...

class BufferedImageOp:
    def createCompatibleDestImage(self, bufferedImage: 'BufferedImage', colorModel: 'ColorModel') -> 'BufferedImage': ...
    def filter(self, bufferedImage: 'BufferedImage', bufferedImage2: 'BufferedImage') -> 'BufferedImage': ...
    def getBounds2D(self, bufferedImage: 'BufferedImage') -> java.awt.geom.Rectangle2D: ...
    def getPoint2D(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D) -> java.awt.geom.Point2D: ...
    def getRenderingHints(self) -> java.awt.RenderingHints: ...

class ColorModel(java.awt.Transparency):
    def __init__(self, int: int): ...
    def coerceData(self, writableRaster: 'WritableRaster', boolean: bool) -> 'ColorModel': ...
    def createCompatibleSampleModel(self, int: int, int2: int) -> 'SampleModel': ...
    def createCompatibleWritableRaster(self, int: int, int2: int) -> 'WritableRaster': ...
    def equals(self, object: _py_Any) -> bool: ...
    def finalize(self) -> None: ...
    @overload
    def getAlpha(self, int: int) -> int: ...
    @overload
    def getAlpha(self, object: _py_Any) -> int: ...
    def getAlphaRaster(self, writableRaster: 'WritableRaster') -> 'WritableRaster': ...
    @overload
    def getBlue(self, int: int) -> int: ...
    @overload
    def getBlue(self, object: _py_Any) -> int: ...
    def getColorSpace(self) -> java.awt.color.ColorSpace: ...
    @overload
    def getComponentSize(self, int: int) -> int: ...
    @overload
    def getComponentSize(self) -> _py_List[int]: ...
    @overload
    def getComponents(self, int: int, intArray: _py_List[int], int3: int) -> _py_List[int]: ...
    @overload
    def getComponents(self, object: _py_Any, intArray: _py_List[int], int2: int) -> _py_List[int]: ...
    @overload
    def getDataElement(self, floatArray: _py_List[float], int: int) -> int: ...
    @overload
    def getDataElement(self, intArray: _py_List[int], int2: int) -> int: ...
    @overload
    def getDataElements(self, floatArray: _py_List[float], int: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getDataElements(self, int: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getDataElements(self, intArray: _py_List[int], int2: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getGreen(self, int: int) -> int: ...
    @overload
    def getGreen(self, object: _py_Any) -> int: ...
    @overload
    def getNormalizedComponents(self, intArray: _py_List[int], int2: int, floatArray: _py_List[float], int3: int) -> _py_List[float]: ...
    @overload
    def getNormalizedComponents(self, object: _py_Any, floatArray: _py_List[float], int: int) -> _py_List[float]: ...
    def getNumColorComponents(self) -> int: ...
    def getNumComponents(self) -> int: ...
    def getPixelSize(self) -> int: ...
    @overload
    def getRGB(self, int: int) -> int: ...
    @overload
    def getRGB(self, object: _py_Any) -> int: ...
    @classmethod
    def getRGBdefault(cls) -> 'ColorModel': ...
    @overload
    def getRed(self, int: int) -> int: ...
    @overload
    def getRed(self, object: _py_Any) -> int: ...
    def getTransferType(self) -> int: ...
    def getTransparency(self) -> int: ...
    def getUnnormalizedComponents(self, floatArray: _py_List[float], int: int, intArray: _py_List[int], int3: int) -> _py_List[int]: ...
    def hasAlpha(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isAlphaPremultiplied(self) -> bool: ...
    def isCompatibleRaster(self, raster: 'Raster') -> bool: ...
    def isCompatibleSampleModel(self, sampleModel: 'SampleModel') -> bool: ...
    def toString(self) -> str: ...

class DataBuffer:
    TYPE_BYTE: _py_ClassVar[int] = ...
    TYPE_USHORT: _py_ClassVar[int] = ...
    TYPE_SHORT: _py_ClassVar[int] = ...
    TYPE_INT: _py_ClassVar[int] = ...
    TYPE_FLOAT: _py_ClassVar[int] = ...
    TYPE_DOUBLE: _py_ClassVar[int] = ...
    TYPE_UNDEFINED: _py_ClassVar[int] = ...
    def getDataType(self) -> int: ...
    @classmethod
    def getDataTypeSize(cls, int: int) -> int: ...
    @overload
    def getElem(self, int: int, int2: int) -> int: ...
    @overload
    def getElem(self, int: int) -> int: ...
    @overload
    def getElemDouble(self, int: int) -> float: ...
    @overload
    def getElemDouble(self, int: int, int2: int) -> float: ...
    @overload
    def getElemFloat(self, int: int) -> float: ...
    @overload
    def getElemFloat(self, int: int, int2: int) -> float: ...
    def getNumBanks(self) -> int: ...
    def getOffset(self) -> int: ...
    def getOffsets(self) -> _py_List[int]: ...
    def getSize(self) -> int: ...
    @overload
    def setElem(self, int: int, int2: int, int3: int) -> None: ...
    @overload
    def setElem(self, int: int, int2: int) -> None: ...
    @overload
    def setElemDouble(self, int: int, double: float) -> None: ...
    @overload
    def setElemDouble(self, int: int, int2: int, double: float) -> None: ...
    @overload
    def setElemFloat(self, int: int, float: float) -> None: ...
    @overload
    def setElemFloat(self, int: int, int2: int, float: float) -> None: ...

class ImageConsumer:
    RANDOMPIXELORDER: _py_ClassVar[int] = ...
    TOPDOWNLEFTRIGHT: _py_ClassVar[int] = ...
    COMPLETESCANLINES: _py_ClassVar[int] = ...
    SINGLEPASS: _py_ClassVar[int] = ...
    SINGLEFRAME: _py_ClassVar[int] = ...
    IMAGEERROR: _py_ClassVar[int] = ...
    SINGLEFRAMEDONE: _py_ClassVar[int] = ...
    STATICIMAGEDONE: _py_ClassVar[int] = ...
    IMAGEABORTED: _py_ClassVar[int] = ...
    def imageComplete(self, int: int) -> None: ...
    def setColorModel(self, colorModel: ColorModel) -> None: ...
    def setDimensions(self, int: int, int2: int) -> None: ...
    def setHints(self, int: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, byteArray: _py_List[int], int5: int, int6: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, intArray: _py_List[int], int6: int, int7: int) -> None: ...
    def setProperties(self, hashtable: java.util.Hashtable[_py_Any, _py_Any]) -> None: ...

class ImageObserver:
    WIDTH: _py_ClassVar[int] = ...
    HEIGHT: _py_ClassVar[int] = ...
    PROPERTIES: _py_ClassVar[int] = ...
    SOMEBITS: _py_ClassVar[int] = ...
    FRAMEBITS: _py_ClassVar[int] = ...
    ALLBITS: _py_ClassVar[int] = ...
    ERROR: _py_ClassVar[int] = ...
    ABORT: _py_ClassVar[int] = ...
    def imageUpdate(self, image: java.awt.Image, int: int, int2: int, int3: int, int4: int, int5: int) -> bool: ...

class ImageProducer:
    def addConsumer(self, imageConsumer: ImageConsumer) -> None: ...
    def isConsumer(self, imageConsumer: ImageConsumer) -> bool: ...
    def removeConsumer(self, imageConsumer: ImageConsumer) -> None: ...
    def requestTopDownLeftRightResend(self, imageConsumer: ImageConsumer) -> None: ...
    def startProduction(self, imageConsumer: ImageConsumer) -> None: ...

class ImagingOpException(java.lang.RuntimeException):
    def __init__(self, string: str): ...

class Kernel(java.lang.Cloneable):
    def __init__(self, int: int, int2: int, floatArray: _py_List[float]): ...
    def clone(self) -> _py_Any: ...
    def getHeight(self) -> int: ...
    def getKernelData(self, floatArray: _py_List[float]) -> _py_List[float]: ...
    def getWidth(self) -> int: ...
    def getXOrigin(self) -> int: ...
    def getYOrigin(self) -> int: ...

class LookupTable:
    def getNumComponents(self) -> int: ...
    def getOffset(self) -> int: ...
    def lookupPixel(self, intArray: _py_List[int], intArray2: _py_List[int]) -> _py_List[int]: ...

class Raster:
    @classmethod
    @overload
    def createBandedRaster(cls, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], intArray2: _py_List[int], point: java.awt.Point) -> 'WritableRaster': ...
    @classmethod
    @overload
    def createBandedRaster(cls, int: int, int2: int, int3: int, int4: int, point: java.awt.Point) -> 'WritableRaster': ...
    @classmethod
    @overload
    def createBandedRaster(cls, dataBuffer: DataBuffer, int: int, int2: int, int3: int, intArray: _py_List[int], intArray2: _py_List[int], point: java.awt.Point) -> 'WritableRaster': ...
    def createChild(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, intArray: _py_List[int]) -> 'Raster': ...
    @overload
    def createCompatibleWritableRaster(self) -> 'WritableRaster': ...
    @overload
    def createCompatibleWritableRaster(self, int: int, int2: int) -> 'WritableRaster': ...
    @overload
    def createCompatibleWritableRaster(self, int: int, int2: int, int3: int, int4: int) -> 'WritableRaster': ...
    @overload
    def createCompatibleWritableRaster(self, rectangle: java.awt.Rectangle) -> 'WritableRaster': ...
    @classmethod
    @overload
    def createInterleavedRaster(cls, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int], point: java.awt.Point) -> 'WritableRaster': ...
    @classmethod
    @overload
    def createInterleavedRaster(cls, int: int, int2: int, int3: int, int4: int, point: java.awt.Point) -> 'WritableRaster': ...
    @classmethod
    @overload
    def createInterleavedRaster(cls, dataBuffer: DataBuffer, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], point: java.awt.Point) -> 'WritableRaster': ...
    @classmethod
    @overload
    def createPackedRaster(cls, int: int, int2: int, int3: int, int4: int, int5: int, point: java.awt.Point) -> 'WritableRaster': ...
    @classmethod
    @overload
    def createPackedRaster(cls, int: int, int2: int, int3: int, intArray: _py_List[int], point: java.awt.Point) -> 'WritableRaster': ...
    @classmethod
    @overload
    def createPackedRaster(cls, dataBuffer: DataBuffer, int: int, int2: int, int3: int, intArray: _py_List[int], point: java.awt.Point) -> 'WritableRaster': ...
    @classmethod
    @overload
    def createPackedRaster(cls, dataBuffer: DataBuffer, int: int, int2: int, int3: int, point: java.awt.Point) -> 'WritableRaster': ...
    @classmethod
    def createRaster(cls, sampleModel: 'SampleModel', dataBuffer: DataBuffer, point: java.awt.Point) -> 'Raster': ...
    def createTranslatedChild(self, int: int, int2: int) -> 'Raster': ...
    @classmethod
    @overload
    def createWritableRaster(cls, sampleModel: 'SampleModel', point: java.awt.Point) -> 'WritableRaster': ...
    @classmethod
    @overload
    def createWritableRaster(cls, sampleModel: 'SampleModel', dataBuffer: DataBuffer, point: java.awt.Point) -> 'WritableRaster': ...
    def getBounds(self) -> java.awt.Rectangle: ...
    def getDataBuffer(self) -> DataBuffer: ...
    @overload
    def getDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getDataElements(self, int: int, int2: int, object: _py_Any) -> _py_Any: ...
    def getHeight(self) -> int: ...
    def getMinX(self) -> int: ...
    def getMinY(self) -> int: ...
    def getNumBands(self) -> int: ...
    def getNumDataElements(self) -> int: ...
    def getParent(self) -> 'Raster': ...
    @overload
    def getPixel(self, int: int, int2: int, doubleArray: _py_List[float]) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, floatArray: _py_List[float]) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, intArray: _py_List[int]) -> _py_List[int]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, doubleArray: _py_List[float]) -> _py_List[float]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, floatArray: _py_List[float]) -> _py_List[float]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int]) -> _py_List[int]: ...
    def getSample(self, int: int, int2: int, int3: int) -> int: ...
    def getSampleDouble(self, int: int, int2: int, int3: int) -> float: ...
    def getSampleFloat(self, int: int, int2: int, int3: int) -> float: ...
    def getSampleModel(self) -> 'SampleModel': ...
    def getSampleModelTranslateX(self) -> int: ...
    def getSampleModelTranslateY(self) -> int: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, doubleArray: _py_List[float]) -> _py_List[float]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, floatArray: _py_List[float]) -> _py_List[float]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int]) -> _py_List[int]: ...
    def getTransferType(self) -> int: ...
    def getWidth(self) -> int: ...

class RasterFormatException(java.lang.RuntimeException):
    def __init__(self, string: str): ...

class RasterOp:
    def createCompatibleDestRaster(self, raster: Raster) -> 'WritableRaster': ...
    def filter(self, raster: Raster, writableRaster: 'WritableRaster') -> 'WritableRaster': ...
    def getBounds2D(self, raster: Raster) -> java.awt.geom.Rectangle2D: ...
    def getPoint2D(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D) -> java.awt.geom.Point2D: ...
    def getRenderingHints(self) -> java.awt.RenderingHints: ...

class RenderedImage:
    def copyData(self, writableRaster: 'WritableRaster') -> 'WritableRaster': ...
    def getColorModel(self) -> ColorModel: ...
    @overload
    def getData(self) -> Raster: ...
    @overload
    def getData(self, rectangle: java.awt.Rectangle) -> Raster: ...
    def getHeight(self) -> int: ...
    def getMinTileX(self) -> int: ...
    def getMinTileY(self) -> int: ...
    def getMinX(self) -> int: ...
    def getMinY(self) -> int: ...
    def getNumXTiles(self) -> int: ...
    def getNumYTiles(self) -> int: ...
    def getProperty(self, string: str) -> _py_Any: ...
    def getPropertyNames(self) -> _py_List[str]: ...
    def getSampleModel(self) -> 'SampleModel': ...
    def getSources(self) -> java.util.Vector['RenderedImage']: ...
    def getTile(self, int: int, int2: int) -> Raster: ...
    def getTileGridXOffset(self) -> int: ...
    def getTileGridYOffset(self) -> int: ...
    def getTileHeight(self) -> int: ...
    def getTileWidth(self) -> int: ...
    def getWidth(self) -> int: ...

class SampleModel:
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    def createCompatibleSampleModel(self, int: int, int2: int) -> 'SampleModel': ...
    def createDataBuffer(self) -> DataBuffer: ...
    def createSubsetSampleModel(self, intArray: _py_List[int]) -> 'SampleModel': ...
    @overload
    def getDataElements(self, int: int, int2: int, object: _py_Any, dataBuffer: DataBuffer) -> _py_Any: ...
    @overload
    def getDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any, dataBuffer: DataBuffer) -> _py_Any: ...
    def getDataType(self) -> int: ...
    def getHeight(self) -> int: ...
    def getNumBands(self) -> int: ...
    def getNumDataElements(self) -> int: ...
    @overload
    def getPixel(self, int: int, int2: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    def getSample(self, int: int, int2: int, int3: int, dataBuffer: DataBuffer) -> int: ...
    def getSampleDouble(self, int: int, int2: int, int3: int, dataBuffer: DataBuffer) -> float: ...
    def getSampleFloat(self, int: int, int2: int, int3: int, dataBuffer: DataBuffer) -> float: ...
    @overload
    def getSampleSize(self, int: int) -> int: ...
    @overload
    def getSampleSize(self) -> _py_List[int]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    def getTransferType(self) -> int: ...
    def getWidth(self) -> int: ...
    @overload
    def setDataElements(self, int: int, int2: int, object: _py_Any, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, int4: int, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, double: float, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, float: float, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...

class TileObserver:
    def tileUpdate(self, writableRenderedImage: 'WritableRenderedImage', int: int, int2: int, boolean: bool) -> None: ...

class VolatileImage(java.awt.Image, java.awt.Transparency):
    IMAGE_OK: _py_ClassVar[int] = ...
    IMAGE_RESTORED: _py_ClassVar[int] = ...
    IMAGE_INCOMPATIBLE: _py_ClassVar[int] = ...
    def __init__(self): ...
    def contentsLost(self) -> bool: ...
    def createGraphics(self) -> java.awt.Graphics2D: ...
    @overload
    def getCapabilities(self) -> java.awt.ImageCapabilities: ...
    @overload
    def getCapabilities(self, graphicsConfiguration: java.awt.GraphicsConfiguration) -> java.awt.ImageCapabilities: ...
    def getGraphics(self) -> java.awt.Graphics: ...
    @overload
    def getHeight(self, imageObserver: ImageObserver) -> int: ...
    @overload
    def getHeight(self) -> int: ...
    def getSnapshot(self) -> 'BufferedImage': ...
    def getSource(self) -> ImageProducer: ...
    def getTransparency(self) -> int: ...
    @overload
    def getWidth(self, imageObserver: ImageObserver) -> int: ...
    @overload
    def getWidth(self) -> int: ...
    def validate(self, graphicsConfiguration: java.awt.GraphicsConfiguration) -> int: ...

class AffineTransformOp(BufferedImageOp, RasterOp):
    TYPE_NEAREST_NEIGHBOR: _py_ClassVar[int] = ...
    TYPE_BILINEAR: _py_ClassVar[int] = ...
    TYPE_BICUBIC: _py_ClassVar[int] = ...
    @overload
    def __init__(self, affineTransform: java.awt.geom.AffineTransform, int: int): ...
    @overload
    def __init__(self, affineTransform: java.awt.geom.AffineTransform, renderingHints: java.awt.RenderingHints): ...
    def createCompatibleDestImage(self, bufferedImage: 'BufferedImage', colorModel: ColorModel) -> 'BufferedImage': ...
    def createCompatibleDestRaster(self, raster: Raster) -> 'WritableRaster': ...
    @overload
    def filter(self, bufferedImage: 'BufferedImage', bufferedImage2: 'BufferedImage') -> 'BufferedImage': ...
    @overload
    def filter(self, raster: Raster, writableRaster: 'WritableRaster') -> 'WritableRaster': ...
    @overload
    def getBounds2D(self, bufferedImage: 'BufferedImage') -> java.awt.geom.Rectangle2D: ...
    @overload
    def getBounds2D(self, raster: Raster) -> java.awt.geom.Rectangle2D: ...
    def getInterpolationType(self) -> int: ...
    def getPoint2D(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D) -> java.awt.geom.Point2D: ...
    def getRenderingHints(self) -> java.awt.RenderingHints: ...
    def getTransform(self) -> java.awt.geom.AffineTransform: ...

class BandCombineOp(RasterOp):
    def __init__(self, floatArray: _py_List[_py_List[float]], renderingHints: java.awt.RenderingHints): ...
    def createCompatibleDestRaster(self, raster: Raster) -> 'WritableRaster': ...
    def filter(self, raster: Raster, writableRaster: 'WritableRaster') -> 'WritableRaster': ...
    def getBounds2D(self, raster: Raster) -> java.awt.geom.Rectangle2D: ...
    def getMatrix(self) -> _py_List[_py_List[float]]: ...
    def getPoint2D(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D) -> java.awt.geom.Point2D: ...
    def getRenderingHints(self) -> java.awt.RenderingHints: ...

class ByteLookupTable(LookupTable):
    @overload
    def __init__(self, int: int, byteArray: _py_List[int]): ...
    @overload
    def __init__(self, int: int, byteArray: _py_List[_py_List[int]]): ...
    def getTable(self) -> _py_List[_py_List[int]]: ...
    @overload
    def lookupPixel(self, byteArray: _py_List[int], byteArray2: _py_List[int]) -> _py_List[int]: ...
    @overload
    def lookupPixel(self, intArray: _py_List[int], intArray2: _py_List[int]) -> _py_List[int]: ...

class ColorConvertOp(BufferedImageOp, RasterOp):
    @overload
    def __init__(self, renderingHints: java.awt.RenderingHints): ...
    @overload
    def __init__(self, colorSpace: java.awt.color.ColorSpace, renderingHints: java.awt.RenderingHints): ...
    @overload
    def __init__(self, colorSpace: java.awt.color.ColorSpace, colorSpace2: java.awt.color.ColorSpace, renderingHints: java.awt.RenderingHints): ...
    @overload
    def __init__(self, iCC_ProfileArray: _py_List[java.awt.color.ICC_Profile], renderingHints: java.awt.RenderingHints): ...
    def createCompatibleDestImage(self, bufferedImage: 'BufferedImage', colorModel: ColorModel) -> 'BufferedImage': ...
    def createCompatibleDestRaster(self, raster: Raster) -> 'WritableRaster': ...
    @overload
    def filter(self, bufferedImage: 'BufferedImage', bufferedImage2: 'BufferedImage') -> 'BufferedImage': ...
    @overload
    def filter(self, raster: Raster, writableRaster: 'WritableRaster') -> 'WritableRaster': ...
    @overload
    def getBounds2D(self, bufferedImage: 'BufferedImage') -> java.awt.geom.Rectangle2D: ...
    @overload
    def getBounds2D(self, raster: Raster) -> java.awt.geom.Rectangle2D: ...
    def getICC_Profiles(self) -> _py_List[java.awt.color.ICC_Profile]: ...
    def getPoint2D(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D) -> java.awt.geom.Point2D: ...
    def getRenderingHints(self) -> java.awt.RenderingHints: ...

class ComponentColorModel(ColorModel):
    @overload
    def __init__(self, colorSpace: java.awt.color.ColorSpace, boolean: bool, boolean2: bool, int: int, int2: int): ...
    @overload
    def __init__(self, colorSpace: java.awt.color.ColorSpace, intArray: _py_List[int], boolean: bool, boolean2: bool, int2: int, int3: int): ...
    def coerceData(self, writableRaster: 'WritableRaster', boolean: bool) -> ColorModel: ...
    def createCompatibleSampleModel(self, int: int, int2: int) -> SampleModel: ...
    def createCompatibleWritableRaster(self, int: int, int2: int) -> 'WritableRaster': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getAlpha(self, int: int) -> int: ...
    @overload
    def getAlpha(self, object: _py_Any) -> int: ...
    def getAlphaRaster(self, writableRaster: 'WritableRaster') -> 'WritableRaster': ...
    @overload
    def getBlue(self, int: int) -> int: ...
    @overload
    def getBlue(self, object: _py_Any) -> int: ...
    @overload
    def getComponents(self, int: int, intArray: _py_List[int], int3: int) -> _py_List[int]: ...
    @overload
    def getComponents(self, object: _py_Any, intArray: _py_List[int], int2: int) -> _py_List[int]: ...
    @overload
    def getDataElement(self, floatArray: _py_List[float], int: int) -> int: ...
    @overload
    def getDataElement(self, intArray: _py_List[int], int2: int) -> int: ...
    @overload
    def getDataElements(self, floatArray: _py_List[float], int: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getDataElements(self, int: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getDataElements(self, intArray: _py_List[int], int2: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getGreen(self, int: int) -> int: ...
    @overload
    def getGreen(self, object: _py_Any) -> int: ...
    @overload
    def getNormalizedComponents(self, intArray: _py_List[int], int2: int, floatArray: _py_List[float], int3: int) -> _py_List[float]: ...
    @overload
    def getNormalizedComponents(self, object: _py_Any, floatArray: _py_List[float], int: int) -> _py_List[float]: ...
    @overload
    def getRGB(self, int: int) -> int: ...
    @overload
    def getRGB(self, object: _py_Any) -> int: ...
    @overload
    def getRed(self, int: int) -> int: ...
    @overload
    def getRed(self, object: _py_Any) -> int: ...
    def getUnnormalizedComponents(self, floatArray: _py_List[float], int: int, intArray: _py_List[int], int3: int) -> _py_List[int]: ...
    def isCompatibleRaster(self, raster: Raster) -> bool: ...
    def isCompatibleSampleModel(self, sampleModel: SampleModel) -> bool: ...

class ComponentSampleModel(SampleModel):
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int]): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int], intArray2: _py_List[int]): ...
    def createCompatibleSampleModel(self, int: int, int2: int) -> SampleModel: ...
    def createDataBuffer(self) -> DataBuffer: ...
    def createSubsetSampleModel(self, intArray: _py_List[int]) -> SampleModel: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getBandOffsets(self) -> _py_List[int]: ...
    def getBankIndices(self) -> _py_List[int]: ...
    @overload
    def getDataElements(self, int: int, int2: int, object: _py_Any, dataBuffer: DataBuffer) -> _py_Any: ...
    @overload
    def getDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any, dataBuffer: DataBuffer) -> _py_Any: ...
    def getNumDataElements(self) -> int: ...
    @overload
    def getOffset(self, int: int, int2: int) -> int: ...
    @overload
    def getOffset(self, int: int, int2: int, int3: int) -> int: ...
    @overload
    def getPixel(self, int: int, int2: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    def getPixelStride(self) -> int: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    def getSample(self, int: int, int2: int, int3: int, dataBuffer: DataBuffer) -> int: ...
    def getSampleDouble(self, int: int, int2: int, int3: int, dataBuffer: DataBuffer) -> float: ...
    def getSampleFloat(self, int: int, int2: int, int3: int, dataBuffer: DataBuffer) -> float: ...
    @overload
    def getSampleSize(self, int: int) -> int: ...
    @overload
    def getSampleSize(self) -> _py_List[int]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    def getScanlineStride(self) -> int: ...
    def hashCode(self) -> int: ...
    @overload
    def setDataElements(self, int: int, int2: int, object: _py_Any, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, double: float, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, float: float, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, int4: int, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...

class ConvolveOp(BufferedImageOp, RasterOp):
    EDGE_ZERO_FILL: _py_ClassVar[int] = ...
    EDGE_NO_OP: _py_ClassVar[int] = ...
    @overload
    def __init__(self, kernel: Kernel): ...
    @overload
    def __init__(self, kernel: Kernel, int: int, renderingHints: java.awt.RenderingHints): ...
    def createCompatibleDestImage(self, bufferedImage: 'BufferedImage', colorModel: ColorModel) -> 'BufferedImage': ...
    def createCompatibleDestRaster(self, raster: Raster) -> 'WritableRaster': ...
    @overload
    def filter(self, bufferedImage: 'BufferedImage', bufferedImage2: 'BufferedImage') -> 'BufferedImage': ...
    @overload
    def filter(self, raster: Raster, writableRaster: 'WritableRaster') -> 'WritableRaster': ...
    @overload
    def getBounds2D(self, bufferedImage: 'BufferedImage') -> java.awt.geom.Rectangle2D: ...
    @overload
    def getBounds2D(self, raster: Raster) -> java.awt.geom.Rectangle2D: ...
    def getEdgeCondition(self) -> int: ...
    def getKernel(self) -> Kernel: ...
    def getPoint2D(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D) -> java.awt.geom.Point2D: ...
    def getRenderingHints(self) -> java.awt.RenderingHints: ...

class DataBufferByte(DataBuffer):
    @overload
    def __init__(self, byteArray: _py_List[int], int: int): ...
    @overload
    def __init__(self, byteArray: _py_List[int], int: int, int2: int): ...
    @overload
    def __init__(self, byteArray: _py_List[_py_List[int]], int: int): ...
    @overload
    def __init__(self, byteArray: _py_List[_py_List[int]], int: int, intArray: _py_List[int]): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    def getBankData(self) -> _py_List[_py_List[int]]: ...
    @overload
    def getData(self) -> _py_List[int]: ...
    @overload
    def getData(self, int: int) -> _py_List[int]: ...
    @overload
    def getElem(self, int: int) -> int: ...
    @overload
    def getElem(self, int: int, int2: int) -> int: ...
    @overload
    def setElem(self, int: int, int2: int) -> None: ...
    @overload
    def setElem(self, int: int, int2: int, int3: int) -> None: ...

class DataBufferDouble(DataBuffer):
    @overload
    def __init__(self, doubleArray: _py_List[float], int: int): ...
    @overload
    def __init__(self, doubleArray: _py_List[float], int: int, int2: int): ...
    @overload
    def __init__(self, doubleArray: _py_List[_py_List[float]], int: int): ...
    @overload
    def __init__(self, doubleArray: _py_List[_py_List[float]], int: int, intArray: _py_List[int]): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    def getBankData(self) -> _py_List[_py_List[float]]: ...
    @overload
    def getData(self) -> _py_List[float]: ...
    @overload
    def getData(self, int: int) -> _py_List[float]: ...
    @overload
    def getElem(self, int: int) -> int: ...
    @overload
    def getElem(self, int: int, int2: int) -> int: ...
    @overload
    def getElemDouble(self, int: int) -> float: ...
    @overload
    def getElemDouble(self, int: int, int2: int) -> float: ...
    @overload
    def getElemFloat(self, int: int) -> float: ...
    @overload
    def getElemFloat(self, int: int, int2: int) -> float: ...
    @overload
    def setElem(self, int: int, int2: int) -> None: ...
    @overload
    def setElem(self, int: int, int2: int, int3: int) -> None: ...
    @overload
    def setElemDouble(self, int: int, double: float) -> None: ...
    @overload
    def setElemDouble(self, int: int, int2: int, double: float) -> None: ...
    @overload
    def setElemFloat(self, int: int, float: float) -> None: ...
    @overload
    def setElemFloat(self, int: int, int2: int, float: float) -> None: ...

class DataBufferFloat(DataBuffer):
    @overload
    def __init__(self, floatArray: _py_List[float], int: int): ...
    @overload
    def __init__(self, floatArray: _py_List[float], int: int, int2: int): ...
    @overload
    def __init__(self, floatArray: _py_List[_py_List[float]], int: int): ...
    @overload
    def __init__(self, floatArray: _py_List[_py_List[float]], int: int, intArray: _py_List[int]): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    def getBankData(self) -> _py_List[_py_List[float]]: ...
    @overload
    def getData(self) -> _py_List[float]: ...
    @overload
    def getData(self, int: int) -> _py_List[float]: ...
    @overload
    def getElem(self, int: int) -> int: ...
    @overload
    def getElem(self, int: int, int2: int) -> int: ...
    @overload
    def getElemDouble(self, int: int) -> float: ...
    @overload
    def getElemDouble(self, int: int, int2: int) -> float: ...
    @overload
    def getElemFloat(self, int: int) -> float: ...
    @overload
    def getElemFloat(self, int: int, int2: int) -> float: ...
    @overload
    def setElem(self, int: int, int2: int) -> None: ...
    @overload
    def setElem(self, int: int, int2: int, int3: int) -> None: ...
    @overload
    def setElemDouble(self, int: int, double: float) -> None: ...
    @overload
    def setElemDouble(self, int: int, int2: int, double: float) -> None: ...
    @overload
    def setElemFloat(self, int: int, float: float) -> None: ...
    @overload
    def setElemFloat(self, int: int, int2: int, float: float) -> None: ...

class DataBufferInt(DataBuffer):
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    @overload
    def __init__(self, intArray: _py_List[int], int2: int): ...
    @overload
    def __init__(self, intArray: _py_List[int], int2: int, int3: int): ...
    @overload
    def __init__(self, intArray: _py_List[_py_List[int]], int2: int): ...
    @overload
    def __init__(self, intArray: _py_List[_py_List[int]], int2: int, intArray2: _py_List[int]): ...
    def getBankData(self) -> _py_List[_py_List[int]]: ...
    @overload
    def getData(self) -> _py_List[int]: ...
    @overload
    def getData(self, int: int) -> _py_List[int]: ...
    @overload
    def getElem(self, int: int) -> int: ...
    @overload
    def getElem(self, int: int, int2: int) -> int: ...
    @overload
    def setElem(self, int: int, int2: int) -> None: ...
    @overload
    def setElem(self, int: int, int2: int, int3: int) -> None: ...

class DataBufferShort(DataBuffer):
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    @overload
    def __init__(self, shortArray: _py_List[int], int: int): ...
    @overload
    def __init__(self, shortArray: _py_List[int], int: int, int2: int): ...
    @overload
    def __init__(self, shortArray: _py_List[_py_List[int]], int: int): ...
    @overload
    def __init__(self, shortArray: _py_List[_py_List[int]], int: int, intArray: _py_List[int]): ...
    def getBankData(self) -> _py_List[_py_List[int]]: ...
    @overload
    def getData(self) -> _py_List[int]: ...
    @overload
    def getData(self, int: int) -> _py_List[int]: ...
    @overload
    def getElem(self, int: int) -> int: ...
    @overload
    def getElem(self, int: int, int2: int) -> int: ...
    @overload
    def setElem(self, int: int, int2: int) -> None: ...
    @overload
    def setElem(self, int: int, int2: int, int3: int) -> None: ...

class DataBufferUShort(DataBuffer):
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    @overload
    def __init__(self, shortArray: _py_List[int], int: int): ...
    @overload
    def __init__(self, shortArray: _py_List[int], int: int, int2: int): ...
    @overload
    def __init__(self, shortArray: _py_List[_py_List[int]], int: int): ...
    @overload
    def __init__(self, shortArray: _py_List[_py_List[int]], int: int, intArray: _py_List[int]): ...
    def getBankData(self) -> _py_List[_py_List[int]]: ...
    @overload
    def getData(self) -> _py_List[int]: ...
    @overload
    def getData(self, int: int) -> _py_List[int]: ...
    @overload
    def getElem(self, int: int) -> int: ...
    @overload
    def getElem(self, int: int, int2: int) -> int: ...
    @overload
    def setElem(self, int: int, int2: int) -> None: ...
    @overload
    def setElem(self, int: int, int2: int, int3: int) -> None: ...

class FilteredImageSource(ImageProducer):
    def __init__(self, imageProducer: ImageProducer, imageFilter: 'ImageFilter'): ...
    def addConsumer(self, imageConsumer: ImageConsumer) -> None: ...
    def isConsumer(self, imageConsumer: ImageConsumer) -> bool: ...
    def removeConsumer(self, imageConsumer: ImageConsumer) -> None: ...
    def requestTopDownLeftRightResend(self, imageConsumer: ImageConsumer) -> None: ...
    def startProduction(self, imageConsumer: ImageConsumer) -> None: ...

class ImageFilter(ImageConsumer, java.lang.Cloneable):
    def __init__(self): ...
    def clone(self) -> _py_Any: ...
    def getFilterInstance(self, imageConsumer: ImageConsumer) -> 'ImageFilter': ...
    def imageComplete(self, int: int) -> None: ...
    def resendTopDownLeftRight(self, imageProducer: ImageProducer) -> None: ...
    def setColorModel(self, colorModel: ColorModel) -> None: ...
    def setDimensions(self, int: int, int2: int) -> None: ...
    def setHints(self, int: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, byteArray: _py_List[int], int5: int, int6: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, intArray: _py_List[int], int6: int, int7: int) -> None: ...
    def setProperties(self, hashtable: java.util.Hashtable[_py_Any, _py_Any]) -> None: ...

class IndexColorModel(ColorModel):
    @overload
    def __init__(self, int: int, int2: int, byteArray: _py_List[int], byteArray2: _py_List[int], byteArray3: _py_List[int]): ...
    @overload
    def __init__(self, int: int, int2: int, byteArray: _py_List[int], byteArray2: _py_List[int], byteArray3: _py_List[int], byteArray4: _py_List[int]): ...
    @overload
    def __init__(self, int: int, int2: int, byteArray: _py_List[int], byteArray2: _py_List[int], byteArray3: _py_List[int], int3: int): ...
    @overload
    def __init__(self, int: int, int2: int, byteArray: _py_List[int], int3: int, boolean: bool): ...
    @overload
    def __init__(self, int: int, int2: int, byteArray: _py_List[int], int3: int, boolean: bool, int4: int): ...
    @overload
    def __init__(self, int: int, int2: int, intArray: _py_List[int], int4: int, boolean: bool, int5: int, int6: int): ...
    @overload
    def __init__(self, int: int, int2: int, intArray: _py_List[int], int4: int, int5: int, bigInteger: java.math.BigInteger): ...
    def convertToIntDiscrete(self, raster: Raster, boolean: bool) -> 'BufferedImage': ...
    def createCompatibleSampleModel(self, int: int, int2: int) -> SampleModel: ...
    def createCompatibleWritableRaster(self, int: int, int2: int) -> 'WritableRaster': ...
    def finalize(self) -> None: ...
    @overload
    def getAlpha(self, int: int) -> int: ...
    @overload
    def getAlpha(self, object: _py_Any) -> int: ...
    def getAlphas(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def getBlue(self, int: int) -> int: ...
    @overload
    def getBlue(self, object: _py_Any) -> int: ...
    def getBlues(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def getComponentSize(self, int: int) -> int: ...
    @overload
    def getComponentSize(self) -> _py_List[int]: ...
    @overload
    def getComponents(self, int: int, intArray: _py_List[int], int3: int) -> _py_List[int]: ...
    @overload
    def getComponents(self, object: _py_Any, intArray: _py_List[int], int2: int) -> _py_List[int]: ...
    @overload
    def getDataElement(self, floatArray: _py_List[float], int: int) -> int: ...
    @overload
    def getDataElement(self, intArray: _py_List[int], int2: int) -> int: ...
    @overload
    def getDataElements(self, floatArray: _py_List[float], int: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getDataElements(self, intArray: _py_List[int], int2: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getDataElements(self, int: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getGreen(self, int: int) -> int: ...
    @overload
    def getGreen(self, object: _py_Any) -> int: ...
    def getGreens(self, byteArray: _py_List[int]) -> None: ...
    def getMapSize(self) -> int: ...
    @overload
    def getRGB(self, int: int) -> int: ...
    @overload
    def getRGB(self, object: _py_Any) -> int: ...
    def getRGBs(self, intArray: _py_List[int]) -> None: ...
    @overload
    def getRed(self, int: int) -> int: ...
    @overload
    def getRed(self, object: _py_Any) -> int: ...
    def getReds(self, byteArray: _py_List[int]) -> None: ...
    def getTransparency(self) -> int: ...
    def getTransparentPixel(self) -> int: ...
    def getValidPixels(self) -> java.math.BigInteger: ...
    def isCompatibleRaster(self, raster: Raster) -> bool: ...
    def isCompatibleSampleModel(self, sampleModel: SampleModel) -> bool: ...
    @overload
    def isValid(self) -> bool: ...
    @overload
    def isValid(self, int: int) -> bool: ...
    def toString(self) -> str: ...

class LookupOp(BufferedImageOp, RasterOp):
    def __init__(self, lookupTable: LookupTable, renderingHints: java.awt.RenderingHints): ...
    def createCompatibleDestImage(self, bufferedImage: 'BufferedImage', colorModel: ColorModel) -> 'BufferedImage': ...
    def createCompatibleDestRaster(self, raster: Raster) -> 'WritableRaster': ...
    @overload
    def filter(self, bufferedImage: 'BufferedImage', bufferedImage2: 'BufferedImage') -> 'BufferedImage': ...
    @overload
    def filter(self, raster: Raster, writableRaster: 'WritableRaster') -> 'WritableRaster': ...
    @overload
    def getBounds2D(self, bufferedImage: 'BufferedImage') -> java.awt.geom.Rectangle2D: ...
    @overload
    def getBounds2D(self, raster: Raster) -> java.awt.geom.Rectangle2D: ...
    def getPoint2D(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D) -> java.awt.geom.Point2D: ...
    def getRenderingHints(self) -> java.awt.RenderingHints: ...
    def getTable(self) -> LookupTable: ...

class MemoryImageSource(ImageProducer):
    @overload
    def __init__(self, int: int, int2: int, intArray: _py_List[int], int4: int, int5: int): ...
    @overload
    def __init__(self, int: int, int2: int, intArray: _py_List[int], int4: int, int5: int, hashtable: java.util.Hashtable[_py_Any, _py_Any]): ...
    @overload
    def __init__(self, int: int, int2: int, colorModel: ColorModel, byteArray: _py_List[int], int3: int, int4: int): ...
    @overload
    def __init__(self, int: int, int2: int, colorModel: ColorModel, byteArray: _py_List[int], int3: int, int4: int, hashtable: java.util.Hashtable[_py_Any, _py_Any]): ...
    @overload
    def __init__(self, int: int, int2: int, colorModel: ColorModel, intArray: _py_List[int], int4: int, int5: int): ...
    @overload
    def __init__(self, int: int, int2: int, colorModel: ColorModel, intArray: _py_List[int], int4: int, int5: int, hashtable: java.util.Hashtable[_py_Any, _py_Any]): ...
    def addConsumer(self, imageConsumer: ImageConsumer) -> None: ...
    def isConsumer(self, imageConsumer: ImageConsumer) -> bool: ...
    @overload
    def newPixels(self, byteArray: _py_List[int], colorModel: ColorModel, int: int, int2: int) -> None: ...
    @overload
    def newPixels(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @overload
    def newPixels(self, int: int, int2: int, int3: int, int4: int, boolean: bool) -> None: ...
    @overload
    def newPixels(self, intArray: _py_List[int], colorModel: ColorModel, int2: int, int3: int) -> None: ...
    @overload
    def newPixels(self) -> None: ...
    def removeConsumer(self, imageConsumer: ImageConsumer) -> None: ...
    def requestTopDownLeftRightResend(self, imageConsumer: ImageConsumer) -> None: ...
    def setAnimated(self, boolean: bool) -> None: ...
    def setFullBufferUpdates(self, boolean: bool) -> None: ...
    def startProduction(self, imageConsumer: ImageConsumer) -> None: ...

class MultiPixelPackedSampleModel(SampleModel):
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int): ...
    def createCompatibleSampleModel(self, int: int, int2: int) -> SampleModel: ...
    def createDataBuffer(self) -> DataBuffer: ...
    def createSubsetSampleModel(self, intArray: _py_List[int]) -> SampleModel: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getBitOffset(self, int: int) -> int: ...
    def getDataBitOffset(self) -> int: ...
    @overload
    def getDataElements(self, int: int, int2: int, object: _py_Any, dataBuffer: DataBuffer) -> _py_Any: ...
    @overload
    def getDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any, dataBuffer: DataBuffer) -> _py_Any: ...
    def getNumDataElements(self) -> int: ...
    def getOffset(self, int: int, int2: int) -> int: ...
    @overload
    def getPixel(self, int: int, int2: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    def getPixelBitStride(self) -> int: ...
    def getSample(self, int: int, int2: int, int3: int, dataBuffer: DataBuffer) -> int: ...
    @overload
    def getSampleSize(self, int: int) -> int: ...
    @overload
    def getSampleSize(self) -> _py_List[int]: ...
    def getScanlineStride(self) -> int: ...
    def getTransferType(self) -> int: ...
    def hashCode(self) -> int: ...
    @overload
    def setDataElements(self, int: int, int2: int, object: _py_Any, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, int4: int, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, double: float, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, float: float, dataBuffer: DataBuffer) -> None: ...

class PackedColorModel(ColorModel):
    @overload
    def __init__(self, colorSpace: java.awt.color.ColorSpace, int: int, int2: int, int3: int, int4: int, int5: int, boolean: bool, int6: int, int7: int): ...
    @overload
    def __init__(self, colorSpace: java.awt.color.ColorSpace, int: int, intArray: _py_List[int], int3: int, boolean: bool, int4: int, int5: int): ...
    def createCompatibleSampleModel(self, int: int, int2: int) -> SampleModel: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAlphaRaster(self, writableRaster: 'WritableRaster') -> 'WritableRaster': ...
    def getMask(self, int: int) -> int: ...
    def getMasks(self) -> _py_List[int]: ...
    def isCompatibleSampleModel(self, sampleModel: SampleModel) -> bool: ...

class PixelGrabber(ImageConsumer):
    @overload
    def __init__(self, image: java.awt.Image, int: int, int2: int, int3: int, int4: int, boolean: bool): ...
    @overload
    def __init__(self, image: java.awt.Image, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], int6: int, int7: int): ...
    @overload
    def __init__(self, imageProducer: ImageProducer, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], int6: int, int7: int): ...
    def abortGrabbing(self) -> None: ...
    def getColorModel(self) -> ColorModel: ...
    def getHeight(self) -> int: ...
    def getPixels(self) -> _py_Any: ...
    def getStatus(self) -> int: ...
    def getWidth(self) -> int: ...
    @overload
    def grabPixels(self) -> bool: ...
    @overload
    def grabPixels(self, long: int) -> bool: ...
    def imageComplete(self, int: int) -> None: ...
    def setColorModel(self, colorModel: ColorModel) -> None: ...
    def setDimensions(self, int: int, int2: int) -> None: ...
    def setHints(self, int: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, byteArray: _py_List[int], int5: int, int6: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, intArray: _py_List[int], int6: int, int7: int) -> None: ...
    def setProperties(self, hashtable: java.util.Hashtable[_py_Any, _py_Any]) -> None: ...
    def startGrabbing(self) -> None: ...
    def status(self) -> int: ...

class RescaleOp(BufferedImageOp, RasterOp):
    @overload
    def __init__(self, float: float, float2: float, renderingHints: java.awt.RenderingHints): ...
    @overload
    def __init__(self, floatArray: _py_List[float], floatArray2: _py_List[float], renderingHints: java.awt.RenderingHints): ...
    def createCompatibleDestImage(self, bufferedImage: 'BufferedImage', colorModel: ColorModel) -> 'BufferedImage': ...
    def createCompatibleDestRaster(self, raster: Raster) -> 'WritableRaster': ...
    @overload
    def filter(self, bufferedImage: 'BufferedImage', bufferedImage2: 'BufferedImage') -> 'BufferedImage': ...
    @overload
    def filter(self, raster: Raster, writableRaster: 'WritableRaster') -> 'WritableRaster': ...
    @overload
    def getBounds2D(self, bufferedImage: 'BufferedImage') -> java.awt.geom.Rectangle2D: ...
    @overload
    def getBounds2D(self, raster: Raster) -> java.awt.geom.Rectangle2D: ...
    def getNumFactors(self) -> int: ...
    def getOffsets(self, floatArray: _py_List[float]) -> _py_List[float]: ...
    def getPoint2D(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D) -> java.awt.geom.Point2D: ...
    def getRenderingHints(self) -> java.awt.RenderingHints: ...
    def getScaleFactors(self, floatArray: _py_List[float]) -> _py_List[float]: ...

class ShortLookupTable(LookupTable):
    @overload
    def __init__(self, int: int, shortArray: _py_List[int]): ...
    @overload
    def __init__(self, int: int, shortArray: _py_List[_py_List[int]]): ...
    def getTable(self) -> _py_List[_py_List[int]]: ...
    @overload
    def lookupPixel(self, intArray: _py_List[int], intArray2: _py_List[int]) -> _py_List[int]: ...
    @overload
    def lookupPixel(self, shortArray: _py_List[int], shortArray2: _py_List[int]) -> _py_List[int]: ...

class SinglePixelPackedSampleModel(SampleModel):
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int]): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int, intArray: _py_List[int]): ...
    def createCompatibleSampleModel(self, int: int, int2: int) -> SampleModel: ...
    def createDataBuffer(self) -> DataBuffer: ...
    def createSubsetSampleModel(self, intArray: _py_List[int]) -> SampleModel: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getBitMasks(self) -> _py_List[int]: ...
    def getBitOffsets(self) -> _py_List[int]: ...
    @overload
    def getDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any, dataBuffer: DataBuffer) -> _py_Any: ...
    @overload
    def getDataElements(self, int: int, int2: int, object: _py_Any, dataBuffer: DataBuffer) -> _py_Any: ...
    def getNumDataElements(self) -> int: ...
    def getOffset(self, int: int, int2: int) -> int: ...
    @overload
    def getPixel(self, int: int, int2: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    def getSample(self, int: int, int2: int, int3: int, dataBuffer: DataBuffer) -> int: ...
    @overload
    def getSampleSize(self, int: int) -> int: ...
    @overload
    def getSampleSize(self) -> _py_List[int]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    def getScanlineStride(self) -> int: ...
    def hashCode(self) -> int: ...
    @overload
    def setDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setDataElements(self, int: int, int2: int, object: _py_Any, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, double: float, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, float: float, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, int4: int, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...

class WritableRaster(Raster):
    def createWritableChild(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, intArray: _py_List[int]) -> 'WritableRaster': ...
    def createWritableTranslatedChild(self, int: int, int2: int) -> 'WritableRaster': ...
    def getWritableParent(self) -> 'WritableRaster': ...
    @overload
    def setDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any) -> None: ...
    @overload
    def setDataElements(self, int: int, int2: int, raster: Raster) -> None: ...
    @overload
    def setDataElements(self, int: int, int2: int, object: _py_Any) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, doubleArray: _py_List[float]) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, floatArray: _py_List[float]) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, intArray: _py_List[int]) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, doubleArray: _py_List[float]) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, floatArray: _py_List[float]) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int]) -> None: ...
    @overload
    def setRect(self, int: int, int2: int, raster: Raster) -> None: ...
    @overload
    def setRect(self, raster: Raster) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, double: float) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, float: float) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, doubleArray: _py_List[float]) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, floatArray: _py_List[float]) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int]) -> None: ...

class WritableRenderedImage(RenderedImage):
    def addTileObserver(self, tileObserver: TileObserver) -> None: ...
    def getWritableTile(self, int: int, int2: int) -> WritableRaster: ...
    def getWritableTileIndices(self) -> _py_List[java.awt.Point]: ...
    def hasTileWriters(self) -> bool: ...
    def isTileWritable(self, int: int, int2: int) -> bool: ...
    def releaseWritableTile(self, int: int, int2: int) -> None: ...
    def removeTileObserver(self, tileObserver: TileObserver) -> None: ...
    def setData(self, raster: Raster) -> None: ...

class BandedSampleModel(ComponentSampleModel):
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], intArray2: _py_List[int]): ...
    def createCompatibleSampleModel(self, int: int, int2: int) -> SampleModel: ...
    def createDataBuffer(self) -> DataBuffer: ...
    def createSubsetSampleModel(self, intArray: _py_List[int]) -> SampleModel: ...
    @overload
    def getDataElements(self, int: int, int2: int, object: _py_Any, dataBuffer: DataBuffer) -> _py_Any: ...
    @overload
    def getDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any, dataBuffer: DataBuffer) -> _py_Any: ...
    @overload
    def getPixel(self, int: int, int2: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixel(self, int: int, int2: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getPixels(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    def getSample(self, int: int, int2: int, int3: int, dataBuffer: DataBuffer) -> int: ...
    def getSampleDouble(self, int: int, int2: int, int3: int, dataBuffer: DataBuffer) -> float: ...
    def getSampleFloat(self, int: int, int2: int, int3: int, dataBuffer: DataBuffer) -> float: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> _py_List[float]: ...
    @overload
    def getSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> _py_List[int]: ...
    def hashCode(self) -> int: ...
    @overload
    def setDataElements(self, int: int, int2: int, object: _py_Any, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setDataElements(self, int: int, int2: int, int3: int, int4: int, object: _py_Any, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixel(self, int: int, int2: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, double: float, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, float: float, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSample(self, int: int, int2: int, int3: int, int4: int, dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, doubleArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...
    @overload
    def setSamples(self, int: int, int2: int, int3: int, int4: int, int5: int, floatArray: _py_List[float], dataBuffer: DataBuffer) -> None: ...

class BufferedImage(java.awt.Image, WritableRenderedImage, java.awt.Transparency):
    TYPE_CUSTOM: _py_ClassVar[int] = ...
    TYPE_INT_RGB: _py_ClassVar[int] = ...
    TYPE_INT_ARGB: _py_ClassVar[int] = ...
    TYPE_INT_ARGB_PRE: _py_ClassVar[int] = ...
    TYPE_INT_BGR: _py_ClassVar[int] = ...
    TYPE_3BYTE_BGR: _py_ClassVar[int] = ...
    TYPE_4BYTE_ABGR: _py_ClassVar[int] = ...
    TYPE_4BYTE_ABGR_PRE: _py_ClassVar[int] = ...
    TYPE_USHORT_565_RGB: _py_ClassVar[int] = ...
    TYPE_USHORT_555_RGB: _py_ClassVar[int] = ...
    TYPE_BYTE_GRAY: _py_ClassVar[int] = ...
    TYPE_USHORT_GRAY: _py_ClassVar[int] = ...
    TYPE_BYTE_BINARY: _py_ClassVar[int] = ...
    TYPE_BYTE_INDEXED: _py_ClassVar[int] = ...
    @overload
    def __init__(self, int: int, int2: int, int3: int): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int, indexColorModel: IndexColorModel): ...
    @overload
    def __init__(self, colorModel: ColorModel, writableRaster: WritableRaster, boolean: bool, hashtable: java.util.Hashtable[_py_Any, _py_Any]): ...
    def addTileObserver(self, tileObserver: TileObserver) -> None: ...
    def coerceData(self, boolean: bool) -> None: ...
    def copyData(self, writableRaster: WritableRaster) -> WritableRaster: ...
    def createGraphics(self) -> java.awt.Graphics2D: ...
    def getAlphaRaster(self) -> WritableRaster: ...
    def getColorModel(self) -> ColorModel: ...
    @overload
    def getData(self) -> Raster: ...
    @overload
    def getData(self, rectangle: java.awt.Rectangle) -> Raster: ...
    def getGraphics(self) -> java.awt.Graphics: ...
    @overload
    def getHeight(self) -> int: ...
    @overload
    def getHeight(self, imageObserver: ImageObserver) -> int: ...
    def getMinTileX(self) -> int: ...
    def getMinTileY(self) -> int: ...
    def getMinX(self) -> int: ...
    def getMinY(self) -> int: ...
    def getNumXTiles(self) -> int: ...
    def getNumYTiles(self) -> int: ...
    @overload
    def getProperty(self, string: str) -> _py_Any: ...
    @overload
    def getProperty(self, string: str, imageObserver: ImageObserver) -> _py_Any: ...
    def getPropertyNames(self) -> _py_List[str]: ...
    @overload
    def getRGB(self, int: int, int2: int) -> int: ...
    @overload
    def getRGB(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], int6: int, int7: int) -> _py_List[int]: ...
    def getRaster(self) -> WritableRaster: ...
    def getSampleModel(self) -> SampleModel: ...
    def getSource(self) -> ImageProducer: ...
    def getSources(self) -> java.util.Vector[RenderedImage]: ...
    def getSubimage(self, int: int, int2: int, int3: int, int4: int) -> 'BufferedImage': ...
    def getTile(self, int: int, int2: int) -> Raster: ...
    def getTileGridXOffset(self) -> int: ...
    def getTileGridYOffset(self) -> int: ...
    def getTileHeight(self) -> int: ...
    def getTileWidth(self) -> int: ...
    def getTransparency(self) -> int: ...
    def getType(self) -> int: ...
    @overload
    def getWidth(self) -> int: ...
    @overload
    def getWidth(self, imageObserver: ImageObserver) -> int: ...
    def getWritableTile(self, int: int, int2: int) -> WritableRaster: ...
    def getWritableTileIndices(self) -> _py_List[java.awt.Point]: ...
    def hasTileWriters(self) -> bool: ...
    def isAlphaPremultiplied(self) -> bool: ...
    def isTileWritable(self, int: int, int2: int) -> bool: ...
    def releaseWritableTile(self, int: int, int2: int) -> None: ...
    def removeTileObserver(self, tileObserver: TileObserver) -> None: ...
    def setData(self, raster: Raster) -> None: ...
    @overload
    def setRGB(self, int: int, int2: int, int3: int) -> None: ...
    @overload
    def setRGB(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], int6: int, int7: int) -> None: ...
    def toString(self) -> str: ...

class BufferedImageFilter(ImageFilter, java.lang.Cloneable):
    def __init__(self, bufferedImageOp: BufferedImageOp): ...
    def getBufferedImageOp(self) -> BufferedImageOp: ...
    def imageComplete(self, int: int) -> None: ...
    def setColorModel(self, colorModel: ColorModel) -> None: ...
    def setDimensions(self, int: int, int2: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, byteArray: _py_List[int], int5: int, int6: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, intArray: _py_List[int], int6: int, int7: int) -> None: ...

class CropImageFilter(ImageFilter):
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    def setDimensions(self, int: int, int2: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, byteArray: _py_List[int], int5: int, int6: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, intArray: _py_List[int], int6: int, int7: int) -> None: ...
    def setProperties(self, hashtable: java.util.Hashtable[_py_Any, _py_Any]) -> None: ...

class DirectColorModel(PackedColorModel):
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int, int5: int): ...
    @overload
    def __init__(self, colorSpace: java.awt.color.ColorSpace, int: int, int2: int, int3: int, int4: int, int5: int, boolean: bool, int6: int): ...
    def coerceData(self, writableRaster: WritableRaster, boolean: bool) -> ColorModel: ...
    def createCompatibleWritableRaster(self, int: int, int2: int) -> WritableRaster: ...
    @overload
    def getAlpha(self, int: int) -> int: ...
    @overload
    def getAlpha(self, object: _py_Any) -> int: ...
    def getAlphaMask(self) -> int: ...
    @overload
    def getBlue(self, int: int) -> int: ...
    @overload
    def getBlue(self, object: _py_Any) -> int: ...
    def getBlueMask(self) -> int: ...
    @overload
    def getComponents(self, int: int, intArray: _py_List[int], int3: int) -> _py_List[int]: ...
    @overload
    def getComponents(self, object: _py_Any, intArray: _py_List[int], int2: int) -> _py_List[int]: ...
    @overload
    def getDataElement(self, floatArray: _py_List[float], int: int) -> int: ...
    @overload
    def getDataElement(self, intArray: _py_List[int], int2: int) -> int: ...
    @overload
    def getDataElements(self, floatArray: _py_List[float], int: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getDataElements(self, int: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getDataElements(self, intArray: _py_List[int], int2: int, object: _py_Any) -> _py_Any: ...
    @overload
    def getGreen(self, int: int) -> int: ...
    @overload
    def getGreen(self, object: _py_Any) -> int: ...
    def getGreenMask(self) -> int: ...
    @overload
    def getRGB(self, int: int) -> int: ...
    @overload
    def getRGB(self, object: _py_Any) -> int: ...
    @overload
    def getRed(self, int: int) -> int: ...
    @overload
    def getRed(self, object: _py_Any) -> int: ...
    def getRedMask(self) -> int: ...
    def isCompatibleRaster(self, raster: Raster) -> bool: ...
    def toString(self) -> str: ...

class PixelInterleavedSampleModel(ComponentSampleModel):
    def __init__(self, int: int, int2: int, int3: int, int4: int, int5: int, intArray: _py_List[int]): ...
    def createCompatibleSampleModel(self, int: int, int2: int) -> SampleModel: ...
    def createSubsetSampleModel(self, intArray: _py_List[int]) -> SampleModel: ...
    def hashCode(self) -> int: ...

class RGBImageFilter(ImageFilter):
    def __init__(self): ...
    def filterIndexColorModel(self, indexColorModel: IndexColorModel) -> IndexColorModel: ...
    def filterRGB(self, int: int, int2: int, int3: int) -> int: ...
    def filterRGBPixels(self, int: int, int2: int, int3: int, int4: int, intArray: _py_List[int], int6: int, int7: int) -> None: ...
    def setColorModel(self, colorModel: ColorModel) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, byteArray: _py_List[int], int5: int, int6: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, intArray: _py_List[int], int6: int, int7: int) -> None: ...
    def substituteColorModel(self, colorModel: ColorModel, colorModel2: ColorModel) -> None: ...

class ReplicateScaleFilter(ImageFilter):
    def __init__(self, int: int, int2: int): ...
    def setDimensions(self, int: int, int2: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, byteArray: _py_List[int], int5: int, int6: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, intArray: _py_List[int], int6: int, int7: int) -> None: ...
    def setProperties(self, hashtable: java.util.Hashtable[_py_Any, _py_Any]) -> None: ...

class AreaAveragingScaleFilter(ReplicateScaleFilter):
    def __init__(self, int: int, int2: int): ...
    def setHints(self, int: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, byteArray: _py_List[int], int5: int, int6: int) -> None: ...
    @overload
    def setPixels(self, int: int, int2: int, int3: int, int4: int, colorModel: ColorModel, intArray: _py_List[int], int6: int, int7: int) -> None: ...
