from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.awt.color
import java.awt.datatransfer
import java.awt.dnd
import java.awt.dnd.peer
import java.awt.event
import java.awt.font
import java.awt.geom
import java.awt.im
import java.awt.image
import java.awt.image.renderable
import java.awt.peer
import java.beans
import java.io
import java.lang
import java.net
import java.security
import java.text
import java.util
import javax.accessibility
import sun.awt


class AWTError(java.lang.Error):
    def __init__(self, string: str): ...

class AWTEvent(java.util.EventObject):
    COMPONENT_EVENT_MASK: _py_ClassVar[int] = ...
    CONTAINER_EVENT_MASK: _py_ClassVar[int] = ...
    FOCUS_EVENT_MASK: _py_ClassVar[int] = ...
    KEY_EVENT_MASK: _py_ClassVar[int] = ...
    MOUSE_EVENT_MASK: _py_ClassVar[int] = ...
    MOUSE_MOTION_EVENT_MASK: _py_ClassVar[int] = ...
    WINDOW_EVENT_MASK: _py_ClassVar[int] = ...
    ACTION_EVENT_MASK: _py_ClassVar[int] = ...
    ADJUSTMENT_EVENT_MASK: _py_ClassVar[int] = ...
    ITEM_EVENT_MASK: _py_ClassVar[int] = ...
    TEXT_EVENT_MASK: _py_ClassVar[int] = ...
    INPUT_METHOD_EVENT_MASK: _py_ClassVar[int] = ...
    PAINT_EVENT_MASK: _py_ClassVar[int] = ...
    INVOCATION_EVENT_MASK: _py_ClassVar[int] = ...
    HIERARCHY_EVENT_MASK: _py_ClassVar[int] = ...
    HIERARCHY_BOUNDS_EVENT_MASK: _py_ClassVar[int] = ...
    MOUSE_WHEEL_EVENT_MASK: _py_ClassVar[int] = ...
    WINDOW_STATE_EVENT_MASK: _py_ClassVar[int] = ...
    WINDOW_FOCUS_EVENT_MASK: _py_ClassVar[int] = ...
    RESERVED_ID_MAX: _py_ClassVar[int] = ...
    @overload
    def __init__(self, event: 'Event'): ...
    @overload
    def __init__(self, object: _py_Any, int: int): ...
    def getID(self) -> int: ...
    def paramString(self) -> str: ...
    def setSource(self, object: _py_Any) -> None: ...
    def toString(self) -> str: ...

class AWTEventMulticaster(java.awt.event.ComponentListener, java.awt.event.ContainerListener, java.awt.event.FocusListener, java.awt.event.KeyListener, java.awt.event.MouseListener, java.awt.event.MouseMotionListener, java.awt.event.WindowListener, java.awt.event.WindowFocusListener, java.awt.event.WindowStateListener, java.awt.event.ActionListener, java.awt.event.ItemListener, java.awt.event.AdjustmentListener, java.awt.event.TextListener, java.awt.event.InputMethodListener, java.awt.event.HierarchyListener, java.awt.event.HierarchyBoundsListener, java.awt.event.MouseWheelListener):
    def actionPerformed(self, actionEvent: java.awt.event.ActionEvent) -> None: ...
    @classmethod
    @overload
    def add(cls, actionListener: java.awt.event.ActionListener, actionListener2: java.awt.event.ActionListener) -> java.awt.event.ActionListener: ...
    @classmethod
    @overload
    def add(cls, adjustmentListener: java.awt.event.AdjustmentListener, adjustmentListener2: java.awt.event.AdjustmentListener) -> java.awt.event.AdjustmentListener: ...
    @classmethod
    @overload
    def add(cls, componentListener: java.awt.event.ComponentListener, componentListener2: java.awt.event.ComponentListener) -> java.awt.event.ComponentListener: ...
    @classmethod
    @overload
    def add(cls, containerListener: java.awt.event.ContainerListener, containerListener2: java.awt.event.ContainerListener) -> java.awt.event.ContainerListener: ...
    @classmethod
    @overload
    def add(cls, focusListener: java.awt.event.FocusListener, focusListener2: java.awt.event.FocusListener) -> java.awt.event.FocusListener: ...
    @classmethod
    @overload
    def add(cls, hierarchyBoundsListener: java.awt.event.HierarchyBoundsListener, hierarchyBoundsListener2: java.awt.event.HierarchyBoundsListener) -> java.awt.event.HierarchyBoundsListener: ...
    @classmethod
    @overload
    def add(cls, hierarchyListener: java.awt.event.HierarchyListener, hierarchyListener2: java.awt.event.HierarchyListener) -> java.awt.event.HierarchyListener: ...
    @classmethod
    @overload
    def add(cls, inputMethodListener: java.awt.event.InputMethodListener, inputMethodListener2: java.awt.event.InputMethodListener) -> java.awt.event.InputMethodListener: ...
    @classmethod
    @overload
    def add(cls, itemListener: java.awt.event.ItemListener, itemListener2: java.awt.event.ItemListener) -> java.awt.event.ItemListener: ...
    @classmethod
    @overload
    def add(cls, keyListener: java.awt.event.KeyListener, keyListener2: java.awt.event.KeyListener) -> java.awt.event.KeyListener: ...
    @classmethod
    @overload
    def add(cls, mouseListener: java.awt.event.MouseListener, mouseListener2: java.awt.event.MouseListener) -> java.awt.event.MouseListener: ...
    @classmethod
    @overload
    def add(cls, mouseMotionListener: java.awt.event.MouseMotionListener, mouseMotionListener2: java.awt.event.MouseMotionListener) -> java.awt.event.MouseMotionListener: ...
    @classmethod
    @overload
    def add(cls, mouseWheelListener: java.awt.event.MouseWheelListener, mouseWheelListener2: java.awt.event.MouseWheelListener) -> java.awt.event.MouseWheelListener: ...
    @classmethod
    @overload
    def add(cls, textListener: java.awt.event.TextListener, textListener2: java.awt.event.TextListener) -> java.awt.event.TextListener: ...
    @classmethod
    @overload
    def add(cls, windowFocusListener: java.awt.event.WindowFocusListener, windowFocusListener2: java.awt.event.WindowFocusListener) -> java.awt.event.WindowFocusListener: ...
    @classmethod
    @overload
    def add(cls, windowListener: java.awt.event.WindowListener, windowListener2: java.awt.event.WindowListener) -> java.awt.event.WindowListener: ...
    @classmethod
    @overload
    def add(cls, windowStateListener: java.awt.event.WindowStateListener, windowStateListener2: java.awt.event.WindowStateListener) -> java.awt.event.WindowStateListener: ...
    def adjustmentValueChanged(self, adjustmentEvent: java.awt.event.AdjustmentEvent) -> None: ...
    def ancestorMoved(self, hierarchyEvent: java.awt.event.HierarchyEvent) -> None: ...
    def ancestorResized(self, hierarchyEvent: java.awt.event.HierarchyEvent) -> None: ...
    def caretPositionChanged(self, inputMethodEvent: java.awt.event.InputMethodEvent) -> None: ...
    def componentAdded(self, containerEvent: java.awt.event.ContainerEvent) -> None: ...
    def componentHidden(self, componentEvent: java.awt.event.ComponentEvent) -> None: ...
    def componentMoved(self, componentEvent: java.awt.event.ComponentEvent) -> None: ...
    def componentRemoved(self, containerEvent: java.awt.event.ContainerEvent) -> None: ...
    def componentResized(self, componentEvent: java.awt.event.ComponentEvent) -> None: ...
    def componentShown(self, componentEvent: java.awt.event.ComponentEvent) -> None: ...
    def focusGained(self, focusEvent: java.awt.event.FocusEvent) -> None: ...
    def focusLost(self, focusEvent: java.awt.event.FocusEvent) -> None: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    @classmethod
    def getListeners(cls, eventListener: java.util.EventListener, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    def hierarchyChanged(self, hierarchyEvent: java.awt.event.HierarchyEvent) -> None: ...
    def inputMethodTextChanged(self, inputMethodEvent: java.awt.event.InputMethodEvent) -> None: ...
    def itemStateChanged(self, itemEvent: java.awt.event.ItemEvent) -> None: ...
    def keyPressed(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyReleased(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def keyTyped(self, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def mouseClicked(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseDragged(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseEntered(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseExited(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseMoved(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mousePressed(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseReleased(self, mouseEvent: java.awt.event.MouseEvent) -> None: ...
    def mouseWheelMoved(self, mouseWheelEvent: java.awt.event.MouseWheelEvent) -> None: ...
    @classmethod
    @overload
    def remove(cls, actionListener: java.awt.event.ActionListener, actionListener2: java.awt.event.ActionListener) -> java.awt.event.ActionListener: ...
    @classmethod
    @overload
    def remove(cls, adjustmentListener: java.awt.event.AdjustmentListener, adjustmentListener2: java.awt.event.AdjustmentListener) -> java.awt.event.AdjustmentListener: ...
    @classmethod
    @overload
    def remove(cls, componentListener: java.awt.event.ComponentListener, componentListener2: java.awt.event.ComponentListener) -> java.awt.event.ComponentListener: ...
    @classmethod
    @overload
    def remove(cls, containerListener: java.awt.event.ContainerListener, containerListener2: java.awt.event.ContainerListener) -> java.awt.event.ContainerListener: ...
    @classmethod
    @overload
    def remove(cls, focusListener: java.awt.event.FocusListener, focusListener2: java.awt.event.FocusListener) -> java.awt.event.FocusListener: ...
    @classmethod
    @overload
    def remove(cls, hierarchyBoundsListener: java.awt.event.HierarchyBoundsListener, hierarchyBoundsListener2: java.awt.event.HierarchyBoundsListener) -> java.awt.event.HierarchyBoundsListener: ...
    @classmethod
    @overload
    def remove(cls, hierarchyListener: java.awt.event.HierarchyListener, hierarchyListener2: java.awt.event.HierarchyListener) -> java.awt.event.HierarchyListener: ...
    @classmethod
    @overload
    def remove(cls, inputMethodListener: java.awt.event.InputMethodListener, inputMethodListener2: java.awt.event.InputMethodListener) -> java.awt.event.InputMethodListener: ...
    @classmethod
    @overload
    def remove(cls, itemListener: java.awt.event.ItemListener, itemListener2: java.awt.event.ItemListener) -> java.awt.event.ItemListener: ...
    @classmethod
    @overload
    def remove(cls, keyListener: java.awt.event.KeyListener, keyListener2: java.awt.event.KeyListener) -> java.awt.event.KeyListener: ...
    @classmethod
    @overload
    def remove(cls, mouseListener: java.awt.event.MouseListener, mouseListener2: java.awt.event.MouseListener) -> java.awt.event.MouseListener: ...
    @classmethod
    @overload
    def remove(cls, mouseMotionListener: java.awt.event.MouseMotionListener, mouseMotionListener2: java.awt.event.MouseMotionListener) -> java.awt.event.MouseMotionListener: ...
    @classmethod
    @overload
    def remove(cls, mouseWheelListener: java.awt.event.MouseWheelListener, mouseWheelListener2: java.awt.event.MouseWheelListener) -> java.awt.event.MouseWheelListener: ...
    @classmethod
    @overload
    def remove(cls, textListener: java.awt.event.TextListener, textListener2: java.awt.event.TextListener) -> java.awt.event.TextListener: ...
    @classmethod
    @overload
    def remove(cls, windowFocusListener: java.awt.event.WindowFocusListener, windowFocusListener2: java.awt.event.WindowFocusListener) -> java.awt.event.WindowFocusListener: ...
    @classmethod
    @overload
    def remove(cls, windowListener: java.awt.event.WindowListener, windowListener2: java.awt.event.WindowListener) -> java.awt.event.WindowListener: ...
    @classmethod
    @overload
    def remove(cls, windowStateListener: java.awt.event.WindowStateListener, windowStateListener2: java.awt.event.WindowStateListener) -> java.awt.event.WindowStateListener: ...
    def textValueChanged(self, textEvent: java.awt.event.TextEvent) -> None: ...
    def windowActivated(self, windowEvent: java.awt.event.WindowEvent) -> None: ...
    def windowClosed(self, windowEvent: java.awt.event.WindowEvent) -> None: ...
    def windowClosing(self, windowEvent: java.awt.event.WindowEvent) -> None: ...
    def windowDeactivated(self, windowEvent: java.awt.event.WindowEvent) -> None: ...
    def windowDeiconified(self, windowEvent: java.awt.event.WindowEvent) -> None: ...
    def windowGainedFocus(self, windowEvent: java.awt.event.WindowEvent) -> None: ...
    def windowIconified(self, windowEvent: java.awt.event.WindowEvent) -> None: ...
    def windowLostFocus(self, windowEvent: java.awt.event.WindowEvent) -> None: ...
    def windowOpened(self, windowEvent: java.awt.event.WindowEvent) -> None: ...
    def windowStateChanged(self, windowEvent: java.awt.event.WindowEvent) -> None: ...

class AWTException(java.lang.Exception):
    def __init__(self, string: str): ...

class AWTKeyStroke(java.io.Serializable):
    def equals(self, object: _py_Any) -> bool: ...
    @classmethod
    @overload
    def getAWTKeyStroke(cls, char: str) -> 'AWTKeyStroke': ...
    @classmethod
    @overload
    def getAWTKeyStroke(cls, int: int, int2: int) -> 'AWTKeyStroke': ...
    @classmethod
    @overload
    def getAWTKeyStroke(cls, int: int, int2: int, boolean: bool) -> 'AWTKeyStroke': ...
    @classmethod
    @overload
    def getAWTKeyStroke(cls, character: str, int: int) -> 'AWTKeyStroke': ...
    @classmethod
    @overload
    def getAWTKeyStroke(cls, string: str) -> 'AWTKeyStroke': ...
    @classmethod
    def getAWTKeyStrokeForEvent(cls, keyEvent: java.awt.event.KeyEvent) -> 'AWTKeyStroke': ...
    def getKeyChar(self) -> str: ...
    def getKeyCode(self) -> int: ...
    def getKeyEventType(self) -> int: ...
    def getModifiers(self) -> int: ...
    def hashCode(self) -> int: ...
    def isOnKeyRelease(self) -> bool: ...
    def toString(self) -> str: ...

class AWTPermission(java.security.BasicPermission):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...

class ActiveEvent:
    def dispatch(self) -> None: ...

class Adjustable:
    HORIZONTAL: _py_ClassVar[int] = ...
    VERTICAL: _py_ClassVar[int] = ...
    NO_ORIENTATION: _py_ClassVar[int] = ...
    def addAdjustmentListener(self, adjustmentListener: java.awt.event.AdjustmentListener) -> None: ...
    def getBlockIncrement(self) -> int: ...
    def getMaximum(self) -> int: ...
    def getMinimum(self) -> int: ...
    def getOrientation(self) -> int: ...
    def getUnitIncrement(self) -> int: ...
    def getValue(self) -> int: ...
    def getVisibleAmount(self) -> int: ...
    def removeAdjustmentListener(self, adjustmentListener: java.awt.event.AdjustmentListener) -> None: ...
    def setBlockIncrement(self, int: int) -> None: ...
    def setMaximum(self, int: int) -> None: ...
    def setMinimum(self, int: int) -> None: ...
    def setUnitIncrement(self, int: int) -> None: ...
    def setValue(self, int: int) -> None: ...
    def setVisibleAmount(self, int: int) -> None: ...

class AttributeValue:
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class CheckboxGroup(java.io.Serializable):
    def __init__(self): ...
    def getCurrent(self) -> 'Checkbox': ...
    def getSelectedCheckbox(self) -> 'Checkbox': ...
    def setCurrent(self, checkbox: 'Checkbox') -> None: ...
    def setSelectedCheckbox(self, checkbox: 'Checkbox') -> None: ...
    def toString(self) -> str: ...

class ComponentOrientation(java.io.Serializable):
    LEFT_TO_RIGHT: _py_ClassVar['ComponentOrientation'] = ...
    RIGHT_TO_LEFT: _py_ClassVar['ComponentOrientation'] = ...
    UNKNOWN: _py_ClassVar['ComponentOrientation'] = ...
    @classmethod
    @overload
    def getOrientation(cls, locale: java.util.Locale) -> 'ComponentOrientation': ...
    @classmethod
    @overload
    def getOrientation(cls, resourceBundle: java.util.ResourceBundle) -> 'ComponentOrientation': ...
    def isHorizontal(self) -> bool: ...
    def isLeftToRight(self) -> bool: ...

class Composite:
    def createContext(self, colorModel: java.awt.image.ColorModel, colorModel2: java.awt.image.ColorModel, renderingHints: 'RenderingHints') -> 'CompositeContext': ...

class CompositeContext:
    def compose(self, raster: java.awt.image.Raster, raster2: java.awt.image.Raster, writableRaster: java.awt.image.WritableRaster) -> None: ...
    def dispose(self) -> None: ...

class Conditional:
    def evaluate(self) -> bool: ...

class Cursor(java.io.Serializable):
    DEFAULT_CURSOR: _py_ClassVar[int] = ...
    CROSSHAIR_CURSOR: _py_ClassVar[int] = ...
    TEXT_CURSOR: _py_ClassVar[int] = ...
    WAIT_CURSOR: _py_ClassVar[int] = ...
    SW_RESIZE_CURSOR: _py_ClassVar[int] = ...
    SE_RESIZE_CURSOR: _py_ClassVar[int] = ...
    NW_RESIZE_CURSOR: _py_ClassVar[int] = ...
    NE_RESIZE_CURSOR: _py_ClassVar[int] = ...
    N_RESIZE_CURSOR: _py_ClassVar[int] = ...
    S_RESIZE_CURSOR: _py_ClassVar[int] = ...
    W_RESIZE_CURSOR: _py_ClassVar[int] = ...
    E_RESIZE_CURSOR: _py_ClassVar[int] = ...
    HAND_CURSOR: _py_ClassVar[int] = ...
    MOVE_CURSOR: _py_ClassVar[int] = ...
    CUSTOM_CURSOR: _py_ClassVar[int] = ...
    def __init__(self, int: int): ...
    @classmethod
    def getDefaultCursor(cls) -> 'Cursor': ...
    def getName(self) -> str: ...
    @classmethod
    def getPredefinedCursor(cls, int: int) -> 'Cursor': ...
    @classmethod
    def getSystemCustomCursor(cls, string: str) -> 'Cursor': ...
    def getType(self) -> int: ...
    def toString(self) -> str: ...

class Desktop:
    def browse(self, uRI: java.net.URI) -> None: ...
    def edit(self, file: java.io.File) -> None: ...
    @classmethod
    def getDesktop(cls) -> 'Desktop': ...
    @classmethod
    def isDesktopSupported(cls) -> bool: ...
    def isSupported(self, action: 'Desktop.Action') -> bool: ...
    @overload
    def mail(self) -> None: ...
    @overload
    def mail(self, uRI: java.net.URI) -> None: ...
    def open(self, file: java.io.File) -> None: ...
    class Action(java.lang.Enum['Desktop.Action']):
        OPEN: _py_ClassVar['Desktop.Action'] = ...
        EDIT: _py_ClassVar['Desktop.Action'] = ...
        PRINT: _py_ClassVar['Desktop.Action'] = ...
        MAIL: _py_ClassVar['Desktop.Action'] = ...
        BROWSE: _py_ClassVar['Desktop.Action'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'Desktop.Action': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['Desktop.Action']: ...

class Dimension(java.awt.geom.Dimension2D, java.io.Serializable):
    width: int = ...
    height: int = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    @overload
    def __init__(self, dimension: 'Dimension'): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getHeight(self) -> float: ...
    def getSize(self) -> 'Dimension': ...
    def getWidth(self) -> float: ...
    def hashCode(self) -> int: ...
    @overload
    def setSize(self, double: float, double2: float) -> None: ...
    @overload
    def setSize(self, int: int, int2: int) -> None: ...
    @overload
    def setSize(self, dimension: 'Dimension') -> None: ...
    @overload
    def setSize(self, dimension2D: java.awt.geom.Dimension2D) -> None: ...
    def toString(self) -> str: ...

class DisplayMode:
    BIT_DEPTH_MULTI: _py_ClassVar[int] = ...
    REFRESH_RATE_UNKNOWN: _py_ClassVar[int] = ...
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    @overload
    def equals(self, displayMode: 'DisplayMode') -> bool: ...
    @overload
    def equals(self, object: _py_Any) -> bool: ...
    def getBitDepth(self) -> int: ...
    def getHeight(self) -> int: ...
    def getRefreshRate(self) -> int: ...
    def getWidth(self) -> int: ...
    def hashCode(self) -> int: ...

class Event(java.io.Serializable):
    SHIFT_MASK: _py_ClassVar[int] = ...
    CTRL_MASK: _py_ClassVar[int] = ...
    META_MASK: _py_ClassVar[int] = ...
    ALT_MASK: _py_ClassVar[int] = ...
    HOME: _py_ClassVar[int] = ...
    END: _py_ClassVar[int] = ...
    PGUP: _py_ClassVar[int] = ...
    PGDN: _py_ClassVar[int] = ...
    UP: _py_ClassVar[int] = ...
    DOWN: _py_ClassVar[int] = ...
    LEFT: _py_ClassVar[int] = ...
    RIGHT: _py_ClassVar[int] = ...
    F1: _py_ClassVar[int] = ...
    F2: _py_ClassVar[int] = ...
    F3: _py_ClassVar[int] = ...
    F4: _py_ClassVar[int] = ...
    F5: _py_ClassVar[int] = ...
    F6: _py_ClassVar[int] = ...
    F7: _py_ClassVar[int] = ...
    F8: _py_ClassVar[int] = ...
    F9: _py_ClassVar[int] = ...
    F10: _py_ClassVar[int] = ...
    F11: _py_ClassVar[int] = ...
    F12: _py_ClassVar[int] = ...
    PRINT_SCREEN: _py_ClassVar[int] = ...
    SCROLL_LOCK: _py_ClassVar[int] = ...
    CAPS_LOCK: _py_ClassVar[int] = ...
    NUM_LOCK: _py_ClassVar[int] = ...
    PAUSE: _py_ClassVar[int] = ...
    INSERT: _py_ClassVar[int] = ...
    ENTER: _py_ClassVar[int] = ...
    BACK_SPACE: _py_ClassVar[int] = ...
    TAB: _py_ClassVar[int] = ...
    ESCAPE: _py_ClassVar[int] = ...
    DELETE: _py_ClassVar[int] = ...
    WINDOW_DESTROY: _py_ClassVar[int] = ...
    WINDOW_EXPOSE: _py_ClassVar[int] = ...
    WINDOW_ICONIFY: _py_ClassVar[int] = ...
    WINDOW_DEICONIFY: _py_ClassVar[int] = ...
    WINDOW_MOVED: _py_ClassVar[int] = ...
    KEY_PRESS: _py_ClassVar[int] = ...
    KEY_RELEASE: _py_ClassVar[int] = ...
    KEY_ACTION: _py_ClassVar[int] = ...
    KEY_ACTION_RELEASE: _py_ClassVar[int] = ...
    MOUSE_DOWN: _py_ClassVar[int] = ...
    MOUSE_UP: _py_ClassVar[int] = ...
    MOUSE_MOVE: _py_ClassVar[int] = ...
    MOUSE_ENTER: _py_ClassVar[int] = ...
    MOUSE_EXIT: _py_ClassVar[int] = ...
    MOUSE_DRAG: _py_ClassVar[int] = ...
    SCROLL_LINE_UP: _py_ClassVar[int] = ...
    SCROLL_LINE_DOWN: _py_ClassVar[int] = ...
    SCROLL_PAGE_UP: _py_ClassVar[int] = ...
    SCROLL_PAGE_DOWN: _py_ClassVar[int] = ...
    SCROLL_ABSOLUTE: _py_ClassVar[int] = ...
    SCROLL_BEGIN: _py_ClassVar[int] = ...
    SCROLL_END: _py_ClassVar[int] = ...
    LIST_SELECT: _py_ClassVar[int] = ...
    LIST_DESELECT: _py_ClassVar[int] = ...
    ACTION_EVENT: _py_ClassVar[int] = ...
    LOAD_FILE: _py_ClassVar[int] = ...
    SAVE_FILE: _py_ClassVar[int] = ...
    GOT_FOCUS: _py_ClassVar[int] = ...
    LOST_FOCUS: _py_ClassVar[int] = ...
    target: _py_Any = ...
    when: int = ...
    id: int = ...
    x: int = ...
    y: int = ...
    key: int = ...
    modifiers: int = ...
    clickCount: int = ...
    arg: _py_Any = ...
    evt: 'Event' = ...
    @overload
    def __init__(self, object: _py_Any, int: int, object2: _py_Any): ...
    @overload
    def __init__(self, object: _py_Any, long: int, int: int, int2: int, int3: int, int4: int, int5: int): ...
    @overload
    def __init__(self, object: _py_Any, long: int, int: int, int2: int, int3: int, int4: int, int5: int, object2: _py_Any): ...
    def controlDown(self) -> bool: ...
    def metaDown(self) -> bool: ...
    def shiftDown(self) -> bool: ...
    def toString(self) -> str: ...
    def translate(self, int: int, int2: int) -> None: ...

class EventDispatchThread(java.lang.Thread):
    def getEventQueue(self) -> 'EventQueue': ...
    def run(self) -> None: ...
    def setEventQueue(self, eventQueue: 'EventQueue') -> None: ...
    def stopDispatching(self) -> None: ...

class EventFilter:
    def acceptEvent(self, aWTEvent: AWTEvent) -> 'EventFilter.FilterAction': ...
    class FilterAction(java.lang.Enum['EventFilter.FilterAction']):
        ACCEPT: _py_ClassVar['EventFilter.FilterAction'] = ...
        REJECT: _py_ClassVar['EventFilter.FilterAction'] = ...
        ACCEPT_IMMEDIATELY: _py_ClassVar['EventFilter.FilterAction'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'EventFilter.FilterAction': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['EventFilter.FilterAction']: ...

class EventQueue:
    def __init__(self): ...
    def createSecondaryLoop(self) -> 'SecondaryLoop': ...
    @classmethod
    def getCurrentEvent(cls) -> AWTEvent: ...
    @classmethod
    def getMostRecentEventTime(cls) -> int: ...
    def getNextEvent(self) -> AWTEvent: ...
    @classmethod
    def invokeAndWait(cls, runnable: java.lang.Runnable) -> None: ...
    @classmethod
    def invokeLater(cls, runnable: java.lang.Runnable) -> None: ...
    @classmethod
    def isDispatchThread(cls) -> bool: ...
    @overload
    def peekEvent(self) -> AWTEvent: ...
    @overload
    def peekEvent(self, int: int) -> AWTEvent: ...
    def postEvent(self, aWTEvent: AWTEvent) -> None: ...
    def push(self, eventQueue: 'EventQueue') -> None: ...

class FocusManager(java.io.Serializable): ...

class FocusTraversalPolicy:
    def __init__(self): ...
    def getComponentAfter(self, container: 'Container', component: 'Component') -> 'Component': ...
    def getComponentBefore(self, container: 'Container', component: 'Component') -> 'Component': ...
    def getDefaultComponent(self, container: 'Container') -> 'Component': ...
    def getFirstComponent(self, container: 'Container') -> 'Component': ...
    def getInitialComponent(self, window: 'Window') -> 'Component': ...
    def getLastComponent(self, container: 'Container') -> 'Component': ...

class Font(java.io.Serializable):
    DIALOG: _py_ClassVar[str] = ...
    DIALOG_INPUT: _py_ClassVar[str] = ...
    SANS_SERIF: _py_ClassVar[str] = ...
    SERIF: _py_ClassVar[str] = ...
    MONOSPACED: _py_ClassVar[str] = ...
    PLAIN: _py_ClassVar[int] = ...
    BOLD: _py_ClassVar[int] = ...
    ITALIC: _py_ClassVar[int] = ...
    ROMAN_BASELINE: _py_ClassVar[int] = ...
    CENTER_BASELINE: _py_ClassVar[int] = ...
    HANGING_BASELINE: _py_ClassVar[int] = ...
    TRUETYPE_FONT: _py_ClassVar[int] = ...
    TYPE1_FONT: _py_ClassVar[int] = ...
    LAYOUT_LEFT_TO_RIGHT: _py_ClassVar[int] = ...
    LAYOUT_RIGHT_TO_LEFT: _py_ClassVar[int] = ...
    LAYOUT_NO_START_CONTEXT: _py_ClassVar[int] = ...
    LAYOUT_NO_LIMIT_CONTEXT: _py_ClassVar[int] = ...
    @overload
    def __init__(self, string: str, int: int, int2: int): ...
    @overload
    def __init__(self, map: java.util.Map[java.text.AttributedCharacterIterator.Attribute, _py_Any]): ...
    @overload
    def canDisplay(self, char: str) -> bool: ...
    @overload
    def canDisplay(self, int: int) -> bool: ...
    @overload
    def canDisplayUpTo(self, charArray: _py_List[str], int: int, int2: int) -> int: ...
    @overload
    def canDisplayUpTo(self, string: str) -> int: ...
    @overload
    def canDisplayUpTo(self, characterIterator: java.text.CharacterIterator, int: int, int2: int) -> int: ...
    @classmethod
    @overload
    def createFont(cls, int: int, file: java.io.File) -> 'Font': ...
    @classmethod
    @overload
    def createFont(cls, int: int, inputStream: java.io.InputStream) -> 'Font': ...
    @overload
    def createGlyphVector(self, fontRenderContext: java.awt.font.FontRenderContext, charArray: _py_List[str]) -> java.awt.font.GlyphVector: ...
    @overload
    def createGlyphVector(self, fontRenderContext: java.awt.font.FontRenderContext, intArray: _py_List[int]) -> java.awt.font.GlyphVector: ...
    @overload
    def createGlyphVector(self, fontRenderContext: java.awt.font.FontRenderContext, string: str) -> java.awt.font.GlyphVector: ...
    @overload
    def createGlyphVector(self, fontRenderContext: java.awt.font.FontRenderContext, characterIterator: java.text.CharacterIterator) -> java.awt.font.GlyphVector: ...
    @classmethod
    def decode(cls, string: str) -> 'Font': ...
    @overload
    def deriveFont(self, float: float) -> 'Font': ...
    @overload
    def deriveFont(self, int: int) -> 'Font': ...
    @overload
    def deriveFont(self, int: int, float: float) -> 'Font': ...
    @overload
    def deriveFont(self, int: int, affineTransform: java.awt.geom.AffineTransform) -> 'Font': ...
    @overload
    def deriveFont(self, affineTransform: java.awt.geom.AffineTransform) -> 'Font': ...
    @overload
    def deriveFont(self, map: java.util.Map[java.text.AttributedCharacterIterator.Attribute, _py_Any]) -> 'Font': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAttributes(self) -> java.util.Map[java.awt.font.TextAttribute, _py_Any]: ...
    def getAvailableAttributes(self) -> _py_List[java.text.AttributedCharacterIterator.Attribute]: ...
    def getBaselineFor(self, char: str) -> int: ...
    @overload
    def getFamily(self) -> str: ...
    @overload
    def getFamily(self, locale: java.util.Locale) -> str: ...
    @classmethod
    @overload
    def getFont(cls, string: str) -> 'Font': ...
    @classmethod
    @overload
    def getFont(cls, string: str, font: 'Font') -> 'Font': ...
    @classmethod
    @overload
    def getFont(cls, map: java.util.Map[java.text.AttributedCharacterIterator.Attribute, _py_Any]) -> 'Font': ...
    @overload
    def getFontName(self) -> str: ...
    @overload
    def getFontName(self, locale: java.util.Locale) -> str: ...
    def getItalicAngle(self) -> float: ...
    @overload
    def getLineMetrics(self, charArray: _py_List[str], int: int, int2: int, fontRenderContext: java.awt.font.FontRenderContext) -> java.awt.font.LineMetrics: ...
    @overload
    def getLineMetrics(self, string: str, int: int, int2: int, fontRenderContext: java.awt.font.FontRenderContext) -> java.awt.font.LineMetrics: ...
    @overload
    def getLineMetrics(self, string: str, fontRenderContext: java.awt.font.FontRenderContext) -> java.awt.font.LineMetrics: ...
    @overload
    def getLineMetrics(self, characterIterator: java.text.CharacterIterator, int: int, int2: int, fontRenderContext: java.awt.font.FontRenderContext) -> java.awt.font.LineMetrics: ...
    def getMaxCharBounds(self, fontRenderContext: java.awt.font.FontRenderContext) -> java.awt.geom.Rectangle2D: ...
    def getMissingGlyphCode(self) -> int: ...
    def getName(self) -> str: ...
    def getNumGlyphs(self) -> int: ...
    def getPSName(self) -> str: ...
    def getPeer(self) -> java.awt.peer.FontPeer: ...
    def getSize(self) -> int: ...
    def getSize2D(self) -> float: ...
    @overload
    def getStringBounds(self, charArray: _py_List[str], int: int, int2: int, fontRenderContext: java.awt.font.FontRenderContext) -> java.awt.geom.Rectangle2D: ...
    @overload
    def getStringBounds(self, string: str, int: int, int2: int, fontRenderContext: java.awt.font.FontRenderContext) -> java.awt.geom.Rectangle2D: ...
    @overload
    def getStringBounds(self, string: str, fontRenderContext: java.awt.font.FontRenderContext) -> java.awt.geom.Rectangle2D: ...
    @overload
    def getStringBounds(self, characterIterator: java.text.CharacterIterator, int: int, int2: int, fontRenderContext: java.awt.font.FontRenderContext) -> java.awt.geom.Rectangle2D: ...
    def getStyle(self) -> int: ...
    def getTransform(self) -> java.awt.geom.AffineTransform: ...
    def hasLayoutAttributes(self) -> bool: ...
    def hasUniformLineMetrics(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isBold(self) -> bool: ...
    def isItalic(self) -> bool: ...
    def isPlain(self) -> bool: ...
    def isTransformed(self) -> bool: ...
    def layoutGlyphVector(self, fontRenderContext: java.awt.font.FontRenderContext, charArray: _py_List[str], int: int, int2: int, int3: int) -> java.awt.font.GlyphVector: ...
    def toString(self) -> str: ...

class FontFormatException(java.lang.Exception):
    def __init__(self, string: str): ...

class FontMetrics(java.io.Serializable):
    def bytesWidth(self, byteArray: _py_List[int], int: int, int2: int) -> int: ...
    @overload
    def charWidth(self, char: str) -> int: ...
    @overload
    def charWidth(self, int: int) -> int: ...
    def charsWidth(self, charArray: _py_List[str], int: int, int2: int) -> int: ...
    def getAscent(self) -> int: ...
    def getDescent(self) -> int: ...
    def getFont(self) -> Font: ...
    def getFontRenderContext(self) -> java.awt.font.FontRenderContext: ...
    def getHeight(self) -> int: ...
    def getLeading(self) -> int: ...
    @overload
    def getLineMetrics(self, charArray: _py_List[str], int: int, int2: int, graphics: 'Graphics') -> java.awt.font.LineMetrics: ...
    @overload
    def getLineMetrics(self, string: str, int: int, int2: int, graphics: 'Graphics') -> java.awt.font.LineMetrics: ...
    @overload
    def getLineMetrics(self, string: str, graphics: 'Graphics') -> java.awt.font.LineMetrics: ...
    @overload
    def getLineMetrics(self, characterIterator: java.text.CharacterIterator, int: int, int2: int, graphics: 'Graphics') -> java.awt.font.LineMetrics: ...
    def getMaxAdvance(self) -> int: ...
    def getMaxAscent(self) -> int: ...
    def getMaxCharBounds(self, graphics: 'Graphics') -> java.awt.geom.Rectangle2D: ...
    def getMaxDecent(self) -> int: ...
    def getMaxDescent(self) -> int: ...
    @overload
    def getStringBounds(self, charArray: _py_List[str], int: int, int2: int, graphics: 'Graphics') -> java.awt.geom.Rectangle2D: ...
    @overload
    def getStringBounds(self, string: str, int: int, int2: int, graphics: 'Graphics') -> java.awt.geom.Rectangle2D: ...
    @overload
    def getStringBounds(self, string: str, graphics: 'Graphics') -> java.awt.geom.Rectangle2D: ...
    @overload
    def getStringBounds(self, characterIterator: java.text.CharacterIterator, int: int, int2: int, graphics: 'Graphics') -> java.awt.geom.Rectangle2D: ...
    def getWidths(self) -> _py_List[int]: ...
    def hasUniformLineMetrics(self) -> bool: ...
    def stringWidth(self, string: str) -> int: ...
    def toString(self) -> str: ...

class Graphics:
    def clearRect(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def clipRect(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def copyArea(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> None: ...
    @overload
    def create(self) -> 'Graphics': ...
    @overload
    def create(self, int: int, int2: int, int3: int, int4: int) -> 'Graphics': ...
    def dispose(self) -> None: ...
    def draw3DRect(self, int: int, int2: int, int3: int, int4: int, boolean: bool) -> None: ...
    def drawArc(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> None: ...
    def drawBytes(self, byteArray: _py_List[int], int: int, int2: int, int3: int, int4: int) -> None: ...
    def drawChars(self, charArray: _py_List[str], int: int, int2: int, int3: int, int4: int) -> None: ...
    @overload
    def drawImage(self, image: 'Image', int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, color: 'Color', imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, image: 'Image', int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, image: 'Image', int: int, int2: int, int3: int, int4: int, color: 'Color', imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, image: 'Image', int: int, int2: int, int3: int, int4: int, imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, image: 'Image', int: int, int2: int, color: 'Color', imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, image: 'Image', int: int, int2: int, imageObserver: java.awt.image.ImageObserver) -> bool: ...
    def drawLine(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def drawOval(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @overload
    def drawPolygon(self, intArray: _py_List[int], intArray2: _py_List[int], int3: int) -> None: ...
    @overload
    def drawPolygon(self, polygon: 'Polygon') -> None: ...
    def drawPolyline(self, intArray: _py_List[int], intArray2: _py_List[int], int3: int) -> None: ...
    def drawRect(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def drawRoundRect(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> None: ...
    @overload
    def drawString(self, string: str, int: int, int2: int) -> None: ...
    @overload
    def drawString(self, attributedCharacterIterator: java.text.AttributedCharacterIterator, int: int, int2: int) -> None: ...
    def fill3DRect(self, int: int, int2: int, int3: int, int4: int, boolean: bool) -> None: ...
    def fillArc(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> None: ...
    def fillOval(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @overload
    def fillPolygon(self, intArray: _py_List[int], intArray2: _py_List[int], int3: int) -> None: ...
    @overload
    def fillPolygon(self, polygon: 'Polygon') -> None: ...
    def fillRect(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def fillRoundRect(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> None: ...
    def finalize(self) -> None: ...
    def getClip(self) -> 'Shape': ...
    @overload
    def getClipBounds(self) -> 'Rectangle': ...
    @overload
    def getClipBounds(self, rectangle: 'Rectangle') -> 'Rectangle': ...
    def getClipRect(self) -> 'Rectangle': ...
    def getColor(self) -> 'Color': ...
    def getFont(self) -> Font: ...
    @overload
    def getFontMetrics(self, font: Font) -> FontMetrics: ...
    @overload
    def getFontMetrics(self) -> FontMetrics: ...
    def hitClip(self, int: int, int2: int, int3: int, int4: int) -> bool: ...
    @overload
    def setClip(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @overload
    def setClip(self, shape: 'Shape') -> None: ...
    def setColor(self, color: 'Color') -> None: ...
    def setFont(self, font: Font) -> None: ...
    def setPaintMode(self) -> None: ...
    def setXORMode(self, color: 'Color') -> None: ...
    def toString(self) -> str: ...
    def translate(self, int: int, int2: int) -> None: ...

class GraphicsCallback(sun.awt.SunGraphicsCallback): ...

class GraphicsConfigTemplate(java.io.Serializable):
    REQUIRED: _py_ClassVar[int] = ...
    PREFERRED: _py_ClassVar[int] = ...
    UNNECESSARY: _py_ClassVar[int] = ...
    def __init__(self): ...
    def getBestConfiguration(self, graphicsConfigurationArray: _py_List['GraphicsConfiguration']) -> 'GraphicsConfiguration': ...
    def isGraphicsConfigSupported(self, graphicsConfiguration: 'GraphicsConfiguration') -> bool: ...

class GraphicsConfiguration:
    @overload
    def createCompatibleImage(self, int: int, int2: int) -> java.awt.image.BufferedImage: ...
    @overload
    def createCompatibleImage(self, int: int, int2: int, int3: int) -> java.awt.image.BufferedImage: ...
    @overload
    def createCompatibleVolatileImage(self, int: int, int2: int) -> java.awt.image.VolatileImage: ...
    @overload
    def createCompatibleVolatileImage(self, int: int, int2: int, int3: int) -> java.awt.image.VolatileImage: ...
    @overload
    def createCompatibleVolatileImage(self, int: int, int2: int, imageCapabilities: 'ImageCapabilities') -> java.awt.image.VolatileImage: ...
    @overload
    def createCompatibleVolatileImage(self, int: int, int2: int, imageCapabilities: 'ImageCapabilities', int3: int) -> java.awt.image.VolatileImage: ...
    def getBounds(self) -> 'Rectangle': ...
    def getBufferCapabilities(self) -> 'BufferCapabilities': ...
    @overload
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    @overload
    def getColorModel(self, int: int) -> java.awt.image.ColorModel: ...
    def getDefaultTransform(self) -> java.awt.geom.AffineTransform: ...
    def getDevice(self) -> 'GraphicsDevice': ...
    def getImageCapabilities(self) -> 'ImageCapabilities': ...
    def getNormalizingTransform(self) -> java.awt.geom.AffineTransform: ...
    def isTranslucencyCapable(self) -> bool: ...

class GraphicsDevice:
    TYPE_RASTER_SCREEN: _py_ClassVar[int] = ...
    TYPE_PRINTER: _py_ClassVar[int] = ...
    TYPE_IMAGE_BUFFER: _py_ClassVar[int] = ...
    def getAvailableAcceleratedMemory(self) -> int: ...
    def getBestConfiguration(self, graphicsConfigTemplate: GraphicsConfigTemplate) -> GraphicsConfiguration: ...
    def getConfigurations(self) -> _py_List[GraphicsConfiguration]: ...
    def getDefaultConfiguration(self) -> GraphicsConfiguration: ...
    def getDisplayMode(self) -> DisplayMode: ...
    def getDisplayModes(self) -> _py_List[DisplayMode]: ...
    def getFullScreenWindow(self) -> 'Window': ...
    def getIDstring(self) -> str: ...
    def getType(self) -> int: ...
    def isDisplayChangeSupported(self) -> bool: ...
    def isFullScreenSupported(self) -> bool: ...
    def isWindowTranslucencySupported(self, windowTranslucency: 'GraphicsDevice.WindowTranslucency') -> bool: ...
    def setDisplayMode(self, displayMode: DisplayMode) -> None: ...
    def setFullScreenWindow(self, window: 'Window') -> None: ...
    class WindowTranslucency(java.lang.Enum['GraphicsDevice.WindowTranslucency']):
        PERPIXEL_TRANSPARENT: _py_ClassVar['GraphicsDevice.WindowTranslucency'] = ...
        TRANSLUCENT: _py_ClassVar['GraphicsDevice.WindowTranslucency'] = ...
        PERPIXEL_TRANSLUCENT: _py_ClassVar['GraphicsDevice.WindowTranslucency'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'GraphicsDevice.WindowTranslucency': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['GraphicsDevice.WindowTranslucency']: ...

class GraphicsEnvironment:
    def createGraphics(self, bufferedImage: java.awt.image.BufferedImage) -> 'Graphics2D': ...
    def getAllFonts(self) -> _py_List[Font]: ...
    @overload
    def getAvailableFontFamilyNames(self) -> _py_List[str]: ...
    @overload
    def getAvailableFontFamilyNames(self, locale: java.util.Locale) -> _py_List[str]: ...
    def getCenterPoint(self) -> 'Point': ...
    def getDefaultScreenDevice(self) -> GraphicsDevice: ...
    @classmethod
    def getLocalGraphicsEnvironment(cls) -> 'GraphicsEnvironment': ...
    def getMaximumWindowBounds(self) -> 'Rectangle': ...
    def getScreenDevices(self) -> _py_List[GraphicsDevice]: ...
    @classmethod
    def isHeadless(cls) -> bool: ...
    def isHeadlessInstance(self) -> bool: ...
    def preferLocaleFonts(self) -> None: ...
    def preferProportionalFonts(self) -> None: ...
    def registerFont(self, font: Font) -> bool: ...

class GridBagConstraints(java.lang.Cloneable, java.io.Serializable):
    RELATIVE: _py_ClassVar[int] = ...
    REMAINDER: _py_ClassVar[int] = ...
    NONE: _py_ClassVar[int] = ...
    BOTH: _py_ClassVar[int] = ...
    HORIZONTAL: _py_ClassVar[int] = ...
    VERTICAL: _py_ClassVar[int] = ...
    CENTER: _py_ClassVar[int] = ...
    NORTH: _py_ClassVar[int] = ...
    NORTHEAST: _py_ClassVar[int] = ...
    EAST: _py_ClassVar[int] = ...
    SOUTHEAST: _py_ClassVar[int] = ...
    SOUTH: _py_ClassVar[int] = ...
    SOUTHWEST: _py_ClassVar[int] = ...
    WEST: _py_ClassVar[int] = ...
    NORTHWEST: _py_ClassVar[int] = ...
    PAGE_START: _py_ClassVar[int] = ...
    PAGE_END: _py_ClassVar[int] = ...
    LINE_START: _py_ClassVar[int] = ...
    LINE_END: _py_ClassVar[int] = ...
    FIRST_LINE_START: _py_ClassVar[int] = ...
    FIRST_LINE_END: _py_ClassVar[int] = ...
    LAST_LINE_START: _py_ClassVar[int] = ...
    LAST_LINE_END: _py_ClassVar[int] = ...
    BASELINE: _py_ClassVar[int] = ...
    BASELINE_LEADING: _py_ClassVar[int] = ...
    BASELINE_TRAILING: _py_ClassVar[int] = ...
    ABOVE_BASELINE: _py_ClassVar[int] = ...
    ABOVE_BASELINE_LEADING: _py_ClassVar[int] = ...
    ABOVE_BASELINE_TRAILING: _py_ClassVar[int] = ...
    BELOW_BASELINE: _py_ClassVar[int] = ...
    BELOW_BASELINE_LEADING: _py_ClassVar[int] = ...
    BELOW_BASELINE_TRAILING: _py_ClassVar[int] = ...
    gridx: int = ...
    gridy: int = ...
    gridwidth: int = ...
    gridheight: int = ...
    weightx: float = ...
    weighty: float = ...
    anchor: int = ...
    fill: int = ...
    insets: 'Insets' = ...
    ipadx: int = ...
    ipady: int = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int, double: float, double2: float, int5: int, int6: int, insets: 'Insets', int7: int, int8: int): ...
    def clone(self) -> _py_Any: ...

class GridBagLayoutInfo(java.io.Serializable): ...

class HeadlessException(java.lang.UnsupportedOperationException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    def getMessage(self) -> str: ...

class IllegalComponentStateException(java.lang.IllegalStateException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class Image:
    UndefinedProperty: _py_ClassVar[_py_Any] = ...
    SCALE_DEFAULT: _py_ClassVar[int] = ...
    SCALE_FAST: _py_ClassVar[int] = ...
    SCALE_SMOOTH: _py_ClassVar[int] = ...
    SCALE_REPLICATE: _py_ClassVar[int] = ...
    SCALE_AREA_AVERAGING: _py_ClassVar[int] = ...
    def __init__(self): ...
    def flush(self) -> None: ...
    def getAccelerationPriority(self) -> float: ...
    def getCapabilities(self, graphicsConfiguration: GraphicsConfiguration) -> 'ImageCapabilities': ...
    def getGraphics(self) -> Graphics: ...
    def getHeight(self, imageObserver: java.awt.image.ImageObserver) -> int: ...
    def getProperty(self, string: str, imageObserver: java.awt.image.ImageObserver) -> _py_Any: ...
    def getScaledInstance(self, int: int, int2: int, int3: int) -> 'Image': ...
    def getSource(self) -> java.awt.image.ImageProducer: ...
    def getWidth(self, imageObserver: java.awt.image.ImageObserver) -> int: ...
    def setAccelerationPriority(self, float: float) -> None: ...

class ImageCapabilities(java.lang.Cloneable):
    def __init__(self, boolean: bool): ...
    def clone(self) -> _py_Any: ...
    def isAccelerated(self) -> bool: ...
    def isTrueVolatile(self) -> bool: ...

class Insets(java.lang.Cloneable, java.io.Serializable):
    top: int = ...
    left: int = ...
    bottom: int = ...
    right: int = ...
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def set(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def toString(self) -> str: ...

class ItemSelectable:
    def addItemListener(self, itemListener: java.awt.event.ItemListener) -> None: ...
    def getSelectedObjects(self) -> _py_List[_py_Any]: ...
    def removeItemListener(self, itemListener: java.awt.event.ItemListener) -> None: ...

class KeyEventDispatcher:
    def dispatchKeyEvent(self, keyEvent: java.awt.event.KeyEvent) -> bool: ...

class KeyEventPostProcessor:
    def postProcessKeyEvent(self, keyEvent: java.awt.event.KeyEvent) -> bool: ...

class LayoutManager:
    def addLayoutComponent(self, string: str, component: 'Component') -> None: ...
    def layoutContainer(self, container: 'Container') -> None: ...
    def minimumLayoutSize(self, container: 'Container') -> Dimension: ...
    def preferredLayoutSize(self, container: 'Container') -> Dimension: ...
    def removeLayoutComponent(self, component: 'Component') -> None: ...

class LightweightDispatcher(java.io.Serializable, java.awt.event.AWTEventListener):
    def eventDispatched(self, aWTEvent: AWTEvent) -> None: ...

class MediaEntry: ...

class MediaTracker(java.io.Serializable):
    LOADING: _py_ClassVar[int] = ...
    ABORTED: _py_ClassVar[int] = ...
    ERRORED: _py_ClassVar[int] = ...
    COMPLETE: _py_ClassVar[int] = ...
    def __init__(self, component: 'Component'): ...
    @overload
    def addImage(self, image: Image, int: int, int2: int, int3: int) -> None: ...
    @overload
    def addImage(self, image: Image, int: int) -> None: ...
    @overload
    def checkAll(self) -> bool: ...
    @overload
    def checkAll(self, boolean: bool) -> bool: ...
    @overload
    def checkID(self, int: int) -> bool: ...
    @overload
    def checkID(self, int: int, boolean: bool) -> bool: ...
    def getErrorsAny(self) -> _py_List[_py_Any]: ...
    def getErrorsID(self, int: int) -> _py_List[_py_Any]: ...
    def isErrorAny(self) -> bool: ...
    def isErrorID(self, int: int) -> bool: ...
    @overload
    def removeImage(self, image: Image) -> None: ...
    @overload
    def removeImage(self, image: Image, int: int) -> None: ...
    @overload
    def removeImage(self, image: Image, int: int, int2: int, int3: int) -> None: ...
    def statusAll(self, boolean: bool) -> int: ...
    def statusID(self, int: int, boolean: bool) -> int: ...
    @overload
    def waitForAll(self, long: int) -> bool: ...
    @overload
    def waitForAll(self) -> None: ...
    @overload
    def waitForID(self, int: int, long: int) -> bool: ...
    @overload
    def waitForID(self, int: int) -> None: ...

class MenuComponent(java.io.Serializable):
    def __init__(self): ...
    def dispatchEvent(self, aWTEvent: AWTEvent) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getFont(self) -> Font: ...
    def getName(self) -> str: ...
    def getParent(self) -> 'MenuContainer': ...
    def getPeer(self) -> java.awt.peer.MenuComponentPeer: ...
    def postEvent(self, event: Event) -> bool: ...
    def removeNotify(self) -> None: ...
    def setFont(self, font: Font) -> None: ...
    def setName(self, string: str) -> None: ...
    def toString(self) -> str: ...

class MenuContainer:
    def getFont(self) -> Font: ...
    def postEvent(self, event: Event) -> bool: ...
    def remove(self, menuComponent: MenuComponent) -> None: ...

class MenuShortcut(java.io.Serializable):
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, boolean: bool): ...
    @overload
    def equals(self, menuShortcut: 'MenuShortcut') -> bool: ...
    @overload
    def equals(self, object: _py_Any) -> bool: ...
    def getKey(self) -> int: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def usesShiftModifier(self) -> bool: ...

class MouseInfo:
    @classmethod
    def getNumberOfButtons(cls) -> int: ...
    @classmethod
    def getPointerInfo(cls) -> 'PointerInfo': ...

class PaintContext:
    def dispose(self) -> None: ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    def getRaster(self, int: int, int2: int, int3: int, int4: int) -> java.awt.image.Raster: ...

class PeerFixer(java.awt.event.AdjustmentListener, java.io.Serializable):
    def adjustmentValueChanged(self, adjustmentEvent: java.awt.event.AdjustmentEvent) -> None: ...

class Point(java.awt.geom.Point2D, java.io.Serializable):
    x: int = ...
    y: int = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    @overload
    def __init__(self, point: 'Point'): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getLocation(self) -> 'Point': ...
    def getX(self) -> float: ...
    def getY(self) -> float: ...
    def move(self, int: int, int2: int) -> None: ...
    @overload
    def setLocation(self, double: float, double2: float) -> None: ...
    @overload
    def setLocation(self, int: int, int2: int) -> None: ...
    @overload
    def setLocation(self, point: 'Point') -> None: ...
    @overload
    def setLocation(self, point2D: java.awt.geom.Point2D) -> None: ...
    def toString(self) -> str: ...
    def translate(self, int: int, int2: int) -> None: ...

class PointerInfo:
    def getDevice(self) -> GraphicsDevice: ...
    def getLocation(self) -> Point: ...

class PrintGraphics:
    def getPrintJob(self) -> 'PrintJob': ...

class PrintJob:
    def __init__(self): ...
    def end(self) -> None: ...
    def finalize(self) -> None: ...
    def getGraphics(self) -> Graphics: ...
    def getPageDimension(self) -> Dimension: ...
    def getPageResolution(self) -> int: ...
    def lastPageFirst(self) -> bool: ...

class Queue: ...

class RenderingHints(java.util.Map[_py_Any, _py_Any], java.lang.Cloneable):
    KEY_ANTIALIASING: _py_ClassVar['RenderingHints.Key'] = ...
    VALUE_ANTIALIAS_ON: _py_ClassVar[_py_Any] = ...
    VALUE_ANTIALIAS_OFF: _py_ClassVar[_py_Any] = ...
    VALUE_ANTIALIAS_DEFAULT: _py_ClassVar[_py_Any] = ...
    KEY_RENDERING: _py_ClassVar['RenderingHints.Key'] = ...
    VALUE_RENDER_SPEED: _py_ClassVar[_py_Any] = ...
    VALUE_RENDER_QUALITY: _py_ClassVar[_py_Any] = ...
    VALUE_RENDER_DEFAULT: _py_ClassVar[_py_Any] = ...
    KEY_DITHERING: _py_ClassVar['RenderingHints.Key'] = ...
    VALUE_DITHER_DISABLE: _py_ClassVar[_py_Any] = ...
    VALUE_DITHER_ENABLE: _py_ClassVar[_py_Any] = ...
    VALUE_DITHER_DEFAULT: _py_ClassVar[_py_Any] = ...
    KEY_TEXT_ANTIALIASING: _py_ClassVar['RenderingHints.Key'] = ...
    VALUE_TEXT_ANTIALIAS_ON: _py_ClassVar[_py_Any] = ...
    VALUE_TEXT_ANTIALIAS_OFF: _py_ClassVar[_py_Any] = ...
    VALUE_TEXT_ANTIALIAS_DEFAULT: _py_ClassVar[_py_Any] = ...
    VALUE_TEXT_ANTIALIAS_GASP: _py_ClassVar[_py_Any] = ...
    VALUE_TEXT_ANTIALIAS_LCD_HRGB: _py_ClassVar[_py_Any] = ...
    VALUE_TEXT_ANTIALIAS_LCD_HBGR: _py_ClassVar[_py_Any] = ...
    VALUE_TEXT_ANTIALIAS_LCD_VRGB: _py_ClassVar[_py_Any] = ...
    VALUE_TEXT_ANTIALIAS_LCD_VBGR: _py_ClassVar[_py_Any] = ...
    KEY_TEXT_LCD_CONTRAST: _py_ClassVar['RenderingHints.Key'] = ...
    KEY_FRACTIONALMETRICS: _py_ClassVar['RenderingHints.Key'] = ...
    VALUE_FRACTIONALMETRICS_OFF: _py_ClassVar[_py_Any] = ...
    VALUE_FRACTIONALMETRICS_ON: _py_ClassVar[_py_Any] = ...
    VALUE_FRACTIONALMETRICS_DEFAULT: _py_ClassVar[_py_Any] = ...
    KEY_INTERPOLATION: _py_ClassVar['RenderingHints.Key'] = ...
    VALUE_INTERPOLATION_NEAREST_NEIGHBOR: _py_ClassVar[_py_Any] = ...
    VALUE_INTERPOLATION_BILINEAR: _py_ClassVar[_py_Any] = ...
    VALUE_INTERPOLATION_BICUBIC: _py_ClassVar[_py_Any] = ...
    KEY_ALPHA_INTERPOLATION: _py_ClassVar['RenderingHints.Key'] = ...
    VALUE_ALPHA_INTERPOLATION_SPEED: _py_ClassVar[_py_Any] = ...
    VALUE_ALPHA_INTERPOLATION_QUALITY: _py_ClassVar[_py_Any] = ...
    VALUE_ALPHA_INTERPOLATION_DEFAULT: _py_ClassVar[_py_Any] = ...
    KEY_COLOR_RENDERING: _py_ClassVar['RenderingHints.Key'] = ...
    VALUE_COLOR_RENDER_SPEED: _py_ClassVar[_py_Any] = ...
    VALUE_COLOR_RENDER_QUALITY: _py_ClassVar[_py_Any] = ...
    VALUE_COLOR_RENDER_DEFAULT: _py_ClassVar[_py_Any] = ...
    KEY_STROKE_CONTROL: _py_ClassVar['RenderingHints.Key'] = ...
    VALUE_STROKE_DEFAULT: _py_ClassVar[_py_Any] = ...
    VALUE_STROKE_NORMALIZE: _py_ClassVar[_py_Any] = ...
    VALUE_STROKE_PURE: _py_ClassVar[_py_Any] = ...
    @overload
    def __init__(self, key: 'RenderingHints.Key', object: _py_Any): ...
    @overload
    def __init__(self, map: java.util.Map['RenderingHints.Key', _py_Any]): ...
    def add(self, renderingHints: 'RenderingHints') -> None: ...
    def clear(self) -> None: ...
    def clone(self) -> _py_Any: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def entrySet(self) -> java.util.Set[java.util.Map.Entry[_py_Any, _py_Any]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, object: _py_Any) -> _py_Any: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def keySet(self) -> java.util.Set[_py_Any]: ...
    def put(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    def putAll(self, map: java.util.Map[_py_Any, _py_Any]) -> None: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _py_Any: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    def values(self) -> java.util.Collection[_py_Any]: ...
    class Key:
        def equals(self, object: _py_Any) -> bool: ...
        def hashCode(self) -> int: ...
        def isCompatibleValue(self, object: _py_Any) -> bool: ...

class Robot:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, graphicsDevice: GraphicsDevice): ...
    def createScreenCapture(self, rectangle: 'Rectangle') -> java.awt.image.BufferedImage: ...
    def delay(self, int: int) -> None: ...
    def getAutoDelay(self) -> int: ...
    def getPixelColor(self, int: int, int2: int) -> 'Color': ...
    def isAutoWaitForIdle(self) -> bool: ...
    def keyPress(self, int: int) -> None: ...
    def keyRelease(self, int: int) -> None: ...
    def mouseMove(self, int: int, int2: int) -> None: ...
    def mousePress(self, int: int) -> None: ...
    def mouseRelease(self, int: int) -> None: ...
    def mouseWheel(self, int: int) -> None: ...
    def setAutoDelay(self, int: int) -> None: ...
    def setAutoWaitForIdle(self, boolean: bool) -> None: ...
    def toString(self) -> str: ...
    def waitForIdle(self) -> None: ...

class SecondaryLoop:
    def enter(self) -> bool: ...
    def exit(self) -> bool: ...

class Shape:
    @overload
    def contains(self, double: float, double2: float) -> bool: ...
    @overload
    def contains(self, double: float, double2: float, double3: float, double4: float) -> bool: ...
    @overload
    def contains(self, point2D: java.awt.geom.Point2D) -> bool: ...
    @overload
    def contains(self, rectangle2D: java.awt.geom.Rectangle2D) -> bool: ...
    def getBounds(self) -> 'Rectangle': ...
    def getBounds2D(self) -> java.awt.geom.Rectangle2D: ...
    @overload
    def getPathIterator(self, affineTransform: java.awt.geom.AffineTransform) -> java.awt.geom.PathIterator: ...
    @overload
    def getPathIterator(self, affineTransform: java.awt.geom.AffineTransform, double: float) -> java.awt.geom.PathIterator: ...
    @overload
    def intersects(self, double: float, double2: float, double3: float, double4: float) -> bool: ...
    @overload
    def intersects(self, rectangle2D: java.awt.geom.Rectangle2D) -> bool: ...

class SplashScreen:
    def close(self) -> None: ...
    def createGraphics(self) -> 'Graphics2D': ...
    def getBounds(self) -> 'Rectangle': ...
    def getImageURL(self) -> java.net.URL: ...
    def getSize(self) -> Dimension: ...
    @classmethod
    def getSplashScreen(cls) -> 'SplashScreen': ...
    def isVisible(self) -> bool: ...
    def setImageURL(self, uRL: java.net.URL) -> None: ...
    def update(self) -> None: ...

class Stroke:
    def createStrokedShape(self, shape: Shape) -> Shape: ...

class SystemTray:
    def add(self, trayIcon: 'TrayIcon') -> None: ...
    def addPropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def getPropertyChangeListeners(self, string: str) -> _py_List[java.beans.PropertyChangeListener]: ...
    @classmethod
    def getSystemTray(cls) -> 'SystemTray': ...
    def getTrayIconSize(self) -> Dimension: ...
    def getTrayIcons(self) -> _py_List['TrayIcon']: ...
    @classmethod
    def isSupported(cls) -> bool: ...
    def remove(self, trayIcon: 'TrayIcon') -> None: ...
    def removePropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...

class Toolkit:
    def __init__(self): ...
    def addAWTEventListener(self, aWTEventListener: java.awt.event.AWTEventListener, long: int) -> None: ...
    def addPropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def areExtraMouseButtonsEnabled(self) -> bool: ...
    def beep(self) -> None: ...
    def checkImage(self, image: Image, int: int, int2: int, imageObserver: java.awt.image.ImageObserver) -> int: ...
    def createCustomCursor(self, image: Image, point: Point, string: str) -> Cursor: ...
    _createDragGestureRecognizer__T = _py_TypeVar('_createDragGestureRecognizer__T', bound=java.awt.dnd.DragGestureRecognizer)  # <T>
    def createDragGestureRecognizer(self, class_: _py_Type[_createDragGestureRecognizer__T], dragSource: java.awt.dnd.DragSource, component: 'Component', int: int, dragGestureListener: java.awt.dnd.DragGestureListener) -> _createDragGestureRecognizer__T: ...
    def createDragSourceContextPeer(self, dragGestureEvent: java.awt.dnd.DragGestureEvent) -> java.awt.dnd.peer.DragSourceContextPeer: ...
    @overload
    def createImage(self, byteArray: _py_List[int], int: int, int2: int) -> Image: ...
    @overload
    def createImage(self, imageProducer: java.awt.image.ImageProducer) -> Image: ...
    @overload
    def createImage(self, string: str) -> Image: ...
    @overload
    def createImage(self, uRL: java.net.URL) -> Image: ...
    @overload
    def createImage(self, byteArray: _py_List[int]) -> Image: ...
    @overload
    def getAWTEventListeners(self) -> _py_List[java.awt.event.AWTEventListener]: ...
    @overload
    def getAWTEventListeners(self, long: int) -> _py_List[java.awt.event.AWTEventListener]: ...
    def getBestCursorSize(self, int: int, int2: int) -> Dimension: ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    @classmethod
    def getDefaultToolkit(cls) -> 'Toolkit': ...
    def getDesktopProperty(self, string: str) -> _py_Any: ...
    def getFontList(self) -> _py_List[str]: ...
    def getFontMetrics(self, font: Font) -> FontMetrics: ...
    @overload
    def getImage(self, string: str) -> Image: ...
    @overload
    def getImage(self, uRL: java.net.URL) -> Image: ...
    def getLockingKeyState(self, int: int) -> bool: ...
    def getMaximumCursorColors(self) -> int: ...
    def getMenuShortcutKeyMask(self) -> int: ...
    @overload
    def getPrintJob(self, frame: 'Frame', string: str, properties: java.util.Properties) -> PrintJob: ...
    @overload
    def getPrintJob(self, frame: 'Frame', string: str, jobAttributes: 'JobAttributes', pageAttributes: 'PageAttributes') -> PrintJob: ...
    @classmethod
    def getProperty(cls, string: str, string2: str) -> str: ...
    @overload
    def getPropertyChangeListeners(self) -> _py_List[java.beans.PropertyChangeListener]: ...
    @overload
    def getPropertyChangeListeners(self, string: str) -> _py_List[java.beans.PropertyChangeListener]: ...
    def getScreenInsets(self, graphicsConfiguration: GraphicsConfiguration) -> Insets: ...
    def getScreenResolution(self) -> int: ...
    def getScreenSize(self) -> Dimension: ...
    def getSystemClipboard(self) -> java.awt.datatransfer.Clipboard: ...
    def getSystemEventQueue(self) -> EventQueue: ...
    def getSystemSelection(self) -> java.awt.datatransfer.Clipboard: ...
    def isAlwaysOnTopSupported(self) -> bool: ...
    def isDynamicLayoutActive(self) -> bool: ...
    def isFrameStateSupported(self, int: int) -> bool: ...
    def isModalExclusionTypeSupported(self, modalExclusionType: 'Dialog.ModalExclusionType') -> bool: ...
    def isModalityTypeSupported(self, modalityType: 'Dialog.ModalityType') -> bool: ...
    def mapInputMethodHighlight(self, inputMethodHighlight: java.awt.im.InputMethodHighlight) -> java.util.Map[java.awt.font.TextAttribute, _py_Any]: ...
    def prepareImage(self, image: Image, int: int, int2: int, imageObserver: java.awt.image.ImageObserver) -> bool: ...
    def removeAWTEventListener(self, aWTEventListener: java.awt.event.AWTEventListener) -> None: ...
    def removePropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def setDynamicLayout(self, boolean: bool) -> None: ...
    def setLockingKeyState(self, int: int, boolean: bool) -> None: ...
    def sync(self) -> None: ...

class Transparency:
    OPAQUE: _py_ClassVar[int] = ...
    BITMASK: _py_ClassVar[int] = ...
    TRANSLUCENT: _py_ClassVar[int] = ...
    def getTransparency(self) -> int: ...

class TrayIcon:
    @overload
    def __init__(self, image: Image): ...
    @overload
    def __init__(self, image: Image, string: str): ...
    @overload
    def __init__(self, image: Image, string: str, popupMenu: 'PopupMenu'): ...
    def addActionListener(self, actionListener: java.awt.event.ActionListener) -> None: ...
    def addMouseListener(self, mouseListener: java.awt.event.MouseListener) -> None: ...
    def addMouseMotionListener(self, mouseMotionListener: java.awt.event.MouseMotionListener) -> None: ...
    def displayMessage(self, string: str, string2: str, messageType: 'TrayIcon.MessageType') -> None: ...
    def getActionCommand(self) -> str: ...
    def getActionListeners(self) -> _py_List[java.awt.event.ActionListener]: ...
    def getImage(self) -> Image: ...
    def getMouseListeners(self) -> _py_List[java.awt.event.MouseListener]: ...
    def getMouseMotionListeners(self) -> _py_List[java.awt.event.MouseMotionListener]: ...
    def getPopupMenu(self) -> 'PopupMenu': ...
    def getSize(self) -> Dimension: ...
    def getToolTip(self) -> str: ...
    def isImageAutoSize(self) -> bool: ...
    def removeActionListener(self, actionListener: java.awt.event.ActionListener) -> None: ...
    def removeMouseListener(self, mouseListener: java.awt.event.MouseListener) -> None: ...
    def removeMouseMotionListener(self, mouseMotionListener: java.awt.event.MouseMotionListener) -> None: ...
    def setActionCommand(self, string: str) -> None: ...
    def setImage(self, image: Image) -> None: ...
    def setImageAutoSize(self, boolean: bool) -> None: ...
    def setPopupMenu(self, popupMenu: 'PopupMenu') -> None: ...
    def setToolTip(self, string: str) -> None: ...
    class MessageType(java.lang.Enum['TrayIcon.MessageType']):
        ERROR: _py_ClassVar['TrayIcon.MessageType'] = ...
        WARNING: _py_ClassVar['TrayIcon.MessageType'] = ...
        INFO: _py_ClassVar['TrayIcon.MessageType'] = ...
        NONE: _py_ClassVar['TrayIcon.MessageType'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'TrayIcon.MessageType': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['TrayIcon.MessageType']: ...

class VKCollection:
    def __init__(self): ...
    def findCode(self, string: str) -> int: ...
    def findName(self, integer: int) -> str: ...
    def put(self, string: str, integer: int) -> None: ...

class AlphaComposite(Composite):
    CLEAR: _py_ClassVar[int] = ...
    SRC: _py_ClassVar[int] = ...
    DST: _py_ClassVar[int] = ...
    SRC_OVER: _py_ClassVar[int] = ...
    DST_OVER: _py_ClassVar[int] = ...
    SRC_IN: _py_ClassVar[int] = ...
    DST_IN: _py_ClassVar[int] = ...
    SRC_OUT: _py_ClassVar[int] = ...
    DST_OUT: _py_ClassVar[int] = ...
    SRC_ATOP: _py_ClassVar[int] = ...
    DST_ATOP: _py_ClassVar[int] = ...
    XOR: _py_ClassVar[int] = ...
    Clear: _py_ClassVar['AlphaComposite'] = ...
    Src: _py_ClassVar['AlphaComposite'] = ...
    Dst: _py_ClassVar['AlphaComposite'] = ...
    SrcOver: _py_ClassVar['AlphaComposite'] = ...
    DstOver: _py_ClassVar['AlphaComposite'] = ...
    SrcIn: _py_ClassVar['AlphaComposite'] = ...
    DstIn: _py_ClassVar['AlphaComposite'] = ...
    SrcOut: _py_ClassVar['AlphaComposite'] = ...
    DstOut: _py_ClassVar['AlphaComposite'] = ...
    SrcAtop: _py_ClassVar['AlphaComposite'] = ...
    DstAtop: _py_ClassVar['AlphaComposite'] = ...
    Xor: _py_ClassVar['AlphaComposite'] = ...
    def createContext(self, colorModel: java.awt.image.ColorModel, colorModel2: java.awt.image.ColorModel, renderingHints: RenderingHints) -> CompositeContext: ...
    @overload
    def derive(self, float: float) -> 'AlphaComposite': ...
    @overload
    def derive(self, int: int) -> 'AlphaComposite': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAlpha(self) -> float: ...
    @classmethod
    @overload
    def getInstance(cls, int: int) -> 'AlphaComposite': ...
    @classmethod
    @overload
    def getInstance(cls, int: int, float: float) -> 'AlphaComposite': ...
    def getRule(self) -> int: ...
    def hashCode(self) -> int: ...

class BasicStroke(Stroke):
    JOIN_MITER: _py_ClassVar[int] = ...
    JOIN_ROUND: _py_ClassVar[int] = ...
    JOIN_BEVEL: _py_ClassVar[int] = ...
    CAP_BUTT: _py_ClassVar[int] = ...
    CAP_ROUND: _py_ClassVar[int] = ...
    CAP_SQUARE: _py_ClassVar[int] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, float: float): ...
    @overload
    def __init__(self, float: float, int: int, int2: int): ...
    @overload
    def __init__(self, float: float, int: int, int2: int, float2: float): ...
    @overload
    def __init__(self, float: float, int: int, int2: int, float2: float, floatArray: _py_List[float], float4: float): ...
    def createStrokedShape(self, shape: Shape) -> Shape: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDashArray(self) -> _py_List[float]: ...
    def getDashPhase(self) -> float: ...
    def getEndCap(self) -> int: ...
    def getLineJoin(self) -> int: ...
    def getLineWidth(self) -> float: ...
    def getMiterLimit(self) -> float: ...
    def hashCode(self) -> int: ...

class BufferCapabilities(java.lang.Cloneable):
    def __init__(self, imageCapabilities: ImageCapabilities, imageCapabilities2: ImageCapabilities, flipContents: 'BufferCapabilities.FlipContents'): ...
    def clone(self) -> _py_Any: ...
    def getBackBufferCapabilities(self) -> ImageCapabilities: ...
    def getFlipContents(self) -> 'BufferCapabilities.FlipContents': ...
    def getFrontBufferCapabilities(self) -> ImageCapabilities: ...
    def isFullScreenRequired(self) -> bool: ...
    def isMultiBufferAvailable(self) -> bool: ...
    def isPageFlipping(self) -> bool: ...
    class FlipContents(AttributeValue):
        UNDEFINED: _py_ClassVar['BufferCapabilities.FlipContents'] = ...
        BACKGROUND: _py_ClassVar['BufferCapabilities.FlipContents'] = ...
        PRIOR: _py_ClassVar['BufferCapabilities.FlipContents'] = ...
        COPIED: _py_ClassVar['BufferCapabilities.FlipContents'] = ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...

class ColorPaintContext(PaintContext):
    def dispose(self) -> None: ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    def getRaster(self, int: int, int2: int, int3: int, int4: int) -> java.awt.image.Raster: ...

class Component(java.awt.image.ImageObserver, MenuContainer, java.io.Serializable):
    TOP_ALIGNMENT: _py_ClassVar[float] = ...
    CENTER_ALIGNMENT: _py_ClassVar[float] = ...
    BOTTOM_ALIGNMENT: _py_ClassVar[float] = ...
    LEFT_ALIGNMENT: _py_ClassVar[float] = ...
    RIGHT_ALIGNMENT: _py_ClassVar[float] = ...
    def action(self, event: Event, object: _py_Any) -> bool: ...
    def add(self, popupMenu: 'PopupMenu') -> None: ...
    def addComponentListener(self, componentListener: java.awt.event.ComponentListener) -> None: ...
    def addFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def addHierarchyBoundsListener(self, hierarchyBoundsListener: java.awt.event.HierarchyBoundsListener) -> None: ...
    def addHierarchyListener(self, hierarchyListener: java.awt.event.HierarchyListener) -> None: ...
    def addInputMethodListener(self, inputMethodListener: java.awt.event.InputMethodListener) -> None: ...
    def addKeyListener(self, keyListener: java.awt.event.KeyListener) -> None: ...
    def addMouseListener(self, mouseListener: java.awt.event.MouseListener) -> None: ...
    def addMouseMotionListener(self, mouseMotionListener: java.awt.event.MouseMotionListener) -> None: ...
    def addMouseWheelListener(self, mouseWheelListener: java.awt.event.MouseWheelListener) -> None: ...
    def addNotify(self) -> None: ...
    @overload
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    @overload
    def addPropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def applyComponentOrientation(self, componentOrientation: ComponentOrientation) -> None: ...
    def areFocusTraversalKeysSet(self, int: int) -> bool: ...
    def bounds(self) -> 'Rectangle': ...
    @overload
    def checkImage(self, image: Image, int: int, int2: int, imageObserver: java.awt.image.ImageObserver) -> int: ...
    @overload
    def checkImage(self, image: Image, imageObserver: java.awt.image.ImageObserver) -> int: ...
    @overload
    def contains(self, int: int, int2: int) -> bool: ...
    @overload
    def contains(self, point: Point) -> bool: ...
    @overload
    def createImage(self, int: int, int2: int) -> Image: ...
    @overload
    def createImage(self, imageProducer: java.awt.image.ImageProducer) -> Image: ...
    @overload
    def createVolatileImage(self, int: int, int2: int) -> java.awt.image.VolatileImage: ...
    @overload
    def createVolatileImage(self, int: int, int2: int, imageCapabilities: ImageCapabilities) -> java.awt.image.VolatileImage: ...
    def deliverEvent(self, event: Event) -> None: ...
    def disable(self) -> None: ...
    def dispatchEvent(self, aWTEvent: AWTEvent) -> None: ...
    def doLayout(self) -> None: ...
    @overload
    def enable(self) -> None: ...
    @overload
    def enable(self, boolean: bool) -> None: ...
    def enableInputMethods(self, boolean: bool) -> None: ...
    @overload
    def firePropertyChange(self, string: str, byte: int, byte2: int) -> None: ...
    @overload
    def firePropertyChange(self, string: str, char: str, char2: str) -> None: ...
    @overload
    def firePropertyChange(self, string: str, double: float, double2: float) -> None: ...
    @overload
    def firePropertyChange(self, string: str, float: float, float2: float) -> None: ...
    @overload
    def firePropertyChange(self, string: str, long: int, long2: int) -> None: ...
    @overload
    def firePropertyChange(self, string: str, short: int, short2: int) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getAlignmentX(self) -> float: ...
    def getAlignmentY(self) -> float: ...
    def getBackground(self) -> 'Color': ...
    def getBaseline(self, int: int, int2: int) -> int: ...
    def getBaselineResizeBehavior(self) -> 'Component.BaselineResizeBehavior': ...
    @overload
    def getBounds(self) -> 'Rectangle': ...
    @overload
    def getBounds(self, rectangle: 'Rectangle') -> 'Rectangle': ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    @overload
    def getComponentAt(self, int: int, int2: int) -> 'Component': ...
    @overload
    def getComponentAt(self, point: Point) -> 'Component': ...
    def getComponentListeners(self) -> _py_List[java.awt.event.ComponentListener]: ...
    def getComponentOrientation(self) -> ComponentOrientation: ...
    def getCursor(self) -> Cursor: ...
    def getDropTarget(self) -> java.awt.dnd.DropTarget: ...
    def getFocusCycleRootAncestor(self) -> 'Container': ...
    def getFocusListeners(self) -> _py_List[java.awt.event.FocusListener]: ...
    def getFocusTraversalKeys(self, int: int) -> java.util.Set[AWTKeyStroke]: ...
    def getFocusTraversalKeysEnabled(self) -> bool: ...
    def getFont(self) -> Font: ...
    def getFontMetrics(self, font: Font) -> FontMetrics: ...
    def getForeground(self) -> 'Color': ...
    def getGraphics(self) -> Graphics: ...
    def getGraphicsConfiguration(self) -> GraphicsConfiguration: ...
    def getHeight(self) -> int: ...
    def getHierarchyBoundsListeners(self) -> _py_List[java.awt.event.HierarchyBoundsListener]: ...
    def getHierarchyListeners(self) -> _py_List[java.awt.event.HierarchyListener]: ...
    def getIgnoreRepaint(self) -> bool: ...
    def getInputContext(self) -> java.awt.im.InputContext: ...
    def getInputMethodListeners(self) -> _py_List[java.awt.event.InputMethodListener]: ...
    def getInputMethodRequests(self) -> java.awt.im.InputMethodRequests: ...
    def getKeyListeners(self) -> _py_List[java.awt.event.KeyListener]: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    def getLocale(self) -> java.util.Locale: ...
    @overload
    def getLocation(self) -> Point: ...
    @overload
    def getLocation(self, point: Point) -> Point: ...
    def getLocationOnScreen(self) -> Point: ...
    def getMaximumSize(self) -> Dimension: ...
    def getMinimumSize(self) -> Dimension: ...
    def getMouseListeners(self) -> _py_List[java.awt.event.MouseListener]: ...
    def getMouseMotionListeners(self) -> _py_List[java.awt.event.MouseMotionListener]: ...
    def getMousePosition(self) -> Point: ...
    def getMouseWheelListeners(self) -> _py_List[java.awt.event.MouseWheelListener]: ...
    def getName(self) -> str: ...
    def getParent(self) -> 'Container': ...
    def getPeer(self) -> java.awt.peer.ComponentPeer: ...
    def getPreferredSize(self) -> Dimension: ...
    @overload
    def getPropertyChangeListeners(self) -> _py_List[java.beans.PropertyChangeListener]: ...
    @overload
    def getPropertyChangeListeners(self, string: str) -> _py_List[java.beans.PropertyChangeListener]: ...
    @overload
    def getSize(self) -> Dimension: ...
    @overload
    def getSize(self, dimension: Dimension) -> Dimension: ...
    def getToolkit(self) -> Toolkit: ...
    def getTreeLock(self) -> _py_Any: ...
    def getWidth(self) -> int: ...
    def getX(self) -> int: ...
    def getY(self) -> int: ...
    def gotFocus(self, event: Event, object: _py_Any) -> bool: ...
    def handleEvent(self, event: Event) -> bool: ...
    def hasFocus(self) -> bool: ...
    def hide(self) -> None: ...
    def imageUpdate(self, image: Image, int: int, int2: int, int3: int, int4: int, int5: int) -> bool: ...
    def inside(self, int: int, int2: int) -> bool: ...
    def invalidate(self) -> None: ...
    def isBackgroundSet(self) -> bool: ...
    def isCursorSet(self) -> bool: ...
    def isDisplayable(self) -> bool: ...
    def isDoubleBuffered(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isFocusCycleRoot(self, container: 'Container') -> bool: ...
    def isFocusOwner(self) -> bool: ...
    def isFocusTraversable(self) -> bool: ...
    def isFocusable(self) -> bool: ...
    def isFontSet(self) -> bool: ...
    def isForegroundSet(self) -> bool: ...
    def isLightweight(self) -> bool: ...
    def isMaximumSizeSet(self) -> bool: ...
    def isMinimumSizeSet(self) -> bool: ...
    def isOpaque(self) -> bool: ...
    def isPreferredSizeSet(self) -> bool: ...
    def isShowing(self) -> bool: ...
    def isValid(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def keyDown(self, event: Event, int: int) -> bool: ...
    def keyUp(self, event: Event, int: int) -> bool: ...
    def layout(self) -> None: ...
    @overload
    def list(self) -> None: ...
    @overload
    def list(self, printStream: java.io.PrintStream) -> None: ...
    @overload
    def list(self, printStream: java.io.PrintStream, int: int) -> None: ...
    @overload
    def list(self, printWriter: java.io.PrintWriter) -> None: ...
    @overload
    def list(self, printWriter: java.io.PrintWriter, int: int) -> None: ...
    def locate(self, int: int, int2: int) -> 'Component': ...
    def location(self) -> Point: ...
    def lostFocus(self, event: Event, object: _py_Any) -> bool: ...
    def minimumSize(self) -> Dimension: ...
    def mouseDown(self, event: Event, int: int, int2: int) -> bool: ...
    def mouseDrag(self, event: Event, int: int, int2: int) -> bool: ...
    def mouseEnter(self, event: Event, int: int, int2: int) -> bool: ...
    def mouseExit(self, event: Event, int: int, int2: int) -> bool: ...
    def mouseMove(self, event: Event, int: int, int2: int) -> bool: ...
    def mouseUp(self, event: Event, int: int, int2: int) -> bool: ...
    def move(self, int: int, int2: int) -> None: ...
    def nextFocus(self) -> None: ...
    def paint(self, graphics: Graphics) -> None: ...
    def paintAll(self, graphics: Graphics) -> None: ...
    def postEvent(self, event: Event) -> bool: ...
    def preferredSize(self) -> Dimension: ...
    @overload
    def prepareImage(self, image: Image, int: int, int2: int, imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def prepareImage(self, image: Image, imageObserver: java.awt.image.ImageObserver) -> bool: ...
    def printAll(self, graphics: Graphics) -> None: ...
    def remove(self, menuComponent: MenuComponent) -> None: ...
    def removeComponentListener(self, componentListener: java.awt.event.ComponentListener) -> None: ...
    def removeFocusListener(self, focusListener: java.awt.event.FocusListener) -> None: ...
    def removeHierarchyBoundsListener(self, hierarchyBoundsListener: java.awt.event.HierarchyBoundsListener) -> None: ...
    def removeHierarchyListener(self, hierarchyListener: java.awt.event.HierarchyListener) -> None: ...
    def removeInputMethodListener(self, inputMethodListener: java.awt.event.InputMethodListener) -> None: ...
    def removeKeyListener(self, keyListener: java.awt.event.KeyListener) -> None: ...
    def removeMouseListener(self, mouseListener: java.awt.event.MouseListener) -> None: ...
    def removeMouseMotionListener(self, mouseMotionListener: java.awt.event.MouseMotionListener) -> None: ...
    def removeMouseWheelListener(self, mouseWheelListener: java.awt.event.MouseWheelListener) -> None: ...
    def removeNotify(self) -> None: ...
    @overload
    def removePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    @overload
    def removePropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    @overload
    def repaint(self) -> None: ...
    @overload
    def repaint(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @overload
    def repaint(self, long: int) -> None: ...
    @overload
    def repaint(self, long: int, int: int, int2: int, int3: int, int4: int) -> None: ...
    def requestFocus(self) -> None: ...
    def requestFocusInWindow(self) -> bool: ...
    def reshape(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @overload
    def resize(self, int: int, int2: int) -> None: ...
    @overload
    def resize(self, dimension: Dimension) -> None: ...
    def revalidate(self) -> None: ...
    def setBackground(self, color: 'Color') -> None: ...
    @overload
    def setBounds(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @overload
    def setBounds(self, rectangle: 'Rectangle') -> None: ...
    def setComponentOrientation(self, componentOrientation: ComponentOrientation) -> None: ...
    def setCursor(self, cursor: Cursor) -> None: ...
    def setDropTarget(self, dropTarget: java.awt.dnd.DropTarget) -> None: ...
    def setEnabled(self, boolean: bool) -> None: ...
    def setFocusTraversalKeys(self, int: int, set: java.util.Set[AWTKeyStroke]) -> None: ...
    def setFocusTraversalKeysEnabled(self, boolean: bool) -> None: ...
    def setFocusable(self, boolean: bool) -> None: ...
    def setFont(self, font: Font) -> None: ...
    def setForeground(self, color: 'Color') -> None: ...
    def setIgnoreRepaint(self, boolean: bool) -> None: ...
    def setLocale(self, locale: java.util.Locale) -> None: ...
    @overload
    def setLocation(self, int: int, int2: int) -> None: ...
    @overload
    def setLocation(self, point: Point) -> None: ...
    def setMaximumSize(self, dimension: Dimension) -> None: ...
    def setMinimumSize(self, dimension: Dimension) -> None: ...
    def setName(self, string: str) -> None: ...
    def setPreferredSize(self, dimension: Dimension) -> None: ...
    @overload
    def setSize(self, int: int, int2: int) -> None: ...
    @overload
    def setSize(self, dimension: Dimension) -> None: ...
    def setVisible(self, boolean: bool) -> None: ...
    @overload
    def show(self) -> None: ...
    @overload
    def show(self, boolean: bool) -> None: ...
    def size(self) -> Dimension: ...
    def toString(self) -> str: ...
    def transferFocus(self) -> None: ...
    def transferFocusBackward(self) -> None: ...
    def transferFocusUpCycle(self) -> None: ...
    def update(self, graphics: Graphics) -> None: ...
    def validate(self) -> None: ...
    class BaselineResizeBehavior(java.lang.Enum['Component.BaselineResizeBehavior']):
        CONSTANT_ASCENT: _py_ClassVar['Component.BaselineResizeBehavior'] = ...
        CONSTANT_DESCENT: _py_ClassVar['Component.BaselineResizeBehavior'] = ...
        CENTER_OFFSET: _py_ClassVar['Component.BaselineResizeBehavior'] = ...
        OTHER: _py_ClassVar['Component.BaselineResizeBehavior'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'Component.BaselineResizeBehavior': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['Component.BaselineResizeBehavior']: ...

class ContainerOrderFocusTraversalPolicy(FocusTraversalPolicy, java.io.Serializable):
    def __init__(self): ...
    def getComponentAfter(self, container: 'Container', component: Component) -> Component: ...
    def getComponentBefore(self, container: 'Container', component: Component) -> Component: ...
    def getDefaultComponent(self, container: 'Container') -> Component: ...
    def getFirstComponent(self, container: 'Container') -> Component: ...
    def getImplicitDownCycleTraversal(self) -> bool: ...
    def getLastComponent(self, container: 'Container') -> Component: ...
    def setImplicitDownCycleTraversal(self, boolean: bool) -> None: ...

class FlowLayout(LayoutManager, java.io.Serializable):
    LEFT: _py_ClassVar[int] = ...
    CENTER: _py_ClassVar[int] = ...
    RIGHT: _py_ClassVar[int] = ...
    LEADING: _py_ClassVar[int] = ...
    TRAILING: _py_ClassVar[int] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int): ...
    def addLayoutComponent(self, string: str, component: Component) -> None: ...
    def getAlignOnBaseline(self) -> bool: ...
    def getAlignment(self) -> int: ...
    def getHgap(self) -> int: ...
    def getVgap(self) -> int: ...
    def layoutContainer(self, container: 'Container') -> None: ...
    def minimumLayoutSize(self, container: 'Container') -> Dimension: ...
    def preferredLayoutSize(self, container: 'Container') -> Dimension: ...
    def removeLayoutComponent(self, component: Component) -> None: ...
    def setAlignOnBaseline(self, boolean: bool) -> None: ...
    def setAlignment(self, int: int) -> None: ...
    def setHgap(self, int: int) -> None: ...
    def setVgap(self, int: int) -> None: ...
    def toString(self) -> str: ...

class GradientPaintContext(PaintContext):
    def __init__(self, colorModel: java.awt.image.ColorModel, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D, affineTransform: java.awt.geom.AffineTransform, color2: 'Color', color3: 'Color', boolean: bool): ...
    def dispose(self) -> None: ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    def getRaster(self, int: int, int2: int, int3: int, int4: int) -> java.awt.image.Raster: ...

class Graphics2D(Graphics):
    def addRenderingHints(self, map: java.util.Map[_py_Any, _py_Any]) -> None: ...
    def clip(self, shape: Shape) -> None: ...
    def draw(self, shape: Shape) -> None: ...
    def draw3DRect(self, int: int, int2: int, int3: int, int4: int, boolean: bool) -> None: ...
    def drawGlyphVector(self, glyphVector: java.awt.font.GlyphVector, float: float, float2: float) -> None: ...
    @overload
    def drawImage(self, image: Image, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, color: 'Color', imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, image: Image, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, image: Image, int: int, int2: int, int3: int, int4: int, color: 'Color', imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, image: Image, int: int, int2: int, int3: int, int4: int, imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, image: Image, int: int, int2: int, color: 'Color', imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, image: Image, int: int, int2: int, imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, image: Image, affineTransform: java.awt.geom.AffineTransform, imageObserver: java.awt.image.ImageObserver) -> bool: ...
    @overload
    def drawImage(self, bufferedImage: java.awt.image.BufferedImage, bufferedImageOp: java.awt.image.BufferedImageOp, int: int, int2: int) -> None: ...
    def drawRenderableImage(self, renderableImage: java.awt.image.renderable.RenderableImage, affineTransform: java.awt.geom.AffineTransform) -> None: ...
    def drawRenderedImage(self, renderedImage: java.awt.image.RenderedImage, affineTransform: java.awt.geom.AffineTransform) -> None: ...
    @overload
    def drawString(self, string: str, float: float, float2: float) -> None: ...
    @overload
    def drawString(self, string: str, int: int, int2: int) -> None: ...
    @overload
    def drawString(self, attributedCharacterIterator: java.text.AttributedCharacterIterator, float: float, float2: float) -> None: ...
    @overload
    def drawString(self, attributedCharacterIterator: java.text.AttributedCharacterIterator, int: int, int2: int) -> None: ...
    def fill(self, shape: Shape) -> None: ...
    def fill3DRect(self, int: int, int2: int, int3: int, int4: int, boolean: bool) -> None: ...
    def getBackground(self) -> 'Color': ...
    def getComposite(self) -> Composite: ...
    def getDeviceConfiguration(self) -> GraphicsConfiguration: ...
    def getFontRenderContext(self) -> java.awt.font.FontRenderContext: ...
    def getPaint(self) -> 'Paint': ...
    def getRenderingHint(self, key: RenderingHints.Key) -> _py_Any: ...
    def getRenderingHints(self) -> RenderingHints: ...
    def getStroke(self) -> Stroke: ...
    def getTransform(self) -> java.awt.geom.AffineTransform: ...
    def hit(self, rectangle: 'Rectangle', shape: Shape, boolean: bool) -> bool: ...
    @overload
    def rotate(self, double: float) -> None: ...
    @overload
    def rotate(self, double: float, double2: float, double3: float) -> None: ...
    def scale(self, double: float, double2: float) -> None: ...
    def setBackground(self, color: 'Color') -> None: ...
    def setComposite(self, composite: Composite) -> None: ...
    def setPaint(self, paint: 'Paint') -> None: ...
    def setRenderingHint(self, key: RenderingHints.Key, object: _py_Any) -> None: ...
    def setRenderingHints(self, map: java.util.Map[_py_Any, _py_Any]) -> None: ...
    def setStroke(self, stroke: Stroke) -> None: ...
    def setTransform(self, affineTransform: java.awt.geom.AffineTransform) -> None: ...
    def shear(self, double: float, double2: float) -> None: ...
    def transform(self, affineTransform: java.awt.geom.AffineTransform) -> None: ...
    @overload
    def translate(self, double: float, double2: float) -> None: ...
    @overload
    def translate(self, int: int, int2: int) -> None: ...

class GridLayout(LayoutManager, java.io.Serializable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    def addLayoutComponent(self, string: str, component: Component) -> None: ...
    def getColumns(self) -> int: ...
    def getHgap(self) -> int: ...
    def getRows(self) -> int: ...
    def getVgap(self) -> int: ...
    def layoutContainer(self, container: 'Container') -> None: ...
    def minimumLayoutSize(self, container: 'Container') -> Dimension: ...
    def preferredLayoutSize(self, container: 'Container') -> Dimension: ...
    def removeLayoutComponent(self, component: Component) -> None: ...
    def setColumns(self, int: int) -> None: ...
    def setHgap(self, int: int) -> None: ...
    def setRows(self, int: int) -> None: ...
    def setVgap(self, int: int) -> None: ...
    def toString(self) -> str: ...

class ImageMediaEntry(MediaEntry, java.awt.image.ImageObserver, java.io.Serializable):
    def imageUpdate(self, image: Image, int: int, int2: int, int3: int, int4: int, int5: int) -> bool: ...

class JobAttributes(java.lang.Cloneable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int, defaultSelectionType: 'JobAttributes.DefaultSelectionType', destinationType: 'JobAttributes.DestinationType', dialogType: 'JobAttributes.DialogType', string: str, int2: int, int3: int, multipleDocumentHandlingType: 'JobAttributes.MultipleDocumentHandlingType', intArray: _py_List[_py_List[int]], string2: str, sidesType: 'JobAttributes.SidesType'): ...
    @overload
    def __init__(self, jobAttributes: 'JobAttributes'): ...
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getCopies(self) -> int: ...
    def getDefaultSelection(self) -> 'JobAttributes.DefaultSelectionType': ...
    def getDestination(self) -> 'JobAttributes.DestinationType': ...
    def getDialog(self) -> 'JobAttributes.DialogType': ...
    def getFileName(self) -> str: ...
    def getFromPage(self) -> int: ...
    def getMaxPage(self) -> int: ...
    def getMinPage(self) -> int: ...
    def getMultipleDocumentHandling(self) -> 'JobAttributes.MultipleDocumentHandlingType': ...
    def getPageRanges(self) -> _py_List[_py_List[int]]: ...
    def getPrinter(self) -> str: ...
    def getSides(self) -> 'JobAttributes.SidesType': ...
    def getToPage(self) -> int: ...
    def hashCode(self) -> int: ...
    def set(self, jobAttributes: 'JobAttributes') -> None: ...
    def setCopies(self, int: int) -> None: ...
    def setCopiesToDefault(self) -> None: ...
    def setDefaultSelection(self, defaultSelectionType: 'JobAttributes.DefaultSelectionType') -> None: ...
    def setDestination(self, destinationType: 'JobAttributes.DestinationType') -> None: ...
    def setDialog(self, dialogType: 'JobAttributes.DialogType') -> None: ...
    def setFileName(self, string: str) -> None: ...
    def setFromPage(self, int: int) -> None: ...
    def setMaxPage(self, int: int) -> None: ...
    def setMinPage(self, int: int) -> None: ...
    def setMultipleDocumentHandling(self, multipleDocumentHandlingType: 'JobAttributes.MultipleDocumentHandlingType') -> None: ...
    def setMultipleDocumentHandlingToDefault(self) -> None: ...
    def setPageRanges(self, intArray: _py_List[_py_List[int]]) -> None: ...
    def setPrinter(self, string: str) -> None: ...
    def setSides(self, sidesType: 'JobAttributes.SidesType') -> None: ...
    def setSidesToDefault(self) -> None: ...
    def setToPage(self, int: int) -> None: ...
    def toString(self) -> str: ...
    class DefaultSelectionType(AttributeValue):
        ALL: _py_ClassVar['JobAttributes.DefaultSelectionType'] = ...
        RANGE: _py_ClassVar['JobAttributes.DefaultSelectionType'] = ...
        SELECTION: _py_ClassVar['JobAttributes.DefaultSelectionType'] = ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
    class DestinationType(AttributeValue):
        FILE: _py_ClassVar['JobAttributes.DestinationType'] = ...
        PRINTER: _py_ClassVar['JobAttributes.DestinationType'] = ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
    class DialogType(AttributeValue):
        COMMON: _py_ClassVar['JobAttributes.DialogType'] = ...
        NATIVE: _py_ClassVar['JobAttributes.DialogType'] = ...
        NONE: _py_ClassVar['JobAttributes.DialogType'] = ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
    class MultipleDocumentHandlingType(AttributeValue):
        SEPARATE_DOCUMENTS_COLLATED_COPIES: _py_ClassVar['JobAttributes.MultipleDocumentHandlingType'] = ...
        SEPARATE_DOCUMENTS_UNCOLLATED_COPIES: _py_ClassVar['JobAttributes.MultipleDocumentHandlingType'] = ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
    class SidesType(AttributeValue):
        ONE_SIDED: _py_ClassVar['JobAttributes.SidesType'] = ...
        TWO_SIDED_LONG_EDGE: _py_ClassVar['JobAttributes.SidesType'] = ...
        TWO_SIDED_SHORT_EDGE: _py_ClassVar['JobAttributes.SidesType'] = ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...

class KeyboardFocusManager(KeyEventDispatcher, KeyEventPostProcessor):
    FORWARD_TRAVERSAL_KEYS: _py_ClassVar[int] = ...
    BACKWARD_TRAVERSAL_KEYS: _py_ClassVar[int] = ...
    UP_CYCLE_TRAVERSAL_KEYS: _py_ClassVar[int] = ...
    DOWN_CYCLE_TRAVERSAL_KEYS: _py_ClassVar[int] = ...
    def __init__(self): ...
    def addKeyEventDispatcher(self, keyEventDispatcher: KeyEventDispatcher) -> None: ...
    def addKeyEventPostProcessor(self, keyEventPostProcessor: KeyEventPostProcessor) -> None: ...
    @overload
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    @overload
    def addPropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    @overload
    def addVetoableChangeListener(self, vetoableChangeListener: java.beans.VetoableChangeListener) -> None: ...
    @overload
    def addVetoableChangeListener(self, string: str, vetoableChangeListener: java.beans.VetoableChangeListener) -> None: ...
    def clearFocusOwner(self) -> None: ...
    def clearGlobalFocusOwner(self) -> None: ...
    def dispatchEvent(self, aWTEvent: AWTEvent) -> bool: ...
    def dispatchKeyEvent(self, keyEvent: java.awt.event.KeyEvent) -> bool: ...
    @overload
    def downFocusCycle(self, container: 'Container') -> None: ...
    @overload
    def downFocusCycle(self) -> None: ...
    @overload
    def focusNextComponent(self, component: Component) -> None: ...
    @overload
    def focusNextComponent(self) -> None: ...
    @overload
    def focusPreviousComponent(self, component: Component) -> None: ...
    @overload
    def focusPreviousComponent(self) -> None: ...
    def getActiveWindow(self) -> 'Window': ...
    def getCurrentFocusCycleRoot(self) -> 'Container': ...
    @classmethod
    def getCurrentKeyboardFocusManager(cls) -> 'KeyboardFocusManager': ...
    def getDefaultFocusTraversalKeys(self, int: int) -> java.util.Set[AWTKeyStroke]: ...
    def getDefaultFocusTraversalPolicy(self) -> FocusTraversalPolicy: ...
    def getFocusOwner(self) -> Component: ...
    def getFocusedWindow(self) -> 'Window': ...
    def getPermanentFocusOwner(self) -> Component: ...
    @overload
    def getPropertyChangeListeners(self) -> _py_List[java.beans.PropertyChangeListener]: ...
    @overload
    def getPropertyChangeListeners(self, string: str) -> _py_List[java.beans.PropertyChangeListener]: ...
    @overload
    def getVetoableChangeListeners(self) -> _py_List[java.beans.VetoableChangeListener]: ...
    @overload
    def getVetoableChangeListeners(self, string: str) -> _py_List[java.beans.VetoableChangeListener]: ...
    def postProcessKeyEvent(self, keyEvent: java.awt.event.KeyEvent) -> bool: ...
    def processKeyEvent(self, component: Component, keyEvent: java.awt.event.KeyEvent) -> None: ...
    def redispatchEvent(self, component: Component, aWTEvent: AWTEvent) -> None: ...
    def removeKeyEventDispatcher(self, keyEventDispatcher: KeyEventDispatcher) -> None: ...
    def removeKeyEventPostProcessor(self, keyEventPostProcessor: KeyEventPostProcessor) -> None: ...
    @overload
    def removePropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    @overload
    def removePropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    @overload
    def removeVetoableChangeListener(self, vetoableChangeListener: java.beans.VetoableChangeListener) -> None: ...
    @overload
    def removeVetoableChangeListener(self, string: str, vetoableChangeListener: java.beans.VetoableChangeListener) -> None: ...
    @classmethod
    def setCurrentKeyboardFocusManager(cls, keyboardFocusManager: 'KeyboardFocusManager') -> None: ...
    def setDefaultFocusTraversalKeys(self, int: int, set: java.util.Set[AWTKeyStroke]) -> None: ...
    def setDefaultFocusTraversalPolicy(self, focusTraversalPolicy: FocusTraversalPolicy) -> None: ...
    def setGlobalCurrentFocusCycleRoot(self, container: 'Container') -> None: ...
    @overload
    def upFocusCycle(self, component: Component) -> None: ...
    @overload
    def upFocusCycle(self) -> None: ...

class LayoutManager2(LayoutManager):
    @overload
    def addLayoutComponent(self, string: str, component: Component) -> None: ...
    @overload
    def addLayoutComponent(self, component: Component, object: _py_Any) -> None: ...
    def getLayoutAlignmentX(self, container: 'Container') -> float: ...
    def getLayoutAlignmentY(self, container: 'Container') -> float: ...
    def invalidateLayout(self, container: 'Container') -> None: ...
    def maximumLayoutSize(self, container: 'Container') -> Dimension: ...

class MenuBar(MenuComponent, MenuContainer, javax.accessibility.Accessible):
    def __init__(self): ...
    def add(self, menu: 'Menu') -> 'Menu': ...
    def addNotify(self) -> None: ...
    def countMenus(self) -> int: ...
    def deleteShortcut(self, menuShortcut: MenuShortcut) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getHelpMenu(self) -> 'Menu': ...
    def getMenu(self, int: int) -> 'Menu': ...
    def getMenuCount(self) -> int: ...
    def getShortcutMenuItem(self, menuShortcut: MenuShortcut) -> 'MenuItem': ...
    @overload
    def remove(self, int: int) -> None: ...
    @overload
    def remove(self, menuComponent: MenuComponent) -> None: ...
    def removeNotify(self) -> None: ...
    def setHelpMenu(self, menu: 'Menu') -> None: ...
    def shortcuts(self) -> java.util.Enumeration[MenuShortcut]: ...

class MenuItem(MenuComponent, javax.accessibility.Accessible):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, menuShortcut: MenuShortcut): ...
    def addActionListener(self, actionListener: java.awt.event.ActionListener) -> None: ...
    def addNotify(self) -> None: ...
    def deleteShortcut(self) -> None: ...
    def disable(self) -> None: ...
    @overload
    def enable(self) -> None: ...
    @overload
    def enable(self, boolean: bool) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getActionCommand(self) -> str: ...
    def getActionListeners(self) -> _py_List[java.awt.event.ActionListener]: ...
    def getLabel(self) -> str: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    def getShortcut(self) -> MenuShortcut: ...
    def isEnabled(self) -> bool: ...
    def paramString(self) -> str: ...
    def removeActionListener(self, actionListener: java.awt.event.ActionListener) -> None: ...
    def setActionCommand(self, string: str) -> None: ...
    def setEnabled(self, boolean: bool) -> None: ...
    def setLabel(self, string: str) -> None: ...
    def setShortcut(self, menuShortcut: MenuShortcut) -> None: ...

class ModalEventFilter(EventFilter):
    def acceptEvent(self, aWTEvent: AWTEvent) -> EventFilter.FilterAction: ...

class MultipleGradientPaintContext(PaintContext):
    def dispose(self) -> None: ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    def getRaster(self, int: int, int2: int, int3: int, int4: int) -> java.awt.image.Raster: ...

class PageAttributes(java.lang.Cloneable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, colorType: 'PageAttributes.ColorType', mediaType: 'PageAttributes.MediaType', orientationRequestedType: 'PageAttributes.OrientationRequestedType', originType: 'PageAttributes.OriginType', printQualityType: 'PageAttributes.PrintQualityType', intArray: _py_List[int]): ...
    @overload
    def __init__(self, pageAttributes: 'PageAttributes'): ...
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getColor(self) -> 'PageAttributes.ColorType': ...
    def getMedia(self) -> 'PageAttributes.MediaType': ...
    def getOrientationRequested(self) -> 'PageAttributes.OrientationRequestedType': ...
    def getOrigin(self) -> 'PageAttributes.OriginType': ...
    def getPrintQuality(self) -> 'PageAttributes.PrintQualityType': ...
    def getPrinterResolution(self) -> _py_List[int]: ...
    def hashCode(self) -> int: ...
    def set(self, pageAttributes: 'PageAttributes') -> None: ...
    def setColor(self, colorType: 'PageAttributes.ColorType') -> None: ...
    def setMedia(self, mediaType: 'PageAttributes.MediaType') -> None: ...
    def setMediaToDefault(self) -> None: ...
    @overload
    def setOrientationRequested(self, int: int) -> None: ...
    @overload
    def setOrientationRequested(self, orientationRequestedType: 'PageAttributes.OrientationRequestedType') -> None: ...
    def setOrientationRequestedToDefault(self) -> None: ...
    def setOrigin(self, originType: 'PageAttributes.OriginType') -> None: ...
    @overload
    def setPrintQuality(self, int: int) -> None: ...
    @overload
    def setPrintQuality(self, printQualityType: 'PageAttributes.PrintQualityType') -> None: ...
    def setPrintQualityToDefault(self) -> None: ...
    @overload
    def setPrinterResolution(self, int: int) -> None: ...
    @overload
    def setPrinterResolution(self, intArray: _py_List[int]) -> None: ...
    def setPrinterResolutionToDefault(self) -> None: ...
    def toString(self) -> str: ...
    class ColorType(AttributeValue):
        COLOR: _py_ClassVar['PageAttributes.ColorType'] = ...
        MONOCHROME: _py_ClassVar['PageAttributes.ColorType'] = ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
    class MediaType(AttributeValue):
        ISO_4A0: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_2A0: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_A0: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_A1: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_A2: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_A3: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_A4: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_A5: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_A6: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_A7: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_A8: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_A9: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_A10: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B0: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B1: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B2: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B3: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B4: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B5: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B6: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B7: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B8: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B9: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B10: _py_ClassVar['PageAttributes.MediaType'] = ...
        JIS_B0: _py_ClassVar['PageAttributes.MediaType'] = ...
        JIS_B1: _py_ClassVar['PageAttributes.MediaType'] = ...
        JIS_B2: _py_ClassVar['PageAttributes.MediaType'] = ...
        JIS_B3: _py_ClassVar['PageAttributes.MediaType'] = ...
        JIS_B4: _py_ClassVar['PageAttributes.MediaType'] = ...
        JIS_B5: _py_ClassVar['PageAttributes.MediaType'] = ...
        JIS_B6: _py_ClassVar['PageAttributes.MediaType'] = ...
        JIS_B7: _py_ClassVar['PageAttributes.MediaType'] = ...
        JIS_B8: _py_ClassVar['PageAttributes.MediaType'] = ...
        JIS_B9: _py_ClassVar['PageAttributes.MediaType'] = ...
        JIS_B10: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C0: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C1: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C2: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C3: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C4: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C5: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C6: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C7: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C8: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C9: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C10: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_DESIGNATED_LONG: _py_ClassVar['PageAttributes.MediaType'] = ...
        EXECUTIVE: _py_ClassVar['PageAttributes.MediaType'] = ...
        FOLIO: _py_ClassVar['PageAttributes.MediaType'] = ...
        INVOICE: _py_ClassVar['PageAttributes.MediaType'] = ...
        LEDGER: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_LETTER: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_LEGAL: _py_ClassVar['PageAttributes.MediaType'] = ...
        QUARTO: _py_ClassVar['PageAttributes.MediaType'] = ...
        A: _py_ClassVar['PageAttributes.MediaType'] = ...
        B: _py_ClassVar['PageAttributes.MediaType'] = ...
        C: _py_ClassVar['PageAttributes.MediaType'] = ...
        D: _py_ClassVar['PageAttributes.MediaType'] = ...
        E: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_10X15_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_10X14_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_10X13_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_9X12_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_9X11_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_7X9_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_6X9_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_NUMBER_9_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_NUMBER_10_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_NUMBER_11_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_NUMBER_12_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        NA_NUMBER_14_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        INVITE_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        ITALY_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        MONARCH_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        PERSONAL_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        A0: _py_ClassVar['PageAttributes.MediaType'] = ...
        A1: _py_ClassVar['PageAttributes.MediaType'] = ...
        A2: _py_ClassVar['PageAttributes.MediaType'] = ...
        A3: _py_ClassVar['PageAttributes.MediaType'] = ...
        A4: _py_ClassVar['PageAttributes.MediaType'] = ...
        A5: _py_ClassVar['PageAttributes.MediaType'] = ...
        A6: _py_ClassVar['PageAttributes.MediaType'] = ...
        A7: _py_ClassVar['PageAttributes.MediaType'] = ...
        A8: _py_ClassVar['PageAttributes.MediaType'] = ...
        A9: _py_ClassVar['PageAttributes.MediaType'] = ...
        A10: _py_ClassVar['PageAttributes.MediaType'] = ...
        B0: _py_ClassVar['PageAttributes.MediaType'] = ...
        B1: _py_ClassVar['PageAttributes.MediaType'] = ...
        B2: _py_ClassVar['PageAttributes.MediaType'] = ...
        B3: _py_ClassVar['PageAttributes.MediaType'] = ...
        B4: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B4_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        B5: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_B5_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        B6: _py_ClassVar['PageAttributes.MediaType'] = ...
        B7: _py_ClassVar['PageAttributes.MediaType'] = ...
        B8: _py_ClassVar['PageAttributes.MediaType'] = ...
        B9: _py_ClassVar['PageAttributes.MediaType'] = ...
        B10: _py_ClassVar['PageAttributes.MediaType'] = ...
        C0: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C0_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        C1: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C1_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        C2: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C2_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        C3: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C3_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        C4: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C4_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        C5: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C5_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        C6: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C6_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        C7: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C7_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        C8: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C8_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        C9: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C9_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        C10: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_C10_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        ISO_DESIGNATED_LONG_ENVELOPE: _py_ClassVar['PageAttributes.MediaType'] = ...
        STATEMENT: _py_ClassVar['PageAttributes.MediaType'] = ...
        TABLOID: _py_ClassVar['PageAttributes.MediaType'] = ...
        LETTER: _py_ClassVar['PageAttributes.MediaType'] = ...
        NOTE: _py_ClassVar['PageAttributes.MediaType'] = ...
        LEGAL: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_10X15: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_10X14: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_10X13: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_9X12: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_9X11: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_7X9: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_6X9: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_9: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_10: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_11: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_12: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_14: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_INVITE: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_ITALY: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_MONARCH: _py_ClassVar['PageAttributes.MediaType'] = ...
        ENV_PERSONAL: _py_ClassVar['PageAttributes.MediaType'] = ...
        INVITE: _py_ClassVar['PageAttributes.MediaType'] = ...
        ITALY: _py_ClassVar['PageAttributes.MediaType'] = ...
        MONARCH: _py_ClassVar['PageAttributes.MediaType'] = ...
        PERSONAL: _py_ClassVar['PageAttributes.MediaType'] = ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
    class OrientationRequestedType(AttributeValue):
        PORTRAIT: _py_ClassVar['PageAttributes.OrientationRequestedType'] = ...
        LANDSCAPE: _py_ClassVar['PageAttributes.OrientationRequestedType'] = ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
    class OriginType(AttributeValue):
        PHYSICAL: _py_ClassVar['PageAttributes.OriginType'] = ...
        PRINTABLE: _py_ClassVar['PageAttributes.OriginType'] = ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
    class PrintQualityType(AttributeValue):
        HIGH: _py_ClassVar['PageAttributes.PrintQualityType'] = ...
        NORMAL: _py_ClassVar['PageAttributes.PrintQualityType'] = ...
        DRAFT: _py_ClassVar['PageAttributes.PrintQualityType'] = ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...

class Paint(Transparency):
    def createContext(self, colorModel: java.awt.image.ColorModel, rectangle: 'Rectangle', rectangle2D: java.awt.geom.Rectangle2D, affineTransform: java.awt.geom.AffineTransform, renderingHints: RenderingHints) -> PaintContext: ...

class Polygon(Shape, java.io.Serializable):
    npoints: int = ...
    xpoints: _py_List[int] = ...
    ypoints: _py_List[int] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, intArray: _py_List[int], intArray2: _py_List[int], int3: int): ...
    def addPoint(self, int: int, int2: int) -> None: ...
    @overload
    def contains(self, double: float, double2: float) -> bool: ...
    @overload
    def contains(self, double: float, double2: float, double3: float, double4: float) -> bool: ...
    @overload
    def contains(self, int: int, int2: int) -> bool: ...
    @overload
    def contains(self, point: Point) -> bool: ...
    @overload
    def contains(self, point2D: java.awt.geom.Point2D) -> bool: ...
    @overload
    def contains(self, rectangle2D: java.awt.geom.Rectangle2D) -> bool: ...
    def getBoundingBox(self) -> 'Rectangle': ...
    def getBounds(self) -> 'Rectangle': ...
    def getBounds2D(self) -> java.awt.geom.Rectangle2D: ...
    @overload
    def getPathIterator(self, affineTransform: java.awt.geom.AffineTransform) -> java.awt.geom.PathIterator: ...
    @overload
    def getPathIterator(self, affineTransform: java.awt.geom.AffineTransform, double: float) -> java.awt.geom.PathIterator: ...
    def inside(self, int: int, int2: int) -> bool: ...
    @overload
    def intersects(self, double: float, double2: float, double3: float, double4: float) -> bool: ...
    @overload
    def intersects(self, rectangle2D: java.awt.geom.Rectangle2D) -> bool: ...
    def invalidate(self) -> None: ...
    def reset(self) -> None: ...
    def translate(self, int: int, int2: int) -> None: ...

class Rectangle(java.awt.geom.Rectangle2D, Shape, java.io.Serializable):
    x: int = ...
    y: int = ...
    width: int = ...
    height: int = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    @overload
    def __init__(self, dimension: Dimension): ...
    @overload
    def __init__(self, point: Point): ...
    @overload
    def __init__(self, point: Point, dimension: Dimension): ...
    @overload
    def __init__(self, rectangle: 'Rectangle'): ...
    @overload
    def add(self, int: int, int2: int) -> None: ...
    @overload
    def add(self, point: Point) -> None: ...
    @overload
    def add(self, rectangle: 'Rectangle') -> None: ...
    @overload
    def add(self, double: float, double2: float) -> None: ...
    @overload
    def add(self, point2D: java.awt.geom.Point2D) -> None: ...
    @overload
    def add(self, rectangle2D: java.awt.geom.Rectangle2D) -> None: ...
    @overload
    def contains(self, int: int, int2: int) -> bool: ...
    @overload
    def contains(self, int: int, int2: int, int3: int, int4: int) -> bool: ...
    @overload
    def contains(self, point: Point) -> bool: ...
    @overload
    def contains(self, rectangle: 'Rectangle') -> bool: ...
    @overload
    def contains(self, double: float, double2: float) -> bool: ...
    @overload
    def contains(self, double: float, double2: float, double3: float, double4: float) -> bool: ...
    @overload
    def contains(self, point2D: java.awt.geom.Point2D) -> bool: ...
    @overload
    def contains(self, rectangle2D: java.awt.geom.Rectangle2D) -> bool: ...
    def createIntersection(self, rectangle2D: java.awt.geom.Rectangle2D) -> java.awt.geom.Rectangle2D: ...
    def createUnion(self, rectangle2D: java.awt.geom.Rectangle2D) -> java.awt.geom.Rectangle2D: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getBounds(self) -> 'Rectangle': ...
    def getBounds2D(self) -> java.awt.geom.Rectangle2D: ...
    def getHeight(self) -> float: ...
    def getLocation(self) -> Point: ...
    def getSize(self) -> Dimension: ...
    def getWidth(self) -> float: ...
    def getX(self) -> float: ...
    def getY(self) -> float: ...
    def grow(self, int: int, int2: int) -> None: ...
    def inside(self, int: int, int2: int) -> bool: ...
    def intersection(self, rectangle: 'Rectangle') -> 'Rectangle': ...
    @overload
    def intersects(self, rectangle: 'Rectangle') -> bool: ...
    @overload
    def intersects(self, double: float, double2: float, double3: float, double4: float) -> bool: ...
    @overload
    def intersects(self, rectangle2D: java.awt.geom.Rectangle2D) -> bool: ...
    def isEmpty(self) -> bool: ...
    def move(self, int: int, int2: int) -> None: ...
    @overload
    def outcode(self, double: float, double2: float) -> int: ...
    @overload
    def outcode(self, point2D: java.awt.geom.Point2D) -> int: ...
    def reshape(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def resize(self, int: int, int2: int) -> None: ...
    @overload
    def setBounds(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @overload
    def setBounds(self, rectangle: 'Rectangle') -> None: ...
    @overload
    def setLocation(self, int: int, int2: int) -> None: ...
    @overload
    def setLocation(self, point: Point) -> None: ...
    @overload
    def setRect(self, double: float, double2: float, double3: float, double4: float) -> None: ...
    @overload
    def setRect(self, rectangle2D: java.awt.geom.Rectangle2D) -> None: ...
    @overload
    def setSize(self, int: int, int2: int) -> None: ...
    @overload
    def setSize(self, dimension: Dimension) -> None: ...
    def toString(self) -> str: ...
    def translate(self, int: int, int2: int) -> None: ...
    @overload
    def union(self, rectangle: 'Rectangle') -> 'Rectangle': ...
    @classmethod
    @overload
    def union(cls, rectangle2D: java.awt.geom.Rectangle2D, rectangle2D2: java.awt.geom.Rectangle2D, rectangle2D3: java.awt.geom.Rectangle2D) -> None: ...

class ScrollPaneAdjustable(Adjustable, java.io.Serializable):
    def addAdjustmentListener(self, adjustmentListener: java.awt.event.AdjustmentListener) -> None: ...
    def getAdjustmentListeners(self) -> _py_List[java.awt.event.AdjustmentListener]: ...
    def getBlockIncrement(self) -> int: ...
    def getMaximum(self) -> int: ...
    def getMinimum(self) -> int: ...
    def getOrientation(self) -> int: ...
    def getUnitIncrement(self) -> int: ...
    def getValue(self) -> int: ...
    def getValueIsAdjusting(self) -> bool: ...
    def getVisibleAmount(self) -> int: ...
    def paramString(self) -> str: ...
    def removeAdjustmentListener(self, adjustmentListener: java.awt.event.AdjustmentListener) -> None: ...
    def setBlockIncrement(self, int: int) -> None: ...
    def setMaximum(self, int: int) -> None: ...
    def setMinimum(self, int: int) -> None: ...
    def setUnitIncrement(self, int: int) -> None: ...
    def setValue(self, int: int) -> None: ...
    def setValueIsAdjusting(self, boolean: bool) -> None: ...
    def setVisibleAmount(self, int: int) -> None: ...
    def toString(self) -> str: ...

class SentEvent(AWTEvent, ActiveEvent):
    def dispatch(self) -> None: ...

class SequencedEvent(AWTEvent, ActiveEvent):
    def __init__(self, aWTEvent: AWTEvent): ...
    def dispatch(self) -> None: ...
    def isFirstOrDisposed(self) -> bool: ...

class TexturePaintContext(PaintContext):
    xrgbmodel: _py_ClassVar[java.awt.image.ColorModel] = ...
    argbmodel: _py_ClassVar[java.awt.image.ColorModel] = ...
    @classmethod
    def blend(cls, intArray: _py_List[int], int2: int, int3: int) -> int: ...
    def dispose(self) -> None: ...
    def getColorModel(self) -> java.awt.image.ColorModel: ...
    @classmethod
    def getContext(cls, bufferedImage: java.awt.image.BufferedImage, affineTransform: java.awt.geom.AffineTransform, renderingHints: RenderingHints, rectangle: Rectangle) -> PaintContext: ...
    @classmethod
    def getInternedColorModel(cls, colorModel: java.awt.image.ColorModel) -> java.awt.image.ColorModel: ...
    def getRaster(self, int: int, int2: int, int3: int, int4: int) -> java.awt.image.Raster: ...
    @classmethod
    def isFilterableDCM(cls, colorModel: java.awt.image.ColorModel) -> bool: ...
    @classmethod
    def isFilterableICM(cls, colorModel: java.awt.image.ColorModel) -> bool: ...
    @classmethod
    def isMaskOK(cls, int: int, boolean: bool) -> bool: ...
    def makeRaster(self, int: int, int2: int) -> java.awt.image.WritableRaster: ...
    def setRaster(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, int8: int, int9: int, int10: int, int11: int, int12: int, int13: int, int14: int, int15: int, int16: int) -> None: ...

class WaitDispatchSupport(SecondaryLoop):
    @overload
    def __init__(self, eventDispatchThread: EventDispatchThread): ...
    @overload
    def __init__(self, eventDispatchThread: EventDispatchThread, conditional: Conditional): ...
    @overload
    def __init__(self, eventDispatchThread: EventDispatchThread, conditional: Conditional, eventFilter: EventFilter, long: int): ...
    def enter(self) -> bool: ...
    def exit(self) -> bool: ...

class BorderLayout(LayoutManager2, java.io.Serializable):
    NORTH: _py_ClassVar[str] = ...
    SOUTH: _py_ClassVar[str] = ...
    EAST: _py_ClassVar[str] = ...
    WEST: _py_ClassVar[str] = ...
    CENTER: _py_ClassVar[str] = ...
    BEFORE_FIRST_LINE: _py_ClassVar[str] = ...
    AFTER_LAST_LINE: _py_ClassVar[str] = ...
    BEFORE_LINE_BEGINS: _py_ClassVar[str] = ...
    AFTER_LINE_ENDS: _py_ClassVar[str] = ...
    PAGE_START: _py_ClassVar[str] = ...
    PAGE_END: _py_ClassVar[str] = ...
    LINE_START: _py_ClassVar[str] = ...
    LINE_END: _py_ClassVar[str] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    @overload
    def addLayoutComponent(self, component: Component, object: _py_Any) -> None: ...
    @overload
    def addLayoutComponent(self, string: str, component: Component) -> None: ...
    def getConstraints(self, component: Component) -> _py_Any: ...
    def getHgap(self) -> int: ...
    def getLayoutAlignmentX(self, container: 'Container') -> float: ...
    def getLayoutAlignmentY(self, container: 'Container') -> float: ...
    @overload
    def getLayoutComponent(self, container: 'Container', object: _py_Any) -> Component: ...
    @overload
    def getLayoutComponent(self, object: _py_Any) -> Component: ...
    def getVgap(self) -> int: ...
    def invalidateLayout(self, container: 'Container') -> None: ...
    def layoutContainer(self, container: 'Container') -> None: ...
    def maximumLayoutSize(self, container: 'Container') -> Dimension: ...
    def minimumLayoutSize(self, container: 'Container') -> Dimension: ...
    def preferredLayoutSize(self, container: 'Container') -> Dimension: ...
    def removeLayoutComponent(self, component: Component) -> None: ...
    def setHgap(self, int: int) -> None: ...
    def setVgap(self, int: int) -> None: ...
    def toString(self) -> str: ...

class Button(Component, javax.accessibility.Accessible):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    def addActionListener(self, actionListener: java.awt.event.ActionListener) -> None: ...
    def addNotify(self) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getActionCommand(self) -> str: ...
    def getActionListeners(self) -> _py_List[java.awt.event.ActionListener]: ...
    def getLabel(self) -> str: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    def removeActionListener(self, actionListener: java.awt.event.ActionListener) -> None: ...
    def setActionCommand(self, string: str) -> None: ...
    def setLabel(self, string: str) -> None: ...

class Canvas(Component, javax.accessibility.Accessible):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, graphicsConfiguration: GraphicsConfiguration): ...
    def addNotify(self) -> None: ...
    @overload
    def createBufferStrategy(self, int: int) -> None: ...
    @overload
    def createBufferStrategy(self, int: int, bufferCapabilities: BufferCapabilities) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getBufferStrategy(self) -> java.awt.image.BufferStrategy: ...
    def paint(self, graphics: Graphics) -> None: ...
    def update(self, graphics: Graphics) -> None: ...

class CardLayout(LayoutManager2, java.io.Serializable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    @overload
    def addLayoutComponent(self, component: Component, object: _py_Any) -> None: ...
    @overload
    def addLayoutComponent(self, string: str, component: Component) -> None: ...
    def first(self, container: 'Container') -> None: ...
    def getHgap(self) -> int: ...
    def getLayoutAlignmentX(self, container: 'Container') -> float: ...
    def getLayoutAlignmentY(self, container: 'Container') -> float: ...
    def getVgap(self) -> int: ...
    def invalidateLayout(self, container: 'Container') -> None: ...
    def last(self, container: 'Container') -> None: ...
    def layoutContainer(self, container: 'Container') -> None: ...
    def maximumLayoutSize(self, container: 'Container') -> Dimension: ...
    def minimumLayoutSize(self, container: 'Container') -> Dimension: ...
    def next(self, container: 'Container') -> None: ...
    def preferredLayoutSize(self, container: 'Container') -> Dimension: ...
    def previous(self, container: 'Container') -> None: ...
    def removeLayoutComponent(self, component: Component) -> None: ...
    def setHgap(self, int: int) -> None: ...
    def setVgap(self, int: int) -> None: ...
    def show(self, container: 'Container', string: str) -> None: ...
    def toString(self) -> str: ...

class Checkbox(Component, ItemSelectable, javax.accessibility.Accessible):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, boolean: bool): ...
    @overload
    def __init__(self, string: str, boolean: bool, checkboxGroup: CheckboxGroup): ...
    @overload
    def __init__(self, string: str, checkboxGroup: CheckboxGroup, boolean: bool): ...
    def addItemListener(self, itemListener: java.awt.event.ItemListener) -> None: ...
    def addNotify(self) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getCheckboxGroup(self) -> CheckboxGroup: ...
    def getItemListeners(self) -> _py_List[java.awt.event.ItemListener]: ...
    def getLabel(self) -> str: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    def getSelectedObjects(self) -> _py_List[_py_Any]: ...
    def getState(self) -> bool: ...
    def removeItemListener(self, itemListener: java.awt.event.ItemListener) -> None: ...
    def setCheckboxGroup(self, checkboxGroup: CheckboxGroup) -> None: ...
    def setLabel(self, string: str) -> None: ...
    def setState(self, boolean: bool) -> None: ...

class CheckboxMenuItem(MenuItem, ItemSelectable, javax.accessibility.Accessible):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, boolean: bool): ...
    def addItemListener(self, itemListener: java.awt.event.ItemListener) -> None: ...
    def addNotify(self) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getItemListeners(self) -> _py_List[java.awt.event.ItemListener]: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    def getSelectedObjects(self) -> _py_List[_py_Any]: ...
    def getState(self) -> bool: ...
    def paramString(self) -> str: ...
    def removeItemListener(self, itemListener: java.awt.event.ItemListener) -> None: ...
    def setState(self, boolean: bool) -> None: ...

class Choice(Component, ItemSelectable, javax.accessibility.Accessible):
    def __init__(self): ...
    @overload
    def add(self, string: str) -> None: ...
    @overload
    def add(self, popupMenu: 'PopupMenu') -> None: ...
    def addItem(self, string: str) -> None: ...
    def addItemListener(self, itemListener: java.awt.event.ItemListener) -> None: ...
    def addNotify(self) -> None: ...
    def countItems(self) -> int: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getItem(self, int: int) -> str: ...
    def getItemCount(self) -> int: ...
    def getItemListeners(self) -> _py_List[java.awt.event.ItemListener]: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    def getSelectedIndex(self) -> int: ...
    def getSelectedItem(self) -> str: ...
    def getSelectedObjects(self) -> _py_List[_py_Any]: ...
    def insert(self, string: str, int: int) -> None: ...
    @overload
    def remove(self, int: int) -> None: ...
    @overload
    def remove(self, string: str) -> None: ...
    @overload
    def remove(self, menuComponent: MenuComponent) -> None: ...
    def removeAll(self) -> None: ...
    def removeItemListener(self, itemListener: java.awt.event.ItemListener) -> None: ...
    @overload
    def select(self, int: int) -> None: ...
    @overload
    def select(self, string: str) -> None: ...

class Color(Paint, java.io.Serializable):
    white: _py_ClassVar['Color'] = ...
    WHITE: _py_ClassVar['Color'] = ...
    lightGray: _py_ClassVar['Color'] = ...
    LIGHT_GRAY: _py_ClassVar['Color'] = ...
    gray: _py_ClassVar['Color'] = ...
    GRAY: _py_ClassVar['Color'] = ...
    darkGray: _py_ClassVar['Color'] = ...
    DARK_GRAY: _py_ClassVar['Color'] = ...
    black: _py_ClassVar['Color'] = ...
    BLACK: _py_ClassVar['Color'] = ...
    red: _py_ClassVar['Color'] = ...
    RED: _py_ClassVar['Color'] = ...
    pink: _py_ClassVar['Color'] = ...
    PINK: _py_ClassVar['Color'] = ...
    orange: _py_ClassVar['Color'] = ...
    ORANGE: _py_ClassVar['Color'] = ...
    yellow: _py_ClassVar['Color'] = ...
    YELLOW: _py_ClassVar['Color'] = ...
    green: _py_ClassVar['Color'] = ...
    GREEN: _py_ClassVar['Color'] = ...
    magenta: _py_ClassVar['Color'] = ...
    MAGENTA: _py_ClassVar['Color'] = ...
    cyan: _py_ClassVar['Color'] = ...
    CYAN: _py_ClassVar['Color'] = ...
    blue: _py_ClassVar['Color'] = ...
    BLUE: _py_ClassVar['Color'] = ...
    @overload
    def __init__(self, float: float, float2: float, float3: float): ...
    @overload
    def __init__(self, float: float, float2: float, float3: float, float4: float): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, boolean: bool): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int): ...
    @overload
    def __init__(self, colorSpace: java.awt.color.ColorSpace, floatArray: _py_List[float], float2: float): ...
    @classmethod
    def HSBtoRGB(cls, float: float, float2: float, float3: float) -> int: ...
    @classmethod
    def RGBtoHSB(cls, int: int, int2: int, int3: int, floatArray: _py_List[float]) -> _py_List[float]: ...
    def brighter(self) -> 'Color': ...
    def createContext(self, colorModel: java.awt.image.ColorModel, rectangle: Rectangle, rectangle2D: java.awt.geom.Rectangle2D, affineTransform: java.awt.geom.AffineTransform, renderingHints: RenderingHints) -> PaintContext: ...
    def darker(self) -> 'Color': ...
    @classmethod
    def decode(cls, string: str) -> 'Color': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAlpha(self) -> int: ...
    def getBlue(self) -> int: ...
    @classmethod
    @overload
    def getColor(cls, string: str) -> 'Color': ...
    @classmethod
    @overload
    def getColor(cls, string: str, int: int) -> 'Color': ...
    @classmethod
    @overload
    def getColor(cls, string: str, color: 'Color') -> 'Color': ...
    @overload
    def getColorComponents(self, floatArray: _py_List[float]) -> _py_List[float]: ...
    @overload
    def getColorComponents(self, colorSpace: java.awt.color.ColorSpace, floatArray: _py_List[float]) -> _py_List[float]: ...
    def getColorSpace(self) -> java.awt.color.ColorSpace: ...
    @overload
    def getComponents(self, floatArray: _py_List[float]) -> _py_List[float]: ...
    @overload
    def getComponents(self, colorSpace: java.awt.color.ColorSpace, floatArray: _py_List[float]) -> _py_List[float]: ...
    def getGreen(self) -> int: ...
    @classmethod
    def getHSBColor(cls, float: float, float2: float, float3: float) -> 'Color': ...
    def getRGB(self) -> int: ...
    def getRGBColorComponents(self, floatArray: _py_List[float]) -> _py_List[float]: ...
    def getRGBComponents(self, floatArray: _py_List[float]) -> _py_List[float]: ...
    def getRed(self) -> int: ...
    def getTransparency(self) -> int: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class Container(Component):
    def __init__(self): ...
    @overload
    def add(self, component: Component) -> Component: ...
    @overload
    def add(self, component: Component, int: int) -> Component: ...
    @overload
    def add(self, string: str, component: Component) -> Component: ...
    @overload
    def add(self, popupMenu: 'PopupMenu') -> None: ...
    @overload
    def add(self, component: Component, object: _py_Any) -> None: ...
    @overload
    def add(self, component: Component, object: _py_Any, int: int) -> None: ...
    def addContainerListener(self, containerListener: java.awt.event.ContainerListener) -> None: ...
    def addNotify(self) -> None: ...
    @overload
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    @overload
    def addPropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def applyComponentOrientation(self, componentOrientation: ComponentOrientation) -> None: ...
    def areFocusTraversalKeysSet(self, int: int) -> bool: ...
    def countComponents(self) -> int: ...
    def deliverEvent(self, event: Event) -> None: ...
    def doLayout(self) -> None: ...
    @overload
    def findComponentAt(self, int: int, int2: int) -> Component: ...
    @overload
    def findComponentAt(self, point: Point) -> Component: ...
    def getAlignmentX(self) -> float: ...
    def getAlignmentY(self) -> float: ...
    def getComponent(self, int: int) -> Component: ...
    @overload
    def getComponentAt(self, int: int, int2: int) -> Component: ...
    @overload
    def getComponentAt(self, point: Point) -> Component: ...
    def getComponentCount(self) -> int: ...
    def getComponentZOrder(self, component: Component) -> int: ...
    def getComponents(self) -> _py_List[Component]: ...
    def getContainerListeners(self) -> _py_List[java.awt.event.ContainerListener]: ...
    def getFocusTraversalKeys(self, int: int) -> java.util.Set[AWTKeyStroke]: ...
    def getFocusTraversalPolicy(self) -> FocusTraversalPolicy: ...
    def getInsets(self) -> Insets: ...
    def getLayout(self) -> LayoutManager: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    def getMaximumSize(self) -> Dimension: ...
    def getMinimumSize(self) -> Dimension: ...
    @overload
    def getMousePosition(self) -> Point: ...
    @overload
    def getMousePosition(self, boolean: bool) -> Point: ...
    def getPreferredSize(self) -> Dimension: ...
    def insets(self) -> Insets: ...
    def invalidate(self) -> None: ...
    def isAncestorOf(self, component: Component) -> bool: ...
    @overload
    def isFocusCycleRoot(self) -> bool: ...
    @overload
    def isFocusCycleRoot(self, container: 'Container') -> bool: ...
    def isFocusTraversalPolicyProvider(self) -> bool: ...
    def isFocusTraversalPolicySet(self) -> bool: ...
    def isValidateRoot(self) -> bool: ...
    def layout(self) -> None: ...
    @overload
    def list(self) -> None: ...
    @overload
    def list(self, printStream: java.io.PrintStream) -> None: ...
    @overload
    def list(self, printWriter: java.io.PrintWriter) -> None: ...
    @overload
    def list(self, printStream: java.io.PrintStream, int: int) -> None: ...
    @overload
    def list(self, printWriter: java.io.PrintWriter, int: int) -> None: ...
    def locate(self, int: int, int2: int) -> Component: ...
    def minimumSize(self) -> Dimension: ...
    def paint(self, graphics: Graphics) -> None: ...
    def paintComponents(self, graphics: Graphics) -> None: ...
    def preferredSize(self) -> Dimension: ...
    def printComponents(self, graphics: Graphics) -> None: ...
    @overload
    def remove(self, menuComponent: MenuComponent) -> None: ...
    @overload
    def remove(self, int: int) -> None: ...
    @overload
    def remove(self, component: Component) -> None: ...
    def removeAll(self) -> None: ...
    def removeContainerListener(self, containerListener: java.awt.event.ContainerListener) -> None: ...
    def removeNotify(self) -> None: ...
    def setComponentZOrder(self, component: Component, int: int) -> None: ...
    def setFocusCycleRoot(self, boolean: bool) -> None: ...
    def setFocusTraversalKeys(self, int: int, set: java.util.Set[AWTKeyStroke]) -> None: ...
    def setFocusTraversalPolicy(self, focusTraversalPolicy: FocusTraversalPolicy) -> None: ...
    def setFocusTraversalPolicyProvider(self, boolean: bool) -> None: ...
    def setFont(self, font: Font) -> None: ...
    def setLayout(self, layoutManager: LayoutManager) -> None: ...
    def transferFocusDownCycle(self) -> None: ...
    def update(self, graphics: Graphics) -> None: ...
    def validate(self) -> None: ...

class DefaultFocusTraversalPolicy(ContainerOrderFocusTraversalPolicy):
    def __init__(self): ...

class DefaultKeyboardFocusManager(KeyboardFocusManager):
    def __init__(self): ...
    def dispatchEvent(self, aWTEvent: AWTEvent) -> bool: ...
    def dispatchKeyEvent(self, keyEvent: java.awt.event.KeyEvent) -> bool: ...
    @overload
    def downFocusCycle(self) -> None: ...
    @overload
    def downFocusCycle(self, container: Container) -> None: ...
    @overload
    def focusNextComponent(self) -> None: ...
    @overload
    def focusNextComponent(self, component: Component) -> None: ...
    @overload
    def focusPreviousComponent(self) -> None: ...
    @overload
    def focusPreviousComponent(self, component: Component) -> None: ...
    def postProcessKeyEvent(self, keyEvent: java.awt.event.KeyEvent) -> bool: ...
    def processKeyEvent(self, component: Component, keyEvent: java.awt.event.KeyEvent) -> None: ...
    @overload
    def upFocusCycle(self) -> None: ...
    @overload
    def upFocusCycle(self, component: Component) -> None: ...

class GradientPaint(Paint):
    @overload
    def __init__(self, float: float, float2: float, color: Color, float3: float, float4: float, color2: Color): ...
    @overload
    def __init__(self, float: float, float2: float, color: Color, float3: float, float4: float, color2: Color, boolean: bool): ...
    @overload
    def __init__(self, point2D: java.awt.geom.Point2D, color: Color, point2D2: java.awt.geom.Point2D, color2: Color): ...
    @overload
    def __init__(self, point2D: java.awt.geom.Point2D, color: Color, point2D2: java.awt.geom.Point2D, color2: Color, boolean: bool): ...
    def createContext(self, colorModel: java.awt.image.ColorModel, rectangle: Rectangle, rectangle2D: java.awt.geom.Rectangle2D, affineTransform: java.awt.geom.AffineTransform, renderingHints: RenderingHints) -> PaintContext: ...
    def getColor1(self) -> Color: ...
    def getColor2(self) -> Color: ...
    def getPoint1(self) -> java.awt.geom.Point2D: ...
    def getPoint2(self) -> java.awt.geom.Point2D: ...
    def getTransparency(self) -> int: ...
    def isCyclic(self) -> bool: ...

class GridBagLayout(LayoutManager2, java.io.Serializable):
    columnWidths: _py_List[int] = ...
    rowHeights: _py_List[int] = ...
    columnWeights: _py_List[float] = ...
    rowWeights: _py_List[float] = ...
    def __init__(self): ...
    @overload
    def addLayoutComponent(self, component: Component, object: _py_Any) -> None: ...
    @overload
    def addLayoutComponent(self, string: str, component: Component) -> None: ...
    def getConstraints(self, component: Component) -> GridBagConstraints: ...
    def getLayoutAlignmentX(self, container: Container) -> float: ...
    def getLayoutAlignmentY(self, container: Container) -> float: ...
    def getLayoutDimensions(self) -> _py_List[_py_List[int]]: ...
    def getLayoutOrigin(self) -> Point: ...
    def getLayoutWeights(self) -> _py_List[_py_List[float]]: ...
    def invalidateLayout(self, container: Container) -> None: ...
    def layoutContainer(self, container: Container) -> None: ...
    def location(self, int: int, int2: int) -> Point: ...
    def maximumLayoutSize(self, container: Container) -> Dimension: ...
    def minimumLayoutSize(self, container: Container) -> Dimension: ...
    def preferredLayoutSize(self, container: Container) -> Dimension: ...
    def removeLayoutComponent(self, component: Component) -> None: ...
    def setConstraints(self, component: Component, gridBagConstraints: GridBagConstraints) -> None: ...
    def toString(self) -> str: ...

class Label(Component, javax.accessibility.Accessible):
    LEFT: _py_ClassVar[int] = ...
    CENTER: _py_ClassVar[int] = ...
    RIGHT: _py_ClassVar[int] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, int: int): ...
    def addNotify(self) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getAlignment(self) -> int: ...
    def getText(self) -> str: ...
    def setAlignment(self, int: int) -> None: ...
    def setText(self, string: str) -> None: ...

class LinearGradientPaintContext(MultipleGradientPaintContext): ...

class List(Component, ItemSelectable, javax.accessibility.Accessible):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, boolean: bool): ...
    @overload
    def add(self, popupMenu: 'PopupMenu') -> None: ...
    @overload
    def add(self, string: str) -> None: ...
    @overload
    def add(self, string: str, int: int) -> None: ...
    def addActionListener(self, actionListener: java.awt.event.ActionListener) -> None: ...
    @overload
    def addItem(self, string: str, int: int) -> None: ...
    @overload
    def addItem(self, string: str) -> None: ...
    def addItemListener(self, itemListener: java.awt.event.ItemListener) -> None: ...
    def addNotify(self) -> None: ...
    def allowsMultipleSelections(self) -> bool: ...
    def clear(self) -> None: ...
    def countItems(self) -> int: ...
    def delItem(self, int: int) -> None: ...
    def delItems(self, int: int, int2: int) -> None: ...
    def deselect(self, int: int) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getActionListeners(self) -> _py_List[java.awt.event.ActionListener]: ...
    def getItem(self, int: int) -> str: ...
    def getItemCount(self) -> int: ...
    def getItemListeners(self) -> _py_List[java.awt.event.ItemListener]: ...
    def getItems(self) -> _py_List[str]: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    @overload
    def getMinimumSize(self) -> Dimension: ...
    @overload
    def getMinimumSize(self, int: int) -> Dimension: ...
    @overload
    def getPreferredSize(self) -> Dimension: ...
    @overload
    def getPreferredSize(self, int: int) -> Dimension: ...
    def getRows(self) -> int: ...
    def getSelectedIndex(self) -> int: ...
    def getSelectedIndexes(self) -> _py_List[int]: ...
    def getSelectedItem(self) -> str: ...
    def getSelectedItems(self) -> _py_List[str]: ...
    def getSelectedObjects(self) -> _py_List[_py_Any]: ...
    def getVisibleIndex(self) -> int: ...
    def isIndexSelected(self, int: int) -> bool: ...
    def isMultipleMode(self) -> bool: ...
    def isSelected(self, int: int) -> bool: ...
    def makeVisible(self, int: int) -> None: ...
    @overload
    def minimumSize(self) -> Dimension: ...
    @overload
    def minimumSize(self, int: int) -> Dimension: ...
    @overload
    def preferredSize(self) -> Dimension: ...
    @overload
    def preferredSize(self, int: int) -> Dimension: ...
    @overload
    def remove(self, string: str) -> None: ...
    @overload
    def remove(self, menuComponent: MenuComponent) -> None: ...
    @overload
    def remove(self, int: int) -> None: ...
    def removeActionListener(self, actionListener: java.awt.event.ActionListener) -> None: ...
    def removeAll(self) -> None: ...
    def removeItemListener(self, itemListener: java.awt.event.ItemListener) -> None: ...
    def removeNotify(self) -> None: ...
    def replaceItem(self, string: str, int: int) -> None: ...
    def select(self, int: int) -> None: ...
    def setMultipleMode(self, boolean: bool) -> None: ...
    def setMultipleSelections(self, boolean: bool) -> None: ...

class Menu(MenuItem, MenuContainer, javax.accessibility.Accessible):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, boolean: bool): ...
    @overload
    def add(self, menuItem: MenuItem) -> MenuItem: ...
    @overload
    def add(self, string: str) -> None: ...
    def addNotify(self) -> None: ...
    def addSeparator(self) -> None: ...
    def countItems(self) -> int: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getItem(self, int: int) -> MenuItem: ...
    def getItemCount(self) -> int: ...
    @overload
    def insert(self, menuItem: MenuItem, int: int) -> None: ...
    @overload
    def insert(self, string: str, int: int) -> None: ...
    def insertSeparator(self, int: int) -> None: ...
    def isTearOff(self) -> bool: ...
    def paramString(self) -> str: ...
    @overload
    def remove(self, int: int) -> None: ...
    @overload
    def remove(self, menuComponent: MenuComponent) -> None: ...
    def removeAll(self) -> None: ...
    def removeNotify(self) -> None: ...

class MultipleGradientPaint(Paint):
    def getColorSpace(self) -> 'MultipleGradientPaint.ColorSpaceType': ...
    def getColors(self) -> _py_List[Color]: ...
    def getCycleMethod(self) -> 'MultipleGradientPaint.CycleMethod': ...
    def getFractions(self) -> _py_List[float]: ...
    def getTransform(self) -> java.awt.geom.AffineTransform: ...
    def getTransparency(self) -> int: ...
    class ColorSpaceType(java.lang.Enum['MultipleGradientPaint.ColorSpaceType']):
        SRGB: _py_ClassVar['MultipleGradientPaint.ColorSpaceType'] = ...
        LINEAR_RGB: _py_ClassVar['MultipleGradientPaint.ColorSpaceType'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'MultipleGradientPaint.ColorSpaceType': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['MultipleGradientPaint.ColorSpaceType']: ...
    class CycleMethod(java.lang.Enum['MultipleGradientPaint.CycleMethod']):
        NO_CYCLE: _py_ClassVar['MultipleGradientPaint.CycleMethod'] = ...
        REFLECT: _py_ClassVar['MultipleGradientPaint.CycleMethod'] = ...
        REPEAT: _py_ClassVar['MultipleGradientPaint.CycleMethod'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'MultipleGradientPaint.CycleMethod': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['MultipleGradientPaint.CycleMethod']: ...

class RadialGradientPaintContext(MultipleGradientPaintContext): ...

class Scrollbar(Component, Adjustable, javax.accessibility.Accessible):
    HORIZONTAL: _py_ClassVar[int] = ...
    VERTICAL: _py_ClassVar[int] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, int2: int, int3: int, int4: int, int5: int): ...
    def addAdjustmentListener(self, adjustmentListener: java.awt.event.AdjustmentListener) -> None: ...
    def addNotify(self) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getAdjustmentListeners(self) -> _py_List[java.awt.event.AdjustmentListener]: ...
    def getBlockIncrement(self) -> int: ...
    def getLineIncrement(self) -> int: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    def getMaximum(self) -> int: ...
    def getMinimum(self) -> int: ...
    def getOrientation(self) -> int: ...
    def getPageIncrement(self) -> int: ...
    def getUnitIncrement(self) -> int: ...
    def getValue(self) -> int: ...
    def getValueIsAdjusting(self) -> bool: ...
    def getVisible(self) -> int: ...
    def getVisibleAmount(self) -> int: ...
    def removeAdjustmentListener(self, adjustmentListener: java.awt.event.AdjustmentListener) -> None: ...
    def setBlockIncrement(self, int: int) -> None: ...
    def setLineIncrement(self, int: int) -> None: ...
    def setMaximum(self, int: int) -> None: ...
    def setMinimum(self, int: int) -> None: ...
    def setOrientation(self, int: int) -> None: ...
    def setPageIncrement(self, int: int) -> None: ...
    def setUnitIncrement(self, int: int) -> None: ...
    def setValue(self, int: int) -> None: ...
    def setValueIsAdjusting(self, boolean: bool) -> None: ...
    def setValues(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def setVisibleAmount(self, int: int) -> None: ...

class TextComponent(Component, javax.accessibility.Accessible):
    def addNotify(self) -> None: ...
    def addTextListener(self, textListener: java.awt.event.TextListener) -> None: ...
    def enableInputMethods(self, boolean: bool) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getBackground(self) -> Color: ...
    def getCaretPosition(self) -> int: ...
    def getInputMethodRequests(self) -> java.awt.im.InputMethodRequests: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    def getSelectedText(self) -> str: ...
    def getSelectionEnd(self) -> int: ...
    def getSelectionStart(self) -> int: ...
    def getText(self) -> str: ...
    def getTextListeners(self) -> _py_List[java.awt.event.TextListener]: ...
    def isEditable(self) -> bool: ...
    def removeNotify(self) -> None: ...
    def removeTextListener(self, textListener: java.awt.event.TextListener) -> None: ...
    def select(self, int: int, int2: int) -> None: ...
    def selectAll(self) -> None: ...
    def setBackground(self, color: Color) -> None: ...
    def setCaretPosition(self, int: int) -> None: ...
    def setEditable(self, boolean: bool) -> None: ...
    def setSelectionEnd(self, int: int) -> None: ...
    def setSelectionStart(self, int: int) -> None: ...
    def setText(self, string: str) -> None: ...

class TexturePaint(Paint):
    def __init__(self, bufferedImage: java.awt.image.BufferedImage, rectangle2D: java.awt.geom.Rectangle2D): ...
    def createContext(self, colorModel: java.awt.image.ColorModel, rectangle: Rectangle, rectangle2D: java.awt.geom.Rectangle2D, affineTransform: java.awt.geom.AffineTransform, renderingHints: RenderingHints) -> PaintContext: ...
    def getAnchorRect(self) -> java.awt.geom.Rectangle2D: ...
    def getImage(self) -> java.awt.image.BufferedImage: ...
    def getTransparency(self) -> int: ...

class LinearGradientPaint(MultipleGradientPaint):
    @overload
    def __init__(self, float: float, float2: float, float3: float, float4: float, floatArray: _py_List[float], colorArray: _py_List[Color]): ...
    @overload
    def __init__(self, float: float, float2: float, float3: float, float4: float, floatArray: _py_List[float], colorArray: _py_List[Color], cycleMethod: MultipleGradientPaint.CycleMethod): ...
    @overload
    def __init__(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D, floatArray: _py_List[float], colorArray: _py_List[Color]): ...
    @overload
    def __init__(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D, floatArray: _py_List[float], colorArray: _py_List[Color], cycleMethod: MultipleGradientPaint.CycleMethod): ...
    @overload
    def __init__(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D, floatArray: _py_List[float], colorArray: _py_List[Color], cycleMethod: MultipleGradientPaint.CycleMethod, colorSpaceType: MultipleGradientPaint.ColorSpaceType, affineTransform: java.awt.geom.AffineTransform): ...
    def createContext(self, colorModel: java.awt.image.ColorModel, rectangle: Rectangle, rectangle2D: java.awt.geom.Rectangle2D, affineTransform: java.awt.geom.AffineTransform, renderingHints: RenderingHints) -> PaintContext: ...
    def getEndPoint(self) -> java.awt.geom.Point2D: ...
    def getStartPoint(self) -> java.awt.geom.Point2D: ...

class Panel(Container, javax.accessibility.Accessible):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, layoutManager: LayoutManager): ...
    def addNotify(self) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...

class PopupMenu(Menu):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    def addNotify(self) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getParent(self) -> MenuContainer: ...
    def show(self, component: Component, int: int, int2: int) -> None: ...

class RadialGradientPaint(MultipleGradientPaint):
    @overload
    def __init__(self, float: float, float2: float, float3: float, float4: float, float5: float, floatArray: _py_List[float], colorArray: _py_List[Color], cycleMethod: MultipleGradientPaint.CycleMethod): ...
    @overload
    def __init__(self, float: float, float2: float, float3: float, floatArray: _py_List[float], colorArray: _py_List[Color]): ...
    @overload
    def __init__(self, float: float, float2: float, float3: float, floatArray: _py_List[float], colorArray: _py_List[Color], cycleMethod: MultipleGradientPaint.CycleMethod): ...
    @overload
    def __init__(self, point2D: java.awt.geom.Point2D, float: float, floatArray: _py_List[float], colorArray: _py_List[Color]): ...
    @overload
    def __init__(self, point2D: java.awt.geom.Point2D, float: float, floatArray: _py_List[float], colorArray: _py_List[Color], cycleMethod: MultipleGradientPaint.CycleMethod): ...
    @overload
    def __init__(self, point2D: java.awt.geom.Point2D, float: float, point2D2: java.awt.geom.Point2D, floatArray: _py_List[float], colorArray: _py_List[Color], cycleMethod: MultipleGradientPaint.CycleMethod): ...
    @overload
    def __init__(self, point2D: java.awt.geom.Point2D, float: float, point2D2: java.awt.geom.Point2D, floatArray: _py_List[float], colorArray: _py_List[Color], cycleMethod: MultipleGradientPaint.CycleMethod, colorSpaceType: MultipleGradientPaint.ColorSpaceType, affineTransform: java.awt.geom.AffineTransform): ...
    @overload
    def __init__(self, rectangle2D: java.awt.geom.Rectangle2D, floatArray: _py_List[float], colorArray: _py_List[Color], cycleMethod: MultipleGradientPaint.CycleMethod): ...
    def createContext(self, colorModel: java.awt.image.ColorModel, rectangle: Rectangle, rectangle2D: java.awt.geom.Rectangle2D, affineTransform: java.awt.geom.AffineTransform, renderingHints: RenderingHints) -> PaintContext: ...
    def getCenterPoint(self) -> java.awt.geom.Point2D: ...
    def getFocusPoint(self) -> java.awt.geom.Point2D: ...
    def getRadius(self) -> float: ...

class ScrollPane(Container, javax.accessibility.Accessible):
    SCROLLBARS_AS_NEEDED: _py_ClassVar[int] = ...
    SCROLLBARS_ALWAYS: _py_ClassVar[int] = ...
    SCROLLBARS_NEVER: _py_ClassVar[int] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    def addNotify(self) -> None: ...
    def doLayout(self) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getHAdjustable(self) -> Adjustable: ...
    def getHScrollbarHeight(self) -> int: ...
    def getScrollPosition(self) -> Point: ...
    def getScrollbarDisplayPolicy(self) -> int: ...
    def getVAdjustable(self) -> Adjustable: ...
    def getVScrollbarWidth(self) -> int: ...
    def getViewportSize(self) -> Dimension: ...
    def isWheelScrollingEnabled(self) -> bool: ...
    def layout(self) -> None: ...
    def paramString(self) -> str: ...
    def printComponents(self, graphics: Graphics) -> None: ...
    def setLayout(self, layoutManager: LayoutManager) -> None: ...
    @overload
    def setScrollPosition(self, int: int, int2: int) -> None: ...
    @overload
    def setScrollPosition(self, point: Point) -> None: ...
    def setWheelScrollingEnabled(self, boolean: bool) -> None: ...

class SystemColor(Color, java.io.Serializable):
    DESKTOP: _py_ClassVar[int] = ...
    ACTIVE_CAPTION: _py_ClassVar[int] = ...
    ACTIVE_CAPTION_TEXT: _py_ClassVar[int] = ...
    ACTIVE_CAPTION_BORDER: _py_ClassVar[int] = ...
    INACTIVE_CAPTION: _py_ClassVar[int] = ...
    INACTIVE_CAPTION_TEXT: _py_ClassVar[int] = ...
    INACTIVE_CAPTION_BORDER: _py_ClassVar[int] = ...
    WINDOW: _py_ClassVar[int] = ...
    WINDOW_BORDER: _py_ClassVar[int] = ...
    WINDOW_TEXT: _py_ClassVar[int] = ...
    MENU: _py_ClassVar[int] = ...
    MENU_TEXT: _py_ClassVar[int] = ...
    TEXT: _py_ClassVar[int] = ...
    TEXT_TEXT: _py_ClassVar[int] = ...
    TEXT_HIGHLIGHT: _py_ClassVar[int] = ...
    TEXT_HIGHLIGHT_TEXT: _py_ClassVar[int] = ...
    TEXT_INACTIVE_TEXT: _py_ClassVar[int] = ...
    CONTROL: _py_ClassVar[int] = ...
    CONTROL_TEXT: _py_ClassVar[int] = ...
    CONTROL_HIGHLIGHT: _py_ClassVar[int] = ...
    CONTROL_LT_HIGHLIGHT: _py_ClassVar[int] = ...
    CONTROL_SHADOW: _py_ClassVar[int] = ...
    CONTROL_DK_SHADOW: _py_ClassVar[int] = ...
    SCROLLBAR: _py_ClassVar[int] = ...
    INFO: _py_ClassVar[int] = ...
    INFO_TEXT: _py_ClassVar[int] = ...
    NUM_COLORS: _py_ClassVar[int] = ...
    desktop: _py_ClassVar['SystemColor'] = ...
    activeCaption: _py_ClassVar['SystemColor'] = ...
    activeCaptionText: _py_ClassVar['SystemColor'] = ...
    activeCaptionBorder: _py_ClassVar['SystemColor'] = ...
    inactiveCaption: _py_ClassVar['SystemColor'] = ...
    inactiveCaptionText: _py_ClassVar['SystemColor'] = ...
    inactiveCaptionBorder: _py_ClassVar['SystemColor'] = ...
    window: _py_ClassVar['SystemColor'] = ...
    windowBorder: _py_ClassVar['SystemColor'] = ...
    windowText: _py_ClassVar['SystemColor'] = ...
    menu: _py_ClassVar['SystemColor'] = ...
    menuText: _py_ClassVar['SystemColor'] = ...
    text: _py_ClassVar['SystemColor'] = ...
    textText: _py_ClassVar['SystemColor'] = ...
    textHighlight: _py_ClassVar['SystemColor'] = ...
    textHighlightText: _py_ClassVar['SystemColor'] = ...
    textInactiveText: _py_ClassVar['SystemColor'] = ...
    control: _py_ClassVar['SystemColor'] = ...
    controlText: _py_ClassVar['SystemColor'] = ...
    controlHighlight: _py_ClassVar['SystemColor'] = ...
    controlLtHighlight: _py_ClassVar['SystemColor'] = ...
    controlShadow: _py_ClassVar['SystemColor'] = ...
    controlDkShadow: _py_ClassVar['SystemColor'] = ...
    scrollbar: _py_ClassVar['SystemColor'] = ...
    info: _py_ClassVar['SystemColor'] = ...
    infoText: _py_ClassVar['SystemColor'] = ...
    def toString(self) -> str: ...

class TextArea(TextComponent):
    SCROLLBARS_BOTH: _py_ClassVar[int] = ...
    SCROLLBARS_VERTICAL_ONLY: _py_ClassVar[int] = ...
    SCROLLBARS_HORIZONTAL_ONLY: _py_ClassVar[int] = ...
    SCROLLBARS_NONE: _py_ClassVar[int] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int, int2: int): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, int: int, int2: int): ...
    @overload
    def __init__(self, string: str, int: int, int2: int, int3: int): ...
    def addNotify(self) -> None: ...
    def append(self, string: str) -> None: ...
    def appendText(self, string: str) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getColumns(self) -> int: ...
    @overload
    def getMinimumSize(self) -> Dimension: ...
    @overload
    def getMinimumSize(self, int: int, int2: int) -> Dimension: ...
    @overload
    def getPreferredSize(self) -> Dimension: ...
    @overload
    def getPreferredSize(self, int: int, int2: int) -> Dimension: ...
    def getRows(self) -> int: ...
    def getScrollbarVisibility(self) -> int: ...
    def insert(self, string: str, int: int) -> None: ...
    def insertText(self, string: str, int: int) -> None: ...
    @overload
    def minimumSize(self) -> Dimension: ...
    @overload
    def minimumSize(self, int: int, int2: int) -> Dimension: ...
    @overload
    def preferredSize(self) -> Dimension: ...
    @overload
    def preferredSize(self, int: int, int2: int) -> Dimension: ...
    def replaceRange(self, string: str, int: int, int2: int) -> None: ...
    def replaceText(self, string: str, int: int, int2: int) -> None: ...
    def setColumns(self, int: int) -> None: ...
    def setRows(self, int: int) -> None: ...

class TextField(TextComponent):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, int: int): ...
    def addActionListener(self, actionListener: java.awt.event.ActionListener) -> None: ...
    def addNotify(self) -> None: ...
    def echoCharIsSet(self) -> bool: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getActionListeners(self) -> _py_List[java.awt.event.ActionListener]: ...
    def getColumns(self) -> int: ...
    def getEchoChar(self) -> str: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    @overload
    def getMinimumSize(self) -> Dimension: ...
    @overload
    def getMinimumSize(self, int: int) -> Dimension: ...
    @overload
    def getPreferredSize(self) -> Dimension: ...
    @overload
    def getPreferredSize(self, int: int) -> Dimension: ...
    @overload
    def minimumSize(self) -> Dimension: ...
    @overload
    def minimumSize(self, int: int) -> Dimension: ...
    @overload
    def preferredSize(self) -> Dimension: ...
    @overload
    def preferredSize(self, int: int) -> Dimension: ...
    def removeActionListener(self, actionListener: java.awt.event.ActionListener) -> None: ...
    def setColumns(self, int: int) -> None: ...
    def setEchoChar(self, char: str) -> None: ...
    def setEchoCharacter(self, char: str) -> None: ...
    def setText(self, string: str) -> None: ...

class Window(Container, javax.accessibility.Accessible):
    @overload
    def __init__(self, frame: 'Frame'): ...
    @overload
    def __init__(self, window: 'Window'): ...
    @overload
    def __init__(self, window: 'Window', graphicsConfiguration: GraphicsConfiguration): ...
    def addNotify(self) -> None: ...
    @overload
    def addPropertyChangeListener(self, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    @overload
    def addPropertyChangeListener(self, string: str, propertyChangeListener: java.beans.PropertyChangeListener) -> None: ...
    def addWindowFocusListener(self, windowFocusListener: java.awt.event.WindowFocusListener) -> None: ...
    def addWindowListener(self, windowListener: java.awt.event.WindowListener) -> None: ...
    def addWindowStateListener(self, windowStateListener: java.awt.event.WindowStateListener) -> None: ...
    @overload
    def applyResourceBundle(self, string: str) -> None: ...
    @overload
    def applyResourceBundle(self, resourceBundle: java.util.ResourceBundle) -> None: ...
    @overload
    def createBufferStrategy(self, int: int) -> None: ...
    @overload
    def createBufferStrategy(self, int: int, bufferCapabilities: BufferCapabilities) -> None: ...
    def dispose(self) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getBackground(self) -> Color: ...
    def getBufferStrategy(self) -> java.awt.image.BufferStrategy: ...
    def getFocusCycleRootAncestor(self) -> Container: ...
    def getFocusOwner(self) -> Component: ...
    def getFocusTraversalKeys(self, int: int) -> java.util.Set[AWTKeyStroke]: ...
    def getFocusableWindowState(self) -> bool: ...
    def getIconImages(self) -> java.util.List[Image]: ...
    def getInputContext(self) -> java.awt.im.InputContext: ...
    _getListeners__T = _py_TypeVar('_getListeners__T', bound=java.util.EventListener)  # <T>
    def getListeners(self, class_: _py_Type[_getListeners__T]) -> _py_List[_getListeners__T]: ...
    def getLocale(self) -> java.util.Locale: ...
    def getModalExclusionType(self) -> 'Dialog.ModalExclusionType': ...
    def getMostRecentFocusOwner(self) -> Component: ...
    def getOpacity(self) -> float: ...
    def getOwnedWindows(self) -> _py_List['Window']: ...
    def getOwner(self) -> 'Window': ...
    @classmethod
    def getOwnerlessWindows(cls) -> _py_List['Window']: ...
    def getShape(self) -> Shape: ...
    def getToolkit(self) -> Toolkit: ...
    def getType(self) -> 'Window.Type': ...
    def getWarningString(self) -> str: ...
    def getWindowFocusListeners(self) -> _py_List[java.awt.event.WindowFocusListener]: ...
    def getWindowListeners(self) -> _py_List[java.awt.event.WindowListener]: ...
    def getWindowStateListeners(self) -> _py_List[java.awt.event.WindowStateListener]: ...
    @classmethod
    def getWindows(cls) -> _py_List['Window']: ...
    def hide(self) -> None: ...
    def isActive(self) -> bool: ...
    def isAlwaysOnTop(self) -> bool: ...
    def isAlwaysOnTopSupported(self) -> bool: ...
    def isAutoRequestFocus(self) -> bool: ...
    @overload
    def isFocusCycleRoot(self, container: Container) -> bool: ...
    @overload
    def isFocusCycleRoot(self) -> bool: ...
    def isFocusableWindow(self) -> bool: ...
    def isFocused(self) -> bool: ...
    def isLocationByPlatform(self) -> bool: ...
    def isOpaque(self) -> bool: ...
    def isShowing(self) -> bool: ...
    def isValidateRoot(self) -> bool: ...
    def pack(self) -> None: ...
    def paint(self, graphics: Graphics) -> None: ...
    def postEvent(self, event: Event) -> bool: ...
    def removeNotify(self) -> None: ...
    def removeWindowFocusListener(self, windowFocusListener: java.awt.event.WindowFocusListener) -> None: ...
    def removeWindowListener(self, windowListener: java.awt.event.WindowListener) -> None: ...
    def removeWindowStateListener(self, windowStateListener: java.awt.event.WindowStateListener) -> None: ...
    def reshape(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    def setAlwaysOnTop(self, boolean: bool) -> None: ...
    def setAutoRequestFocus(self, boolean: bool) -> None: ...
    def setBackground(self, color: Color) -> None: ...
    @overload
    def setBounds(self, int: int, int2: int, int3: int, int4: int) -> None: ...
    @overload
    def setBounds(self, rectangle: Rectangle) -> None: ...
    def setCursor(self, cursor: Cursor) -> None: ...
    def setFocusCycleRoot(self, boolean: bool) -> None: ...
    def setFocusableWindowState(self, boolean: bool) -> None: ...
    def setIconImage(self, image: Image) -> None: ...
    def setIconImages(self, list: java.util.List[Image]) -> None: ...
    @overload
    def setLocation(self, int: int, int2: int) -> None: ...
    @overload
    def setLocation(self, point: Point) -> None: ...
    def setLocationByPlatform(self, boolean: bool) -> None: ...
    def setLocationRelativeTo(self, component: Component) -> None: ...
    def setMinimumSize(self, dimension: Dimension) -> None: ...
    def setModalExclusionType(self, modalExclusionType: 'Dialog.ModalExclusionType') -> None: ...
    def setOpacity(self, float: float) -> None: ...
    def setShape(self, shape: Shape) -> None: ...
    @overload
    def setSize(self, int: int, int2: int) -> None: ...
    @overload
    def setSize(self, dimension: Dimension) -> None: ...
    def setType(self, type: 'Window.Type') -> None: ...
    def setVisible(self, boolean: bool) -> None: ...
    @overload
    def show(self, boolean: bool) -> None: ...
    @overload
    def show(self) -> None: ...
    def toBack(self) -> None: ...
    def toFront(self) -> None: ...
    class Type(java.lang.Enum['Window.Type']):
        NORMAL: _py_ClassVar['Window.Type'] = ...
        UTILITY: _py_ClassVar['Window.Type'] = ...
        POPUP: _py_ClassVar['Window.Type'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'Window.Type': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['Window.Type']: ...

class Dialog(Window):
    DEFAULT_MODALITY_TYPE: _py_ClassVar['Dialog.ModalityType'] = ...
    @overload
    def __init__(self, dialog: 'Dialog'): ...
    @overload
    def __init__(self, dialog: 'Dialog', string: str): ...
    @overload
    def __init__(self, dialog: 'Dialog', string: str, boolean: bool): ...
    @overload
    def __init__(self, dialog: 'Dialog', string: str, boolean: bool, graphicsConfiguration: GraphicsConfiguration): ...
    @overload
    def __init__(self, frame: 'Frame'): ...
    @overload
    def __init__(self, frame: 'Frame', boolean: bool): ...
    @overload
    def __init__(self, frame: 'Frame', string: str): ...
    @overload
    def __init__(self, frame: 'Frame', string: str, boolean: bool): ...
    @overload
    def __init__(self, frame: 'Frame', string: str, boolean: bool, graphicsConfiguration: GraphicsConfiguration): ...
    @overload
    def __init__(self, window: Window): ...
    @overload
    def __init__(self, window: Window, modalityType: 'Dialog.ModalityType'): ...
    @overload
    def __init__(self, window: Window, string: str): ...
    @overload
    def __init__(self, window: Window, string: str, modalityType: 'Dialog.ModalityType'): ...
    @overload
    def __init__(self, window: Window, string: str, modalityType: 'Dialog.ModalityType', graphicsConfiguration: GraphicsConfiguration): ...
    def addNotify(self) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getModalityType(self) -> 'Dialog.ModalityType': ...
    def getTitle(self) -> str: ...
    def hide(self) -> None: ...
    def isModal(self) -> bool: ...
    def isResizable(self) -> bool: ...
    def isUndecorated(self) -> bool: ...
    def setBackground(self, color: Color) -> None: ...
    def setModal(self, boolean: bool) -> None: ...
    def setModalityType(self, modalityType: 'Dialog.ModalityType') -> None: ...
    def setOpacity(self, float: float) -> None: ...
    def setResizable(self, boolean: bool) -> None: ...
    def setShape(self, shape: Shape) -> None: ...
    def setTitle(self, string: str) -> None: ...
    def setUndecorated(self, boolean: bool) -> None: ...
    def setVisible(self, boolean: bool) -> None: ...
    @overload
    def show(self, boolean: bool) -> None: ...
    @overload
    def show(self) -> None: ...
    def toBack(self) -> None: ...
    class ModalExclusionType(java.lang.Enum['Dialog.ModalExclusionType']):
        NO_EXCLUDE: _py_ClassVar['Dialog.ModalExclusionType'] = ...
        APPLICATION_EXCLUDE: _py_ClassVar['Dialog.ModalExclusionType'] = ...
        TOOLKIT_EXCLUDE: _py_ClassVar['Dialog.ModalExclusionType'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'Dialog.ModalExclusionType': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['Dialog.ModalExclusionType']: ...
    class ModalityType(java.lang.Enum['Dialog.ModalityType']):
        MODELESS: _py_ClassVar['Dialog.ModalityType'] = ...
        DOCUMENT_MODAL: _py_ClassVar['Dialog.ModalityType'] = ...
        APPLICATION_MODAL: _py_ClassVar['Dialog.ModalityType'] = ...
        TOOLKIT_MODAL: _py_ClassVar['Dialog.ModalityType'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'Dialog.ModalityType': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['Dialog.ModalityType']: ...

class Frame(Window, MenuContainer):
    DEFAULT_CURSOR: _py_ClassVar[int] = ...
    CROSSHAIR_CURSOR: _py_ClassVar[int] = ...
    TEXT_CURSOR: _py_ClassVar[int] = ...
    WAIT_CURSOR: _py_ClassVar[int] = ...
    SW_RESIZE_CURSOR: _py_ClassVar[int] = ...
    SE_RESIZE_CURSOR: _py_ClassVar[int] = ...
    NW_RESIZE_CURSOR: _py_ClassVar[int] = ...
    NE_RESIZE_CURSOR: _py_ClassVar[int] = ...
    N_RESIZE_CURSOR: _py_ClassVar[int] = ...
    S_RESIZE_CURSOR: _py_ClassVar[int] = ...
    W_RESIZE_CURSOR: _py_ClassVar[int] = ...
    E_RESIZE_CURSOR: _py_ClassVar[int] = ...
    HAND_CURSOR: _py_ClassVar[int] = ...
    MOVE_CURSOR: _py_ClassVar[int] = ...
    NORMAL: _py_ClassVar[int] = ...
    ICONIFIED: _py_ClassVar[int] = ...
    MAXIMIZED_HORIZ: _py_ClassVar[int] = ...
    MAXIMIZED_VERT: _py_ClassVar[int] = ...
    MAXIMIZED_BOTH: _py_ClassVar[int] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, graphicsConfiguration: GraphicsConfiguration): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, graphicsConfiguration: GraphicsConfiguration): ...
    def addNotify(self) -> None: ...
    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...
    def getCursorType(self) -> int: ...
    def getExtendedState(self) -> int: ...
    @classmethod
    def getFrames(cls) -> _py_List['Frame']: ...
    def getIconImage(self) -> Image: ...
    def getMaximizedBounds(self) -> Rectangle: ...
    def getMenuBar(self) -> MenuBar: ...
    def getState(self) -> int: ...
    def getTitle(self) -> str: ...
    def isResizable(self) -> bool: ...
    def isUndecorated(self) -> bool: ...
    @overload
    def remove(self, int: int) -> None: ...
    @overload
    def remove(self, component: Component) -> None: ...
    @overload
    def remove(self, menuComponent: MenuComponent) -> None: ...
    def removeNotify(self) -> None: ...
    def setBackground(self, color: Color) -> None: ...
    @overload
    def setCursor(self, int: int) -> None: ...
    @overload
    def setCursor(self, cursor: Cursor) -> None: ...
    def setExtendedState(self, int: int) -> None: ...
    def setIconImage(self, image: Image) -> None: ...
    def setMaximizedBounds(self, rectangle: Rectangle) -> None: ...
    def setMenuBar(self, menuBar: MenuBar) -> None: ...
    def setOpacity(self, float: float) -> None: ...
    def setResizable(self, boolean: bool) -> None: ...
    def setShape(self, shape: Shape) -> None: ...
    def setState(self, int: int) -> None: ...
    def setTitle(self, string: str) -> None: ...
    def setUndecorated(self, boolean: bool) -> None: ...

class FileDialog(Dialog):
    LOAD: _py_ClassVar[int] = ...
    SAVE: _py_ClassVar[int] = ...
    @overload
    def __init__(self, dialog: Dialog): ...
    @overload
    def __init__(self, dialog: Dialog, string: str): ...
    @overload
    def __init__(self, dialog: Dialog, string: str, int: int): ...
    @overload
    def __init__(self, frame: Frame): ...
    @overload
    def __init__(self, frame: Frame, string: str): ...
    @overload
    def __init__(self, frame: Frame, string: str, int: int): ...
    def addNotify(self) -> None: ...
    def getDirectory(self) -> str: ...
    def getFile(self) -> str: ...
    def getFilenameFilter(self) -> java.io.FilenameFilter: ...
    def getFiles(self) -> _py_List[java.io.File]: ...
    def getMode(self) -> int: ...
    def isMultipleMode(self) -> bool: ...
    def setDirectory(self, string: str) -> None: ...
    def setFile(self, string: str) -> None: ...
    def setFilenameFilter(self, filenameFilter: java.io.FilenameFilter) -> None: ...
    def setMode(self, int: int) -> None: ...
    def setMultipleMode(self, boolean: bool) -> None: ...
