from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import com
import java.io
import java.lang
import java.lang.ref
import java.lang.reflect
import java.nio.charset
import java.time
import java.util
import java.util.concurrent
import java.util.function
import java.util.regex


_AbstractIterator__T = _py_TypeVar('_AbstractIterator__T')  # <T>
class AbstractIterator(java.util.Iterator[_AbstractIterator__T], _py_Generic[_AbstractIterator__T]):
    def hasNext(self) -> bool: ...
    def next(self) -> _AbstractIterator__T: ...
    def remove(self) -> None: ...

class Ascii:
    NUL: _py_ClassVar[int] = ...
    SOH: _py_ClassVar[int] = ...
    STX: _py_ClassVar[int] = ...
    ETX: _py_ClassVar[int] = ...
    EOT: _py_ClassVar[int] = ...
    ENQ: _py_ClassVar[int] = ...
    ACK: _py_ClassVar[int] = ...
    BEL: _py_ClassVar[int] = ...
    BS: _py_ClassVar[int] = ...
    HT: _py_ClassVar[int] = ...
    LF: _py_ClassVar[int] = ...
    NL: _py_ClassVar[int] = ...
    VT: _py_ClassVar[int] = ...
    FF: _py_ClassVar[int] = ...
    CR: _py_ClassVar[int] = ...
    SO: _py_ClassVar[int] = ...
    SI: _py_ClassVar[int] = ...
    DLE: _py_ClassVar[int] = ...
    DC1: _py_ClassVar[int] = ...
    XON: _py_ClassVar[int] = ...
    DC2: _py_ClassVar[int] = ...
    DC3: _py_ClassVar[int] = ...
    XOFF: _py_ClassVar[int] = ...
    DC4: _py_ClassVar[int] = ...
    NAK: _py_ClassVar[int] = ...
    SYN: _py_ClassVar[int] = ...
    ETB: _py_ClassVar[int] = ...
    CAN: _py_ClassVar[int] = ...
    EM: _py_ClassVar[int] = ...
    SUB: _py_ClassVar[int] = ...
    ESC: _py_ClassVar[int] = ...
    FS: _py_ClassVar[int] = ...
    GS: _py_ClassVar[int] = ...
    RS: _py_ClassVar[int] = ...
    US: _py_ClassVar[int] = ...
    SP: _py_ClassVar[int] = ...
    SPACE: _py_ClassVar[int] = ...
    DEL: _py_ClassVar[int] = ...
    MIN: _py_ClassVar[str] = ...
    MAX: _py_ClassVar[str] = ...
    @classmethod
    def equalsIgnoreCase(cls, charSequence: java.lang.CharSequence, charSequence2: java.lang.CharSequence) -> bool: ...
    @classmethod
    def isLowerCase(cls, char: str) -> bool: ...
    @classmethod
    def isUpperCase(cls, char: str) -> bool: ...
    @classmethod
    @overload
    def toLowerCase(cls, char: str) -> str: ...
    @classmethod
    @overload
    def toLowerCase(cls, charSequence: java.lang.CharSequence) -> str: ...
    @classmethod
    @overload
    def toLowerCase(cls, string: str) -> str: ...
    @classmethod
    @overload
    def toUpperCase(cls, char: str) -> str: ...
    @classmethod
    @overload
    def toUpperCase(cls, charSequence: java.lang.CharSequence) -> str: ...
    @classmethod
    @overload
    def toUpperCase(cls, string: str) -> str: ...
    @classmethod
    def truncate(cls, charSequence: java.lang.CharSequence, int: int, string: str) -> str: ...

class CaseFormat(java.lang.Enum['CaseFormat']):
    LOWER_HYPHEN: _py_ClassVar['CaseFormat'] = ...
    LOWER_UNDERSCORE: _py_ClassVar['CaseFormat'] = ...
    LOWER_CAMEL: _py_ClassVar['CaseFormat'] = ...
    UPPER_CAMEL: _py_ClassVar['CaseFormat'] = ...
    UPPER_UNDERSCORE: _py_ClassVar['CaseFormat'] = ...
    def converterTo(self, caseFormat: 'CaseFormat') -> 'Converter'[str, str]: ...
    def to(self, caseFormat: 'CaseFormat', string: str) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'CaseFormat': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['CaseFormat']: ...

class Charsets:
    US_ASCII: _py_ClassVar[java.nio.charset.Charset] = ...
    ISO_8859_1: _py_ClassVar[java.nio.charset.Charset] = ...
    UTF_8: _py_ClassVar[java.nio.charset.Charset] = ...
    UTF_16BE: _py_ClassVar[java.nio.charset.Charset] = ...
    UTF_16LE: _py_ClassVar[java.nio.charset.Charset] = ...
    UTF_16: _py_ClassVar[java.nio.charset.Charset] = ...

class CommonMatcher:
    def end(self) -> int: ...
    @overload
    def find(self) -> bool: ...
    @overload
    def find(self, int: int) -> bool: ...
    def matches(self) -> bool: ...
    def replaceAll(self, string: str) -> str: ...
    def start(self) -> int: ...

class CommonPattern:
    @classmethod
    def compile(cls, string: str) -> 'CommonPattern': ...
    def flags(self) -> int: ...
    @classmethod
    def isPcreLike(cls) -> bool: ...
    def matcher(self, charSequence: java.lang.CharSequence) -> CommonMatcher: ...
    def pattern(self) -> str: ...
    def toString(self) -> str: ...

class Defaults:
    _defaultValue__T = _py_TypeVar('_defaultValue__T')  # <T>
    @classmethod
    def defaultValue(cls, class_: _py_Type[_defaultValue__T]) -> _defaultValue__T: ...

class Enums:
    @classmethod
    def getField(cls, enum: java.lang.Enum[_py_Any]) -> java.lang.reflect.Field: ...
    _getIfPresent__T = _py_TypeVar('_getIfPresent__T', bound=java.lang.Enum)  # <T>
    @classmethod
    def getIfPresent(cls, class_: _py_Type[_getIfPresent__T], string: str) -> 'Optional'[_getIfPresent__T]: ...
    _stringConverter__T = _py_TypeVar('_stringConverter__T', bound=java.lang.Enum)  # <T>
    @classmethod
    def stringConverter(cls, class_: _py_Type[_stringConverter__T]) -> 'Converter'[str, _stringConverter__T]: ...

_Equivalence__Wrapper__T = _py_TypeVar('_Equivalence__Wrapper__T')  # <T>
_Equivalence__T = _py_TypeVar('_Equivalence__T')  # <T>
class Equivalence(java.util.function.BiPredicate[_Equivalence__T, _Equivalence__T], _py_Generic[_Equivalence__T]):
    @overload
    def equals(self, object: _py_Any) -> bool: ...
    @classmethod
    @overload
    def equals(cls) -> 'Equivalence'[_py_Any]: ...
    def equivalent(self, t: _Equivalence__T, t2: _Equivalence__T) -> bool: ...
    def equivalentTo(self, t: _Equivalence__T) -> 'Predicate'[_Equivalence__T]: ...
    def hash(self, t: _Equivalence__T) -> int: ...
    @classmethod
    def identity(cls) -> 'Equivalence'[_py_Any]: ...
    _onResultOf__F = _py_TypeVar('_onResultOf__F')  # <F>
    def onResultOf(self, function: 'Function'[_onResultOf__F, _Equivalence__T]) -> 'Equivalence'[_onResultOf__F]: ...
    _pairwise__S = _py_TypeVar('_pairwise__S')  # <S>
    def pairwise(self) -> 'Equivalence'[java.lang.Iterable[_pairwise__S]]: ...
    def test(self, t: _Equivalence__T, t2: _Equivalence__T) -> bool: ...
    _wrap__S = _py_TypeVar('_wrap__S')  # <S>
    def wrap(self, s2: _wrap__S) -> 'Equivalence.Wrapper'[_wrap__S]: ...
    class Wrapper(java.io.Serializable, _py_Generic[_Equivalence__Wrapper__T]):
        def equals(self, object: _py_Any) -> bool: ...
        def get(self) -> _Equivalence__Wrapper__T: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...

class ExtraObjectsMethodsForWeb: ...

class FinalizableReference:
    def finalizeReferent(self) -> None: ...

class FinalizableReferenceQueue(java.io.Closeable):
    def __init__(self): ...
    def close(self) -> None: ...

_Function__F = _py_TypeVar('_Function__F')  # <F>
_Function__T = _py_TypeVar('_Function__T')  # <T>
class Function(java.util.function.Function[_Function__F, _Function__T], _py_Generic[_Function__F, _Function__T]):
    def apply(self, f: _Function__F) -> _Function__T: ...
    def equals(self, object: _py_Any) -> bool: ...

class Functions:
    _compose__A = _py_TypeVar('_compose__A')  # <A>
    _compose__B = _py_TypeVar('_compose__B')  # <B>
    _compose__C = _py_TypeVar('_compose__C')  # <C>
    @classmethod
    def compose(cls, function: Function[_compose__B, _compose__C], function2: Function[_compose__A, _compose__B]) -> Function[_compose__A, _compose__C]: ...
    _constant__E = _py_TypeVar('_constant__E')  # <E>
    @classmethod
    def constant(cls, e: _constant__E) -> Function[_py_Any, _constant__E]: ...
    _forMap_0__K = _py_TypeVar('_forMap_0__K')  # <K>
    _forMap_0__V = _py_TypeVar('_forMap_0__V')  # <V>
    @classmethod
    @overload
    def forMap(cls, map: java.util.Map[_forMap_0__K, _forMap_0__V]) -> Function[_forMap_0__K, _forMap_0__V]: ...
    _forMap_1__K = _py_TypeVar('_forMap_1__K')  # <K>
    _forMap_1__V = _py_TypeVar('_forMap_1__V')  # <V>
    @classmethod
    @overload
    def forMap(cls, map: java.util.Map[_forMap_1__K, _forMap_1__V], v: _forMap_1__V) -> Function[_forMap_1__K, _forMap_1__V]: ...
    _forPredicate__T = _py_TypeVar('_forPredicate__T')  # <T>
    @classmethod
    def forPredicate(cls, predicate: 'Predicate'[_forPredicate__T]) -> Function[_forPredicate__T, bool]: ...
    _forSupplier__T = _py_TypeVar('_forSupplier__T')  # <T>
    @classmethod
    def forSupplier(cls, supplier: 'Supplier'[_forSupplier__T]) -> Function[_py_Any, _forSupplier__T]: ...
    _identity__E = _py_TypeVar('_identity__E')  # <E>
    @classmethod
    def identity(cls) -> Function[_identity__E, _identity__E]: ...
    @classmethod
    def toStringFunction(cls) -> Function[_py_Any, str]: ...

class Joiner:
    _appendTo_0__A = _py_TypeVar('_appendTo_0__A', bound=java.lang.Appendable)  # <A>
    @overload
    def appendTo(self, a: _appendTo_0__A, object: _py_Any, object2: _py_Any, objectArray: _py_List[_py_Any]) -> _appendTo_0__A: ...
    _appendTo_1__A = _py_TypeVar('_appendTo_1__A', bound=java.lang.Appendable)  # <A>
    @overload
    def appendTo(self, a: _appendTo_1__A, objectArray: _py_List[_py_Any]) -> _appendTo_1__A: ...
    @overload
    def appendTo(self, stringBuilder: java.lang.StringBuilder, iterable: java.lang.Iterable[_py_Any]) -> java.lang.StringBuilder: ...
    @overload
    def appendTo(self, stringBuilder: java.lang.StringBuilder, object: _py_Any, object2: _py_Any, objectArray: _py_List[_py_Any]) -> java.lang.StringBuilder: ...
    @overload
    def appendTo(self, stringBuilder: java.lang.StringBuilder, objectArray: _py_List[_py_Any]) -> java.lang.StringBuilder: ...
    @overload
    def appendTo(self, stringBuilder: java.lang.StringBuilder, iterator: java.util.Iterator[_py_Any]) -> java.lang.StringBuilder: ...
    _appendTo_6__A = _py_TypeVar('_appendTo_6__A', bound=java.lang.Appendable)  # <A>
    @overload
    def appendTo(self, a: _appendTo_6__A, iterable: java.lang.Iterable[_py_Any]) -> _appendTo_6__A: ...
    _appendTo_7__A = _py_TypeVar('_appendTo_7__A', bound=java.lang.Appendable)  # <A>
    @overload
    def appendTo(self, a: _appendTo_7__A, iterator: java.util.Iterator[_py_Any]) -> _appendTo_7__A: ...
    @overload
    def join(self, iterable: java.lang.Iterable[_py_Any]) -> str: ...
    @overload
    def join(self, object: _py_Any, object2: _py_Any, objectArray: _py_List[_py_Any]) -> str: ...
    @overload
    def join(self, objectArray: _py_List[_py_Any]) -> str: ...
    @overload
    def join(self, iterator: java.util.Iterator[_py_Any]) -> str: ...
    @classmethod
    @overload
    def on(cls, char: str) -> 'Joiner': ...
    @classmethod
    @overload
    def on(cls, string: str) -> 'Joiner': ...
    def skipNulls(self) -> 'Joiner': ...
    def useForNull(self, string: str) -> 'Joiner': ...
    @overload
    def withKeyValueSeparator(self, char: str) -> 'Joiner.MapJoiner': ...
    @overload
    def withKeyValueSeparator(self, string: str) -> 'Joiner.MapJoiner': ...
    class MapJoiner:
        _appendTo_0__A = _py_TypeVar('_appendTo_0__A', bound=java.lang.Appendable)  # <A>
        @overload
        def appendTo(self, a: _appendTo_0__A, iterable: java.lang.Iterable[java.util.Map.Entry[_py_Any, _py_Any]]) -> _appendTo_0__A: ...
        _appendTo_1__A = _py_TypeVar('_appendTo_1__A', bound=java.lang.Appendable)  # <A>
        @overload
        def appendTo(self, a: _appendTo_1__A, iterator: java.util.Iterator[java.util.Map.Entry[_py_Any, _py_Any]]) -> _appendTo_1__A: ...
        _appendTo_2__A = _py_TypeVar('_appendTo_2__A', bound=java.lang.Appendable)  # <A>
        @overload
        def appendTo(self, a: _appendTo_2__A, map: java.util.Map[_py_Any, _py_Any]) -> _appendTo_2__A: ...
        @overload
        def appendTo(self, stringBuilder: java.lang.StringBuilder, iterable: java.lang.Iterable[java.util.Map.Entry[_py_Any, _py_Any]]) -> java.lang.StringBuilder: ...
        @overload
        def appendTo(self, stringBuilder: java.lang.StringBuilder, iterator: java.util.Iterator[java.util.Map.Entry[_py_Any, _py_Any]]) -> java.lang.StringBuilder: ...
        @overload
        def appendTo(self, stringBuilder: java.lang.StringBuilder, map: java.util.Map[_py_Any, _py_Any]) -> java.lang.StringBuilder: ...
        @overload
        def join(self, iterable: java.lang.Iterable[java.util.Map.Entry[_py_Any, _py_Any]]) -> str: ...
        @overload
        def join(self, iterator: java.util.Iterator[java.util.Map.Entry[_py_Any, _py_Any]]) -> str: ...
        @overload
        def join(self, map: java.util.Map[_py_Any, _py_Any]) -> str: ...
        def useForNull(self, string: str) -> 'Joiner.MapJoiner': ...

class MoreObjects:
    _firstNonNull__T = _py_TypeVar('_firstNonNull__T')  # <T>
    @classmethod
    def firstNonNull(cls, t: _firstNonNull__T, t2: _firstNonNull__T) -> _firstNonNull__T: ...
    @classmethod
    @overload
    def toStringHelper(cls, class_: _py_Type[_py_Any]) -> 'MoreObjects.ToStringHelper': ...
    @classmethod
    @overload
    def toStringHelper(cls, object: _py_Any) -> 'MoreObjects.ToStringHelper': ...
    @classmethod
    @overload
    def toStringHelper(cls, string: str) -> 'MoreObjects.ToStringHelper': ...
    class ToStringHelper:
        @overload
        def add(self, string: str, boolean: bool) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def add(self, string: str, char: str) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def add(self, string: str, double: float) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def add(self, string: str, float: float) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def add(self, string: str, int: int) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def add(self, string: str, object: _py_Any) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def add(self, string: str, long: int) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def addValue(self, boolean: bool) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def addValue(self, char: str) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def addValue(self, double: float) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def addValue(self, float: float) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def addValue(self, int: int) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def addValue(self, object: _py_Any) -> 'MoreObjects.ToStringHelper': ...
        @overload
        def addValue(self, long: int) -> 'MoreObjects.ToStringHelper': ...
        def omitNullValues(self) -> 'MoreObjects.ToStringHelper': ...
        def toString(self) -> str: ...

_Optional__T = _py_TypeVar('_Optional__T')  # <T>
class Optional(java.io.Serializable, _py_Generic[_Optional__T]):
    _absent__T = _py_TypeVar('_absent__T')  # <T>
    @classmethod
    def absent(cls) -> 'Optional'[_absent__T]: ...
    def asSet(self) -> java.util.Set[_Optional__T]: ...
    def equals(self, object: _py_Any) -> bool: ...
    _fromJavaUtil__T = _py_TypeVar('_fromJavaUtil__T')  # <T>
    @classmethod
    def fromJavaUtil(cls, optional: java.util.Optional[_fromJavaUtil__T]) -> 'Optional'[_fromJavaUtil__T]: ...
    _fromNullable__T = _py_TypeVar('_fromNullable__T')  # <T>
    @classmethod
    def fromNullable(cls, t: _fromNullable__T) -> 'Optional'[_fromNullable__T]: ...
    def get(self) -> _Optional__T: ...
    def hashCode(self) -> int: ...
    def isPresent(self) -> bool: ...
    _of__T = _py_TypeVar('_of__T')  # <T>
    @classmethod
    def of(cls, t: _of__T) -> 'Optional'[_of__T]: ...
    def orNull(self) -> _Optional__T: ...
    _presentInstances__T = _py_TypeVar('_presentInstances__T')  # <T>
    @classmethod
    def presentInstances(cls, iterable: java.lang.Iterable['Optional'[_presentInstances__T]]) -> java.lang.Iterable[_presentInstances__T]: ...
    @overload
    def toJavaUtil(self) -> java.util.Optional[_Optional__T]: ...
    _toJavaUtil_1__T = _py_TypeVar('_toJavaUtil_1__T')  # <T>
    @classmethod
    @overload
    def toJavaUtil(cls, optional: 'Optional'[_toJavaUtil_1__T]) -> java.util.Optional[_toJavaUtil_1__T]: ...
    def toString(self) -> str: ...
    _transform__V = _py_TypeVar('_transform__V')  # <V>
    def transform(self, function: Function[_Optional__T, _transform__V]) -> 'Optional'[_transform__V]: ...

class PatternCompiler:
    def compile(self, string: str) -> CommonPattern: ...
    def isPcreLike(self) -> bool: ...

class Platform: ...

class Preconditions:
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, char: str) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, char: str, char2: str) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, char: str, int: int) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, char: str, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, char: str, long: int) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, int: int) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, int: int, char: str) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, int: int, int2: int) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, int: int, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, int: int, long: int) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, object: _py_Any, char: str) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, object: _py_Any, int: int) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, object: _py_Any, object2: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, object: _py_Any, object2: _py_Any, object3: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, object: _py_Any, object2: _py_Any, object3: _py_Any, object4: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, object: _py_Any, long: int) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, objectArray: _py_List[_py_Any]) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, long: int) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, long: int, char: str) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, long: int, int: int) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, long: int, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkArgument(cls, boolean: bool, string: str, long: int, long2: int) -> None: ...
    @classmethod
    @overload
    def checkElementIndex(cls, int: int, int2: int) -> int: ...
    @classmethod
    @overload
    def checkElementIndex(cls, int: int, int2: int, string: str) -> int: ...
    _checkNotNull_0__T = _py_TypeVar('_checkNotNull_0__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_0__T) -> _checkNotNull_0__T: ...
    _checkNotNull_1__T = _py_TypeVar('_checkNotNull_1__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_1__T, object: _py_Any) -> _checkNotNull_1__T: ...
    _checkNotNull_2__T = _py_TypeVar('_checkNotNull_2__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_2__T, string: str, char: str) -> _checkNotNull_2__T: ...
    _checkNotNull_3__T = _py_TypeVar('_checkNotNull_3__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_3__T, string: str, char: str, char2: str) -> _checkNotNull_3__T: ...
    _checkNotNull_4__T = _py_TypeVar('_checkNotNull_4__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_4__T, string: str, char: str, int: int) -> _checkNotNull_4__T: ...
    _checkNotNull_5__T = _py_TypeVar('_checkNotNull_5__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_5__T, string: str, char: str, object: _py_Any) -> _checkNotNull_5__T: ...
    _checkNotNull_6__T = _py_TypeVar('_checkNotNull_6__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_6__T, string: str, char: str, long: int) -> _checkNotNull_6__T: ...
    _checkNotNull_7__T = _py_TypeVar('_checkNotNull_7__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_7__T, string: str, int: int) -> _checkNotNull_7__T: ...
    _checkNotNull_8__T = _py_TypeVar('_checkNotNull_8__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_8__T, string: str, int: int, char: str) -> _checkNotNull_8__T: ...
    _checkNotNull_9__T = _py_TypeVar('_checkNotNull_9__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_9__T, string: str, int: int, int2: int) -> _checkNotNull_9__T: ...
    _checkNotNull_10__T = _py_TypeVar('_checkNotNull_10__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_10__T, string: str, int: int, object: _py_Any) -> _checkNotNull_10__T: ...
    _checkNotNull_11__T = _py_TypeVar('_checkNotNull_11__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_11__T, string: str, int: int, long: int) -> _checkNotNull_11__T: ...
    _checkNotNull_12__T = _py_TypeVar('_checkNotNull_12__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_12__T, string: str, object: _py_Any) -> _checkNotNull_12__T: ...
    _checkNotNull_13__T = _py_TypeVar('_checkNotNull_13__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_13__T, string: str, object: _py_Any, char: str) -> _checkNotNull_13__T: ...
    _checkNotNull_14__T = _py_TypeVar('_checkNotNull_14__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_14__T, string: str, object: _py_Any, int: int) -> _checkNotNull_14__T: ...
    _checkNotNull_15__T = _py_TypeVar('_checkNotNull_15__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_15__T, string: str, object: _py_Any, object2: _py_Any) -> _checkNotNull_15__T: ...
    _checkNotNull_16__T = _py_TypeVar('_checkNotNull_16__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_16__T, string: str, object: _py_Any, object2: _py_Any, object3: _py_Any) -> _checkNotNull_16__T: ...
    _checkNotNull_17__T = _py_TypeVar('_checkNotNull_17__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_17__T, string: str, object: _py_Any, object2: _py_Any, object3: _py_Any, object4: _py_Any) -> _checkNotNull_17__T: ...
    _checkNotNull_18__T = _py_TypeVar('_checkNotNull_18__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_18__T, string: str, object: _py_Any, long: int) -> _checkNotNull_18__T: ...
    _checkNotNull_19__T = _py_TypeVar('_checkNotNull_19__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_19__T, string: str, objectArray: _py_List[_py_Any]) -> _checkNotNull_19__T: ...
    _checkNotNull_20__T = _py_TypeVar('_checkNotNull_20__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_20__T, string: str, long: int) -> _checkNotNull_20__T: ...
    _checkNotNull_21__T = _py_TypeVar('_checkNotNull_21__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_21__T, string: str, long: int, char: str) -> _checkNotNull_21__T: ...
    _checkNotNull_22__T = _py_TypeVar('_checkNotNull_22__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_22__T, string: str, long: int, int: int) -> _checkNotNull_22__T: ...
    _checkNotNull_23__T = _py_TypeVar('_checkNotNull_23__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_23__T, string: str, long: int, object: _py_Any) -> _checkNotNull_23__T: ...
    _checkNotNull_24__T = _py_TypeVar('_checkNotNull_24__T')  # <T>
    @classmethod
    @overload
    def checkNotNull(cls, t: _checkNotNull_24__T, string: str, long: int, long2: int) -> _checkNotNull_24__T: ...
    @classmethod
    @overload
    def checkPositionIndex(cls, int: int, int2: int) -> int: ...
    @classmethod
    @overload
    def checkPositionIndex(cls, int: int, int2: int, string: str) -> int: ...
    @classmethod
    def checkPositionIndexes(cls, int: int, int2: int, int3: int) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, char: str) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, char: str, char2: str) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, char: str, int: int) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, char: str, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, char: str, long: int) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, int: int) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, int: int, char: str) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, int: int, int2: int) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, int: int, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, int: int, long: int) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, object: _py_Any, char: str) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, object: _py_Any, int: int) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, object: _py_Any, object2: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, object: _py_Any, object2: _py_Any, object3: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, object: _py_Any, object2: _py_Any, object3: _py_Any, object4: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, object: _py_Any, long: int) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, objectArray: _py_List[_py_Any]) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, long: int) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, long: int, char: str) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, long: int, int: int) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, long: int, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def checkState(cls, boolean: bool, string: str, long: int, long2: int) -> None: ...

_Predicate__T = _py_TypeVar('_Predicate__T')  # <T>
class Predicate(java.util.function.Predicate[_Predicate__T], _py_Generic[_Predicate__T]):
    def apply(self, t: _Predicate__T) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def test(self, t: _Predicate__T) -> bool: ...

class Predicates:
    _alwaysFalse__T = _py_TypeVar('_alwaysFalse__T')  # <T>
    @classmethod
    def alwaysFalse(cls) -> Predicate[_alwaysFalse__T]: ...
    _alwaysTrue__T = _py_TypeVar('_alwaysTrue__T')  # <T>
    @classmethod
    def alwaysTrue(cls) -> Predicate[_alwaysTrue__T]: ...
    _compose__A = _py_TypeVar('_compose__A')  # <A>
    _compose__B = _py_TypeVar('_compose__B')  # <B>
    @classmethod
    def compose(cls, predicate: Predicate[_compose__B], function: Function[_compose__A, _compose__B]) -> Predicate[_compose__A]: ...
    @classmethod
    def contains(cls, pattern: java.util.regex.Pattern) -> Predicate[java.lang.CharSequence]: ...
    @classmethod
    def containsPattern(cls, string: str) -> Predicate[java.lang.CharSequence]: ...
    _equalTo__T = _py_TypeVar('_equalTo__T')  # <T>
    @classmethod
    def equalTo(cls, t: _equalTo__T) -> Predicate[_equalTo__T]: ...
    @classmethod
    def instanceOf(cls, class_: _py_Type[_py_Any]) -> Predicate[_py_Any]: ...
    _isNull__T = _py_TypeVar('_isNull__T')  # <T>
    @classmethod
    def isNull(cls) -> Predicate[_isNull__T]: ...
    _notNull__T = _py_TypeVar('_notNull__T')  # <T>
    @classmethod
    def notNull(cls) -> Predicate[_notNull__T]: ...
    @classmethod
    def subtypeOf(cls, class_: _py_Type[_py_Any]) -> Predicate[_py_Type[_py_Any]]: ...

class Splitter:
    @classmethod
    def fixedLength(cls, int: int) -> 'Splitter': ...
    def limit(self, int: int) -> 'Splitter': ...
    def omitEmptyStrings(self) -> 'Splitter': ...
    @classmethod
    @overload
    def on(cls, char: str) -> 'Splitter': ...
    @classmethod
    @overload
    def on(cls, charMatcher: 'CharMatcher') -> 'Splitter': ...
    @classmethod
    @overload
    def on(cls, string: str) -> 'Splitter': ...
    @classmethod
    @overload
    def on(cls, pattern: java.util.regex.Pattern) -> 'Splitter': ...
    @classmethod
    def onPattern(cls, string: str) -> 'Splitter': ...
    def split(self, charSequence: java.lang.CharSequence) -> java.lang.Iterable[str]: ...
    def splitToList(self, charSequence: java.lang.CharSequence) -> java.util.List[str]: ...
    @overload
    def trimResults(self) -> 'Splitter': ...
    @overload
    def trimResults(self, charMatcher: 'CharMatcher') -> 'Splitter': ...
    @overload
    def withKeyValueSeparator(self, char: str) -> 'Splitter.MapSplitter': ...
    @overload
    def withKeyValueSeparator(self, splitter: 'Splitter') -> 'Splitter.MapSplitter': ...
    @overload
    def withKeyValueSeparator(self, string: str) -> 'Splitter.MapSplitter': ...
    class MapSplitter:
        def split(self, charSequence: java.lang.CharSequence) -> java.util.Map[str, str]: ...

class StandardSystemProperty(java.lang.Enum['StandardSystemProperty']):
    JAVA_VERSION: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_VENDOR: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_VENDOR_URL: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_HOME: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_VM_SPECIFICATION_VERSION: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_VM_SPECIFICATION_VENDOR: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_VM_SPECIFICATION_NAME: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_VM_VERSION: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_VM_VENDOR: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_VM_NAME: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_SPECIFICATION_VERSION: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_SPECIFICATION_VENDOR: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_SPECIFICATION_NAME: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_CLASS_VERSION: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_CLASS_PATH: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_LIBRARY_PATH: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_IO_TMPDIR: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_COMPILER: _py_ClassVar['StandardSystemProperty'] = ...
    JAVA_EXT_DIRS: _py_ClassVar['StandardSystemProperty'] = ...
    OS_NAME: _py_ClassVar['StandardSystemProperty'] = ...
    OS_ARCH: _py_ClassVar['StandardSystemProperty'] = ...
    OS_VERSION: _py_ClassVar['StandardSystemProperty'] = ...
    FILE_SEPARATOR: _py_ClassVar['StandardSystemProperty'] = ...
    PATH_SEPARATOR: _py_ClassVar['StandardSystemProperty'] = ...
    LINE_SEPARATOR: _py_ClassVar['StandardSystemProperty'] = ...
    USER_NAME: _py_ClassVar['StandardSystemProperty'] = ...
    USER_HOME: _py_ClassVar['StandardSystemProperty'] = ...
    USER_DIR: _py_ClassVar['StandardSystemProperty'] = ...
    def key(self) -> str: ...
    def toString(self) -> str: ...
    def value(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'StandardSystemProperty': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['StandardSystemProperty']: ...

class Stopwatch:
    @classmethod
    @overload
    def createStarted(cls) -> 'Stopwatch': ...
    @classmethod
    @overload
    def createStarted(cls, ticker: 'Ticker') -> 'Stopwatch': ...
    @classmethod
    @overload
    def createUnstarted(cls) -> 'Stopwatch': ...
    @classmethod
    @overload
    def createUnstarted(cls, ticker: 'Ticker') -> 'Stopwatch': ...
    @overload
    def elapsed(self) -> java.time.Duration: ...
    @overload
    def elapsed(self, timeUnit: java.util.concurrent.TimeUnit) -> int: ...
    def isRunning(self) -> bool: ...
    def reset(self) -> 'Stopwatch': ...
    def start(self) -> 'Stopwatch': ...
    def stop(self) -> 'Stopwatch': ...
    def toString(self) -> str: ...

class Strings:
    @classmethod
    def commonPrefix(cls, charSequence: java.lang.CharSequence, charSequence2: java.lang.CharSequence) -> str: ...
    @classmethod
    def commonSuffix(cls, charSequence: java.lang.CharSequence, charSequence2: java.lang.CharSequence) -> str: ...
    @classmethod
    def emptyToNull(cls, string: str) -> str: ...
    @classmethod
    def isNullOrEmpty(cls, string: str) -> bool: ...
    @classmethod
    def lenientFormat(cls, string: str, objectArray: _py_List[_py_Any]) -> str: ...
    @classmethod
    def nullToEmpty(cls, string: str) -> str: ...
    @classmethod
    def padEnd(cls, string: str, int: int, char: str) -> str: ...
    @classmethod
    def padStart(cls, string: str, int: int, char: str) -> str: ...
    @classmethod
    def repeat(cls, string: str, int: int) -> str: ...

_Supplier__T = _py_TypeVar('_Supplier__T')  # <T>
class Supplier(java.util.function.Supplier[_Supplier__T], _py_Generic[_Supplier__T]):
    def get(self) -> _Supplier__T: ...

class Suppliers:
    _compose__F = _py_TypeVar('_compose__F')  # <F>
    _compose__T = _py_TypeVar('_compose__T')  # <T>
    @classmethod
    def compose(cls, function: Function[_compose__F, _compose__T], supplier: Supplier[_compose__F]) -> Supplier[_compose__T]: ...
    _memoize__T = _py_TypeVar('_memoize__T')  # <T>
    @classmethod
    def memoize(cls, supplier: Supplier[_memoize__T]) -> Supplier[_memoize__T]: ...
    _memoizeWithExpiration__T = _py_TypeVar('_memoizeWithExpiration__T')  # <T>
    @classmethod
    def memoizeWithExpiration(cls, supplier: Supplier[_memoizeWithExpiration__T], long: int, timeUnit: java.util.concurrent.TimeUnit) -> Supplier[_memoizeWithExpiration__T]: ...
    _ofInstance__T = _py_TypeVar('_ofInstance__T')  # <T>
    @classmethod
    def ofInstance(cls, t: _ofInstance__T) -> Supplier[_ofInstance__T]: ...
    _supplierFunction__T = _py_TypeVar('_supplierFunction__T')  # <T>
    @classmethod
    def supplierFunction(cls) -> Function[Supplier[_supplierFunction__T], _supplierFunction__T]: ...
    _synchronizedSupplier__T = _py_TypeVar('_synchronizedSupplier__T')  # <T>
    @classmethod
    def synchronizedSupplier(cls, supplier: Supplier[_synchronizedSupplier__T]) -> Supplier[_synchronizedSupplier__T]: ...

class Throwables:
    @classmethod
    def getCausalChain(cls, throwable: java.lang.Throwable) -> java.util.List[java.lang.Throwable]: ...
    _getCauseAs__X = _py_TypeVar('_getCauseAs__X', bound=java.lang.Throwable)  # <X>
    @classmethod
    def getCauseAs(cls, throwable: java.lang.Throwable, class_: _py_Type[_getCauseAs__X]) -> _getCauseAs__X: ...
    @classmethod
    def getRootCause(cls, throwable: java.lang.Throwable) -> java.lang.Throwable: ...
    @classmethod
    def getStackTraceAsString(cls, throwable: java.lang.Throwable) -> str: ...
    @classmethod
    def lazyStackTrace(cls, throwable: java.lang.Throwable) -> java.util.List[java.lang.StackTraceElement]: ...
    @classmethod
    def lazyStackTraceIsLazy(cls) -> bool: ...
    @classmethod
    def propagate(cls, throwable: java.lang.Throwable) -> java.lang.RuntimeException: ...
    _propagateIfInstanceOf__X = _py_TypeVar('_propagateIfInstanceOf__X', bound=java.lang.Throwable)  # <X>
    @classmethod
    def propagateIfInstanceOf(cls, throwable: java.lang.Throwable, class_: _py_Type[_propagateIfInstanceOf__X]) -> None: ...
    @classmethod
    @overload
    def propagateIfPossible(cls, throwable: java.lang.Throwable) -> None: ...
    _propagateIfPossible_1__X = _py_TypeVar('_propagateIfPossible_1__X', bound=java.lang.Throwable)  # <X>
    @classmethod
    @overload
    def propagateIfPossible(cls, throwable: java.lang.Throwable, class_: _py_Type[_propagateIfPossible_1__X]) -> None: ...
    _propagateIfPossible_2__X1 = _py_TypeVar('_propagateIfPossible_2__X1', bound=java.lang.Throwable)  # <X1>
    _propagateIfPossible_2__X2 = _py_TypeVar('_propagateIfPossible_2__X2', bound=java.lang.Throwable)  # <X2>
    @classmethod
    @overload
    def propagateIfPossible(cls, throwable: java.lang.Throwable, class_: _py_Type[_propagateIfPossible_2__X1], class2: _py_Type[_propagateIfPossible_2__X2]) -> None: ...
    _throwIfInstanceOf__X = _py_TypeVar('_throwIfInstanceOf__X', bound=java.lang.Throwable)  # <X>
    @classmethod
    def throwIfInstanceOf(cls, throwable: java.lang.Throwable, class_: _py_Type[_throwIfInstanceOf__X]) -> None: ...
    @classmethod
    def throwIfUnchecked(cls, throwable: java.lang.Throwable) -> None: ...

class Ticker:
    def read(self) -> int: ...
    @classmethod
    def systemTicker(cls) -> 'Ticker': ...

class Utf8:
    @classmethod
    def encodedLength(cls, charSequence: java.lang.CharSequence) -> int: ...
    @classmethod
    @overload
    def isWellFormed(cls, byteArray: _py_List[int]) -> bool: ...
    @classmethod
    @overload
    def isWellFormed(cls, byteArray: _py_List[int], int: int, int2: int) -> bool: ...

class Verify:
    @classmethod
    @overload
    def verify(cls, boolean: bool) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, char: str) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, char: str, char2: str) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, char: str, int: int) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, char: str, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, char: str, long: int) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, int: int) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, int: int, char: str) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, int: int, int2: int) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, int: int, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, int: int, long: int) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, object: _py_Any, char: str) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, object: _py_Any, int: int) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, object: _py_Any, object2: _py_Any) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, object: _py_Any, object2: _py_Any, object3: _py_Any) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, object: _py_Any, object2: _py_Any, object3: _py_Any, object4: _py_Any) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, object: _py_Any, long: int) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, objectArray: _py_List[_py_Any]) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, long: int) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, long: int, char: str) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, long: int, int: int) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, long: int, object: _py_Any) -> None: ...
    @classmethod
    @overload
    def verify(cls, boolean: bool, string: str, long: int, long2: int) -> None: ...
    _verifyNotNull_0__T = _py_TypeVar('_verifyNotNull_0__T')  # <T>
    @classmethod
    @overload
    def verifyNotNull(cls, t: _verifyNotNull_0__T) -> _verifyNotNull_0__T: ...
    _verifyNotNull_1__T = _py_TypeVar('_verifyNotNull_1__T')  # <T>
    @classmethod
    @overload
    def verifyNotNull(cls, t: _verifyNotNull_1__T, string: str, objectArray: _py_List[_py_Any]) -> _verifyNotNull_1__T: ...

class VerifyException(java.lang.RuntimeException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

_Absent__T = _py_TypeVar('_Absent__T')  # <T>
class Absent(Optional[_Absent__T], _py_Generic[_Absent__T]):
    def asSet(self) -> java.util.Set[_Absent__T]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self) -> _Absent__T: ...
    def hashCode(self) -> int: ...
    def isPresent(self) -> bool: ...
    def orNull(self) -> _Absent__T: ...
    def toString(self) -> str: ...
    _transform__V = _py_TypeVar('_transform__V')  # <V>
    def transform(self, function: Function[_Absent__T, _transform__V]) -> Optional[_transform__V]: ...

class CharMatcher(Predicate[str]):
    @classmethod
    def any(cls) -> 'CharMatcher': ...
    @classmethod
    def anyOf(cls, charSequence: java.lang.CharSequence) -> 'CharMatcher': ...
    @overload
    def apply(self, character: str) -> bool: ...
    @overload
    def apply(self, object: _py_Any) -> bool: ...
    @classmethod
    def ascii(cls) -> 'CharMatcher': ...
    @classmethod
    def breakingWhitespace(cls) -> 'CharMatcher': ...
    def collapseFrom(self, charSequence: java.lang.CharSequence, char2: str) -> str: ...
    def countIn(self, charSequence: java.lang.CharSequence) -> int: ...
    @classmethod
    def digit(cls) -> 'CharMatcher': ...
    @classmethod
    def forPredicate(cls, predicate: Predicate[str]) -> 'CharMatcher': ...
    @classmethod
    def inRange(cls, char: str, char2: str) -> 'CharMatcher': ...
    @overload
    def indexIn(self, charSequence: java.lang.CharSequence) -> int: ...
    @overload
    def indexIn(self, charSequence: java.lang.CharSequence, int: int) -> int: ...
    @classmethod
    def invisible(cls) -> 'CharMatcher': ...
    @classmethod
    def isNot(cls, char: str) -> 'CharMatcher': ...
    @classmethod
    def javaDigit(cls) -> 'CharMatcher': ...
    @classmethod
    def javaIsoControl(cls) -> 'CharMatcher': ...
    @classmethod
    def javaLetter(cls) -> 'CharMatcher': ...
    @classmethod
    def javaLetterOrDigit(cls) -> 'CharMatcher': ...
    @classmethod
    def javaLowerCase(cls) -> 'CharMatcher': ...
    @classmethod
    def javaUpperCase(cls) -> 'CharMatcher': ...
    def lastIndexIn(self, charSequence: java.lang.CharSequence) -> int: ...
    def matches(self, char: str) -> bool: ...
    def matchesAllOf(self, charSequence: java.lang.CharSequence) -> bool: ...
    def matchesAnyOf(self, charSequence: java.lang.CharSequence) -> bool: ...
    def matchesNoneOf(self, charSequence: java.lang.CharSequence) -> bool: ...
    @overload
    def negate(self) -> 'CharMatcher': ...
    @overload
    def negate(self) -> java.util.function.Predicate: ...
    @classmethod
    def none(cls) -> 'CharMatcher': ...
    @classmethod
    def noneOf(cls, charSequence: java.lang.CharSequence) -> 'CharMatcher': ...
    def precomputed(self) -> 'CharMatcher': ...
    def removeFrom(self, charSequence: java.lang.CharSequence) -> str: ...
    @overload
    def replaceFrom(self, charSequence: java.lang.CharSequence, char2: str) -> str: ...
    @overload
    def replaceFrom(self, charSequence: java.lang.CharSequence, charSequence2: java.lang.CharSequence) -> str: ...
    def retainFrom(self, charSequence: java.lang.CharSequence) -> str: ...
    @classmethod
    def singleWidth(cls) -> 'CharMatcher': ...
    def toString(self) -> str: ...
    def trimAndCollapseFrom(self, charSequence: java.lang.CharSequence, char2: str) -> str: ...
    def trimFrom(self, charSequence: java.lang.CharSequence) -> str: ...
    def trimLeadingFrom(self, charSequence: java.lang.CharSequence) -> str: ...
    def trimTrailingFrom(self, charSequence: java.lang.CharSequence) -> str: ...
    @classmethod
    def whitespace(cls) -> 'CharMatcher': ...

_Converter__A = _py_TypeVar('_Converter__A')  # <A>
_Converter__B = _py_TypeVar('_Converter__B')  # <B>
class Converter(Function[_Converter__A, _Converter__B], _py_Generic[_Converter__A, _Converter__B]):
    _andThen_0__V = _py_TypeVar('_andThen_0__V')  # <V>
    @overload
    def andThen(self, function: java.util.function.Function[_py_Any, _andThen_0__V]) -> java.util.function.Function[_py_Any, _andThen_0__V]: ...
    _andThen_1__C = _py_TypeVar('_andThen_1__C')  # <C>
    @overload
    def andThen(self, converter: 'Converter'[_Converter__B, _andThen_1__C]) -> 'Converter'[_Converter__A, _andThen_1__C]: ...
    def apply(self, a: _Converter__A) -> _Converter__B: ...
    def convert(self, a: _Converter__A) -> _Converter__B: ...
    def convertAll(self, iterable: java.lang.Iterable[_Converter__A]) -> java.lang.Iterable[_Converter__B]: ...
    def equals(self, object: _py_Any) -> bool: ...
    _identity__T = _py_TypeVar('_identity__T')  # <T>
    @classmethod
    def identity(cls) -> 'Converter'[_identity__T, _identity__T]: ...
    def reverse(self) -> 'Converter'[_Converter__B, _Converter__A]: ...

_FinalizablePhantomReference__T = _py_TypeVar('_FinalizablePhantomReference__T')  # <T>
class FinalizablePhantomReference(java.lang.ref.PhantomReference[_FinalizablePhantomReference__T], FinalizableReference, _py_Generic[_FinalizablePhantomReference__T]): ...

_FinalizableSoftReference__T = _py_TypeVar('_FinalizableSoftReference__T')  # <T>
class FinalizableSoftReference(java.lang.ref.SoftReference[_FinalizableSoftReference__T], FinalizableReference, _py_Generic[_FinalizableSoftReference__T]): ...

_FinalizableWeakReference__T = _py_TypeVar('_FinalizableWeakReference__T')  # <T>
class FinalizableWeakReference(java.lang.ref.WeakReference[_FinalizableWeakReference__T], FinalizableReference, _py_Generic[_FinalizableWeakReference__T]): ...

_FunctionalEquivalence__F = _py_TypeVar('_FunctionalEquivalence__F')  # <F>
_FunctionalEquivalence__T = _py_TypeVar('_FunctionalEquivalence__T')  # <T>
class FunctionalEquivalence(Equivalence[_FunctionalEquivalence__F], java.io.Serializable, _py_Generic[_FunctionalEquivalence__F, _FunctionalEquivalence__T]):
    @overload
    def equals(self, object: _py_Any) -> bool: ...
    @classmethod
    @overload
    def equals(cls) -> Equivalence[_py_Any]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class JdkPattern(CommonPattern, java.io.Serializable):
    def flags(self) -> int: ...
    def matcher(self, charSequence: java.lang.CharSequence) -> CommonMatcher: ...
    def pattern(self) -> str: ...
    def toString(self) -> str: ...

class Objects(ExtraObjectsMethodsForWeb):
    @classmethod
    def equal(cls, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def hashCode(self) -> int: ...
    @classmethod
    @overload
    def hashCode(cls, objectArray: _py_List[_py_Any]) -> int: ...

_PairwiseEquivalence__T = _py_TypeVar('_PairwiseEquivalence__T')  # <T>
class PairwiseEquivalence(Equivalence[java.lang.Iterable[_PairwiseEquivalence__T]], java.io.Serializable, _py_Generic[_PairwiseEquivalence__T]):
    @overload
    def equals(self, object: _py_Any) -> bool: ...
    @classmethod
    @overload
    def equals(cls) -> Equivalence[_py_Any]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

_Present__T = _py_TypeVar('_Present__T')  # <T>
class Present(Optional[_Present__T], _py_Generic[_Present__T]):
    def asSet(self) -> java.util.Set[_Present__T]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self) -> _Present__T: ...
    def hashCode(self) -> int: ...
    def isPresent(self) -> bool: ...
    def orNull(self) -> _Present__T: ...
    def toString(self) -> str: ...
    _transform__V = _py_TypeVar('_transform__V')  # <V>
    def transform(self, function: Function[_Present__T, _transform__V]) -> Optional[_transform__V]: ...

class SmallCharMatcher(com.google.common.base.CharMatcher.NamedFastMatcher):
    def matches(self, char: str) -> bool: ...
