from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.value
import cern.japc.core
import cern.japc.value
import cern.lsa.domain
import cern.lsa.domain.exploitation.factory
import cern.lsa.domain.exploitation.spi
import cern.lsa.domain.exploitation.spi.results
import cern.lsa.domain.settings
import java.io
import java.lang
import java.util


class DisplayMode(java.io.Serializable):
    RESULT: _py_ClassVar['DisplayMode'] = ...
    STATE: _py_ClassVar['DisplayMode'] = ...
    CONSOLE: _py_ClassVar['DisplayMode'] = ...
    GRAPH: _py_ClassVar['DisplayMode'] = ...
    TABLE: _py_ClassVar['DisplayMode'] = ...
    PCCURRENTS_TABLE: _py_ClassVar['DisplayMode'] = ...
    UNDEFINED: _py_ClassVar['DisplayMode'] = ...
    DRIVE_STATUS: _py_ClassVar['DisplayMode'] = ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def isConsole(self) -> bool: ...
    def isGraph(self) -> bool: ...
    def isResult(self) -> bool: ...
    def isTable(self) -> bool: ...
    def toString(self) -> str: ...
    @classmethod
    def valueOf(cls, string: str) -> 'DisplayMode': ...

class DriveException(cern.lsa.domain.LsaException):
    ERROR_DURING_DRIVE: _py_ClassVar[str] = ...
    def __init__(self, string: str, driveResult: 'DriveResult'): ...
    def getDriveResult(self) -> 'DriveResult': ...
    def getExceptions(self) -> java.util.Set[java.lang.Exception]: ...
    def getMessage(self) -> str: ...

class DriveRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.exploitation.factory.DriveRequestBuilder: ...
    def containsSettings(self) -> bool: ...
    def driveAllParameters(self) -> bool: ...
    def getAttribute(self, string: str) -> _py_Any: ...
    def getAttributes(self) -> java.util.Map[str, _py_Any]: ...
    def getContextSettings(self) -> cern.lsa.domain.settings.ContextSettings: ...
    def getDrivableContexts(self) -> java.util.Set[cern.lsa.domain.settings.DrivableContext]: ...
    def getParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getStandAloneContext(self) -> cern.lsa.domain.settings.StandAloneContext: ...
    def getTransactionId(self) -> int: ...
    def getValue(self, parameter: cern.lsa.domain.settings.Parameter, drivableContext: cern.lsa.domain.settings.DrivableContext) -> cern.accsoft.commons.value.ImmutableValue: ...
    def isCommit(self) -> bool: ...
    def isDriveForNonResidentContextsEnabled(self) -> bool: ...
    def isLenientDrive(self) -> bool: ...
    def setAttribute(self, string: str, object: _py_Any) -> None: ...

class DriveResult:
    @classmethod
    def builder(cls) -> cern.lsa.domain.exploitation.spi.DriveResultImpl.Builder: ...
    def containsErrors(self) -> bool: ...
    def getAttribute(self, string: str) -> _py_Any: ...
    def getAttributes(self) -> java.util.Map[str, _py_Any]: ...
    def getContextDriveResults(self) -> java.util.Set[cern.lsa.domain.exploitation.spi.results.ContextDriveResult]: ...
    def getDrivableContexts(self) -> java.util.Set[cern.lsa.domain.settings.DrivableContext]: ...
    def getDrivenParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getExceptions(self) -> java.util.Set[java.lang.Exception]: ...
    def merge(self, driveResult: 'DriveResult') -> 'DriveResult': ...

class DriveResults:
    @classmethod
    def containsResultsForJapcParametersInEveryContext(cls, driveResult: DriveResult, parameterArray: _py_List[cern.japc.core.Parameter]) -> bool: ...
    @classmethod
    def getAllExceptions(cls, driveResult: DriveResult) -> java.util.Set[java.lang.Exception]: ...
    @classmethod
    def getDriveResultsByLsaParameter(cls, driveResult: DriveResult, parameter: cern.lsa.domain.settings.Parameter) -> java.util.Set[cern.lsa.domain.exploitation.spi.results.LsaParameterDriveResult]: ...
    @classmethod
    def getDrivenParametersByContext(cls, driveResult: DriveResult) -> java.util.Map[cern.lsa.domain.settings.DrivableContext, java.util.Set[cern.lsa.domain.settings.Parameter]]: ...
    @classmethod
    def getExceptionsByContext(cls, driveResult: DriveResult) -> java.util.Map[cern.lsa.domain.settings.DrivableContext, java.util.Set[java.lang.Exception]]: ...
    @classmethod
    def getFailedLsaDriveResults(cls, driveResult: DriveResult) -> java.util.Map[java.lang.Exception, java.util.Set[cern.lsa.domain.exploitation.spi.results.LsaParameterDriveResult]]: ...
    @classmethod
    def getFailedParametersByContext(cls, driveResult: DriveResult) -> java.util.Map[cern.lsa.domain.settings.DrivableContext, java.util.Set[cern.lsa.domain.settings.Parameter]]: ...
    @classmethod
    def getIgnoredParametersByContext(cls, driveResult: DriveResult) -> java.util.Map[cern.lsa.domain.settings.DrivableContext, java.util.Set[cern.lsa.domain.settings.Parameter]]: ...
    @classmethod
    def getLsaParametersByStatus(cls, driveResult: DriveResult, status: cern.lsa.domain.exploitation.spi.results.LsaParameterDriveResult.Status) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...

class FailSafeImmutableValue:
    def getException(self) -> cern.japc.core.ParameterException: ...
    def getParameterName(self) -> str: ...
    def getValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...

class OnlineCheckException(cern.japc.core.ParameterException):
    @overload
    def __init__(self, onlineCheckExceptionType: 'OnlineCheckException.OnlineCheckExceptionType', string: str, string2: str): ...
    @overload
    def __init__(self, onlineCheckExceptionType: 'OnlineCheckException.OnlineCheckExceptionType', string: str, string2: str, string3: str): ...
    @overload
    def __init__(self, onlineCheckExceptionType: 'OnlineCheckException.OnlineCheckExceptionType', string: str, string2: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, string2: str, immutableValue: cern.accsoft.commons.value.ImmutableValue, immutableValue2: cern.accsoft.commons.value.ImmutableValue): ...
    def getContextName(self) -> str: ...
    def getDatabaseValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getErrorType(self) -> 'OnlineCheckException.OnlineCheckExceptionType': ...
    def getHardwareValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getLocalizedMessage(self) -> str: ...
    def getMessage(self) -> str: ...
    def getParameterName(self) -> str: ...
    class OnlineCheckExceptionType(java.lang.Enum['OnlineCheckException.OnlineCheckExceptionType']):
        SIGNATURE_MISMATCH: _py_ClassVar['OnlineCheckException.OnlineCheckExceptionType'] = ...
        DATABASE_CONFIGURATION: _py_ClassVar['OnlineCheckException.OnlineCheckExceptionType'] = ...
        SIGNATURE_CALCULATION_FAILURE: _py_ClassVar['OnlineCheckException.OnlineCheckExceptionType'] = ...
        NO_SIGNATURE_PARAMETER: _py_ClassVar['OnlineCheckException.OnlineCheckExceptionType'] = ...
        HARDWARE_DATABASE_MISMATCH: _py_ClassVar['OnlineCheckException.OnlineCheckExceptionType'] = ...
        SETTINGS_MISSING: _py_ClassVar['OnlineCheckException.OnlineCheckExceptionType'] = ...
        HARDWARE_ACCESS: _py_ClassVar['OnlineCheckException.OnlineCheckExceptionType'] = ...
        BAD_STATE: _py_ClassVar['OnlineCheckException.OnlineCheckExceptionType'] = ...
        def toString(self) -> str: ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'OnlineCheckException.OnlineCheckExceptionType': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['OnlineCheckException.OnlineCheckExceptionType']: ...

class ParameterValueConverter:
    def __init__(self): ...
    @classmethod
    def convertScalars2ParameterValue(cls, map: java.util.Map[str, cern.accsoft.commons.value.ImmutableValue]) -> cern.japc.value.MapParameterValue: ...
    @classmethod
    def convertSetting2ParameterValue(cls, setting: cern.lsa.domain.settings.Setting) -> cern.japc.value.ParameterValue: ...
    @classmethod
    def convertToFailSafeImmutableValue(cls, parameter: cern.lsa.domain.settings.Parameter, simpleParameterValue: cern.japc.value.SimpleParameterValue) -> cern.lsa.domain.exploitation.spi.FailSafeImmutableValueImpl: ...
    @classmethod
    def convertToFailSafeImmutableValues(cls, collection: java.util.Collection[cern.lsa.domain.settings.Parameter], mapParameterValue: cern.japc.value.MapParameterValue) -> java.util.Map[cern.lsa.domain.settings.Parameter, FailSafeImmutableValue]: ...
    @classmethod
    def convertToImmutableScalars(cls, mapParameterValue: cern.japc.value.MapParameterValue, list: java.util.List[str]) -> java.util.List[cern.accsoft.commons.value.ImmutableScalar]: ...
    @classmethod
    def convertToImmutableValue(cls, parameter: cern.lsa.domain.settings.Parameter, simpleParameterValue: cern.japc.value.SimpleParameterValue) -> cern.accsoft.commons.value.ImmutableValue: ...
    @classmethod
    def convertToParameterValue(cls, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> cern.japc.value.SimpleParameterValue: ...
    @classmethod
    def getSPVForParameter(cls, parameter: cern.lsa.domain.settings.Parameter, mapParameterValue: cern.japc.value.MapParameterValue) -> cern.japc.value.SimpleParameterValue: ...

class ReadHardwareRequest:
    def areNonResidentContextsEnabled(self) -> bool: ...
    @classmethod
    def builder(cls) -> cern.lsa.domain.exploitation.factory.ReadHardwareRequestBuilder: ...
    def getDrivableContext(self) -> cern.lsa.domain.settings.DrivableContext: ...
    def getParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...

class SettingsOnlineCheckRequest:
    def areNonResidentContextsEnabled(self) -> bool: ...
    def getCheckType(self) -> 'SettingsOnlineCheckRequest.SettingsCheckType': ...
    def getDeviceGroupName(self) -> str: ...
    def getDeviceNames(self) -> java.util.Set[str]: ...
    def getParameterNames(self) -> java.util.Set[str]: ...
    def getPropertyNames(self) -> java.util.Set[str]: ...
    def getUser(self) -> str: ...
    class SettingsCheckType(java.lang.Enum['SettingsOnlineCheckRequest.SettingsCheckType']):
        HARDWARE_CHECK: _py_ClassVar['SettingsOnlineCheckRequest.SettingsCheckType'] = ...
        SIGNATURE_CHECK: _py_ClassVar['SettingsOnlineCheckRequest.SettingsCheckType'] = ...
        FULL_CHECK: _py_ClassVar['SettingsOnlineCheckRequest.SettingsCheckType'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'SettingsOnlineCheckRequest.SettingsCheckType': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['SettingsOnlineCheckRequest.SettingsCheckType']: ...
