from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.util
import cern.accsoft.commons.value
import cern.lsa.domain.commons
import cern.lsa.domain.devices
import cern.lsa.domain.devices.factory.type
import cern.lsa.domain.devices.spi.type
import com.google.common.collect
import java.io
import java.lang
import java.util


class LsaAddedPropertyFieldSaveRequest:
    @classmethod
    def builder(cls) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
    def getDescription(self) -> str: ...
    def getDeviceTypeName(self) -> str: ...
    def getExistingPropertyHandling(self) -> 'LsaAddedPropertyFieldSaveRequest.ExistingPropertyHandling': ...
    def getFieldAccess(self) -> cern.lsa.domain.devices.spi.type.PropertyFieldAccess: ...
    def getFieldMaxValue(self) -> float: ...
    def getFieldMinValue(self) -> float: ...
    def getFieldName(self) -> str: ...
    def getFieldUnit(self) -> str: ...
    def getFieldValueType(self) -> cern.accsoft.commons.value.Type: ...
    def getPropertyName(self) -> str: ...
    def getReasonForAdding(self) -> str: ...
    def isPropertyCycleBound(self) -> bool: ...
    def isPropertyMultiplexed(self) -> bool: ...
    def isPropertyReadable(self) -> bool: ...
    def isPropertyWritable(self) -> bool: ...
    class ExistingPropertyHandling(java.lang.Enum['LsaAddedPropertyFieldSaveRequest.ExistingPropertyHandling']):
        THROW: _py_ClassVar['LsaAddedPropertyFieldSaveRequest.ExistingPropertyHandling'] = ...
        REUSE_EXISTING_PROPERTY: _py_ClassVar['LsaAddedPropertyFieldSaveRequest.ExistingPropertyHandling'] = ...
        ASSERT_EXISTING_PROPERTY_MATCH: _py_ClassVar['LsaAddedPropertyFieldSaveRequest.ExistingPropertyHandling'] = ...
        UPDATE_EXISTING_PROPERTY: _py_ClassVar['LsaAddedPropertyFieldSaveRequest.ExistingPropertyHandling'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'LsaAddedPropertyFieldSaveRequest.ExistingPropertyHandling': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['LsaAddedPropertyFieldSaveRequest.ExistingPropertyHandling']: ...

class PropertyField(cern.lsa.domain.commons.IdentifiedEntity):
    @classmethod
    def builder(cls) -> 'DefaultPropertyField.Builder': ...
    def getDeviceTypeName(self) -> str: ...
    def getFieldName(self) -> str: ...
    def getPropertyName(self) -> str: ...

class PropertyFieldVersion(cern.accsoft.commons.util.Named):
    def getDescription(self) -> str: ...
    def getPropertyField(self) -> PropertyField: ...
    def getPropertyVersion(self) -> 'PropertyVersion': ...
    def getValueDescriptor(self) -> cern.accsoft.commons.value.ValueDescriptor: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    def isReadable(self) -> bool: ...
    def isWritable(self) -> bool: ...

class PropertyFields:
    @classmethod
    def buildPropertyFieldDisplayName(cls, string: str, string2: str) -> str: ...

class PropertyFieldsRequest:
    @classmethod
    def builder(cls) -> 'DefaultPropertyFieldsRequest.Builder': ...
    @classmethod
    def byDeviceTypeAndProperty(cls, string: str, string2: str) -> 'DefaultPropertyFieldsRequest': ...
    @classmethod
    def byDeviceTypeName(cls, string: str) -> 'DefaultPropertyFieldsRequest': ...
    @classmethod
    def byDeviceTypeNames(cls, collection: java.util.Collection[str]) -> 'DefaultPropertyFieldsRequest': ...
    @classmethod
    def byDeviceTypePropertyAndField(cls, string: str, string2: str, string3: str) -> 'DefaultPropertyFieldsRequest': ...
    def getDeviceTypeNames(self) -> java.util.Set[str]: ...
    def getFieldNames(self) -> java.util.Set[str]: ...
    def getPropertyNames(self) -> java.util.Set[str]: ...

class PropertyVersion(cern.accsoft.commons.util.Named):
    def getDescription(self) -> str: ...
    def getDeviceTypeVersion(self) -> cern.lsa.domain.devices.DeviceTypeVersion: ...
    def getFields(self) -> java.util.Set[PropertyFieldVersion]: ...
    def getPropertyVisibility(self) -> 'PropertyVersion.PropertyVisibility': ...
    def isCycleBound(self) -> bool: ...
    def isMonitorable(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isSupportingPartialSet(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWritable(self) -> bool: ...
    class PropertyVisibility(java.lang.Enum['PropertyVersion.PropertyVisibility']):
        OPERATIONAL: _py_ClassVar['PropertyVersion.PropertyVisibility'] = ...
        EXPERT: _py_ClassVar['PropertyVersion.PropertyVisibility'] = ...
        DEVELOPMENT: _py_ClassVar['PropertyVersion.PropertyVisibility'] = ...
        DEPRECATED: _py_ClassVar['PropertyVersion.PropertyVisibility'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'PropertyVersion.PropertyVisibility': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['PropertyVersion.PropertyVisibility']: ...

class PropertyVersionFilter(cern.accsoft.commons.util.Filters.Filter[PropertyVersion]):
    def __init__(self): ...
    @overload
    def accepts(self, propertyVersion: PropertyVersion) -> bool: ...
    @overload
    def accepts(self, object: _py_Any) -> bool: ...
    @classmethod
    def deviceType(cls, deviceType: cern.lsa.domain.devices.DeviceType) -> 'PropertyVersionFilter': ...
    @classmethod
    def deviceTypeIn(cls, collection: java.util.Collection[cern.lsa.domain.devices.DeviceType]) -> 'PropertyVersionFilter': ...
    @classmethod
    def deviceTypeName(cls, string: str) -> 'PropertyVersionFilter': ...
    @classmethod
    def deviceTypeNameIn(cls, collection: java.util.Collection[str]) -> 'PropertyVersionFilter': ...
    @classmethod
    def multiplexed(cls, boolean: bool) -> 'PropertyVersionFilter': ...
    @classmethod
    def propertyName(cls, string: str) -> 'PropertyVersionFilter': ...
    @classmethod
    def propertyNameIn(cls, collection: java.util.Collection[str]) -> 'PropertyVersionFilter': ...
    def setDeviceType(self, deviceType: cern.lsa.domain.devices.DeviceType) -> 'PropertyVersionFilter': ...
    def setDeviceTypeName(self, string: str) -> 'PropertyVersionFilter': ...
    def setDeviceTypeNames(self, collection: java.util.Collection[str]) -> 'PropertyVersionFilter': ...
    def setDeviceTypes(self, collection: java.util.Collection[cern.lsa.domain.devices.DeviceType]) -> 'PropertyVersionFilter': ...
    def setMultiplexed(self, boolean: bool) -> 'PropertyVersionFilter': ...
    def setPropertyName(self, string: str) -> 'PropertyVersionFilter': ...
    def setPropertyNames(self, collection: java.util.Collection[str]) -> 'PropertyVersionFilter': ...

class PropertyVersions:
    def __init__(self): ...
    @classmethod
    def findPropertyVersion(cls, string: str, sortedMap: java.util.SortedMap[cern.lsa.domain.devices.DeviceTypeVersion, java.util.Set[PropertyVersion]], device: cern.lsa.domain.devices.Device) -> PropertyVersion: ...
    @classmethod
    def isCycleDependent(cls, propertyVersion: PropertyVersion) -> bool: ...
    @classmethod
    def toDeviceTypeNamesMap(cls, set: java.util.Set[PropertyVersion]) -> java.util.Map[str, java.util.Set[PropertyVersion]]: ...
    @classmethod
    def toNamesMap(cls, map: java.util.Map[str, java.util.Set[PropertyVersion]]) -> java.util.Map[str, java.util.Map[str, PropertyVersion]]: ...

class PropertyVersionsRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.devices.factory.type.PropertyVersionsRequestBuilder: ...
    def getDeviceTypeNames(self) -> java.util.Set[str]: ...
    def getDeviceTypeVersions(self) -> java.util.Set[cern.lsa.domain.devices.DeviceTypeVersion]: ...
    def getPropertyNames(self) -> java.util.Set[str]: ...

class DefaultLsaAddedPropertyFieldSaveRequest(LsaAddedPropertyFieldSaveRequest, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
    @classmethod
    def copyOf(cls, lsaAddedPropertyFieldSaveRequest: LsaAddedPropertyFieldSaveRequest) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDescription(self) -> str: ...
    def getDeviceTypeName(self) -> str: ...
    def getExistingPropertyHandling(self) -> LsaAddedPropertyFieldSaveRequest.ExistingPropertyHandling: ...
    def getFieldAccess(self) -> cern.lsa.domain.devices.spi.type.PropertyFieldAccess: ...
    def getFieldMaxValue(self) -> float: ...
    def getFieldMinValue(self) -> float: ...
    def getFieldName(self) -> str: ...
    def getFieldUnit(self) -> str: ...
    def getFieldValueType(self) -> cern.accsoft.commons.value.Type: ...
    def getPropertyName(self) -> str: ...
    def getReasonForAdding(self) -> str: ...
    def hashCode(self) -> int: ...
    def isPropertyCycleBound(self) -> bool: ...
    def isPropertyMultiplexed(self) -> bool: ...
    def isPropertyReadable(self) -> bool: ...
    def isPropertyWritable(self) -> bool: ...
    def toString(self) -> str: ...
    def withDescription(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withDeviceTypeName(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withExistingPropertyHandling(self, existingPropertyHandling: LsaAddedPropertyFieldSaveRequest.ExistingPropertyHandling) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withFieldAccess(self, propertyFieldAccess: cern.lsa.domain.devices.spi.type.PropertyFieldAccess) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withFieldMaxValue(self, double: float) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withFieldMinValue(self, double: float) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withFieldName(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withFieldUnit(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withFieldValueType(self, type: cern.accsoft.commons.value.Type) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withPropertyCycleBound(self, boolean: bool) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withPropertyMultiplexed(self, boolean: bool) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withPropertyName(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withPropertyReadable(self, boolean: bool) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withPropertyWritable(self, boolean: bool) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    def withReasonForAdding(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
    class Builder:
        def build(self) -> 'DefaultLsaAddedPropertyFieldSaveRequest': ...
        def description(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def deviceTypeName(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def existingPropertyHandling(self, existingPropertyHandling: LsaAddedPropertyFieldSaveRequest.ExistingPropertyHandling) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def fieldAccess(self, propertyFieldAccess: cern.lsa.domain.devices.spi.type.PropertyFieldAccess) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def fieldMaxValue(self, double: float) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def fieldMinValue(self, double: float) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def fieldName(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def fieldUnit(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def fieldValueType(self, type: cern.accsoft.commons.value.Type) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def propertyCycleBound(self, boolean: bool) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def propertyMultiplexed(self, boolean: bool) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def propertyName(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def propertyReadable(self, boolean: bool) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def propertyWritable(self, boolean: bool) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...
        def reasonForAdding(self, string: str) -> 'DefaultLsaAddedPropertyFieldSaveRequest.Builder': ...

class DefaultPropertyField(PropertyField, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultPropertyField.Builder': ...
    @classmethod
    def copyOf(cls, propertyField: PropertyField) -> 'DefaultPropertyField': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDeviceTypeName(self) -> str: ...
    def getFieldName(self) -> str: ...
    def getId(self) -> int: ...
    def getPropertyName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withDeviceTypeName(self, string: str) -> 'DefaultPropertyField': ...
    def withFieldName(self, string: str) -> 'DefaultPropertyField': ...
    def withId(self, long: int) -> 'DefaultPropertyField': ...
    def withPropertyName(self, string: str) -> 'DefaultPropertyField': ...
    class Builder:
        def build(self) -> 'DefaultPropertyField': ...
        def deviceTypeName(self, string: str) -> 'DefaultPropertyField.Builder': ...
        def fieldName(self, string: str) -> 'DefaultPropertyField.Builder': ...
        def id(self, long: int) -> 'DefaultPropertyField.Builder': ...
        def propertyName(self, string: str) -> 'DefaultPropertyField.Builder': ...

class DefaultPropertyFieldsRequest(PropertyFieldsRequest, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultPropertyFieldsRequest.Builder': ...
    @classmethod
    def copyOf(cls, propertyFieldsRequest: PropertyFieldsRequest) -> 'DefaultPropertyFieldsRequest': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def getDeviceTypeNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getDeviceTypeNames(self) -> java.util.Set: ...
    @overload
    def getFieldNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getFieldNames(self) -> java.util.Set: ...
    @overload
    def getPropertyNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getPropertyNames(self) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def withDeviceTypeNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultPropertyFieldsRequest': ...
    @overload
    def withDeviceTypeNames(self, stringArray: _py_List[str]) -> 'DefaultPropertyFieldsRequest': ...
    @overload
    def withFieldNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultPropertyFieldsRequest': ...
    @overload
    def withFieldNames(self, stringArray: _py_List[str]) -> 'DefaultPropertyFieldsRequest': ...
    @overload
    def withPropertyNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultPropertyFieldsRequest': ...
    @overload
    def withPropertyNames(self, stringArray: _py_List[str]) -> 'DefaultPropertyFieldsRequest': ...
    class Builder:
        def addAllDeviceTypeNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultPropertyFieldsRequest.Builder': ...
        def addAllFieldNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultPropertyFieldsRequest.Builder': ...
        def addAllPropertyNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultPropertyFieldsRequest.Builder': ...
        def addDeviceTypeName(self, string: str) -> 'DefaultPropertyFieldsRequest.Builder': ...
        def addDeviceTypeNames(self, stringArray: _py_List[str]) -> 'DefaultPropertyFieldsRequest.Builder': ...
        def addFieldName(self, string: str) -> 'DefaultPropertyFieldsRequest.Builder': ...
        def addFieldNames(self, stringArray: _py_List[str]) -> 'DefaultPropertyFieldsRequest.Builder': ...
        def addPropertyName(self, string: str) -> 'DefaultPropertyFieldsRequest.Builder': ...
        def addPropertyNames(self, stringArray: _py_List[str]) -> 'DefaultPropertyFieldsRequest.Builder': ...
        def build(self) -> 'DefaultPropertyFieldsRequest': ...
        def deviceTypeNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultPropertyFieldsRequest.Builder': ...
        def fieldNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultPropertyFieldsRequest.Builder': ...
        def propertyNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultPropertyFieldsRequest.Builder': ...
