from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.util
import cern.lsa.domain.commons
import cern.lsa.domain.settings
import java.lang
import java.util


class LktimDevice(cern.accsoft.commons.util.Named):
    def getActiveTreeId(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> int: ...
    def getErrorMessages(self) -> java.util.Set[str]: ...
    def getParameters(self) -> java.util.List[cern.lsa.domain.settings.Parameter]: ...
    def getTime(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> float: ...
    def isEnabled(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> bool: ...
    def isPermitted(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> bool: ...
    def isValid(self) -> bool: ...
    def setActiveTreeId(self, contextSettings: cern.lsa.domain.settings.ContextSettings, long: int) -> None: ...
    def setEnabled(self, contextSettings: cern.lsa.domain.settings.ContextSettings, boolean: bool) -> None: ...
    def setPermitted(self, contextSettings: cern.lsa.domain.settings.ContextSettings, boolean: bool) -> None: ...
    def setTime(self, contextSettings: cern.lsa.domain.settings.ContextSettings, double: float) -> None: ...

class LktimTree(cern.lsa.domain.commons.IdentifiedEntity, cern.accsoft.commons.util.Named):
    def getErrorMessages(self) -> java.util.Set[str]: ...
    def getName(self) -> str: ...
    def getNode(self, string: str) -> 'LktimTreeNode': ...
    def getRoot(self) -> 'LktimTreeNode': ...
    def getStatusParameter(self) -> cern.lsa.domain.settings.Parameter: ...
    def getTime(self) -> java.util.Date: ...
    def isValid(self) -> bool: ...

class LktimTreeNode(cern.accsoft.commons.util.Named, java.lang.Comparable['LktimTreeNode']):
    @overload
    def addChild(self, lktimTreeNode: 'LktimTreeNode') -> None: ...
    @overload
    def addChild(self, int: int, lktimTreeNode: 'LktimTreeNode') -> None: ...
    def getChildCount(self) -> int: ...
    def getChildren(self) -> java.util.List['LktimTreeNode']: ...
    def getDescendants(self, boolean: bool) -> java.util.List['LktimTreeNode']: ...
    def getDescription(self) -> str: ...
    def getDeviceId(self) -> int: ...
    def getErrorMessages(self) -> java.util.Set[str]: ...
    def getLevel(self) -> int: ...
    def getLktimDevice(self) -> LktimDevice: ...
    def getName(self) -> str: ...
    def getParent(self) -> 'LktimTreeNode': ...
    def isValid(self) -> bool: ...
    def removeChild(self, lktimTreeNode: 'LktimTreeNode') -> None: ...
    def setDescription(self, string: str) -> None: ...

class LktimTreeSettings:
    def getActiveTreeId(self, lktimTreeNode: LktimTreeNode) -> int: ...
    def getContext(self) -> cern.lsa.domain.settings.StandAloneCycle: ...
    def getContextSettings(self) -> cern.lsa.domain.settings.ContextSettings: ...
    def getDelay(self, lktimTreeNode: LktimTreeNode) -> float: ...
    def getStatus(self) -> 'LktimTreeStatus': ...
    def getTime(self, lktimTreeNode: LktimTreeNode) -> float: ...
    def getTree(self) -> LktimTree: ...
    def isEnabled(self, lktimTreeNode: LktimTreeNode) -> bool: ...
    def isPermitted(self, lktimTreeNode: LktimTreeNode) -> bool: ...
    def setActive(self, boolean: bool) -> None: ...
    def setDelay(self, lktimTreeNode: LktimTreeNode, double: float) -> None: ...
    def setEnabled(self, lktimTreeNode: LktimTreeNode, boolean: bool) -> None: ...
    def setPermitted(self, lktimTreeNode: LktimTreeNode, boolean: bool) -> None: ...
    def statusHasChanged(self) -> bool: ...

class LktimTreeStatus(java.lang.Enum['LktimTreeStatus']):
    IN_USE: _py_ClassVar['LktimTreeStatus'] = ...
    NOT_IN_USE: _py_ClassVar['LktimTreeStatus'] = ...
    NOT_USABLE: _py_ClassVar['LktimTreeStatus'] = ...
    ERROR: _py_ClassVar['LktimTreeStatus'] = ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'LktimTreeStatus': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['LktimTreeStatus']: ...

class NodeAdditionCheckResult(java.lang.Enum['NodeAdditionCheckResult']):
    OK: _py_ClassVar['NodeAdditionCheckResult'] = ...
    DEVICE_ALREADY_IN_THE_TREE: _py_ClassVar['NodeAdditionCheckResult'] = ...
    CANNOT_ADD_TO_HISTORICAL_TREE: _py_ClassVar['NodeAdditionCheckResult'] = ...
    UNSUPPORTED_DEVICE: _py_ClassVar['NodeAdditionCheckResult'] = ...
    DEVICE_BELONGS_TO_ACTIVE_TREE: _py_ClassVar['NodeAdditionCheckResult'] = ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'NodeAdditionCheckResult': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['NodeAdditionCheckResult']: ...
