from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.util
import cern.lsa.domain.cern.timing
import cern.lsa.domain.commons
import java.lang
import java.util


class AdCycleSegment(cern.accsoft.commons.util.Named):
    def addTimingProcess(self, timingProcess: cern.lsa.domain.cern.timing.TimingProcess, int: int, timingProcessAnchor: cern.lsa.domain.cern.timing.TimingProcessAnchor) -> None: ...
    def getAttribute(self, string: str) -> str: ...
    def getAttributeNames(self) -> java.util.Set[str]: ...
    def getEndMomentum(self) -> int: ...
    def getInitialMomentum(self) -> int: ...
    def getLength(self) -> int: ...
    def getScheduledTimingProcesses(self) -> java.util.Set[cern.lsa.domain.cern.timing.TimingProcessScheduling]: ...
    def getStartTime(self) -> int: ...
    def getType(self) -> 'SegmentType': ...
    def isFirstSegmentInCycle(self) -> bool: ...
    def nextSegment(self) -> 'AdCycleSegment': ...
    def previousSegment(self) -> 'AdCycleSegment': ...
    def removeAttribute(self, string: str) -> None: ...
    def removeTimingProcess(self, timingProcess: cern.lsa.domain.cern.timing.TimingProcess) -> None: ...
    def setAttribute(self, string: str, string2: str) -> None: ...
    def setLength(self, int: int) -> None: ...
    def setName(self, string: str) -> None: ...

class AdCycleStructure(cern.lsa.domain.commons.IdentifiedEntity):
    def getId(self) -> int: ...
    def getLength(self) -> int: ...
    def getSegment(self, int: int) -> AdCycleSegment: ...
    def getSegments(self) -> java.util.List[AdCycleSegment]: ...
    def getSegmentsCount(self) -> int: ...
    def getVersion(self) -> int: ...
    def insertFlatSegment(self, rampSegment: 'RampSegment', int: int) -> 'FlatSegment': ...
    def isTestCycle(self) -> bool: ...
    def removeFlatSegment(self, flatSegment: 'FlatSegment') -> None: ...

class PauseLocation(java.lang.Enum['PauseLocation']):
    NONE: _py_ClassVar['PauseLocation'] = ...
    BEFORE_START: _py_ClassVar['PauseLocation'] = ...
    BEFORE_END: _py_ClassVar['PauseLocation'] = ...
    AFTER_END: _py_ClassVar['PauseLocation'] = ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'PauseLocation': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['PauseLocation']: ...

class SegmentAttribute(java.lang.Enum['SegmentAttribute']):
    ELTAG: _py_ClassVar['SegmentAttribute'] = ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'SegmentAttribute': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['SegmentAttribute']: ...

class SegmentType(java.lang.Enum['SegmentType']):
    RAMP: _py_ClassVar['SegmentType'] = ...
    FLAT: _py_ClassVar['SegmentType'] = ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'SegmentType': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['SegmentType']: ...

class FlatSegment(AdCycleSegment):
    def getNumberOfExtractions(self) -> int: ...
    def getNumberOfInjections(self) -> int: ...
    def getPauseLocation(self) -> PauseLocation: ...
    def setNumberOfExtractions(self, int: int) -> None: ...
    def setNumberOfInjections(self, int: int) -> None: ...
    def setPauseLocation(self, pauseLocation: PauseLocation) -> None: ...

class RampSegment(AdCycleSegment):
    def getFlatPartLength(self) -> int: ...
    def getRoundPartLength(self) -> int: ...
    def setEndMomentum(self, int: int) -> None: ...
    def setFlatPartLength(self, int: int) -> None: ...
    def setRoundPartLength(self, int: int) -> None: ...
